// { dg-options "-D__STDCPP_WANT_MATH_SPEC_FUNCS__ -ffp-contract=off" }

// Copyright (C) 2016 Free Software Foundation, Inc.
//
// This file is part of the GNU ISO C++ Library.  This library is free
// software; you can redistribute it and/or modify it under the
// terms of the GNU General Public License as published by the
// Free Software Foundation; either version 3, or (at your option)
// any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License along
// with this library; see the file COPYING3.  If not see
// <http://www.gnu.org/licenses/>.

//  assoc_legendre
//  Compare against values generated by the GNU Scientific Library.
//  The GSL can be found on the web: http://www.gnu.org/software/gsl/
#include <limits>
#include <cmath>
#if defined(__TEST_DEBUG)
#  include <iostream>
#  define VERIFY(A) \
  if (!(A)) \
    { \
      std::cout << "line " << __LINE__ \
	<< "  max_abs_frac = " << max_abs_frac \
	<< std::endl; \
    }
#else
#  include <testsuite_hooks.h>
#endif
#include <specfun_testcase.h>


// Test data for l=0, m=0.
// max(|f - f_GSL|): 0.0000000000000000
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
const testcase_assoc_legendre<double>
data001[21] =
{
  { 1.0000000000000000, 0, 0, 
	  -1.0000000000000000 },
  { 1.0000000000000000, 0, 0, 
	  -0.90000000000000002 },
  { 1.0000000000000000, 0, 0, 
	  -0.80000000000000004 },
  { 1.0000000000000000, 0, 0, 
	  -0.69999999999999996 },
  { 1.0000000000000000, 0, 0, 
	  -0.59999999999999998 },
  { 1.0000000000000000, 0, 0, 
	  -0.50000000000000000 },
  { 1.0000000000000000, 0, 0, 
	  -0.40000000000000002 },
  { 1.0000000000000000, 0, 0, 
	  -0.30000000000000004 },
  { 1.0000000000000000, 0, 0, 
	  -0.19999999999999996 },
  { 1.0000000000000000, 0, 0, 
	  -0.099999999999999978 },
  { 1.0000000000000000, 0, 0, 
	  0.0000000000000000 },
  { 1.0000000000000000, 0, 0, 
	  0.10000000000000009 },
  { 1.0000000000000000, 0, 0, 
	  0.19999999999999996 },
  { 1.0000000000000000, 0, 0, 
	  0.30000000000000004 },
  { 1.0000000000000000, 0, 0, 
	  0.39999999999999991 },
  { 1.0000000000000000, 0, 0, 
	  0.50000000000000000 },
  { 1.0000000000000000, 0, 0, 
	  0.60000000000000009 },
  { 1.0000000000000000, 0, 0, 
	  0.69999999999999996 },
  { 1.0000000000000000, 0, 0, 
	  0.80000000000000004 },
  { 1.0000000000000000, 0, 0, 
	  0.89999999999999991 },
  { 1.0000000000000000, 0, 0, 
	  1.0000000000000000 },
};
const double toler001 = 2.5000000000000020e-13;

// Test data for l=1, m=0.
// max(|f - f_GSL|): 0.0000000000000000
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
const testcase_assoc_legendre<double>
data002[21] =
{
  { -1.0000000000000000, 1, 0, 
	  -1.0000000000000000 },
  { -0.90000000000000002, 1, 0, 
	  -0.90000000000000002 },
  { -0.80000000000000004, 1, 0, 
	  -0.80000000000000004 },
  { -0.69999999999999996, 1, 0, 
	  -0.69999999999999996 },
  { -0.59999999999999998, 1, 0, 
	  -0.59999999999999998 },
  { -0.50000000000000000, 1, 0, 
	  -0.50000000000000000 },
  { -0.40000000000000002, 1, 0, 
	  -0.40000000000000002 },
  { -0.30000000000000004, 1, 0, 
	  -0.30000000000000004 },
  { -0.19999999999999996, 1, 0, 
	  -0.19999999999999996 },
  { -0.099999999999999978, 1, 0, 
	  -0.099999999999999978 },
  { 0.0000000000000000, 1, 0, 
	  0.0000000000000000 },
  { 0.10000000000000009, 1, 0, 
	  0.10000000000000009 },
  { 0.19999999999999996, 1, 0, 
	  0.19999999999999996 },
  { 0.30000000000000004, 1, 0, 
	  0.30000000000000004 },
  { 0.39999999999999991, 1, 0, 
	  0.39999999999999991 },
  { 0.50000000000000000, 1, 0, 
	  0.50000000000000000 },
  { 0.60000000000000009, 1, 0, 
	  0.60000000000000009 },
  { 0.69999999999999996, 1, 0, 
	  0.69999999999999996 },
  { 0.80000000000000004, 1, 0, 
	  0.80000000000000004 },
  { 0.89999999999999991, 1, 0, 
	  0.89999999999999991 },
  { 1.0000000000000000, 1, 0, 
	  1.0000000000000000 },
};
const double toler002 = 2.5000000000000020e-13;

// Test data for l=1, m=1.
// max(|f - f_GSL|): 0.0000000000000000
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
const testcase_assoc_legendre<double>
data003[21] =
{
  { -0.0000000000000000, 1, 1, 
	  -1.0000000000000000 },
  { -0.43588989435406728, 1, 1, 
	  -0.90000000000000002 },
  { -0.59999999999999987, 1, 1, 
	  -0.80000000000000004 },
  { -0.71414284285428509, 1, 1, 
	  -0.69999999999999996 },
  { -0.80000000000000004, 1, 1, 
	  -0.59999999999999998 },
  { -0.86602540378443860, 1, 1, 
	  -0.50000000000000000 },
  { -0.91651513899116799, 1, 1, 
	  -0.40000000000000002 },
  { -0.95393920141694577, 1, 1, 
	  -0.30000000000000004 },
  { -0.97979589711327120, 1, 1, 
	  -0.19999999999999996 },
  { -0.99498743710661997, 1, 1, 
	  -0.099999999999999978 },
  { -1.0000000000000000, 1, 1, 
	  0.0000000000000000 },
  { -0.99498743710661997, 1, 1, 
	  0.10000000000000009 },
  { -0.97979589711327120, 1, 1, 
	  0.19999999999999996 },
  { -0.95393920141694577, 1, 1, 
	  0.30000000000000004 },
  { -0.91651513899116799, 1, 1, 
	  0.39999999999999991 },
  { -0.86602540378443860, 1, 1, 
	  0.50000000000000000 },
  { -0.79999999999999993, 1, 1, 
	  0.60000000000000009 },
  { -0.71414284285428509, 1, 1, 
	  0.69999999999999996 },
  { -0.59999999999999987, 1, 1, 
	  0.80000000000000004 },
  { -0.43588989435406750, 1, 1, 
	  0.89999999999999991 },
  { -0.0000000000000000, 1, 1, 
	  1.0000000000000000 },
};
const double toler003 = 2.5000000000000020e-13;

// Test data for l=2, m=0.
// max(|f - f_GSL|): 1.1102230246251565e-16
// max(|f - f_GSL| / |f_GSL|): 1.3877787807814482e-15
const testcase_assoc_legendre<double>
data004[21] =
{
  { 1.0000000000000000, 2, 0, 
	  -1.0000000000000000 },
  { 0.71500000000000008, 2, 0, 
	  -0.90000000000000002 },
  { 0.46000000000000019, 2, 0, 
	  -0.80000000000000004 },
  { 0.23499999999999988, 2, 0, 
	  -0.69999999999999996 },
  { 0.039999999999999925, 2, 0, 
	  -0.59999999999999998 },
  { -0.12500000000000000, 2, 0, 
	  -0.50000000000000000 },
  { -0.25999999999999995, 2, 0, 
	  -0.40000000000000002 },
  { -0.36499999999999999, 2, 0, 
	  -0.30000000000000004 },
  { -0.44000000000000006, 2, 0, 
	  -0.19999999999999996 },
  { -0.48499999999999999, 2, 0, 
	  -0.099999999999999978 },
  { -0.50000000000000000, 2, 0, 
	  0.0000000000000000 },
  { -0.48499999999999999, 2, 0, 
	  0.10000000000000009 },
  { -0.44000000000000006, 2, 0, 
	  0.19999999999999996 },
  { -0.36499999999999999, 2, 0, 
	  0.30000000000000004 },
  { -0.26000000000000012, 2, 0, 
	  0.39999999999999991 },
  { -0.12500000000000000, 2, 0, 
	  0.50000000000000000 },
  { 0.040000000000000147, 2, 0, 
	  0.60000000000000009 },
  { 0.23499999999999988, 2, 0, 
	  0.69999999999999996 },
  { 0.46000000000000019, 2, 0, 
	  0.80000000000000004 },
  { 0.71499999999999986, 2, 0, 
	  0.89999999999999991 },
  { 1.0000000000000000, 2, 0, 
	  1.0000000000000000 },
};
const double toler004 = 2.5000000000000020e-13;

// Test data for l=2, m=1.
// max(|f - f_GSL|): 0.0000000000000000
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
const testcase_assoc_legendre<double>
data005[21] =
{
  { 0.0000000000000000, 2, 1, 
	  -1.0000000000000000 },
  { 1.1769027147559816, 2, 1, 
	  -0.90000000000000002 },
  { 1.4399999999999999, 2, 1, 
	  -0.80000000000000004 },
  { 1.4996999699939983, 2, 1, 
	  -0.69999999999999996 },
  { 1.4399999999999999, 2, 1, 
	  -0.59999999999999998 },
  { 1.2990381056766580, 2, 1, 
	  -0.50000000000000000 },
  { 1.0998181667894018, 2, 1, 
	  -0.40000000000000002 },
  { 0.85854528127525132, 2, 1, 
	  -0.30000000000000004 },
  { 0.58787753826796263, 2, 1, 
	  -0.19999999999999996 },
  { 0.29849623113198592, 2, 1, 
	  -0.099999999999999978 },
  { -0.0000000000000000, 2, 1, 
	  0.0000000000000000 },
  { -0.29849623113198626, 2, 1, 
	  0.10000000000000009 },
  { -0.58787753826796263, 2, 1, 
	  0.19999999999999996 },
  { -0.85854528127525132, 2, 1, 
	  0.30000000000000004 },
  { -1.0998181667894014, 2, 1, 
	  0.39999999999999991 },
  { -1.2990381056766580, 2, 1, 
	  0.50000000000000000 },
  { -1.4400000000000002, 2, 1, 
	  0.60000000000000009 },
  { -1.4996999699939983, 2, 1, 
	  0.69999999999999996 },
  { -1.4399999999999999, 2, 1, 
	  0.80000000000000004 },
  { -1.1769027147559821, 2, 1, 
	  0.89999999999999991 },
  { -0.0000000000000000, 2, 1, 
	  1.0000000000000000 },
};
const double toler005 = 2.5000000000000020e-13;

// Test data for l=2, m=2.
// max(|f - f_GSL|): 0.0000000000000000
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
const testcase_assoc_legendre<double>
data006[21] =
{
  { 0.0000000000000000, 2, 2, 
	  -1.0000000000000000 },
  { 0.56999999999999984, 2, 2, 
	  -0.90000000000000002 },
  { 1.0799999999999996, 2, 2, 
	  -0.80000000000000004 },
  { 1.5300000000000005, 2, 2, 
	  -0.69999999999999996 },
  { 1.9200000000000004, 2, 2, 
	  -0.59999999999999998 },
  { 2.2500000000000000, 2, 2, 
	  -0.50000000000000000 },
  { 2.5200000000000000, 2, 2, 
	  -0.40000000000000002 },
  { 2.7300000000000004, 2, 2, 
	  -0.30000000000000004 },
  { 2.8799999999999999, 2, 2, 
	  -0.19999999999999996 },
  { 2.9700000000000002, 2, 2, 
	  -0.099999999999999978 },
  { 3.0000000000000000, 2, 2, 
	  0.0000000000000000 },
  { 2.9700000000000002, 2, 2, 
	  0.10000000000000009 },
  { 2.8799999999999999, 2, 2, 
	  0.19999999999999996 },
  { 2.7300000000000004, 2, 2, 
	  0.30000000000000004 },
  { 2.5200000000000000, 2, 2, 
	  0.39999999999999991 },
  { 2.2500000000000000, 2, 2, 
	  0.50000000000000000 },
  { 1.9199999999999997, 2, 2, 
	  0.60000000000000009 },
  { 1.5300000000000005, 2, 2, 
	  0.69999999999999996 },
  { 1.0799999999999996, 2, 2, 
	  0.80000000000000004 },
  { 0.57000000000000040, 2, 2, 
	  0.89999999999999991 },
  { 0.0000000000000000, 2, 2, 
	  1.0000000000000000 },
};
const double toler006 = 2.5000000000000020e-13;

// Test data for l=5, m=0.
// max(|f - f_GSL|): 2.0122792321330962e-16
// max(|f - f_GSL| / |f_GSL|): 4.8911475274404243e-15
const testcase_assoc_legendre<double>
data007[21] =
{
  { -1.0000000000000000, 5, 0, 
	  -1.0000000000000000 },
  { 0.041141250000000087, 5, 0, 
	  -0.90000000000000002 },
  { 0.39951999999999993, 5, 0, 
	  -0.80000000000000004 },
  { 0.36519874999999991, 5, 0, 
	  -0.69999999999999996 },
  { 0.15263999999999994, 5, 0, 
	  -0.59999999999999998 },
  { -0.089843750000000000, 5, 0, 
	  -0.50000000000000000 },
  { -0.27063999999999994, 5, 0, 
	  -0.40000000000000002 },
  { -0.34538625000000001, 5, 0, 
	  -0.30000000000000004 },
  { -0.30751999999999996, 5, 0, 
	  -0.19999999999999996 },
  { -0.17882874999999995, 5, 0, 
	  -0.099999999999999978 },
  { 0.0000000000000000, 5, 0, 
	  0.0000000000000000 },
  { 0.17882875000000015, 5, 0, 
	  0.10000000000000009 },
  { 0.30751999999999996, 5, 0, 
	  0.19999999999999996 },
  { 0.34538625000000001, 5, 0, 
	  0.30000000000000004 },
  { 0.27064000000000010, 5, 0, 
	  0.39999999999999991 },
  { 0.089843750000000000, 5, 0, 
	  0.50000000000000000 },
  { -0.15264000000000016, 5, 0, 
	  0.60000000000000009 },
  { -0.36519874999999991, 5, 0, 
	  0.69999999999999996 },
  { -0.39951999999999993, 5, 0, 
	  0.80000000000000004 },
  { -0.041141250000000261, 5, 0, 
	  0.89999999999999991 },
  { 1.0000000000000000, 5, 0, 
	  1.0000000000000000 },
};
const double toler007 = 2.5000000000000020e-13;

// Test data for l=5, m=1.
// max(|f - f_GSL|): 0.0000000000000000
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
const testcase_assoc_legendre<double>
data008[21] =
{
  { 0.0000000000000000, 5, 1, 
	  -1.0000000000000000 },
  { -2.8099369608350981, 5, 1, 
	  -0.90000000000000002 },
  { -0.72180000000000089, 5, 1, 
	  -0.80000000000000004 },
  { 1.0951826834447254, 5, 1, 
	  -0.69999999999999996 },
  { 1.9775999999999998, 5, 1, 
	  -0.59999999999999998 },
  { 1.9282596881137892, 5, 1, 
	  -0.50000000000000000 },
  { 1.2070504380513685, 5, 1, 
	  -0.40000000000000002 },
  { 0.16079837663884422, 5, 1, 
	  -0.30000000000000004 },
  { -0.87005875663658538, 5, 1, 
	  -0.19999999999999996 },
  { -1.6083350053680323, 5, 1, 
	  -0.099999999999999978 },
  { -1.8750000000000000, 5, 1, 
	  0.0000000000000000 },
  { -1.6083350053680314, 5, 1, 
	  0.10000000000000009 },
  { -0.87005875663658538, 5, 1, 
	  0.19999999999999996 },
  { 0.16079837663884422, 5, 1, 
	  0.30000000000000004 },
  { 1.2070504380513671, 5, 1, 
	  0.39999999999999991 },
  { 1.9282596881137892, 5, 1, 
	  0.50000000000000000 },
  { 1.9775999999999998, 5, 1, 
	  0.60000000000000009 },
  { 1.0951826834447254, 5, 1, 
	  0.69999999999999996 },
  { -0.72180000000000089, 5, 1, 
	  0.80000000000000004 },
  { -2.8099369608350973, 5, 1, 
	  0.89999999999999991 },
  { 0.0000000000000000, 5, 1, 
	  1.0000000000000000 },
};
const double toler008 = 2.5000000000000020e-13;

// Test data for l=5, m=2.
// max(|f - f_GSL|): 0.0000000000000000
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
const testcase_assoc_legendre<double>
data009[21] =
{
  { 0.0000000000000000, 5, 2, 
	  -1.0000000000000000 },
  { -12.837825000000000, 5, 2, 
	  -0.90000000000000002 },
  { -13.910400000000001, 5, 2, 
	  -0.80000000000000004 },
  { -8.8089749999999967, 5, 2, 
	  -0.69999999999999996 },
  { -1.6128000000000000, 5, 2, 
	  -0.59999999999999998 },
  { 4.9218750000000000, 5, 2, 
	  -0.50000000000000000 },
  { 9.1728000000000005, 5, 2, 
	  -0.40000000000000002 },
  { 10.462725000000001, 5, 2, 
	  -0.30000000000000004 },
  { 8.8703999999999983, 5, 2, 
	  -0.19999999999999996 },
  { 5.0415749999999990, 5, 2, 
	  -0.099999999999999978 },
  { -0.0000000000000000, 5, 2, 
	  0.0000000000000000 },
  { -5.0415750000000044, 5, 2, 
	  0.10000000000000009 },
  { -8.8703999999999983, 5, 2, 
	  0.19999999999999996 },
  { -10.462725000000001, 5, 2, 
	  0.30000000000000004 },
  { -9.1728000000000005, 5, 2, 
	  0.39999999999999991 },
  { -4.9218750000000000, 5, 2, 
	  0.50000000000000000 },
  { 1.6128000000000047, 5, 2, 
	  0.60000000000000009 },
  { 8.8089749999999967, 5, 2, 
	  0.69999999999999996 },
  { 13.910400000000001, 5, 2, 
	  0.80000000000000004 },
  { 12.837825000000004, 5, 2, 
	  0.89999999999999991 },
  { 0.0000000000000000, 5, 2, 
	  1.0000000000000000 },
};
const double toler009 = 2.5000000000000020e-13;

// Test data for l=5, m=5.
// max(|f - f_GSL|): 0.0000000000000000
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
const testcase_assoc_legendre<double>
data010[21] =
{
  { -0.0000000000000000, 5, 5, 
	  -1.0000000000000000 },
  { -14.870165800941818, 5, 5, 
	  -0.90000000000000002 },
  { -73.483199999999925, 5, 5, 
	  -0.80000000000000004 },
  { -175.53238298794764, 5, 5, 
	  -0.69999999999999996 },
  { -309.65760000000006, 5, 5, 
	  -0.59999999999999998 },
  { -460.34662869916559, 5, 5, 
	  -0.50000000000000000 },
  { -611.12496255819883, 5, 5, 
	  -0.40000000000000002 },
  { -746.50941479523760, 5, 5, 
	  -0.30000000000000004 },
  { -853.31600434671316, 5, 5, 
	  -0.19999999999999996 },
  { -921.55189181724734, 5, 5, 
	  -0.099999999999999978 },
  { -945.00000000000000, 5, 5, 
	  0.0000000000000000 },
  { -921.55189181724734, 5, 5, 
	  0.10000000000000009 },
  { -853.31600434671316, 5, 5, 
	  0.19999999999999996 },
  { -746.50941479523760, 5, 5, 
	  0.30000000000000004 },
  { -611.12496255819883, 5, 5, 
	  0.39999999999999991 },
  { -460.34662869916559, 5, 5, 
	  0.50000000000000000 },
  { -309.65759999999989, 5, 5, 
	  0.60000000000000009 },
  { -175.53238298794764, 5, 5, 
	  0.69999999999999996 },
  { -73.483199999999925, 5, 5, 
	  0.80000000000000004 },
  { -14.870165800941855, 5, 5, 
	  0.89999999999999991 },
  { -0.0000000000000000, 5, 5, 
	  1.0000000000000000 },
};
const double toler010 = 2.5000000000000020e-13;

// Test data for l=10, m=0.
// max(|f - f_GSL|): 2.7755575615628914e-16
// max(|f - f_GSL| / |f_GSL|): 1.0547610802636413e-15
const testcase_assoc_legendre<double>
data011[21] =
{
  { 1.0000000000000000, 10, 0, 
	  -1.0000000000000000 },
  { -0.26314561785585960, 10, 0, 
	  -0.90000000000000002 },
  { 0.30052979560000004, 10, 0, 
	  -0.80000000000000004 },
  { 0.085805795531640333, 10, 0, 
	  -0.69999999999999996 },
  { -0.24366274560000001, 10, 0, 
	  -0.59999999999999998 },
  { -0.18822860717773438, 10, 0, 
	  -0.50000000000000000 },
  { 0.096839064399999925, 10, 0, 
	  -0.40000000000000002 },
  { 0.25147634951601561, 10, 0, 
	  -0.30000000000000004 },
  { 0.12907202559999983, 10, 0, 
	  -0.19999999999999996 },
  { -0.12212499738710943, 10, 0, 
	  -0.099999999999999978 },
  { -0.24609375000000000, 10, 0, 
	  0.0000000000000000 },
  { -0.12212499738710922, 10, 0, 
	  0.10000000000000009 },
  { 0.12907202559999983, 10, 0, 
	  0.19999999999999996 },
  { 0.25147634951601561, 10, 0, 
	  0.30000000000000004 },
  { 0.096839064400000258, 10, 0, 
	  0.39999999999999991 },
  { -0.18822860717773438, 10, 0, 
	  0.50000000000000000 },
  { -0.24366274559999984, 10, 0, 
	  0.60000000000000009 },
  { 0.085805795531640333, 10, 0, 
	  0.69999999999999996 },
  { 0.30052979560000004, 10, 0, 
	  0.80000000000000004 },
  { -0.26314561785585899, 10, 0, 
	  0.89999999999999991 },
  { 1.0000000000000000, 10, 0, 
	  1.0000000000000000 },
};
const double toler011 = 2.5000000000000020e-13;

// Test data for l=10, m=1.
// max(|f - f_GSL|): 0.0000000000000000
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
const testcase_assoc_legendre<double>
data012[21] =
{
  { -0.0000000000000000, 10, 1, 
	  -1.0000000000000000 },
  { -3.0438748781479039, 10, 1, 
	  -0.90000000000000002 },
  { -0.87614260800000254, 10, 1, 
	  -0.80000000000000004 },
  { 2.9685359952934527, 10, 1, 
	  -0.69999999999999996 },
  { 1.2511825919999997, 10, 1, 
	  -0.59999999999999998 },
  { -2.0066877394361260, 10, 1, 
	  -0.50000000000000000 },
  { -2.4822196173476661, 10, 1, 
	  -0.40000000000000002 },
  { -0.12309508907433910, 10, 1, 
	  -0.30000000000000004 },
  { 2.2468221751958413, 10, 1, 
	  -0.19999999999999996 },
  { 2.2472659777983512, 10, 1, 
	  -0.099999999999999978 },
  { -0.0000000000000000, 10, 1, 
	  0.0000000000000000 },
  { -2.2472659777983535, 10, 1, 
	  0.10000000000000009 },
  { -2.2468221751958413, 10, 1, 
	  0.19999999999999996 },
  { 0.12309508907433910, 10, 1, 
	  0.30000000000000004 },
  { 2.4822196173476647, 10, 1, 
	  0.39999999999999991 },
  { 2.0066877394361260, 10, 1, 
	  0.50000000000000000 },
  { -1.2511825920000037, 10, 1, 
	  0.60000000000000009 },
  { -2.9685359952934527, 10, 1, 
	  0.69999999999999996 },
  { 0.87614260800000254, 10, 1, 
	  0.80000000000000004 },
  { 3.0438748781479115, 10, 1, 
	  0.89999999999999991 },
  { 0.0000000000000000, 10, 1, 
	  1.0000000000000000 },
};
const double toler012 = 2.5000000000000020e-13;

// Test data for l=10, m=2.
// max(|f - f_GSL|): 0.0000000000000000
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
const testcase_assoc_legendre<double>
data013[21] =
{
  { 0.0000000000000000, 10, 2, 
	  -1.0000000000000000 },
  { 16.376387762496137, 10, 2, 
	  -0.90000000000000002 },
  { -35.394657804000005, 10, 2, 
	  -0.80000000000000004 },
  { -3.6191429423788648, 10, 2, 
	  -0.69999999999999996 },
  { 28.679675904000014, 10, 2, 
	  -0.59999999999999998 },
  { 18.388023376464844, 10, 2, 
	  -0.50000000000000000 },
  { -12.818955995999994, 10, 2, 
	  -0.40000000000000002 },
  { -27.739821675972664, 10, 2, 
	  -0.30000000000000004 },
  { -13.280661503999987, 10, 2, 
	  -0.19999999999999996 },
  { 13.885467170308601, 10, 2, 
	  -0.099999999999999978 },
  { 27.070312500000000, 10, 2, 
	  0.0000000000000000 },
  { 13.885467170308573, 10, 2, 
	  0.10000000000000009 },
  { -13.280661503999987, 10, 2, 
	  0.19999999999999996 },
  { -27.739821675972664, 10, 2, 
	  0.30000000000000004 },
  { -12.818955996000021, 10, 2, 
	  0.39999999999999991 },
  { 18.388023376464844, 10, 2, 
	  0.50000000000000000 },
  { 28.679675904000000, 10, 2, 
	  0.60000000000000009 },
  { -3.6191429423788648, 10, 2, 
	  0.69999999999999996 },
  { -35.394657804000005, 10, 2, 
	  0.80000000000000004 },
  { 16.376387762496009, 10, 2, 
	  0.89999999999999991 },
  { 0.0000000000000000, 10, 2, 
	  1.0000000000000000 },
};
const double toler013 = 2.5000000000000020e-13;

// Test data for l=10, m=5.
// max(|f - f_GSL|): 0.0000000000000000
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
const testcase_assoc_legendre<double>
data014[21] =
{
  { 0.0000000000000000, 10, 5, 
	  -1.0000000000000000 },
  { 21343.618518164680, 10, 5, 
	  -0.90000000000000002 },
  { 40457.016407807983, 10, 5, 
	  -0.80000000000000004 },
  { 20321.279317331315, 10, 5, 
	  -0.69999999999999996 },
  { -14410.820616192004, 10, 5, 
	  -0.59999999999999998 },
  { -30086.169706116176, 10, 5, 
	  -0.50000000000000000 },
  { -17177.549337582859, 10, 5, 
	  -0.40000000000000002 },
  { 9272.5119495412364, 10, 5, 
	  -0.30000000000000004 },
  { 26591.511184414714, 10, 5, 
	  -0.19999999999999996 },
  { 21961.951238504211, 10, 5, 
	  -0.099999999999999978 },
  { -0.0000000000000000, 10, 5, 
	  0.0000000000000000 },
  { -21961.951238504229, 10, 5, 
	  0.10000000000000009 },
  { -26591.511184414714, 10, 5, 
	  0.19999999999999996 },
  { -9272.5119495412364, 10, 5, 
	  0.30000000000000004 },
  { 17177.549337582834, 10, 5, 
	  0.39999999999999991 },
  { 30086.169706116176, 10, 5, 
	  0.50000000000000000 },
  { 14410.820616191972, 10, 5, 
	  0.60000000000000009 },
  { -20321.279317331315, 10, 5, 
	  0.69999999999999996 },
  { -40457.016407807983, 10, 5, 
	  0.80000000000000004 },
  { -21343.618518164694, 10, 5, 
	  0.89999999999999991 },
  { 0.0000000000000000, 10, 5, 
	  1.0000000000000000 },
};
const double toler014 = 2.5000000000000020e-13;

// Test data for l=10, m=10.
// max(|f - f_GSL|): 0.0000000000000000
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
const testcase_assoc_legendre<double>
data015[21] =
{
  { 0.0000000000000000, 10, 10, 
	  -1.0000000000000000 },
  { 162117.40078784220, 10, 10, 
	  -0.90000000000000002 },
  { 3958896.3481267113, 10, 10, 
	  -0.80000000000000004 },
  { 22589806.343887307, 10, 10, 
	  -0.69999999999999996 },
  { 70300999.121633321, 10, 10, 
	  -0.59999999999999998 },
  { 155370278.54003900, 10, 10, 
	  -0.50000000000000000 },
  { 273815518.20150518, 10, 10, 
	  -0.40000000000000002 },
  { 408571989.13158917, 10, 10, 
	  -0.30000000000000004 },
  { 533848212.07990247, 10, 10, 
	  -0.19999999999999996 },
  { 622640835.70523083, 10, 10, 
	  -0.099999999999999978 },
  { 654729075.00000000, 10, 10, 
	  0.0000000000000000 },
  { 622640835.70523083, 10, 10, 
	  0.10000000000000009 },
  { 533848212.07990247, 10, 10, 
	  0.19999999999999996 },
  { 408571989.13158917, 10, 10, 
	  0.30000000000000004 },
  { 273815518.20150518, 10, 10, 
	  0.39999999999999991 },
  { 155370278.54003900, 10, 10, 
	  0.50000000000000000 },
  { 70300999.121633217, 10, 10, 
	  0.60000000000000009 },
  { 22589806.343887307, 10, 10, 
	  0.69999999999999996 },
  { 3958896.3481267113, 10, 10, 
	  0.80000000000000004 },
  { 162117.40078784304, 10, 10, 
	  0.89999999999999991 },
  { 0.0000000000000000, 10, 10, 
	  1.0000000000000000 },
};
const double toler015 = 2.5000000000000020e-13;

// Test data for l=20, m=0.
// max(|f - f_GSL|): 3.3306690738754696e-16
// max(|f - f_GSL| / |f_GSL|): 2.2307336678138069e-15
const testcase_assoc_legendre<double>
data016[21] =
{
  { 1.0000000000000000, 20, 0, 
	  -1.0000000000000000 },
  { -0.14930823530984835, 20, 0, 
	  -0.90000000000000002 },
  { 0.22420460541741347, 20, 0, 
	  -0.80000000000000004 },
  { -0.20457394463834172, 20, 0, 
	  -0.69999999999999996 },
  { 0.15916752910098109, 20, 0, 
	  -0.59999999999999998 },
  { -0.048358381067373557, 20, 0, 
	  -0.50000000000000000 },
  { -0.10159261558628156, 20, 0, 
	  -0.40000000000000002 },
  { 0.18028715947998042, 20, 0, 
	  -0.30000000000000004 },
  { -0.098042194344594796, 20, 0, 
	  -0.19999999999999996 },
  { -0.082077130944527663, 20, 0, 
	  -0.099999999999999978 },
  { 0.17619705200195312, 20, 0, 
	  0.0000000000000000 },
  { -0.082077130944528023, 20, 0, 
	  0.10000000000000009 },
  { -0.098042194344594796, 20, 0, 
	  0.19999999999999996 },
  { 0.18028715947998042, 20, 0, 
	  0.30000000000000004 },
  { -0.10159261558628112, 20, 0, 
	  0.39999999999999991 },
  { -0.048358381067373557, 20, 0, 
	  0.50000000000000000 },
  { 0.15916752910098075, 20, 0, 
	  0.60000000000000009 },
  { -0.20457394463834172, 20, 0, 
	  0.69999999999999996 },
  { 0.22420460541741347, 20, 0, 
	  0.80000000000000004 },
  { -0.14930823530984924, 20, 0, 
	  0.89999999999999991 },
  { 1.0000000000000000, 20, 0, 
	  1.0000000000000000 },
};
const double toler016 = 2.5000000000000020e-13;

// Test data for l=20, m=1.
// max(|f - f_GSL|): 0.0000000000000000
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
const testcase_assoc_legendre<double>
data017[21] =
{
  { 0.0000000000000000, 20, 1, 
	  -1.0000000000000000 },
  { 4.3838334818220499, 20, 1, 
	  -0.90000000000000002 },
  { -0.63138296146340844, 20, 1, 
	  -0.80000000000000004 },
  { 0.72274871413391395, 20, 1, 
	  -0.69999999999999996 },
  { -2.3203528743824910, 20, 1, 
	  -0.59999999999999998 },
  { 3.7399919228791405, 20, 1, 
	  -0.50000000000000000 },
  { -3.1692202279270041, 20, 1, 
	  -0.40000000000000002 },
  { 0.15804468835344135, 20, 1, 
	  -0.30000000000000004 },
  { 3.0366182393271171, 20, 1, 
	  -0.19999999999999996 },
  { -3.2115523815580209, 20, 1, 
	  -0.099999999999999978 },
  { 0.0000000000000000, 20, 1, 
	  0.0000000000000000 },
  { 3.2115523815580169, 20, 1, 
	  0.10000000000000009 },
  { -3.0366182393271171, 20, 1, 
	  0.19999999999999996 },
  { -0.15804468835344135, 20, 1, 
	  0.30000000000000004 },
  { 3.1692202279270085, 20, 1, 
	  0.39999999999999991 },
  { -3.7399919228791405, 20, 1, 
	  0.50000000000000000 },
  { 2.3203528743824995, 20, 1, 
	  0.60000000000000009 },
  { -0.72274871413391395, 20, 1, 
	  0.69999999999999996 },
  { 0.63138296146340844, 20, 1, 
	  0.80000000000000004 },
  { -4.3838334818220339, 20, 1, 
	  0.89999999999999991 },
  { 0.0000000000000000, 20, 1, 
	  1.0000000000000000 },
};
const double toler017 = 2.5000000000000020e-13;

// Test data for l=20, m=2.
// max(|f - f_GSL|): 0.0000000000000000
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
const testcase_assoc_legendre<double>
data018[21] =
{
  { 0.0000000000000000, 20, 2, 
	  -1.0000000000000000 },
  { 80.812425587310102, 20, 2, 
	  -0.90000000000000002 },
  { -95.849622172549374, 20, 2, 
	  -0.80000000000000004 },
  { 87.337927630325510, 20, 2, 
	  -0.69999999999999996 },
  { -70.330891533985834, 20, 2, 
	  -0.59999999999999998 },
  { 24.629090735179489, 20, 2, 
	  -0.50000000000000000 },
  { 39.902576338912425, 20, 2, 
	  -0.40000000000000002 },
  { -75.621201471396603, 20, 2, 
	  -0.30000000000000004 },
  { 42.417415829726494, 20, 2, 
	  -0.19999999999999996 },
  { 33.826848678871293, 20, 2, 
	  -0.099999999999999978 },
  { -74.002761840820312, 20, 2, 
	  0.0000000000000000 },
  { 33.826848678871464, 20, 2, 
	  0.10000000000000009 },
  { 42.417415829726494, 20, 2, 
	  0.19999999999999996 },
  { -75.621201471396603, 20, 2, 
	  0.30000000000000004 },
  { 39.902576338912247, 20, 2, 
	  0.39999999999999991 },
  { 24.629090735179489, 20, 2, 
	  0.50000000000000000 },
  { -70.330891533985721, 20, 2, 
	  0.60000000000000009 },
  { 87.337927630325510, 20, 2, 
	  0.69999999999999996 },
  { -95.849622172549374, 20, 2, 
	  0.80000000000000004 },
  { 80.812425587310500, 20, 2, 
	  0.89999999999999991 },
  { 0.0000000000000000, 20, 2, 
	  1.0000000000000000 },
};
const double toler018 = 2.5000000000000020e-13;

// Test data for l=20, m=5.
// max(|f - f_GSL|): 0.0000000000000000
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
const testcase_assoc_legendre<double>
data019[21] =
{
  { -0.0000000000000000, 20, 5, 
	  -1.0000000000000000 },
  { -315702.32715134218, 20, 5, 
	  -0.90000000000000002 },
  { 503060.91484852589, 20, 5, 
	  -0.80000000000000004 },
  { -298127.28360361955, 20, 5, 
	  -0.69999999999999996 },
  { -114444.61447464029, 20, 5, 
	  -0.59999999999999998 },
  { 543428.40914592845, 20, 5, 
	  -0.50000000000000000 },
  { -613842.07728185470, 20, 5, 
	  -0.40000000000000002 },
  { 143765.42411270936, 20, 5, 
	  -0.30000000000000004 },
  { 472600.45321372285, 20, 5, 
	  -0.19999999999999996 },
  { -563861.76771496492, 20, 5, 
	  -0.099999999999999978 },
  { 0.0000000000000000, 20, 5, 
	  0.0000000000000000 },
  { 563861.76771496458, 20, 5, 
	  0.10000000000000009 },
  { -472600.45321372285, 20, 5, 
	  0.19999999999999996 },
  { -143765.42411270936, 20, 5, 
	  0.30000000000000004 },
  { 613842.07728185481, 20, 5, 
	  0.39999999999999991 },
  { -543428.40914592845, 20, 5, 
	  0.50000000000000000 },
  { 114444.61447464178, 20, 5, 
	  0.60000000000000009 },
  { 298127.28360361955, 20, 5, 
	  0.69999999999999996 },
  { -503060.91484852589, 20, 5, 
	  0.80000000000000004 },
  { 315702.32715134491, 20, 5, 
	  0.89999999999999991 },
  { 0.0000000000000000, 20, 5, 
	  1.0000000000000000 },
};
const double toler019 = 2.5000000000000020e-13;

// Test data for l=20, m=10.
// max(|f - f_GSL|): 0.0000000000000000
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
const testcase_assoc_legendre<double>
data020[21] =
{
  { -0.0000000000000000, 20, 10, 
	  -1.0000000000000000 },
  { 990017476694.99084, 20, 10, 
	  -0.90000000000000002 },
  { 2392757933281.0498, 20, 10, 
	  -0.80000000000000004 },
  { -1548364524949.5808, 20, 10, 
	  -0.69999999999999996 },
  { -424471915195.05627, 20, 10, 
	  -0.59999999999999998 },
  { 1744502295946.2073, 20, 10, 
	  -0.50000000000000000 },
  { -899973487310.55212, 20, 10, 
	  -0.40000000000000002 },
  { -1092420454297.7161, 20, 10, 
	  -0.30000000000000004 },
  { 1466609267659.8816, 20, 10, 
	  -0.19999999999999996 },
  { 356041756390.71674, 20, 10, 
	  -0.099999999999999978 },
  { -1612052956674.3164, 20, 10, 
	  0.0000000000000000 },
  { 356041756390.71985, 20, 10, 
	  0.10000000000000009 },
  { 1466609267659.8816, 20, 10, 
	  0.19999999999999996 },
  { -1092420454297.7161, 20, 10, 
	  0.30000000000000004 },
  { -899973487310.55530, 20, 10, 
	  0.39999999999999991 },
  { 1744502295946.2073, 20, 10, 
	  0.50000000000000000 },
  { -424471915195.05896, 20, 10, 
	  0.60000000000000009 },
  { -1548364524949.5808, 20, 10, 
	  0.69999999999999996 },
  { 2392757933281.0498, 20, 10, 
	  0.80000000000000004 },
  { 990017476694.99316, 20, 10, 
	  0.89999999999999991 },
  { 0.0000000000000000, 20, 10, 
	  1.0000000000000000 },
};
const double toler020 = 2.5000000000000020e-13;

// Test data for l=20, m=20.
// max(|f - f_GSL|): 0.0000000000000000
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
const testcase_assoc_legendre<double>
data021[21] =
{
  { 0.0000000000000000, 20, 20, 
	  -1.0000000000000000 },
  { 19609049712023808., 20, 20, 
	  -0.90000000000000002 },
  { 1.1693527616833221e+19, 20, 20, 
	  -0.80000000000000004 },
  { 3.8073455880620691e+20, 20, 20, 
	  -0.69999999999999996 },
  { 3.6874002249007927e+21, 20, 20, 
	  -0.59999999999999998 },
  { 1.8010806978179592e+22, 20, 20, 
	  -0.50000000000000000 },
  { 5.5938832584012466e+22, 20, 20, 
	  -0.40000000000000002 },
  { 1.2454734132297811e+23, 20, 20, 
	  -0.30000000000000004 },
  { 2.1263407800797497e+23, 20, 20, 
	  -0.19999999999999996 },
  { 2.8924941146976873e+23, 20, 20, 
	  -0.099999999999999978 },
  { 3.1983098677287775e+23, 20, 20, 
	  0.0000000000000000 },
  { 2.8924941146976873e+23, 20, 20, 
	  0.10000000000000009 },
  { 2.1263407800797497e+23, 20, 20, 
	  0.19999999999999996 },
  { 1.2454734132297811e+23, 20, 20, 
	  0.30000000000000004 },
  { 5.5938832584012466e+22, 20, 20, 
	  0.39999999999999991 },
  { 1.8010806978179592e+22, 20, 20, 
	  0.50000000000000000 },
  { 3.6874002249007807e+21, 20, 20, 
	  0.60000000000000009 },
  { 3.8073455880620691e+20, 20, 20, 
	  0.69999999999999996 },
  { 1.1693527616833221e+19, 20, 20, 
	  0.80000000000000004 },
  { 19609049712024020., 20, 20, 
	  0.89999999999999991 },
  { 0.0000000000000000, 20, 20, 
	  1.0000000000000000 },
};
const double toler021 = 2.5000000000000020e-13;

// Test data for l=50, m=0.
// max(|f - f_GSL|): 3.6082248300317588e-16
// max(|f - f_GSL| / |f_GSL|): 2.1700196856209138e-15
const testcase_assoc_legendre<double>
data022[21] =
{
  { 1.0000000000000000, 50, 0, 
	  -1.0000000000000000 },
  { -0.17003765994383671, 50, 0, 
	  -0.90000000000000002 },
  { 0.13879737345093113, 50, 0, 
	  -0.80000000000000004 },
  { -0.014572731645892852, 50, 0, 
	  -0.69999999999999996 },
  { -0.058860798844002096, 50, 0, 
	  -0.59999999999999998 },
  { -0.031059099239609811, 50, 0, 
	  -0.50000000000000000 },
  { 0.041569033381825375, 50, 0, 
	  -0.40000000000000002 },
  { 0.10911051574714797, 50, 0, 
	  -0.30000000000000004 },
  { 0.083432272204197494, 50, 0, 
	  -0.19999999999999996 },
  { -0.038205812661313600, 50, 0, 
	  -0.099999999999999978 },
  { -0.11227517265921705, 50, 0, 
	  0.0000000000000000 },
  { -0.038205812661314155, 50, 0, 
	  0.10000000000000009 },
  { 0.083432272204197494, 50, 0, 
	  0.19999999999999996 },
  { 0.10911051574714797, 50, 0, 
	  0.30000000000000004 },
  { 0.041569033381824674, 50, 0, 
	  0.39999999999999991 },
  { -0.031059099239609811, 50, 0, 
	  0.50000000000000000 },
  { -0.058860798844001430, 50, 0, 
	  0.60000000000000009 },
  { -0.014572731645892852, 50, 0, 
	  0.69999999999999996 },
  { 0.13879737345093113, 50, 0, 
	  0.80000000000000004 },
  { -0.17003765994383657, 50, 0, 
	  0.89999999999999991 },
  { 1.0000000000000000, 50, 0, 
	  1.0000000000000000 },
};
const double toler022 = 2.5000000000000020e-13;

// Test data for l=50, m=1.
// max(|f - f_GSL|): 0.0000000000000000
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
const testcase_assoc_legendre<double>
data023[21] =
{
  { 0.0000000000000000, 50, 1, 
	  -1.0000000000000000 },
  { -0.13424149984449490, 50, 1, 
	  -0.90000000000000002 },
  { 2.2011219672413018, 50, 1, 
	  -0.80000000000000004 },
  { 6.6622414993232004, 50, 1, 
	  -0.69999999999999996 },
  { 5.5772846936919249, 50, 1, 
	  -0.59999999999999998 },
  { 5.8787148815607608, 50, 1, 
	  -0.50000000000000000 },
  { 5.5473459458633974, 50, 1, 
	  -0.40000000000000002 },
  { 1.8444956647619930, 50, 1, 
	  -0.30000000000000004 },
  { -3.8722014306642127, 50, 1, 
	  -0.19999999999999996 },
  { -5.3488751322285628, 50, 1, 
	  -0.099999999999999978 },
  { -0.0000000000000000, 50, 1, 
	  0.0000000000000000 },
  { 5.3488751322285522, 50, 1, 
	  0.10000000000000009 },
  { 3.8722014306642127, 50, 1, 
	  0.19999999999999996 },
  { -1.8444956647619930, 50, 1, 
	  0.30000000000000004 },
  { -5.5473459458634080, 50, 1, 
	  0.39999999999999991 },
  { -5.8787148815607608, 50, 1, 
	  0.50000000000000000 },
  { -5.5772846936919453, 50, 1, 
	  0.60000000000000009 },
  { -6.6622414993232004, 50, 1, 
	  0.69999999999999996 },
  { -2.2011219672413018, 50, 1, 
	  0.80000000000000004 },
  { 0.13424149984462019, 50, 1, 
	  0.89999999999999991 },
  { 0.0000000000000000, 50, 1, 
	  1.0000000000000000 },
};
const double toler023 = 2.5000000000000020e-13;

// Test data for l=50, m=2.
// max(|f - f_GSL|): 0.0000000000000000
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
const testcase_assoc_legendre<double>
data024[21] =
{
  { 0.0000000000000000, 50, 2, 
	  -1.0000000000000000 },
  { 433.04168483713511, 50, 2, 
	  -0.90000000000000002 },
  { -348.06364372056424, 50, 2, 
	  -0.80000000000000004 },
  { 50.221071418108444, 50, 2, 
	  -0.69999999999999996 },
  { 158.46096409274352, 50, 2, 
	  -0.59999999999999998 },
  { 85.988858299721457, 50, 2, 
	  -0.50000000000000000 },
  { -101.15891460879270, 50, 2, 
	  -0.40000000000000002 },
  { -277.07168105316617, 50, 2, 
	  -0.30000000000000004 },
  { -214.33311373510401, 50, 2, 
	  -0.19999999999999996 },
  { 96.349657930951665, 50, 2, 
	  -0.099999999999999978 },
  { 286.30169028100346, 50, 2, 
	  0.0000000000000000 },
  { 96.349657930953242, 50, 2, 
	  0.10000000000000009 },
  { -214.33311373510401, 50, 2, 
	  0.19999999999999996 },
  { -277.07168105316617, 50, 2, 
	  0.30000000000000004 },
  { -101.15891460879088, 50, 2, 
	  0.39999999999999991 },
  { 85.988858299721457, 50, 2, 
	  0.50000000000000000 },
  { 158.46096409274153, 50, 2, 
	  0.60000000000000009 },
  { 50.221071418108444, 50, 2, 
	  0.69999999999999996 },
  { -348.06364372056424, 50, 2, 
	  0.80000000000000004 },
  { 433.04168483713374, 50, 2, 
	  0.89999999999999991 },
  { 0.0000000000000000, 50, 2, 
	  1.0000000000000000 },
};
const double toler024 = 2.5000000000000020e-13;

// Test data for l=50, m=5.
// max(|f - f_GSL|): 0.0000000000000000
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
const testcase_assoc_legendre<double>
data025[21] =
{
  { -0.0000000000000000, 50, 5, 
	  -1.0000000000000000 },
  { -27340473.952132829, 50, 5, 
	  -0.90000000000000002 },
  { 27753716.768532373, 50, 5, 
	  -0.80000000000000004 },
  { 40808153.913493633, 50, 5, 
	  -0.69999999999999996 },
  { 32071189.035790090, 50, 5, 
	  -0.59999999999999998 },
  { 36265736.218529105, 50, 5, 
	  -0.50000000000000000 },
  { 37089596.700204901, 50, 5, 
	  -0.40000000000000002 },
  { 14562029.629244499, 50, 5, 
	  -0.30000000000000004 },
  { -23686895.217517190, 50, 5, 
	  -0.19999999999999996 },
  { -34878992.965676002, 50, 5, 
	  -0.099999999999999978 },
  { -0.0000000000000000, 50, 5, 
	  0.0000000000000000 },
  { 34878992.965675958, 50, 5, 
	  0.10000000000000009 },
  { 23686895.217517190, 50, 5, 
	  0.19999999999999996 },
  { -14562029.629244499, 50, 5, 
	  0.30000000000000004 },
  { -37089596.700204931, 50, 5, 
	  0.39999999999999991 },
  { -36265736.218529105, 50, 5, 
	  0.50000000000000000 },
  { -32071189.035790242, 50, 5, 
	  0.60000000000000009 },
  { -40808153.913493633, 50, 5, 
	  0.69999999999999996 },
  { -27753716.768532373, 50, 5, 
	  0.80000000000000004 },
  { 27340473.952133428, 50, 5, 
	  0.89999999999999991 },
  { 0.0000000000000000, 50, 5, 
	  1.0000000000000000 },
};
const double toler025 = 2.5000000000000020e-13;

// Test data for l=50, m=10.
// max(|f - f_GSL|): 0.0000000000000000
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
const testcase_assoc_legendre<double>
data026[21] =
{
  { -0.0000000000000000, 50, 10, 
	  -1.0000000000000000 },
  { -8994661710093155.0, 50, 10, 
	  -0.90000000000000002 },
  { 932311375306569.62, 50, 10, 
	  -0.80000000000000004 },
  { 12153535011507012., 50, 10, 
	  -0.69999999999999996 },
  { 12176690755542240., 50, 10, 
	  -0.59999999999999998 },
  { 9180035388465754.0, 50, 10, 
	  -0.50000000000000000 },
  { 889201701866910.38, 50, 10, 
	  -0.40000000000000002 },
  { -9451384032851604.0, 50, 10, 
	  -0.30000000000000004 },
  { -9926439446673564.0, 50, 10, 
	  -0.19999999999999996 },
  { 2794368162749970.5, 50, 10, 
	  -0.099999999999999978 },
  { 11452238249246346., 50, 10, 
	  0.0000000000000000 },
  { 2794368162750031.0, 50, 10, 
	  0.10000000000000009 },
  { -9926439446673564.0, 50, 10, 
	  0.19999999999999996 },
  { -9451384032851604.0, 50, 10, 
	  0.30000000000000004 },
  { 889201701866984.00, 50, 10, 
	  0.39999999999999991 },
  { 9180035388465754.0, 50, 10, 
	  0.50000000000000000 },
  { 12176690755542214., 50, 10, 
	  0.60000000000000009 },
  { 12153535011507012., 50, 10, 
	  0.69999999999999996 },
  { 932311375306569.62, 50, 10, 
	  0.80000000000000004 },
  { -8994661710093362.0, 50, 10, 
	  0.89999999999999991 },
  { 0.0000000000000000, 50, 10, 
	  1.0000000000000000 },
};
const double toler026 = 2.5000000000000020e-13;

// Test data for l=50, m=20.
// max(|f - f_GSL|): 0.0000000000000000
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
const testcase_assoc_legendre<double>
data027[21] =
{
  { 0.0000000000000000, 50, 20, 
	  -1.0000000000000000 },
  { 1.6630925158645501e+33, 50, 20, 
	  -0.90000000000000002 },
  { 1.0622676657892052e+33, 50, 20, 
	  -0.80000000000000004 },
  { 8.6022521164717112e+32, 50, 20, 
	  -0.69999999999999996 },
  { 4.0860128756808466e+32, 50, 20, 
	  -0.59999999999999998 },
  { -4.0169860814274459e+32, 50, 20, 
	  -0.50000000000000000 },
  { -8.2324325279774037e+32, 50, 20, 
	  -0.40000000000000002 },
  { -4.0054067236243731e+31, 50, 20, 
	  -0.30000000000000004 },
  { 7.9309266056434309e+32, 50, 20, 
	  -0.19999999999999996 },
  { 5.4151358290898977e+31, 50, 20, 
	  -0.099999999999999978 },
  { -7.8735935697332210e+32, 50, 20, 
	  0.0000000000000000 },
  { 5.4151358290894924e+31, 50, 20, 
	  0.10000000000000009 },
  { 7.9309266056434309e+32, 50, 20, 
	  0.19999999999999996 },
  { -4.0054067236243731e+31, 50, 20, 
	  0.30000000000000004 },
  { -8.2324325279773994e+32, 50, 20, 
	  0.39999999999999991 },
  { -4.0169860814274459e+32, 50, 20, 
	  0.50000000000000000 },
  { 4.0860128756807846e+32, 50, 20, 
	  0.60000000000000009 },
  { 8.6022521164717112e+32, 50, 20, 
	  0.69999999999999996 },
  { 1.0622676657892052e+33, 50, 20, 
	  0.80000000000000004 },
  { 1.6630925158645483e+33, 50, 20, 
	  0.89999999999999991 },
  { 0.0000000000000000, 50, 20, 
	  1.0000000000000000 },
};
const double toler027 = 2.5000000000000020e-13;

// Test data for l=50, m=50.
// max(|f - f_GSL|): 0.0000000000000000
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
const testcase_assoc_legendre<double>
data028[21] =
{
  { 0.0000000000000000, 50, 50, 
	  -1.0000000000000000 },
  { 2.5366994974431341e+60, 50, 50, 
	  -0.90000000000000002 },
  { 2.2028834403101213e+67, 50, 50, 
	  -0.80000000000000004 },
  { 1.3325496559566651e+71, 50, 50, 
	  -0.69999999999999996 },
  { 3.8898096431781969e+73, 50, 50, 
	  -0.59999999999999998 },
  { 2.0509760257037188e+75, 50, 50, 
	  -0.50000000000000000 },
  { 3.4866724533443283e+76, 50, 50, 
	  -0.40000000000000002 },
  { 2.5790740224150207e+77, 50, 50, 
	  -0.30000000000000004 },
  { 9.8222237931680989e+77, 50, 50, 
	  -0.19999999999999996 },
  { 2.1198682190366617e+78, 50, 50, 
	  -0.099999999999999978 },
  { 2.7253921397507295e+78, 50, 50, 
	  0.0000000000000000 },
  { 2.1198682190366617e+78, 50, 50, 
	  0.10000000000000009 },
  { 9.8222237931680989e+77, 50, 50, 
	  0.19999999999999996 },
  { 2.5790740224150207e+77, 50, 50, 
	  0.30000000000000004 },
  { 3.4866724533443283e+76, 50, 50, 
	  0.39999999999999991 },
  { 2.0509760257037188e+75, 50, 50, 
	  0.50000000000000000 },
  { 3.8898096431781724e+73, 50, 50, 
	  0.60000000000000009 },
  { 1.3325496559566651e+71, 50, 50, 
	  0.69999999999999996 },
  { 2.2028834403101213e+67, 50, 50, 
	  0.80000000000000004 },
  { 2.5366994974431990e+60, 50, 50, 
	  0.89999999999999991 },
  { 0.0000000000000000, 50, 50, 
	  1.0000000000000000 },
};
const double toler028 = 2.5000000000000020e-13;

// Test data for l=100, m=0.
// max(|f - f_GSL|): 3.4694469519536142e-16
// max(|f - f_GSL| / |f_GSL|): 6.8214063779431592e-15
const testcase_assoc_legendre<double>
data029[21] =
{
  { 1.0000000000000000, 100, 0, 
	  -1.0000000000000000 },
  { 0.10226582055871893, 100, 0, 
	  -0.90000000000000002 },
  { 0.050861167913584228, 100, 0, 
	  -0.80000000000000004 },
  { -0.077132507199778641, 100, 0, 
	  -0.69999999999999996 },
  { -0.023747023905133141, 100, 0, 
	  -0.59999999999999998 },
  { -0.060518025961861198, 100, 0, 
	  -0.50000000000000000 },
  { -0.072258202125684470, 100, 0, 
	  -0.40000000000000002 },
  { 0.057127392202801566, 100, 0, 
	  -0.30000000000000004 },
  { 0.014681835355659706, 100, 0, 
	  -0.19999999999999996 },
  { -0.063895098434750205, 100, 0, 
	  -0.099999999999999978 },
  { 0.079589237387178727, 100, 0, 
	  0.0000000000000000 },
  { -0.063895098434749761, 100, 0, 
	  0.10000000000000009 },
  { 0.014681835355659706, 100, 0, 
	  0.19999999999999996 },
  { 0.057127392202801566, 100, 0, 
	  0.30000000000000004 },
  { -0.072258202125685025, 100, 0, 
	  0.39999999999999991 },
  { -0.060518025961861198, 100, 0, 
	  0.50000000000000000 },
  { -0.023747023905134217, 100, 0, 
	  0.60000000000000009 },
  { -0.077132507199778641, 100, 0, 
	  0.69999999999999996 },
  { 0.050861167913584228, 100, 0, 
	  0.80000000000000004 },
  { 0.10226582055871711, 100, 0, 
	  0.89999999999999991 },
  { 1.0000000000000000, 100, 0, 
	  1.0000000000000000 },
};
const double toler029 = 5.0000000000000039e-13;

// Test data for l=100, m=1.
// max(|f - f_GSL|): 0.0000000000000000
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
const testcase_assoc_legendre<double>
data030[21] =
{
  { -0.0000000000000000, 100, 1, 
	  -1.0000000000000000 },
  { 6.5200167187780345, 100, 1, 
	  -0.90000000000000002 },
  { 9.0065170007027486, 100, 1, 
	  -0.80000000000000004 },
  { -5.4690908541180976, 100, 1, 
	  -0.69999999999999996 },
  { -8.6275439170430790, 100, 1, 
	  -0.59999999999999998 },
  { -6.0909031663448454, 100, 1, 
	  -0.50000000000000000 },
  { 4.1160338699561212, 100, 1, 
	  -0.40000000000000002 },
  { 5.8491043010758013, 100, 1, 
	  -0.30000000000000004 },
  { -7.9435138723089826, 100, 1, 
	  -0.19999999999999996 },
  { 4.7996285823989355, 100, 1, 
	  -0.099999999999999978 },
  { 0.0000000000000000, 100, 1, 
	  0.0000000000000000 },
  { -4.7996285823990101, 100, 1, 
	  0.10000000000000009 },
  { 7.9435138723089826, 100, 1, 
	  0.19999999999999996 },
  { -5.8491043010758013, 100, 1, 
	  0.30000000000000004 },
  { -4.1160338699560395, 100, 1, 
	  0.39999999999999991 },
  { 6.0909031663448454, 100, 1, 
	  0.50000000000000000 },
  { 8.6275439170430470, 100, 1, 
	  0.60000000000000009 },
  { 5.4690908541180976, 100, 1, 
	  0.69999999999999996 },
  { -9.0065170007027486, 100, 1, 
	  0.80000000000000004 },
  { -6.5200167187783542, 100, 1, 
	  0.89999999999999991 },
  { 0.0000000000000000, 100, 1, 
	  1.0000000000000000 },
};
const double toler030 = 2.5000000000000020e-13;

// Test data for l=100, m=2.
// max(|f - f_GSL|): 0.0000000000000000
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
const testcase_assoc_legendre<double>
data031[21] =
{
  { 0.0000000000000000, 100, 2, 
	  -1.0000000000000000 },
  { -1005.9604880761002, 100, 2, 
	  -0.90000000000000002 },
  { -489.68041725865947, 100, 2, 
	  -0.80000000000000004 },
  { 768.31676011669924, 100, 2, 
	  -0.69999999999999996 },
  { 226.90362556627937, 100, 2, 
	  -0.59999999999999998 },
  { 604.19889304940341, 100, 2, 
	  -0.50000000000000000 },
  { 733.40061037838029, 100, 2, 
	  -0.40000000000000002 },
  { -573.30774483996390, 100, 2, 
	  -0.30000000000000004 },
  { -151.52946305080880, 100, 2, 
	  -0.19999999999999996 },
  { 646.30525583587985, 100, 2, 
	  -0.099999999999999978 },
  { -803.85129761050518, 100, 2, 
	  0.0000000000000000 },
  { 646.30525583587439, 100, 2, 
	  0.10000000000000009 },
  { -151.52946305080880, 100, 2, 
	  0.19999999999999996 },
  { -573.30774483996390, 100, 2, 
	  0.30000000000000004 },
  { 733.40061037838518, 100, 2, 
	  0.39999999999999991 },
  { 604.19889304940341, 100, 2, 
	  0.50000000000000000 },
  { 226.90362556629168, 100, 2, 
	  0.60000000000000009 },
  { 768.31676011669924, 100, 2, 
	  0.69999999999999996 },
  { -489.68041725865947, 100, 2, 
	  0.80000000000000004 },
  { -1005.9604880760779, 100, 2, 
	  0.89999999999999991 },
  { 0.0000000000000000, 100, 2, 
	  1.0000000000000000 },
};
const double toler031 = 2.5000000000000020e-13;

// Test data for l=100, m=5.
// max(|f - f_GSL|): 0.0000000000000000
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
const testcase_assoc_legendre<double>
data032[21] =
{
  { 0.0000000000000000, 100, 5, 
	  -1.0000000000000000 },
  { 900551126.09653807, 100, 5, 
	  -0.90000000000000002 },
  { 988567431.55756140, 100, 5, 
	  -0.80000000000000004 },
  { -645646451.90344620, 100, 5, 
	  -0.69999999999999996 },
  { -897114585.29920685, 100, 5, 
	  -0.59999999999999998 },
  { -661710744.42483854, 100, 5, 
	  -0.50000000000000000 },
  { 380163158.51425636, 100, 5, 
	  -0.40000000000000002 },
  { 617391071.36632574, 100, 5, 
	  -0.30000000000000004 },
  { -805288801.85509109, 100, 5, 
	  -0.19999999999999996 },
  { 481041740.16728652, 100, 5, 
	  -0.099999999999999978 },
  { 0.0000000000000000, 100, 5, 
	  0.0000000000000000 },
  { -481041740.16729391, 100, 5, 
	  0.10000000000000009 },
  { 805288801.85509109, 100, 5, 
	  0.19999999999999996 },
  { -617391071.36632574, 100, 5, 
	  0.30000000000000004 },
  { -380163158.51424754, 100, 5, 
	  0.39999999999999991 },
  { 661710744.42483854, 100, 5, 
	  0.50000000000000000 },
  { 897114585.29920483, 100, 5, 
	  0.60000000000000009 },
  { 645646451.90344620, 100, 5, 
	  0.69999999999999996 },
  { -988567431.55756140, 100, 5, 
	  0.80000000000000004 },
  { -900551126.09655857, 100, 5, 
	  0.89999999999999991 },
  { 0.0000000000000000, 100, 5, 
	  1.0000000000000000 },
};
const double toler032 = 2.5000000000000020e-13;

// Test data for l=100, m=10.
// max(|f - f_GSL|): 0.0000000000000000
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
const testcase_assoc_legendre<double>
data033[21] =
{
  { 0.0000000000000000, 100, 10, 
	  -1.0000000000000000 },
  { 2.5643395957658602e+17, 100, 10, 
	  -0.90000000000000002 },
  { 1.5778673545673485e+18, 100, 10, 
	  -0.80000000000000004 },
  { 4.4355048487496801e+18, 100, 10, 
	  -0.69999999999999996 },
  { -9.5936111659124288e+17, 100, 10, 
	  -0.59999999999999998 },
  { 4.2387123021963438e+18, 100, 10, 
	  -0.50000000000000000 },
  { 8.2370834618426542e+18, 100, 10, 
	  -0.40000000000000002 },
  { -4.9089358388052941e+18, 100, 10, 
	  -0.30000000000000004 },
  { -2.3468810358091274e+18, 100, 10, 
	  -0.19999999999999996 },
  { 6.8627855225034568e+18, 100, 10, 
	  -0.099999999999999978 },
  { -8.2494597181670380e+18, 100, 10, 
	  0.0000000000000000 },
  { 6.8627855225034056e+18, 100, 10, 
	  0.10000000000000009 },
  { -2.3468810358091274e+18, 100, 10, 
	  0.19999999999999996 },
  { -4.9089358388052941e+18, 100, 10, 
	  0.30000000000000004 },
  { 8.2370834618426767e+18, 100, 10, 
	  0.39999999999999991 },
  { 4.2387123021963438e+18, 100, 10, 
	  0.50000000000000000 },
  { -9.5936111659112640e+17, 100, 10, 
	  0.60000000000000009 },
  { 4.4355048487496801e+18, 100, 10, 
	  0.69999999999999996 },
  { 1.5778673545673485e+18, 100, 10, 
	  0.80000000000000004 },
  { 2.5643395957697341e+17, 100, 10, 
	  0.89999999999999991 },
  { 0.0000000000000000, 100, 10, 
	  1.0000000000000000 },
};
const double toler033 = 2.5000000000000020e-13;

// Test data for l=100, m=20.
// max(|f - f_GSL|): 0.0000000000000000
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
const testcase_assoc_legendre<double>
data034[21] =
{
  { 0.0000000000000000, 100, 20, 
	  -1.0000000000000000 },
  { 7.1604344878780134e+37, 100, 20, 
	  -0.90000000000000002 },
  { -8.3963895116962231e+38, 100, 20, 
	  -0.80000000000000004 },
  { 7.9022236853110145e+38, 100, 20, 
	  -0.69999999999999996 },
  { 8.2680005574121013e+38, 100, 20, 
	  -0.59999999999999998 },
  { 3.0750497039999552e+38, 100, 20, 
	  -0.50000000000000000 },
  { -7.6120586043843889e+38, 100, 20, 
	  -0.40000000000000002 },
  { 1.1474496891901797e+38, 100, 20, 
	  -0.30000000000000004 },
  { 4.3966251307444241e+38, 100, 20, 
	  -0.19999999999999996 },
  { -7.0503266451702591e+38, 100, 20, 
	  -0.099999999999999978 },
  { 7.7727439836159581e+38, 100, 20, 
	  0.0000000000000000 },
  { -7.0503266451702213e+38, 100, 20, 
	  0.10000000000000009 },
  { 4.3966251307444241e+38, 100, 20, 
	  0.19999999999999996 },
  { 1.1474496891901797e+38, 100, 20, 
	  0.30000000000000004 },
  { -7.6120586043843556e+38, 100, 20, 
	  0.39999999999999991 },
  { 3.0750497039999552e+38, 100, 20, 
	  0.50000000000000000 },
  { 8.2680005574120394e+38, 100, 20, 
	  0.60000000000000009 },
  { 7.9022236853110145e+38, 100, 20, 
	  0.69999999999999996 },
  { -8.3963895116962231e+38, 100, 20, 
	  0.80000000000000004 },
  { 7.1604344878812652e+37, 100, 20, 
	  0.89999999999999991 },
  { 0.0000000000000000, 100, 20, 
	  1.0000000000000000 },
};
const double toler034 = 2.5000000000000020e-13;

// Test data for l=100, m=50.
// max(|f - f_GSL|): 0.0000000000000000
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
const testcase_assoc_legendre<double>
data035[21] =
{
  { 0.0000000000000000, 100, 50, 
	  -1.0000000000000000 },
  { 9.3231278516893716e+96, 100, 50, 
	  -0.90000000000000002 },
  { -1.1029797977454281e+98, 100, 50, 
	  -0.80000000000000004 },
  { 1.8089333903465606e+97, 100, 50, 
	  -0.69999999999999996 },
  { 5.9364045925669405e+97, 100, 50, 
	  -0.59999999999999998 },
  { -8.2252620339727118e+97, 100, 50, 
	  -0.50000000000000000 },
  { 7.1431385093739863e+97, 100, 50, 
	  -0.40000000000000002 },
  { -3.3520602067479344e+97, 100, 50, 
	  -0.30000000000000004 },
  { -2.7791149588121382e+97, 100, 50, 
	  -0.19999999999999996 },
  { 9.0119338550180417e+97, 100, 50, 
	  -0.099999999999999978 },
  { -1.1712145031578381e+98, 100, 50, 
	  0.0000000000000000 },
  { 9.0119338550181207e+97, 100, 50, 
	  0.10000000000000009 },
  { -2.7791149588121382e+97, 100, 50, 
	  0.19999999999999996 },
  { -3.3520602067479344e+97, 100, 50, 
	  0.30000000000000004 },
  { 7.1431385093740728e+97, 100, 50, 
	  0.39999999999999991 },
  { -8.2252620339727118e+97, 100, 50, 
	  0.50000000000000000 },
  { 5.9364045925668024e+97, 100, 50, 
	  0.60000000000000009 },
  { 1.8089333903465606e+97, 100, 50, 
	  0.69999999999999996 },
  { -1.1029797977454281e+98, 100, 50, 
	  0.80000000000000004 },
  { 9.3231278516894968e+96, 100, 50, 
	  0.89999999999999991 },
  { 0.0000000000000000, 100, 50, 
	  1.0000000000000000 },
};
const double toler035 = 2.5000000000000020e-13;

// Test data for l=100, m=100.
// max(|f - f_GSL|): 0.0000000000000000
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
const testcase_assoc_legendre<double>
data036[21] =
{
  { 0.0000000000000000, 100, 100, 
	  -1.0000000000000000 },
  { 5.7751792255758316e+150, 100, 100, 
	  -0.90000000000000002 },
  { 4.3552236041585515e+164, 100, 100, 
	  -0.80000000000000004 },
  { 1.5936546850595123e+172, 100, 100, 
	  -0.69999999999999996 },
  { 1.3579510590289176e+177, 100, 100, 
	  -0.59999999999999998 },
  { 3.7752749682889513e+180, 100, 100, 
	  -0.50000000000000000 },
  { 1.0910627330458913e+183, 100, 100, 
	  -0.40000000000000002 },
  { 5.9697347526822483e+184, 100, 100, 
	  -0.30000000000000004 },
  { 8.6585879147526714e+185, 100, 100, 
	  -0.19999999999999996 },
  { 4.0331571908057011e+186, 100, 100, 
	  -0.099999999999999978 },
  { 6.6663086700729543e+186, 100, 100, 
	  0.0000000000000000 },
  { 4.0331571908057011e+186, 100, 100, 
	  0.10000000000000009 },
  { 8.6585879147526714e+185, 100, 100, 
	  0.19999999999999996 },
  { 5.9697347526822483e+184, 100, 100, 
	  0.30000000000000004 },
  { 1.0910627330458913e+183, 100, 100, 
	  0.39999999999999991 },
  { 3.7752749682889513e+180, 100, 100, 
	  0.50000000000000000 },
  { 1.3579510590289000e+177, 100, 100, 
	  0.60000000000000009 },
  { 1.5936546850595123e+172, 100, 100, 
	  0.69999999999999996 },
  { 4.3552236041585515e+164, 100, 100, 
	  0.80000000000000004 },
  { 5.7751792255761289e+150, 100, 100, 
	  0.89999999999999991 },
  { 0.0000000000000000, 100, 100, 
	  1.0000000000000000 },
};
const double toler036 = 2.5000000000000020e-13;

template<typename Tp, unsigned int Num>
  void
  test(const testcase_assoc_legendre<Tp> (&data)[Num], Tp toler)
  {
    bool test __attribute__((unused)) = true;
    const Tp eps = std::numeric_limits<Tp>::epsilon();
    Tp max_abs_diff = -Tp(1);
    Tp max_abs_frac = -Tp(1);
    unsigned int num_datum = Num;
    for (unsigned int i = 0; i < num_datum; ++i)
  	 {
	const Tp f = std::assoc_legendre(data[i].l, data[i].m,
		     data[i].x);
	const Tp f0 = data[i].f0;
	const Tp diff = f - f0;
	if (std::abs(diff) > max_abs_diff)
	  max_abs_diff = std::abs(diff);
	if (std::abs(f0) > Tp(10) * eps
	 && std::abs(f) > Tp(10) * eps)
	  {
	    const Tp frac = diff / f0;
	    if (std::abs(frac) > max_abs_frac)
	      max_abs_frac = std::abs(frac);
	  }
      }
    VERIFY(max_abs_frac < toler);
  }

int
main()
{
  test(data001, toler001);
  test(data002, toler002);
  test(data003, toler003);
  test(data004, toler004);
  test(data005, toler005);
  test(data006, toler006);
  test(data007, toler007);
  test(data008, toler008);
  test(data009, toler009);
  test(data010, toler010);
  test(data011, toler011);
  test(data012, toler012);
  test(data013, toler013);
  test(data014, toler014);
  test(data015, toler015);
  test(data016, toler016);
  test(data017, toler017);
  test(data018, toler018);
  test(data019, toler019);
  test(data020, toler020);
  test(data021, toler021);
  test(data022, toler022);
  test(data023, toler023);
  test(data024, toler024);
  test(data025, toler025);
  test(data026, toler026);
  test(data027, toler027);
  test(data028, toler028);
  test(data029, toler029);
  test(data030, toler030);
  test(data031, toler031);
  test(data032, toler032);
  test(data033, toler033);
  test(data034, toler034);
  test(data035, toler035);
  test(data036, toler036);
  return 0;
}
