/* { dg-require-effective-target size32plus } */

#define DEBUG 0
#if DEBUG
#include <stdio.h>
#endif

#define N 200

int a[N][N];
int b[N][N];

static int __attribute__((noinline))
foo (void)
{
  int i, j;
  int res = 0;

  /* This loop nest should be blocked.  */
  for (j = 1; j < N; j++)
    for (i = 0; i < N; i++)
      a[i][j] = a[i][j-1] + b[i][j];

  for (i = 0; i < N; i++)
    res += a[i][i];

  return res;
}

extern void abort ();

int
main (void)
{
  int i, j, res;

  for (i = 0; i < N; i++)
    for (j = 0; j < N; j++)
      {
	a[i][j] = i + j;
	b[i][j] = i - j;
      }

  res = foo ();

#if DEBUG
  fprintf (stderr, "res = %d \n", res);
#endif

  if (res != 1333300)
    abort ();

  return 0;
}

/* { dg-final { scan-tree-dump-times "tiled by" 4 "graphite" } } */
