/* Test whether all of the 32-bit function specific options are accepted
   without error.  */
/* { dg-do compile } */
/* { dg-require-effective-target ia32 } */

extern void test_abm (void)			__attribute__((__target__("abm")));
extern void test_aes (void)			__attribute__((__target__("aes")));
extern void test_bmi (void)			__attribute__((__target__("bmi")));
extern void test_mmx (void)			__attribute__((__target__("mmx")));
extern void test_pclmul (void)			__attribute__((__target__("pclmul")));
extern void test_popcnt (void)			__attribute__((__target__("popcnt")));
extern void test_recip (void)			__attribute__((__target__("recip")));
extern void test_sse (void)			__attribute__((__target__("sse")));
extern void test_sse2 (void)			__attribute__((__target__("sse2")));
extern void test_sse3 (void)			__attribute__((__target__("sse3")));
extern void test_sse4 (void)			__attribute__((__target__("sse4")));
extern void test_sse4_1 (void)			__attribute__((__target__("sse4.1")));
extern void test_sse4_2 (void)			__attribute__((__target__("sse4.2")));
extern void test_sse4a (void)			__attribute__((__target__("sse4a")));
extern void test_fma (void)			__attribute__((__target__("fma")));
extern void test_fma4 (void)			__attribute__((__target__("fma4")));
extern void test_xop (void)			__attribute__((__target__("xop")));
extern void test_ssse3 (void)			__attribute__((__target__("ssse3")));
extern void test_tbm (void)			__attribute__((__target__("tbm")));
extern void test_avx (void)			__attribute__((__target__("avx")));
extern void test_avx2 (void)			__attribute__((__target__("avx2")));
extern void test_avx512 (void)			__attribute__((__target__("avx512")));

extern void test_no_abm (void)			__attribute__((__target__("no-abm")));
extern void test_no_aes (void)			__attribute__((__target__("no-aes")));
extern void test_no_bmi (void)			__attribute__((__target__("no-bmi")));
extern void test_no_mmx (void)			__attribute__((__target__("no-mmx")));
extern void test_no_pclmul (void)		__attribute__((__target__("no-pclmul")));
extern void test_no_popcnt (void)		__attribute__((__target__("no-popcnt")));
extern void test_no_recip (void)		__attribute__((__target__("no-recip")));
extern void test_no_sse (void)			__attribute__((__target__("no-sse")));
extern void test_no_sse2 (void)			__attribute__((__target__("no-sse2")));
extern void test_no_sse3 (void)			__attribute__((__target__("no-sse3")));
extern void test_no_sse4 (void)			__attribute__((__target__("no-sse4")));
extern void test_no_sse4_1 (void)		__attribute__((__target__("no-sse4.1")));
extern void test_no_sse4_2 (void)		__attribute__((__target__("no-sse4.2")));
extern void test_no_sse4a (void)		__attribute__((__target__("no-sse4a")));
extern void test_no_fma (void)			__attribute__((__target__("no-fma")));
extern void test_no_fma4 (void)			__attribute__((__target__("no-fma4")));
extern void test_no_xop (void)			__attribute__((__target__("no-xop")));
extern void test_no_ssse3 (void)		__attribute__((__target__("no-ssse3")));
extern void test_no_tbm (void)			__attribute__((__target__("no-tbm")));
extern void test_no_avx (void)			__attribute__((__target__("no-avx")));
extern void test_no_avx2 (void)   		__attribute__((__target__("no-avx2")));
extern void test_no_avx512 (void)   		__attribute__((__target__("no-avx512")));

extern void test_arch_i386 (void)		__attribute__((__target__("arch=i386")));
extern void test_arch_i486 (void)		__attribute__((__target__("arch=i486")));
extern void test_arch_i586 (void)		__attribute__((__target__("arch=i586")));
extern void test_arch_pentium (void)		__attribute__((__target__("arch=pentium")));
extern void test_arch_pentium_mmx (void)	__attribute__((__target__("arch=pentium-mmx")));
extern void test_arch_winchip_c6 (void)		__attribute__((__target__("arch=winchip-c6")));
extern void test_arch_winchip2 (void)		__attribute__((__target__("arch=winchip2")));
extern void test_arch_c3 (void)			__attribute__((__target__("arch=c3")));
extern void test_arch_c3_2 (void)		__attribute__((__target__("arch=c3-2")));
extern void test_arch_i686 (void)		__attribute__((__target__("arch=i686")));
extern void test_arch_pentiumpro (void)		__attribute__((__target__("arch=pentiumpro")));
extern void test_arch_pentium2 (void)		__attribute__((__target__("arch=pentium2")));
extern void test_arch_pentium3 (void)		__attribute__((__target__("arch=pentium3")));
extern void test_arch_pentium3m (void)		__attribute__((__target__("arch=pentium3m")));
extern void test_arch_pentium_m (void)		__attribute__((__target__("arch=pentium-m")));
extern void test_arch_pentium4 (void)		__attribute__((__target__("arch=pentium4")));
extern void test_arch_pentium4m (void)		__attribute__((__target__("arch=pentium4m")));
extern void test_arch_prescott (void)		__attribute__((__target__("arch=prescott")));
extern void test_arch_nocona (void)		__attribute__((__target__("arch=nocona")));
extern void test_arch_core2 (void)		__attribute__((__target__("arch=core2")));
extern void test_arch_corei7 (void)		__attribute__((__target__("arch=corei7")));
extern void test_arch_corei7_avx (void)		__attribute__((__target__("arch=corei7-avx")));
extern void test_arch_core_avx2 (void)		__attribute__((__target__("arch=core-avx2")));
extern void test_arch_knl (void)		__attribute__((__target__("arch=knl")));
extern void test_arch_geode (void)		__attribute__((__target__("arch=geode")));
extern void test_arch_k6 (void)			__attribute__((__target__("arch=k6")));
extern void test_arch_k6_2 (void)		__attribute__((__target__("arch=k6-2")));
extern void test_arch_k6_3 (void)		__attribute__((__target__("arch=k6-3")));
extern void test_arch_athlon (void)		__attribute__((__target__("arch=athlon")));
extern void test_arch_athlon_tbird (void)	__attribute__((__target__("arch=athlon-tbird")));
extern void test_arch_athlon_4 (void)		__attribute__((__target__("arch=athlon-4")));
extern void test_arch_athlon_xp (void)		__attribute__((__target__("arch=athlon-xp")));
extern void test_arch_athlon_mp (void)		__attribute__((__target__("arch=athlon-mp")));
extern void test_arch_k8 (void)			__attribute__((__target__("arch=k8")));
extern void test_arch_k8_sse3 (void)		__attribute__((__target__("arch=k8-sse3")));
extern void test_arch_opteron (void)		__attribute__((__target__("arch=opteron")));
extern void test_arch_opteron_sse3 (void)	__attribute__((__target__("arch=opteron-sse3")));
extern void test_arch_athlon64 (void)		__attribute__((__target__("arch=athlon64")));
extern void test_arch_athlon64_sse3 (void)	__attribute__((__target__("arch=athlon64-sse3")));
extern void test_arch_athlon_fx (void)		__attribute__((__target__("arch=athlon-fx")));
extern void test_arch_amdfam10 (void)		__attribute__((__target__("arch=amdfam10")));
extern void test_arch_barcelona (void)		__attribute__((__target__("arch=barcelona")));
extern void test_arch_bdver1 (void)		__attribute__((__target__("arch=bdver1")));
extern void test_arch_bdver2 (void)		__attribute__((__target__("arch=bdver2")));
extern void test_arch_bdver3 (void)		__attribute__((__target__("arch=bdver3")));
extern void test_arch_foo (void)		__attribute__((__target__("arch=foo"))); /* { dg-error "bad value" } */

extern void test_tune_i386 (void)		__attribute__((__target__("tune=i386")));
extern void test_tune_i486 (void)		__attribute__((__target__("tune=i486")));
extern void test_tune_i586 (void)		__attribute__((__target__("tune=i586")));
extern void test_tune_pentium (void)		__attribute__((__target__("tune=pentium")));
extern void test_tune_pentium_mmx (void)	__attribute__((__target__("tune=pentium-mmx")));
extern void test_tune_winchip_c6 (void)		__attribute__((__target__("tune=winchip-c6")));
extern void test_tune_winchip2 (void)		__attribute__((__target__("tune=winchip2")));
extern void test_tune_c3 (void)			__attribute__((__target__("tune=c3")));
extern void test_tune_c3_2 (void)		__attribute__((__target__("tune=c3-2")));
extern void test_tune_i686 (void)		__attribute__((__target__("tune=i686")));
extern void test_tune_pentiumpro (void)		__attribute__((__target__("tune=pentiumpro")));
extern void test_tune_pentium2 (void)		__attribute__((__target__("tune=pentium2")));
extern void test_tune_pentium3 (void)		__attribute__((__target__("tune=pentium3")));
extern void test_tune_pentium3m (void)		__attribute__((__target__("tune=pentium3m")));
extern void test_tune_pentium_m (void)		__attribute__((__target__("tune=pentium-m")));
extern void test_tune_pentium4 (void)		__attribute__((__target__("tune=pentium4")));
extern void test_tune_pentium4m (void)		__attribute__((__target__("tune=pentium4m")));
extern void test_tune_prescott (void)		__attribute__((__target__("tune=prescott")));
extern void test_tune_nocona (void)		__attribute__((__target__("tune=nocona")));
extern void test_tune_core2 (void)		__attribute__((__target__("tune=core2")));
extern void test_tune_corei7 (void)		__attribute__((__target__("tune=corei7")));
extern void test_tune_corei7_avx (void)		__attribute__((__target__("tune=corei7-avx")));
extern void test_tune_core_avx2 (void)		__attribute__((__target__("tune=core-avx2")));
extern void test_tune_geode (void)		__attribute__((__target__("tune=geode")));
extern void test_tune_k6 (void)			__attribute__((__target__("tune=k6")));
extern void test_tune_k6_2 (void)		__attribute__((__target__("tune=k6-2")));
extern void test_tune_k6_3 (void)		__attribute__((__target__("tune=k6-3")));
extern void test_tune_athlon (void)		__attribute__((__target__("tune=athlon")));
extern void test_tune_athlon_tbird (void)	__attribute__((__target__("tune=athlon-tbird")));
extern void test_tune_athlon_4 (void)		__attribute__((__target__("tune=athlon-4")));
extern void test_tune_athlon_xp (void)		__attribute__((__target__("tune=athlon-xp")));
extern void test_tune_athlon_mp (void)		__attribute__((__target__("tune=athlon-mp")));
extern void test_tune_k8 (void)			__attribute__((__target__("tune=k8")));
extern void test_tune_k8_sse3 (void)		__attribute__((__target__("tune=k8-sse3")));
extern void test_tune_opteron (void)		__attribute__((__target__("tune=opteron")));
extern void test_tune_opteron_sse3 (void)	__attribute__((__target__("tune=opteron-sse3")));
extern void test_tune_athlon64 (void)		__attribute__((__target__("tune=athlon64")));
extern void test_tune_athlon64_sse3 (void)	__attribute__((__target__("tune=athlon64-sse3")));
extern void test_tune_athlon_fx (void)		__attribute__((__target__("tune=athlon-fx")));
extern void test_tune_amdfam10 (void)		__attribute__((__target__("tune=amdfam10")));
extern void test_tune_barcelona (void)		__attribute__((__target__("tune=barcelona")));
extern void test_tune_bdver1 (void)		__attribute__((__target__("tune=bdver1")));
extern void test_tune_bdver2 (void)		__attribute__((__target__("tune=bdver2")));
extern void test_tune_bdver3 (void)		__attribute__((__target__("tune=bdver3")));
extern void test_tune_generic (void)		__attribute__((__target__("tune=generic")));
extern void test_tune_foo (void)		__attribute__((__target__("tune=foo"))); /* { dg-error "bad value" } */

extern void test_fpmath_sse (void)		__attribute__((__target__("sse2,fpmath=sse")));
extern void test_fpmath_387 (void)		__attribute__((__target__("sse2,fpmath=387")));
extern void test_fpmath_sse_387 (void)		__attribute__((__target__("sse2,fpmath=sse+387")));
extern void test_fpmath_387_sse (void)		__attribute__((__target__("sse2,fpmath=387+sse")));
extern void test_fpmath_both (void)		__attribute__((__target__("sse2,fpmath=both")));
