// DR 743: A type without linkage shall not be used as the type of a
//     variable or function with linkage, unless
//   o the variable or function has extern "C" linkage (7.5 [dcl.link]), or
//   o the variable or function is not used (3.2 [basic.def.odr]) or is
//   defined in the same translation unit.

// { dg-options -std=c++11 }

template <typename T> struct B {
  void g(T){}
  void h(T);			// { dg-error "never defined" }
  friend void i(B, T){}
  static T t1;			// { dg-error "never defined" }
  static T t2;
};

template <typename T> T B<T>::t2 = { };

enum {} e1;			// OK, defined
extern enum {} e2;		// { dg-error "never defined" }
extern "C" enum {} e3;		// OK, extern "C"

void f() {
  struct A { int x; };  // no linkage
  A a = {1};
  B<A> ba;              // declares B<A>::g(A) and B<A>::h(A)
  ba.t1 = a;		// error, B<T>::t never defined
  ba.t2 = a;		// OK
  ba.g(a);              // OK
  ba.h(a);              // error, B<T>::h never defined
  i(ba, a);             // OK
  e1+e2+e3;
}
