// { dg-do run { target *-*-freebsd* *-*-netbsd* *-*-linux* *-*-gnu* *-*-solaris* *-*-cygwin *-*-darwin* powerpc-ibm-aix* } }
// { dg-options " -std=gnu++0x -pthread -Wl,--no-as-needed" { target *-*-freebsd* *-*-netbsd* *-*-linux* *-*-gnu* powerpc-ibm-aix* } }
// { dg-options " -std=gnu++0x -pthreads" { target *-*-solaris* } }
// { dg-options " -std=gnu++0x " { target *-*-cygwin *-*-darwin* } }
// { dg-require-cstdint "" }
// { dg-require-gthreads "" }

// Copyright (C) 2008-2013 Free Software Foundation, Inc.
//
// This file is part of the GNU ISO C++ Library.  This library is free
// software; you can redistribute it and/or modify it under the
// terms of the GNU General Public License as published by the
// Free Software Foundation; either version 3, or (at your option)
// any later version.

// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License along
// with this library; see the file COPYING3.  If not see
// <http://www.gnu.org/licenses/>.


#include <thread>
#include <system_error>
#include <bits/move.h> // std::move
#include <testsuite_hooks.h>

void f() { }

void test01()
{
  bool test __attribute__((unused)) = true;

  try
    {
      std::thread t1(f);
      std::thread::id t1_id = t1.get_id();
      
      std::thread t2;
      
      t2.swap(t1);
      VERIFY( t1.get_id() == std::thread::id() );
      VERIFY( t2.get_id() == t1_id );

      t2.join();
    }
  catch (const std::system_error&)
    {
      VERIFY( false );
    }
  catch (...)
    {
      VERIFY( false );
    }
}

void test02()
{
  bool test __attribute__((unused)) = true;

  try
    {
      std::thread t1(f);
      std::thread::id t1_id = t1.get_id();
      
      std::thread t2;
      
      std::swap(t1, t2);
      VERIFY( t1.get_id() == std::thread::id() );
      VERIFY( t2.get_id() == t1_id );

      t2.join();
    }
  catch (const std::system_error&)
    {
      VERIFY( false );
    }
  catch (...)
    {
      VERIFY( false );
    }
}

int main()
{
  test01();
  test02();

  return 0;
}
