/* Test exact conversion to binary floating-point types of
   floating-point contents expressed in decimal.  PR 21718.  */
/* { dg-do run } */
/* { dg-options "-w" } */

/* For float (if IEEE binary32), double (if IEEE binary64) and long
   double (if IEEE binary64, x86 extended or IEEE binary128) we test
   half-way values and numbers close to those half-way values.  */

#include <float.h>

#if FLT_EVAL_METHOD == 0 \
  && FLT_MANT_DIG == 24 \
  && FLT_MIN_EXP == -125 \
  && FLT_MAX_EXP == 128
# define FLT_OK
/* 0x0.8p-149 */
static const float f1ae = 0, f1be = 0, f1ce = 0x1p-149f;
static const float f1a =
7.0064923216240853546186479164495806564013097093825788587853\
4141944895541342930300743319094181060791015624999e-46f;
static const float f1b =
7.0064923216240853546186479164495806564013097093825788587853\
4141944895541342930300743319094181060791015625e-46f;
static const float f1c =
7.0064923216240853546186479164495806564013097093825788587853\
4141944895541342930300743319094181060791015625001e-46f;
/* 0x1.8p-149 */
static const float f2ae = 0x1p-149f, f2be = 0x2p-149f, f2ce = 0x2p-149f;
static const float f2a =
2.1019476964872256063855943749348741969203929128147736576356\
02425834686624028790902229957282543182373046874999e-45f;
static const float f2b =
2.1019476964872256063855943749348741969203929128147736576356\
02425834686624028790902229957282543182373046875e-45f;
static const float f2c =
2.1019476964872256063855943749348741969203929128147736576356\
02425834686624028790902229957282543182373046875001e-45f;
/* 0x1.000001p127 */
static const float f3ae = 0x1p127f, f3be = 0x1p127f, f3ce = 0x1.000002p127f;
static const float f3a =
1.70141193601674033557522515689509748735999e+38f;
static const float f3b =
1.70141193601674033557522515689509748736e+38f;
static const float f3c =
1.70141193601674033557522515689509748736001e+38f;
#endif

#if (FLT_EVAL_METHOD == 0 || FLT_EVAL_METHOD == 1) \
  && DBL_MANT_DIG == 53 \
  && DBL_MIN_EXP == -1021 \
  && DBL_MAX_EXP == 1024
# define DBL_OK
/* 0x0.8p-1074 */
static const double d1ae = 0, d1be = 0, d1ce = 0x1p-1074;
static const double d1a =
2.4703282292062327208828439643411068618252990130716238221279\
284125033775363510437593264991818081799618989828234772285886\
546332835517796989819938739800539093906315035659515570226392\
290858392449105184435931802849936536152500319370457678249219\
365623669863658480757001585769269903706311928279558551332927\
834338409351978015531246597263579574622766465272827220056374\
006485499977096599470454020828166226237857393450736339007967\
761930577506740176324673600968951340535537458516661134223766\
678604162159680461914467291840300530057530849048765391711386\
591646239524912623653881879636239373280423891018672348497668\
235089863388587925628302755995657524455507255189313690836254\
779186948667994968324049705821028513185451396213837722826145\
437693412532098591327667236328124999e-324;
static const double d1b =
2.4703282292062327208828439643411068618252990130716238221279\
284125033775363510437593264991818081799618989828234772285886\
546332835517796989819938739800539093906315035659515570226392\
290858392449105184435931802849936536152500319370457678249219\
365623669863658480757001585769269903706311928279558551332927\
834338409351978015531246597263579574622766465272827220056374\
006485499977096599470454020828166226237857393450736339007967\
761930577506740176324673600968951340535537458516661134223766\
678604162159680461914467291840300530057530849048765391711386\
591646239524912623653881879636239373280423891018672348497668\
235089863388587925628302755995657524455507255189313690836254\
779186948667994968324049705821028513185451396213837722826145\
437693412532098591327667236328125e-324;
static const double d1c =
2.4703282292062327208828439643411068618252990130716238221279\
284125033775363510437593264991818081799618989828234772285886\
546332835517796989819938739800539093906315035659515570226392\
290858392449105184435931802849936536152500319370457678249219\
365623669863658480757001585769269903706311928279558551332927\
834338409351978015531246597263579574622766465272827220056374\
006485499977096599470454020828166226237857393450736339007967\
761930577506740176324673600968951340535537458516661134223766\
678604162159680461914467291840300530057530849048765391711386\
591646239524912623653881879636239373280423891018672348497668\
235089863388587925628302755995657524455507255189313690836254\
779186948667994968324049705821028513185451396213837722826145\
437693412532098591327667236328125001e-324;
/* 0x1.8p-1074 */
static const double d2ae = 0x1p-1074, d2be = 0x2p-1074, d2ce = 0x2p-1074;
static const double d2a =
7.4109846876186981626485318930233205854758970392148714663837\
852375101326090531312779794975454245398856969484704316857659\
638998506553390969459816219401617281718945106978546710679176\
872575177347315553307795408549809608457500958111373034747658\
096871009590975442271004757307809711118935784838675653998783\
503015228055934046593739791790738723868299395818481660169122\
019456499931289798411362062484498678713572180352209017023903\
285791732520220528974020802906854021606612375549983402671300\
035812486479041385743401875520901590172592547146296175134159\
774938718574737870961645638908718119841271673056017045493004\
705269590165763776884908267986972573366521765567941072508764\
337560846003984904972149117463085539556354188641513168478436\
313080237596295773983001708984374999e-324;
static const double d2b =
7.4109846876186981626485318930233205854758970392148714663837\
852375101326090531312779794975454245398856969484704316857659\
638998506553390969459816219401617281718945106978546710679176\
872575177347315553307795408549809608457500958111373034747658\
096871009590975442271004757307809711118935784838675653998783\
503015228055934046593739791790738723868299395818481660169122\
019456499931289798411362062484498678713572180352209017023903\
285791732520220528974020802906854021606612375549983402671300\
035812486479041385743401875520901590172592547146296175134159\
774938718574737870961645638908718119841271673056017045493004\
705269590165763776884908267986972573366521765567941072508764\
337560846003984904972149117463085539556354188641513168478436\
313080237596295773983001708984375e-324;
static const double d2c =
7.4109846876186981626485318930233205854758970392148714663837\
852375101326090531312779794975454245398856969484704316857659\
638998506553390969459816219401617281718945106978546710679176\
872575177347315553307795408549809608457500958111373034747658\
096871009590975442271004757307809711118935784838675653998783\
503015228055934046593739791790738723868299395818481660169122\
019456499931289798411362062484498678713572180352209017023903\
285791732520220528974020802906854021606612375549983402671300\
035812486479041385743401875520901590172592547146296175134159\
774938718574737870961645638908718119841271673056017045493004\
705269590165763776884908267986972573366521765567941072508764\
337560846003984904972149117463085539556354188641513168478436\
313080237596295773983001708984375001e-324;
/* 0x1.00000000000008p1023 */
static const double d3ae = 0x1p1023, d3be = 0x1p1023, d3ce = 0x1.0000000000001p1023;
static const double d3a =
8.9884656743115805365666807213050294962762414131308158973971\
342756154045415486693752413698006024096935349884403114202125\
541629105369684531108613657287705365884742938136589844238179\
474556051429647415148697857438797685859063890851407391008830\
874765563025951597582513936655578157348020066364210154316532\
161708031999e+307;
static const double d3b =
8.9884656743115805365666807213050294962762414131308158973971\
342756154045415486693752413698006024096935349884403114202125\
541629105369684531108613657287705365884742938136589844238179\
474556051429647415148697857438797685859063890851407391008830\
874765563025951597582513936655578157348020066364210154316532\
161708032e+307;
static const double d3c =
8.9884656743115805365666807213050294962762414131308158973971\
342756154045415486693752413698006024096935349884403114202125\
541629105369684531108613657287705365884742938136589844238179\
474556051429647415148697857438797685859063890851407391008830\
874765563025951597582513936655578157348020066364210154316532\
161708032001e+307;
#endif

#if LDBL_MANT_DIG == 53 \
  && LDBL_MIN_EXP == -1021 \
  && LDBL_MAX_EXP == 1024
# define LDBL_OK
/* 0x0.8p-1074 */
static const long double ld1ae = 0, ld1be = 0, ld1ce = 0x1p-1074L;
static const long double ld1a =
2.4703282292062327208828439643411068618252990130716238221279\
284125033775363510437593264991818081799618989828234772285886\
546332835517796989819938739800539093906315035659515570226392\
290858392449105184435931802849936536152500319370457678249219\
365623669863658480757001585769269903706311928279558551332927\
834338409351978015531246597263579574622766465272827220056374\
006485499977096599470454020828166226237857393450736339007967\
761930577506740176324673600968951340535537458516661134223766\
678604162159680461914467291840300530057530849048765391711386\
591646239524912623653881879636239373280423891018672348497668\
235089863388587925628302755995657524455507255189313690836254\
779186948667994968324049705821028513185451396213837722826145\
437693412532098591327667236328124999e-324L;
static const long double ld1b =
2.4703282292062327208828439643411068618252990130716238221279\
284125033775363510437593264991818081799618989828234772285886\
546332835517796989819938739800539093906315035659515570226392\
290858392449105184435931802849936536152500319370457678249219\
365623669863658480757001585769269903706311928279558551332927\
834338409351978015531246597263579574622766465272827220056374\
006485499977096599470454020828166226237857393450736339007967\
761930577506740176324673600968951340535537458516661134223766\
678604162159680461914467291840300530057530849048765391711386\
591646239524912623653881879636239373280423891018672348497668\
235089863388587925628302755995657524455507255189313690836254\
779186948667994968324049705821028513185451396213837722826145\
437693412532098591327667236328125e-324L;
static const long double ld1c =
2.4703282292062327208828439643411068618252990130716238221279\
284125033775363510437593264991818081799618989828234772285886\
546332835517796989819938739800539093906315035659515570226392\
290858392449105184435931802849936536152500319370457678249219\
365623669863658480757001585769269903706311928279558551332927\
834338409351978015531246597263579574622766465272827220056374\
006485499977096599470454020828166226237857393450736339007967\
761930577506740176324673600968951340535537458516661134223766\
678604162159680461914467291840300530057530849048765391711386\
591646239524912623653881879636239373280423891018672348497668\
235089863388587925628302755995657524455507255189313690836254\
779186948667994968324049705821028513185451396213837722826145\
437693412532098591327667236328125001e-324L;
/* 0x1.8p-1074 */
static const long double ld2ae = 0x1p-1074L, ld2be = 0x2p-1074L, ld2ce = 0x2p-1074L;
static const long double ld2a =
7.4109846876186981626485318930233205854758970392148714663837\
852375101326090531312779794975454245398856969484704316857659\
638998506553390969459816219401617281718945106978546710679176\
872575177347315553307795408549809608457500958111373034747658\
096871009590975442271004757307809711118935784838675653998783\
503015228055934046593739791790738723868299395818481660169122\
019456499931289798411362062484498678713572180352209017023903\
285791732520220528974020802906854021606612375549983402671300\
035812486479041385743401875520901590172592547146296175134159\
774938718574737870961645638908718119841271673056017045493004\
705269590165763776884908267986972573366521765567941072508764\
337560846003984904972149117463085539556354188641513168478436\
313080237596295773983001708984374999e-324L;
static const long double ld2b =
7.4109846876186981626485318930233205854758970392148714663837\
852375101326090531312779794975454245398856969484704316857659\
638998506553390969459816219401617281718945106978546710679176\
872575177347315553307795408549809608457500958111373034747658\
096871009590975442271004757307809711118935784838675653998783\
503015228055934046593739791790738723868299395818481660169122\
019456499931289798411362062484498678713572180352209017023903\
285791732520220528974020802906854021606612375549983402671300\
035812486479041385743401875520901590172592547146296175134159\
774938718574737870961645638908718119841271673056017045493004\
705269590165763776884908267986972573366521765567941072508764\
337560846003984904972149117463085539556354188641513168478436\
313080237596295773983001708984375e-324L;
static const long double ld2c =
7.4109846876186981626485318930233205854758970392148714663837\
852375101326090531312779794975454245398856969484704316857659\
638998506553390969459816219401617281718945106978546710679176\
872575177347315553307795408549809608457500958111373034747658\
096871009590975442271004757307809711118935784838675653998783\
503015228055934046593739791790738723868299395818481660169122\
019456499931289798411362062484498678713572180352209017023903\
285791732520220528974020802906854021606612375549983402671300\
035812486479041385743401875520901590172592547146296175134159\
774938718574737870961645638908718119841271673056017045493004\
705269590165763776884908267986972573366521765567941072508764\
337560846003984904972149117463085539556354188641513168478436\
313080237596295773983001708984375001e-324L;
/* 0x1.00000000000008p1023 */
static const long double ld3ae = 0x1p1023L, ld3be = 0x1p1023L, ld3ce = 0x1.0000000000001p1023L;
static const long double ld3a =
8.9884656743115805365666807213050294962762414131308158973971\
342756154045415486693752413698006024096935349884403114202125\
541629105369684531108613657287705365884742938136589844238179\
474556051429647415148697857438797685859063890851407391008830\
874765563025951597582513936655578157348020066364210154316532\
161708031999e+307L;
static const long double ld3b =
8.9884656743115805365666807213050294962762414131308158973971\
342756154045415486693752413698006024096935349884403114202125\
541629105369684531108613657287705365884742938136589844238179\
474556051429647415148697857438797685859063890851407391008830\
874765563025951597582513936655578157348020066364210154316532\
161708032e+307L;
static const long double ld3c =
8.9884656743115805365666807213050294962762414131308158973971\
342756154045415486693752413698006024096935349884403114202125\
541629105369684531108613657287705365884742938136589844238179\
474556051429647415148697857438797685859063890851407391008830\
874765563025951597582513936655578157348020066364210154316532\
161708032001e+307L;
#endif

#if LDBL_MANT_DIG == 64 \
  && LDBL_MIN_EXP == -16381 \
  && LDBL_MAX_EXP == 16384
# define LDBL_OK
/* 0x0.8p-16445 */
static const long double ld1ae = 0, ld1be = 0, ld1ce = 0x1p-16445L;
static const long double ld1a =
1.8225997659412373012642029668097099081995254078467816718604\
902435141858443166988684047803543129136025986236736736017655\
509834928163110160849867540377949045027419112905889658392846\
126319028167798783107812829917053644701598967767636342956203\
999770864055077592691915230273843577112246476529298591341071\
313110337661777304220340396298768698441131694859514066773321\
059786469060001083813361460161387168195154228027648977594276\
496061276605855817438145692314650177569263750801566422892936\
732834290416745265618525969943519916542939199731612507343012\
297331882934352282118173551211985973294301787840335672389913\
821098681464088756477802684228806339233239542587316254618680\
197563613907079766830481997222017010585267442240109888818022\
189543438116245170584546472752661417773021275082355242554950\
776248474101880875363872607989624146320823364146896124171892\
610744237622308266702265704492674694505399997330424978964704\
335411125839490463131661420668167686151828553033363555080508\
484934542727634080467233927879117726432283352324546435315312\
937809651095964197873430398662003709663353962932921239516263\
008572512558260093668527782388349282015308359304941505110445\
043762021191469060607078792635897736408141163554429972292873\
575169264387977130124003958599909776720759582995017519144111\
001778329839793855454688442046155253818724410472281602421363\
580613990749181808302947976045417884436271162664776148749463\
202753814797191206392480969096910387729527305862739806702349\
088455828380471306603628636563037414688265702108098430515297\
645997107159687247830496686980315376091511219227376708389862\
310190633134517040835432587726931910775044780329777051964574\
763119639404235797665922677433332402402817037657141926646502\
612388421085254756323737273178774331073924707711575555193153\
421957126062196520952920611871114861423032687425262323243276\
848595495133802591437804984986053892365334900647137137197585\
161954823956838391108748154877098567190695813394392779995887\
642254413740232692940887236351533691174492514884514265006822\
752026136435469700291628942927286843274959781329315250417360\
438115330104516894597449604875954147108010051910197388860417\
003307595774863477182911525109554542883460240867674794470854\
883815424039187014069246137704710366577005576311674384079810\
437206511282792194562503036151028910065418370565117488062226\
073975854919243439941741016447206284543777826080409075756028\
194465562812076645422284670475730922346454505830553174377950\
824178034708147037448871898963699023373821217419560423459358\
846127232531421552826545954362386431279626917642725181802754\
271134597856231805666129524101509582941585421888561296839474\
232056474112935379177434928227554149402642893913492062781246\
372611175305462271711931011635602039137701669573065960945871\
579420683440097179831368317352157202215160682058878025153007\
184185319863451652087375936651004559837502483808090613073982\
264685620351993519454344577635257452328683726988824705474397\
398247190812883071734743260426540123481791283782928972842466\
595210269414219040901793935553872090377394005932597887081359\
481915849178541128182923272843218513093012167744690818603663\
862691727272565325057703378827553284852502067686026850339624\
401046086817036618366842240024522042069888708534827471235203\
998932259309110942367856287784097166420437430118381247339347\
418156902369282431197735078016591613063918260343498992697002\
033186558413655576703389208301203552157755701852051877927864\
696515420369217703510602759815252574799728706795849558382877\
392016396900560101736741462690753991602263974212137632508984\
264559315540891383192361601189350414311358816980975697568561\
515680971830107704152657284552920241862730125888825702301035\
564615759615882010733764341109834449576907982406265803484111\
303615971297609065271517286111839839646343815364461776394273\
571391219315553915335300622295196577640884201524657614065743\
729121754460652975075990012786021662416077757235487562550381\
116824006014440438178253273174734436163638119532295383351135\
543170811596051785036366846773285937845231974424475418970517\
659179798069972876889488877627309887323737590814875050457317\
809625163713227973229002908003491739085115971899606986738405\
752463436186745107821032315480693516006251388789902053863235\
071957895722121876262598833823352290042576488238120724072267\
480348425637199003147760378463243043407534395221882144887315\
875876025907739792297575795373506429192468470170038312050500\
917665707583420927303790875332407805094505665159755210495266\
485594187244922216154283213688032393939401426499517609275128\
062067355172333120857796045387692492375534056470145301671359\
016602832469675123108598588424022216759334733452626330303791\
660952659036162827509451468771297954737165701921676834866994\
084496268491510599580714458155026746676860790028899722645883\
679435969902046442373108472951515492761911884847211825930115\
654927539118088350255959445076757398298893380662248358210075\
297702191186519614515280395341723177201383862827129721649638\
274531314762377778754560119397123180107310216608157141828379\
259328274508467371717057031104537750450228447941619684073375\
630517322006118640290925241602376256334414376495602911265450\
165889418372161719063670619610214632774542741157366426747861\
054811449449004970132668146607323502760146957586465275981090\
328336256381187450646030492071694516054712444513961269623339\
705411366337817643269316717217432478812002049894979925260411\
553651385384826214231392012841425936827944383266227115236029\
717393064659821056467446870597828757433936024422511537561864\
619865595955628070343780472634463916608440151554502790128417\
277259492437005696576453717387309605129939526661181496994297\
244693710437436581443653555343763817246961834486181294985455\
884981266421533438177271809310897035958260776218253097858601\
160643120653927024652834025146166356877731266566437231429061\
099807825113272551869352908241073955695854354852545370793609\
838167127357752579007490955536081388103461735071174567636929\
060824172375010035497010614957197713919909924635906503348016\
450952475530978921242656498701313530533991692867619886826204\
706468476070943378163577235406861262755114909606255628375659\
196050370661430148107216310635729360112021571291096278032076\
401092225373270173950575377792566872113768085940991929655824\
050914085013970861399015141010432835406337266746706727481946\
196898882472095111505210339933002505227334750020285673634670\
738458390159933494226851499935336922036551687169140582574153\
726872453800858360764892975201757027862632615130256075468549\
502839367841926212872731925042838691319757663382746471782087\
828988857978192483595747889021081459460627705275735868618724\
958783348362295106875556443770626864591972089881215465141073\
516646930158996569747675806719463602045230325049794904894739\
988312727573320971310488326486213061839843830003145873279435\
454121817918269218294901387830156432148142381592864575229119\
479029130050663564889172093067341444164942736885872753984012\
865743421266470861425283889134636885790293235727017788606167\
560012477186697069994213912998550931078617189790771376702549\
055361745205232419031423044366971378594392952093464046441667\
117613906203494872209149396518971207279263883566606774353236\
255473603377861613942239543893894460581170658088042083661404\
937465706659424639301296621963906278930754459296017486063079\
582024995485338893699574289806529424673393810217577605952909\
491283123179789154639057105774960699934999681018155749261864\
012821574480758746632022143860041252142846691648490809250856\
327057133540568617791625295314357533564192304930155735301757\
457531580062662693966772497728335047637869054460240023262262\
260698443946964564691259441706490611176164305693669515767804\
836460521205954731752583848846525153811934541997962775215961\
180346397456122329133421016560406277159258781706172834569862\
946953007793254152187010227976038449980797987728559041018441\
590564594738308310579014597893182017151615208050090318483536\
106249131918576316944251537092347119867433735046169725181104\
507590928834713669184230634083190791725243913641206256399101\
550966117564795555149420011152858441084271411289366093158722\
254752761637144762690747726313899449121995142565661043193165\
353010677613760383307839362361625628371456344409245507081913\
518237257141164239966660785903970075181826808229440731778746\
830751045427285945936163931997929399708401851740705527023711\
492262489476846435969872480702228386506357017948329114555484\
164760105906717855684788039081591713778852802032849601308169\
832017420608399347713424218434541771868442189843417628618330\
607429739733739437863581804003482214082370567967330530446020\
897773385726872912189813323094415093143437550397556262780011\
208941731420098754319961419532567861629590267320403217607660\
774125374101195389953895035347940170148097810952083736798564\
420421622607993390894450932047257403433908665884124601384175\
012387617430467934818665777122459487877479257747635172691688\
471574765285820096075133353869554987216398800026453207557923\
535966131756358352198875705382763163680830588056974671628368\
719411827591592806044707764658145625683998557872894583705117\
936257144994734815912058252772021032081682437093280526665192\
728869800954748014250481042845426151143544474372887617562791\
409866964806319608280819816846942058817381943129762034507591\
367065185343216917751414811188645979508942996964383255432999\
246119971295726296202396921903289017490293595312645036697141\
581149988784499288560584613793415358537364677872496224892098\
940856692342358755626519304557946447004033186014602147449599\
351317079758304444877174136521487256811625263467410007624215\
856145392339552689565690577293133060124853654497575571509576\
408069646196646757505249296126372820539234090564691695806544\
715766025588258581902342311480969412221466852421842650484494\
063894865891424563992751226230317059592413191308470146226366\
458233536657973376067140793776369412191789801225320255079444\
592709005698858098716107025188986428347407279053266600044521\
079987989879536957560131070100060050673537683871138182387904\
590837539252425985326631955455857258818756188063697492342550\
045277400125480079927908846850898283905756532829762950509886\
991675925213188409911532242068610889478326451513981115020992\
630395715520350039372702741107911736947893709538471200363740\
669304116845653259038102180504837110789645359520309929381266\
271463740502507456882882255788069710715770802338317704510793\
279398576163709512326095306022330346997717688118726634628650\
675984237916551201500684504118483305560295744746257951860545\
390826531622290588364837980034428055971370065573420370270905\
592141420051502465016793525150950140243606137664910359769114\
512792293426708006440346732679574519594848136194781488696994\
267355775509666977187349644291823026624985531726865131782364\
428380093055155988532106121916567178604128111080322761213573\
781334480667563871257352254033032675246444238637990062075058\
819854494711379915549313390179300091783493496822950479766923\
983305064901026858870340863556799948310622536592472509634484\
910640735459644047154918467543140024764605449756679450446473\
048922824617117723876384637412932380635306714345354710568410\
140587435077620501285599837051978855056335305570615129711860\
309387503970812843734718712815925040263182888714533431137355\
255722368962836390856001176889513153529416105504464217522618\
741534232432067776306691118141998014985541610448993152948945\
865983354717289054861249734477980864059509622993770525110616\
313865830823478927462500895844216364365499438449134659145333\
799994034010282254566331595018205841080487728993632798168070\
476921205941768965021887178681810499301253039335978279707627\
295287697256489961179958946847840431902105306618594831078534\
622089641993900896756734276531931450266972752637997248151974\
2277811246822238899767398834228515624999e-4951L;
static const long double ld1b =
1.8225997659412373012642029668097099081995254078467816718604\
902435141858443166988684047803543129136025986236736736017655\
509834928163110160849867540377949045027419112905889658392846\
126319028167798783107812829917053644701598967767636342956203\
999770864055077592691915230273843577112246476529298591341071\
313110337661777304220340396298768698441131694859514066773321\
059786469060001083813361460161387168195154228027648977594276\
496061276605855817438145692314650177569263750801566422892936\
732834290416745265618525969943519916542939199731612507343012\
297331882934352282118173551211985973294301787840335672389913\
821098681464088756477802684228806339233239542587316254618680\
197563613907079766830481997222017010585267442240109888818022\
189543438116245170584546472752661417773021275082355242554950\
776248474101880875363872607989624146320823364146896124171892\
610744237622308266702265704492674694505399997330424978964704\
335411125839490463131661420668167686151828553033363555080508\
484934542727634080467233927879117726432283352324546435315312\
937809651095964197873430398662003709663353962932921239516263\
008572512558260093668527782388349282015308359304941505110445\
043762021191469060607078792635897736408141163554429972292873\
575169264387977130124003958599909776720759582995017519144111\
001778329839793855454688442046155253818724410472281602421363\
580613990749181808302947976045417884436271162664776148749463\
202753814797191206392480969096910387729527305862739806702349\
088455828380471306603628636563037414688265702108098430515297\
645997107159687247830496686980315376091511219227376708389862\
310190633134517040835432587726931910775044780329777051964574\
763119639404235797665922677433332402402817037657141926646502\
612388421085254756323737273178774331073924707711575555193153\
421957126062196520952920611871114861423032687425262323243276\
848595495133802591437804984986053892365334900647137137197585\
161954823956838391108748154877098567190695813394392779995887\
642254413740232692940887236351533691174492514884514265006822\
752026136435469700291628942927286843274959781329315250417360\
438115330104516894597449604875954147108010051910197388860417\
003307595774863477182911525109554542883460240867674794470854\
883815424039187014069246137704710366577005576311674384079810\
437206511282792194562503036151028910065418370565117488062226\
073975854919243439941741016447206284543777826080409075756028\
194465562812076645422284670475730922346454505830553174377950\
824178034708147037448871898963699023373821217419560423459358\
846127232531421552826545954362386431279626917642725181802754\
271134597856231805666129524101509582941585421888561296839474\
232056474112935379177434928227554149402642893913492062781246\
372611175305462271711931011635602039137701669573065960945871\
579420683440097179831368317352157202215160682058878025153007\
184185319863451652087375936651004559837502483808090613073982\
264685620351993519454344577635257452328683726988824705474397\
398247190812883071734743260426540123481791283782928972842466\
595210269414219040901793935553872090377394005932597887081359\
481915849178541128182923272843218513093012167744690818603663\
862691727272565325057703378827553284852502067686026850339624\
401046086817036618366842240024522042069888708534827471235203\
998932259309110942367856287784097166420437430118381247339347\
418156902369282431197735078016591613063918260343498992697002\
033186558413655576703389208301203552157755701852051877927864\
696515420369217703510602759815252574799728706795849558382877\
392016396900560101736741462690753991602263974212137632508984\
264559315540891383192361601189350414311358816980975697568561\
515680971830107704152657284552920241862730125888825702301035\
564615759615882010733764341109834449576907982406265803484111\
303615971297609065271517286111839839646343815364461776394273\
571391219315553915335300622295196577640884201524657614065743\
729121754460652975075990012786021662416077757235487562550381\
116824006014440438178253273174734436163638119532295383351135\
543170811596051785036366846773285937845231974424475418970517\
659179798069972876889488877627309887323737590814875050457317\
809625163713227973229002908003491739085115971899606986738405\
752463436186745107821032315480693516006251388789902053863235\
071957895722121876262598833823352290042576488238120724072267\
480348425637199003147760378463243043407534395221882144887315\
875876025907739792297575795373506429192468470170038312050500\
917665707583420927303790875332407805094505665159755210495266\
485594187244922216154283213688032393939401426499517609275128\
062067355172333120857796045387692492375534056470145301671359\
016602832469675123108598588424022216759334733452626330303791\
660952659036162827509451468771297954737165701921676834866994\
084496268491510599580714458155026746676860790028899722645883\
679435969902046442373108472951515492761911884847211825930115\
654927539118088350255959445076757398298893380662248358210075\
297702191186519614515280395341723177201383862827129721649638\
274531314762377778754560119397123180107310216608157141828379\
259328274508467371717057031104537750450228447941619684073375\
630517322006118640290925241602376256334414376495602911265450\
165889418372161719063670619610214632774542741157366426747861\
054811449449004970132668146607323502760146957586465275981090\
328336256381187450646030492071694516054712444513961269623339\
705411366337817643269316717217432478812002049894979925260411\
553651385384826214231392012841425936827944383266227115236029\
717393064659821056467446870597828757433936024422511537561864\
619865595955628070343780472634463916608440151554502790128417\
277259492437005696576453717387309605129939526661181496994297\
244693710437436581443653555343763817246961834486181294985455\
884981266421533438177271809310897035958260776218253097858601\
160643120653927024652834025146166356877731266566437231429061\
099807825113272551869352908241073955695854354852545370793609\
838167127357752579007490955536081388103461735071174567636929\
060824172375010035497010614957197713919909924635906503348016\
450952475530978921242656498701313530533991692867619886826204\
706468476070943378163577235406861262755114909606255628375659\
196050370661430148107216310635729360112021571291096278032076\
401092225373270173950575377792566872113768085940991929655824\
050914085013970861399015141010432835406337266746706727481946\
196898882472095111505210339933002505227334750020285673634670\
738458390159933494226851499935336922036551687169140582574153\
726872453800858360764892975201757027862632615130256075468549\
502839367841926212872731925042838691319757663382746471782087\
828988857978192483595747889021081459460627705275735868618724\
958783348362295106875556443770626864591972089881215465141073\
516646930158996569747675806719463602045230325049794904894739\
988312727573320971310488326486213061839843830003145873279435\
454121817918269218294901387830156432148142381592864575229119\
479029130050663564889172093067341444164942736885872753984012\
865743421266470861425283889134636885790293235727017788606167\
560012477186697069994213912998550931078617189790771376702549\
055361745205232419031423044366971378594392952093464046441667\
117613906203494872209149396518971207279263883566606774353236\
255473603377861613942239543893894460581170658088042083661404\
937465706659424639301296621963906278930754459296017486063079\
582024995485338893699574289806529424673393810217577605952909\
491283123179789154639057105774960699934999681018155749261864\
012821574480758746632022143860041252142846691648490809250856\
327057133540568617791625295314357533564192304930155735301757\
457531580062662693966772497728335047637869054460240023262262\
260698443946964564691259441706490611176164305693669515767804\
836460521205954731752583848846525153811934541997962775215961\
180346397456122329133421016560406277159258781706172834569862\
946953007793254152187010227976038449980797987728559041018441\
590564594738308310579014597893182017151615208050090318483536\
106249131918576316944251537092347119867433735046169725181104\
507590928834713669184230634083190791725243913641206256399101\
550966117564795555149420011152858441084271411289366093158722\
254752761637144762690747726313899449121995142565661043193165\
353010677613760383307839362361625628371456344409245507081913\
518237257141164239966660785903970075181826808229440731778746\
830751045427285945936163931997929399708401851740705527023711\
492262489476846435969872480702228386506357017948329114555484\
164760105906717855684788039081591713778852802032849601308169\
832017420608399347713424218434541771868442189843417628618330\
607429739733739437863581804003482214082370567967330530446020\
897773385726872912189813323094415093143437550397556262780011\
208941731420098754319961419532567861629590267320403217607660\
774125374101195389953895035347940170148097810952083736798564\
420421622607993390894450932047257403433908665884124601384175\
012387617430467934818665777122459487877479257747635172691688\
471574765285820096075133353869554987216398800026453207557923\
535966131756358352198875705382763163680830588056974671628368\
719411827591592806044707764658145625683998557872894583705117\
936257144994734815912058252772021032081682437093280526665192\
728869800954748014250481042845426151143544474372887617562791\
409866964806319608280819816846942058817381943129762034507591\
367065185343216917751414811188645979508942996964383255432999\
246119971295726296202396921903289017490293595312645036697141\
581149988784499288560584613793415358537364677872496224892098\
940856692342358755626519304557946447004033186014602147449599\
351317079758304444877174136521487256811625263467410007624215\
856145392339552689565690577293133060124853654497575571509576\
408069646196646757505249296126372820539234090564691695806544\
715766025588258581902342311480969412221466852421842650484494\
063894865891424563992751226230317059592413191308470146226366\
458233536657973376067140793776369412191789801225320255079444\
592709005698858098716107025188986428347407279053266600044521\
079987989879536957560131070100060050673537683871138182387904\
590837539252425985326631955455857258818756188063697492342550\
045277400125480079927908846850898283905756532829762950509886\
991675925213188409911532242068610889478326451513981115020992\
630395715520350039372702741107911736947893709538471200363740\
669304116845653259038102180504837110789645359520309929381266\
271463740502507456882882255788069710715770802338317704510793\
279398576163709512326095306022330346997717688118726634628650\
675984237916551201500684504118483305560295744746257951860545\
390826531622290588364837980034428055971370065573420370270905\
592141420051502465016793525150950140243606137664910359769114\
512792293426708006440346732679574519594848136194781488696994\
267355775509666977187349644291823026624985531726865131782364\
428380093055155988532106121916567178604128111080322761213573\
781334480667563871257352254033032675246444238637990062075058\
819854494711379915549313390179300091783493496822950479766923\
983305064901026858870340863556799948310622536592472509634484\
910640735459644047154918467543140024764605449756679450446473\
048922824617117723876384637412932380635306714345354710568410\
140587435077620501285599837051978855056335305570615129711860\
309387503970812843734718712815925040263182888714533431137355\
255722368962836390856001176889513153529416105504464217522618\
741534232432067776306691118141998014985541610448993152948945\
865983354717289054861249734477980864059509622993770525110616\
313865830823478927462500895844216364365499438449134659145333\
799994034010282254566331595018205841080487728993632798168070\
476921205941768965021887178681810499301253039335978279707627\
295287697256489961179958946847840431902105306618594831078534\
622089641993900896756734276531931450266972752637997248151974\
2277811246822238899767398834228515625e-4951L;
static const long double ld1c =
1.8225997659412373012642029668097099081995254078467816718604\
902435141858443166988684047803543129136025986236736736017655\
509834928163110160849867540377949045027419112905889658392846\
126319028167798783107812829917053644701598967767636342956203\
999770864055077592691915230273843577112246476529298591341071\
313110337661777304220340396298768698441131694859514066773321\
059786469060001083813361460161387168195154228027648977594276\
496061276605855817438145692314650177569263750801566422892936\
732834290416745265618525969943519916542939199731612507343012\
297331882934352282118173551211985973294301787840335672389913\
821098681464088756477802684228806339233239542587316254618680\
197563613907079766830481997222017010585267442240109888818022\
189543438116245170584546472752661417773021275082355242554950\
776248474101880875363872607989624146320823364146896124171892\
610744237622308266702265704492674694505399997330424978964704\
335411125839490463131661420668167686151828553033363555080508\
484934542727634080467233927879117726432283352324546435315312\
937809651095964197873430398662003709663353962932921239516263\
008572512558260093668527782388349282015308359304941505110445\
043762021191469060607078792635897736408141163554429972292873\
575169264387977130124003958599909776720759582995017519144111\
001778329839793855454688442046155253818724410472281602421363\
580613990749181808302947976045417884436271162664776148749463\
202753814797191206392480969096910387729527305862739806702349\
088455828380471306603628636563037414688265702108098430515297\
645997107159687247830496686980315376091511219227376708389862\
310190633134517040835432587726931910775044780329777051964574\
763119639404235797665922677433332402402817037657141926646502\
612388421085254756323737273178774331073924707711575555193153\
421957126062196520952920611871114861423032687425262323243276\
848595495133802591437804984986053892365334900647137137197585\
161954823956838391108748154877098567190695813394392779995887\
642254413740232692940887236351533691174492514884514265006822\
752026136435469700291628942927286843274959781329315250417360\
438115330104516894597449604875954147108010051910197388860417\
003307595774863477182911525109554542883460240867674794470854\
883815424039187014069246137704710366577005576311674384079810\
437206511282792194562503036151028910065418370565117488062226\
073975854919243439941741016447206284543777826080409075756028\
194465562812076645422284670475730922346454505830553174377950\
824178034708147037448871898963699023373821217419560423459358\
846127232531421552826545954362386431279626917642725181802754\
271134597856231805666129524101509582941585421888561296839474\
232056474112935379177434928227554149402642893913492062781246\
372611175305462271711931011635602039137701669573065960945871\
579420683440097179831368317352157202215160682058878025153007\
184185319863451652087375936651004559837502483808090613073982\
264685620351993519454344577635257452328683726988824705474397\
398247190812883071734743260426540123481791283782928972842466\
595210269414219040901793935553872090377394005932597887081359\
481915849178541128182923272843218513093012167744690818603663\
862691727272565325057703378827553284852502067686026850339624\
401046086817036618366842240024522042069888708534827471235203\
998932259309110942367856287784097166420437430118381247339347\
418156902369282431197735078016591613063918260343498992697002\
033186558413655576703389208301203552157755701852051877927864\
696515420369217703510602759815252574799728706795849558382877\
392016396900560101736741462690753991602263974212137632508984\
264559315540891383192361601189350414311358816980975697568561\
515680971830107704152657284552920241862730125888825702301035\
564615759615882010733764341109834449576907982406265803484111\
303615971297609065271517286111839839646343815364461776394273\
571391219315553915335300622295196577640884201524657614065743\
729121754460652975075990012786021662416077757235487562550381\
116824006014440438178253273174734436163638119532295383351135\
543170811596051785036366846773285937845231974424475418970517\
659179798069972876889488877627309887323737590814875050457317\
809625163713227973229002908003491739085115971899606986738405\
752463436186745107821032315480693516006251388789902053863235\
071957895722121876262598833823352290042576488238120724072267\
480348425637199003147760378463243043407534395221882144887315\
875876025907739792297575795373506429192468470170038312050500\
917665707583420927303790875332407805094505665159755210495266\
485594187244922216154283213688032393939401426499517609275128\
062067355172333120857796045387692492375534056470145301671359\
016602832469675123108598588424022216759334733452626330303791\
660952659036162827509451468771297954737165701921676834866994\
084496268491510599580714458155026746676860790028899722645883\
679435969902046442373108472951515492761911884847211825930115\
654927539118088350255959445076757398298893380662248358210075\
297702191186519614515280395341723177201383862827129721649638\
274531314762377778754560119397123180107310216608157141828379\
259328274508467371717057031104537750450228447941619684073375\
630517322006118640290925241602376256334414376495602911265450\
165889418372161719063670619610214632774542741157366426747861\
054811449449004970132668146607323502760146957586465275981090\
328336256381187450646030492071694516054712444513961269623339\
705411366337817643269316717217432478812002049894979925260411\
553651385384826214231392012841425936827944383266227115236029\
717393064659821056467446870597828757433936024422511537561864\
619865595955628070343780472634463916608440151554502790128417\
277259492437005696576453717387309605129939526661181496994297\
244693710437436581443653555343763817246961834486181294985455\
884981266421533438177271809310897035958260776218253097858601\
160643120653927024652834025146166356877731266566437231429061\
099807825113272551869352908241073955695854354852545370793609\
838167127357752579007490955536081388103461735071174567636929\
060824172375010035497010614957197713919909924635906503348016\
450952475530978921242656498701313530533991692867619886826204\
706468476070943378163577235406861262755114909606255628375659\
196050370661430148107216310635729360112021571291096278032076\
401092225373270173950575377792566872113768085940991929655824\
050914085013970861399015141010432835406337266746706727481946\
196898882472095111505210339933002505227334750020285673634670\
738458390159933494226851499935336922036551687169140582574153\
726872453800858360764892975201757027862632615130256075468549\
502839367841926212872731925042838691319757663382746471782087\
828988857978192483595747889021081459460627705275735868618724\
958783348362295106875556443770626864591972089881215465141073\
516646930158996569747675806719463602045230325049794904894739\
988312727573320971310488326486213061839843830003145873279435\
454121817918269218294901387830156432148142381592864575229119\
479029130050663564889172093067341444164942736885872753984012\
865743421266470861425283889134636885790293235727017788606167\
560012477186697069994213912998550931078617189790771376702549\
055361745205232419031423044366971378594392952093464046441667\
117613906203494872209149396518971207279263883566606774353236\
255473603377861613942239543893894460581170658088042083661404\
937465706659424639301296621963906278930754459296017486063079\
582024995485338893699574289806529424673393810217577605952909\
491283123179789154639057105774960699934999681018155749261864\
012821574480758746632022143860041252142846691648490809250856\
327057133540568617791625295314357533564192304930155735301757\
457531580062662693966772497728335047637869054460240023262262\
260698443946964564691259441706490611176164305693669515767804\
836460521205954731752583848846525153811934541997962775215961\
180346397456122329133421016560406277159258781706172834569862\
946953007793254152187010227976038449980797987728559041018441\
590564594738308310579014597893182017151615208050090318483536\
106249131918576316944251537092347119867433735046169725181104\
507590928834713669184230634083190791725243913641206256399101\
550966117564795555149420011152858441084271411289366093158722\
254752761637144762690747726313899449121995142565661043193165\
353010677613760383307839362361625628371456344409245507081913\
518237257141164239966660785903970075181826808229440731778746\
830751045427285945936163931997929399708401851740705527023711\
492262489476846435969872480702228386506357017948329114555484\
164760105906717855684788039081591713778852802032849601308169\
832017420608399347713424218434541771868442189843417628618330\
607429739733739437863581804003482214082370567967330530446020\
897773385726872912189813323094415093143437550397556262780011\
208941731420098754319961419532567861629590267320403217607660\
774125374101195389953895035347940170148097810952083736798564\
420421622607993390894450932047257403433908665884124601384175\
012387617430467934818665777122459487877479257747635172691688\
471574765285820096075133353869554987216398800026453207557923\
535966131756358352198875705382763163680830588056974671628368\
719411827591592806044707764658145625683998557872894583705117\
936257144994734815912058252772021032081682437093280526665192\
728869800954748014250481042845426151143544474372887617562791\
409866964806319608280819816846942058817381943129762034507591\
367065185343216917751414811188645979508942996964383255432999\
246119971295726296202396921903289017490293595312645036697141\
581149988784499288560584613793415358537364677872496224892098\
940856692342358755626519304557946447004033186014602147449599\
351317079758304444877174136521487256811625263467410007624215\
856145392339552689565690577293133060124853654497575571509576\
408069646196646757505249296126372820539234090564691695806544\
715766025588258581902342311480969412221466852421842650484494\
063894865891424563992751226230317059592413191308470146226366\
458233536657973376067140793776369412191789801225320255079444\
592709005698858098716107025188986428347407279053266600044521\
079987989879536957560131070100060050673537683871138182387904\
590837539252425985326631955455857258818756188063697492342550\
045277400125480079927908846850898283905756532829762950509886\
991675925213188409911532242068610889478326451513981115020992\
630395715520350039372702741107911736947893709538471200363740\
669304116845653259038102180504837110789645359520309929381266\
271463740502507456882882255788069710715770802338317704510793\
279398576163709512326095306022330346997717688118726634628650\
675984237916551201500684504118483305560295744746257951860545\
390826531622290588364837980034428055971370065573420370270905\
592141420051502465016793525150950140243606137664910359769114\
512792293426708006440346732679574519594848136194781488696994\
267355775509666977187349644291823026624985531726865131782364\
428380093055155988532106121916567178604128111080322761213573\
781334480667563871257352254033032675246444238637990062075058\
819854494711379915549313390179300091783493496822950479766923\
983305064901026858870340863556799948310622536592472509634484\
910640735459644047154918467543140024764605449756679450446473\
048922824617117723876384637412932380635306714345354710568410\
140587435077620501285599837051978855056335305570615129711860\
309387503970812843734718712815925040263182888714533431137355\
255722368962836390856001176889513153529416105504464217522618\
741534232432067776306691118141998014985541610448993152948945\
865983354717289054861249734477980864059509622993770525110616\
313865830823478927462500895844216364365499438449134659145333\
799994034010282254566331595018205841080487728993632798168070\
476921205941768965021887178681810499301253039335978279707627\
295287697256489961179958946847840431902105306618594831078534\
622089641993900896756734276531931450266972752637997248151974\
2277811246822238899767398834228515625001e-4951L;
/* 0x1.8p-16445 */
static const long double ld2ae = 0x1p-16445L, ld2be = 0x2p-16445L, ld2ce = 0x2p-16445L;
static const long double ld2a =
5.4677992978237119037926089004291297245985762235403450155814\
707305425575329500966052143410629387408077958710210208052966\
529504784489330482549602621133847135082257338717668975178538\
378957084503396349323438489751160934104796903302909028868611\
999312592165232778075745690821530731336739429587895774023213\
939331012985331912661021188896306095323395084578542200319963\
179359407180003251440084380484161504585462684082946932782829\
488183829817567452314437076943950532707791252404699268678810\
198502871250235796855577909830559749628817599194837522029036\
891995648803056846354520653635957919882905363521007017169741\
463296044392266269433408052686419017699718627761948763856040\
592690841721239300491445991666051031755802326720329666454066\
568630314348735511753639418257984253319063825247065727664852\
328745422305642626091617823968872438962470092440688372515677\
832232712866924800106797113478024083516199991991274936894113\
006233377518471389394984262004503058455485659100090665241525\
454803628182902241401701783637353179296850056973639305945938\
813428953287892593620291195986011128990061888798763718548789\
025717537674780281005583347165047846045925077914824515331335\
131286063574407181821236377907693209224423490663289916878620\
725507793163931390372011875799729330162278748985052557432333\
005334989519381566364065326138465761456173231416844807264090\
741841972247545424908843928136253653308813487994328446248389\
608261444391573619177442907290731163188581917588219420107047\
265367485141413919810885909689112244064797106324295291545892\
937991321479061743491490060940946128274533657682130125169586\
930571899403551122506297763180795732325134340989331155893724\
289358918212707392997768032299997207208451112971425779939507\
837165263255764268971211819536322993221774123134726665579460\
265871378186589562858761835613344584269098062275786969729830\
545786485401407774313414954958161677096004701941411411592755\
485864471870515173326244464631295701572087440183178339987662\
926763241220698078822661709054601073523477544653542795020468\
256078409306409100874886828781860529824879343987945751252081\
314345990313550683792348814627862441324030155730592166581251\
009922787324590431548734575328663628650380722603024383412564\
651446272117561042207738413114131099731016728935023152239431\
311619533848376583687509108453086730196255111695352464186678\
221927564757730319825223049341618853631333478241227227268084\
583396688436229936266854011427192767039363517491659523133852\
472534104124441112346615696891097070121463652258681270378076\
538381697594264658479637863087159293838880752928175545408262\
813403793568695416998388572304528748824756265665683890518422\
696169422338806137532304784682662448207928681740476188343739\
117833525916386815135793034906806117413105008719197882837614\
738262050320291539494104952056471606645482046176634075459021\
552555959590354956262127809953013679512507451424271839221946\
794056861055980558363033732905772356986051180966474116423192\
194741572438649215204229781279620370445373851348786918527399\
785630808242657122705381806661616271132182017797793661244078\
445747547535623384548769818529655539279036503234072455810991\
588075181817695975173110136482659854557506203058080551018873\
203138260451109855100526720073566126209666125604482413705611\
996796777927332827103568863352291499261312290355143742018042\
254470707107847293593205234049774839191754781030496978091006\
099559675240966730110167624903610656473267105556155633783594\
089546261107653110531808279445757724399186120387548675148632\
176049190701680305210224388072261974806791922636412897526952\
793677946622674149577084803568051242934076450942927092705684\
547042915490323112457971853658760725588190377666477106903106\
693847278847646032201293023329503348730723947218797410452333\
910847913892827195814551858335519518939031446093385329182820\
714173657946661746005901866885589732922652604573972842197231\
187365263381958925227970038358064987248233271706462687651143\
350472018043321314534759819524203308490914358596886150053406\
629512434788155355109100540319857813535695923273426256911552\
977539394209918630668466632881929661971212772444625151371953\
428875491139683919687008724010475217255347915698820960215217\
257390308560235323463096946442080548018754166369706161589705\
215873687166365628787796501470056870127729464714362172216802\
441045276911597009443281135389729130222603185665646434661947\
627628077723219376892727386120519287577405410510114936151502\
752997122750262781911372625997223415283516995479265631485799\
456782561734766648462849641064097181818204279498552827825384\
186202065516999362573388136163077477126602169410435905014077\
049808497409025369325795765272066650278004200357878990911374\
982857977108488482528354406313893864211497105765030504600982\
253488805474531798742143374465080240030582370086699167937651\
038307909706139327119325418854546478285735654541635477790346\
964782617354265050767878335230272194896680141986745074630225\
893106573559558843545841186025169531604151588481389164948914\
823593944287133336263680358191369540321930649824471425485137\
777984823525402115151171093313613251350685343824859052220126\
891551966018355920872775724807128769003243129486808733796350\
497668255116485157191011858830643898323628223472099280243583\
164434348347014910398004439821970508280440872759395827943270\
985008769143562351938091476215083548164137333541883808870019\
116234099013452929807950151652297436436006149684939775781234\
660954156154478642694176038524277810483833149798681345708089\
152179193979463169402340611793486272301808073267534612685593\
859596787866884211031341417903391749825320454663508370385251\
831778477311017089729361152161928815389818579983544490982891\
734081131312309744330960666031291451740885503458543884956367\
654943799264600314531815427932691107874782328654759293575803\
481929361961781073958502075438499070633193799699311694287183\
299423475339817655608058724723221867087563064557636112380829\
514501382073257737022472866608244164310385205213523702910787\
182472517125030106491031844871593141759729773907719510044049\
352857426592936763727969496103940591601975078602859660478614\
119405428212830134490731706220583788265344728818766885126977\
588151111984290444321648931907188080336064713873288834096229\
203276676119810521851726133377700616341304257822975788967472\
152742255041912584197045423031298506219011800240120182445838\
590696647416285334515631019799007515682004250060857020904012\
215375170479800482680554499806010766109655061507421747722461\
180617361402575082294678925605271083587897845390768226405648\
508518103525778638618195775128516073959272990148239415346263\
486966573934577450787243667063244378381883115827207605856174\
876350045086885320626669331311880593775916269643646395423220\
549940790476989709243027420158390806135690975149384714684219\
964938182719962913931464979458639185519531490009437619838306\
362365453754807654884704163490469296444427144778593725687358\
437087390151990694667516279202024332494828210657618261952038\
597230263799412584275851667403910657370879707181053365818502\
680037431560091209982641738995652793235851569372314130107647\
166085235615697257094269133100914135783178856280392139325001\
352841718610484616627448189556913621837791650699820323059708\
766420810133584841826718631681683381743511974264126250984214\
812397119978273917903889865891718836792263377888052458189238\
746074986456016681098722869419588274020181430652732817858728\
473849369539367463917171317324882099804999043054467247785592\
038464723442276239896066431580123756428540074945472427752568\
981171400621705853374875885943072600692576914790467205905272\
372594740187988081900317493185005142913607163380720069786786\
782095331840893694073778325119471833528492917081008547303414\
509381563617864195257751546539575461435803625993888325647883\
541039192368366987400263049681218831477776345118518503709588\
840859023379762456561030683928115349942393963185677123055324\
771693784214924931737043793679546051454845624150270955450608\
318747395755728950832754611277041359602301205138509175543313\
522772786504141007552691902249572375175731740923618769197304\
652898352694386665448260033458575323252814233868098279476166\
764258284911434288072243178941698347365985427696983129579496\
059032032841281149923518087084876885114369033227736521245740\
554711771423492719899982357711910225545480424688322195336240\
492253136281857837808491795993788199125205555222116581071134\
476787468430539307909617442106685159519071053844987343666452\
494280317720153567054364117244775141336558406098548803924509\
496052261825198043140272655303625315605326569530252885854991\
822289219201218313590745412010446642247111703901991591338062\
693320157180618736569439969283245279430312651192668788340033\
626825194260296262959884258597703584888770801961209652822982\
322376122303586169861685106043820510444293432856251210395693\
261264867823980172683352796141772210301725997652373804152525\
037162852291403804455997331367378463632437773242905518075065\
414724295857460288225400061608664961649196400079359622673770\
607898395269075056596627116148289491042491764170924014885106\
158235482774778418134123293974436877051995673618683751115353\
808771434984204447736174758316063096245047311279841579995578\
186609402864244042751443128536278453430633423118662852688374\
229600894418958824842459450540826176452145829389286103522774\
101195556029650753254244433565937938526828990893149766298997\
738359913887178888607190765709867052470880785937935110091424\
743449966353497865681753841380246075612094033617488674676296\
822570077027076266879557913673839341012099558043806442348798\
053951239274913334631522409564461770434875790402230022872647\
568436177018658068697071731879399180374560963492726714528729\
224208938589940272515747888379118461617702271694075087419634\
147298076764775745707026934442908236664400557265527951453482\
191684597674273691978253678690951178777239573925410438679099\
374700609973920128201422381329108236575369403675960765238333\
778127017096574296148321075566959285042221837159799800133563\
239963969638610872680393210300180152020613051613414547163713\
772512617757277955979895866367571776456268564191092477027650\
135832200376440239783726540552694851717269598489288851529660\
975027775639565229734596726205832668434979354541943345062977\
891187146561050118118108223323735210843681128615413601091222\
007912350536959777114306541514511332368936078560929788143798\
814391221507522370648646767364209132147312407014953113532379\
838195728491128536978285918066991040993153064356179903885952\
027952713749653604502053512355449916680887234238773855581636\
172479594866871765094513940103284167914110196720261110812716\
776424260154507395050380575452850420730818412994731079307343\
538376880280124019321040198038723558784544408584344466090982\
802067326529000931562048932875469079874956595180595395347093\
285140279165467965596318365749701535812384333240968283640721\
344003442002691613772056762099098025739332715913970186225176\
459563484134139746647940170537900275350480490468851439300771\
949915194703080576611022590670399844931867609777417528903454\
731922206378932141464755402629420074293816349270038351339419\
146768473851353171629153912238797141905920143036064131705230\
421762305232861503856799511155936565169005916711845389135580\
928162511912438531204156138447775120789548666143600293412065\
767167106888509172568003530668539460588248316513392652567856\
224602697296203328920073354425994044956624831346979458846837\
597950064151867164583749203433942592178528868981311575331848\
941597492470436782387502687532649093096498315347403977436001\
399982102030846763698994785054617523241463186980898394504211\
430763617825306895065661536045431497903759118007934839122881\
885863091769469883539876840543521295706315919855784493235603\
866268925981702690270202829595794350800918257913991744455922\
6833433740466716699302196502685546874999e-4951L;
static const long double ld2b =
5.4677992978237119037926089004291297245985762235403450155814\
707305425575329500966052143410629387408077958710210208052966\
529504784489330482549602621133847135082257338717668975178538\
378957084503396349323438489751160934104796903302909028868611\
999312592165232778075745690821530731336739429587895774023213\
939331012985331912661021188896306095323395084578542200319963\
179359407180003251440084380484161504585462684082946932782829\
488183829817567452314437076943950532707791252404699268678810\
198502871250235796855577909830559749628817599194837522029036\
891995648803056846354520653635957919882905363521007017169741\
463296044392266269433408052686419017699718627761948763856040\
592690841721239300491445991666051031755802326720329666454066\
568630314348735511753639418257984253319063825247065727664852\
328745422305642626091617823968872438962470092440688372515677\
832232712866924800106797113478024083516199991991274936894113\
006233377518471389394984262004503058455485659100090665241525\
454803628182902241401701783637353179296850056973639305945938\
813428953287892593620291195986011128990061888798763718548789\
025717537674780281005583347165047846045925077914824515331335\
131286063574407181821236377907693209224423490663289916878620\
725507793163931390372011875799729330162278748985052557432333\
005334989519381566364065326138465761456173231416844807264090\
741841972247545424908843928136253653308813487994328446248389\
608261444391573619177442907290731163188581917588219420107047\
265367485141413919810885909689112244064797106324295291545892\
937991321479061743491490060940946128274533657682130125169586\
930571899403551122506297763180795732325134340989331155893724\
289358918212707392997768032299997207208451112971425779939507\
837165263255764268971211819536322993221774123134726665579460\
265871378186589562858761835613344584269098062275786969729830\
545786485401407774313414954958161677096004701941411411592755\
485864471870515173326244464631295701572087440183178339987662\
926763241220698078822661709054601073523477544653542795020468\
256078409306409100874886828781860529824879343987945751252081\
314345990313550683792348814627862441324030155730592166581251\
009922787324590431548734575328663628650380722603024383412564\
651446272117561042207738413114131099731016728935023152239431\
311619533848376583687509108453086730196255111695352464186678\
221927564757730319825223049341618853631333478241227227268084\
583396688436229936266854011427192767039363517491659523133852\
472534104124441112346615696891097070121463652258681270378076\
538381697594264658479637863087159293838880752928175545408262\
813403793568695416998388572304528748824756265665683890518422\
696169422338806137532304784682662448207928681740476188343739\
117833525916386815135793034906806117413105008719197882837614\
738262050320291539494104952056471606645482046176634075459021\
552555959590354956262127809953013679512507451424271839221946\
794056861055980558363033732905772356986051180966474116423192\
194741572438649215204229781279620370445373851348786918527399\
785630808242657122705381806661616271132182017797793661244078\
445747547535623384548769818529655539279036503234072455810991\
588075181817695975173110136482659854557506203058080551018873\
203138260451109855100526720073566126209666125604482413705611\
996796777927332827103568863352291499261312290355143742018042\
254470707107847293593205234049774839191754781030496978091006\
099559675240966730110167624903610656473267105556155633783594\
089546261107653110531808279445757724399186120387548675148632\
176049190701680305210224388072261974806791922636412897526952\
793677946622674149577084803568051242934076450942927092705684\
547042915490323112457971853658760725588190377666477106903106\
693847278847646032201293023329503348730723947218797410452333\
910847913892827195814551858335519518939031446093385329182820\
714173657946661746005901866885589732922652604573972842197231\
187365263381958925227970038358064987248233271706462687651143\
350472018043321314534759819524203308490914358596886150053406\
629512434788155355109100540319857813535695923273426256911552\
977539394209918630668466632881929661971212772444625151371953\
428875491139683919687008724010475217255347915698820960215217\
257390308560235323463096946442080548018754166369706161589705\
215873687166365628787796501470056870127729464714362172216802\
441045276911597009443281135389729130222603185665646434661947\
627628077723219376892727386120519287577405410510114936151502\
752997122750262781911372625997223415283516995479265631485799\
456782561734766648462849641064097181818204279498552827825384\
186202065516999362573388136163077477126602169410435905014077\
049808497409025369325795765272066650278004200357878990911374\
982857977108488482528354406313893864211497105765030504600982\
253488805474531798742143374465080240030582370086699167937651\
038307909706139327119325418854546478285735654541635477790346\
964782617354265050767878335230272194896680141986745074630225\
893106573559558843545841186025169531604151588481389164948914\
823593944287133336263680358191369540321930649824471425485137\
777984823525402115151171093313613251350685343824859052220126\
891551966018355920872775724807128769003243129486808733796350\
497668255116485157191011858830643898323628223472099280243583\
164434348347014910398004439821970508280440872759395827943270\
985008769143562351938091476215083548164137333541883808870019\
116234099013452929807950151652297436436006149684939775781234\
660954156154478642694176038524277810483833149798681345708089\
152179193979463169402340611793486272301808073267534612685593\
859596787866884211031341417903391749825320454663508370385251\
831778477311017089729361152161928815389818579983544490982891\
734081131312309744330960666031291451740885503458543884956367\
654943799264600314531815427932691107874782328654759293575803\
481929361961781073958502075438499070633193799699311694287183\
299423475339817655608058724723221867087563064557636112380829\
514501382073257737022472866608244164310385205213523702910787\
182472517125030106491031844871593141759729773907719510044049\
352857426592936763727969496103940591601975078602859660478614\
119405428212830134490731706220583788265344728818766885126977\
588151111984290444321648931907188080336064713873288834096229\
203276676119810521851726133377700616341304257822975788967472\
152742255041912584197045423031298506219011800240120182445838\
590696647416285334515631019799007515682004250060857020904012\
215375170479800482680554499806010766109655061507421747722461\
180617361402575082294678925605271083587897845390768226405648\
508518103525778638618195775128516073959272990148239415346263\
486966573934577450787243667063244378381883115827207605856174\
876350045086885320626669331311880593775916269643646395423220\
549940790476989709243027420158390806135690975149384714684219\
964938182719962913931464979458639185519531490009437619838306\
362365453754807654884704163490469296444427144778593725687358\
437087390151990694667516279202024332494828210657618261952038\
597230263799412584275851667403910657370879707181053365818502\
680037431560091209982641738995652793235851569372314130107647\
166085235615697257094269133100914135783178856280392139325001\
352841718610484616627448189556913621837791650699820323059708\
766420810133584841826718631681683381743511974264126250984214\
812397119978273917903889865891718836792263377888052458189238\
746074986456016681098722869419588274020181430652732817858728\
473849369539367463917171317324882099804999043054467247785592\
038464723442276239896066431580123756428540074945472427752568\
981171400621705853374875885943072600692576914790467205905272\
372594740187988081900317493185005142913607163380720069786786\
782095331840893694073778325119471833528492917081008547303414\
509381563617864195257751546539575461435803625993888325647883\
541039192368366987400263049681218831477776345118518503709588\
840859023379762456561030683928115349942393963185677123055324\
771693784214924931737043793679546051454845624150270955450608\
318747395755728950832754611277041359602301205138509175543313\
522772786504141007552691902249572375175731740923618769197304\
652898352694386665448260033458575323252814233868098279476166\
764258284911434288072243178941698347365985427696983129579496\
059032032841281149923518087084876885114369033227736521245740\
554711771423492719899982357711910225545480424688322195336240\
492253136281857837808491795993788199125205555222116581071134\
476787468430539307909617442106685159519071053844987343666452\
494280317720153567054364117244775141336558406098548803924509\
496052261825198043140272655303625315605326569530252885854991\
822289219201218313590745412010446642247111703901991591338062\
693320157180618736569439969283245279430312651192668788340033\
626825194260296262959884258597703584888770801961209652822982\
322376122303586169861685106043820510444293432856251210395693\
261264867823980172683352796141772210301725997652373804152525\
037162852291403804455997331367378463632437773242905518075065\
414724295857460288225400061608664961649196400079359622673770\
607898395269075056596627116148289491042491764170924014885106\
158235482774778418134123293974436877051995673618683751115353\
808771434984204447736174758316063096245047311279841579995578\
186609402864244042751443128536278453430633423118662852688374\
229600894418958824842459450540826176452145829389286103522774\
101195556029650753254244433565937938526828990893149766298997\
738359913887178888607190765709867052470880785937935110091424\
743449966353497865681753841380246075612094033617488674676296\
822570077027076266879557913673839341012099558043806442348798\
053951239274913334631522409564461770434875790402230022872647\
568436177018658068697071731879399180374560963492726714528729\
224208938589940272515747888379118461617702271694075087419634\
147298076764775745707026934442908236664400557265527951453482\
191684597674273691978253678690951178777239573925410438679099\
374700609973920128201422381329108236575369403675960765238333\
778127017096574296148321075566959285042221837159799800133563\
239963969638610872680393210300180152020613051613414547163713\
772512617757277955979895866367571776456268564191092477027650\
135832200376440239783726540552694851717269598489288851529660\
975027775639565229734596726205832668434979354541943345062977\
891187146561050118118108223323735210843681128615413601091222\
007912350536959777114306541514511332368936078560929788143798\
814391221507522370648646767364209132147312407014953113532379\
838195728491128536978285918066991040993153064356179903885952\
027952713749653604502053512355449916680887234238773855581636\
172479594866871765094513940103284167914110196720261110812716\
776424260154507395050380575452850420730818412994731079307343\
538376880280124019321040198038723558784544408584344466090982\
802067326529000931562048932875469079874956595180595395347093\
285140279165467965596318365749701535812384333240968283640721\
344003442002691613772056762099098025739332715913970186225176\
459563484134139746647940170537900275350480490468851439300771\
949915194703080576611022590670399844931867609777417528903454\
731922206378932141464755402629420074293816349270038351339419\
146768473851353171629153912238797141905920143036064131705230\
421762305232861503856799511155936565169005916711845389135580\
928162511912438531204156138447775120789548666143600293412065\
767167106888509172568003530668539460588248316513392652567856\
224602697296203328920073354425994044956624831346979458846837\
597950064151867164583749203433942592178528868981311575331848\
941597492470436782387502687532649093096498315347403977436001\
399982102030846763698994785054617523241463186980898394504211\
430763617825306895065661536045431497903759118007934839122881\
885863091769469883539876840543521295706315919855784493235603\
866268925981702690270202829595794350800918257913991744455922\
6833433740466716699302196502685546875e-4951L;
static const long double ld2c =
5.4677992978237119037926089004291297245985762235403450155814\
707305425575329500966052143410629387408077958710210208052966\
529504784489330482549602621133847135082257338717668975178538\
378957084503396349323438489751160934104796903302909028868611\
999312592165232778075745690821530731336739429587895774023213\
939331012985331912661021188896306095323395084578542200319963\
179359407180003251440084380484161504585462684082946932782829\
488183829817567452314437076943950532707791252404699268678810\
198502871250235796855577909830559749628817599194837522029036\
891995648803056846354520653635957919882905363521007017169741\
463296044392266269433408052686419017699718627761948763856040\
592690841721239300491445991666051031755802326720329666454066\
568630314348735511753639418257984253319063825247065727664852\
328745422305642626091617823968872438962470092440688372515677\
832232712866924800106797113478024083516199991991274936894113\
006233377518471389394984262004503058455485659100090665241525\
454803628182902241401701783637353179296850056973639305945938\
813428953287892593620291195986011128990061888798763718548789\
025717537674780281005583347165047846045925077914824515331335\
131286063574407181821236377907693209224423490663289916878620\
725507793163931390372011875799729330162278748985052557432333\
005334989519381566364065326138465761456173231416844807264090\
741841972247545424908843928136253653308813487994328446248389\
608261444391573619177442907290731163188581917588219420107047\
265367485141413919810885909689112244064797106324295291545892\
937991321479061743491490060940946128274533657682130125169586\
930571899403551122506297763180795732325134340989331155893724\
289358918212707392997768032299997207208451112971425779939507\
837165263255764268971211819536322993221774123134726665579460\
265871378186589562858761835613344584269098062275786969729830\
545786485401407774313414954958161677096004701941411411592755\
485864471870515173326244464631295701572087440183178339987662\
926763241220698078822661709054601073523477544653542795020468\
256078409306409100874886828781860529824879343987945751252081\
314345990313550683792348814627862441324030155730592166581251\
009922787324590431548734575328663628650380722603024383412564\
651446272117561042207738413114131099731016728935023152239431\
311619533848376583687509108453086730196255111695352464186678\
221927564757730319825223049341618853631333478241227227268084\
583396688436229936266854011427192767039363517491659523133852\
472534104124441112346615696891097070121463652258681270378076\
538381697594264658479637863087159293838880752928175545408262\
813403793568695416998388572304528748824756265665683890518422\
696169422338806137532304784682662448207928681740476188343739\
117833525916386815135793034906806117413105008719197882837614\
738262050320291539494104952056471606645482046176634075459021\
552555959590354956262127809953013679512507451424271839221946\
794056861055980558363033732905772356986051180966474116423192\
194741572438649215204229781279620370445373851348786918527399\
785630808242657122705381806661616271132182017797793661244078\
445747547535623384548769818529655539279036503234072455810991\
588075181817695975173110136482659854557506203058080551018873\
203138260451109855100526720073566126209666125604482413705611\
996796777927332827103568863352291499261312290355143742018042\
254470707107847293593205234049774839191754781030496978091006\
099559675240966730110167624903610656473267105556155633783594\
089546261107653110531808279445757724399186120387548675148632\
176049190701680305210224388072261974806791922636412897526952\
793677946622674149577084803568051242934076450942927092705684\
547042915490323112457971853658760725588190377666477106903106\
693847278847646032201293023329503348730723947218797410452333\
910847913892827195814551858335519518939031446093385329182820\
714173657946661746005901866885589732922652604573972842197231\
187365263381958925227970038358064987248233271706462687651143\
350472018043321314534759819524203308490914358596886150053406\
629512434788155355109100540319857813535695923273426256911552\
977539394209918630668466632881929661971212772444625151371953\
428875491139683919687008724010475217255347915698820960215217\
257390308560235323463096946442080548018754166369706161589705\
215873687166365628787796501470056870127729464714362172216802\
441045276911597009443281135389729130222603185665646434661947\
627628077723219376892727386120519287577405410510114936151502\
752997122750262781911372625997223415283516995479265631485799\
456782561734766648462849641064097181818204279498552827825384\
186202065516999362573388136163077477126602169410435905014077\
049808497409025369325795765272066650278004200357878990911374\
982857977108488482528354406313893864211497105765030504600982\
253488805474531798742143374465080240030582370086699167937651\
038307909706139327119325418854546478285735654541635477790346\
964782617354265050767878335230272194896680141986745074630225\
893106573559558843545841186025169531604151588481389164948914\
823593944287133336263680358191369540321930649824471425485137\
777984823525402115151171093313613251350685343824859052220126\
891551966018355920872775724807128769003243129486808733796350\
497668255116485157191011858830643898323628223472099280243583\
164434348347014910398004439821970508280440872759395827943270\
985008769143562351938091476215083548164137333541883808870019\
116234099013452929807950151652297436436006149684939775781234\
660954156154478642694176038524277810483833149798681345708089\
152179193979463169402340611793486272301808073267534612685593\
859596787866884211031341417903391749825320454663508370385251\
831778477311017089729361152161928815389818579983544490982891\
734081131312309744330960666031291451740885503458543884956367\
654943799264600314531815427932691107874782328654759293575803\
481929361961781073958502075438499070633193799699311694287183\
299423475339817655608058724723221867087563064557636112380829\
514501382073257737022472866608244164310385205213523702910787\
182472517125030106491031844871593141759729773907719510044049\
352857426592936763727969496103940591601975078602859660478614\
119405428212830134490731706220583788265344728818766885126977\
588151111984290444321648931907188080336064713873288834096229\
203276676119810521851726133377700616341304257822975788967472\
152742255041912584197045423031298506219011800240120182445838\
590696647416285334515631019799007515682004250060857020904012\
215375170479800482680554499806010766109655061507421747722461\
180617361402575082294678925605271083587897845390768226405648\
508518103525778638618195775128516073959272990148239415346263\
486966573934577450787243667063244378381883115827207605856174\
876350045086885320626669331311880593775916269643646395423220\
549940790476989709243027420158390806135690975149384714684219\
964938182719962913931464979458639185519531490009437619838306\
362365453754807654884704163490469296444427144778593725687358\
437087390151990694667516279202024332494828210657618261952038\
597230263799412584275851667403910657370879707181053365818502\
680037431560091209982641738995652793235851569372314130107647\
166085235615697257094269133100914135783178856280392139325001\
352841718610484616627448189556913621837791650699820323059708\
766420810133584841826718631681683381743511974264126250984214\
812397119978273917903889865891718836792263377888052458189238\
746074986456016681098722869419588274020181430652732817858728\
473849369539367463917171317324882099804999043054467247785592\
038464723442276239896066431580123756428540074945472427752568\
981171400621705853374875885943072600692576914790467205905272\
372594740187988081900317493185005142913607163380720069786786\
782095331840893694073778325119471833528492917081008547303414\
509381563617864195257751546539575461435803625993888325647883\
541039192368366987400263049681218831477776345118518503709588\
840859023379762456561030683928115349942393963185677123055324\
771693784214924931737043793679546051454845624150270955450608\
318747395755728950832754611277041359602301205138509175543313\
522772786504141007552691902249572375175731740923618769197304\
652898352694386665448260033458575323252814233868098279476166\
764258284911434288072243178941698347365985427696983129579496\
059032032841281149923518087084876885114369033227736521245740\
554711771423492719899982357711910225545480424688322195336240\
492253136281857837808491795993788199125205555222116581071134\
476787468430539307909617442106685159519071053844987343666452\
494280317720153567054364117244775141336558406098548803924509\
496052261825198043140272655303625315605326569530252885854991\
822289219201218313590745412010446642247111703901991591338062\
693320157180618736569439969283245279430312651192668788340033\
626825194260296262959884258597703584888770801961209652822982\
322376122303586169861685106043820510444293432856251210395693\
261264867823980172683352796141772210301725997652373804152525\
037162852291403804455997331367378463632437773242905518075065\
414724295857460288225400061608664961649196400079359622673770\
607898395269075056596627116148289491042491764170924014885106\
158235482774778418134123293974436877051995673618683751115353\
808771434984204447736174758316063096245047311279841579995578\
186609402864244042751443128536278453430633423118662852688374\
229600894418958824842459450540826176452145829389286103522774\
101195556029650753254244433565937938526828990893149766298997\
738359913887178888607190765709867052470880785937935110091424\
743449966353497865681753841380246075612094033617488674676296\
822570077027076266879557913673839341012099558043806442348798\
053951239274913334631522409564461770434875790402230022872647\
568436177018658068697071731879399180374560963492726714528729\
224208938589940272515747888379118461617702271694075087419634\
147298076764775745707026934442908236664400557265527951453482\
191684597674273691978253678690951178777239573925410438679099\
374700609973920128201422381329108236575369403675960765238333\
778127017096574296148321075566959285042221837159799800133563\
239963969638610872680393210300180152020613051613414547163713\
772512617757277955979895866367571776456268564191092477027650\
135832200376440239783726540552694851717269598489288851529660\
975027775639565229734596726205832668434979354541943345062977\
891187146561050118118108223323735210843681128615413601091222\
007912350536959777114306541514511332368936078560929788143798\
814391221507522370648646767364209132147312407014953113532379\
838195728491128536978285918066991040993153064356179903885952\
027952713749653604502053512355449916680887234238773855581636\
172479594866871765094513940103284167914110196720261110812716\
776424260154507395050380575452850420730818412994731079307343\
538376880280124019321040198038723558784544408584344466090982\
802067326529000931562048932875469079874956595180595395347093\
285140279165467965596318365749701535812384333240968283640721\
344003442002691613772056762099098025739332715913970186225176\
459563484134139746647940170537900275350480490468851439300771\
949915194703080576611022590670399844931867609777417528903454\
731922206378932141464755402629420074293816349270038351339419\
146768473851353171629153912238797141905920143036064131705230\
421762305232861503856799511155936565169005916711845389135580\
928162511912438531204156138447775120789548666143600293412065\
767167106888509172568003530668539460588248316513392652567856\
224602697296203328920073354425994044956624831346979458846837\
597950064151867164583749203433942592178528868981311575331848\
941597492470436782387502687532649093096498315347403977436001\
399982102030846763698994785054617523241463186980898394504211\
430763617825306895065661536045431497903759118007934839122881\
885863091769469883539876840543521295706315919855784493235603\
866268925981702690270202829595794350800918257913991744455922\
6833433740466716699302196502685546875001e-4951L;
/* 0x1.0000000000000001p16383 */
static const long double ld3ae = 0x1p16383L, ld3be = 0x1p16383L, ld3ce = 0x1.0000000000000002p16383L;
static const long double ld3a =
5.9486574767861588257512740011252202817891302594919813725251\
295428739285541899832559628345030434759848834258858109152060\
168394580447354320917546191141469316674407503401251826592118\
529247805068466318759038608659253988075214874609536526621357\
456531393890166762179915866732524251539065872543957371571521\
983821811625262362379785274802094595537134203491628334800642\
100552410980148340419844099304716014319891796892117978584065\
642215994189779833796388294931075153217985342401232585488548\
183499573356819649604353341808627018653300000165159821533158\
398534762310007133107769480816106094590754928301890268526601\
948012303315011492834812113743989351274355589970363438128551\
573643438403526566620300559126131289478114044934210031633528\
263569989916613277150372804081100885766846923338387335735275\
815690693627425316500993091757924061275520326543377826484801\
260850814410014200240706874882235908793464063722267631785502\
588978890438298369667014685160756795261293064179236782450102\
879817506411379585551974343148401888001113058696688771238532\
123329163319380775763389985796856252232367435778523577763581\
076318820356483011816956309162306010784749642144593052844981\
144455778303480881727480293033710826466852650686573284449164\
971550815761322623554550767170481569400661823142075309755585\
825399262942161733431916879499819498306470556518202895225167\
570891857833504708712937447726161123901897152190727519098753\
173091256107155059564163182449945325514965354563242034921715\
085079669416064946957897843700525314730377964740286745952320\
848539618361767466769711132391357232984948881905511016501295\
373458116601070538750219227472880922074079367616789330713051\
392796054620611196686398104309732110578180612371988986941283\
463409571752839755060102940634838880149410521082372514146698\
949690555298417297141754693386954049385392552489950059242099\
158790234260937921119976211248531759522503364724271154732450\
580204158756703065275680503502538215181617861403909609765438\
459404741896379126766756324776550060890489522385655907004761\
103760380176704738464932582597767398552360992261748200224552\
499221197984163362555822765637968034280918669504609870586242\
062170049756721980421608552698712778507151233315121277695507\
694932304894125095195395002291537339548463471343544834535084\
385597125111888342671654244935921073610595930775193595237994\
484405470453247603596164707279142831292696020597352513459682\
982542490819269161229107183625537754125393689567083050306972\
299472451409351528024124972676859164822379702549840869992122\
109088558738008051503238314435613116752657081607929379237268\
685258548361696557803717952234859306922044575896046034219495\
078937310258307531674502149231702180717812559299741279722940\
331553164095430990867607708187092707603492795672693661579813\
722297206006600340954221573260854019342039503980256096723323\
974619210941227998945120494044519820953637210732374225869479\
681431453077746347270062554307578221973966755682727685671115\
104598487346465589917255152859638133529840253249441154093766\
468296435228729803156904942774237478111621919125582394448948\
295406406844691902789160843785892192212760482854142616066966\
061436483840059374641455624686877579416182709686546132337333\
180030729666859995573465620394353524944034503194887839608451\
069029644904642077575045157730600577875158390703330602738631\
860629283284285902868412268522486164537842820453011183015531\
669082023505889165928251243784395957824980999247118276540195\
068956031183236585108415603897481193085040746824934727777986\
761703484626902903260925660927239810711484175954901422619731\
922057229492660554293614771979793133433085936212830723862399\
334585740422370252249982159238980361966177481883090934546250\
903836442278836769393445168381535656636696931116641217099763\
249205106142470169654056239769609880390474141835446455366216\
163044493526155530766380018725181852858797332884069215206429\
253933800732703242020102754246055713369281324885855415528125\
659581759080256206862639693790603663547070031814664699862085\
124026740519096394950750536940374610036575208929959836461615\
919280191863569472772191938255564055565023733812663112274784\
824733213440763947293874467915896768018331324730250697015099\
463062533087218087488410166157459583569488345783974179340987\
151815108212218686575226398710276498737521494877861721916239\
286780194943271811625644415312213945242110591353818534254974\
082884162962499579444882831630967263044313008877192427542802\
154833385005287431176015973444837288763406349559772586733139\
508290944276618724455216038372331277739377332938820061159422\
131545699737995079186343848189545551446309662717473667598998\
332988069951307480469935653061211574846012803370905284012473\
025318540210297839541696998136885534223864988557670674501375\
244470147903967779423817060038384764935662497442963759653206\
786432859777470896394181997456033131032688720696203667198626\
404895099030068466008555612541561023366202324622483939422567\
021914882845352467305687811236417567525816955182834161603932\
993065869465459807593704095390354125514253872107415823725124\
7263969181695999e+4931L;
static const long double ld3b =
5.9486574767861588257512740011252202817891302594919813725251\
295428739285541899832559628345030434759848834258858109152060\
168394580447354320917546191141469316674407503401251826592118\
529247805068466318759038608659253988075214874609536526621357\
456531393890166762179915866732524251539065872543957371571521\
983821811625262362379785274802094595537134203491628334800642\
100552410980148340419844099304716014319891796892117978584065\
642215994189779833796388294931075153217985342401232585488548\
183499573356819649604353341808627018653300000165159821533158\
398534762310007133107769480816106094590754928301890268526601\
948012303315011492834812113743989351274355589970363438128551\
573643438403526566620300559126131289478114044934210031633528\
263569989916613277150372804081100885766846923338387335735275\
815690693627425316500993091757924061275520326543377826484801\
260850814410014200240706874882235908793464063722267631785502\
588978890438298369667014685160756795261293064179236782450102\
879817506411379585551974343148401888001113058696688771238532\
123329163319380775763389985796856252232367435778523577763581\
076318820356483011816956309162306010784749642144593052844981\
144455778303480881727480293033710826466852650686573284449164\
971550815761322623554550767170481569400661823142075309755585\
825399262942161733431916879499819498306470556518202895225167\
570891857833504708712937447726161123901897152190727519098753\
173091256107155059564163182449945325514965354563242034921715\
085079669416064946957897843700525314730377964740286745952320\
848539618361767466769711132391357232984948881905511016501295\
373458116601070538750219227472880922074079367616789330713051\
392796054620611196686398104309732110578180612371988986941283\
463409571752839755060102940634838880149410521082372514146698\
949690555298417297141754693386954049385392552489950059242099\
158790234260937921119976211248531759522503364724271154732450\
580204158756703065275680503502538215181617861403909609765438\
459404741896379126766756324776550060890489522385655907004761\
103760380176704738464932582597767398552360992261748200224552\
499221197984163362555822765637968034280918669504609870586242\
062170049756721980421608552698712778507151233315121277695507\
694932304894125095195395002291537339548463471343544834535084\
385597125111888342671654244935921073610595930775193595237994\
484405470453247603596164707279142831292696020597352513459682\
982542490819269161229107183625537754125393689567083050306972\
299472451409351528024124972676859164822379702549840869992122\
109088558738008051503238314435613116752657081607929379237268\
685258548361696557803717952234859306922044575896046034219495\
078937310258307531674502149231702180717812559299741279722940\
331553164095430990867607708187092707603492795672693661579813\
722297206006600340954221573260854019342039503980256096723323\
974619210941227998945120494044519820953637210732374225869479\
681431453077746347270062554307578221973966755682727685671115\
104598487346465589917255152859638133529840253249441154093766\
468296435228729803156904942774237478111621919125582394448948\
295406406844691902789160843785892192212760482854142616066966\
061436483840059374641455624686877579416182709686546132337333\
180030729666859995573465620394353524944034503194887839608451\
069029644904642077575045157730600577875158390703330602738631\
860629283284285902868412268522486164537842820453011183015531\
669082023505889165928251243784395957824980999247118276540195\
068956031183236585108415603897481193085040746824934727777986\
761703484626902903260925660927239810711484175954901422619731\
922057229492660554293614771979793133433085936212830723862399\
334585740422370252249982159238980361966177481883090934546250\
903836442278836769393445168381535656636696931116641217099763\
249205106142470169654056239769609880390474141835446455366216\
163044493526155530766380018725181852858797332884069215206429\
253933800732703242020102754246055713369281324885855415528125\
659581759080256206862639693790603663547070031814664699862085\
124026740519096394950750536940374610036575208929959836461615\
919280191863569472772191938255564055565023733812663112274784\
824733213440763947293874467915896768018331324730250697015099\
463062533087218087488410166157459583569488345783974179340987\
151815108212218686575226398710276498737521494877861721916239\
286780194943271811625644415312213945242110591353818534254974\
082884162962499579444882831630967263044313008877192427542802\
154833385005287431176015973444837288763406349559772586733139\
508290944276618724455216038372331277739377332938820061159422\
131545699737995079186343848189545551446309662717473667598998\
332988069951307480469935653061211574846012803370905284012473\
025318540210297839541696998136885534223864988557670674501375\
244470147903967779423817060038384764935662497442963759653206\
786432859777470896394181997456033131032688720696203667198626\
404895099030068466008555612541561023366202324622483939422567\
021914882845352467305687811236417567525816955182834161603932\
993065869465459807593704095390354125514253872107415823725124\
7263969181696e+4931L;
static const long double ld3c =
5.9486574767861588257512740011252202817891302594919813725251\
295428739285541899832559628345030434759848834258858109152060\
168394580447354320917546191141469316674407503401251826592118\
529247805068466318759038608659253988075214874609536526621357\
456531393890166762179915866732524251539065872543957371571521\
983821811625262362379785274802094595537134203491628334800642\
100552410980148340419844099304716014319891796892117978584065\
642215994189779833796388294931075153217985342401232585488548\
183499573356819649604353341808627018653300000165159821533158\
398534762310007133107769480816106094590754928301890268526601\
948012303315011492834812113743989351274355589970363438128551\
573643438403526566620300559126131289478114044934210031633528\
263569989916613277150372804081100885766846923338387335735275\
815690693627425316500993091757924061275520326543377826484801\
260850814410014200240706874882235908793464063722267631785502\
588978890438298369667014685160756795261293064179236782450102\
879817506411379585551974343148401888001113058696688771238532\
123329163319380775763389985796856252232367435778523577763581\
076318820356483011816956309162306010784749642144593052844981\
144455778303480881727480293033710826466852650686573284449164\
971550815761322623554550767170481569400661823142075309755585\
825399262942161733431916879499819498306470556518202895225167\
570891857833504708712937447726161123901897152190727519098753\
173091256107155059564163182449945325514965354563242034921715\
085079669416064946957897843700525314730377964740286745952320\
848539618361767466769711132391357232984948881905511016501295\
373458116601070538750219227472880922074079367616789330713051\
392796054620611196686398104309732110578180612371988986941283\
463409571752839755060102940634838880149410521082372514146698\
949690555298417297141754693386954049385392552489950059242099\
158790234260937921119976211248531759522503364724271154732450\
580204158756703065275680503502538215181617861403909609765438\
459404741896379126766756324776550060890489522385655907004761\
103760380176704738464932582597767398552360992261748200224552\
499221197984163362555822765637968034280918669504609870586242\
062170049756721980421608552698712778507151233315121277695507\
694932304894125095195395002291537339548463471343544834535084\
385597125111888342671654244935921073610595930775193595237994\
484405470453247603596164707279142831292696020597352513459682\
982542490819269161229107183625537754125393689567083050306972\
299472451409351528024124972676859164822379702549840869992122\
109088558738008051503238314435613116752657081607929379237268\
685258548361696557803717952234859306922044575896046034219495\
078937310258307531674502149231702180717812559299741279722940\
331553164095430990867607708187092707603492795672693661579813\
722297206006600340954221573260854019342039503980256096723323\
974619210941227998945120494044519820953637210732374225869479\
681431453077746347270062554307578221973966755682727685671115\
104598487346465589917255152859638133529840253249441154093766\
468296435228729803156904942774237478111621919125582394448948\
295406406844691902789160843785892192212760482854142616066966\
061436483840059374641455624686877579416182709686546132337333\
180030729666859995573465620394353524944034503194887839608451\
069029644904642077575045157730600577875158390703330602738631\
860629283284285902868412268522486164537842820453011183015531\
669082023505889165928251243784395957824980999247118276540195\
068956031183236585108415603897481193085040746824934727777986\
761703484626902903260925660927239810711484175954901422619731\
922057229492660554293614771979793133433085936212830723862399\
334585740422370252249982159238980361966177481883090934546250\
903836442278836769393445168381535656636696931116641217099763\
249205106142470169654056239769609880390474141835446455366216\
163044493526155530766380018725181852858797332884069215206429\
253933800732703242020102754246055713369281324885855415528125\
659581759080256206862639693790603663547070031814664699862085\
124026740519096394950750536940374610036575208929959836461615\
919280191863569472772191938255564055565023733812663112274784\
824733213440763947293874467915896768018331324730250697015099\
463062533087218087488410166157459583569488345783974179340987\
151815108212218686575226398710276498737521494877861721916239\
286780194943271811625644415312213945242110591353818534254974\
082884162962499579444882831630967263044313008877192427542802\
154833385005287431176015973444837288763406349559772586733139\
508290944276618724455216038372331277739377332938820061159422\
131545699737995079186343848189545551446309662717473667598998\
332988069951307480469935653061211574846012803370905284012473\
025318540210297839541696998136885534223864988557670674501375\
244470147903967779423817060038384764935662497442963759653206\
786432859777470896394181997456033131032688720696203667198626\
404895099030068466008555612541561023366202324622483939422567\
021914882845352467305687811236417567525816955182834161603932\
993065869465459807593704095390354125514253872107415823725124\
7263969181696001e+4931L;
#endif

#if LDBL_MANT_DIG == 113 \
  && LDBL_MIN_EXP == -16381 \
  && LDBL_MAX_EXP == 16384
# define LDBL_OK
/* 0x0.8p-16494 */
static const long double ld1ae = 0, ld1be = 0, ld1ce = 0x1p-16494L;
static const long double ld1a =
3.2375875597190125554622194791138232762497846690173405048449\
421945985197700620596855088357456383249701279390707384240598\
382936099431912710233425550359863089915213963553756674672083\
673128192358701197242632527769951957277781260855740340354110\
173441284912381364143945515141786687806740155311932822963199\
131134959539539338316310328556057915323285980341541664226172\
265348802632447238304822896568757017013159021750199744350376\
278243566840330589397015778833566517337174685312047058426075\
688036665697114219175258344917835835984013214761767520398571\
735519302688914468501077605843338555214753050109407568139932\
147308502166696009676987494125921676927574464221699654264839\
192243410627511520570610765229732327315423820550872393685221\
676561948307418196052769717057382723931306989375320957256133\
838073129463951849807075348034900035402513943244599879584009\
391110011261908615236154859382854977144106096407982738165117\
693915685918231984764157652755343417097983676870433731452629\
339981084526616826599425863049784138127555181662391766144738\
159400253422795753041594932607700680306368857466952063923782\
760519487592638820793893796669403574411398166619131986561877\
034635197232626532239192571857518274939275861531537920777299\
133535479548088762634002006634954143608168633852204577195463\
389533233992867620995583241321034602255800668175356808869060\
608582640890741203603916133682748118680676374951545690715916\
241859799379894025137504643469040366684778763795442214328000\
375999444991619403217748350277527106812175542863660436614910\
135938862296156144947361864759321605496309393905421651264941\
669606814994816518612155298709843817262034769175075602668866\
926449523554218142013501373514352370369126244144449924971423\
038024236058971106053649565799145071085840022305247663313482\
714565918140785997808209749619683146844964283106915422726638\
184861327711776708749278315100024436584176080783836115268999\
055336294569042349971163039294272620322160728879610722678506\
182344928526064885227397447578450046944618127903428943538029\
386719288345854473283987116842451647036255801966780244103035\
425445345127067921349083698736056197567752071915587544133815\
717564310032485290205726480489464589999677885266171263493459\
668963623768410922688414177814149693150024191921819721215688\
114324591287371281400636455584825253000890602388603923710921\
026880979879158388608823700222683123228822356907857261909150\
626993825760416437415551396973489279578569909699853422995997\
974315036153120383930698087773157253674975950409660938084071\
173163693891122166282318691732176374528554627905530306369204\
877964658806333996327938827344733821685425961846791581492287\
250044047142934607523718654369478552373072400018635730811749\
291666457582760812726851561001954207941547404866373158231367\
986951247388733285659455982411993350593989550494594498447410\
984783303191128659803467713819821511544998464785455306500918\
241648925913966507036336000231915215026183799886938007038845\
551916478649593272604688927931953165785101738164060543643192\
949066412847647883846835866623820426428526541564774787007791\
235843699657232847114093617412355486871810526396392792853731\
390841657984518997639795008374280777823099107035223998600103\
103211166230289241182380237703814248941627178152962100972452\
217697144954497443279450919433943252592977710901289696002698\
225209041938801190947812141758873162203113090284565687499100\
109623665868340184032428667217835198069330185880779776269137\
742366802202585247113480377505916462865316253065105837519292\
805411191872195967066157363040364443666632564266439033866945\
366496486863801221986778957510023272290593640187551645170603\
215150911733580059874983597994671388176488814794186236946834\
548816837468411497151813344980969677026131105901402313456769\
561412278508799050185582199844418197980544632067644131002512\
557755358307705356209461595354064971347590431926479961905129\
785864961996560707071051177738535042777950247546470241655891\
294428226271478689174637951663865529219133988782700199051475\
108495188941141025360733690471601309904116260484264378352956\
830972782977747351810451586166745640802378131466232692150196\
132319386267589275314909450293562079332893638471814389025392\
970579695249613486078445695214422379148991006996109216699215\
721671648754881325271879493185438097033881789311707997697928\
860866812849648616086569281093053695399558469641977866770538\
476039621947215238679930485285585513808236992918733520331110\
962448142457896209307561142289713638388281085340301520317159\
297224995464365477734040179470355969363384621039467975256670\
339354334892926205316491997244008324897517881293654265688813\
283579663372924392043825371743576754041055802440187836850412\
247984570221893156921757872572872036331343007592090605703195\
088864753777199111760713027328198781654685927174063882187275\
850263521274368447629947228263907797373221137688424821608129\
731003236738630502344377228987961455961818623205503012858619\
800521948637807438081069469400793496307826769301971342062597\
391253779410607511754278887744936774785938056823221738917303\
119592848951788560393540150358649310736020595310015728915288\
289821678102453433273888879288862086153270028346900686360943\
250522514297816412678213672667152836436597491522644579383191\
851483036048273636234050603745735057899230038434384361744893\
838050985090837220507663282503497932038372021626246900935334\
781144388106031405650705176699646299475436084049881780196520\
881623075256119318210664937469946410480660118598143375898298\
965497205621170906772915413181530577151676241283182977713765\
317889730886996471681592298058774155948285325398399674640645\
566475947058303746531133735308766583802401453804232106737787\
768035926272312574958173945816077962772826443125107145322971\
087220172175473177449006473180221085709470643042801004189714\
505520073568915195232936144169440163547568663500508335014169\
425050712038101167190534305435310279534374364467455668392421\
298604104431988622194699721632249712583483143417550152131186\
288827131347662976240916448058011869761525369135147129192405\
037216807405860168320999468074663117771890506566769628495813\
837909047220874786467663205170561835819702362482274133227483\
041342457179876653773960112367066273208176545656826800069574\
547599816180234764485446735080683694920665668954370505715843\
455110709594838989387382250502925336743830916124954071268053\
817964873658921319164268375226716232666274830656557657055342\
393552148933959057023293404027940528842591460490646295820755\
765633076707491896621769767253619370462005760078938144396953\
018925287611875441613896820035092167912718365454954166761481\
511451950826683236776211829914518353242818636196417736206010\
145109509967467266157037719712666871515644277723594273405669\
093518586548079997818085130346801040781966074621669280188633\
856299289656492439545033914935979634179552686396067914528336\
924678729357419403624798426886422277256625046946795576781709\
298737741510378578072199383561520569978396254537274419476511\
983161908266152660163477408756159700314280122283281906103567\
067156627222418787671312246698375736071215395722993294041012\
744631560602983489316782773611740570974847045870362276861106\
774130949410119612624380274679529647271294627526939490197641\
645383447755544661714281218489998189691140343327976729279891\
077101372792811842951182338559423852563331641533781432796742\
873181364582071661749961126386895359760476172215209100274274\
851619657020388051618654944574445941780637669570374280535432\
399157923698778110534174856844986671232161320063786308144771\
068130888985636449091787794632959555876880672773686838364706\
122084832995722603440165161942472322987408003421165899848443\
566885769845535074102932500939450142098799833145629484519298\
622410092757836842296697186410137365818568152771850732591405\
340248509247875448717161746544246407280913725135059228268131\
453903691495906528862410006254958805237716723952273129715780\
425223305517882562616830806755498203755676925741529569939445\
043490046171854709456730491532189688306135861932534903184518\
717706426178028900836080044604143054210332610482947502104703\
032028463320549525316174330585387581543470878545616097381416\
151451037487775797335749896735101048367502483255117772375025\
269956476872153642623856062175536913321594213515989059505375\
135183515207096576145781316398544325320022366962008554087665\
201050763789833457082359181807492731245904330245198691471329\
319324627030678762142685799400660305214140453863665517807185\
105354694177602424937823924511789133225030926924236498557565\
212794565582753399214908928688568628950225640472058381324292\
866007645368390366981937596341868992912741319342960598330486\
905946276235953206760977215407164729909506118583728562718724\
235732515062300426080741679038098122641980345051854359908213\
563779664847422505775922437272989231878912994048540484468227\
199282393172540734295329890896755037903724644870572648941076\
132423009124870700536763793881894969000042397318202298868940\
530196108237639578098191879486398269734335286831689173606327\
500405178476864790935386838169242131756729797688220656276969\
434749140204830563840068728357383111109865861495106613619153\
421725274090787422508800568671498311491210197298472420373359\
044400631309819996507004167876832936101195902219429743174557\
163362274547892397934880322990633165889175059124060202200452\
648684577182821651588921716304707095995039972827781680978274\
973838841958209215836456212939412000456040621743349981715350\
305133662772937143899882197561295808685181679238411733642697\
748892466944352640514849114619882270112386610376024527101889\
119004382703622803911212700216792471528793241950356942780714\
774957204475130171711488773121937363663487116301055073658645\
980695862570269762957141239436916216723776945522480189876803\
386123827956059851911061129713987960026363403936931196519733\
447116468545744829997003979525368783485129837821983305137448\
031689360764270759437872004895754351479890333865299565515706\
690471030702230767978923298480584997256328135245813726407464\
159230169328539541524724878662873185450510653764301207480799\
488602832618557388369552461881286225098286358672257087829660\
174231705350465091313887538950130611513878400895128618426154\
417299623157313010877679890009181366178705821415173309356192\
686429159835537275875876767919535369607142366878476025895389\
279625854409611312402187942369446302119309705461187450803468\
606366203101933821675974655441744883993796837164178911391575\
751463591650231265941242686108002052587760190005508737394014\
453031299745602214380618917954427803281262300931789525045703\
809571995929933387196864877982754748535701000330924817431298\
365273697561943437891318220691072831562717726798635382168915\
187137325209768346284183473712613689334546294053718697897526\
843398053681374508250012035211936425982389543291022583173280\
985811169783438836113209408147936547458073361625570571955232\
746103236016857123149307991441916732438322836596693687161268\
151183603534413030099360835441935243365729307681545065674775\
655582111435085683962037818795920337874290127531069511296530\
746308404963763022896682861683252995925040540038039172626001\
958340013361801588367655990575379797454237110701588716509764\
759243657077584013289594787913434812509790293636440469725564\
222946985585616708175959944099853232059130350099233608207347\
955460820122006976717445739825352919058005528371183277021250\
186916447745609162301667393077050176560656798672598371789181\
232542195795945358691713761483976100058707499929103557275695\
937295677892604799308353051124627278706035295473126217205599\
530746756205492173148619619059839609108464715691924592576481\
382126740168148453274964955074129767533813576349605298268179\
068244338581354855186516322703199278802275718580352103754433\
240982354636196477238624205575823556321375833700666021556412\
182358152808745703724362178773168996492870519432472065091133\
11767578124999e-4966L;
static const long double ld1b =
3.2375875597190125554622194791138232762497846690173405048449\
421945985197700620596855088357456383249701279390707384240598\
382936099431912710233425550359863089915213963553756674672083\
673128192358701197242632527769951957277781260855740340354110\
173441284912381364143945515141786687806740155311932822963199\
131134959539539338316310328556057915323285980341541664226172\
265348802632447238304822896568757017013159021750199744350376\
278243566840330589397015778833566517337174685312047058426075\
688036665697114219175258344917835835984013214761767520398571\
735519302688914468501077605843338555214753050109407568139932\
147308502166696009676987494125921676927574464221699654264839\
192243410627511520570610765229732327315423820550872393685221\
676561948307418196052769717057382723931306989375320957256133\
838073129463951849807075348034900035402513943244599879584009\
391110011261908615236154859382854977144106096407982738165117\
693915685918231984764157652755343417097983676870433731452629\
339981084526616826599425863049784138127555181662391766144738\
159400253422795753041594932607700680306368857466952063923782\
760519487592638820793893796669403574411398166619131986561877\
034635197232626532239192571857518274939275861531537920777299\
133535479548088762634002006634954143608168633852204577195463\
389533233992867620995583241321034602255800668175356808869060\
608582640890741203603916133682748118680676374951545690715916\
241859799379894025137504643469040366684778763795442214328000\
375999444991619403217748350277527106812175542863660436614910\
135938862296156144947361864759321605496309393905421651264941\
669606814994816518612155298709843817262034769175075602668866\
926449523554218142013501373514352370369126244144449924971423\
038024236058971106053649565799145071085840022305247663313482\
714565918140785997808209749619683146844964283106915422726638\
184861327711776708749278315100024436584176080783836115268999\
055336294569042349971163039294272620322160728879610722678506\
182344928526064885227397447578450046944618127903428943538029\
386719288345854473283987116842451647036255801966780244103035\
425445345127067921349083698736056197567752071915587544133815\
717564310032485290205726480489464589999677885266171263493459\
668963623768410922688414177814149693150024191921819721215688\
114324591287371281400636455584825253000890602388603923710921\
026880979879158388608823700222683123228822356907857261909150\
626993825760416437415551396973489279578569909699853422995997\
974315036153120383930698087773157253674975950409660938084071\
173163693891122166282318691732176374528554627905530306369204\
877964658806333996327938827344733821685425961846791581492287\
250044047142934607523718654369478552373072400018635730811749\
291666457582760812726851561001954207941547404866373158231367\
986951247388733285659455982411993350593989550494594498447410\
984783303191128659803467713819821511544998464785455306500918\
241648925913966507036336000231915215026183799886938007038845\
551916478649593272604688927931953165785101738164060543643192\
949066412847647883846835866623820426428526541564774787007791\
235843699657232847114093617412355486871810526396392792853731\
390841657984518997639795008374280777823099107035223998600103\
103211166230289241182380237703814248941627178152962100972452\
217697144954497443279450919433943252592977710901289696002698\
225209041938801190947812141758873162203113090284565687499100\
109623665868340184032428667217835198069330185880779776269137\
742366802202585247113480377505916462865316253065105837519292\
805411191872195967066157363040364443666632564266439033866945\
366496486863801221986778957510023272290593640187551645170603\
215150911733580059874983597994671388176488814794186236946834\
548816837468411497151813344980969677026131105901402313456769\
561412278508799050185582199844418197980544632067644131002512\
557755358307705356209461595354064971347590431926479961905129\
785864961996560707071051177738535042777950247546470241655891\
294428226271478689174637951663865529219133988782700199051475\
108495188941141025360733690471601309904116260484264378352956\
830972782977747351810451586166745640802378131466232692150196\
132319386267589275314909450293562079332893638471814389025392\
970579695249613486078445695214422379148991006996109216699215\
721671648754881325271879493185438097033881789311707997697928\
860866812849648616086569281093053695399558469641977866770538\
476039621947215238679930485285585513808236992918733520331110\
962448142457896209307561142289713638388281085340301520317159\
297224995464365477734040179470355969363384621039467975256670\
339354334892926205316491997244008324897517881293654265688813\
283579663372924392043825371743576754041055802440187836850412\
247984570221893156921757872572872036331343007592090605703195\
088864753777199111760713027328198781654685927174063882187275\
850263521274368447629947228263907797373221137688424821608129\
731003236738630502344377228987961455961818623205503012858619\
800521948637807438081069469400793496307826769301971342062597\
391253779410607511754278887744936774785938056823221738917303\
119592848951788560393540150358649310736020595310015728915288\
289821678102453433273888879288862086153270028346900686360943\
250522514297816412678213672667152836436597491522644579383191\
851483036048273636234050603745735057899230038434384361744893\
838050985090837220507663282503497932038372021626246900935334\
781144388106031405650705176699646299475436084049881780196520\
881623075256119318210664937469946410480660118598143375898298\
965497205621170906772915413181530577151676241283182977713765\
317889730886996471681592298058774155948285325398399674640645\
566475947058303746531133735308766583802401453804232106737787\
768035926272312574958173945816077962772826443125107145322971\
087220172175473177449006473180221085709470643042801004189714\
505520073568915195232936144169440163547568663500508335014169\
425050712038101167190534305435310279534374364467455668392421\
298604104431988622194699721632249712583483143417550152131186\
288827131347662976240916448058011869761525369135147129192405\
037216807405860168320999468074663117771890506566769628495813\
837909047220874786467663205170561835819702362482274133227483\
041342457179876653773960112367066273208176545656826800069574\
547599816180234764485446735080683694920665668954370505715843\
455110709594838989387382250502925336743830916124954071268053\
817964873658921319164268375226716232666274830656557657055342\
393552148933959057023293404027940528842591460490646295820755\
765633076707491896621769767253619370462005760078938144396953\
018925287611875441613896820035092167912718365454954166761481\
511451950826683236776211829914518353242818636196417736206010\
145109509967467266157037719712666871515644277723594273405669\
093518586548079997818085130346801040781966074621669280188633\
856299289656492439545033914935979634179552686396067914528336\
924678729357419403624798426886422277256625046946795576781709\
298737741510378578072199383561520569978396254537274419476511\
983161908266152660163477408756159700314280122283281906103567\
067156627222418787671312246698375736071215395722993294041012\
744631560602983489316782773611740570974847045870362276861106\
774130949410119612624380274679529647271294627526939490197641\
645383447755544661714281218489998189691140343327976729279891\
077101372792811842951182338559423852563331641533781432796742\
873181364582071661749961126386895359760476172215209100274274\
851619657020388051618654944574445941780637669570374280535432\
399157923698778110534174856844986671232161320063786308144771\
068130888985636449091787794632959555876880672773686838364706\
122084832995722603440165161942472322987408003421165899848443\
566885769845535074102932500939450142098799833145629484519298\
622410092757836842296697186410137365818568152771850732591405\
340248509247875448717161746544246407280913725135059228268131\
453903691495906528862410006254958805237716723952273129715780\
425223305517882562616830806755498203755676925741529569939445\
043490046171854709456730491532189688306135861932534903184518\
717706426178028900836080044604143054210332610482947502104703\
032028463320549525316174330585387581543470878545616097381416\
151451037487775797335749896735101048367502483255117772375025\
269956476872153642623856062175536913321594213515989059505375\
135183515207096576145781316398544325320022366962008554087665\
201050763789833457082359181807492731245904330245198691471329\
319324627030678762142685799400660305214140453863665517807185\
105354694177602424937823924511789133225030926924236498557565\
212794565582753399214908928688568628950225640472058381324292\
866007645368390366981937596341868992912741319342960598330486\
905946276235953206760977215407164729909506118583728562718724\
235732515062300426080741679038098122641980345051854359908213\
563779664847422505775922437272989231878912994048540484468227\
199282393172540734295329890896755037903724644870572648941076\
132423009124870700536763793881894969000042397318202298868940\
530196108237639578098191879486398269734335286831689173606327\
500405178476864790935386838169242131756729797688220656276969\
434749140204830563840068728357383111109865861495106613619153\
421725274090787422508800568671498311491210197298472420373359\
044400631309819996507004167876832936101195902219429743174557\
163362274547892397934880322990633165889175059124060202200452\
648684577182821651588921716304707095995039972827781680978274\
973838841958209215836456212939412000456040621743349981715350\
305133662772937143899882197561295808685181679238411733642697\
748892466944352640514849114619882270112386610376024527101889\
119004382703622803911212700216792471528793241950356942780714\
774957204475130171711488773121937363663487116301055073658645\
980695862570269762957141239436916216723776945522480189876803\
386123827956059851911061129713987960026363403936931196519733\
447116468545744829997003979525368783485129837821983305137448\
031689360764270759437872004895754351479890333865299565515706\
690471030702230767978923298480584997256328135245813726407464\
159230169328539541524724878662873185450510653764301207480799\
488602832618557388369552461881286225098286358672257087829660\
174231705350465091313887538950130611513878400895128618426154\
417299623157313010877679890009181366178705821415173309356192\
686429159835537275875876767919535369607142366878476025895389\
279625854409611312402187942369446302119309705461187450803468\
606366203101933821675974655441744883993796837164178911391575\
751463591650231265941242686108002052587760190005508737394014\
453031299745602214380618917954427803281262300931789525045703\
809571995929933387196864877982754748535701000330924817431298\
365273697561943437891318220691072831562717726798635382168915\
187137325209768346284183473712613689334546294053718697897526\
843398053681374508250012035211936425982389543291022583173280\
985811169783438836113209408147936547458073361625570571955232\
746103236016857123149307991441916732438322836596693687161268\
151183603534413030099360835441935243365729307681545065674775\
655582111435085683962037818795920337874290127531069511296530\
746308404963763022896682861683252995925040540038039172626001\
958340013361801588367655990575379797454237110701588716509764\
759243657077584013289594787913434812509790293636440469725564\
222946985585616708175959944099853232059130350099233608207347\
955460820122006976717445739825352919058005528371183277021250\
186916447745609162301667393077050176560656798672598371789181\
232542195795945358691713761483976100058707499929103557275695\
937295677892604799308353051124627278706035295473126217205599\
530746756205492173148619619059839609108464715691924592576481\
382126740168148453274964955074129767533813576349605298268179\
068244338581354855186516322703199278802275718580352103754433\
240982354636196477238624205575823556321375833700666021556412\
182358152808745703724362178773168996492870519432472065091133\
11767578125e-4966L;
static const long double ld1c =
3.2375875597190125554622194791138232762497846690173405048449\
421945985197700620596855088357456383249701279390707384240598\
382936099431912710233425550359863089915213963553756674672083\
673128192358701197242632527769951957277781260855740340354110\
173441284912381364143945515141786687806740155311932822963199\
131134959539539338316310328556057915323285980341541664226172\
265348802632447238304822896568757017013159021750199744350376\
278243566840330589397015778833566517337174685312047058426075\
688036665697114219175258344917835835984013214761767520398571\
735519302688914468501077605843338555214753050109407568139932\
147308502166696009676987494125921676927574464221699654264839\
192243410627511520570610765229732327315423820550872393685221\
676561948307418196052769717057382723931306989375320957256133\
838073129463951849807075348034900035402513943244599879584009\
391110011261908615236154859382854977144106096407982738165117\
693915685918231984764157652755343417097983676870433731452629\
339981084526616826599425863049784138127555181662391766144738\
159400253422795753041594932607700680306368857466952063923782\
760519487592638820793893796669403574411398166619131986561877\
034635197232626532239192571857518274939275861531537920777299\
133535479548088762634002006634954143608168633852204577195463\
389533233992867620995583241321034602255800668175356808869060\
608582640890741203603916133682748118680676374951545690715916\
241859799379894025137504643469040366684778763795442214328000\
375999444991619403217748350277527106812175542863660436614910\
135938862296156144947361864759321605496309393905421651264941\
669606814994816518612155298709843817262034769175075602668866\
926449523554218142013501373514352370369126244144449924971423\
038024236058971106053649565799145071085840022305247663313482\
714565918140785997808209749619683146844964283106915422726638\
184861327711776708749278315100024436584176080783836115268999\
055336294569042349971163039294272620322160728879610722678506\
182344928526064885227397447578450046944618127903428943538029\
386719288345854473283987116842451647036255801966780244103035\
425445345127067921349083698736056197567752071915587544133815\
717564310032485290205726480489464589999677885266171263493459\
668963623768410922688414177814149693150024191921819721215688\
114324591287371281400636455584825253000890602388603923710921\
026880979879158388608823700222683123228822356907857261909150\
626993825760416437415551396973489279578569909699853422995997\
974315036153120383930698087773157253674975950409660938084071\
173163693891122166282318691732176374528554627905530306369204\
877964658806333996327938827344733821685425961846791581492287\
250044047142934607523718654369478552373072400018635730811749\
291666457582760812726851561001954207941547404866373158231367\
986951247388733285659455982411993350593989550494594498447410\
984783303191128659803467713819821511544998464785455306500918\
241648925913966507036336000231915215026183799886938007038845\
551916478649593272604688927931953165785101738164060543643192\
949066412847647883846835866623820426428526541564774787007791\
235843699657232847114093617412355486871810526396392792853731\
390841657984518997639795008374280777823099107035223998600103\
103211166230289241182380237703814248941627178152962100972452\
217697144954497443279450919433943252592977710901289696002698\
225209041938801190947812141758873162203113090284565687499100\
109623665868340184032428667217835198069330185880779776269137\
742366802202585247113480377505916462865316253065105837519292\
805411191872195967066157363040364443666632564266439033866945\
366496486863801221986778957510023272290593640187551645170603\
215150911733580059874983597994671388176488814794186236946834\
548816837468411497151813344980969677026131105901402313456769\
561412278508799050185582199844418197980544632067644131002512\
557755358307705356209461595354064971347590431926479961905129\
785864961996560707071051177738535042777950247546470241655891\
294428226271478689174637951663865529219133988782700199051475\
108495188941141025360733690471601309904116260484264378352956\
830972782977747351810451586166745640802378131466232692150196\
132319386267589275314909450293562079332893638471814389025392\
970579695249613486078445695214422379148991006996109216699215\
721671648754881325271879493185438097033881789311707997697928\
860866812849648616086569281093053695399558469641977866770538\
476039621947215238679930485285585513808236992918733520331110\
962448142457896209307561142289713638388281085340301520317159\
297224995464365477734040179470355969363384621039467975256670\
339354334892926205316491997244008324897517881293654265688813\
283579663372924392043825371743576754041055802440187836850412\
247984570221893156921757872572872036331343007592090605703195\
088864753777199111760713027328198781654685927174063882187275\
850263521274368447629947228263907797373221137688424821608129\
731003236738630502344377228987961455961818623205503012858619\
800521948637807438081069469400793496307826769301971342062597\
391253779410607511754278887744936774785938056823221738917303\
119592848951788560393540150358649310736020595310015728915288\
289821678102453433273888879288862086153270028346900686360943\
250522514297816412678213672667152836436597491522644579383191\
851483036048273636234050603745735057899230038434384361744893\
838050985090837220507663282503497932038372021626246900935334\
781144388106031405650705176699646299475436084049881780196520\
881623075256119318210664937469946410480660118598143375898298\
965497205621170906772915413181530577151676241283182977713765\
317889730886996471681592298058774155948285325398399674640645\
566475947058303746531133735308766583802401453804232106737787\
768035926272312574958173945816077962772826443125107145322971\
087220172175473177449006473180221085709470643042801004189714\
505520073568915195232936144169440163547568663500508335014169\
425050712038101167190534305435310279534374364467455668392421\
298604104431988622194699721632249712583483143417550152131186\
288827131347662976240916448058011869761525369135147129192405\
037216807405860168320999468074663117771890506566769628495813\
837909047220874786467663205170561835819702362482274133227483\
041342457179876653773960112367066273208176545656826800069574\
547599816180234764485446735080683694920665668954370505715843\
455110709594838989387382250502925336743830916124954071268053\
817964873658921319164268375226716232666274830656557657055342\
393552148933959057023293404027940528842591460490646295820755\
765633076707491896621769767253619370462005760078938144396953\
018925287611875441613896820035092167912718365454954166761481\
511451950826683236776211829914518353242818636196417736206010\
145109509967467266157037719712666871515644277723594273405669\
093518586548079997818085130346801040781966074621669280188633\
856299289656492439545033914935979634179552686396067914528336\
924678729357419403624798426886422277256625046946795576781709\
298737741510378578072199383561520569978396254537274419476511\
983161908266152660163477408756159700314280122283281906103567\
067156627222418787671312246698375736071215395722993294041012\
744631560602983489316782773611740570974847045870362276861106\
774130949410119612624380274679529647271294627526939490197641\
645383447755544661714281218489998189691140343327976729279891\
077101372792811842951182338559423852563331641533781432796742\
873181364582071661749961126386895359760476172215209100274274\
851619657020388051618654944574445941780637669570374280535432\
399157923698778110534174856844986671232161320063786308144771\
068130888985636449091787794632959555876880672773686838364706\
122084832995722603440165161942472322987408003421165899848443\
566885769845535074102932500939450142098799833145629484519298\
622410092757836842296697186410137365818568152771850732591405\
340248509247875448717161746544246407280913725135059228268131\
453903691495906528862410006254958805237716723952273129715780\
425223305517882562616830806755498203755676925741529569939445\
043490046171854709456730491532189688306135861932534903184518\
717706426178028900836080044604143054210332610482947502104703\
032028463320549525316174330585387581543470878545616097381416\
151451037487775797335749896735101048367502483255117772375025\
269956476872153642623856062175536913321594213515989059505375\
135183515207096576145781316398544325320022366962008554087665\
201050763789833457082359181807492731245904330245198691471329\
319324627030678762142685799400660305214140453863665517807185\
105354694177602424937823924511789133225030926924236498557565\
212794565582753399214908928688568628950225640472058381324292\
866007645368390366981937596341868992912741319342960598330486\
905946276235953206760977215407164729909506118583728562718724\
235732515062300426080741679038098122641980345051854359908213\
563779664847422505775922437272989231878912994048540484468227\
199282393172540734295329890896755037903724644870572648941076\
132423009124870700536763793881894969000042397318202298868940\
530196108237639578098191879486398269734335286831689173606327\
500405178476864790935386838169242131756729797688220656276969\
434749140204830563840068728357383111109865861495106613619153\
421725274090787422508800568671498311491210197298472420373359\
044400631309819996507004167876832936101195902219429743174557\
163362274547892397934880322990633165889175059124060202200452\
648684577182821651588921716304707095995039972827781680978274\
973838841958209215836456212939412000456040621743349981715350\
305133662772937143899882197561295808685181679238411733642697\
748892466944352640514849114619882270112386610376024527101889\
119004382703622803911212700216792471528793241950356942780714\
774957204475130171711488773121937363663487116301055073658645\
980695862570269762957141239436916216723776945522480189876803\
386123827956059851911061129713987960026363403936931196519733\
447116468545744829997003979525368783485129837821983305137448\
031689360764270759437872004895754351479890333865299565515706\
690471030702230767978923298480584997256328135245813726407464\
159230169328539541524724878662873185450510653764301207480799\
488602832618557388369552461881286225098286358672257087829660\
174231705350465091313887538950130611513878400895128618426154\
417299623157313010877679890009181366178705821415173309356192\
686429159835537275875876767919535369607142366878476025895389\
279625854409611312402187942369446302119309705461187450803468\
606366203101933821675974655441744883993796837164178911391575\
751463591650231265941242686108002052587760190005508737394014\
453031299745602214380618917954427803281262300931789525045703\
809571995929933387196864877982754748535701000330924817431298\
365273697561943437891318220691072831562717726798635382168915\
187137325209768346284183473712613689334546294053718697897526\
843398053681374508250012035211936425982389543291022583173280\
985811169783438836113209408147936547458073361625570571955232\
746103236016857123149307991441916732438322836596693687161268\
151183603534413030099360835441935243365729307681545065674775\
655582111435085683962037818795920337874290127531069511296530\
746308404963763022896682861683252995925040540038039172626001\
958340013361801588367655990575379797454237110701588716509764\
759243657077584013289594787913434812509790293636440469725564\
222946985585616708175959944099853232059130350099233608207347\
955460820122006976717445739825352919058005528371183277021250\
186916447745609162301667393077050176560656798672598371789181\
232542195795945358691713761483976100058707499929103557275695\
937295677892604799308353051124627278706035295473126217205599\
530746756205492173148619619059839609108464715691924592576481\
382126740168148453274964955074129767533813576349605298268179\
068244338581354855186516322703199278802275718580352103754433\
240982354636196477238624205575823556321375833700666021556412\
182358152808745703724362178773168996492870519432472065091133\
11767578125001e-4966L;
/* 0x1.8p-16494 */
static const long double ld2ae = 0x1p-16494L, ld2be = 0x2p-16494L, ld1ce = 0x2p-16494L;
static const long double ld2a =
9.7127626791570376663866584373414698287493540070520215145348\
265837955593101861790565265072369149749103838172122152721795\
148808298295738130700276651079589269745641890661270024016251\
019384577076103591727897583309855871833343782567221021062330\
520323854737144092431836545425360063420220465935798468889597\
393404878618618014948930985668173745969857941024624992678516\
796046407897341714914468689706271051039477065250599233051128\
834730700520991768191047336500699552011524055936141175278227\
064109997091342657525775034753507507952039644285302561195715\
206557908066743405503232817530015665644259150328222704419796\
441925506500088029030962482377765030782723392665098962794517\
576730231882534561711832295689196981946271461652617181055665\
029685844922254588158309151172148171793920968125962871768401\
514219388391855549421226044104700106207541829733799638752028\
173330033785725845708464578148564931432318289223948214495353\
081747057754695954292472958266030251293951030611301194357888\
019943253579850479798277589149352414382665544987175298434214\
478200760268387259124784797823102040919106572400856191771348\
281558462777916462381681390008210723234194499857395959685631\
103905591697879596717577715572554824817827584594613762331897\
400606438644266287902006019904862430824505901556613731586390\
168599701978602862986749723963103806767402004526070426607181\
825747922672223610811748401048244356042029124854637072147748\
725579398139682075412513930407121100054336291386326642984001\
127998334974858209653245050832581320436526628590981309844730\
407816586888468434842085594277964816488928181716264953794825\
008820444984449555836465896129531451786104307525226808006600\
779348570662654426040504120543057111107378732433349774914269\
114072708176913318160948697397435213257520066915742989940448\
143697754422357993424629248859049440534892849320746268179914\
554583983135330126247834945300073309752528242351508345806997\
166008883707127049913489117882817860966482186638832168035518\
547034785578194655682192342735350140833854383710286830614088\
160157865037563419851961350527354941108767405900340732309106\
276336035381203764047251096208168592703256215746762632401447\
152692930097455870617179441468393769999033655798513790480379\
006890871305232768065242533442449079450072575765459163647064\
342973773862113844201909366754475759002671807165811771132763\
080642939637475165826471100668049369686467070723571785727451\
880981477281249312246654190920467838735709729099560268987993\
922945108459361151792094263319471761024927851228982814252213\
519491081673366498846956075196529123585663883716590919107614\
633893976419001988983816482034201465056277885540374744476861\
750132141428803822571155963108435657119217200055907192435247\
874999372748282438180554683005862623824642214599119474694103\
960853742166199856978367947235980051781968651483783495342232\
954349909573385979410403141459464534634995394356365919502754\
724946777741899521109008000695745645078551399660814021116536\
655749435948779817814066783795859497355305214492181630929578\
847199238542943651540507599871461279285579624694324361023373\
707531098971698541342280852237066460615431579189178378561194\
172524973953556992919385025122842333469297321105671995800309\
309633498690867723547140713111442746824881534458886302917356\
653091434863492329838352758301829757778933132703869088008094\
675627125816403572843436425276619486609339270853697062497300\
328870997605020552097286001653505594207990557642339328807413\
227100406607755741340441132517749388595948759195317512557878\
416233575616587901198472089121093330999897692799317101600836\
099489460591403665960336872530069816871780920562654935511809\
645452735200740179624950793984014164529466444382558710840503\
646450512405234491455440034942909031078393317704206940370308\
684236835526397150556746599533254593941633896202932393007537\
673266074923116068628384786062194914042771295779439885715389\
357594885989682121213153533215605128333850742639410724967673\
883284678814436067523913854991596587657401966348100597154425\
325485566823423076082201071414803929712348781452793135058870\
492918348933242055431354758500236922407134394398698076450588\
396958158802767825944728350880686237998680915415443167076178\
911739085748840458235337085643267137446973020988327650097647\
165014946264643975815638479556314291101645367935123993093786\
582600438548945848259707843279161086198675408925933600311615\
428118865841645716039791455856756541424710978756200560993332\
887344427373688627922683426869140915164843256020904560951477\
891674986393096433202120538411067908090153863118403925770011\
018063004678778615949475991732024974692553643880962797066439\
850738990118773176131476115230730262123167407320563510551236\
743953710665679470765273617718616108994029022776271817109585\
266594261331597335282139081984596344964057781522191646561827\
550790563823105342889841684791723392119663413065274464824389\
193009710215891507033131686963884367885455869616509038575859\
401565845913422314243208408202380488923480307905914026187792\
173761338231822535262836663234810324357814170469665216751909\
358778546855365681180620451075947932208061785930047186745864\
869465034307360299821666637866586258459810085040702059082829\
751567542893449238034641018001458509309792474567933738149575\
554449108144820908702151811237205173697690115303153085234681\
514152955272511661522989847510493796115116064878740702806004\
343433164318094216952115530098938898426308252149645340589562\
644869225768357954631994812409839231441980355794430127694896\
896491616863512720318746239544591731455028723849548933141295\
953669192660989415044776894176322467844855976195199023921936\
699427841174911239593401205926299751407204361412696320213363\
304107778816937724874521837448233888318479329375321435968913\
261660516526419532347019419540663257128411929128403012569143\
516560220706745585698808432508320490642705990501525005042508\
275152136114303501571602916305930838603123093402367005177263\
895812313295965866584099164896749137750449430252650456393558\
866481394042988928722749344174035609284576107405441387577215\
111650422217580504962998404223989353315671519700308885487441\
513727141662624359402989615511685507459107087446822399682449\
124027371539629961321880337101198819624529636970480400208723\
642799448540704293456340205242051084761997006863111517147530\
365332128784516968162146751508776010231492748374862213804161\
453894620976763957492805125680148697998824491969672971166027\
180656446801877171069880212083821586527774381471938887462267\
296899230122475689865309301760858111386017280236814433190859\
056775862835626324841690460105276503738155096364862500284444\
534355852480049710328635489743555059728455908589253208618030\
435328529902401798471113159138000614546932833170782820217007\
280555759644239993454255391040403122345898223865007840565901\
568897868969477318635101744807938902538658059188203743585010\
774036188072258210874395280659266831769875140840386730345127\
896213224531135734216598150684561709935188763611823258429535\
949485724798457980490432226268479100942840366849845718310701\
201469881667256363013936740095127208213646187168979882123038\
233894681808950467950348320835221712924541137611086830583320\
322392848230358837873140824038588941813883882580818470592924\
936150343266633985142843655469994569073421029983930187839673\
231304118378435528853547015678271557689994924601344298390228\
619544093746214985249883379160686079281428516645627300822824\
554858971061164154855964833723337825341913008711122841606297\
197473771096334331602524570534960013696483960191358924434313\
204392666956909347275363383898878667630642018321060515094118\
366254498987167810320495485827416968962224010263497699545330\
700657309536605222308797502818350426296399499436888453557895\
867230278273510526890091559230412097455704458315552197774216\
020745527743626346151485239632739221842741175405177684804394\
361711074487719586587230018764876415713150171856819389147341\
275669916553647687850492420266494611267030777224588709818335\
130470138515564128370191474596569064918407585797604709553556\
153119278534086702508240133812429162630997831448842506314109\
096085389961648575948522991756162744630412635636848292144248\
454353112463327392007249690205303145102507449765353317125075\
809869430616460927871568186526610739964782640547967178516125\
405550545621289728437343949195632975960067100886025662262995\
603152291369500371247077545422478193737712990735596074413987\
957973881092036286428057398201980915642421361590996553421555\
316064082532807274813471773535367399675092780772709495672695\
638383696748260197644726786065705886850676921416175143972878\
598022936105171100945812789025606978738223958028881794991460\
717838828707859620282931646221494189728518355751185688156172\
707197545186901278242225037114294367925941035155563079724640\
691338994542267517327767311818967695636738982145621453404681\
597847179517622202885989672690265113711173934611717946823228\
397269027374612101610291381645684907000127191954606896606821\
590588324712918734294575638459194809203005860495067520818982\
501215535430594372806160514507726395270189393064661968830908\
304247420614491691520206185072149333329597584485319840857460\
265175822272362267526401706014494934473630591895417261120077\
133201893929459989521012503630498808303587706658289229523671\
490086823643677193804640968971899497667525177372180606601357\
946053731548464954766765148914121287985119918483345042934824\
921516525874627647509368638818236001368121865230049945146050\
915400988318811431699646592683887426055545037715235200928093\
246677400833057921544547343859646810337159831128073581305667\
357013148110868411733638100650377414586379725851070828342144\
324871613425390515134466319365812090990461348903165220975937\
942087587710809288871423718310748650171330836567440569630410\
158371483868179555733183389141963880079090211810793589559200\
341349405637234489991011938576106350455389513465949915412344\
095068082292812278313616014687263054439671001595898696547120\
071413092106692303936769895441754991768984405737441179222392\
477690507985618624574174635988619556351531961292903622442398\
465808497855672165108657385643858675294859076016771263488980\
522695116051395273941662616850391834541635202685385855278463\
251898869471939032633039670027544098536117464245519928068578\
059287479506611827627630303758606108821427100635428077686167\
838877563228833937206563827108338906357929116383562352410405\
819098609305801465027923966325234651981390511492536734174727\
254390774950693797823728058324006157763280570016526212182043\
359093899236806643141856753863283409843786902795368575137111\
428715987789800161590594633948264245607103000992774452293895\
095821092685830313673954662073218494688153180395906146506745\
561411975629305038852550421137841068003638882161156093692580\
530194161044123524750036105635809277947168629873067749519842\
957433509350316508339628224443809642374220084876711715865698\
238309708050571369447923974325750197314968509790081061483804\
453550810603239090298082506325805730097187923044635197024326\
966746334305257051886113456387761013622870382593208533889592\
238925214891289068690048585049758987775121620114117517878005\
875020040085404765102967971726139392362711332104766149529294\
277730971232752039868784363740304437529370880909321409176692\
668840956756850124527879832299559696177391050297700824622043\
866382460366020930152337219476058757174016585113549831063750\
560749343236827486905002179231150529681970396017795115367543\
697626587387836076075141284451928300176122499787310671827087\
811887033677814397925059153373881836118105886419378651616798\
592240268616476519445858857179518827325394147075773777729444\
146380220504445359824894865222389302601440729048815894804537\
204733015744064565559548968109597836406827155741056311263299\
722947063908589431715872616727470668964127501101998064669236\
547074458426237111173086536319506989478611558297416195273399\
35302734374999e-4966L;
static const long double ld2b =
9.7127626791570376663866584373414698287493540070520215145348\
265837955593101861790565265072369149749103838172122152721795\
148808298295738130700276651079589269745641890661270024016251\
019384577076103591727897583309855871833343782567221021062330\
520323854737144092431836545425360063420220465935798468889597\
393404878618618014948930985668173745969857941024624992678516\
796046407897341714914468689706271051039477065250599233051128\
834730700520991768191047336500699552011524055936141175278227\
064109997091342657525775034753507507952039644285302561195715\
206557908066743405503232817530015665644259150328222704419796\
441925506500088029030962482377765030782723392665098962794517\
576730231882534561711832295689196981946271461652617181055665\
029685844922254588158309151172148171793920968125962871768401\
514219388391855549421226044104700106207541829733799638752028\
173330033785725845708464578148564931432318289223948214495353\
081747057754695954292472958266030251293951030611301194357888\
019943253579850479798277589149352414382665544987175298434214\
478200760268387259124784797823102040919106572400856191771348\
281558462777916462381681390008210723234194499857395959685631\
103905591697879596717577715572554824817827584594613762331897\
400606438644266287902006019904862430824505901556613731586390\
168599701978602862986749723963103806767402004526070426607181\
825747922672223610811748401048244356042029124854637072147748\
725579398139682075412513930407121100054336291386326642984001\
127998334974858209653245050832581320436526628590981309844730\
407816586888468434842085594277964816488928181716264953794825\
008820444984449555836465896129531451786104307525226808006600\
779348570662654426040504120543057111107378732433349774914269\
114072708176913318160948697397435213257520066915742989940448\
143697754422357993424629248859049440534892849320746268179914\
554583983135330126247834945300073309752528242351508345806997\
166008883707127049913489117882817860966482186638832168035518\
547034785578194655682192342735350140833854383710286830614088\
160157865037563419851961350527354941108767405900340732309106\
276336035381203764047251096208168592703256215746762632401447\
152692930097455870617179441468393769999033655798513790480379\
006890871305232768065242533442449079450072575765459163647064\
342973773862113844201909366754475759002671807165811771132763\
080642939637475165826471100668049369686467070723571785727451\
880981477281249312246654190920467838735709729099560268987993\
922945108459361151792094263319471761024927851228982814252213\
519491081673366498846956075196529123585663883716590919107614\
633893976419001988983816482034201465056277885540374744476861\
750132141428803822571155963108435657119217200055907192435247\
874999372748282438180554683005862623824642214599119474694103\
960853742166199856978367947235980051781968651483783495342232\
954349909573385979410403141459464534634995394356365919502754\
724946777741899521109008000695745645078551399660814021116536\
655749435948779817814066783795859497355305214492181630929578\
847199238542943651540507599871461279285579624694324361023373\
707531098971698541342280852237066460615431579189178378561194\
172524973953556992919385025122842333469297321105671995800309\
309633498690867723547140713111442746824881534458886302917356\
653091434863492329838352758301829757778933132703869088008094\
675627125816403572843436425276619486609339270853697062497300\
328870997605020552097286001653505594207990557642339328807413\
227100406607755741340441132517749388595948759195317512557878\
416233575616587901198472089121093330999897692799317101600836\
099489460591403665960336872530069816871780920562654935511809\
645452735200740179624950793984014164529466444382558710840503\
646450512405234491455440034942909031078393317704206940370308\
684236835526397150556746599533254593941633896202932393007537\
673266074923116068628384786062194914042771295779439885715389\
357594885989682121213153533215605128333850742639410724967673\
883284678814436067523913854991596587657401966348100597154425\
325485566823423076082201071414803929712348781452793135058870\
492918348933242055431354758500236922407134394398698076450588\
396958158802767825944728350880686237998680915415443167076178\
911739085748840458235337085643267137446973020988327650097647\
165014946264643975815638479556314291101645367935123993093786\
582600438548945848259707843279161086198675408925933600311615\
428118865841645716039791455856756541424710978756200560993332\
887344427373688627922683426869140915164843256020904560951477\
891674986393096433202120538411067908090153863118403925770011\
018063004678778615949475991732024974692553643880962797066439\
850738990118773176131476115230730262123167407320563510551236\
743953710665679470765273617718616108994029022776271817109585\
266594261331597335282139081984596344964057781522191646561827\
550790563823105342889841684791723392119663413065274464824389\
193009710215891507033131686963884367885455869616509038575859\
401565845913422314243208408202380488923480307905914026187792\
173761338231822535262836663234810324357814170469665216751909\
358778546855365681180620451075947932208061785930047186745864\
869465034307360299821666637866586258459810085040702059082829\
751567542893449238034641018001458509309792474567933738149575\
554449108144820908702151811237205173697690115303153085234681\
514152955272511661522989847510493796115116064878740702806004\
343433164318094216952115530098938898426308252149645340589562\
644869225768357954631994812409839231441980355794430127694896\
896491616863512720318746239544591731455028723849548933141295\
953669192660989415044776894176322467844855976195199023921936\
699427841174911239593401205926299751407204361412696320213363\
304107778816937724874521837448233888318479329375321435968913\
261660516526419532347019419540663257128411929128403012569143\
516560220706745585698808432508320490642705990501525005042508\
275152136114303501571602916305930838603123093402367005177263\
895812313295965866584099164896749137750449430252650456393558\
866481394042988928722749344174035609284576107405441387577215\
111650422217580504962998404223989353315671519700308885487441\
513727141662624359402989615511685507459107087446822399682449\
124027371539629961321880337101198819624529636970480400208723\
642799448540704293456340205242051084761997006863111517147530\
365332128784516968162146751508776010231492748374862213804161\
453894620976763957492805125680148697998824491969672971166027\
180656446801877171069880212083821586527774381471938887462267\
296899230122475689865309301760858111386017280236814433190859\
056775862835626324841690460105276503738155096364862500284444\
534355852480049710328635489743555059728455908589253208618030\
435328529902401798471113159138000614546932833170782820217007\
280555759644239993454255391040403122345898223865007840565901\
568897868969477318635101744807938902538658059188203743585010\
774036188072258210874395280659266831769875140840386730345127\
896213224531135734216598150684561709935188763611823258429535\
949485724798457980490432226268479100942840366849845718310701\
201469881667256363013936740095127208213646187168979882123038\
233894681808950467950348320835221712924541137611086830583320\
322392848230358837873140824038588941813883882580818470592924\
936150343266633985142843655469994569073421029983930187839673\
231304118378435528853547015678271557689994924601344298390228\
619544093746214985249883379160686079281428516645627300822824\
554858971061164154855964833723337825341913008711122841606297\
197473771096334331602524570534960013696483960191358924434313\
204392666956909347275363383898878667630642018321060515094118\
366254498987167810320495485827416968962224010263497699545330\
700657309536605222308797502818350426296399499436888453557895\
867230278273510526890091559230412097455704458315552197774216\
020745527743626346151485239632739221842741175405177684804394\
361711074487719586587230018764876415713150171856819389147341\
275669916553647687850492420266494611267030777224588709818335\
130470138515564128370191474596569064918407585797604709553556\
153119278534086702508240133812429162630997831448842506314109\
096085389961648575948522991756162744630412635636848292144248\
454353112463327392007249690205303145102507449765353317125075\
809869430616460927871568186526610739964782640547967178516125\
405550545621289728437343949195632975960067100886025662262995\
603152291369500371247077545422478193737712990735596074413987\
957973881092036286428057398201980915642421361590996553421555\
316064082532807274813471773535367399675092780772709495672695\
638383696748260197644726786065705886850676921416175143972878\
598022936105171100945812789025606978738223958028881794991460\
717838828707859620282931646221494189728518355751185688156172\
707197545186901278242225037114294367925941035155563079724640\
691338994542267517327767311818967695636738982145621453404681\
597847179517622202885989672690265113711173934611717946823228\
397269027374612101610291381645684907000127191954606896606821\
590588324712918734294575638459194809203005860495067520818982\
501215535430594372806160514507726395270189393064661968830908\
304247420614491691520206185072149333329597584485319840857460\
265175822272362267526401706014494934473630591895417261120077\
133201893929459989521012503630498808303587706658289229523671\
490086823643677193804640968971899497667525177372180606601357\
946053731548464954766765148914121287985119918483345042934824\
921516525874627647509368638818236001368121865230049945146050\
915400988318811431699646592683887426055545037715235200928093\
246677400833057921544547343859646810337159831128073581305667\
357013148110868411733638100650377414586379725851070828342144\
324871613425390515134466319365812090990461348903165220975937\
942087587710809288871423718310748650171330836567440569630410\
158371483868179555733183389141963880079090211810793589559200\
341349405637234489991011938576106350455389513465949915412344\
095068082292812278313616014687263054439671001595898696547120\
071413092106692303936769895441754991768984405737441179222392\
477690507985618624574174635988619556351531961292903622442398\
465808497855672165108657385643858675294859076016771263488980\
522695116051395273941662616850391834541635202685385855278463\
251898869471939032633039670027544098536117464245519928068578\
059287479506611827627630303758606108821427100635428077686167\
838877563228833937206563827108338906357929116383562352410405\
819098609305801465027923966325234651981390511492536734174727\
254390774950693797823728058324006157763280570016526212182043\
359093899236806643141856753863283409843786902795368575137111\
428715987789800161590594633948264245607103000992774452293895\
095821092685830313673954662073218494688153180395906146506745\
561411975629305038852550421137841068003638882161156093692580\
530194161044123524750036105635809277947168629873067749519842\
957433509350316508339628224443809642374220084876711715865698\
238309708050571369447923974325750197314968509790081061483804\
453550810603239090298082506325805730097187923044635197024326\
966746334305257051886113456387761013622870382593208533889592\
238925214891289068690048585049758987775121620114117517878005\
875020040085404765102967971726139392362711332104766149529294\
277730971232752039868784363740304437529370880909321409176692\
668840956756850124527879832299559696177391050297700824622043\
866382460366020930152337219476058757174016585113549831063750\
560749343236827486905002179231150529681970396017795115367543\
697626587387836076075141284451928300176122499787310671827087\
811887033677814397925059153373881836118105886419378651616798\
592240268616476519445858857179518827325394147075773777729444\
146380220504445359824894865222389302601440729048815894804537\
204733015744064565559548968109597836406827155741056311263299\
722947063908589431715872616727470668964127501101998064669236\
547074458426237111173086536319506989478611558297416195273399\
35302734375e-4966L;
static const long double ld2c =
9.7127626791570376663866584373414698287493540070520215145348\
265837955593101861790565265072369149749103838172122152721795\
148808298295738130700276651079589269745641890661270024016251\
019384577076103591727897583309855871833343782567221021062330\
520323854737144092431836545425360063420220465935798468889597\
393404878618618014948930985668173745969857941024624992678516\
796046407897341714914468689706271051039477065250599233051128\
834730700520991768191047336500699552011524055936141175278227\
064109997091342657525775034753507507952039644285302561195715\
206557908066743405503232817530015665644259150328222704419796\
441925506500088029030962482377765030782723392665098962794517\
576730231882534561711832295689196981946271461652617181055665\
029685844922254588158309151172148171793920968125962871768401\
514219388391855549421226044104700106207541829733799638752028\
173330033785725845708464578148564931432318289223948214495353\
081747057754695954292472958266030251293951030611301194357888\
019943253579850479798277589149352414382665544987175298434214\
478200760268387259124784797823102040919106572400856191771348\
281558462777916462381681390008210723234194499857395959685631\
103905591697879596717577715572554824817827584594613762331897\
400606438644266287902006019904862430824505901556613731586390\
168599701978602862986749723963103806767402004526070426607181\
825747922672223610811748401048244356042029124854637072147748\
725579398139682075412513930407121100054336291386326642984001\
127998334974858209653245050832581320436526628590981309844730\
407816586888468434842085594277964816488928181716264953794825\
008820444984449555836465896129531451786104307525226808006600\
779348570662654426040504120543057111107378732433349774914269\
114072708176913318160948697397435213257520066915742989940448\
143697754422357993424629248859049440534892849320746268179914\
554583983135330126247834945300073309752528242351508345806997\
166008883707127049913489117882817860966482186638832168035518\
547034785578194655682192342735350140833854383710286830614088\
160157865037563419851961350527354941108767405900340732309106\
276336035381203764047251096208168592703256215746762632401447\
152692930097455870617179441468393769999033655798513790480379\
006890871305232768065242533442449079450072575765459163647064\
342973773862113844201909366754475759002671807165811771132763\
080642939637475165826471100668049369686467070723571785727451\
880981477281249312246654190920467838735709729099560268987993\
922945108459361151792094263319471761024927851228982814252213\
519491081673366498846956075196529123585663883716590919107614\
633893976419001988983816482034201465056277885540374744476861\
750132141428803822571155963108435657119217200055907192435247\
874999372748282438180554683005862623824642214599119474694103\
960853742166199856978367947235980051781968651483783495342232\
954349909573385979410403141459464534634995394356365919502754\
724946777741899521109008000695745645078551399660814021116536\
655749435948779817814066783795859497355305214492181630929578\
847199238542943651540507599871461279285579624694324361023373\
707531098971698541342280852237066460615431579189178378561194\
172524973953556992919385025122842333469297321105671995800309\
309633498690867723547140713111442746824881534458886302917356\
653091434863492329838352758301829757778933132703869088008094\
675627125816403572843436425276619486609339270853697062497300\
328870997605020552097286001653505594207990557642339328807413\
227100406607755741340441132517749388595948759195317512557878\
416233575616587901198472089121093330999897692799317101600836\
099489460591403665960336872530069816871780920562654935511809\
645452735200740179624950793984014164529466444382558710840503\
646450512405234491455440034942909031078393317704206940370308\
684236835526397150556746599533254593941633896202932393007537\
673266074923116068628384786062194914042771295779439885715389\
357594885989682121213153533215605128333850742639410724967673\
883284678814436067523913854991596587657401966348100597154425\
325485566823423076082201071414803929712348781452793135058870\
492918348933242055431354758500236922407134394398698076450588\
396958158802767825944728350880686237998680915415443167076178\
911739085748840458235337085643267137446973020988327650097647\
165014946264643975815638479556314291101645367935123993093786\
582600438548945848259707843279161086198675408925933600311615\
428118865841645716039791455856756541424710978756200560993332\
887344427373688627922683426869140915164843256020904560951477\
891674986393096433202120538411067908090153863118403925770011\
018063004678778615949475991732024974692553643880962797066439\
850738990118773176131476115230730262123167407320563510551236\
743953710665679470765273617718616108994029022776271817109585\
266594261331597335282139081984596344964057781522191646561827\
550790563823105342889841684791723392119663413065274464824389\
193009710215891507033131686963884367885455869616509038575859\
401565845913422314243208408202380488923480307905914026187792\
173761338231822535262836663234810324357814170469665216751909\
358778546855365681180620451075947932208061785930047186745864\
869465034307360299821666637866586258459810085040702059082829\
751567542893449238034641018001458509309792474567933738149575\
554449108144820908702151811237205173697690115303153085234681\
514152955272511661522989847510493796115116064878740702806004\
343433164318094216952115530098938898426308252149645340589562\
644869225768357954631994812409839231441980355794430127694896\
896491616863512720318746239544591731455028723849548933141295\
953669192660989415044776894176322467844855976195199023921936\
699427841174911239593401205926299751407204361412696320213363\
304107778816937724874521837448233888318479329375321435968913\
261660516526419532347019419540663257128411929128403012569143\
516560220706745585698808432508320490642705990501525005042508\
275152136114303501571602916305930838603123093402367005177263\
895812313295965866584099164896749137750449430252650456393558\
866481394042988928722749344174035609284576107405441387577215\
111650422217580504962998404223989353315671519700308885487441\
513727141662624359402989615511685507459107087446822399682449\
124027371539629961321880337101198819624529636970480400208723\
642799448540704293456340205242051084761997006863111517147530\
365332128784516968162146751508776010231492748374862213804161\
453894620976763957492805125680148697998824491969672971166027\
180656446801877171069880212083821586527774381471938887462267\
296899230122475689865309301760858111386017280236814433190859\
056775862835626324841690460105276503738155096364862500284444\
534355852480049710328635489743555059728455908589253208618030\
435328529902401798471113159138000614546932833170782820217007\
280555759644239993454255391040403122345898223865007840565901\
568897868969477318635101744807938902538658059188203743585010\
774036188072258210874395280659266831769875140840386730345127\
896213224531135734216598150684561709935188763611823258429535\
949485724798457980490432226268479100942840366849845718310701\
201469881667256363013936740095127208213646187168979882123038\
233894681808950467950348320835221712924541137611086830583320\
322392848230358837873140824038588941813883882580818470592924\
936150343266633985142843655469994569073421029983930187839673\
231304118378435528853547015678271557689994924601344298390228\
619544093746214985249883379160686079281428516645627300822824\
554858971061164154855964833723337825341913008711122841606297\
197473771096334331602524570534960013696483960191358924434313\
204392666956909347275363383898878667630642018321060515094118\
366254498987167810320495485827416968962224010263497699545330\
700657309536605222308797502818350426296399499436888453557895\
867230278273510526890091559230412097455704458315552197774216\
020745527743626346151485239632739221842741175405177684804394\
361711074487719586587230018764876415713150171856819389147341\
275669916553647687850492420266494611267030777224588709818335\
130470138515564128370191474596569064918407585797604709553556\
153119278534086702508240133812429162630997831448842506314109\
096085389961648575948522991756162744630412635636848292144248\
454353112463327392007249690205303145102507449765353317125075\
809869430616460927871568186526610739964782640547967178516125\
405550545621289728437343949195632975960067100886025662262995\
603152291369500371247077545422478193737712990735596074413987\
957973881092036286428057398201980915642421361590996553421555\
316064082532807274813471773535367399675092780772709495672695\
638383696748260197644726786065705886850676921416175143972878\
598022936105171100945812789025606978738223958028881794991460\
717838828707859620282931646221494189728518355751185688156172\
707197545186901278242225037114294367925941035155563079724640\
691338994542267517327767311818967695636738982145621453404681\
597847179517622202885989672690265113711173934611717946823228\
397269027374612101610291381645684907000127191954606896606821\
590588324712918734294575638459194809203005860495067520818982\
501215535430594372806160514507726395270189393064661968830908\
304247420614491691520206185072149333329597584485319840857460\
265175822272362267526401706014494934473630591895417261120077\
133201893929459989521012503630498808303587706658289229523671\
490086823643677193804640968971899497667525177372180606601357\
946053731548464954766765148914121287985119918483345042934824\
921516525874627647509368638818236001368121865230049945146050\
915400988318811431699646592683887426055545037715235200928093\
246677400833057921544547343859646810337159831128073581305667\
357013148110868411733638100650377414586379725851070828342144\
324871613425390515134466319365812090990461348903165220975937\
942087587710809288871423718310748650171330836567440569630410\
158371483868179555733183389141963880079090211810793589559200\
341349405637234489991011938576106350455389513465949915412344\
095068082292812278313616014687263054439671001595898696547120\
071413092106692303936769895441754991768984405737441179222392\
477690507985618624574174635988619556351531961292903622442398\
465808497855672165108657385643858675294859076016771263488980\
522695116051395273941662616850391834541635202685385855278463\
251898869471939032633039670027544098536117464245519928068578\
059287479506611827627630303758606108821427100635428077686167\
838877563228833937206563827108338906357929116383562352410405\
819098609305801465027923966325234651981390511492536734174727\
254390774950693797823728058324006157763280570016526212182043\
359093899236806643141856753863283409843786902795368575137111\
428715987789800161590594633948264245607103000992774452293895\
095821092685830313673954662073218494688153180395906146506745\
561411975629305038852550421137841068003638882161156093692580\
530194161044123524750036105635809277947168629873067749519842\
957433509350316508339628224443809642374220084876711715865698\
238309708050571369447923974325750197314968509790081061483804\
453550810603239090298082506325805730097187923044635197024326\
966746334305257051886113456387761013622870382593208533889592\
238925214891289068690048585049758987775121620114117517878005\
875020040085404765102967971726139392362711332104766149529294\
277730971232752039868784363740304437529370880909321409176692\
668840956756850124527879832299559696177391050297700824622043\
866382460366020930152337219476058757174016585113549831063750\
560749343236827486905002179231150529681970396017795115367543\
697626587387836076075141284451928300176122499787310671827087\
811887033677814397925059153373881836118105886419378651616798\
592240268616476519445858857179518827325394147075773777729444\
146380220504445359824894865222389302601440729048815894804537\
204733015744064565559548968109597836406827155741056311263299\
722947063908589431715872616727470668964127501101998064669236\
547074458426237111173086536319506989478611558297416195273399\
35302734375001e-4966L;
/* 0x1.00000000000000000000000000008p16383 */
static const long double ld3ae = 0x1p16383L, ld3be = 0x1p16383L, ld3ce = 0x1.0000000000000000000000000001p16383L;
static const long double ld3a =
5.9486574767861588254287966331400362266521016077566321470782\
537912717956830282749074200158904838100315216442070246474582\
902003466452178519493817532236893426065414065500349426609921\
035191682920005861156266113904955955975156868485667432573303\
878926292023832306985858165533616318247459636179261303962505\
904914506095247123433601806274279678546351097459236573913920\
031119173565521719790447288258729779003490433862818295682642\
966216118764004792730459319737327354906008978235133081179386\
661103577408353480771246949457853166617701522167422003413661\
284349262437896929014552545611813747697933241007066137144800\
742052491919942298834913628182656296203230288447275444631994\
418174246363265098248611943128819168942591708210157385631417\
956400560296628065072016801065604053356267458749418972817500\
860163920552394032596390414022010839803056885484295371329659\
344624001094572196271168792142488910586863048428263135994222\
918660801863635503541746352435642903327106245556596971697306\
154375736529491499973297647239267168544491542059174479409314\
453930981788080813637734358380528957486229480817553751111130\
404254432007093360403147894746265072027252334199618554793914\
408408563073872776198001518686536858983411123156743992398602\
085226973929708268146742705557350571330511483380748376403472\
416543579901056379914358020396036857647833383066531875675143\
906511120597222727322243981995901699031025427175941279288823\
868963521340475095965307606235778429805072284801680535137734\
383642104178041358430293569208331406005130704155581295151191\
023575851522079817808333970280354640050199344622016227349001\
158400930280667186488774262251890453600109065837537684194570\
764422774923245437306731669764159584659798151950637627762794\
773771743234047950402370403351226180108444229650943701626484\
199813157683590670152514287926030050893275989087988431157294\
053225152320381185461962202878894704210605536874860744635921\
856800920799848781308318732102232154544901177747472418520161\
539850654183977571241391795912749098112352006092865789718049\
308722403022684428414862730635213534446271587083620368851394\
539053886621230946713996355227159995125430034494483477708852\
290917108703653719242299789100268057863851224567265334616704\
172517852701300018859009181286438758473871366303386211559752\
189988549719766361306120241141163757479824826687017385967199\
730649217746155593260923125994938678356692052428393066501806\
030161358556419313420716683771612548240263459903320490075985\
482955242306590857238462197972208846146747634114611463194143\
127229709932188005016692926586196070737427116881065809283735\
578248117685225847553587906225824731173075427424421056682930\
008434666477496431516691881829440430197100204332606435934395\
919650053069892524027974091575173698894803107552411683630872\
565514028274910395383420510115859479233531504702656455261624\
525121293886827716275308028935388238178963278225114817400178\
138358373030159940110845417191798464503817960506134575572552\
914585335913528444536373142082490326061583126796147603336390\
503084982226891516248370317420733394038771780044922478150880\
480334844447412365553656029955296322473008695074712792828366\
405738282245039545396582938290818627301780773130202921675326\
417583673495241569334204568141534153408474297319168484568799\
451491133718839097374713416523361939237171154953070144389353\
699828605993755613252573941610133829557167740458222617685028\
690018342727148122013513056358815140027414679795450105000784\
206522215604435223172005007036171570530334304897008809135848\
675229547083561399988252552429769084290516103080260036003448\
294799988351419108088251107290628711358276092795741489822211\
879153727229891058795497426373608319405317602924241055836665\
412584135657242160003706626205312971822953452930840783143003\
733239017808969394445195220787737174218027747221253900890536\
730326425051240764874006627032589076376990325467270006751475\
463920721323985366812116303998245085483206258613663624851716\
293180303624443281556295689730668616708901429287181381627670\
203893651414675005136379365959571811951919653635887567699289\
348324076406793991923217469674198904524716009847788439650157\
995310043698774137542541699134940585662745702625097983274489\
141416414789061652098131796728731652650516767112149192122453\
562328802846445391417036742140146906572447511494124473885963\
235217227016424204095604485308686968373890645296189932416571\
281295736247619241329068636405743573306087991776733585972793\
132869616481671565021096885870153734254648327143225051745267\
530463119926261147612098111086806545372953526471421579845285\
862975776235466663857936867536855924718593170503922894779577\
706239977813334283740751103082483280516469722321753891088699\
714361755511843803441649441302693703577359971743834932539197\
595873998629500074441134301810890941848881837426270390549007\
490141375766653241037340192392236932759127069111401216220596\
540958515892047794438580629374176225297401789362125586732528\
367695144980519774116001979888033796577336271850743828263427\
598863925843301048044096576340652808516459551933515596083641\
0468395384831999e+4931L;
static const long double ld3b =
5.9486574767861588254287966331400362266521016077566321470782\
537912717956830282749074200158904838100315216442070246474582\
902003466452178519493817532236893426065414065500349426609921\
035191682920005861156266113904955955975156868485667432573303\
878926292023832306985858165533616318247459636179261303962505\
904914506095247123433601806274279678546351097459236573913920\
031119173565521719790447288258729779003490433862818295682642\
966216118764004792730459319737327354906008978235133081179386\
661103577408353480771246949457853166617701522167422003413661\
284349262437896929014552545611813747697933241007066137144800\
742052491919942298834913628182656296203230288447275444631994\
418174246363265098248611943128819168942591708210157385631417\
956400560296628065072016801065604053356267458749418972817500\
860163920552394032596390414022010839803056885484295371329659\
344624001094572196271168792142488910586863048428263135994222\
918660801863635503541746352435642903327106245556596971697306\
154375736529491499973297647239267168544491542059174479409314\
453930981788080813637734358380528957486229480817553751111130\
404254432007093360403147894746265072027252334199618554793914\
408408563073872776198001518686536858983411123156743992398602\
085226973929708268146742705557350571330511483380748376403472\
416543579901056379914358020396036857647833383066531875675143\
906511120597222727322243981995901699031025427175941279288823\
868963521340475095965307606235778429805072284801680535137734\
383642104178041358430293569208331406005130704155581295151191\
023575851522079817808333970280354640050199344622016227349001\
158400930280667186488774262251890453600109065837537684194570\
764422774923245437306731669764159584659798151950637627762794\
773771743234047950402370403351226180108444229650943701626484\
199813157683590670152514287926030050893275989087988431157294\
053225152320381185461962202878894704210605536874860744635921\
856800920799848781308318732102232154544901177747472418520161\
539850654183977571241391795912749098112352006092865789718049\
308722403022684428414862730635213534446271587083620368851394\
539053886621230946713996355227159995125430034494483477708852\
290917108703653719242299789100268057863851224567265334616704\
172517852701300018859009181286438758473871366303386211559752\
189988549719766361306120241141163757479824826687017385967199\
730649217746155593260923125994938678356692052428393066501806\
030161358556419313420716683771612548240263459903320490075985\
482955242306590857238462197972208846146747634114611463194143\
127229709932188005016692926586196070737427116881065809283735\
578248117685225847553587906225824731173075427424421056682930\
008434666477496431516691881829440430197100204332606435934395\
919650053069892524027974091575173698894803107552411683630872\
565514028274910395383420510115859479233531504702656455261624\
525121293886827716275308028935388238178963278225114817400178\
138358373030159940110845417191798464503817960506134575572552\
914585335913528444536373142082490326061583126796147603336390\
503084982226891516248370317420733394038771780044922478150880\
480334844447412365553656029955296322473008695074712792828366\
405738282245039545396582938290818627301780773130202921675326\
417583673495241569334204568141534153408474297319168484568799\
451491133718839097374713416523361939237171154953070144389353\
699828605993755613252573941610133829557167740458222617685028\
690018342727148122013513056358815140027414679795450105000784\
206522215604435223172005007036171570530334304897008809135848\
675229547083561399988252552429769084290516103080260036003448\
294799988351419108088251107290628711358276092795741489822211\
879153727229891058795497426373608319405317602924241055836665\
412584135657242160003706626205312971822953452930840783143003\
733239017808969394445195220787737174218027747221253900890536\
730326425051240764874006627032589076376990325467270006751475\
463920721323985366812116303998245085483206258613663624851716\
293180303624443281556295689730668616708901429287181381627670\
203893651414675005136379365959571811951919653635887567699289\
348324076406793991923217469674198904524716009847788439650157\
995310043698774137542541699134940585662745702625097983274489\
141416414789061652098131796728731652650516767112149192122453\
562328802846445391417036742140146906572447511494124473885963\
235217227016424204095604485308686968373890645296189932416571\
281295736247619241329068636405743573306087991776733585972793\
132869616481671565021096885870153734254648327143225051745267\
530463119926261147612098111086806545372953526471421579845285\
862975776235466663857936867536855924718593170503922894779577\
706239977813334283740751103082483280516469722321753891088699\
714361755511843803441649441302693703577359971743834932539197\
595873998629500074441134301810890941848881837426270390549007\
490141375766653241037340192392236932759127069111401216220596\
540958515892047794438580629374176225297401789362125586732528\
367695144980519774116001979888033796577336271850743828263427\
598863925843301048044096576340652808516459551933515596083641\
0468395384832e+4931L;
static const long double ld3c =
5.9486574767861588254287966331400362266521016077566321470782\
537912717956830282749074200158904838100315216442070246474582\
902003466452178519493817532236893426065414065500349426609921\
035191682920005861156266113904955955975156868485667432573303\
878926292023832306985858165533616318247459636179261303962505\
904914506095247123433601806274279678546351097459236573913920\
031119173565521719790447288258729779003490433862818295682642\
966216118764004792730459319737327354906008978235133081179386\
661103577408353480771246949457853166617701522167422003413661\
284349262437896929014552545611813747697933241007066137144800\
742052491919942298834913628182656296203230288447275444631994\
418174246363265098248611943128819168942591708210157385631417\
956400560296628065072016801065604053356267458749418972817500\
860163920552394032596390414022010839803056885484295371329659\
344624001094572196271168792142488910586863048428263135994222\
918660801863635503541746352435642903327106245556596971697306\
154375736529491499973297647239267168544491542059174479409314\
453930981788080813637734358380528957486229480817553751111130\
404254432007093360403147894746265072027252334199618554793914\
408408563073872776198001518686536858983411123156743992398602\
085226973929708268146742705557350571330511483380748376403472\
416543579901056379914358020396036857647833383066531875675143\
906511120597222727322243981995901699031025427175941279288823\
868963521340475095965307606235778429805072284801680535137734\
383642104178041358430293569208331406005130704155581295151191\
023575851522079817808333970280354640050199344622016227349001\
158400930280667186488774262251890453600109065837537684194570\
764422774923245437306731669764159584659798151950637627762794\
773771743234047950402370403351226180108444229650943701626484\
199813157683590670152514287926030050893275989087988431157294\
053225152320381185461962202878894704210605536874860744635921\
856800920799848781308318732102232154544901177747472418520161\
539850654183977571241391795912749098112352006092865789718049\
308722403022684428414862730635213534446271587083620368851394\
539053886621230946713996355227159995125430034494483477708852\
290917108703653719242299789100268057863851224567265334616704\
172517852701300018859009181286438758473871366303386211559752\
189988549719766361306120241141163757479824826687017385967199\
730649217746155593260923125994938678356692052428393066501806\
030161358556419313420716683771612548240263459903320490075985\
482955242306590857238462197972208846146747634114611463194143\
127229709932188005016692926586196070737427116881065809283735\
578248117685225847553587906225824731173075427424421056682930\
008434666477496431516691881829440430197100204332606435934395\
919650053069892524027974091575173698894803107552411683630872\
565514028274910395383420510115859479233531504702656455261624\
525121293886827716275308028935388238178963278225114817400178\
138358373030159940110845417191798464503817960506134575572552\
914585335913528444536373142082490326061583126796147603336390\
503084982226891516248370317420733394038771780044922478150880\
480334844447412365553656029955296322473008695074712792828366\
405738282245039545396582938290818627301780773130202921675326\
417583673495241569334204568141534153408474297319168484568799\
451491133718839097374713416523361939237171154953070144389353\
699828605993755613252573941610133829557167740458222617685028\
690018342727148122013513056358815140027414679795450105000784\
206522215604435223172005007036171570530334304897008809135848\
675229547083561399988252552429769084290516103080260036003448\
294799988351419108088251107290628711358276092795741489822211\
879153727229891058795497426373608319405317602924241055836665\
412584135657242160003706626205312971822953452930840783143003\
733239017808969394445195220787737174218027747221253900890536\
730326425051240764874006627032589076376990325467270006751475\
463920721323985366812116303998245085483206258613663624851716\
293180303624443281556295689730668616708901429287181381627670\
203893651414675005136379365959571811951919653635887567699289\
348324076406793991923217469674198904524716009847788439650157\
995310043698774137542541699134940585662745702625097983274489\
141416414789061652098131796728731652650516767112149192122453\
562328802846445391417036742140146906572447511494124473885963\
235217227016424204095604485308686968373890645296189932416571\
281295736247619241329068636405743573306087991776733585972793\
132869616481671565021096885870153734254648327143225051745267\
530463119926261147612098111086806545372953526471421579845285\
862975776235466663857936867536855924718593170503922894779577\
706239977813334283740751103082483280516469722321753891088699\
714361755511843803441649441302693703577359971743834932539197\
595873998629500074441134301810890941848881837426270390549007\
490141375766653241037340192392236932759127069111401216220596\
540958515892047794438580629374176225297401789362125586732528\
367695144980519774116001979888033796577336271850743828263427\
598863925843301048044096576340652808516459551933515596083641\
0468395384832001e+4931L;
#endif

extern void abort (void);
extern void exit (int);

int
main (void)
{
#ifdef FLT_OK
  if (f1a != f1ae
      || f1b != f1be
      || f1c != f1ce
      || f2a != f2ae
      || f2b != f2be
      || f2c != f2ce
      || f3a != f3ae
      || f3b != f3be
      || f3c != f3ce)
    abort ();
#endif
#ifdef DBL_OK
  if (d1a != d1ae
      || d1b != d1be
      || d1c != d1ce
      || d2a != d2ae
      || d2b != d2be
      || d2c != d2ce
      || d3a != d3ae
      || d3b != d3be
      || d3c != d3ce)
    abort ();
#endif
#ifdef LDBL_OK
  if (ld1a != ld1ae
      || ld1b != ld1be
      || ld1c != ld1ce
      || ld2a != ld2ae
      || ld2b != ld2be
      || ld2c != ld2ce
      || ld3a != ld3ae
      || ld3b != ld3be
      || ld3c != ld3ce)
    abort ();
#endif
  exit (0);
}
