;; Faraday FA526 Pipeline Description
;; Copyright (C) 2010-2013 Free Software Foundation, Inc.
;; Written by I-Jui Sung, based on ARM926EJ-S Pipeline Description.

;; This file is part of GCC.
;;
;; GCC is free software; you can redistribute it and/or modify it under
;; the terms of the GNU General Public License as published by the Free
;; Software Foundation; either version 3, or (at your option) any later
;; version.
;;
;; GCC is distributed in the hope that it will be useful, but WITHOUT ANY
;; WARRANTY; without even the implied warranty of MERCHANTABILITY or
;; FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
;; for more details.
;;
;; You should have received a copy of the GNU General Public License
;; along with GCC; see the file COPYING3.  If not see
;; <http://www.gnu.org/licenses/>.  */

;; These descriptions are based on the information contained in the
;; FA526 Core Design Note, Copyright (c) 2010 Faraday Technology Corp.
;;
;; Modeled pipeline characteristics:
;; LD -> any use: latency = 3 (2 cycle penalty).
;; ALU -> any use: latency = 2 (1 cycle penalty).

;; This automaton provides a pipeline description for the Faraday
;; FA526 core.
;;
;; The model given here assumes that the condition for all conditional
;; instructions is "true", i.e., that all of the instructions are
;; actually executed.

(define_automaton "fa526")

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Pipelines
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;; There is a single pipeline
;;
;;   The ALU pipeline has fetch, decode, execute, memory, and
;;   write stages.  We only need to model the execute, memory and write
;;   stages.

;;      S      E      M      W

(define_cpu_unit "fa526_core" "fa526")

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; ALU Instructions
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;; ALU instructions require two cycles to execute, and use the ALU
;; pipeline in each of the three stages.  The results are available
;; after the execute stage stage has finished.
;;
;; If the destination register is the PC, the pipelines are stalled
;; for several cycles.  That case is not modeled here.

;; ALU operations
(define_insn_reservation "526_alu_op" 1
 (and (eq_attr "tune" "fa526")
      (eq_attr "type" "arlo_imm,arlo_reg,shift,shift_reg,\
                       mov_imm,mov_reg,mvn_imm,mvn_reg"))
 "fa526_core")

(define_insn_reservation "526_alu_shift_op" 2
 (and (eq_attr "tune" "fa526")
      (eq_attr "type" "extend,arlo_shift,arlo_shift_reg,\
                       mov_shift,mov_shift_reg,\
                       mvn_shift,mvn_shift_reg"))
 "fa526_core")

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Multiplication Instructions
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(define_insn_reservation "526_mult1" 2
 (and (eq_attr "tune" "fa526")
      (eq_attr "type" "smlalxy,smulxy,smlaxy,smlalxy"))
 "fa526_core")

(define_insn_reservation "526_mult2" 5
 (and (eq_attr "tune" "fa526")
      (eq_attr "type" "mul,mla,muls,mlas,umull,umlal,smull,smlal,umulls,\
                       umlals,smulls,smlals,smlawx"))
 "fa526_core*4")

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Load/Store Instructions
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;; The models for load/store instructions do not accurately describe
;; the difference between operations with a base register writeback
;; (such as "ldm!").  These models assume that all memory references
;; hit in dcache.

(define_insn_reservation "526_load1_op" 3
 (and (eq_attr "tune" "fa526")
      (eq_attr "type" "load1,load_byte"))
 "fa526_core")

(define_insn_reservation "526_load2_op" 4
 (and (eq_attr "tune" "fa526")
      (eq_attr "type" "load2"))
 "fa526_core*2")

(define_insn_reservation "526_load3_op" 5
 (and (eq_attr "tune" "fa526")
      (eq_attr "type" "load3"))
 "fa526_core*3")

(define_insn_reservation "526_load4_op" 6
 (and (eq_attr "tune" "fa526")
      (eq_attr "type" "load4"))
 "fa526_core*4")

(define_insn_reservation "526_store1_op" 0
 (and (eq_attr "tune" "fa526")
      (eq_attr "type" "store1"))
 "fa526_core")

(define_insn_reservation "526_store2_op" 1
 (and (eq_attr "tune" "fa526")
      (eq_attr "type" "store2"))
 "fa526_core*2")

(define_insn_reservation "526_store3_op" 2
 (and (eq_attr "tune" "fa526")
      (eq_attr "type" "store3"))
 "fa526_core*3")

(define_insn_reservation "526_store4_op" 3
 (and (eq_attr "tune" "fa526")
      (eq_attr "type" "store4"))
 "fa526_core*4")

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Branch and Call Instructions
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;; Branch instructions are difficult to model accurately.  The FA526
;; core can predict most branches.  If the branch is predicted
;; correctly, and predicted early enough, the branch can be completely
;; eliminated from the instruction stream.  Some branches can
;; therefore appear to require zero cycle to execute.  We assume that
;; all branches are predicted correctly, and that the latency is
;; therefore the minimum value.

(define_insn_reservation "526_branch_op" 0
 (and (eq_attr "tune" "fa526")
      (eq_attr "type" "branch"))
 "fa526_core")

;; The latency for a call is actually the latency when the result is available.
;; i.e. R0 ready for int return value.  For most cases, the return value is set
;; by a mov instruction, which has 1 cycle latency.
(define_insn_reservation "526_call_op" 1
 (and (eq_attr "tune" "fa526")
      (eq_attr "type" "call"))
 "fa526_core")

