// Generated by running
//	maketables --tables=all --data=http://www.unicode.org/Public/6.0.0/ucd/UnicodeData.txt --casefolding=http://www.unicode.org/Public/6.0.0/ucd/CaseFolding.txt
// DO NOT EDIT

package unicode

// Version is the Unicode edition from which the tables are derived.
const Version = "6.0.0"

// Categories is the set of Unicode data tables.
var Categories = map[string]*RangeTable{
	"Lm": Lm,
	"Ll": Ll,
	"C":  C,
	"M":  M,
	"L":  L,
	"N":  N,
	"P":  P,
	"S":  S,
	"Z":  Z,
	"Me": Me,
	"Mc": Mc,
	"Mn": Mn,
	"Zl": Zl,
	"Zp": Zp,
	"Zs": Zs,
	"Cs": Cs,
	"Co": Co,
	"Cf": Cf,
	"Cc": Cc,
	"Po": Po,
	"Pi": Pi,
	"Pf": Pf,
	"Pe": Pe,
	"Pd": Pd,
	"Pc": Pc,
	"Ps": Ps,
	"Nd": Nd,
	"Nl": Nl,
	"No": No,
	"So": So,
	"Sm": Sm,
	"Sk": Sk,
	"Sc": Sc,
	"Lu": Lu,
	"Lt": Lt,
	"Lo": Lo,
}

var _Lm = &RangeTable{
	R16: []Range16{
		{0x02b0, 0x02c1, 1},
		{0x02c6, 0x02d1, 1},
		{0x02e0, 0x02e4, 1},
		{0x02ec, 0x02ee, 2},
		{0x0374, 0x037a, 6},
		{0x0559, 0x0640, 231},
		{0x06e5, 0x06e6, 1},
		{0x07f4, 0x07f5, 1},
		{0x07fa, 0x081a, 32},
		{0x0824, 0x0828, 4},
		{0x0971, 0x0e46, 1237},
		{0x0ec6, 0x10fc, 566},
		{0x17d7, 0x1843, 108},
		{0x1aa7, 0x1c78, 465},
		{0x1c79, 0x1c7d, 1},
		{0x1d2c, 0x1d61, 1},
		{0x1d78, 0x1d9b, 35},
		{0x1d9c, 0x1dbf, 1},
		{0x2071, 0x207f, 14},
		{0x2090, 0x209c, 1},
		{0x2c7d, 0x2d6f, 242},
		{0x2e2f, 0x3005, 470},
		{0x3031, 0x3035, 1},
		{0x303b, 0x309d, 98},
		{0x309e, 0x30fc, 94},
		{0x30fd, 0x30fe, 1},
		{0xa015, 0xa4f8, 1251},
		{0xa4f9, 0xa4fd, 1},
		{0xa60c, 0xa67f, 115},
		{0xa717, 0xa71f, 1},
		{0xa770, 0xa788, 24},
		{0xa9cf, 0xaa70, 161},
		{0xaadd, 0xff70, 21651},
		{0xff9e, 0xff9f, 1},
	},
}

var _Ll = &RangeTable{
	R16: []Range16{
		{0x0061, 0x007a, 1},
		{0x00aa, 0x00b5, 11},
		{0x00ba, 0x00df, 37},
		{0x00e0, 0x00f6, 1},
		{0x00f8, 0x00ff, 1},
		{0x0101, 0x0137, 2},
		{0x0138, 0x0148, 2},
		{0x0149, 0x0177, 2},
		{0x017a, 0x017e, 2},
		{0x017f, 0x0180, 1},
		{0x0183, 0x0185, 2},
		{0x0188, 0x018c, 4},
		{0x018d, 0x0192, 5},
		{0x0195, 0x0199, 4},
		{0x019a, 0x019b, 1},
		{0x019e, 0x01a1, 3},
		{0x01a3, 0x01a5, 2},
		{0x01a8, 0x01aa, 2},
		{0x01ab, 0x01ad, 2},
		{0x01b0, 0x01b4, 4},
		{0x01b6, 0x01b9, 3},
		{0x01ba, 0x01bd, 3},
		{0x01be, 0x01bf, 1},
		{0x01c6, 0x01cc, 3},
		{0x01ce, 0x01dc, 2},
		{0x01dd, 0x01ef, 2},
		{0x01f0, 0x01f3, 3},
		{0x01f5, 0x01f9, 4},
		{0x01fb, 0x0233, 2},
		{0x0234, 0x0239, 1},
		{0x023c, 0x023f, 3},
		{0x0240, 0x0242, 2},
		{0x0247, 0x024f, 2},
		{0x0250, 0x0293, 1},
		{0x0295, 0x02af, 1},
		{0x0371, 0x0373, 2},
		{0x0377, 0x037b, 4},
		{0x037c, 0x037d, 1},
		{0x0390, 0x03ac, 28},
		{0x03ad, 0x03ce, 1},
		{0x03d0, 0x03d1, 1},
		{0x03d5, 0x03d7, 1},
		{0x03d9, 0x03ef, 2},
		{0x03f0, 0x03f3, 1},
		{0x03f5, 0x03fb, 3},
		{0x03fc, 0x0430, 52},
		{0x0431, 0x045f, 1},
		{0x0461, 0x0481, 2},
		{0x048b, 0x04bf, 2},
		{0x04c2, 0x04ce, 2},
		{0x04cf, 0x0527, 2},
		{0x0561, 0x0587, 1},
		{0x1d00, 0x1d2b, 1},
		{0x1d62, 0x1d77, 1},
		{0x1d79, 0x1d9a, 1},
		{0x1e01, 0x1e95, 2},
		{0x1e96, 0x1e9d, 1},
		{0x1e9f, 0x1eff, 2},
		{0x1f00, 0x1f07, 1},
		{0x1f10, 0x1f15, 1},
		{0x1f20, 0x1f27, 1},
		{0x1f30, 0x1f37, 1},
		{0x1f40, 0x1f45, 1},
		{0x1f50, 0x1f57, 1},
		{0x1f60, 0x1f67, 1},
		{0x1f70, 0x1f7d, 1},
		{0x1f80, 0x1f87, 1},
		{0x1f90, 0x1f97, 1},
		{0x1fa0, 0x1fa7, 1},
		{0x1fb0, 0x1fb4, 1},
		{0x1fb6, 0x1fb7, 1},
		{0x1fbe, 0x1fc2, 4},
		{0x1fc3, 0x1fc4, 1},
		{0x1fc6, 0x1fc7, 1},
		{0x1fd0, 0x1fd3, 1},
		{0x1fd6, 0x1fd7, 1},
		{0x1fe0, 0x1fe7, 1},
		{0x1ff2, 0x1ff4, 1},
		{0x1ff6, 0x1ff7, 1},
		{0x210a, 0x210e, 4},
		{0x210f, 0x2113, 4},
		{0x212f, 0x2139, 5},
		{0x213c, 0x213d, 1},
		{0x2146, 0x2149, 1},
		{0x214e, 0x2184, 54},
		{0x2c30, 0x2c5e, 1},
		{0x2c61, 0x2c65, 4},
		{0x2c66, 0x2c6c, 2},
		{0x2c71, 0x2c73, 2},
		{0x2c74, 0x2c76, 2},
		{0x2c77, 0x2c7c, 1},
		{0x2c81, 0x2ce3, 2},
		{0x2ce4, 0x2cec, 8},
		{0x2cee, 0x2d00, 18},
		{0x2d01, 0x2d25, 1},
		{0xa641, 0xa66d, 2},
		{0xa681, 0xa697, 2},
		{0xa723, 0xa72f, 2},
		{0xa730, 0xa731, 1},
		{0xa733, 0xa771, 2},
		{0xa772, 0xa778, 1},
		{0xa77a, 0xa77c, 2},
		{0xa77f, 0xa787, 2},
		{0xa78c, 0xa78e, 2},
		{0xa791, 0xa7a1, 16},
		{0xa7a3, 0xa7a9, 2},
		{0xa7fa, 0xfb00, 21254},
		{0xfb01, 0xfb06, 1},
		{0xfb13, 0xfb17, 1},
		{0xff41, 0xff5a, 1},
	},
	R32: []Range32{
		{0x10428, 0x1044f, 1},
		{0x1d41a, 0x1d433, 1},
		{0x1d44e, 0x1d454, 1},
		{0x1d456, 0x1d467, 1},
		{0x1d482, 0x1d49b, 1},
		{0x1d4b6, 0x1d4b9, 1},
		{0x1d4bb, 0x1d4bd, 2},
		{0x1d4be, 0x1d4c3, 1},
		{0x1d4c5, 0x1d4cf, 1},
		{0x1d4ea, 0x1d503, 1},
		{0x1d51e, 0x1d537, 1},
		{0x1d552, 0x1d56b, 1},
		{0x1d586, 0x1d59f, 1},
		{0x1d5ba, 0x1d5d3, 1},
		{0x1d5ee, 0x1d607, 1},
		{0x1d622, 0x1d63b, 1},
		{0x1d656, 0x1d66f, 1},
		{0x1d68a, 0x1d6a5, 1},
		{0x1d6c2, 0x1d6da, 1},
		{0x1d6dc, 0x1d6e1, 1},
		{0x1d6fc, 0x1d714, 1},
		{0x1d716, 0x1d71b, 1},
		{0x1d736, 0x1d74e, 1},
		{0x1d750, 0x1d755, 1},
		{0x1d770, 0x1d788, 1},
		{0x1d78a, 0x1d78f, 1},
		{0x1d7aa, 0x1d7c2, 1},
		{0x1d7c4, 0x1d7c9, 1},
		{0x1d7cb, 0x1d7cb, 1},
	},
}

var _C = &RangeTable{
	R16: []Range16{
		{0x0001, 0x001f, 1},
		{0x007f, 0x009f, 1},
		{0x00ad, 0x0600, 1363},
		{0x0601, 0x0603, 1},
		{0x06dd, 0x070f, 50},
		{0x17b4, 0x17b5, 1},
		{0x200b, 0x200f, 1},
		{0x202a, 0x202e, 1},
		{0x2060, 0x2064, 1},
		{0x206a, 0x206f, 1},
		{0xd800, 0xf8ff, 1},
		{0xfeff, 0xfff9, 250},
		{0xfffa, 0xfffb, 1},
	},
	R32: []Range32{
		{0x110bd, 0x1d173, 49334},
		{0x1d174, 0x1d17a, 1},
		{0xe0001, 0xe0020, 31},
		{0xe0021, 0xe007f, 1},
		{0xf0000, 0xffffd, 1},
		{0x100000, 0x10fffd, 1},
	},
}

var _M = &RangeTable{
	R16: []Range16{
		{0x0300, 0x036f, 1},
		{0x0483, 0x0489, 1},
		{0x0591, 0x05bd, 1},
		{0x05bf, 0x05c1, 2},
		{0x05c2, 0x05c4, 2},
		{0x05c5, 0x05c7, 2},
		{0x0610, 0x061a, 1},
		{0x064b, 0x065f, 1},
		{0x0670, 0x06d6, 102},
		{0x06d7, 0x06dc, 1},
		{0x06df, 0x06e4, 1},
		{0x06e7, 0x06e8, 1},
		{0x06ea, 0x06ed, 1},
		{0x0711, 0x0730, 31},
		{0x0731, 0x074a, 1},
		{0x07a6, 0x07b0, 1},
		{0x07eb, 0x07f3, 1},
		{0x0816, 0x0819, 1},
		{0x081b, 0x0823, 1},
		{0x0825, 0x0827, 1},
		{0x0829, 0x082d, 1},
		{0x0859, 0x085b, 1},
		{0x0900, 0x0903, 1},
		{0x093a, 0x093c, 1},
		{0x093e, 0x094f, 1},
		{0x0951, 0x0957, 1},
		{0x0962, 0x0963, 1},
		{0x0981, 0x0983, 1},
		{0x09bc, 0x09be, 2},
		{0x09bf, 0x09c4, 1},
		{0x09c7, 0x09c8, 1},
		{0x09cb, 0x09cd, 1},
		{0x09d7, 0x09e2, 11},
		{0x09e3, 0x0a01, 30},
		{0x0a02, 0x0a03, 1},
		{0x0a3c, 0x0a3e, 2},
		{0x0a3f, 0x0a42, 1},
		{0x0a47, 0x0a48, 1},
		{0x0a4b, 0x0a4d, 1},
		{0x0a51, 0x0a70, 31},
		{0x0a71, 0x0a75, 4},
		{0x0a81, 0x0a83, 1},
		{0x0abc, 0x0abe, 2},
		{0x0abf, 0x0ac5, 1},
		{0x0ac7, 0x0ac9, 1},
		{0x0acb, 0x0acd, 1},
		{0x0ae2, 0x0ae3, 1},
		{0x0b01, 0x0b03, 1},
		{0x0b3c, 0x0b3e, 2},
		{0x0b3f, 0x0b44, 1},
		{0x0b47, 0x0b48, 1},
		{0x0b4b, 0x0b4d, 1},
		{0x0b56, 0x0b57, 1},
		{0x0b62, 0x0b63, 1},
		{0x0b82, 0x0bbe, 60},
		{0x0bbf, 0x0bc2, 1},
		{0x0bc6, 0x0bc8, 1},
		{0x0bca, 0x0bcd, 1},
		{0x0bd7, 0x0c01, 42},
		{0x0c02, 0x0c03, 1},
		{0x0c3e, 0x0c44, 1},
		{0x0c46, 0x0c48, 1},
		{0x0c4a, 0x0c4d, 1},
		{0x0c55, 0x0c56, 1},
		{0x0c62, 0x0c63, 1},
		{0x0c82, 0x0c83, 1},
		{0x0cbc, 0x0cbe, 2},
		{0x0cbf, 0x0cc4, 1},
		{0x0cc6, 0x0cc8, 1},
		{0x0cca, 0x0ccd, 1},
		{0x0cd5, 0x0cd6, 1},
		{0x0ce2, 0x0ce3, 1},
		{0x0d02, 0x0d03, 1},
		{0x0d3e, 0x0d44, 1},
		{0x0d46, 0x0d48, 1},
		{0x0d4a, 0x0d4d, 1},
		{0x0d57, 0x0d62, 11},
		{0x0d63, 0x0d82, 31},
		{0x0d83, 0x0dca, 71},
		{0x0dcf, 0x0dd4, 1},
		{0x0dd6, 0x0dd8, 2},
		{0x0dd9, 0x0ddf, 1},
		{0x0df2, 0x0df3, 1},
		{0x0e31, 0x0e34, 3},
		{0x0e35, 0x0e3a, 1},
		{0x0e47, 0x0e4e, 1},
		{0x0eb1, 0x0eb4, 3},
		{0x0eb5, 0x0eb9, 1},
		{0x0ebb, 0x0ebc, 1},
		{0x0ec8, 0x0ecd, 1},
		{0x0f18, 0x0f19, 1},
		{0x0f35, 0x0f39, 2},
		{0x0f3e, 0x0f3f, 1},
		{0x0f71, 0x0f84, 1},
		{0x0f86, 0x0f87, 1},
		{0x0f8d, 0x0f97, 1},
		{0x0f99, 0x0fbc, 1},
		{0x0fc6, 0x102b, 101},
		{0x102c, 0x103e, 1},
		{0x1056, 0x1059, 1},
		{0x105e, 0x1060, 1},
		{0x1062, 0x1064, 1},
		{0x1067, 0x106d, 1},
		{0x1071, 0x1074, 1},
		{0x1082, 0x108d, 1},
		{0x108f, 0x109a, 11},
		{0x109b, 0x109d, 1},
		{0x135d, 0x135f, 1},
		{0x1712, 0x1714, 1},
		{0x1732, 0x1734, 1},
		{0x1752, 0x1753, 1},
		{0x1772, 0x1773, 1},
		{0x17b6, 0x17d3, 1},
		{0x17dd, 0x180b, 46},
		{0x180c, 0x180d, 1},
		{0x18a9, 0x1920, 119},
		{0x1921, 0x192b, 1},
		{0x1930, 0x193b, 1},
		{0x19b0, 0x19c0, 1},
		{0x19c8, 0x19c9, 1},
		{0x1a17, 0x1a1b, 1},
		{0x1a55, 0x1a5e, 1},
		{0x1a60, 0x1a7c, 1},
		{0x1a7f, 0x1b00, 129},
		{0x1b01, 0x1b04, 1},
		{0x1b34, 0x1b44, 1},
		{0x1b6b, 0x1b73, 1},
		{0x1b80, 0x1b82, 1},
		{0x1ba1, 0x1baa, 1},
		{0x1be6, 0x1bf3, 1},
		{0x1c24, 0x1c37, 1},
		{0x1cd0, 0x1cd2, 1},
		{0x1cd4, 0x1ce8, 1},
		{0x1ced, 0x1cf2, 5},
		{0x1dc0, 0x1de6, 1},
		{0x1dfc, 0x1dff, 1},
		{0x20d0, 0x20f0, 1},
		{0x2cef, 0x2cf1, 1},
		{0x2d7f, 0x2de0, 97},
		{0x2de1, 0x2dff, 1},
		{0x302a, 0x302f, 1},
		{0x3099, 0x309a, 1},
		{0xa66f, 0xa672, 1},
		{0xa67c, 0xa67d, 1},
		{0xa6f0, 0xa6f1, 1},
		{0xa802, 0xa806, 4},
		{0xa80b, 0xa823, 24},
		{0xa824, 0xa827, 1},
		{0xa880, 0xa881, 1},
		{0xa8b4, 0xa8c4, 1},
		{0xa8e0, 0xa8f1, 1},
		{0xa926, 0xa92d, 1},
		{0xa947, 0xa953, 1},
		{0xa980, 0xa983, 1},
		{0xa9b3, 0xa9c0, 1},
		{0xaa29, 0xaa36, 1},
		{0xaa43, 0xaa4c, 9},
		{0xaa4d, 0xaa7b, 46},
		{0xaab0, 0xaab2, 2},
		{0xaab3, 0xaab4, 1},
		{0xaab7, 0xaab8, 1},
		{0xaabe, 0xaabf, 1},
		{0xaac1, 0xabe3, 290},
		{0xabe4, 0xabea, 1},
		{0xabec, 0xabed, 1},
		{0xfb1e, 0xfe00, 738},
		{0xfe01, 0xfe0f, 1},
		{0xfe20, 0xfe26, 1},
	},
	R32: []Range32{
		{0x101fd, 0x10a01, 2052},
		{0x10a02, 0x10a03, 1},
		{0x10a05, 0x10a06, 1},
		{0x10a0c, 0x10a0f, 1},
		{0x10a38, 0x10a3a, 1},
		{0x10a3f, 0x11000, 1473},
		{0x11001, 0x11002, 1},
		{0x11038, 0x11046, 1},
		{0x11080, 0x11082, 1},
		{0x110b0, 0x110ba, 1},
		{0x1d165, 0x1d169, 1},
		{0x1d16d, 0x1d172, 1},
		{0x1d17b, 0x1d182, 1},
		{0x1d185, 0x1d18b, 1},
		{0x1d1aa, 0x1d1ad, 1},
		{0x1d242, 0x1d244, 1},
		{0xe0100, 0xe01ef, 1},
	},
}

var _L = &RangeTable{
	R16: []Range16{
		{0x0041, 0x005a, 1},
		{0x0061, 0x007a, 1},
		{0x00aa, 0x00b5, 11},
		{0x00ba, 0x00c0, 6},
		{0x00c1, 0x00d6, 1},
		{0x00d8, 0x00f6, 1},
		{0x00f8, 0x02c1, 1},
		{0x02c6, 0x02d1, 1},
		{0x02e0, 0x02e4, 1},
		{0x02ec, 0x02ee, 2},
		{0x0370, 0x0374, 1},
		{0x0376, 0x0377, 1},
		{0x037a, 0x037d, 1},
		{0x0386, 0x0388, 2},
		{0x0389, 0x038a, 1},
		{0x038c, 0x038e, 2},
		{0x038f, 0x03a1, 1},
		{0x03a3, 0x03f5, 1},
		{0x03f7, 0x0481, 1},
		{0x048a, 0x0527, 1},
		{0x0531, 0x0556, 1},
		{0x0559, 0x0561, 8},
		{0x0562, 0x0587, 1},
		{0x05d0, 0x05ea, 1},
		{0x05f0, 0x05f2, 1},
		{0x0620, 0x064a, 1},
		{0x066e, 0x066f, 1},
		{0x0671, 0x06d3, 1},
		{0x06d5, 0x06e5, 16},
		{0x06e6, 0x06ee, 8},
		{0x06ef, 0x06fa, 11},
		{0x06fb, 0x06fc, 1},
		{0x06ff, 0x0710, 17},
		{0x0712, 0x072f, 1},
		{0x074d, 0x07a5, 1},
		{0x07b1, 0x07ca, 25},
		{0x07cb, 0x07ea, 1},
		{0x07f4, 0x07f5, 1},
		{0x07fa, 0x0800, 6},
		{0x0801, 0x0815, 1},
		{0x081a, 0x0824, 10},
		{0x0828, 0x0840, 24},
		{0x0841, 0x0858, 1},
		{0x0904, 0x0939, 1},
		{0x093d, 0x0950, 19},
		{0x0958, 0x0961, 1},
		{0x0971, 0x0977, 1},
		{0x0979, 0x097f, 1},
		{0x0985, 0x098c, 1},
		{0x098f, 0x0990, 1},
		{0x0993, 0x09a8, 1},
		{0x09aa, 0x09b0, 1},
		{0x09b2, 0x09b6, 4},
		{0x09b7, 0x09b9, 1},
		{0x09bd, 0x09ce, 17},
		{0x09dc, 0x09dd, 1},
		{0x09df, 0x09e1, 1},
		{0x09f0, 0x09f1, 1},
		{0x0a05, 0x0a0a, 1},
		{0x0a0f, 0x0a10, 1},
		{0x0a13, 0x0a28, 1},
		{0x0a2a, 0x0a30, 1},
		{0x0a32, 0x0a33, 1},
		{0x0a35, 0x0a36, 1},
		{0x0a38, 0x0a39, 1},
		{0x0a59, 0x0a5c, 1},
		{0x0a5e, 0x0a72, 20},
		{0x0a73, 0x0a74, 1},
		{0x0a85, 0x0a8d, 1},
		{0x0a8f, 0x0a91, 1},
		{0x0a93, 0x0aa8, 1},
		{0x0aaa, 0x0ab0, 1},
		{0x0ab2, 0x0ab3, 1},
		{0x0ab5, 0x0ab9, 1},
		{0x0abd, 0x0ad0, 19},
		{0x0ae0, 0x0ae1, 1},
		{0x0b05, 0x0b0c, 1},
		{0x0b0f, 0x0b10, 1},
		{0x0b13, 0x0b28, 1},
		{0x0b2a, 0x0b30, 1},
		{0x0b32, 0x0b33, 1},
		{0x0b35, 0x0b39, 1},
		{0x0b3d, 0x0b5c, 31},
		{0x0b5d, 0x0b5f, 2},
		{0x0b60, 0x0b61, 1},
		{0x0b71, 0x0b83, 18},
		{0x0b85, 0x0b8a, 1},
		{0x0b8e, 0x0b90, 1},
		{0x0b92, 0x0b95, 1},
		{0x0b99, 0x0b9a, 1},
		{0x0b9c, 0x0b9e, 2},
		{0x0b9f, 0x0ba3, 4},
		{0x0ba4, 0x0ba8, 4},
		{0x0ba9, 0x0baa, 1},
		{0x0bae, 0x0bb9, 1},
		{0x0bd0, 0x0c05, 53},
		{0x0c06, 0x0c0c, 1},
		{0x0c0e, 0x0c10, 1},
		{0x0c12, 0x0c28, 1},
		{0x0c2a, 0x0c33, 1},
		{0x0c35, 0x0c39, 1},
		{0x0c3d, 0x0c58, 27},
		{0x0c59, 0x0c60, 7},
		{0x0c61, 0x0c85, 36},
		{0x0c86, 0x0c8c, 1},
		{0x0c8e, 0x0c90, 1},
		{0x0c92, 0x0ca8, 1},
		{0x0caa, 0x0cb3, 1},
		{0x0cb5, 0x0cb9, 1},
		{0x0cbd, 0x0cde, 33},
		{0x0ce0, 0x0ce1, 1},
		{0x0cf1, 0x0cf2, 1},
		{0x0d05, 0x0d0c, 1},
		{0x0d0e, 0x0d10, 1},
		{0x0d12, 0x0d3a, 1},
		{0x0d3d, 0x0d4e, 17},
		{0x0d60, 0x0d61, 1},
		{0x0d7a, 0x0d7f, 1},
		{0x0d85, 0x0d96, 1},
		{0x0d9a, 0x0db1, 1},
		{0x0db3, 0x0dbb, 1},
		{0x0dbd, 0x0dc0, 3},
		{0x0dc1, 0x0dc6, 1},
		{0x0e01, 0x0e30, 1},
		{0x0e32, 0x0e33, 1},
		{0x0e40, 0x0e46, 1},
		{0x0e81, 0x0e82, 1},
		{0x0e84, 0x0e87, 3},
		{0x0e88, 0x0e8a, 2},
		{0x0e8d, 0x0e94, 7},
		{0x0e95, 0x0e97, 1},
		{0x0e99, 0x0e9f, 1},
		{0x0ea1, 0x0ea3, 1},
		{0x0ea5, 0x0ea7, 2},
		{0x0eaa, 0x0eab, 1},
		{0x0ead, 0x0eb0, 1},
		{0x0eb2, 0x0eb3, 1},
		{0x0ebd, 0x0ec0, 3},
		{0x0ec1, 0x0ec4, 1},
		{0x0ec6, 0x0edc, 22},
		{0x0edd, 0x0f00, 35},
		{0x0f40, 0x0f47, 1},
		{0x0f49, 0x0f6c, 1},
		{0x0f88, 0x0f8c, 1},
		{0x1000, 0x102a, 1},
		{0x103f, 0x1050, 17},
		{0x1051, 0x1055, 1},
		{0x105a, 0x105d, 1},
		{0x1061, 0x1065, 4},
		{0x1066, 0x106e, 8},
		{0x106f, 0x1070, 1},
		{0x1075, 0x1081, 1},
		{0x108e, 0x10a0, 18},
		{0x10a1, 0x10c5, 1},
		{0x10d0, 0x10fa, 1},
		{0x10fc, 0x1100, 4},
		{0x1101, 0x1248, 1},
		{0x124a, 0x124d, 1},
		{0x1250, 0x1256, 1},
		{0x1258, 0x125a, 2},
		{0x125b, 0x125d, 1},
		{0x1260, 0x1288, 1},
		{0x128a, 0x128d, 1},
		{0x1290, 0x12b0, 1},
		{0x12b2, 0x12b5, 1},
		{0x12b8, 0x12be, 1},
		{0x12c0, 0x12c2, 2},
		{0x12c3, 0x12c5, 1},
		{0x12c8, 0x12d6, 1},
		{0x12d8, 0x1310, 1},
		{0x1312, 0x1315, 1},
		{0x1318, 0x135a, 1},
		{0x1380, 0x138f, 1},
		{0x13a0, 0x13f4, 1},
		{0x1401, 0x166c, 1},
		{0x166f, 0x167f, 1},
		{0x1681, 0x169a, 1},
		{0x16a0, 0x16ea, 1},
		{0x1700, 0x170c, 1},
		{0x170e, 0x1711, 1},
		{0x1720, 0x1731, 1},
		{0x1740, 0x1751, 1},
		{0x1760, 0x176c, 1},
		{0x176e, 0x1770, 1},
		{0x1780, 0x17b3, 1},
		{0x17d7, 0x17dc, 5},
		{0x1820, 0x1877, 1},
		{0x1880, 0x18a8, 1},
		{0x18aa, 0x18b0, 6},
		{0x18b1, 0x18f5, 1},
		{0x1900, 0x191c, 1},
		{0x1950, 0x196d, 1},
		{0x1970, 0x1974, 1},
		{0x1980, 0x19ab, 1},
		{0x19c1, 0x19c7, 1},
		{0x1a00, 0x1a16, 1},
		{0x1a20, 0x1a54, 1},
		{0x1aa7, 0x1b05, 94},
		{0x1b06, 0x1b33, 1},
		{0x1b45, 0x1b4b, 1},
		{0x1b83, 0x1ba0, 1},
		{0x1bae, 0x1baf, 1},
		{0x1bc0, 0x1be5, 1},
		{0x1c00, 0x1c23, 1},
		{0x1c4d, 0x1c4f, 1},
		{0x1c5a, 0x1c7d, 1},
		{0x1ce9, 0x1cec, 1},
		{0x1cee, 0x1cf1, 1},
		{0x1d00, 0x1dbf, 1},
		{0x1e00, 0x1f15, 1},
		{0x1f18, 0x1f1d, 1},
		{0x1f20, 0x1f45, 1},
		{0x1f48, 0x1f4d, 1},
		{0x1f50, 0x1f57, 1},
		{0x1f59, 0x1f5f, 2},
		{0x1f60, 0x1f7d, 1},
		{0x1f80, 0x1fb4, 1},
		{0x1fb6, 0x1fbc, 1},
		{0x1fbe, 0x1fc2, 4},
		{0x1fc3, 0x1fc4, 1},
		{0x1fc6, 0x1fcc, 1},
		{0x1fd0, 0x1fd3, 1},
		{0x1fd6, 0x1fdb, 1},
		{0x1fe0, 0x1fec, 1},
		{0x1ff2, 0x1ff4, 1},
		{0x1ff6, 0x1ffc, 1},
		{0x2071, 0x207f, 14},
		{0x2090, 0x209c, 1},
		{0x2102, 0x2107, 5},
		{0x210a, 0x2113, 1},
		{0x2115, 0x2119, 4},
		{0x211a, 0x211d, 1},
		{0x2124, 0x212a, 2},
		{0x212b, 0x212d, 1},
		{0x212f, 0x2139, 1},
		{0x213c, 0x213f, 1},
		{0x2145, 0x2149, 1},
		{0x214e, 0x2183, 53},
		{0x2184, 0x2c00, 2684},
		{0x2c01, 0x2c2e, 1},
		{0x2c30, 0x2c5e, 1},
		{0x2c60, 0x2ce4, 1},
		{0x2ceb, 0x2cee, 1},
		{0x2d00, 0x2d25, 1},
		{0x2d30, 0x2d65, 1},
		{0x2d6f, 0x2d80, 17},
		{0x2d81, 0x2d96, 1},
		{0x2da0, 0x2da6, 1},
		{0x2da8, 0x2dae, 1},
		{0x2db0, 0x2db6, 1},
		{0x2db8, 0x2dbe, 1},
		{0x2dc0, 0x2dc6, 1},
		{0x2dc8, 0x2dce, 1},
		{0x2dd0, 0x2dd6, 1},
		{0x2dd8, 0x2dde, 1},
		{0x2e2f, 0x3005, 470},
		{0x3006, 0x3031, 43},
		{0x3032, 0x3035, 1},
		{0x303b, 0x303c, 1},
		{0x3041, 0x3096, 1},
		{0x309d, 0x309f, 1},
		{0x30a1, 0x30fa, 1},
		{0x30fc, 0x30ff, 1},
		{0x3105, 0x312d, 1},
		{0x3131, 0x318e, 1},
		{0x31a0, 0x31ba, 1},
		{0x31f0, 0x31ff, 1},
		{0x3400, 0x4db5, 1},
		{0x4e00, 0x9fcb, 1},
		{0xa000, 0xa48c, 1},
		{0xa4d0, 0xa4fd, 1},
		{0xa500, 0xa60c, 1},
		{0xa610, 0xa61f, 1},
		{0xa62a, 0xa62b, 1},
		{0xa640, 0xa66e, 1},
		{0xa67f, 0xa697, 1},
		{0xa6a0, 0xa6e5, 1},
		{0xa717, 0xa71f, 1},
		{0xa722, 0xa788, 1},
		{0xa78b, 0xa78e, 1},
		{0xa790, 0xa791, 1},
		{0xa7a0, 0xa7a9, 1},
		{0xa7fa, 0xa801, 1},
		{0xa803, 0xa805, 1},
		{0xa807, 0xa80a, 1},
		{0xa80c, 0xa822, 1},
		{0xa840, 0xa873, 1},
		{0xa882, 0xa8b3, 1},
		{0xa8f2, 0xa8f7, 1},
		{0xa8fb, 0xa90a, 15},
		{0xa90b, 0xa925, 1},
		{0xa930, 0xa946, 1},
		{0xa960, 0xa97c, 1},
		{0xa984, 0xa9b2, 1},
		{0xa9cf, 0xaa00, 49},
		{0xaa01, 0xaa28, 1},
		{0xaa40, 0xaa42, 1},
		{0xaa44, 0xaa4b, 1},
		{0xaa60, 0xaa76, 1},
		{0xaa7a, 0xaa80, 6},
		{0xaa81, 0xaaaf, 1},
		{0xaab1, 0xaab5, 4},
		{0xaab6, 0xaab9, 3},
		{0xaaba, 0xaabd, 1},
		{0xaac0, 0xaac2, 2},
		{0xaadb, 0xaadd, 1},
		{0xab01, 0xab06, 1},
		{0xab09, 0xab0e, 1},
		{0xab11, 0xab16, 1},
		{0xab20, 0xab26, 1},
		{0xab28, 0xab2e, 1},
		{0xabc0, 0xabe2, 1},
		{0xac00, 0xd7a3, 1},
		{0xd7b0, 0xd7c6, 1},
		{0xd7cb, 0xd7fb, 1},
		{0xf900, 0xfa2d, 1},
		{0xfa30, 0xfa6d, 1},
		{0xfa70, 0xfad9, 1},
		{0xfb00, 0xfb06, 1},
		{0xfb13, 0xfb17, 1},
		{0xfb1d, 0xfb1f, 2},
		{0xfb20, 0xfb28, 1},
		{0xfb2a, 0xfb36, 1},
		{0xfb38, 0xfb3c, 1},
		{0xfb3e, 0xfb40, 2},
		{0xfb41, 0xfb43, 2},
		{0xfb44, 0xfb46, 2},
		{0xfb47, 0xfbb1, 1},
		{0xfbd3, 0xfd3d, 1},
		{0xfd50, 0xfd8f, 1},
		{0xfd92, 0xfdc7, 1},
		{0xfdf0, 0xfdfb, 1},
		{0xfe70, 0xfe74, 1},
		{0xfe76, 0xfefc, 1},
		{0xff21, 0xff3a, 1},
		{0xff41, 0xff5a, 1},
		{0xff66, 0xffbe, 1},
		{0xffc2, 0xffc7, 1},
		{0xffca, 0xffcf, 1},
		{0xffd2, 0xffd7, 1},
		{0xffda, 0xffdc, 1},
	},
	R32: []Range32{
		{0x10000, 0x1000b, 1},
		{0x1000d, 0x10026, 1},
		{0x10028, 0x1003a, 1},
		{0x1003c, 0x1003d, 1},
		{0x1003f, 0x1004d, 1},
		{0x10050, 0x1005d, 1},
		{0x10080, 0x100fa, 1},
		{0x10280, 0x1029c, 1},
		{0x102a0, 0x102d0, 1},
		{0x10300, 0x1031e, 1},
		{0x10330, 0x10340, 1},
		{0x10342, 0x10349, 1},
		{0x10380, 0x1039d, 1},
		{0x103a0, 0x103c3, 1},
		{0x103c8, 0x103cf, 1},
		{0x10400, 0x1049d, 1},
		{0x10800, 0x10805, 1},
		{0x10808, 0x1080a, 2},
		{0x1080b, 0x10835, 1},
		{0x10837, 0x10838, 1},
		{0x1083c, 0x1083f, 3},
		{0x10840, 0x10855, 1},
		{0x10900, 0x10915, 1},
		{0x10920, 0x10939, 1},
		{0x10a00, 0x10a10, 16},
		{0x10a11, 0x10a13, 1},
		{0x10a15, 0x10a17, 1},
		{0x10a19, 0x10a33, 1},
		{0x10a60, 0x10a7c, 1},
		{0x10b00, 0x10b35, 1},
		{0x10b40, 0x10b55, 1},
		{0x10b60, 0x10b72, 1},
		{0x10c00, 0x10c48, 1},
		{0x11003, 0x11037, 1},
		{0x11083, 0x110af, 1},
		{0x12000, 0x1236e, 1},
		{0x13000, 0x1342e, 1},
		{0x16800, 0x16a38, 1},
		{0x1b000, 0x1b001, 1},
		{0x1d400, 0x1d454, 1},
		{0x1d456, 0x1d49c, 1},
		{0x1d49e, 0x1d49f, 1},
		{0x1d4a2, 0x1d4a5, 3},
		{0x1d4a6, 0x1d4a9, 3},
		{0x1d4aa, 0x1d4ac, 1},
		{0x1d4ae, 0x1d4b9, 1},
		{0x1d4bb, 0x1d4bd, 2},
		{0x1d4be, 0x1d4c3, 1},
		{0x1d4c5, 0x1d505, 1},
		{0x1d507, 0x1d50a, 1},
		{0x1d50d, 0x1d514, 1},
		{0x1d516, 0x1d51c, 1},
		{0x1d51e, 0x1d539, 1},
		{0x1d53b, 0x1d53e, 1},
		{0x1d540, 0x1d544, 1},
		{0x1d546, 0x1d54a, 4},
		{0x1d54b, 0x1d550, 1},
		{0x1d552, 0x1d6a5, 1},
		{0x1d6a8, 0x1d6c0, 1},
		{0x1d6c2, 0x1d6da, 1},
		{0x1d6dc, 0x1d6fa, 1},
		{0x1d6fc, 0x1d714, 1},
		{0x1d716, 0x1d734, 1},
		{0x1d736, 0x1d74e, 1},
		{0x1d750, 0x1d76e, 1},
		{0x1d770, 0x1d788, 1},
		{0x1d78a, 0x1d7a8, 1},
		{0x1d7aa, 0x1d7c2, 1},
		{0x1d7c4, 0x1d7cb, 1},
		{0x20000, 0x2a6d6, 1},
		{0x2a700, 0x2b734, 1},
		{0x2b740, 0x2b81d, 1},
		{0x2f800, 0x2fa1d, 1},
	},
}

var _N = &RangeTable{
	R16: []Range16{
		{0x0030, 0x0039, 1},
		{0x00b2, 0x00b3, 1},
		{0x00b9, 0x00bc, 3},
		{0x00bd, 0x00be, 1},
		{0x0660, 0x0669, 1},
		{0x06f0, 0x06f9, 1},
		{0x07c0, 0x07c9, 1},
		{0x0966, 0x096f, 1},
		{0x09e6, 0x09ef, 1},
		{0x09f4, 0x09f9, 1},
		{0x0a66, 0x0a6f, 1},
		{0x0ae6, 0x0aef, 1},
		{0x0b66, 0x0b6f, 1},
		{0x0b72, 0x0b77, 1},
		{0x0be6, 0x0bf2, 1},
		{0x0c66, 0x0c6f, 1},
		{0x0c78, 0x0c7e, 1},
		{0x0ce6, 0x0cef, 1},
		{0x0d66, 0x0d75, 1},
		{0x0e50, 0x0e59, 1},
		{0x0ed0, 0x0ed9, 1},
		{0x0f20, 0x0f33, 1},
		{0x1040, 0x1049, 1},
		{0x1090, 0x1099, 1},
		{0x1369, 0x137c, 1},
		{0x16ee, 0x16f0, 1},
		{0x17e0, 0x17e9, 1},
		{0x17f0, 0x17f9, 1},
		{0x1810, 0x1819, 1},
		{0x1946, 0x194f, 1},
		{0x19d0, 0x19da, 1},
		{0x1a80, 0x1a89, 1},
		{0x1a90, 0x1a99, 1},
		{0x1b50, 0x1b59, 1},
		{0x1bb0, 0x1bb9, 1},
		{0x1c40, 0x1c49, 1},
		{0x1c50, 0x1c59, 1},
		{0x2070, 0x2074, 4},
		{0x2075, 0x2079, 1},
		{0x2080, 0x2089, 1},
		{0x2150, 0x2182, 1},
		{0x2185, 0x2189, 1},
		{0x2460, 0x249b, 1},
		{0x24ea, 0x24ff, 1},
		{0x2776, 0x2793, 1},
		{0x2cfd, 0x3007, 778},
		{0x3021, 0x3029, 1},
		{0x3038, 0x303a, 1},
		{0x3192, 0x3195, 1},
		{0x3220, 0x3229, 1},
		{0x3251, 0x325f, 1},
		{0x3280, 0x3289, 1},
		{0x32b1, 0x32bf, 1},
		{0xa620, 0xa629, 1},
		{0xa6e6, 0xa6ef, 1},
		{0xa830, 0xa835, 1},
		{0xa8d0, 0xa8d9, 1},
		{0xa900, 0xa909, 1},
		{0xa9d0, 0xa9d9, 1},
		{0xaa50, 0xaa59, 1},
		{0xabf0, 0xabf9, 1},
		{0xff10, 0xff19, 1},
	},
	R32: []Range32{
		{0x10107, 0x10133, 1},
		{0x10140, 0x10178, 1},
		{0x1018a, 0x10320, 406},
		{0x10321, 0x10323, 1},
		{0x10341, 0x1034a, 9},
		{0x103d1, 0x103d5, 1},
		{0x104a0, 0x104a9, 1},
		{0x10858, 0x1085f, 1},
		{0x10916, 0x1091b, 1},
		{0x10a40, 0x10a47, 1},
		{0x10a7d, 0x10a7e, 1},
		{0x10b58, 0x10b5f, 1},
		{0x10b78, 0x10b7f, 1},
		{0x10e60, 0x10e7e, 1},
		{0x11052, 0x1106f, 1},
		{0x12400, 0x12462, 1},
		{0x1d360, 0x1d371, 1},
		{0x1d7ce, 0x1d7ff, 1},
		{0x1f100, 0x1f10a, 1},
	},
}

var _P = &RangeTable{
	R16: []Range16{
		{0x0021, 0x0023, 1},
		{0x0025, 0x002a, 1},
		{0x002c, 0x002f, 1},
		{0x003a, 0x003b, 1},
		{0x003f, 0x0040, 1},
		{0x005b, 0x005d, 1},
		{0x005f, 0x007b, 28},
		{0x007d, 0x00a1, 36},
		{0x00ab, 0x00b7, 12},
		{0x00bb, 0x00bf, 4},
		{0x037e, 0x0387, 9},
		{0x055a, 0x055f, 1},
		{0x0589, 0x058a, 1},
		{0x05be, 0x05c0, 2},
		{0x05c3, 0x05c6, 3},
		{0x05f3, 0x05f4, 1},
		{0x0609, 0x060a, 1},
		{0x060c, 0x060d, 1},
		{0x061b, 0x061e, 3},
		{0x061f, 0x066a, 75},
		{0x066b, 0x066d, 1},
		{0x06d4, 0x0700, 44},
		{0x0701, 0x070d, 1},
		{0x07f7, 0x07f9, 1},
		{0x0830, 0x083e, 1},
		{0x085e, 0x0964, 262},
		{0x0965, 0x0970, 11},
		{0x0df4, 0x0e4f, 91},
		{0x0e5a, 0x0e5b, 1},
		{0x0f04, 0x0f12, 1},
		{0x0f3a, 0x0f3d, 1},
		{0x0f85, 0x0fd0, 75},
		{0x0fd1, 0x0fd4, 1},
		{0x0fd9, 0x0fda, 1},
		{0x104a, 0x104f, 1},
		{0x10fb, 0x1361, 614},
		{0x1362, 0x1368, 1},
		{0x1400, 0x166d, 621},
		{0x166e, 0x169b, 45},
		{0x169c, 0x16eb, 79},
		{0x16ec, 0x16ed, 1},
		{0x1735, 0x1736, 1},
		{0x17d4, 0x17d6, 1},
		{0x17d8, 0x17da, 1},
		{0x1800, 0x180a, 1},
		{0x1944, 0x1945, 1},
		{0x1a1e, 0x1a1f, 1},
		{0x1aa0, 0x1aa6, 1},
		{0x1aa8, 0x1aad, 1},
		{0x1b5a, 0x1b60, 1},
		{0x1bfc, 0x1bff, 1},
		{0x1c3b, 0x1c3f, 1},
		{0x1c7e, 0x1c7f, 1},
		{0x1cd3, 0x2010, 829},
		{0x2011, 0x2027, 1},
		{0x2030, 0x2043, 1},
		{0x2045, 0x2051, 1},
		{0x2053, 0x205e, 1},
		{0x207d, 0x207e, 1},
		{0x208d, 0x208e, 1},
		{0x2329, 0x232a, 1},
		{0x2768, 0x2775, 1},
		{0x27c5, 0x27c6, 1},
		{0x27e6, 0x27ef, 1},
		{0x2983, 0x2998, 1},
		{0x29d8, 0x29db, 1},
		{0x29fc, 0x29fd, 1},
		{0x2cf9, 0x2cfc, 1},
		{0x2cfe, 0x2cff, 1},
		{0x2d70, 0x2e00, 144},
		{0x2e01, 0x2e2e, 1},
		{0x2e30, 0x2e31, 1},
		{0x3001, 0x3003, 1},
		{0x3008, 0x3011, 1},
		{0x3014, 0x301f, 1},
		{0x3030, 0x303d, 13},
		{0x30a0, 0x30fb, 91},
		{0xa4fe, 0xa4ff, 1},
		{0xa60d, 0xa60f, 1},
		{0xa673, 0xa67e, 11},
		{0xa6f2, 0xa6f7, 1},
		{0xa874, 0xa877, 1},
		{0xa8ce, 0xa8cf, 1},
		{0xa8f8, 0xa8fa, 1},
		{0xa92e, 0xa92f, 1},
		{0xa95f, 0xa9c1, 98},
		{0xa9c2, 0xa9cd, 1},
		{0xa9de, 0xa9df, 1},
		{0xaa5c, 0xaa5f, 1},
		{0xaade, 0xaadf, 1},
		{0xabeb, 0xfd3e, 20819},
		{0xfd3f, 0xfe10, 209},
		{0xfe11, 0xfe19, 1},
		{0xfe30, 0xfe52, 1},
		{0xfe54, 0xfe61, 1},
		{0xfe63, 0xfe68, 5},
		{0xfe6a, 0xfe6b, 1},
		{0xff01, 0xff03, 1},
		{0xff05, 0xff0a, 1},
		{0xff0c, 0xff0f, 1},
		{0xff1a, 0xff1b, 1},
		{0xff1f, 0xff20, 1},
		{0xff3b, 0xff3d, 1},
		{0xff3f, 0xff5b, 28},
		{0xff5d, 0xff5f, 2},
		{0xff60, 0xff65, 1},
	},
	R32: []Range32{
		{0x10100, 0x10101, 1},
		{0x1039f, 0x103d0, 49},
		{0x10857, 0x1091f, 200},
		{0x1093f, 0x10a50, 273},
		{0x10a51, 0x10a58, 1},
		{0x10a7f, 0x10b39, 186},
		{0x10b3a, 0x10b3f, 1},
		{0x11047, 0x1104d, 1},
		{0x110bb, 0x110bc, 1},
		{0x110be, 0x110c1, 1},
		{0x12470, 0x12473, 1},
	},
}

var _S = &RangeTable{
	R16: []Range16{
		{0x0024, 0x002b, 7},
		{0x003c, 0x003e, 1},
		{0x005e, 0x0060, 2},
		{0x007c, 0x007e, 2},
		{0x00a2, 0x00a9, 1},
		{0x00ac, 0x00ae, 2},
		{0x00af, 0x00b1, 1},
		{0x00b4, 0x00b8, 2},
		{0x00d7, 0x00f7, 32},
		{0x02c2, 0x02c5, 1},
		{0x02d2, 0x02df, 1},
		{0x02e5, 0x02eb, 1},
		{0x02ed, 0x02ef, 2},
		{0x02f0, 0x02ff, 1},
		{0x0375, 0x0384, 15},
		{0x0385, 0x03f6, 113},
		{0x0482, 0x0606, 388},
		{0x0607, 0x0608, 1},
		{0x060b, 0x060e, 3},
		{0x060f, 0x06de, 207},
		{0x06e9, 0x06fd, 20},
		{0x06fe, 0x07f6, 248},
		{0x09f2, 0x09f3, 1},
		{0x09fa, 0x09fb, 1},
		{0x0af1, 0x0b70, 127},
		{0x0bf3, 0x0bfa, 1},
		{0x0c7f, 0x0d79, 250},
		{0x0e3f, 0x0f01, 194},
		{0x0f02, 0x0f03, 1},
		{0x0f13, 0x0f17, 1},
		{0x0f1a, 0x0f1f, 1},
		{0x0f34, 0x0f38, 2},
		{0x0fbe, 0x0fc5, 1},
		{0x0fc7, 0x0fcc, 1},
		{0x0fce, 0x0fcf, 1},
		{0x0fd5, 0x0fd8, 1},
		{0x109e, 0x109f, 1},
		{0x1360, 0x1390, 48},
		{0x1391, 0x1399, 1},
		{0x17db, 0x1940, 357},
		{0x19de, 0x19ff, 1},
		{0x1b61, 0x1b6a, 1},
		{0x1b74, 0x1b7c, 1},
		{0x1fbd, 0x1fbf, 2},
		{0x1fc0, 0x1fc1, 1},
		{0x1fcd, 0x1fcf, 1},
		{0x1fdd, 0x1fdf, 1},
		{0x1fed, 0x1fef, 1},
		{0x1ffd, 0x1ffe, 1},
		{0x2044, 0x2052, 14},
		{0x207a, 0x207c, 1},
		{0x208a, 0x208c, 1},
		{0x20a0, 0x20b9, 1},
		{0x2100, 0x2101, 1},
		{0x2103, 0x2106, 1},
		{0x2108, 0x2109, 1},
		{0x2114, 0x2116, 2},
		{0x2117, 0x2118, 1},
		{0x211e, 0x2123, 1},
		{0x2125, 0x2129, 2},
		{0x212e, 0x213a, 12},
		{0x213b, 0x2140, 5},
		{0x2141, 0x2144, 1},
		{0x214a, 0x214d, 1},
		{0x214f, 0x2190, 65},
		{0x2191, 0x2328, 1},
		{0x232b, 0x23f3, 1},
		{0x2400, 0x2426, 1},
		{0x2440, 0x244a, 1},
		{0x249c, 0x24e9, 1},
		{0x2500, 0x26ff, 1},
		{0x2701, 0x2767, 1},
		{0x2794, 0x27c4, 1},
		{0x27c7, 0x27ca, 1},
		{0x27cc, 0x27ce, 2},
		{0x27cf, 0x27e5, 1},
		{0x27f0, 0x2982, 1},
		{0x2999, 0x29d7, 1},
		{0x29dc, 0x29fb, 1},
		{0x29fe, 0x2b4c, 1},
		{0x2b50, 0x2b59, 1},
		{0x2ce5, 0x2cea, 1},
		{0x2e80, 0x2e99, 1},
		{0x2e9b, 0x2ef3, 1},
		{0x2f00, 0x2fd5, 1},
		{0x2ff0, 0x2ffb, 1},
		{0x3004, 0x3012, 14},
		{0x3013, 0x3020, 13},
		{0x3036, 0x3037, 1},
		{0x303e, 0x303f, 1},
		{0x309b, 0x309c, 1},
		{0x3190, 0x3191, 1},
		{0x3196, 0x319f, 1},
		{0x31c0, 0x31e3, 1},
		{0x3200, 0x321e, 1},
		{0x322a, 0x3250, 1},
		{0x3260, 0x327f, 1},
		{0x328a, 0x32b0, 1},
		{0x32c0, 0x32fe, 1},
		{0x3300, 0x33ff, 1},
		{0x4dc0, 0x4dff, 1},
		{0xa490, 0xa4c6, 1},
		{0xa700, 0xa716, 1},
		{0xa720, 0xa721, 1},
		{0xa789, 0xa78a, 1},
		{0xa828, 0xa82b, 1},
		{0xa836, 0xa839, 1},
		{0xaa77, 0xaa79, 1},
		{0xfb29, 0xfbb2, 137},
		{0xfbb3, 0xfbc1, 1},
		{0xfdfc, 0xfdfd, 1},
		{0xfe62, 0xfe64, 2},
		{0xfe65, 0xfe66, 1},
		{0xfe69, 0xff04, 155},
		{0xff0b, 0xff1c, 17},
		{0xff1d, 0xff1e, 1},
		{0xff3e, 0xff40, 2},
		{0xff5c, 0xff5e, 2},
		{0xffe0, 0xffe6, 1},
		{0xffe8, 0xffee, 1},
		{0xfffc, 0xfffd, 1},
	},
	R32: []Range32{
		{0x10102, 0x10137, 53},
		{0x10138, 0x1013f, 1},
		{0x10179, 0x10189, 1},
		{0x10190, 0x1019b, 1},
		{0x101d0, 0x101fc, 1},
		{0x1d000, 0x1d0f5, 1},
		{0x1d100, 0x1d126, 1},
		{0x1d129, 0x1d164, 1},
		{0x1d16a, 0x1d16c, 1},
		{0x1d183, 0x1d184, 1},
		{0x1d18c, 0x1d1a9, 1},
		{0x1d1ae, 0x1d1dd, 1},
		{0x1d200, 0x1d241, 1},
		{0x1d245, 0x1d300, 187},
		{0x1d301, 0x1d356, 1},
		{0x1d6c1, 0x1d6db, 26},
		{0x1d6fb, 0x1d715, 26},
		{0x1d735, 0x1d74f, 26},
		{0x1d76f, 0x1d789, 26},
		{0x1d7a9, 0x1d7c3, 26},
		{0x1f000, 0x1f02b, 1},
		{0x1f030, 0x1f093, 1},
		{0x1f0a0, 0x1f0ae, 1},
		{0x1f0b1, 0x1f0be, 1},
		{0x1f0c1, 0x1f0cf, 1},
		{0x1f0d1, 0x1f0df, 1},
		{0x1f110, 0x1f12e, 1},
		{0x1f130, 0x1f169, 1},
		{0x1f170, 0x1f19a, 1},
		{0x1f1e6, 0x1f202, 1},
		{0x1f210, 0x1f23a, 1},
		{0x1f240, 0x1f248, 1},
		{0x1f250, 0x1f251, 1},
		{0x1f300, 0x1f320, 1},
		{0x1f330, 0x1f335, 1},
		{0x1f337, 0x1f37c, 1},
		{0x1f380, 0x1f393, 1},
		{0x1f3a0, 0x1f3c4, 1},
		{0x1f3c6, 0x1f3ca, 1},
		{0x1f3e0, 0x1f3f0, 1},
		{0x1f400, 0x1f43e, 1},
		{0x1f440, 0x1f442, 2},
		{0x1f443, 0x1f4f7, 1},
		{0x1f4f9, 0x1f4fc, 1},
		{0x1f500, 0x1f53d, 1},
		{0x1f550, 0x1f567, 1},
		{0x1f5fb, 0x1f5ff, 1},
		{0x1f601, 0x1f610, 1},
		{0x1f612, 0x1f614, 1},
		{0x1f616, 0x1f61c, 2},
		{0x1f61d, 0x1f61e, 1},
		{0x1f620, 0x1f625, 1},
		{0x1f628, 0x1f62b, 1},
		{0x1f62d, 0x1f630, 3},
		{0x1f631, 0x1f633, 1},
		{0x1f635, 0x1f640, 1},
		{0x1f645, 0x1f64f, 1},
		{0x1f680, 0x1f6c5, 1},
		{0x1f700, 0x1f773, 1},
	},
}

var _Z = &RangeTable{
	R16: []Range16{
		{0x0020, 0x00a0, 128},
		{0x1680, 0x180e, 398},
		{0x2000, 0x200a, 1},
		{0x2028, 0x2029, 1},
		{0x202f, 0x205f, 48},
		{0x3000, 0x3000, 1},
	},
}

var _Me = &RangeTable{
	R16: []Range16{
		{0x0488, 0x0489, 1},
		{0x20dd, 0x20e0, 1},
		{0x20e2, 0x20e4, 1},
		{0xa670, 0xa672, 1},
	},
}

var _Mc = &RangeTable{
	R16: []Range16{
		{0x0903, 0x093b, 56},
		{0x093e, 0x0940, 1},
		{0x0949, 0x094c, 1},
		{0x094e, 0x094f, 1},
		{0x0982, 0x0983, 1},
		{0x09be, 0x09c0, 1},
		{0x09c7, 0x09c8, 1},
		{0x09cb, 0x09cc, 1},
		{0x09d7, 0x0a03, 44},
		{0x0a3e, 0x0a40, 1},
		{0x0a83, 0x0abe, 59},
		{0x0abf, 0x0ac0, 1},
		{0x0ac9, 0x0acb, 2},
		{0x0acc, 0x0b02, 54},
		{0x0b03, 0x0b3e, 59},
		{0x0b40, 0x0b47, 7},
		{0x0b48, 0x0b4b, 3},
		{0x0b4c, 0x0b57, 11},
		{0x0bbe, 0x0bbf, 1},
		{0x0bc1, 0x0bc2, 1},
		{0x0bc6, 0x0bc8, 1},
		{0x0bca, 0x0bcc, 1},
		{0x0bd7, 0x0c01, 42},
		{0x0c02, 0x0c03, 1},
		{0x0c41, 0x0c44, 1},
		{0x0c82, 0x0c83, 1},
		{0x0cbe, 0x0cc0, 2},
		{0x0cc1, 0x0cc4, 1},
		{0x0cc7, 0x0cc8, 1},
		{0x0cca, 0x0ccb, 1},
		{0x0cd5, 0x0cd6, 1},
		{0x0d02, 0x0d03, 1},
		{0x0d3e, 0x0d40, 1},
		{0x0d46, 0x0d48, 1},
		{0x0d4a, 0x0d4c, 1},
		{0x0d57, 0x0d82, 43},
		{0x0d83, 0x0dcf, 76},
		{0x0dd0, 0x0dd1, 1},
		{0x0dd8, 0x0ddf, 1},
		{0x0df2, 0x0df3, 1},
		{0x0f3e, 0x0f3f, 1},
		{0x0f7f, 0x102b, 172},
		{0x102c, 0x1031, 5},
		{0x1038, 0x103b, 3},
		{0x103c, 0x1056, 26},
		{0x1057, 0x1062, 11},
		{0x1063, 0x1064, 1},
		{0x1067, 0x106d, 1},
		{0x1083, 0x1084, 1},
		{0x1087, 0x108c, 1},
		{0x108f, 0x109a, 11},
		{0x109b, 0x109c, 1},
		{0x17b6, 0x17be, 8},
		{0x17bf, 0x17c5, 1},
		{0x17c7, 0x17c8, 1},
		{0x1923, 0x1926, 1},
		{0x1929, 0x192b, 1},
		{0x1930, 0x1931, 1},
		{0x1933, 0x1938, 1},
		{0x19b0, 0x19c0, 1},
		{0x19c8, 0x19c9, 1},
		{0x1a19, 0x1a1b, 1},
		{0x1a55, 0x1a57, 2},
		{0x1a61, 0x1a63, 2},
		{0x1a64, 0x1a6d, 9},
		{0x1a6e, 0x1a72, 1},
		{0x1b04, 0x1b35, 49},
		{0x1b3b, 0x1b3d, 2},
		{0x1b3e, 0x1b41, 1},
		{0x1b43, 0x1b44, 1},
		{0x1b82, 0x1ba1, 31},
		{0x1ba6, 0x1ba7, 1},
		{0x1baa, 0x1be7, 61},
		{0x1bea, 0x1bec, 1},
		{0x1bee, 0x1bf2, 4},
		{0x1bf3, 0x1c24, 49},
		{0x1c25, 0x1c2b, 1},
		{0x1c34, 0x1c35, 1},
		{0x1ce1, 0x1cf2, 17},
		{0xa823, 0xa824, 1},
		{0xa827, 0xa880, 89},
		{0xa881, 0xa8b4, 51},
		{0xa8b5, 0xa8c3, 1},
		{0xa952, 0xa953, 1},
		{0xa983, 0xa9b4, 49},
		{0xa9b5, 0xa9ba, 5},
		{0xa9bb, 0xa9bd, 2},
		{0xa9be, 0xa9c0, 1},
		{0xaa2f, 0xaa30, 1},
		{0xaa33, 0xaa34, 1},
		{0xaa4d, 0xaa7b, 46},
		{0xabe3, 0xabe4, 1},
		{0xabe6, 0xabe7, 1},
		{0xabe9, 0xabea, 1},
		{0xabec, 0xabec, 1},
	},
	R32: []Range32{
		{0x11000, 0x11000, 1},
		{0x11002, 0x11082, 128},
		{0x110b0, 0x110b2, 1},
		{0x110b7, 0x110b8, 1},
		{0x1d165, 0x1d166, 1},
		{0x1d16d, 0x1d172, 1},
	},
}

var _Mn = &RangeTable{
	R16: []Range16{
		{0x0300, 0x036f, 1},
		{0x0483, 0x0487, 1},
		{0x0591, 0x05bd, 1},
		{0x05bf, 0x05c1, 2},
		{0x05c2, 0x05c4, 2},
		{0x05c5, 0x05c7, 2},
		{0x0610, 0x061a, 1},
		{0x064b, 0x065f, 1},
		{0x0670, 0x06d6, 102},
		{0x06d7, 0x06dc, 1},
		{0x06df, 0x06e4, 1},
		{0x06e7, 0x06e8, 1},
		{0x06ea, 0x06ed, 1},
		{0x0711, 0x0730, 31},
		{0x0731, 0x074a, 1},
		{0x07a6, 0x07b0, 1},
		{0x07eb, 0x07f3, 1},
		{0x0816, 0x0819, 1},
		{0x081b, 0x0823, 1},
		{0x0825, 0x0827, 1},
		{0x0829, 0x082d, 1},
		{0x0859, 0x085b, 1},
		{0x0900, 0x0902, 1},
		{0x093a, 0x093c, 2},
		{0x0941, 0x0948, 1},
		{0x094d, 0x0951, 4},
		{0x0952, 0x0957, 1},
		{0x0962, 0x0963, 1},
		{0x0981, 0x09bc, 59},
		{0x09c1, 0x09c4, 1},
		{0x09cd, 0x09e2, 21},
		{0x09e3, 0x0a01, 30},
		{0x0a02, 0x0a3c, 58},
		{0x0a41, 0x0a42, 1},
		{0x0a47, 0x0a48, 1},
		{0x0a4b, 0x0a4d, 1},
		{0x0a51, 0x0a70, 31},
		{0x0a71, 0x0a75, 4},
		{0x0a81, 0x0a82, 1},
		{0x0abc, 0x0ac1, 5},
		{0x0ac2, 0x0ac5, 1},
		{0x0ac7, 0x0ac8, 1},
		{0x0acd, 0x0ae2, 21},
		{0x0ae3, 0x0b01, 30},
		{0x0b3c, 0x0b3f, 3},
		{0x0b41, 0x0b44, 1},
		{0x0b4d, 0x0b56, 9},
		{0x0b62, 0x0b63, 1},
		{0x0b82, 0x0bc0, 62},
		{0x0bcd, 0x0c3e, 113},
		{0x0c3f, 0x0c40, 1},
		{0x0c46, 0x0c48, 1},
		{0x0c4a, 0x0c4d, 1},
		{0x0c55, 0x0c56, 1},
		{0x0c62, 0x0c63, 1},
		{0x0cbc, 0x0cbf, 3},
		{0x0cc6, 0x0ccc, 6},
		{0x0ccd, 0x0ce2, 21},
		{0x0ce3, 0x0d41, 94},
		{0x0d42, 0x0d44, 1},
		{0x0d4d, 0x0d62, 21},
		{0x0d63, 0x0dca, 103},
		{0x0dd2, 0x0dd4, 1},
		{0x0dd6, 0x0e31, 91},
		{0x0e34, 0x0e3a, 1},
		{0x0e47, 0x0e4e, 1},
		{0x0eb1, 0x0eb4, 3},
		{0x0eb5, 0x0eb9, 1},
		{0x0ebb, 0x0ebc, 1},
		{0x0ec8, 0x0ecd, 1},
		{0x0f18, 0x0f19, 1},
		{0x0f35, 0x0f39, 2},
		{0x0f71, 0x0f7e, 1},
		{0x0f80, 0x0f84, 1},
		{0x0f86, 0x0f87, 1},
		{0x0f8d, 0x0f97, 1},
		{0x0f99, 0x0fbc, 1},
		{0x0fc6, 0x102d, 103},
		{0x102e, 0x1030, 1},
		{0x1032, 0x1037, 1},
		{0x1039, 0x103a, 1},
		{0x103d, 0x103e, 1},
		{0x1058, 0x1059, 1},
		{0x105e, 0x1060, 1},
		{0x1071, 0x1074, 1},
		{0x1082, 0x1085, 3},
		{0x1086, 0x108d, 7},
		{0x109d, 0x135d, 704},
		{0x135e, 0x135f, 1},
		{0x1712, 0x1714, 1},
		{0x1732, 0x1734, 1},
		{0x1752, 0x1753, 1},
		{0x1772, 0x1773, 1},
		{0x17b7, 0x17bd, 1},
		{0x17c6, 0x17c9, 3},
		{0x17ca, 0x17d3, 1},
		{0x17dd, 0x180b, 46},
		{0x180c, 0x180d, 1},
		{0x18a9, 0x1920, 119},
		{0x1921, 0x1922, 1},
		{0x1927, 0x1928, 1},
		{0x1932, 0x1939, 7},
		{0x193a, 0x193b, 1},
		{0x1a17, 0x1a18, 1},
		{0x1a56, 0x1a58, 2},
		{0x1a59, 0x1a5e, 1},
		{0x1a60, 0x1a62, 2},
		{0x1a65, 0x1a6c, 1},
		{0x1a73, 0x1a7c, 1},
		{0x1a7f, 0x1b00, 129},
		{0x1b01, 0x1b03, 1},
		{0x1b34, 0x1b36, 2},
		{0x1b37, 0x1b3a, 1},
		{0x1b3c, 0x1b42, 6},
		{0x1b6b, 0x1b73, 1},
		{0x1b80, 0x1b81, 1},
		{0x1ba2, 0x1ba5, 1},
		{0x1ba8, 0x1ba9, 1},
		{0x1be6, 0x1be8, 2},
		{0x1be9, 0x1bed, 4},
		{0x1bef, 0x1bf1, 1},
		{0x1c2c, 0x1c33, 1},
		{0x1c36, 0x1c37, 1},
		{0x1cd0, 0x1cd2, 1},
		{0x1cd4, 0x1ce0, 1},
		{0x1ce2, 0x1ce8, 1},
		{0x1ced, 0x1dc0, 211},
		{0x1dc1, 0x1de6, 1},
		{0x1dfc, 0x1dff, 1},
		{0x20d0, 0x20dc, 1},
		{0x20e1, 0x20e5, 4},
		{0x20e6, 0x20f0, 1},
		{0x2cef, 0x2cf1, 1},
		{0x2d7f, 0x2de0, 97},
		{0x2de1, 0x2dff, 1},
		{0x302a, 0x302f, 1},
		{0x3099, 0x309a, 1},
		{0xa66f, 0xa67c, 13},
		{0xa67d, 0xa6f0, 115},
		{0xa6f1, 0xa802, 273},
		{0xa806, 0xa80b, 5},
		{0xa825, 0xa826, 1},
		{0xa8c4, 0xa8e0, 28},
		{0xa8e1, 0xa8f1, 1},
		{0xa926, 0xa92d, 1},
		{0xa947, 0xa951, 1},
		{0xa980, 0xa982, 1},
		{0xa9b3, 0xa9b6, 3},
		{0xa9b7, 0xa9b9, 1},
		{0xa9bc, 0xaa29, 109},
		{0xaa2a, 0xaa2e, 1},
		{0xaa31, 0xaa32, 1},
		{0xaa35, 0xaa36, 1},
		{0xaa43, 0xaa4c, 9},
		{0xaab0, 0xaab2, 2},
		{0xaab3, 0xaab4, 1},
		{0xaab7, 0xaab8, 1},
		{0xaabe, 0xaabf, 1},
		{0xaac1, 0xabe5, 292},
		{0xabe8, 0xabed, 5},
		{0xfb1e, 0xfe00, 738},
		{0xfe01, 0xfe0f, 1},
		{0xfe20, 0xfe26, 1},
	},
	R32: []Range32{
		{0x101fd, 0x10a01, 2052},
		{0x10a02, 0x10a03, 1},
		{0x10a05, 0x10a06, 1},
		{0x10a0c, 0x10a0f, 1},
		{0x10a38, 0x10a3a, 1},
		{0x10a3f, 0x11001, 1474},
		{0x11038, 0x11046, 1},
		{0x11080, 0x11081, 1},
		{0x110b3, 0x110b6, 1},
		{0x110b9, 0x110ba, 1},
		{0x1d167, 0x1d169, 1},
		{0x1d17b, 0x1d182, 1},
		{0x1d185, 0x1d18b, 1},
		{0x1d1aa, 0x1d1ad, 1},
		{0x1d242, 0x1d244, 1},
		{0xe0100, 0xe01ef, 1},
	},
}

var _Zl = &RangeTable{
	R16: []Range16{
		{0x2028, 0x2028, 1},
	},
}

var _Zp = &RangeTable{
	R16: []Range16{
		{0x2029, 0x2029, 1},
	},
}

var _Zs = &RangeTable{
	R16: []Range16{
		{0x0020, 0x00a0, 128},
		{0x1680, 0x180e, 398},
		{0x2000, 0x200a, 1},
		{0x202f, 0x205f, 48},
		{0x3000, 0x3000, 1},
	},
}

var _Cs = &RangeTable{
	R16: []Range16{
		{0xd800, 0xdfff, 1},
	},
}

var _Co = &RangeTable{
	R16: []Range16{
		{0xe000, 0xf8ff, 1},
	},
	R32: []Range32{
		{0xf0000, 0xffffd, 1},
		{0x100000, 0x10fffd, 1},
	},
}

var _Cf = &RangeTable{
	R16: []Range16{
		{0x00ad, 0x0600, 1363},
		{0x0601, 0x0603, 1},
		{0x06dd, 0x070f, 50},
		{0x17b4, 0x17b5, 1},
		{0x200b, 0x200f, 1},
		{0x202a, 0x202e, 1},
		{0x2060, 0x2064, 1},
		{0x206a, 0x206f, 1},
		{0xfeff, 0xfff9, 250},
		{0xfffa, 0xfffb, 1},
	},
	R32: []Range32{
		{0x110bd, 0x1d173, 49334},
		{0x1d174, 0x1d17a, 1},
		{0xe0001, 0xe0020, 31},
		{0xe0021, 0xe007f, 1},
	},
}

var _Cc = &RangeTable{
	R16: []Range16{
		{0x0001, 0x001f, 1},
		{0x007f, 0x009f, 1},
	},
}

var _Po = &RangeTable{
	R16: []Range16{
		{0x0021, 0x0023, 1},
		{0x0025, 0x0027, 1},
		{0x002a, 0x002e, 2},
		{0x002f, 0x003a, 11},
		{0x003b, 0x003f, 4},
		{0x0040, 0x005c, 28},
		{0x00a1, 0x00b7, 22},
		{0x00bf, 0x037e, 703},
		{0x0387, 0x055a, 467},
		{0x055b, 0x055f, 1},
		{0x0589, 0x05c0, 55},
		{0x05c3, 0x05c6, 3},
		{0x05f3, 0x05f4, 1},
		{0x0609, 0x060a, 1},
		{0x060c, 0x060d, 1},
		{0x061b, 0x061e, 3},
		{0x061f, 0x066a, 75},
		{0x066b, 0x066d, 1},
		{0x06d4, 0x0700, 44},
		{0x0701, 0x070d, 1},
		{0x07f7, 0x07f9, 1},
		{0x0830, 0x083e, 1},
		{0x085e, 0x0964, 262},
		{0x0965, 0x0970, 11},
		{0x0df4, 0x0e4f, 91},
		{0x0e5a, 0x0e5b, 1},
		{0x0f04, 0x0f12, 1},
		{0x0f85, 0x0fd0, 75},
		{0x0fd1, 0x0fd4, 1},
		{0x0fd9, 0x0fda, 1},
		{0x104a, 0x104f, 1},
		{0x10fb, 0x1361, 614},
		{0x1362, 0x1368, 1},
		{0x166d, 0x166e, 1},
		{0x16eb, 0x16ed, 1},
		{0x1735, 0x1736, 1},
		{0x17d4, 0x17d6, 1},
		{0x17d8, 0x17da, 1},
		{0x1800, 0x1805, 1},
		{0x1807, 0x180a, 1},
		{0x1944, 0x1945, 1},
		{0x1a1e, 0x1a1f, 1},
		{0x1aa0, 0x1aa6, 1},
		{0x1aa8, 0x1aad, 1},
		{0x1b5a, 0x1b60, 1},
		{0x1bfc, 0x1bff, 1},
		{0x1c3b, 0x1c3f, 1},
		{0x1c7e, 0x1c7f, 1},
		{0x1cd3, 0x2016, 835},
		{0x2017, 0x2020, 9},
		{0x2021, 0x2027, 1},
		{0x2030, 0x2038, 1},
		{0x203b, 0x203e, 1},
		{0x2041, 0x2043, 1},
		{0x2047, 0x2051, 1},
		{0x2053, 0x2055, 2},
		{0x2056, 0x205e, 1},
		{0x2cf9, 0x2cfc, 1},
		{0x2cfe, 0x2cff, 1},
		{0x2d70, 0x2e00, 144},
		{0x2e01, 0x2e06, 5},
		{0x2e07, 0x2e08, 1},
		{0x2e0b, 0x2e0e, 3},
		{0x2e0f, 0x2e16, 1},
		{0x2e18, 0x2e19, 1},
		{0x2e1b, 0x2e1e, 3},
		{0x2e1f, 0x2e2a, 11},
		{0x2e2b, 0x2e2e, 1},
		{0x2e30, 0x2e31, 1},
		{0x3001, 0x3003, 1},
		{0x303d, 0x30fb, 190},
		{0xa4fe, 0xa4ff, 1},
		{0xa60d, 0xa60f, 1},
		{0xa673, 0xa67e, 11},
		{0xa6f2, 0xa6f7, 1},
		{0xa874, 0xa877, 1},
		{0xa8ce, 0xa8cf, 1},
		{0xa8f8, 0xa8fa, 1},
		{0xa92e, 0xa92f, 1},
		{0xa95f, 0xa9c1, 98},
		{0xa9c2, 0xa9cd, 1},
		{0xa9de, 0xa9df, 1},
		{0xaa5c, 0xaa5f, 1},
		{0xaade, 0xaadf, 1},
		{0xabeb, 0xfe10, 21029},
		{0xfe11, 0xfe16, 1},
		{0xfe19, 0xfe30, 23},
		{0xfe45, 0xfe46, 1},
		{0xfe49, 0xfe4c, 1},
		{0xfe50, 0xfe52, 1},
		{0xfe54, 0xfe57, 1},
		{0xfe5f, 0xfe61, 1},
		{0xfe68, 0xfe6a, 2},
		{0xfe6b, 0xff01, 150},
		{0xff02, 0xff03, 1},
		{0xff05, 0xff07, 1},
		{0xff0a, 0xff0e, 2},
		{0xff0f, 0xff1a, 11},
		{0xff1b, 0xff1f, 4},
		{0xff20, 0xff3c, 28},
		{0xff61, 0xff64, 3},
		{0xff65, 0xff65, 1},
	},
	R32: []Range32{
		{0x10100, 0x10100, 1},
		{0x10101, 0x1039f, 670},
		{0x103d0, 0x10857, 1159},
		{0x1091f, 0x1093f, 32},
		{0x10a50, 0x10a58, 1},
		{0x10a7f, 0x10b39, 186},
		{0x10b3a, 0x10b3f, 1},
		{0x11047, 0x1104d, 1},
		{0x110bb, 0x110bc, 1},
		{0x110be, 0x110c1, 1},
		{0x12470, 0x12473, 1},
	},
}

var _Pi = &RangeTable{
	R16: []Range16{
		{0x00ab, 0x2018, 8045},
		{0x201b, 0x201c, 1},
		{0x201f, 0x2039, 26},
		{0x2e02, 0x2e04, 2},
		{0x2e09, 0x2e0c, 3},
		{0x2e1c, 0x2e20, 4},
	},
}

var _Pf = &RangeTable{
	R16: []Range16{
		{0x00bb, 0x2019, 8030},
		{0x201d, 0x203a, 29},
		{0x2e03, 0x2e05, 2},
		{0x2e0a, 0x2e0d, 3},
		{0x2e1d, 0x2e21, 4},
	},
}

var _Pe = &RangeTable{
	R16: []Range16{
		{0x0029, 0x005d, 52},
		{0x007d, 0x0f3b, 3774},
		{0x0f3d, 0x169c, 1887},
		{0x2046, 0x207e, 56},
		{0x208e, 0x232a, 668},
		{0x2769, 0x2775, 2},
		{0x27c6, 0x27e7, 33},
		{0x27e9, 0x27ef, 2},
		{0x2984, 0x2998, 2},
		{0x29d9, 0x29db, 2},
		{0x29fd, 0x2e23, 1062},
		{0x2e25, 0x2e29, 2},
		{0x3009, 0x3011, 2},
		{0x3015, 0x301b, 2},
		{0x301e, 0x301f, 1},
		{0xfd3f, 0xfe18, 217},
		{0xfe36, 0xfe44, 2},
		{0xfe48, 0xfe5a, 18},
		{0xfe5c, 0xfe5e, 2},
		{0xff09, 0xff3d, 52},
		{0xff5d, 0xff63, 3},
	},
}

var _Pd = &RangeTable{
	R16: []Range16{
		{0x002d, 0x058a, 1373},
		{0x05be, 0x1400, 3650},
		{0x1806, 0x2010, 2058},
		{0x2011, 0x2015, 1},
		{0x2e17, 0x2e1a, 3},
		{0x301c, 0x3030, 20},
		{0x30a0, 0xfe31, 52625},
		{0xfe32, 0xfe58, 38},
		{0xfe63, 0xff0d, 170},
	},
}

var _Pc = &RangeTable{
	R16: []Range16{
		{0x005f, 0x203f, 8160},
		{0x2040, 0x2054, 20},
		{0xfe33, 0xfe34, 1},
		{0xfe4d, 0xfe4f, 1},
		{0xff3f, 0xff3f, 1},
	},
}

var _Ps = &RangeTable{
	R16: []Range16{
		{0x0028, 0x005b, 51},
		{0x007b, 0x0f3a, 3775},
		{0x0f3c, 0x169b, 1887},
		{0x201a, 0x201e, 4},
		{0x2045, 0x207d, 56},
		{0x208d, 0x2329, 668},
		{0x2768, 0x2774, 2},
		{0x27c5, 0x27e6, 33},
		{0x27e8, 0x27ee, 2},
		{0x2983, 0x2997, 2},
		{0x29d8, 0x29da, 2},
		{0x29fc, 0x2e22, 1062},
		{0x2e24, 0x2e28, 2},
		{0x3008, 0x3010, 2},
		{0x3014, 0x301a, 2},
		{0x301d, 0xfd3e, 52513},
		{0xfe17, 0xfe35, 30},
		{0xfe37, 0xfe43, 2},
		{0xfe47, 0xfe59, 18},
		{0xfe5b, 0xfe5d, 2},
		{0xff08, 0xff3b, 51},
		{0xff5b, 0xff5f, 4},
		{0xff62, 0xff62, 1},
	},
}

var _Nd = &RangeTable{
	R16: []Range16{
		{0x0030, 0x0039, 1},
		{0x0660, 0x0669, 1},
		{0x06f0, 0x06f9, 1},
		{0x07c0, 0x07c9, 1},
		{0x0966, 0x096f, 1},
		{0x09e6, 0x09ef, 1},
		{0x0a66, 0x0a6f, 1},
		{0x0ae6, 0x0aef, 1},
		{0x0b66, 0x0b6f, 1},
		{0x0be6, 0x0bef, 1},
		{0x0c66, 0x0c6f, 1},
		{0x0ce6, 0x0cef, 1},
		{0x0d66, 0x0d6f, 1},
		{0x0e50, 0x0e59, 1},
		{0x0ed0, 0x0ed9, 1},
		{0x0f20, 0x0f29, 1},
		{0x1040, 0x1049, 1},
		{0x1090, 0x1099, 1},
		{0x17e0, 0x17e9, 1},
		{0x1810, 0x1819, 1},
		{0x1946, 0x194f, 1},
		{0x19d0, 0x19d9, 1},
		{0x1a80, 0x1a89, 1},
		{0x1a90, 0x1a99, 1},
		{0x1b50, 0x1b59, 1},
		{0x1bb0, 0x1bb9, 1},
		{0x1c40, 0x1c49, 1},
		{0x1c50, 0x1c59, 1},
		{0xa620, 0xa629, 1},
		{0xa8d0, 0xa8d9, 1},
		{0xa900, 0xa909, 1},
		{0xa9d0, 0xa9d9, 1},
		{0xaa50, 0xaa59, 1},
		{0xabf0, 0xabf9, 1},
		{0xff10, 0xff19, 1},
	},
	R32: []Range32{
		{0x104a0, 0x104a9, 1},
		{0x11066, 0x1106f, 1},
		{0x1d7ce, 0x1d7ff, 1},
	},
}

var _Nl = &RangeTable{
	R16: []Range16{
		{0x16ee, 0x16f0, 1},
		{0x2160, 0x2182, 1},
		{0x2185, 0x2188, 1},
		{0x3007, 0x3021, 26},
		{0x3022, 0x3029, 1},
		{0x3038, 0x303a, 1},
		{0xa6e6, 0xa6ef, 1},
	},
	R32: []Range32{
		{0x10140, 0x10174, 1},
		{0x10341, 0x1034a, 9},
		{0x103d1, 0x103d5, 1},
		{0x12400, 0x12462, 1},
	},
}

var _No = &RangeTable{
	R16: []Range16{
		{0x00b2, 0x00b3, 1},
		{0x00b9, 0x00bc, 3},
		{0x00bd, 0x00be, 1},
		{0x09f4, 0x09f9, 1},
		{0x0b72, 0x0b77, 1},
		{0x0bf0, 0x0bf2, 1},
		{0x0c78, 0x0c7e, 1},
		{0x0d70, 0x0d75, 1},
		{0x0f2a, 0x0f33, 1},
		{0x1369, 0x137c, 1},
		{0x17f0, 0x17f9, 1},
		{0x19da, 0x2070, 1686},
		{0x2074, 0x2079, 1},
		{0x2080, 0x2089, 1},
		{0x2150, 0x215f, 1},
		{0x2189, 0x2460, 727},
		{0x2461, 0x249b, 1},
		{0x24ea, 0x24ff, 1},
		{0x2776, 0x2793, 1},
		{0x2cfd, 0x3192, 1173},
		{0x3193, 0x3195, 1},
		{0x3220, 0x3229, 1},
		{0x3251, 0x325f, 1},
		{0x3280, 0x3289, 1},
		{0x32b1, 0x32bf, 1},
		{0xa830, 0xa835, 1},
	},
	R32: []Range32{
		{0x10107, 0x10133, 1},
		{0x10175, 0x10178, 1},
		{0x1018a, 0x10320, 406},
		{0x10321, 0x10323, 1},
		{0x10858, 0x1085f, 1},
		{0x10916, 0x1091b, 1},
		{0x10a40, 0x10a47, 1},
		{0x10a7d, 0x10a7e, 1},
		{0x10b58, 0x10b5f, 1},
		{0x10b78, 0x10b7f, 1},
		{0x10e60, 0x10e7e, 1},
		{0x11052, 0x11065, 1},
		{0x1d360, 0x1d371, 1},
		{0x1f100, 0x1f10a, 1},
	},
}

var _So = &RangeTable{
	R16: []Range16{
		{0x00a6, 0x00a7, 1},
		{0x00a9, 0x00ae, 5},
		{0x00b0, 0x00b6, 6},
		{0x0482, 0x060e, 396},
		{0x060f, 0x06de, 207},
		{0x06e9, 0x06fd, 20},
		{0x06fe, 0x07f6, 248},
		{0x09fa, 0x0b70, 374},
		{0x0bf3, 0x0bf8, 1},
		{0x0bfa, 0x0c7f, 133},
		{0x0d79, 0x0f01, 392},
		{0x0f02, 0x0f03, 1},
		{0x0f13, 0x0f17, 1},
		{0x0f1a, 0x0f1f, 1},
		{0x0f34, 0x0f38, 2},
		{0x0fbe, 0x0fc5, 1},
		{0x0fc7, 0x0fcc, 1},
		{0x0fce, 0x0fcf, 1},
		{0x0fd5, 0x0fd8, 1},
		{0x109e, 0x109f, 1},
		{0x1360, 0x1390, 48},
		{0x1391, 0x1399, 1},
		{0x1940, 0x19de, 158},
		{0x19df, 0x19ff, 1},
		{0x1b61, 0x1b6a, 1},
		{0x1b74, 0x1b7c, 1},
		{0x2100, 0x2101, 1},
		{0x2103, 0x2106, 1},
		{0x2108, 0x2109, 1},
		{0x2114, 0x2116, 2},
		{0x2117, 0x211e, 7},
		{0x211f, 0x2123, 1},
		{0x2125, 0x2129, 2},
		{0x212e, 0x213a, 12},
		{0x213b, 0x214a, 15},
		{0x214c, 0x214d, 1},
		{0x214f, 0x2195, 70},
		{0x2196, 0x2199, 1},
		{0x219c, 0x219f, 1},
		{0x21a1, 0x21a2, 1},
		{0x21a4, 0x21a5, 1},
		{0x21a7, 0x21ad, 1},
		{0x21af, 0x21cd, 1},
		{0x21d0, 0x21d1, 1},
		{0x21d3, 0x21d5, 2},
		{0x21d6, 0x21f3, 1},
		{0x2300, 0x2307, 1},
		{0x230c, 0x231f, 1},
		{0x2322, 0x2328, 1},
		{0x232b, 0x237b, 1},
		{0x237d, 0x239a, 1},
		{0x23b4, 0x23db, 1},
		{0x23e2, 0x23f3, 1},
		{0x2400, 0x2426, 1},
		{0x2440, 0x244a, 1},
		{0x249c, 0x24e9, 1},
		{0x2500, 0x25b6, 1},
		{0x25b8, 0x25c0, 1},
		{0x25c2, 0x25f7, 1},
		{0x2600, 0x266e, 1},
		{0x2670, 0x26ff, 1},
		{0x2701, 0x2767, 1},
		{0x2794, 0x27bf, 1},
		{0x2800, 0x28ff, 1},
		{0x2b00, 0x2b2f, 1},
		{0x2b45, 0x2b46, 1},
		{0x2b50, 0x2b59, 1},
		{0x2ce5, 0x2cea, 1},
		{0x2e80, 0x2e99, 1},
		{0x2e9b, 0x2ef3, 1},
		{0x2f00, 0x2fd5, 1},
		{0x2ff0, 0x2ffb, 1},
		{0x3004, 0x3012, 14},
		{0x3013, 0x3020, 13},
		{0x3036, 0x3037, 1},
		{0x303e, 0x303f, 1},
		{0x3190, 0x3191, 1},
		{0x3196, 0x319f, 1},
		{0x31c0, 0x31e3, 1},
		{0x3200, 0x321e, 1},
		{0x322a, 0x3250, 1},
		{0x3260, 0x327f, 1},
		{0x328a, 0x32b0, 1},
		{0x32c0, 0x32fe, 1},
		{0x3300, 0x33ff, 1},
		{0x4dc0, 0x4dff, 1},
		{0xa490, 0xa4c6, 1},
		{0xa828, 0xa82b, 1},
		{0xa836, 0xa837, 1},
		{0xa839, 0xaa77, 574},
		{0xaa78, 0xaa79, 1},
		{0xfdfd, 0xffe4, 487},
		{0xffe8, 0xffed, 5},
		{0xffee, 0xfffc, 14},
		{0xfffd, 0xfffd, 1},
	},
	R32: []Range32{
		{0x10102, 0x10102, 1},
		{0x10137, 0x1013f, 1},
		{0x10179, 0x10189, 1},
		{0x10190, 0x1019b, 1},
		{0x101d0, 0x101fc, 1},
		{0x1d000, 0x1d0f5, 1},
		{0x1d100, 0x1d126, 1},
		{0x1d129, 0x1d164, 1},
		{0x1d16a, 0x1d16c, 1},
		{0x1d183, 0x1d184, 1},
		{0x1d18c, 0x1d1a9, 1},
		{0x1d1ae, 0x1d1dd, 1},
		{0x1d200, 0x1d241, 1},
		{0x1d245, 0x1d300, 187},
		{0x1d301, 0x1d356, 1},
		{0x1f000, 0x1f02b, 1},
		{0x1f030, 0x1f093, 1},
		{0x1f0a0, 0x1f0ae, 1},
		{0x1f0b1, 0x1f0be, 1},
		{0x1f0c1, 0x1f0cf, 1},
		{0x1f0d1, 0x1f0df, 1},
		{0x1f110, 0x1f12e, 1},
		{0x1f130, 0x1f169, 1},
		{0x1f170, 0x1f19a, 1},
		{0x1f1e6, 0x1f202, 1},
		{0x1f210, 0x1f23a, 1},
		{0x1f240, 0x1f248, 1},
		{0x1f250, 0x1f251, 1},
		{0x1f300, 0x1f320, 1},
		{0x1f330, 0x1f335, 1},
		{0x1f337, 0x1f37c, 1},
		{0x1f380, 0x1f393, 1},
		{0x1f3a0, 0x1f3c4, 1},
		{0x1f3c6, 0x1f3ca, 1},
		{0x1f3e0, 0x1f3f0, 1},
		{0x1f400, 0x1f43e, 1},
		{0x1f440, 0x1f442, 2},
		{0x1f443, 0x1f4f7, 1},
		{0x1f4f9, 0x1f4fc, 1},
		{0x1f500, 0x1f53d, 1},
		{0x1f550, 0x1f567, 1},
		{0x1f5fb, 0x1f5ff, 1},
		{0x1f601, 0x1f610, 1},
		{0x1f612, 0x1f614, 1},
		{0x1f616, 0x1f61c, 2},
		{0x1f61d, 0x1f61e, 1},
		{0x1f620, 0x1f625, 1},
		{0x1f628, 0x1f62b, 1},
		{0x1f62d, 0x1f630, 3},
		{0x1f631, 0x1f633, 1},
		{0x1f635, 0x1f640, 1},
		{0x1f645, 0x1f64f, 1},
		{0x1f680, 0x1f6c5, 1},
		{0x1f700, 0x1f773, 1},
	},
}

var _Sm = &RangeTable{
	R16: []Range16{
		{0x002b, 0x003c, 17},
		{0x003d, 0x003e, 1},
		{0x007c, 0x007e, 2},
		{0x00ac, 0x00b1, 5},
		{0x00d7, 0x00f7, 32},
		{0x03f6, 0x0606, 528},
		{0x0607, 0x0608, 1},
		{0x2044, 0x2052, 14},
		{0x207a, 0x207c, 1},
		{0x208a, 0x208c, 1},
		{0x2118, 0x2140, 40},
		{0x2141, 0x2144, 1},
		{0x214b, 0x2190, 69},
		{0x2191, 0x2194, 1},
		{0x219a, 0x219b, 1},
		{0x21a0, 0x21a6, 3},
		{0x21ae, 0x21ce, 32},
		{0x21cf, 0x21d2, 3},
		{0x21d4, 0x21f4, 32},
		{0x21f5, 0x22ff, 1},
		{0x2308, 0x230b, 1},
		{0x2320, 0x2321, 1},
		{0x237c, 0x239b, 31},
		{0x239c, 0x23b3, 1},
		{0x23dc, 0x23e1, 1},
		{0x25b7, 0x25c1, 10},
		{0x25f8, 0x25ff, 1},
		{0x266f, 0x27c0, 337},
		{0x27c1, 0x27c4, 1},
		{0x27c7, 0x27ca, 1},
		{0x27cc, 0x27ce, 2},
		{0x27cf, 0x27e5, 1},
		{0x27f0, 0x27ff, 1},
		{0x2900, 0x2982, 1},
		{0x2999, 0x29d7, 1},
		{0x29dc, 0x29fb, 1},
		{0x29fe, 0x2aff, 1},
		{0x2b30, 0x2b44, 1},
		{0x2b47, 0x2b4c, 1},
		{0xfb29, 0xfe62, 825},
		{0xfe64, 0xfe66, 1},
		{0xff0b, 0xff1c, 17},
		{0xff1d, 0xff1e, 1},
		{0xff5c, 0xff5e, 2},
		{0xffe2, 0xffe9, 7},
		{0xffea, 0xffec, 1},
	},
	R32: []Range32{
		{0x1d6c1, 0x1d6db, 26},
		{0x1d6fb, 0x1d715, 26},
		{0x1d735, 0x1d74f, 26},
		{0x1d76f, 0x1d789, 26},
		{0x1d7a9, 0x1d7c3, 26},
	},
}

var _Sk = &RangeTable{
	R16: []Range16{
		{0x005e, 0x0060, 2},
		{0x00a8, 0x00af, 7},
		{0x00b4, 0x00b8, 4},
		{0x02c2, 0x02c5, 1},
		{0x02d2, 0x02df, 1},
		{0x02e5, 0x02eb, 1},
		{0x02ed, 0x02ef, 2},
		{0x02f0, 0x02ff, 1},
		{0x0375, 0x0384, 15},
		{0x0385, 0x1fbd, 7224},
		{0x1fbf, 0x1fc1, 1},
		{0x1fcd, 0x1fcf, 1},
		{0x1fdd, 0x1fdf, 1},
		{0x1fed, 0x1fef, 1},
		{0x1ffd, 0x1ffe, 1},
		{0x309b, 0x309c, 1},
		{0xa700, 0xa716, 1},
		{0xa720, 0xa721, 1},
		{0xa789, 0xa78a, 1},
		{0xfbb2, 0xfbc1, 1},
		{0xff3e, 0xff40, 2},
		{0xffe3, 0xffe3, 1},
	},
}

var _Sc = &RangeTable{
	R16: []Range16{
		{0x0024, 0x00a2, 126},
		{0x00a3, 0x00a5, 1},
		{0x060b, 0x09f2, 999},
		{0x09f3, 0x09fb, 8},
		{0x0af1, 0x0bf9, 264},
		{0x0e3f, 0x17db, 2460},
		{0x20a0, 0x20b9, 1},
		{0xa838, 0xfdfc, 21956},
		{0xfe69, 0xff04, 155},
		{0xffe0, 0xffe1, 1},
		{0xffe5, 0xffe6, 1},
	},
}

var _Lu = &RangeTable{
	R16: []Range16{
		{0x0041, 0x005a, 1},
		{0x00c0, 0x00d6, 1},
		{0x00d8, 0x00de, 1},
		{0x0100, 0x0136, 2},
		{0x0139, 0x0147, 2},
		{0x014a, 0x0178, 2},
		{0x0179, 0x017d, 2},
		{0x0181, 0x0182, 1},
		{0x0184, 0x0186, 2},
		{0x0187, 0x0189, 2},
		{0x018a, 0x018b, 1},
		{0x018e, 0x0191, 1},
		{0x0193, 0x0194, 1},
		{0x0196, 0x0198, 1},
		{0x019c, 0x019d, 1},
		{0x019f, 0x01a0, 1},
		{0x01a2, 0x01a6, 2},
		{0x01a7, 0x01a9, 2},
		{0x01ac, 0x01ae, 2},
		{0x01af, 0x01b1, 2},
		{0x01b2, 0x01b3, 1},
		{0x01b5, 0x01b7, 2},
		{0x01b8, 0x01bc, 4},
		{0x01c4, 0x01cd, 3},
		{0x01cf, 0x01db, 2},
		{0x01de, 0x01ee, 2},
		{0x01f1, 0x01f4, 3},
		{0x01f6, 0x01f8, 1},
		{0x01fa, 0x0232, 2},
		{0x023a, 0x023b, 1},
		{0x023d, 0x023e, 1},
		{0x0241, 0x0243, 2},
		{0x0244, 0x0246, 1},
		{0x0248, 0x024e, 2},
		{0x0370, 0x0372, 2},
		{0x0376, 0x0386, 16},
		{0x0388, 0x038a, 1},
		{0x038c, 0x038e, 2},
		{0x038f, 0x0391, 2},
		{0x0392, 0x03a1, 1},
		{0x03a3, 0x03ab, 1},
		{0x03cf, 0x03d2, 3},
		{0x03d3, 0x03d4, 1},
		{0x03d8, 0x03ee, 2},
		{0x03f4, 0x03f7, 3},
		{0x03f9, 0x03fa, 1},
		{0x03fd, 0x042f, 1},
		{0x0460, 0x0480, 2},
		{0x048a, 0x04c0, 2},
		{0x04c1, 0x04cd, 2},
		{0x04d0, 0x0526, 2},
		{0x0531, 0x0556, 1},
		{0x10a0, 0x10c5, 1},
		{0x1e00, 0x1e94, 2},
		{0x1e9e, 0x1efe, 2},
		{0x1f08, 0x1f0f, 1},
		{0x1f18, 0x1f1d, 1},
		{0x1f28, 0x1f2f, 1},
		{0x1f38, 0x1f3f, 1},
		{0x1f48, 0x1f4d, 1},
		{0x1f59, 0x1f5f, 2},
		{0x1f68, 0x1f6f, 1},
		{0x1fb8, 0x1fbb, 1},
		{0x1fc8, 0x1fcb, 1},
		{0x1fd8, 0x1fdb, 1},
		{0x1fe8, 0x1fec, 1},
		{0x1ff8, 0x1ffb, 1},
		{0x2102, 0x2107, 5},
		{0x210b, 0x210d, 1},
		{0x2110, 0x2112, 1},
		{0x2115, 0x2119, 4},
		{0x211a, 0x211d, 1},
		{0x2124, 0x212a, 2},
		{0x212b, 0x212d, 1},
		{0x2130, 0x2133, 1},
		{0x213e, 0x213f, 1},
		{0x2145, 0x2183, 62},
		{0x2c00, 0x2c2e, 1},
		{0x2c60, 0x2c62, 2},
		{0x2c63, 0x2c64, 1},
		{0x2c67, 0x2c6d, 2},
		{0x2c6e, 0x2c70, 1},
		{0x2c72, 0x2c75, 3},
		{0x2c7e, 0x2c80, 1},
		{0x2c82, 0x2ce2, 2},
		{0x2ceb, 0x2ced, 2},
		{0xa640, 0xa66c, 2},
		{0xa680, 0xa696, 2},
		{0xa722, 0xa72e, 2},
		{0xa732, 0xa76e, 2},
		{0xa779, 0xa77d, 2},
		{0xa77e, 0xa786, 2},
		{0xa78b, 0xa78d, 2},
		{0xa790, 0xa7a0, 16},
		{0xa7a2, 0xa7a8, 2},
		{0xff21, 0xff3a, 1},
	},
	R32: []Range32{
		{0x10400, 0x10427, 1},
		{0x1d400, 0x1d419, 1},
		{0x1d434, 0x1d44d, 1},
		{0x1d468, 0x1d481, 1},
		{0x1d49c, 0x1d49e, 2},
		{0x1d49f, 0x1d4a5, 3},
		{0x1d4a6, 0x1d4a9, 3},
		{0x1d4aa, 0x1d4ac, 1},
		{0x1d4ae, 0x1d4b5, 1},
		{0x1d4d0, 0x1d4e9, 1},
		{0x1d504, 0x1d505, 1},
		{0x1d507, 0x1d50a, 1},
		{0x1d50d, 0x1d514, 1},
		{0x1d516, 0x1d51c, 1},
		{0x1d538, 0x1d539, 1},
		{0x1d53b, 0x1d53e, 1},
		{0x1d540, 0x1d544, 1},
		{0x1d546, 0x1d54a, 4},
		{0x1d54b, 0x1d550, 1},
		{0x1d56c, 0x1d585, 1},
		{0x1d5a0, 0x1d5b9, 1},
		{0x1d5d4, 0x1d5ed, 1},
		{0x1d608, 0x1d621, 1},
		{0x1d63c, 0x1d655, 1},
		{0x1d670, 0x1d689, 1},
		{0x1d6a8, 0x1d6c0, 1},
		{0x1d6e2, 0x1d6fa, 1},
		{0x1d71c, 0x1d734, 1},
		{0x1d756, 0x1d76e, 1},
		{0x1d790, 0x1d7a8, 1},
		{0x1d7ca, 0x1d7ca, 1},
	},
}

var _Lt = &RangeTable{
	R16: []Range16{
		{0x01c5, 0x01cb, 3},
		{0x01f2, 0x1f88, 7574},
		{0x1f89, 0x1f8f, 1},
		{0x1f98, 0x1f9f, 1},
		{0x1fa8, 0x1faf, 1},
		{0x1fbc, 0x1fcc, 16},
		{0x1ffc, 0x1ffc, 1},
	},
}

var _Lo = &RangeTable{
	R16: []Range16{
		{0x01bb, 0x01c0, 5},
		{0x01c1, 0x01c3, 1},
		{0x0294, 0x05d0, 828},
		{0x05d1, 0x05ea, 1},
		{0x05f0, 0x05f2, 1},
		{0x0620, 0x063f, 1},
		{0x0641, 0x064a, 1},
		{0x066e, 0x066f, 1},
		{0x0671, 0x06d3, 1},
		{0x06d5, 0x06ee, 25},
		{0x06ef, 0x06fa, 11},
		{0x06fb, 0x06fc, 1},
		{0x06ff, 0x0710, 17},
		{0x0712, 0x072f, 1},
		{0x074d, 0x07a5, 1},
		{0x07b1, 0x07ca, 25},
		{0x07cb, 0x07ea, 1},
		{0x0800, 0x0815, 1},
		{0x0840, 0x0858, 1},
		{0x0904, 0x0939, 1},
		{0x093d, 0x0950, 19},
		{0x0958, 0x0961, 1},
		{0x0972, 0x0977, 1},
		{0x0979, 0x097f, 1},
		{0x0985, 0x098c, 1},
		{0x098f, 0x0990, 1},
		{0x0993, 0x09a8, 1},
		{0x09aa, 0x09b0, 1},
		{0x09b2, 0x09b6, 4},
		{0x09b7, 0x09b9, 1},
		{0x09bd, 0x09ce, 17},
		{0x09dc, 0x09dd, 1},
		{0x09df, 0x09e1, 1},
		{0x09f0, 0x09f1, 1},
		{0x0a05, 0x0a0a, 1},
		{0x0a0f, 0x0a10, 1},
		{0x0a13, 0x0a28, 1},
		{0x0a2a, 0x0a30, 1},
		{0x0a32, 0x0a33, 1},
		{0x0a35, 0x0a36, 1},
		{0x0a38, 0x0a39, 1},
		{0x0a59, 0x0a5c, 1},
		{0x0a5e, 0x0a72, 20},
		{0x0a73, 0x0a74, 1},
		{0x0a85, 0x0a8d, 1},
		{0x0a8f, 0x0a91, 1},
		{0x0a93, 0x0aa8, 1},
		{0x0aaa, 0x0ab0, 1},
		{0x0ab2, 0x0ab3, 1},
		{0x0ab5, 0x0ab9, 1},
		{0x0abd, 0x0ad0, 19},
		{0x0ae0, 0x0ae1, 1},
		{0x0b05, 0x0b0c, 1},
		{0x0b0f, 0x0b10, 1},
		{0x0b13, 0x0b28, 1},
		{0x0b2a, 0x0b30, 1},
		{0x0b32, 0x0b33, 1},
		{0x0b35, 0x0b39, 1},
		{0x0b3d, 0x0b5c, 31},
		{0x0b5d, 0x0b5f, 2},
		{0x0b60, 0x0b61, 1},
		{0x0b71, 0x0b83, 18},
		{0x0b85, 0x0b8a, 1},
		{0x0b8e, 0x0b90, 1},
		{0x0b92, 0x0b95, 1},
		{0x0b99, 0x0b9a, 1},
		{0x0b9c, 0x0b9e, 2},
		{0x0b9f, 0x0ba3, 4},
		{0x0ba4, 0x0ba8, 4},
		{0x0ba9, 0x0baa, 1},
		{0x0bae, 0x0bb9, 1},
		{0x0bd0, 0x0c05, 53},
		{0x0c06, 0x0c0c, 1},
		{0x0c0e, 0x0c10, 1},
		{0x0c12, 0x0c28, 1},
		{0x0c2a, 0x0c33, 1},
		{0x0c35, 0x0c39, 1},
		{0x0c3d, 0x0c58, 27},
		{0x0c59, 0x0c60, 7},
		{0x0c61, 0x0c85, 36},
		{0x0c86, 0x0c8c, 1},
		{0x0c8e, 0x0c90, 1},
		{0x0c92, 0x0ca8, 1},
		{0x0caa, 0x0cb3, 1},
		{0x0cb5, 0x0cb9, 1},
		{0x0cbd, 0x0cde, 33},
		{0x0ce0, 0x0ce1, 1},
		{0x0cf1, 0x0cf2, 1},
		{0x0d05, 0x0d0c, 1},
		{0x0d0e, 0x0d10, 1},
		{0x0d12, 0x0d3a, 1},
		{0x0d3d, 0x0d4e, 17},
		{0x0d60, 0x0d61, 1},
		{0x0d7a, 0x0d7f, 1},
		{0x0d85, 0x0d96, 1},
		{0x0d9a, 0x0db1, 1},
		{0x0db3, 0x0dbb, 1},
		{0x0dbd, 0x0dc0, 3},
		{0x0dc1, 0x0dc6, 1},
		{0x0e01, 0x0e30, 1},
		{0x0e32, 0x0e33, 1},
		{0x0e40, 0x0e45, 1},
		{0x0e81, 0x0e82, 1},
		{0x0e84, 0x0e87, 3},
		{0x0e88, 0x0e8a, 2},
		{0x0e8d, 0x0e94, 7},
		{0x0e95, 0x0e97, 1},
		{0x0e99, 0x0e9f, 1},
		{0x0ea1, 0x0ea3, 1},
		{0x0ea5, 0x0ea7, 2},
		{0x0eaa, 0x0eab, 1},
		{0x0ead, 0x0eb0, 1},
		{0x0eb2, 0x0eb3, 1},
		{0x0ebd, 0x0ec0, 3},
		{0x0ec1, 0x0ec4, 1},
		{0x0edc, 0x0edd, 1},
		{0x0f00, 0x0f40, 64},
		{0x0f41, 0x0f47, 1},
		{0x0f49, 0x0f6c, 1},
		{0x0f88, 0x0f8c, 1},
		{0x1000, 0x102a, 1},
		{0x103f, 0x1050, 17},
		{0x1051, 0x1055, 1},
		{0x105a, 0x105d, 1},
		{0x1061, 0x1065, 4},
		{0x1066, 0x106e, 8},
		{0x106f, 0x1070, 1},
		{0x1075, 0x1081, 1},
		{0x108e, 0x10d0, 66},
		{0x10d1, 0x10fa, 1},
		{0x1100, 0x1248, 1},
		{0x124a, 0x124d, 1},
		{0x1250, 0x1256, 1},
		{0x1258, 0x125a, 2},
		{0x125b, 0x125d, 1},
		{0x1260, 0x1288, 1},
		{0x128a, 0x128d, 1},
		{0x1290, 0x12b0, 1},
		{0x12b2, 0x12b5, 1},
		{0x12b8, 0x12be, 1},
		{0x12c0, 0x12c2, 2},
		{0x12c3, 0x12c5, 1},
		{0x12c8, 0x12d6, 1},
		{0x12d8, 0x1310, 1},
		{0x1312, 0x1315, 1},
		{0x1318, 0x135a, 1},
		{0x1380, 0x138f, 1},
		{0x13a0, 0x13f4, 1},
		{0x1401, 0x166c, 1},
		{0x166f, 0x167f, 1},
		{0x1681, 0x169a, 1},
		{0x16a0, 0x16ea, 1},
		{0x1700, 0x170c, 1},
		{0x170e, 0x1711, 1},
		{0x1720, 0x1731, 1},
		{0x1740, 0x1751, 1},
		{0x1760, 0x176c, 1},
		{0x176e, 0x1770, 1},
		{0x1780, 0x17b3, 1},
		{0x17dc, 0x1820, 68},
		{0x1821, 0x1842, 1},
		{0x1844, 0x1877, 1},
		{0x1880, 0x18a8, 1},
		{0x18aa, 0x18b0, 6},
		{0x18b1, 0x18f5, 1},
		{0x1900, 0x191c, 1},
		{0x1950, 0x196d, 1},
		{0x1970, 0x1974, 1},
		{0x1980, 0x19ab, 1},
		{0x19c1, 0x19c7, 1},
		{0x1a00, 0x1a16, 1},
		{0x1a20, 0x1a54, 1},
		{0x1b05, 0x1b33, 1},
		{0x1b45, 0x1b4b, 1},
		{0x1b83, 0x1ba0, 1},
		{0x1bae, 0x1baf, 1},
		{0x1bc0, 0x1be5, 1},
		{0x1c00, 0x1c23, 1},
		{0x1c4d, 0x1c4f, 1},
		{0x1c5a, 0x1c77, 1},
		{0x1ce9, 0x1cec, 1},
		{0x1cee, 0x1cf1, 1},
		{0x2135, 0x2138, 1},
		{0x2d30, 0x2d65, 1},
		{0x2d80, 0x2d96, 1},
		{0x2da0, 0x2da6, 1},
		{0x2da8, 0x2dae, 1},
		{0x2db0, 0x2db6, 1},
		{0x2db8, 0x2dbe, 1},
		{0x2dc0, 0x2dc6, 1},
		{0x2dc8, 0x2dce, 1},
		{0x2dd0, 0x2dd6, 1},
		{0x2dd8, 0x2dde, 1},
		{0x3006, 0x303c, 54},
		{0x3041, 0x3096, 1},
		{0x309f, 0x30a1, 2},
		{0x30a2, 0x30fa, 1},
		{0x30ff, 0x3105, 6},
		{0x3106, 0x312d, 1},
		{0x3131, 0x318e, 1},
		{0x31a0, 0x31ba, 1},
		{0x31f0, 0x31ff, 1},
		{0x3400, 0x4db5, 1},
		{0x4e00, 0x9fcb, 1},
		{0xa000, 0xa014, 1},
		{0xa016, 0xa48c, 1},
		{0xa4d0, 0xa4f7, 1},
		{0xa500, 0xa60b, 1},
		{0xa610, 0xa61f, 1},
		{0xa62a, 0xa62b, 1},
		{0xa66e, 0xa6a0, 50},
		{0xa6a1, 0xa6e5, 1},
		{0xa7fb, 0xa801, 1},
		{0xa803, 0xa805, 1},
		{0xa807, 0xa80a, 1},
		{0xa80c, 0xa822, 1},
		{0xa840, 0xa873, 1},
		{0xa882, 0xa8b3, 1},
		{0xa8f2, 0xa8f7, 1},
		{0xa8fb, 0xa90a, 15},
		{0xa90b, 0xa925, 1},
		{0xa930, 0xa946, 1},
		{0xa960, 0xa97c, 1},
		{0xa984, 0xa9b2, 1},
		{0xaa00, 0xaa28, 1},
		{0xaa40, 0xaa42, 1},
		{0xaa44, 0xaa4b, 1},
		{0xaa60, 0xaa6f, 1},
		{0xaa71, 0xaa76, 1},
		{0xaa7a, 0xaa80, 6},
		{0xaa81, 0xaaaf, 1},
		{0xaab1, 0xaab5, 4},
		{0xaab6, 0xaab9, 3},
		{0xaaba, 0xaabd, 1},
		{0xaac0, 0xaac2, 2},
		{0xaadb, 0xaadc, 1},
		{0xab01, 0xab06, 1},
		{0xab09, 0xab0e, 1},
		{0xab11, 0xab16, 1},
		{0xab20, 0xab26, 1},
		{0xab28, 0xab2e, 1},
		{0xabc0, 0xabe2, 1},
		{0xac00, 0xd7a3, 1},
		{0xd7b0, 0xd7c6, 1},
		{0xd7cb, 0xd7fb, 1},
		{0xf900, 0xfa2d, 1},
		{0xfa30, 0xfa6d, 1},
		{0xfa70, 0xfad9, 1},
		{0xfb1d, 0xfb1f, 2},
		{0xfb20, 0xfb28, 1},
		{0xfb2a, 0xfb36, 1},
		{0xfb38, 0xfb3c, 1},
		{0xfb3e, 0xfb40, 2},
		{0xfb41, 0xfb43, 2},
		{0xfb44, 0xfb46, 2},
		{0xfb47, 0xfbb1, 1},
		{0xfbd3, 0xfd3d, 1},
		{0xfd50, 0xfd8f, 1},
		{0xfd92, 0xfdc7, 1},
		{0xfdf0, 0xfdfb, 1},
		{0xfe70, 0xfe74, 1},
		{0xfe76, 0xfefc, 1},
		{0xff66, 0xff6f, 1},
		{0xff71, 0xff9d, 1},
		{0xffa0, 0xffbe, 1},
		{0xffc2, 0xffc7, 1},
		{0xffca, 0xffcf, 1},
		{0xffd2, 0xffd7, 1},
		{0xffda, 0xffdc, 1},
	},
	R32: []Range32{
		{0x10000, 0x1000b, 1},
		{0x1000d, 0x10026, 1},
		{0x10028, 0x1003a, 1},
		{0x1003c, 0x1003d, 1},
		{0x1003f, 0x1004d, 1},
		{0x10050, 0x1005d, 1},
		{0x10080, 0x100fa, 1},
		{0x10280, 0x1029c, 1},
		{0x102a0, 0x102d0, 1},
		{0x10300, 0x1031e, 1},
		{0x10330, 0x10340, 1},
		{0x10342, 0x10349, 1},
		{0x10380, 0x1039d, 1},
		{0x103a0, 0x103c3, 1},
		{0x103c8, 0x103cf, 1},
		{0x10450, 0x1049d, 1},
		{0x10800, 0x10805, 1},
		{0x10808, 0x1080a, 2},
		{0x1080b, 0x10835, 1},
		{0x10837, 0x10838, 1},
		{0x1083c, 0x1083f, 3},
		{0x10840, 0x10855, 1},
		{0x10900, 0x10915, 1},
		{0x10920, 0x10939, 1},
		{0x10a00, 0x10a10, 16},
		{0x10a11, 0x10a13, 1},
		{0x10a15, 0x10a17, 1},
		{0x10a19, 0x10a33, 1},
		{0x10a60, 0x10a7c, 1},
		{0x10b00, 0x10b35, 1},
		{0x10b40, 0x10b55, 1},
		{0x10b60, 0x10b72, 1},
		{0x10c00, 0x10c48, 1},
		{0x11003, 0x11037, 1},
		{0x11083, 0x110af, 1},
		{0x12000, 0x1236e, 1},
		{0x13000, 0x1342e, 1},
		{0x16800, 0x16a38, 1},
		{0x1b000, 0x1b001, 1},
		{0x20000, 0x2a6d6, 1},
		{0x2a700, 0x2b734, 1},
		{0x2b740, 0x2b81d, 1},
		{0x2f800, 0x2fa1d, 1},
	},
}

var (
	Cc     = _Cc // Cc is the set of Unicode characters in category Cc.
	Cf     = _Cf // Cf is the set of Unicode characters in category Cf.
	Co     = _Co // Co is the set of Unicode characters in category Co.
	Cs     = _Cs // Cs is the set of Unicode characters in category Cs.
	Digit  = _Nd // Digit is the set of Unicode characters with the "decimal digit" property.
	Nd     = _Nd // Nd is the set of Unicode characters in category Nd.
	Letter = _L  // Letter/L is the set of Unicode letters, category L.
	L      = _L
	Lm     = _Lm // Lm is the set of Unicode characters in category Lm.
	Lo     = _Lo // Lo is the set of Unicode characters in category Lo.
	Lower  = _Ll // Lower is the set of Unicode lower case letters.
	Ll     = _Ll // Ll is the set of Unicode characters in category Ll.
	Mark   = _M  // Mark/M is the set of Unicode mark characters, category  M.
	M      = _M
	Mc     = _Mc // Mc is the set of Unicode characters in category Mc.
	Me     = _Me // Me is the set of Unicode characters in category Me.
	Mn     = _Mn // Mn is the set of Unicode characters in category Mn.
	Nl     = _Nl // Nl is the set of Unicode characters in category Nl.
	No     = _No // No is the set of Unicode characters in category No.
	Number = _N  // Number/N is the set of Unicode number characters, category N.
	N      = _N
	Other  = _C // Other/C is the set of Unicode control and special characters, category C.
	C      = _C
	Pc     = _Pc // Pc is the set of Unicode characters in category Pc.
	Pd     = _Pd // Pd is the set of Unicode characters in category Pd.
	Pe     = _Pe // Pe is the set of Unicode characters in category Pe.
	Pf     = _Pf // Pf is the set of Unicode characters in category Pf.
	Pi     = _Pi // Pi is the set of Unicode characters in category Pi.
	Po     = _Po // Po is the set of Unicode characters in category Po.
	Ps     = _Ps // Ps is the set of Unicode characters in category Ps.
	Punct  = _P  // Punct/P is the set of Unicode punctuation characters, category P.
	P      = _P
	Sc     = _Sc // Sc is the set of Unicode characters in category Sc.
	Sk     = _Sk // Sk is the set of Unicode characters in category Sk.
	Sm     = _Sm // Sm is the set of Unicode characters in category Sm.
	So     = _So // So is the set of Unicode characters in category So.
	Space  = _Z  // Space/Z is the set of Unicode space characters, category Z.
	Z      = _Z
	Symbol = _S // Symbol/S is the set of Unicode symbol characters, category S.
	S      = _S
	Title  = _Lt // Title is the set of Unicode title case letters.
	Lt     = _Lt // Lt is the set of Unicode characters in category Lt.
	Upper  = _Lu // Upper is the set of Unicode upper case letters.
	Lu     = _Lu // Lu is the set of Unicode characters in category Lu.
	Zl     = _Zl // Zl is the set of Unicode characters in category Zl.
	Zp     = _Zp // Zp is the set of Unicode characters in category Zp.
	Zs     = _Zs // Zs is the set of Unicode characters in category Zs.
)

// Generated by running
//	maketables --scripts=all --url=http://www.unicode.org/Public/6.0.0/ucd/
// DO NOT EDIT

// Scripts is the set of Unicode script tables.
var Scripts = map[string]*RangeTable{
	"Katakana":               Katakana,
	"Malayalam":              Malayalam,
	"Phags_Pa":               Phags_Pa,
	"Inscriptional_Parthian": Inscriptional_Parthian,
	"Latin":                  Latin,
	"Inscriptional_Pahlavi":  Inscriptional_Pahlavi,
	"Osmanya":                Osmanya,
	"Khmer":                  Khmer,
	"Inherited":              Inherited,
	"Telugu":                 Telugu,
	"Samaritan":              Samaritan,
	"Bopomofo":               Bopomofo,
	"Imperial_Aramaic":       Imperial_Aramaic,
	"Kaithi":                 Kaithi,
	"Mandaic":                Mandaic,
	"Old_South_Arabian":      Old_South_Arabian,
	"Kayah_Li":               Kayah_Li,
	"New_Tai_Lue":            New_Tai_Lue,
	"Tai_Le":                 Tai_Le,
	"Kharoshthi":             Kharoshthi,
	"Common":                 Common,
	"Kannada":                Kannada,
	"Old_Turkic":             Old_Turkic,
	"Tamil":                  Tamil,
	"Tagalog":                Tagalog,
	"Brahmi":                 Brahmi,
	"Arabic":                 Arabic,
	"Tagbanwa":               Tagbanwa,
	"Canadian_Aboriginal":    Canadian_Aboriginal,
	"Tibetan":                Tibetan,
	"Coptic":                 Coptic,
	"Hiragana":               Hiragana,
	"Limbu":                  Limbu,
	"Egyptian_Hieroglyphs":   Egyptian_Hieroglyphs,
	"Avestan":                Avestan,
	"Myanmar":                Myanmar,
	"Armenian":               Armenian,
	"Sinhala":                Sinhala,
	"Bengali":                Bengali,
	"Greek":                  Greek,
	"Cham":                   Cham,
	"Hebrew":                 Hebrew,
	"Meetei_Mayek":           Meetei_Mayek,
	"Saurashtra":             Saurashtra,
	"Hangul":                 Hangul,
	"Runic":                  Runic,
	"Deseret":                Deseret,
	"Lisu":                   Lisu,
	"Sundanese":              Sundanese,
	"Glagolitic":             Glagolitic,
	"Oriya":                  Oriya,
	"Buhid":                  Buhid,
	"Ethiopic":               Ethiopic,
	"Javanese":               Javanese,
	"Syloti_Nagri":           Syloti_Nagri,
	"Vai":                    Vai,
	"Cherokee":               Cherokee,
	"Ogham":                  Ogham,
	"Batak":                  Batak,
	"Syriac":                 Syriac,
	"Gurmukhi":               Gurmukhi,
	"Tai_Tham":               Tai_Tham,
	"Ol_Chiki":               Ol_Chiki,
	"Mongolian":              Mongolian,
	"Hanunoo":                Hanunoo,
	"Cypriot":                Cypriot,
	"Buginese":               Buginese,
	"Bamum":                  Bamum,
	"Lepcha":                 Lepcha,
	"Thaana":                 Thaana,
	"Old_Persian":            Old_Persian,
	"Cuneiform":              Cuneiform,
	"Rejang":                 Rejang,
	"Georgian":               Georgian,
	"Shavian":                Shavian,
	"Lycian":                 Lycian,
	"Nko":                    Nko,
	"Yi":                     Yi,
	"Lao":                    Lao,
	"Linear_B":               Linear_B,
	"Old_Italic":             Old_Italic,
	"Tai_Viet":               Tai_Viet,
	"Devanagari":             Devanagari,
	"Lydian":                 Lydian,
	"Tifinagh":               Tifinagh,
	"Ugaritic":               Ugaritic,
	"Thai":                   Thai,
	"Cyrillic":               Cyrillic,
	"Gujarati":               Gujarati,
	"Carian":                 Carian,
	"Phoenician":             Phoenician,
	"Balinese":               Balinese,
	"Braille":                Braille,
	"Han":                    Han,
	"Gothic":                 Gothic,
}

var _Katakana = &RangeTable{
	R16: []Range16{
		{0x30a1, 0x30fa, 1},
		{0x30fd, 0x30ff, 1},
		{0x31f0, 0x31ff, 1},
		{0x32d0, 0x32fe, 1},
		{0x3300, 0x3357, 1},
		{0xff66, 0xff6f, 1},
		{0xff71, 0xff9d, 1},
	},
	R32: []Range32{
		{0x1b000, 0x1b000, 1},
	},
}

var _Malayalam = &RangeTable{
	R16: []Range16{
		{0x0d02, 0x0d03, 1},
		{0x0d05, 0x0d0c, 1},
		{0x0d0e, 0x0d10, 1},
		{0x0d12, 0x0d3a, 1},
		{0x0d3d, 0x0d44, 1},
		{0x0d46, 0x0d48, 1},
		{0x0d4a, 0x0d4e, 1},
		{0x0d57, 0x0d57, 1},
		{0x0d60, 0x0d63, 1},
		{0x0d66, 0x0d75, 1},
		{0x0d79, 0x0d7f, 1},
	},
}

var _Phags_Pa = &RangeTable{
	R16: []Range16{
		{0xa840, 0xa877, 1},
	},
}

var _Inscriptional_Parthian = &RangeTable{
	R16: []Range16{},
	R32: []Range32{
		{0x10b40, 0x10b55, 1},
		{0x10b58, 0x10b5f, 1},
	},
}

var _Latin = &RangeTable{
	R16: []Range16{
		{0x0041, 0x005a, 1},
		{0x0061, 0x007a, 1},
		{0x00aa, 0x00aa, 1},
		{0x00ba, 0x00ba, 1},
		{0x00c0, 0x00d6, 1},
		{0x00d8, 0x00f6, 1},
		{0x00f8, 0x02b8, 1},
		{0x02e0, 0x02e4, 1},
		{0x1d00, 0x1d25, 1},
		{0x1d2c, 0x1d5c, 1},
		{0x1d62, 0x1d65, 1},
		{0x1d6b, 0x1d77, 1},
		{0x1d79, 0x1dbe, 1},
		{0x1e00, 0x1eff, 1},
		{0x2071, 0x2071, 1},
		{0x207f, 0x207f, 1},
		{0x2090, 0x209c, 1},
		{0x212a, 0x212b, 1},
		{0x2132, 0x2132, 1},
		{0x214e, 0x214e, 1},
		{0x2160, 0x2188, 1},
		{0x2c60, 0x2c7f, 1},
		{0xa722, 0xa787, 1},
		{0xa78b, 0xa78e, 1},
		{0xa790, 0xa791, 1},
		{0xa7a0, 0xa7a9, 1},
		{0xa7fa, 0xa7ff, 1},
		{0xfb00, 0xfb06, 1},
		{0xff21, 0xff3a, 1},
		{0xff41, 0xff5a, 1},
	},
}

var _Inscriptional_Pahlavi = &RangeTable{
	R16: []Range16{},
	R32: []Range32{
		{0x10b60, 0x10b72, 1},
		{0x10b78, 0x10b7f, 1},
	},
}

var _Osmanya = &RangeTable{
	R16: []Range16{},
	R32: []Range32{
		{0x10480, 0x1049d, 1},
		{0x104a0, 0x104a9, 1},
	},
}

var _Khmer = &RangeTable{
	R16: []Range16{
		{0x1780, 0x17dd, 1},
		{0x17e0, 0x17e9, 1},
		{0x17f0, 0x17f9, 1},
		{0x19e0, 0x19ff, 1},
	},
}

var _Inherited = &RangeTable{
	R16: []Range16{
		{0x0300, 0x036f, 1},
		{0x0485, 0x0486, 1},
		{0x064b, 0x0655, 1},
		{0x065f, 0x065f, 1},
		{0x0670, 0x0670, 1},
		{0x0951, 0x0952, 1},
		{0x1cd0, 0x1cd2, 1},
		{0x1cd4, 0x1ce0, 1},
		{0x1ce2, 0x1ce8, 1},
		{0x1ced, 0x1ced, 1},
		{0x1dc0, 0x1de6, 1},
		{0x1dfc, 0x1dff, 1},
		{0x200c, 0x200d, 1},
		{0x20d0, 0x20f0, 1},
		{0x302a, 0x302d, 1},
		{0x3099, 0x309a, 1},
		{0xfe00, 0xfe0f, 1},
		{0xfe20, 0xfe26, 1},
	},
	R32: []Range32{
		{0x101fd, 0x101fd, 1},
		{0x1d167, 0x1d169, 1},
		{0x1d17b, 0x1d182, 1},
		{0x1d185, 0x1d18b, 1},
		{0x1d1aa, 0x1d1ad, 1},
		{0xe0100, 0xe01ef, 1},
	},
}

var _Telugu = &RangeTable{
	R16: []Range16{
		{0x0c01, 0x0c03, 1},
		{0x0c05, 0x0c0c, 1},
		{0x0c0e, 0x0c10, 1},
		{0x0c12, 0x0c28, 1},
		{0x0c2a, 0x0c33, 1},
		{0x0c35, 0x0c39, 1},
		{0x0c3d, 0x0c44, 1},
		{0x0c46, 0x0c48, 1},
		{0x0c4a, 0x0c4d, 1},
		{0x0c55, 0x0c56, 1},
		{0x0c58, 0x0c59, 1},
		{0x0c60, 0x0c63, 1},
		{0x0c66, 0x0c6f, 1},
		{0x0c78, 0x0c7f, 1},
	},
}

var _Samaritan = &RangeTable{
	R16: []Range16{
		{0x0800, 0x082d, 1},
		{0x0830, 0x083e, 1},
	},
}

var _Bopomofo = &RangeTable{
	R16: []Range16{
		{0x02ea, 0x02eb, 1},
		{0x3105, 0x312d, 1},
		{0x31a0, 0x31ba, 1},
	},
}

var _Imperial_Aramaic = &RangeTable{
	R16: []Range16{},
	R32: []Range32{
		{0x10840, 0x10855, 1},
		{0x10857, 0x1085f, 1},
	},
}

var _Kaithi = &RangeTable{
	R16: []Range16{},
	R32: []Range32{
		{0x11080, 0x110c1, 1},
	},
}

var _Mandaic = &RangeTable{
	R16: []Range16{
		{0x0840, 0x085b, 1},
		{0x085e, 0x085e, 1},
	},
}

var _Old_South_Arabian = &RangeTable{
	R16: []Range16{},
	R32: []Range32{
		{0x10a60, 0x10a7f, 1},
	},
}

var _Kayah_Li = &RangeTable{
	R16: []Range16{
		{0xa900, 0xa92f, 1},
	},
}

var _New_Tai_Lue = &RangeTable{
	R16: []Range16{
		{0x1980, 0x19ab, 1},
		{0x19b0, 0x19c9, 1},
		{0x19d0, 0x19da, 1},
		{0x19de, 0x19df, 1},
	},
}

var _Tai_Le = &RangeTable{
	R16: []Range16{
		{0x1950, 0x196d, 1},
		{0x1970, 0x1974, 1},
	},
}

var _Kharoshthi = &RangeTable{
	R16: []Range16{},
	R32: []Range32{
		{0x10a00, 0x10a03, 1},
		{0x10a05, 0x10a06, 1},
		{0x10a0c, 0x10a13, 1},
		{0x10a15, 0x10a17, 1},
		{0x10a19, 0x10a33, 1},
		{0x10a38, 0x10a3a, 1},
		{0x10a3f, 0x10a47, 1},
		{0x10a50, 0x10a58, 1},
	},
}

var _Common = &RangeTable{
	R16: []Range16{
		{0x0000, 0x0040, 1},
		{0x005b, 0x0060, 1},
		{0x007b, 0x00a9, 1},
		{0x00ab, 0x00b9, 1},
		{0x00bb, 0x00bf, 1},
		{0x00d7, 0x00d7, 1},
		{0x00f7, 0x00f7, 1},
		{0x02b9, 0x02df, 1},
		{0x02e5, 0x02e9, 1},
		{0x02ec, 0x02ff, 1},
		{0x0374, 0x0374, 1},
		{0x037e, 0x037e, 1},
		{0x0385, 0x0385, 1},
		{0x0387, 0x0387, 1},
		{0x0589, 0x0589, 1},
		{0x060c, 0x060c, 1},
		{0x061b, 0x061b, 1},
		{0x061f, 0x061f, 1},
		{0x0640, 0x0640, 1},
		{0x0660, 0x0669, 1},
		{0x06dd, 0x06dd, 1},
		{0x0964, 0x0965, 1},
		{0x0970, 0x0970, 1},
		{0x0e3f, 0x0e3f, 1},
		{0x0fd5, 0x0fd8, 1},
		{0x10fb, 0x10fb, 1},
		{0x16eb, 0x16ed, 1},
		{0x1735, 0x1736, 1},
		{0x1802, 0x1803, 1},
		{0x1805, 0x1805, 1},
		{0x1cd3, 0x1cd3, 1},
		{0x1ce1, 0x1ce1, 1},
		{0x1ce9, 0x1cec, 1},
		{0x1cee, 0x1cf2, 1},
		{0x2000, 0x200b, 1},
		{0x200e, 0x2064, 1},
		{0x206a, 0x2070, 1},
		{0x2074, 0x207e, 1},
		{0x2080, 0x208e, 1},
		{0x20a0, 0x20b9, 1},
		{0x2100, 0x2125, 1},
		{0x2127, 0x2129, 1},
		{0x212c, 0x2131, 1},
		{0x2133, 0x214d, 1},
		{0x214f, 0x215f, 1},
		{0x2189, 0x2189, 1},
		{0x2190, 0x23f3, 1},
		{0x2400, 0x2426, 1},
		{0x2440, 0x244a, 1},
		{0x2460, 0x26ff, 1},
		{0x2701, 0x27ca, 1},
		{0x27cc, 0x27cc, 1},
		{0x27ce, 0x27ff, 1},
		{0x2900, 0x2b4c, 1},
		{0x2b50, 0x2b59, 1},
		{0x2e00, 0x2e31, 1},
		{0x2ff0, 0x2ffb, 1},
		{0x3000, 0x3004, 1},
		{0x3006, 0x3006, 1},
		{0x3008, 0x3020, 1},
		{0x3030, 0x3037, 1},
		{0x303c, 0x303f, 1},
		{0x309b, 0x309c, 1},
		{0x30a0, 0x30a0, 1},
		{0x30fb, 0x30fc, 1},
		{0x3190, 0x319f, 1},
		{0x31c0, 0x31e3, 1},
		{0x3220, 0x325f, 1},
		{0x327f, 0x32cf, 1},
		{0x3358, 0x33ff, 1},
		{0x4dc0, 0x4dff, 1},
		{0xa700, 0xa721, 1},
		{0xa788, 0xa78a, 1},
		{0xa830, 0xa839, 1},
		{0xfd3e, 0xfd3f, 1},
		{0xfdfd, 0xfdfd, 1},
		{0xfe10, 0xfe19, 1},
		{0xfe30, 0xfe52, 1},
		{0xfe54, 0xfe66, 1},
		{0xfe68, 0xfe6b, 1},
		{0xfeff, 0xfeff, 1},
		{0xff01, 0xff20, 1},
		{0xff3b, 0xff40, 1},
		{0xff5b, 0xff65, 1},
		{0xff70, 0xff70, 1},
		{0xff9e, 0xff9f, 1},
		{0xffe0, 0xffe6, 1},
		{0xffe8, 0xffee, 1},
		{0xfff9, 0xfffd, 1},
	},
	R32: []Range32{
		{0x10100, 0x10102, 1},
		{0x10107, 0x10133, 1},
		{0x10137, 0x1013f, 1},
		{0x10190, 0x1019b, 1},
		{0x101d0, 0x101fc, 1},
		{0x1d000, 0x1d0f5, 1},
		{0x1d100, 0x1d126, 1},
		{0x1d129, 0x1d166, 1},
		{0x1d16a, 0x1d17a, 1},
		{0x1d183, 0x1d184, 1},
		{0x1d18c, 0x1d1a9, 1},
		{0x1d1ae, 0x1d1dd, 1},
		{0x1d300, 0x1d356, 1},
		{0x1d360, 0x1d371, 1},
		{0x1d400, 0x1d454, 1},
		{0x1d456, 0x1d49c, 1},
		{0x1d49e, 0x1d49f, 1},
		{0x1d4a2, 0x1d4a2, 1},
		{0x1d4a5, 0x1d4a6, 1},
		{0x1d4a9, 0x1d4ac, 1},
		{0x1d4ae, 0x1d4b9, 1},
		{0x1d4bb, 0x1d4bb, 1},
		{0x1d4bd, 0x1d4c3, 1},
		{0x1d4c5, 0x1d505, 1},
		{0x1d507, 0x1d50a, 1},
		{0x1d50d, 0x1d514, 1},
		{0x1d516, 0x1d51c, 1},
		{0x1d51e, 0x1d539, 1},
		{0x1d53b, 0x1d53e, 1},
		{0x1d540, 0x1d544, 1},
		{0x1d546, 0x1d546, 1},
		{0x1d54a, 0x1d550, 1},
		{0x1d552, 0x1d6a5, 1},
		{0x1d6a8, 0x1d7cb, 1},
		{0x1d7ce, 0x1d7ff, 1},
		{0x1f000, 0x1f02b, 1},
		{0x1f030, 0x1f093, 1},
		{0x1f0a0, 0x1f0ae, 1},
		{0x1f0b1, 0x1f0be, 1},
		{0x1f0c1, 0x1f0cf, 1},
		{0x1f0d1, 0x1f0df, 1},
		{0x1f100, 0x1f10a, 1},
		{0x1f110, 0x1f12e, 1},
		{0x1f130, 0x1f169, 1},
		{0x1f170, 0x1f19a, 1},
		{0x1f1e6, 0x1f1ff, 1},
		{0x1f201, 0x1f202, 1},
		{0x1f210, 0x1f23a, 1},
		{0x1f240, 0x1f248, 1},
		{0x1f250, 0x1f251, 1},
		{0x1f300, 0x1f320, 1},
		{0x1f330, 0x1f335, 1},
		{0x1f337, 0x1f37c, 1},
		{0x1f380, 0x1f393, 1},
		{0x1f3a0, 0x1f3c4, 1},
		{0x1f3c6, 0x1f3ca, 1},
		{0x1f3e0, 0x1f3f0, 1},
		{0x1f400, 0x1f43e, 1},
		{0x1f440, 0x1f440, 1},
		{0x1f442, 0x1f4f7, 1},
		{0x1f4f9, 0x1f4fc, 1},
		{0x1f500, 0x1f53d, 1},
		{0x1f550, 0x1f567, 1},
		{0x1f5fb, 0x1f5ff, 1},
		{0x1f601, 0x1f610, 1},
		{0x1f612, 0x1f614, 1},
		{0x1f616, 0x1f616, 1},
		{0x1f618, 0x1f618, 1},
		{0x1f61a, 0x1f61a, 1},
		{0x1f61c, 0x1f61e, 1},
		{0x1f620, 0x1f625, 1},
		{0x1f628, 0x1f62b, 1},
		{0x1f62d, 0x1f62d, 1},
		{0x1f630, 0x1f633, 1},
		{0x1f635, 0x1f640, 1},
		{0x1f645, 0x1f64f, 1},
		{0x1f680, 0x1f6c5, 1},
		{0x1f700, 0x1f773, 1},
		{0xe0001, 0xe0001, 1},
		{0xe0020, 0xe007f, 1},
	},
}

var _Kannada = &RangeTable{
	R16: []Range16{
		{0x0c82, 0x0c83, 1},
		{0x0c85, 0x0c8c, 1},
		{0x0c8e, 0x0c90, 1},
		{0x0c92, 0x0ca8, 1},
		{0x0caa, 0x0cb3, 1},
		{0x0cb5, 0x0cb9, 1},
		{0x0cbc, 0x0cc4, 1},
		{0x0cc6, 0x0cc8, 1},
		{0x0cca, 0x0ccd, 1},
		{0x0cd5, 0x0cd6, 1},
		{0x0cde, 0x0cde, 1},
		{0x0ce0, 0x0ce3, 1},
		{0x0ce6, 0x0cef, 1},
		{0x0cf1, 0x0cf2, 1},
	},
}

var _Old_Turkic = &RangeTable{
	R16: []Range16{},
	R32: []Range32{
		{0x10c00, 0x10c48, 1},
	},
}

var _Tamil = &RangeTable{
	R16: []Range16{
		{0x0b82, 0x0b83, 1},
		{0x0b85, 0x0b8a, 1},
		{0x0b8e, 0x0b90, 1},
		{0x0b92, 0x0b95, 1},
		{0x0b99, 0x0b9a, 1},
		{0x0b9c, 0x0b9c, 1},
		{0x0b9e, 0x0b9f, 1},
		{0x0ba3, 0x0ba4, 1},
		{0x0ba8, 0x0baa, 1},
		{0x0bae, 0x0bb9, 1},
		{0x0bbe, 0x0bc2, 1},
		{0x0bc6, 0x0bc8, 1},
		{0x0bca, 0x0bcd, 1},
		{0x0bd0, 0x0bd0, 1},
		{0x0bd7, 0x0bd7, 1},
		{0x0be6, 0x0bfa, 1},
	},
}

var _Tagalog = &RangeTable{
	R16: []Range16{
		{0x1700, 0x170c, 1},
		{0x170e, 0x1714, 1},
	},
}

var _Brahmi = &RangeTable{
	R16: []Range16{},
	R32: []Range32{
		{0x11000, 0x1104d, 1},
		{0x11052, 0x1106f, 1},
	},
}

var _Arabic = &RangeTable{
	R16: []Range16{
		{0x0600, 0x0603, 1},
		{0x0606, 0x060b, 1},
		{0x060d, 0x061a, 1},
		{0x061e, 0x061e, 1},
		{0x0620, 0x063f, 1},
		{0x0641, 0x064a, 1},
		{0x0656, 0x065e, 1},
		{0x066a, 0x066f, 1},
		{0x0671, 0x06dc, 1},
		{0x06de, 0x06ff, 1},
		{0x0750, 0x077f, 1},
		{0xfb50, 0xfbc1, 1},
		{0xfbd3, 0xfd3d, 1},
		{0xfd50, 0xfd8f, 1},
		{0xfd92, 0xfdc7, 1},
		{0xfdf0, 0xfdfc, 1},
		{0xfe70, 0xfe74, 1},
		{0xfe76, 0xfefc, 1},
	},
	R32: []Range32{
		{0x10e60, 0x10e7e, 1},
	},
}

var _Tagbanwa = &RangeTable{
	R16: []Range16{
		{0x1760, 0x176c, 1},
		{0x176e, 0x1770, 1},
		{0x1772, 0x1773, 1},
	},
}

var _Canadian_Aboriginal = &RangeTable{
	R16: []Range16{
		{0x1400, 0x167f, 1},
		{0x18b0, 0x18f5, 1},
	},
}

var _Tibetan = &RangeTable{
	R16: []Range16{
		{0x0f00, 0x0f47, 1},
		{0x0f49, 0x0f6c, 1},
		{0x0f71, 0x0f97, 1},
		{0x0f99, 0x0fbc, 1},
		{0x0fbe, 0x0fcc, 1},
		{0x0fce, 0x0fd4, 1},
		{0x0fd9, 0x0fda, 1},
	},
}

var _Coptic = &RangeTable{
	R16: []Range16{
		{0x03e2, 0x03ef, 1},
		{0x2c80, 0x2cf1, 1},
		{0x2cf9, 0x2cff, 1},
	},
}

var _Hiragana = &RangeTable{
	R16: []Range16{
		{0x3041, 0x3096, 1},
		{0x309d, 0x309f, 1},
	},
	R32: []Range32{
		{0x1b001, 0x1b001, 1},
		{0x1f200, 0x1f200, 1},
	},
}

var _Limbu = &RangeTable{
	R16: []Range16{
		{0x1900, 0x191c, 1},
		{0x1920, 0x192b, 1},
		{0x1930, 0x193b, 1},
		{0x1940, 0x1940, 1},
		{0x1944, 0x194f, 1},
	},
}

var _Egyptian_Hieroglyphs = &RangeTable{
	R16: []Range16{},
	R32: []Range32{
		{0x13000, 0x1342e, 1},
	},
}

var _Avestan = &RangeTable{
	R16: []Range16{},
	R32: []Range32{
		{0x10b00, 0x10b35, 1},
		{0x10b39, 0x10b3f, 1},
	},
}

var _Myanmar = &RangeTable{
	R16: []Range16{
		{0x1000, 0x109f, 1},
		{0xaa60, 0xaa7b, 1},
	},
}

var _Armenian = &RangeTable{
	R16: []Range16{
		{0x0531, 0x0556, 1},
		{0x0559, 0x055f, 1},
		{0x0561, 0x0587, 1},
		{0x058a, 0x058a, 1},
		{0xfb13, 0xfb17, 1},
	},
}

var _Sinhala = &RangeTable{
	R16: []Range16{
		{0x0d82, 0x0d83, 1},
		{0x0d85, 0x0d96, 1},
		{0x0d9a, 0x0db1, 1},
		{0x0db3, 0x0dbb, 1},
		{0x0dbd, 0x0dbd, 1},
		{0x0dc0, 0x0dc6, 1},
		{0x0dca, 0x0dca, 1},
		{0x0dcf, 0x0dd4, 1},
		{0x0dd6, 0x0dd6, 1},
		{0x0dd8, 0x0ddf, 1},
		{0x0df2, 0x0df4, 1},
	},
}

var _Bengali = &RangeTable{
	R16: []Range16{
		{0x0981, 0x0983, 1},
		{0x0985, 0x098c, 1},
		{0x098f, 0x0990, 1},
		{0x0993, 0x09a8, 1},
		{0x09aa, 0x09b0, 1},
		{0x09b2, 0x09b2, 1},
		{0x09b6, 0x09b9, 1},
		{0x09bc, 0x09c4, 1},
		{0x09c7, 0x09c8, 1},
		{0x09cb, 0x09ce, 1},
		{0x09d7, 0x09d7, 1},
		{0x09dc, 0x09dd, 1},
		{0x09df, 0x09e3, 1},
		{0x09e6, 0x09fb, 1},
	},
}

var _Greek = &RangeTable{
	R16: []Range16{
		{0x0370, 0x0373, 1},
		{0x0375, 0x0377, 1},
		{0x037a, 0x037d, 1},
		{0x0384, 0x0384, 1},
		{0x0386, 0x0386, 1},
		{0x0388, 0x038a, 1},
		{0x038c, 0x038c, 1},
		{0x038e, 0x03a1, 1},
		{0x03a3, 0x03e1, 1},
		{0x03f0, 0x03ff, 1},
		{0x1d26, 0x1d2a, 1},
		{0x1d5d, 0x1d61, 1},
		{0x1d66, 0x1d6a, 1},
		{0x1dbf, 0x1dbf, 1},
		{0x1f00, 0x1f15, 1},
		{0x1f18, 0x1f1d, 1},
		{0x1f20, 0x1f45, 1},
		{0x1f48, 0x1f4d, 1},
		{0x1f50, 0x1f57, 1},
		{0x1f59, 0x1f59, 1},
		{0x1f5b, 0x1f5b, 1},
		{0x1f5d, 0x1f5d, 1},
		{0x1f5f, 0x1f7d, 1},
		{0x1f80, 0x1fb4, 1},
		{0x1fb6, 0x1fc4, 1},
		{0x1fc6, 0x1fd3, 1},
		{0x1fd6, 0x1fdb, 1},
		{0x1fdd, 0x1fef, 1},
		{0x1ff2, 0x1ff4, 1},
		{0x1ff6, 0x1ffe, 1},
		{0x2126, 0x2126, 1},
	},
	R32: []Range32{
		{0x10140, 0x1018a, 1},
		{0x1d200, 0x1d245, 1},
	},
}

var _Cham = &RangeTable{
	R16: []Range16{
		{0xaa00, 0xaa36, 1},
		{0xaa40, 0xaa4d, 1},
		{0xaa50, 0xaa59, 1},
		{0xaa5c, 0xaa5f, 1},
	},
}

var _Hebrew = &RangeTable{
	R16: []Range16{
		{0x0591, 0x05c7, 1},
		{0x05d0, 0x05ea, 1},
		{0x05f0, 0x05f4, 1},
		{0xfb1d, 0xfb36, 1},
		{0xfb38, 0xfb3c, 1},
		{0xfb3e, 0xfb3e, 1},
		{0xfb40, 0xfb41, 1},
		{0xfb43, 0xfb44, 1},
		{0xfb46, 0xfb4f, 1},
	},
}

var _Meetei_Mayek = &RangeTable{
	R16: []Range16{
		{0xabc0, 0xabed, 1},
		{0xabf0, 0xabf9, 1},
	},
}

var _Saurashtra = &RangeTable{
	R16: []Range16{
		{0xa880, 0xa8c4, 1},
		{0xa8ce, 0xa8d9, 1},
	},
}

var _Hangul = &RangeTable{
	R16: []Range16{
		{0x1100, 0x11ff, 1},
		{0x302e, 0x302f, 1},
		{0x3131, 0x318e, 1},
		{0x3200, 0x321e, 1},
		{0x3260, 0x327e, 1},
		{0xa960, 0xa97c, 1},
		{0xac00, 0xd7a3, 1},
		{0xd7b0, 0xd7c6, 1},
		{0xd7cb, 0xd7fb, 1},
		{0xffa0, 0xffbe, 1},
		{0xffc2, 0xffc7, 1},
		{0xffca, 0xffcf, 1},
		{0xffd2, 0xffd7, 1},
		{0xffda, 0xffdc, 1},
	},
}

var _Runic = &RangeTable{
	R16: []Range16{
		{0x16a0, 0x16ea, 1},
		{0x16ee, 0x16f0, 1},
	},
}

var _Deseret = &RangeTable{
	R16: []Range16{},
	R32: []Range32{
		{0x10400, 0x1044f, 1},
	},
}

var _Lisu = &RangeTable{
	R16: []Range16{
		{0xa4d0, 0xa4ff, 1},
	},
}

var _Sundanese = &RangeTable{
	R16: []Range16{
		{0x1b80, 0x1baa, 1},
		{0x1bae, 0x1bb9, 1},
	},
}

var _Glagolitic = &RangeTable{
	R16: []Range16{
		{0x2c00, 0x2c2e, 1},
		{0x2c30, 0x2c5e, 1},
	},
}

var _Oriya = &RangeTable{
	R16: []Range16{
		{0x0b01, 0x0b03, 1},
		{0x0b05, 0x0b0c, 1},
		{0x0b0f, 0x0b10, 1},
		{0x0b13, 0x0b28, 1},
		{0x0b2a, 0x0b30, 1},
		{0x0b32, 0x0b33, 1},
		{0x0b35, 0x0b39, 1},
		{0x0b3c, 0x0b44, 1},
		{0x0b47, 0x0b48, 1},
		{0x0b4b, 0x0b4d, 1},
		{0x0b56, 0x0b57, 1},
		{0x0b5c, 0x0b5d, 1},
		{0x0b5f, 0x0b63, 1},
		{0x0b66, 0x0b77, 1},
	},
}

var _Buhid = &RangeTable{
	R16: []Range16{
		{0x1740, 0x1753, 1},
	},
}

var _Ethiopic = &RangeTable{
	R16: []Range16{
		{0x1200, 0x1248, 1},
		{0x124a, 0x124d, 1},
		{0x1250, 0x1256, 1},
		{0x1258, 0x1258, 1},
		{0x125a, 0x125d, 1},
		{0x1260, 0x1288, 1},
		{0x128a, 0x128d, 1},
		{0x1290, 0x12b0, 1},
		{0x12b2, 0x12b5, 1},
		{0x12b8, 0x12be, 1},
		{0x12c0, 0x12c0, 1},
		{0x12c2, 0x12c5, 1},
		{0x12c8, 0x12d6, 1},
		{0x12d8, 0x1310, 1},
		{0x1312, 0x1315, 1},
		{0x1318, 0x135a, 1},
		{0x135d, 0x137c, 1},
		{0x1380, 0x1399, 1},
		{0x2d80, 0x2d96, 1},
		{0x2da0, 0x2da6, 1},
		{0x2da8, 0x2dae, 1},
		{0x2db0, 0x2db6, 1},
		{0x2db8, 0x2dbe, 1},
		{0x2dc0, 0x2dc6, 1},
		{0x2dc8, 0x2dce, 1},
		{0x2dd0, 0x2dd6, 1},
		{0x2dd8, 0x2dde, 1},
		{0xab01, 0xab06, 1},
		{0xab09, 0xab0e, 1},
		{0xab11, 0xab16, 1},
		{0xab20, 0xab26, 1},
		{0xab28, 0xab2e, 1},
	},
}

var _Javanese = &RangeTable{
	R16: []Range16{
		{0xa980, 0xa9cd, 1},
		{0xa9cf, 0xa9d9, 1},
		{0xa9de, 0xa9df, 1},
	},
}

var _Syloti_Nagri = &RangeTable{
	R16: []Range16{
		{0xa800, 0xa82b, 1},
	},
}

var _Vai = &RangeTable{
	R16: []Range16{
		{0xa500, 0xa62b, 1},
	},
}

var _Cherokee = &RangeTable{
	R16: []Range16{
		{0x13a0, 0x13f4, 1},
	},
}

var _Ogham = &RangeTable{
	R16: []Range16{
		{0x1680, 0x169c, 1},
	},
}

var _Batak = &RangeTable{
	R16: []Range16{
		{0x1bc0, 0x1bf3, 1},
		{0x1bfc, 0x1bff, 1},
	},
}

var _Syriac = &RangeTable{
	R16: []Range16{
		{0x0700, 0x070d, 1},
		{0x070f, 0x074a, 1},
		{0x074d, 0x074f, 1},
	},
}

var _Gurmukhi = &RangeTable{
	R16: []Range16{
		{0x0a01, 0x0a03, 1},
		{0x0a05, 0x0a0a, 1},
		{0x0a0f, 0x0a10, 1},
		{0x0a13, 0x0a28, 1},
		{0x0a2a, 0x0a30, 1},
		{0x0a32, 0x0a33, 1},
		{0x0a35, 0x0a36, 1},
		{0x0a38, 0x0a39, 1},
		{0x0a3c, 0x0a3c, 1},
		{0x0a3e, 0x0a42, 1},
		{0x0a47, 0x0a48, 1},
		{0x0a4b, 0x0a4d, 1},
		{0x0a51, 0x0a51, 1},
		{0x0a59, 0x0a5c, 1},
		{0x0a5e, 0x0a5e, 1},
		{0x0a66, 0x0a75, 1},
	},
}

var _Tai_Tham = &RangeTable{
	R16: []Range16{
		{0x1a20, 0x1a5e, 1},
		{0x1a60, 0x1a7c, 1},
		{0x1a7f, 0x1a89, 1},
		{0x1a90, 0x1a99, 1},
		{0x1aa0, 0x1aad, 1},
	},
}

var _Ol_Chiki = &RangeTable{
	R16: []Range16{
		{0x1c50, 0x1c7f, 1},
	},
}

var _Mongolian = &RangeTable{
	R16: []Range16{
		{0x1800, 0x1801, 1},
		{0x1804, 0x1804, 1},
		{0x1806, 0x180e, 1},
		{0x1810, 0x1819, 1},
		{0x1820, 0x1877, 1},
		{0x1880, 0x18aa, 1},
	},
}

var _Hanunoo = &RangeTable{
	R16: []Range16{
		{0x1720, 0x1734, 1},
	},
}

var _Cypriot = &RangeTable{
	R16: []Range16{},
	R32: []Range32{
		{0x10800, 0x10805, 1},
		{0x10808, 0x10808, 1},
		{0x1080a, 0x10835, 1},
		{0x10837, 0x10838, 1},
		{0x1083c, 0x1083c, 1},
		{0x1083f, 0x1083f, 1},
	},
}

var _Buginese = &RangeTable{
	R16: []Range16{
		{0x1a00, 0x1a1b, 1},
		{0x1a1e, 0x1a1f, 1},
	},
}

var _Bamum = &RangeTable{
	R16: []Range16{
		{0xa6a0, 0xa6f7, 1},
	},
	R32: []Range32{
		{0x16800, 0x16a38, 1},
	},
}

var _Lepcha = &RangeTable{
	R16: []Range16{
		{0x1c00, 0x1c37, 1},
		{0x1c3b, 0x1c49, 1},
		{0x1c4d, 0x1c4f, 1},
	},
}

var _Thaana = &RangeTable{
	R16: []Range16{
		{0x0780, 0x07b1, 1},
	},
}

var _Old_Persian = &RangeTable{
	R16: []Range16{},
	R32: []Range32{
		{0x103a0, 0x103c3, 1},
		{0x103c8, 0x103d5, 1},
	},
}

var _Cuneiform = &RangeTable{
	R16: []Range16{},
	R32: []Range32{
		{0x12000, 0x1236e, 1},
		{0x12400, 0x12462, 1},
		{0x12470, 0x12473, 1},
	},
}

var _Rejang = &RangeTable{
	R16: []Range16{
		{0xa930, 0xa953, 1},
		{0xa95f, 0xa95f, 1},
	},
}

var _Georgian = &RangeTable{
	R16: []Range16{
		{0x10a0, 0x10c5, 1},
		{0x10d0, 0x10fa, 1},
		{0x10fc, 0x10fc, 1},
		{0x2d00, 0x2d25, 1},
	},
}

var _Shavian = &RangeTable{
	R16: []Range16{},
	R32: []Range32{
		{0x10450, 0x1047f, 1},
	},
}

var _Lycian = &RangeTable{
	R16: []Range16{},
	R32: []Range32{
		{0x10280, 0x1029c, 1},
	},
}

var _Nko = &RangeTable{
	R16: []Range16{
		{0x07c0, 0x07fa, 1},
	},
}

var _Yi = &RangeTable{
	R16: []Range16{
		{0xa000, 0xa48c, 1},
		{0xa490, 0xa4c6, 1},
	},
}

var _Lao = &RangeTable{
	R16: []Range16{
		{0x0e81, 0x0e82, 1},
		{0x0e84, 0x0e84, 1},
		{0x0e87, 0x0e88, 1},
		{0x0e8a, 0x0e8a, 1},
		{0x0e8d, 0x0e8d, 1},
		{0x0e94, 0x0e97, 1},
		{0x0e99, 0x0e9f, 1},
		{0x0ea1, 0x0ea3, 1},
		{0x0ea5, 0x0ea5, 1},
		{0x0ea7, 0x0ea7, 1},
		{0x0eaa, 0x0eab, 1},
		{0x0ead, 0x0eb9, 1},
		{0x0ebb, 0x0ebd, 1},
		{0x0ec0, 0x0ec4, 1},
		{0x0ec6, 0x0ec6, 1},
		{0x0ec8, 0x0ecd, 1},
		{0x0ed0, 0x0ed9, 1},
		{0x0edc, 0x0edd, 1},
	},
}

var _Linear_B = &RangeTable{
	R16: []Range16{},
	R32: []Range32{
		{0x10000, 0x1000b, 1},
		{0x1000d, 0x10026, 1},
		{0x10028, 0x1003a, 1},
		{0x1003c, 0x1003d, 1},
		{0x1003f, 0x1004d, 1},
		{0x10050, 0x1005d, 1},
		{0x10080, 0x100fa, 1},
	},
}

var _Old_Italic = &RangeTable{
	R16: []Range16{},
	R32: []Range32{
		{0x10300, 0x1031e, 1},
		{0x10320, 0x10323, 1},
	},
}

var _Tai_Viet = &RangeTable{
	R16: []Range16{
		{0xaa80, 0xaac2, 1},
		{0xaadb, 0xaadf, 1},
	},
}

var _Devanagari = &RangeTable{
	R16: []Range16{
		{0x0900, 0x0950, 1},
		{0x0953, 0x0963, 1},
		{0x0966, 0x096f, 1},
		{0x0971, 0x0977, 1},
		{0x0979, 0x097f, 1},
		{0xa8e0, 0xa8fb, 1},
	},
}

var _Lydian = &RangeTable{
	R16: []Range16{},
	R32: []Range32{
		{0x10920, 0x10939, 1},
		{0x1093f, 0x1093f, 1},
	},
}

var _Tifinagh = &RangeTable{
	R16: []Range16{
		{0x2d30, 0x2d65, 1},
		{0x2d6f, 0x2d70, 1},
		{0x2d7f, 0x2d7f, 1},
	},
}

var _Ugaritic = &RangeTable{
	R16: []Range16{},
	R32: []Range32{
		{0x10380, 0x1039d, 1},
		{0x1039f, 0x1039f, 1},
	},
}

var _Thai = &RangeTable{
	R16: []Range16{
		{0x0e01, 0x0e3a, 1},
		{0x0e40, 0x0e5b, 1},
	},
}

var _Cyrillic = &RangeTable{
	R16: []Range16{
		{0x0400, 0x0484, 1},
		{0x0487, 0x0527, 1},
		{0x1d2b, 0x1d2b, 1},
		{0x1d78, 0x1d78, 1},
		{0x2de0, 0x2dff, 1},
		{0xa640, 0xa673, 1},
		{0xa67c, 0xa697, 1},
	},
}

var _Gujarati = &RangeTable{
	R16: []Range16{
		{0x0a81, 0x0a83, 1},
		{0x0a85, 0x0a8d, 1},
		{0x0a8f, 0x0a91, 1},
		{0x0a93, 0x0aa8, 1},
		{0x0aaa, 0x0ab0, 1},
		{0x0ab2, 0x0ab3, 1},
		{0x0ab5, 0x0ab9, 1},
		{0x0abc, 0x0ac5, 1},
		{0x0ac7, 0x0ac9, 1},
		{0x0acb, 0x0acd, 1},
		{0x0ad0, 0x0ad0, 1},
		{0x0ae0, 0x0ae3, 1},
		{0x0ae6, 0x0aef, 1},
		{0x0af1, 0x0af1, 1},
	},
}

var _Carian = &RangeTable{
	R16: []Range16{},
	R32: []Range32{
		{0x102a0, 0x102d0, 1},
	},
}

var _Phoenician = &RangeTable{
	R16: []Range16{},
	R32: []Range32{
		{0x10900, 0x1091b, 1},
		{0x1091f, 0x1091f, 1},
	},
}

var _Balinese = &RangeTable{
	R16: []Range16{
		{0x1b00, 0x1b4b, 1},
		{0x1b50, 0x1b7c, 1},
	},
}

var _Braille = &RangeTable{
	R16: []Range16{
		{0x2800, 0x28ff, 1},
	},
}

var _Han = &RangeTable{
	R16: []Range16{
		{0x2e80, 0x2e99, 1},
		{0x2e9b, 0x2ef3, 1},
		{0x2f00, 0x2fd5, 1},
		{0x3005, 0x3005, 1},
		{0x3007, 0x3007, 1},
		{0x3021, 0x3029, 1},
		{0x3038, 0x303b, 1},
		{0x3400, 0x4db5, 1},
		{0x4e00, 0x9fcb, 1},
		{0xf900, 0xfa2d, 1},
		{0xfa30, 0xfa6d, 1},
		{0xfa70, 0xfad9, 1},
	},
	R32: []Range32{
		{0x20000, 0x2a6d6, 1},
		{0x2a700, 0x2b734, 1},
		{0x2b740, 0x2b81d, 1},
		{0x2f800, 0x2fa1d, 1},
	},
}

var _Gothic = &RangeTable{
	R16: []Range16{},
	R32: []Range32{
		{0x10330, 0x1034a, 1},
	},
}

var (
	Arabic                 = _Arabic                 // Arabic is the set of Unicode characters in script Arabic.
	Armenian               = _Armenian               // Armenian is the set of Unicode characters in script Armenian.
	Avestan                = _Avestan                // Avestan is the set of Unicode characters in script Avestan.
	Balinese               = _Balinese               // Balinese is the set of Unicode characters in script Balinese.
	Bamum                  = _Bamum                  // Bamum is the set of Unicode characters in script Bamum.
	Batak                  = _Batak                  // Batak is the set of Unicode characters in script Batak.
	Bengali                = _Bengali                // Bengali is the set of Unicode characters in script Bengali.
	Bopomofo               = _Bopomofo               // Bopomofo is the set of Unicode characters in script Bopomofo.
	Brahmi                 = _Brahmi                 // Brahmi is the set of Unicode characters in script Brahmi.
	Braille                = _Braille                // Braille is the set of Unicode characters in script Braille.
	Buginese               = _Buginese               // Buginese is the set of Unicode characters in script Buginese.
	Buhid                  = _Buhid                  // Buhid is the set of Unicode characters in script Buhid.
	Canadian_Aboriginal    = _Canadian_Aboriginal    // Canadian_Aboriginal is the set of Unicode characters in script Canadian_Aboriginal.
	Carian                 = _Carian                 // Carian is the set of Unicode characters in script Carian.
	Cham                   = _Cham                   // Cham is the set of Unicode characters in script Cham.
	Cherokee               = _Cherokee               // Cherokee is the set of Unicode characters in script Cherokee.
	Common                 = _Common                 // Common is the set of Unicode characters in script Common.
	Coptic                 = _Coptic                 // Coptic is the set of Unicode characters in script Coptic.
	Cuneiform              = _Cuneiform              // Cuneiform is the set of Unicode characters in script Cuneiform.
	Cypriot                = _Cypriot                // Cypriot is the set of Unicode characters in script Cypriot.
	Cyrillic               = _Cyrillic               // Cyrillic is the set of Unicode characters in script Cyrillic.
	Deseret                = _Deseret                // Deseret is the set of Unicode characters in script Deseret.
	Devanagari             = _Devanagari             // Devanagari is the set of Unicode characters in script Devanagari.
	Egyptian_Hieroglyphs   = _Egyptian_Hieroglyphs   // Egyptian_Hieroglyphs is the set of Unicode characters in script Egyptian_Hieroglyphs.
	Ethiopic               = _Ethiopic               // Ethiopic is the set of Unicode characters in script Ethiopic.
	Georgian               = _Georgian               // Georgian is the set of Unicode characters in script Georgian.
	Glagolitic             = _Glagolitic             // Glagolitic is the set of Unicode characters in script Glagolitic.
	Gothic                 = _Gothic                 // Gothic is the set of Unicode characters in script Gothic.
	Greek                  = _Greek                  // Greek is the set of Unicode characters in script Greek.
	Gujarati               = _Gujarati               // Gujarati is the set of Unicode characters in script Gujarati.
	Gurmukhi               = _Gurmukhi               // Gurmukhi is the set of Unicode characters in script Gurmukhi.
	Han                    = _Han                    // Han is the set of Unicode characters in script Han.
	Hangul                 = _Hangul                 // Hangul is the set of Unicode characters in script Hangul.
	Hanunoo                = _Hanunoo                // Hanunoo is the set of Unicode characters in script Hanunoo.
	Hebrew                 = _Hebrew                 // Hebrew is the set of Unicode characters in script Hebrew.
	Hiragana               = _Hiragana               // Hiragana is the set of Unicode characters in script Hiragana.
	Imperial_Aramaic       = _Imperial_Aramaic       // Imperial_Aramaic is the set of Unicode characters in script Imperial_Aramaic.
	Inherited              = _Inherited              // Inherited is the set of Unicode characters in script Inherited.
	Inscriptional_Pahlavi  = _Inscriptional_Pahlavi  // Inscriptional_Pahlavi is the set of Unicode characters in script Inscriptional_Pahlavi.
	Inscriptional_Parthian = _Inscriptional_Parthian // Inscriptional_Parthian is the set of Unicode characters in script Inscriptional_Parthian.
	Javanese               = _Javanese               // Javanese is the set of Unicode characters in script Javanese.
	Kaithi                 = _Kaithi                 // Kaithi is the set of Unicode characters in script Kaithi.
	Kannada                = _Kannada                // Kannada is the set of Unicode characters in script Kannada.
	Katakana               = _Katakana               // Katakana is the set of Unicode characters in script Katakana.
	Kayah_Li               = _Kayah_Li               // Kayah_Li is the set of Unicode characters in script Kayah_Li.
	Kharoshthi             = _Kharoshthi             // Kharoshthi is the set of Unicode characters in script Kharoshthi.
	Khmer                  = _Khmer                  // Khmer is the set of Unicode characters in script Khmer.
	Lao                    = _Lao                    // Lao is the set of Unicode characters in script Lao.
	Latin                  = _Latin                  // Latin is the set of Unicode characters in script Latin.
	Lepcha                 = _Lepcha                 // Lepcha is the set of Unicode characters in script Lepcha.
	Limbu                  = _Limbu                  // Limbu is the set of Unicode characters in script Limbu.
	Linear_B               = _Linear_B               // Linear_B is the set of Unicode characters in script Linear_B.
	Lisu                   = _Lisu                   // Lisu is the set of Unicode characters in script Lisu.
	Lycian                 = _Lycian                 // Lycian is the set of Unicode characters in script Lycian.
	Lydian                 = _Lydian                 // Lydian is the set of Unicode characters in script Lydian.
	Malayalam              = _Malayalam              // Malayalam is the set of Unicode characters in script Malayalam.
	Mandaic                = _Mandaic                // Mandaic is the set of Unicode characters in script Mandaic.
	Meetei_Mayek           = _Meetei_Mayek           // Meetei_Mayek is the set of Unicode characters in script Meetei_Mayek.
	Mongolian              = _Mongolian              // Mongolian is the set of Unicode characters in script Mongolian.
	Myanmar                = _Myanmar                // Myanmar is the set of Unicode characters in script Myanmar.
	New_Tai_Lue            = _New_Tai_Lue            // New_Tai_Lue is the set of Unicode characters in script New_Tai_Lue.
	Nko                    = _Nko                    // Nko is the set of Unicode characters in script Nko.
	Ogham                  = _Ogham                  // Ogham is the set of Unicode characters in script Ogham.
	Ol_Chiki               = _Ol_Chiki               // Ol_Chiki is the set of Unicode characters in script Ol_Chiki.
	Old_Italic             = _Old_Italic             // Old_Italic is the set of Unicode characters in script Old_Italic.
	Old_Persian            = _Old_Persian            // Old_Persian is the set of Unicode characters in script Old_Persian.
	Old_South_Arabian      = _Old_South_Arabian      // Old_South_Arabian is the set of Unicode characters in script Old_South_Arabian.
	Old_Turkic             = _Old_Turkic             // Old_Turkic is the set of Unicode characters in script Old_Turkic.
	Oriya                  = _Oriya                  // Oriya is the set of Unicode characters in script Oriya.
	Osmanya                = _Osmanya                // Osmanya is the set of Unicode characters in script Osmanya.
	Phags_Pa               = _Phags_Pa               // Phags_Pa is the set of Unicode characters in script Phags_Pa.
	Phoenician             = _Phoenician             // Phoenician is the set of Unicode characters in script Phoenician.
	Rejang                 = _Rejang                 // Rejang is the set of Unicode characters in script Rejang.
	Runic                  = _Runic                  // Runic is the set of Unicode characters in script Runic.
	Samaritan              = _Samaritan              // Samaritan is the set of Unicode characters in script Samaritan.
	Saurashtra             = _Saurashtra             // Saurashtra is the set of Unicode characters in script Saurashtra.
	Shavian                = _Shavian                // Shavian is the set of Unicode characters in script Shavian.
	Sinhala                = _Sinhala                // Sinhala is the set of Unicode characters in script Sinhala.
	Sundanese              = _Sundanese              // Sundanese is the set of Unicode characters in script Sundanese.
	Syloti_Nagri           = _Syloti_Nagri           // Syloti_Nagri is the set of Unicode characters in script Syloti_Nagri.
	Syriac                 = _Syriac                 // Syriac is the set of Unicode characters in script Syriac.
	Tagalog                = _Tagalog                // Tagalog is the set of Unicode characters in script Tagalog.
	Tagbanwa               = _Tagbanwa               // Tagbanwa is the set of Unicode characters in script Tagbanwa.
	Tai_Le                 = _Tai_Le                 // Tai_Le is the set of Unicode characters in script Tai_Le.
	Tai_Tham               = _Tai_Tham               // Tai_Tham is the set of Unicode characters in script Tai_Tham.
	Tai_Viet               = _Tai_Viet               // Tai_Viet is the set of Unicode characters in script Tai_Viet.
	Tamil                  = _Tamil                  // Tamil is the set of Unicode characters in script Tamil.
	Telugu                 = _Telugu                 // Telugu is the set of Unicode characters in script Telugu.
	Thaana                 = _Thaana                 // Thaana is the set of Unicode characters in script Thaana.
	Thai                   = _Thai                   // Thai is the set of Unicode characters in script Thai.
	Tibetan                = _Tibetan                // Tibetan is the set of Unicode characters in script Tibetan.
	Tifinagh               = _Tifinagh               // Tifinagh is the set of Unicode characters in script Tifinagh.
	Ugaritic               = _Ugaritic               // Ugaritic is the set of Unicode characters in script Ugaritic.
	Vai                    = _Vai                    // Vai is the set of Unicode characters in script Vai.
	Yi                     = _Yi                     // Yi is the set of Unicode characters in script Yi.
)

// Generated by running
//	maketables --props=all --url=http://www.unicode.org/Public/6.0.0/ucd/
// DO NOT EDIT

// Properties is the set of Unicode property tables.
var Properties = map[string]*RangeTable{
	"Pattern_Syntax":                     Pattern_Syntax,
	"Other_ID_Start":                     Other_ID_Start,
	"Pattern_White_Space":                Pattern_White_Space,
	"Other_Lowercase":                    Other_Lowercase,
	"Soft_Dotted":                        Soft_Dotted,
	"Hex_Digit":                          Hex_Digit,
	"ASCII_Hex_Digit":                    ASCII_Hex_Digit,
	"Deprecated":                         Deprecated,
	"Terminal_Punctuation":               Terminal_Punctuation,
	"Quotation_Mark":                     Quotation_Mark,
	"Other_ID_Continue":                  Other_ID_Continue,
	"Bidi_Control":                       Bidi_Control,
	"Variation_Selector":                 Variation_Selector,
	"Noncharacter_Code_Point":            Noncharacter_Code_Point,
	"Other_Math":                         Other_Math,
	"Unified_Ideograph":                  Unified_Ideograph,
	"Hyphen":                             Hyphen,
	"IDS_Binary_Operator":                IDS_Binary_Operator,
	"Logical_Order_Exception":            Logical_Order_Exception,
	"Radical":                            Radical,
	"Other_Uppercase":                    Other_Uppercase,
	"STerm":                              STerm,
	"Other_Alphabetic":                   Other_Alphabetic,
	"Diacritic":                          Diacritic,
	"Extender":                           Extender,
	"Join_Control":                       Join_Control,
	"Ideographic":                        Ideographic,
	"Dash":                               Dash,
	"IDS_Trinary_Operator":               IDS_Trinary_Operator,
	"Other_Grapheme_Extend":              Other_Grapheme_Extend,
	"Other_Default_Ignorable_Code_Point": Other_Default_Ignorable_Code_Point,
	"White_Space":                        White_Space,
}

var _Pattern_Syntax = &RangeTable{
	R16: []Range16{
		{0x0021, 0x002f, 1},
		{0x003a, 0x0040, 1},
		{0x005b, 0x005e, 1},
		{0x0060, 0x0060, 1},
		{0x007b, 0x007e, 1},
		{0x00a1, 0x00a7, 1},
		{0x00a9, 0x00a9, 1},
		{0x00ab, 0x00ac, 1},
		{0x00ae, 0x00ae, 1},
		{0x00b0, 0x00b1, 1},
		{0x00b6, 0x00b6, 1},
		{0x00bb, 0x00bb, 1},
		{0x00bf, 0x00bf, 1},
		{0x00d7, 0x00d7, 1},
		{0x00f7, 0x00f7, 1},
		{0x2010, 0x2027, 1},
		{0x2030, 0x203e, 1},
		{0x2041, 0x2053, 1},
		{0x2055, 0x205e, 1},
		{0x2190, 0x245f, 1},
		{0x2500, 0x2775, 1},
		{0x2794, 0x2bff, 1},
		{0x2e00, 0x2e7f, 1},
		{0x3001, 0x3003, 1},
		{0x3008, 0x3020, 1},
		{0x3030, 0x3030, 1},
		{0xfd3e, 0xfd3f, 1},
		{0xfe45, 0xfe46, 1},
	},
}

var _Other_ID_Start = &RangeTable{
	R16: []Range16{
		{0x2118, 0x2118, 1},
		{0x212e, 0x212e, 1},
		{0x309b, 0x309c, 1},
	},
}

var _Pattern_White_Space = &RangeTable{
	R16: []Range16{
		{0x0009, 0x000d, 1},
		{0x0020, 0x0020, 1},
		{0x0085, 0x0085, 1},
		{0x200e, 0x200f, 1},
		{0x2028, 0x2029, 1},
	},
}

var _Other_Lowercase = &RangeTable{
	R16: []Range16{
		{0x02b0, 0x02b8, 1},
		{0x02c0, 0x02c1, 1},
		{0x02e0, 0x02e4, 1},
		{0x0345, 0x0345, 1},
		{0x037a, 0x037a, 1},
		{0x1d2c, 0x1d61, 1},
		{0x1d78, 0x1d78, 1},
		{0x1d9b, 0x1dbf, 1},
		{0x2090, 0x2094, 1},
		{0x2170, 0x217f, 1},
		{0x24d0, 0x24e9, 1},
		{0x2c7d, 0x2c7d, 1},
		{0xa770, 0xa770, 1},
	},
}

var _Soft_Dotted = &RangeTable{
	R16: []Range16{
		{0x0069, 0x006a, 1},
		{0x012f, 0x012f, 1},
		{0x0249, 0x0249, 1},
		{0x0268, 0x0268, 1},
		{0x029d, 0x029d, 1},
		{0x02b2, 0x02b2, 1},
		{0x03f3, 0x03f3, 1},
		{0x0456, 0x0456, 1},
		{0x0458, 0x0458, 1},
		{0x1d62, 0x1d62, 1},
		{0x1d96, 0x1d96, 1},
		{0x1da4, 0x1da4, 1},
		{0x1da8, 0x1da8, 1},
		{0x1e2d, 0x1e2d, 1},
		{0x1ecb, 0x1ecb, 1},
		{0x2071, 0x2071, 1},
		{0x2148, 0x2149, 1},
		{0x2c7c, 0x2c7c, 1},
	},
	R32: []Range32{
		{0x1d422, 0x1d423, 1},
		{0x1d456, 0x1d457, 1},
		{0x1d48a, 0x1d48b, 1},
		{0x1d4be, 0x1d4bf, 1},
		{0x1d4f2, 0x1d4f3, 1},
		{0x1d526, 0x1d527, 1},
		{0x1d55a, 0x1d55b, 1},
		{0x1d58e, 0x1d58f, 1},
		{0x1d5c2, 0x1d5c3, 1},
		{0x1d5f6, 0x1d5f7, 1},
		{0x1d62a, 0x1d62b, 1},
		{0x1d65e, 0x1d65f, 1},
		{0x1d692, 0x1d693, 1},
	},
}

var _Hex_Digit = &RangeTable{
	R16: []Range16{
		{0x0030, 0x0039, 1},
		{0x0041, 0x0046, 1},
		{0x0061, 0x0066, 1},
		{0xff10, 0xff19, 1},
		{0xff21, 0xff26, 1},
		{0xff41, 0xff46, 1},
	},
}

var _ASCII_Hex_Digit = &RangeTable{
	R16: []Range16{
		{0x0030, 0x0039, 1},
		{0x0041, 0x0046, 1},
		{0x0061, 0x0066, 1},
	},
}

var _Deprecated = &RangeTable{
	R16: []Range16{
		{0x0149, 0x0149, 1},
		{0x0673, 0x0673, 1},
		{0x0f77, 0x0f77, 1},
		{0x0f79, 0x0f79, 1},
		{0x17a3, 0x17a4, 1},
		{0x206a, 0x206f, 1},
		{0x2329, 0x232a, 1},
	},
	R32: []Range32{
		{0xe0001, 0xe0001, 1},
		{0xe0020, 0xe007f, 1},
	},
}

var _Terminal_Punctuation = &RangeTable{
	R16: []Range16{
		{0x0021, 0x0021, 1},
		{0x002c, 0x002c, 1},
		{0x002e, 0x002e, 1},
		{0x003a, 0x003b, 1},
		{0x003f, 0x003f, 1},
		{0x037e, 0x037e, 1},
		{0x0387, 0x0387, 1},
		{0x0589, 0x0589, 1},
		{0x05c3, 0x05c3, 1},
		{0x060c, 0x060c, 1},
		{0x061b, 0x061b, 1},
		{0x061f, 0x061f, 1},
		{0x06d4, 0x06d4, 1},
		{0x0700, 0x070a, 1},
		{0x070c, 0x070c, 1},
		{0x07f8, 0x07f9, 1},
		{0x0830, 0x083e, 1},
		{0x085e, 0x085e, 1},
		{0x0964, 0x0965, 1},
		{0x0e5a, 0x0e5b, 1},
		{0x0f08, 0x0f08, 1},
		{0x0f0d, 0x0f12, 1},
		{0x104a, 0x104b, 1},
		{0x1361, 0x1368, 1},
		{0x166d, 0x166e, 1},
		{0x16eb, 0x16ed, 1},
		{0x17d4, 0x17d6, 1},
		{0x17da, 0x17da, 1},
		{0x1802, 0x1805, 1},
		{0x1808, 0x1809, 1},
		{0x1944, 0x1945, 1},
		{0x1aa8, 0x1aab, 1},
		{0x1b5a, 0x1b5b, 1},
		{0x1b5d, 0x1b5f, 1},
		{0x1c3b, 0x1c3f, 1},
		{0x1c7e, 0x1c7f, 1},
		{0x203c, 0x203d, 1},
		{0x2047, 0x2049, 1},
		{0x2e2e, 0x2e2e, 1},
		{0x3001, 0x3002, 1},
		{0xa4fe, 0xa4ff, 1},
		{0xa60d, 0xa60f, 1},
		{0xa6f3, 0xa6f7, 1},
		{0xa876, 0xa877, 1},
		{0xa8ce, 0xa8cf, 1},
		{0xa92f, 0xa92f, 1},
		{0xa9c7, 0xa9c9, 1},
		{0xaa5d, 0xaa5f, 1},
		{0xaadf, 0xaadf, 1},
		{0xabeb, 0xabeb, 1},
		{0xfe50, 0xfe52, 1},
		{0xfe54, 0xfe57, 1},
		{0xff01, 0xff01, 1},
		{0xff0c, 0xff0c, 1},
		{0xff0e, 0xff0e, 1},
		{0xff1a, 0xff1b, 1},
		{0xff1f, 0xff1f, 1},
		{0xff61, 0xff61, 1},
		{0xff64, 0xff64, 1},
	},
	R32: []Range32{
		{0x1039f, 0x1039f, 1},
		{0x103d0, 0x103d0, 1},
		{0x10857, 0x10857, 1},
		{0x1091f, 0x1091f, 1},
		{0x10b3a, 0x10b3f, 1},
		{0x11047, 0x1104d, 1},
		{0x110be, 0x110c1, 1},
		{0x12470, 0x12473, 1},
	},
}

var _Quotation_Mark = &RangeTable{
	R16: []Range16{
		{0x0022, 0x0022, 1},
		{0x0027, 0x0027, 1},
		{0x00ab, 0x00ab, 1},
		{0x00bb, 0x00bb, 1},
		{0x2018, 0x201f, 1},
		{0x2039, 0x203a, 1},
		{0x300c, 0x300f, 1},
		{0x301d, 0x301f, 1},
		{0xfe41, 0xfe44, 1},
		{0xff02, 0xff02, 1},
		{0xff07, 0xff07, 1},
		{0xff62, 0xff63, 1},
	},
}

var _Other_ID_Continue = &RangeTable{
	R16: []Range16{
		{0x00b7, 0x00b7, 1},
		{0x0387, 0x0387, 1},
		{0x1369, 0x1371, 1},
		{0x19da, 0x19da, 1},
	},
}

var _Bidi_Control = &RangeTable{
	R16: []Range16{
		{0x200e, 0x200f, 1},
		{0x202a, 0x202e, 1},
	},
}

var _Variation_Selector = &RangeTable{
	R16: []Range16{
		{0x180b, 0x180d, 1},
		{0xfe00, 0xfe0f, 1},
	},
	R32: []Range32{
		{0xe0100, 0xe01ef, 1},
	},
}

var _Noncharacter_Code_Point = &RangeTable{
	R16: []Range16{
		{0xfdd0, 0xfdef, 1},
		{0xfffe, 0xffff, 1},
	},
	R32: []Range32{
		{0x1fffe, 0x1ffff, 1},
		{0x2fffe, 0x2ffff, 1},
		{0x3fffe, 0x3ffff, 1},
		{0x4fffe, 0x4ffff, 1},
		{0x5fffe, 0x5ffff, 1},
		{0x6fffe, 0x6ffff, 1},
		{0x7fffe, 0x7ffff, 1},
		{0x8fffe, 0x8ffff, 1},
		{0x9fffe, 0x9ffff, 1},
		{0xafffe, 0xaffff, 1},
		{0xbfffe, 0xbffff, 1},
		{0xcfffe, 0xcffff, 1},
		{0xdfffe, 0xdffff, 1},
		{0xefffe, 0xeffff, 1},
		{0xffffe, 0xfffff, 1},
		{0x10fffe, 0x10ffff, 1},
	},
}

var _Other_Math = &RangeTable{
	R16: []Range16{
		{0x005e, 0x005e, 1},
		{0x03d0, 0x03d2, 1},
		{0x03d5, 0x03d5, 1},
		{0x03f0, 0x03f1, 1},
		{0x03f4, 0x03f5, 1},
		{0x2016, 0x2016, 1},
		{0x2032, 0x2034, 1},
		{0x2040, 0x2040, 1},
		{0x2061, 0x2064, 1},
		{0x207d, 0x207e, 1},
		{0x208d, 0x208e, 1},
		{0x20d0, 0x20dc, 1},
		{0x20e1, 0x20e1, 1},
		{0x20e5, 0x20e6, 1},
		{0x20eb, 0x20ef, 1},
		{0x2102, 0x2102, 1},
		{0x2107, 0x2107, 1},
		{0x210a, 0x2113, 1},
		{0x2115, 0x2115, 1},
		{0x2119, 0x211d, 1},
		{0x2124, 0x2124, 1},
		{0x2128, 0x2129, 1},
		{0x212c, 0x212d, 1},
		{0x212f, 0x2131, 1},
		{0x2133, 0x2138, 1},
		{0x213c, 0x213f, 1},
		{0x2145, 0x2149, 1},
		{0x2195, 0x2199, 1},
		{0x219c, 0x219f, 1},
		{0x21a1, 0x21a2, 1},
		{0x21a4, 0x21a5, 1},
		{0x21a7, 0x21a7, 1},
		{0x21a9, 0x21ad, 1},
		{0x21b0, 0x21b1, 1},
		{0x21b6, 0x21b7, 1},
		{0x21bc, 0x21cd, 1},
		{0x21d0, 0x21d1, 1},
		{0x21d3, 0x21d3, 1},
		{0x21d5, 0x21db, 1},
		{0x21dd, 0x21dd, 1},
		{0x21e4, 0x21e5, 1},
		{0x23b4, 0x23b5, 1},
		{0x23b7, 0x23b7, 1},
		{0x23d0, 0x23d0, 1},
		{0x23e2, 0x23e2, 1},
		{0x25a0, 0x25a1, 1},
		{0x25ae, 0x25b6, 1},
		{0x25bc, 0x25c0, 1},
		{0x25c6, 0x25c7, 1},
		{0x25ca, 0x25cb, 1},
		{0x25cf, 0x25d3, 1},
		{0x25e2, 0x25e2, 1},
		{0x25e4, 0x25e4, 1},
		{0x25e7, 0x25ec, 1},
		{0x2605, 0x2606, 1},
		{0x2640, 0x2640, 1},
		{0x2642, 0x2642, 1},
		{0x2660, 0x2663, 1},
		{0x266d, 0x266e, 1},
		{0x27c5, 0x27c6, 1},
		{0x27e6, 0x27ef, 1},
		{0x2983, 0x2998, 1},
		{0x29d8, 0x29db, 1},
		{0x29fc, 0x29fd, 1},
		{0xfe61, 0xfe61, 1},
		{0xfe63, 0xfe63, 1},
		{0xfe68, 0xfe68, 1},
		{0xff3c, 0xff3c, 1},
		{0xff3e, 0xff3e, 1},
	},
	R32: []Range32{
		{0x1d400, 0x1d454, 1},
		{0x1d456, 0x1d49c, 1},
		{0x1d49e, 0x1d49f, 1},
		{0x1d4a2, 0x1d4a2, 1},
		{0x1d4a5, 0x1d4a6, 1},
		{0x1d4a9, 0x1d4ac, 1},
		{0x1d4ae, 0x1d4b9, 1},
		{0x1d4bb, 0x1d4bb, 1},
		{0x1d4bd, 0x1d4c3, 1},
		{0x1d4c5, 0x1d505, 1},
		{0x1d507, 0x1d50a, 1},
		{0x1d50d, 0x1d514, 1},
		{0x1d516, 0x1d51c, 1},
		{0x1d51e, 0x1d539, 1},
		{0x1d53b, 0x1d53e, 1},
		{0x1d540, 0x1d544, 1},
		{0x1d546, 0x1d546, 1},
		{0x1d54a, 0x1d550, 1},
		{0x1d552, 0x1d6a5, 1},
		{0x1d6a8, 0x1d6c0, 1},
		{0x1d6c2, 0x1d6da, 1},
		{0x1d6dc, 0x1d6fa, 1},
		{0x1d6fc, 0x1d714, 1},
		{0x1d716, 0x1d734, 1},
		{0x1d736, 0x1d74e, 1},
		{0x1d750, 0x1d76e, 1},
		{0x1d770, 0x1d788, 1},
		{0x1d78a, 0x1d7a8, 1},
		{0x1d7aa, 0x1d7c2, 1},
		{0x1d7c4, 0x1d7cb, 1},
		{0x1d7ce, 0x1d7ff, 1},
	},
}

var _Unified_Ideograph = &RangeTable{
	R16: []Range16{
		{0x3400, 0x4db5, 1},
		{0x4e00, 0x9fcb, 1},
		{0xfa0e, 0xfa0f, 1},
		{0xfa11, 0xfa11, 1},
		{0xfa13, 0xfa14, 1},
		{0xfa1f, 0xfa1f, 1},
		{0xfa21, 0xfa21, 1},
		{0xfa23, 0xfa24, 1},
		{0xfa27, 0xfa29, 1},
	},
	R32: []Range32{
		{0x20000, 0x2a6d6, 1},
		{0x2a700, 0x2b734, 1},
		{0x2b740, 0x2b81d, 1},
	},
}

var _Hyphen = &RangeTable{
	R16: []Range16{
		{0x002d, 0x002d, 1},
		{0x00ad, 0x00ad, 1},
		{0x058a, 0x058a, 1},
		{0x1806, 0x1806, 1},
		{0x2010, 0x2011, 1},
		{0x2e17, 0x2e17, 1},
		{0x30fb, 0x30fb, 1},
		{0xfe63, 0xfe63, 1},
		{0xff0d, 0xff0d, 1},
		{0xff65, 0xff65, 1},
	},
}

var _IDS_Binary_Operator = &RangeTable{
	R16: []Range16{
		{0x2ff0, 0x2ff1, 1},
		{0x2ff4, 0x2ffb, 1},
	},
}

var _Logical_Order_Exception = &RangeTable{
	R16: []Range16{
		{0x0e40, 0x0e44, 1},
		{0x0ec0, 0x0ec4, 1},
		{0xaab5, 0xaab6, 1},
		{0xaab9, 0xaab9, 1},
		{0xaabb, 0xaabc, 1},
	},
}

var _Radical = &RangeTable{
	R16: []Range16{
		{0x2e80, 0x2e99, 1},
		{0x2e9b, 0x2ef3, 1},
		{0x2f00, 0x2fd5, 1},
	},
}

var _Other_Uppercase = &RangeTable{
	R16: []Range16{
		{0x2160, 0x216f, 1},
		{0x24b6, 0x24cf, 1},
	},
}

var _STerm = &RangeTable{
	R16: []Range16{
		{0x0021, 0x0021, 1},
		{0x002e, 0x002e, 1},
		{0x003f, 0x003f, 1},
		{0x055c, 0x055c, 1},
		{0x055e, 0x055e, 1},
		{0x0589, 0x0589, 1},
		{0x061f, 0x061f, 1},
		{0x06d4, 0x06d4, 1},
		{0x0700, 0x0702, 1},
		{0x07f9, 0x07f9, 1},
		{0x0964, 0x0965, 1},
		{0x104a, 0x104b, 1},
		{0x1362, 0x1362, 1},
		{0x1367, 0x1368, 1},
		{0x166e, 0x166e, 1},
		{0x1735, 0x1736, 1},
		{0x1803, 0x1803, 1},
		{0x1809, 0x1809, 1},
		{0x1944, 0x1945, 1},
		{0x1aa8, 0x1aab, 1},
		{0x1b5a, 0x1b5b, 1},
		{0x1b5e, 0x1b5f, 1},
		{0x1c3b, 0x1c3c, 1},
		{0x1c7e, 0x1c7f, 1},
		{0x203c, 0x203d, 1},
		{0x2047, 0x2049, 1},
		{0x2e2e, 0x2e2e, 1},
		{0x3002, 0x3002, 1},
		{0xa4ff, 0xa4ff, 1},
		{0xa60e, 0xa60f, 1},
		{0xa6f3, 0xa6f3, 1},
		{0xa6f7, 0xa6f7, 1},
		{0xa876, 0xa877, 1},
		{0xa8ce, 0xa8cf, 1},
		{0xa92f, 0xa92f, 1},
		{0xa9c8, 0xa9c9, 1},
		{0xaa5d, 0xaa5f, 1},
		{0xabeb, 0xabeb, 1},
		{0xfe52, 0xfe52, 1},
		{0xfe56, 0xfe57, 1},
		{0xff01, 0xff01, 1},
		{0xff0e, 0xff0e, 1},
		{0xff1f, 0xff1f, 1},
		{0xff61, 0xff61, 1},
	},
	R32: []Range32{
		{0x10a56, 0x10a57, 1},
		{0x11047, 0x11048, 1},
		{0x110be, 0x110c1, 1},
	},
}

var _Other_Alphabetic = &RangeTable{
	R16: []Range16{
		{0x0345, 0x0345, 1},
		{0x05b0, 0x05bd, 1},
		{0x05bf, 0x05bf, 1},
		{0x05c1, 0x05c2, 1},
		{0x05c4, 0x05c5, 1},
		{0x05c7, 0x05c7, 1},
		{0x0610, 0x061a, 1},
		{0x064b, 0x0657, 1},
		{0x0659, 0x065f, 1},
		{0x0670, 0x0670, 1},
		{0x06d6, 0x06dc, 1},
		{0x06e1, 0x06e4, 1},
		{0x06e7, 0x06e8, 1},
		{0x06ed, 0x06ed, 1},
		{0x0711, 0x0711, 1},
		{0x0730, 0x073f, 1},
		{0x07a6, 0x07b0, 1},
		{0x0816, 0x0817, 1},
		{0x081b, 0x0823, 1},
		{0x0825, 0x0827, 1},
		{0x0829, 0x082c, 1},
		{0x0900, 0x0903, 1},
		{0x093a, 0x093b, 1},
		{0x093e, 0x094c, 1},
		{0x094e, 0x094f, 1},
		{0x0955, 0x0957, 1},
		{0x0962, 0x0963, 1},
		{0x0981, 0x0983, 1},
		{0x09be, 0x09c4, 1},
		{0x09c7, 0x09c8, 1},
		{0x09cb, 0x09cc, 1},
		{0x09d7, 0x09d7, 1},
		{0x09e2, 0x09e3, 1},
		{0x0a01, 0x0a03, 1},
		{0x0a3e, 0x0a42, 1},
		{0x0a47, 0x0a48, 1},
		{0x0a4b, 0x0a4c, 1},
		{0x0a51, 0x0a51, 1},
		{0x0a70, 0x0a71, 1},
		{0x0a75, 0x0a75, 1},
		{0x0a81, 0x0a83, 1},
		{0x0abe, 0x0ac5, 1},
		{0x0ac7, 0x0ac9, 1},
		{0x0acb, 0x0acc, 1},
		{0x0ae2, 0x0ae3, 1},
		{0x0b01, 0x0b03, 1},
		{0x0b3e, 0x0b44, 1},
		{0x0b47, 0x0b48, 1},
		{0x0b4b, 0x0b4c, 1},
		{0x0b56, 0x0b57, 1},
		{0x0b62, 0x0b63, 1},
		{0x0b82, 0x0b82, 1},
		{0x0bbe, 0x0bc2, 1},
		{0x0bc6, 0x0bc8, 1},
		{0x0bca, 0x0bcc, 1},
		{0x0bd7, 0x0bd7, 1},
		{0x0c01, 0x0c03, 1},
		{0x0c3e, 0x0c44, 1},
		{0x0c46, 0x0c48, 1},
		{0x0c4a, 0x0c4c, 1},
		{0x0c55, 0x0c56, 1},
		{0x0c62, 0x0c63, 1},
		{0x0c82, 0x0c83, 1},
		{0x0cbe, 0x0cc4, 1},
		{0x0cc6, 0x0cc8, 1},
		{0x0cca, 0x0ccc, 1},
		{0x0cd5, 0x0cd6, 1},
		{0x0ce2, 0x0ce3, 1},
		{0x0d02, 0x0d03, 1},
		{0x0d3e, 0x0d44, 1},
		{0x0d46, 0x0d48, 1},
		{0x0d4a, 0x0d4c, 1},
		{0x0d57, 0x0d57, 1},
		{0x0d62, 0x0d63, 1},
		{0x0d82, 0x0d83, 1},
		{0x0dcf, 0x0dd4, 1},
		{0x0dd6, 0x0dd6, 1},
		{0x0dd8, 0x0ddf, 1},
		{0x0df2, 0x0df3, 1},
		{0x0e31, 0x0e31, 1},
		{0x0e34, 0x0e3a, 1},
		{0x0e4d, 0x0e4d, 1},
		{0x0eb1, 0x0eb1, 1},
		{0x0eb4, 0x0eb9, 1},
		{0x0ebb, 0x0ebc, 1},
		{0x0ecd, 0x0ecd, 1},
		{0x0f71, 0x0f81, 1},
		{0x0f8d, 0x0f97, 1},
		{0x0f99, 0x0fbc, 1},
		{0x102b, 0x1036, 1},
		{0x1038, 0x1038, 1},
		{0x103b, 0x103e, 1},
		{0x1056, 0x1059, 1},
		{0x105e, 0x1060, 1},
		{0x1062, 0x1062, 1},
		{0x1067, 0x1068, 1},
		{0x1071, 0x1074, 1},
		{0x1082, 0x1086, 1},
		{0x109c, 0x109d, 1},
		{0x135f, 0x135f, 1},
		{0x1712, 0x1713, 1},
		{0x1732, 0x1733, 1},
		{0x1752, 0x1753, 1},
		{0x1772, 0x1773, 1},
		{0x17b6, 0x17c8, 1},
		{0x18a9, 0x18a9, 1},
		{0x1920, 0x192b, 1},
		{0x1930, 0x1938, 1},
		{0x19b0, 0x19c0, 1},
		{0x19c8, 0x19c9, 1},
		{0x1a17, 0x1a1b, 1},
		{0x1a55, 0x1a5e, 1},
		{0x1a61, 0x1a74, 1},
		{0x1b00, 0x1b04, 1},
		{0x1b35, 0x1b43, 1},
		{0x1b80, 0x1b82, 1},
		{0x1ba1, 0x1ba9, 1},
		{0x1be7, 0x1bf1, 1},
		{0x1c24, 0x1c35, 1},
		{0x1cf2, 0x1cf2, 1},
		{0x24b6, 0x24e9, 1},
		{0x2de0, 0x2dff, 1},
		{0xa823, 0xa827, 1},
		{0xa880, 0xa881, 1},
		{0xa8b4, 0xa8c3, 1},
		{0xa926, 0xa92a, 1},
		{0xa947, 0xa952, 1},
		{0xa980, 0xa983, 1},
		{0xa9b4, 0xa9bf, 1},
		{0xaa29, 0xaa36, 1},
		{0xaa43, 0xaa43, 1},
		{0xaa4c, 0xaa4d, 1},
		{0xaab0, 0xaab0, 1},
		{0xaab2, 0xaab4, 1},
		{0xaab7, 0xaab8, 1},
		{0xaabe, 0xaabe, 1},
		{0xabe3, 0xabea, 1},
		{0xfb1e, 0xfb1e, 1},
	},
	R32: []Range32{
		{0x10a01, 0x10a03, 1},
		{0x10a05, 0x10a06, 1},
		{0x10a0c, 0x10a0f, 1},
		{0x11000, 0x11002, 1},
		{0x11038, 0x11045, 1},
		{0x11082, 0x11082, 1},
		{0x110b0, 0x110b8, 1},
	},
}

var _Diacritic = &RangeTable{
	R16: []Range16{
		{0x005e, 0x005e, 1},
		{0x0060, 0x0060, 1},
		{0x00a8, 0x00a8, 1},
		{0x00af, 0x00af, 1},
		{0x00b4, 0x00b4, 1},
		{0x00b7, 0x00b8, 1},
		{0x02b0, 0x034e, 1},
		{0x0350, 0x0357, 1},
		{0x035d, 0x0362, 1},
		{0x0374, 0x0375, 1},
		{0x037a, 0x037a, 1},
		{0x0384, 0x0385, 1},
		{0x0483, 0x0487, 1},
		{0x0559, 0x0559, 1},
		{0x0591, 0x05a1, 1},
		{0x05a3, 0x05bd, 1},
		{0x05bf, 0x05bf, 1},
		{0x05c1, 0x05c2, 1},
		{0x05c4, 0x05c4, 1},
		{0x064b, 0x0652, 1},
		{0x0657, 0x0658, 1},
		{0x06df, 0x06e0, 1},
		{0x06e5, 0x06e6, 1},
		{0x06ea, 0x06ec, 1},
		{0x0730, 0x074a, 1},
		{0x07a6, 0x07b0, 1},
		{0x07eb, 0x07f5, 1},
		{0x0818, 0x0819, 1},
		{0x093c, 0x093c, 1},
		{0x094d, 0x094d, 1},
		{0x0951, 0x0954, 1},
		{0x0971, 0x0971, 1},
		{0x09bc, 0x09bc, 1},
		{0x09cd, 0x09cd, 1},
		{0x0a3c, 0x0a3c, 1},
		{0x0a4d, 0x0a4d, 1},
		{0x0abc, 0x0abc, 1},
		{0x0acd, 0x0acd, 1},
		{0x0b3c, 0x0b3c, 1},
		{0x0b4d, 0x0b4d, 1},
		{0x0bcd, 0x0bcd, 1},
		{0x0c4d, 0x0c4d, 1},
		{0x0cbc, 0x0cbc, 1},
		{0x0ccd, 0x0ccd, 1},
		{0x0d4d, 0x0d4d, 1},
		{0x0dca, 0x0dca, 1},
		{0x0e47, 0x0e4c, 1},
		{0x0e4e, 0x0e4e, 1},
		{0x0ec8, 0x0ecc, 1},
		{0x0f18, 0x0f19, 1},
		{0x0f35, 0x0f35, 1},
		{0x0f37, 0x0f37, 1},
		{0x0f39, 0x0f39, 1},
		{0x0f3e, 0x0f3f, 1},
		{0x0f82, 0x0f84, 1},
		{0x0f86, 0x0f87, 1},
		{0x0fc6, 0x0fc6, 1},
		{0x1037, 0x1037, 1},
		{0x1039, 0x103a, 1},
		{0x1087, 0x108d, 1},
		{0x108f, 0x108f, 1},
		{0x109a, 0x109b, 1},
		{0x17c9, 0x17d3, 1},
		{0x17dd, 0x17dd, 1},
		{0x1939, 0x193b, 1},
		{0x1a75, 0x1a7c, 1},
		{0x1a7f, 0x1a7f, 1},
		{0x1b34, 0x1b34, 1},
		{0x1b44, 0x1b44, 1},
		{0x1b6b, 0x1b73, 1},
		{0x1baa, 0x1baa, 1},
		{0x1c36, 0x1c37, 1},
		{0x1c78, 0x1c7d, 1},
		{0x1cd0, 0x1ce8, 1},
		{0x1ced, 0x1ced, 1},
		{0x1d2c, 0x1d6a, 1},
		{0x1dc4, 0x1dcf, 1},
		{0x1dfd, 0x1dff, 1},
		{0x1fbd, 0x1fbd, 1},
		{0x1fbf, 0x1fc1, 1},
		{0x1fcd, 0x1fcf, 1},
		{0x1fdd, 0x1fdf, 1},
		{0x1fed, 0x1fef, 1},
		{0x1ffd, 0x1ffe, 1},
		{0x2cef, 0x2cf1, 1},
		{0x2e2f, 0x2e2f, 1},
		{0x302a, 0x302f, 1},
		{0x3099, 0x309c, 1},
		{0x30fc, 0x30fc, 1},
		{0xa66f, 0xa66f, 1},
		{0xa67c, 0xa67d, 1},
		{0xa67f, 0xa67f, 1},
		{0xa6f0, 0xa6f1, 1},
		{0xa717, 0xa721, 1},
		{0xa788, 0xa788, 1},
		{0xa8c4, 0xa8c4, 1},
		{0xa8e0, 0xa8f1, 1},
		{0xa92b, 0xa92e, 1},
		{0xa953, 0xa953, 1},
		{0xa9b3, 0xa9b3, 1},
		{0xa9c0, 0xa9c0, 1},
		{0xaa7b, 0xaa7b, 1},
		{0xaabf, 0xaac2, 1},
		{0xabec, 0xabed, 1},
		{0xfb1e, 0xfb1e, 1},
		{0xfe20, 0xfe26, 1},
		{0xff3e, 0xff3e, 1},
		{0xff40, 0xff40, 1},
		{0xff70, 0xff70, 1},
		{0xff9e, 0xff9f, 1},
		{0xffe3, 0xffe3, 1},
	},
	R32: []Range32{
		{0x110b9, 0x110ba, 1},
		{0x1d167, 0x1d169, 1},
		{0x1d16d, 0x1d172, 1},
		{0x1d17b, 0x1d182, 1},
		{0x1d185, 0x1d18b, 1},
		{0x1d1aa, 0x1d1ad, 1},
	},
}

var _Extender = &RangeTable{
	R16: []Range16{
		{0x00b7, 0x00b7, 1},
		{0x02d0, 0x02d1, 1},
		{0x0640, 0x0640, 1},
		{0x07fa, 0x07fa, 1},
		{0x0e46, 0x0e46, 1},
		{0x0ec6, 0x0ec6, 1},
		{0x1843, 0x1843, 1},
		{0x1aa7, 0x1aa7, 1},
		{0x1c36, 0x1c36, 1},
		{0x1c7b, 0x1c7b, 1},
		{0x3005, 0x3005, 1},
		{0x3031, 0x3035, 1},
		{0x309d, 0x309e, 1},
		{0x30fc, 0x30fe, 1},
		{0xa015, 0xa015, 1},
		{0xa60c, 0xa60c, 1},
		{0xa9cf, 0xa9cf, 1},
		{0xaa70, 0xaa70, 1},
		{0xaadd, 0xaadd, 1},
		{0xff70, 0xff70, 1},
	},
}

var _Join_Control = &RangeTable{
	R16: []Range16{
		{0x200c, 0x200d, 1},
	},
}

var _Ideographic = &RangeTable{
	R16: []Range16{
		{0x3006, 0x3007, 1},
		{0x3021, 0x3029, 1},
		{0x3038, 0x303a, 1},
		{0x3400, 0x4db5, 1},
		{0x4e00, 0x9fcb, 1},
		{0xf900, 0xfa2d, 1},
		{0xfa30, 0xfa6d, 1},
		{0xfa70, 0xfad9, 1},
	},
	R32: []Range32{
		{0x20000, 0x2a6d6, 1},
		{0x2a700, 0x2b734, 1},
		{0x2b740, 0x2b81d, 1},
		{0x2f800, 0x2fa1d, 1},
	},
}

var _Dash = &RangeTable{
	R16: []Range16{
		{0x002d, 0x002d, 1},
		{0x058a, 0x058a, 1},
		{0x05be, 0x05be, 1},
		{0x1400, 0x1400, 1},
		{0x1806, 0x1806, 1},
		{0x2010, 0x2015, 1},
		{0x2053, 0x2053, 1},
		{0x207b, 0x207b, 1},
		{0x208b, 0x208b, 1},
		{0x2212, 0x2212, 1},
		{0x2e17, 0x2e17, 1},
		{0x2e1a, 0x2e1a, 1},
		{0x301c, 0x301c, 1},
		{0x3030, 0x3030, 1},
		{0x30a0, 0x30a0, 1},
		{0xfe31, 0xfe32, 1},
		{0xfe58, 0xfe58, 1},
		{0xfe63, 0xfe63, 1},
		{0xff0d, 0xff0d, 1},
	},
}

var _IDS_Trinary_Operator = &RangeTable{
	R16: []Range16{
		{0x2ff2, 0x2ff3, 1},
	},
}

var _Other_Grapheme_Extend = &RangeTable{
	R16: []Range16{
		{0x09be, 0x09be, 1},
		{0x09d7, 0x09d7, 1},
		{0x0b3e, 0x0b3e, 1},
		{0x0b57, 0x0b57, 1},
		{0x0bbe, 0x0bbe, 1},
		{0x0bd7, 0x0bd7, 1},
		{0x0cc2, 0x0cc2, 1},
		{0x0cd5, 0x0cd6, 1},
		{0x0d3e, 0x0d3e, 1},
		{0x0d57, 0x0d57, 1},
		{0x0dcf, 0x0dcf, 1},
		{0x0ddf, 0x0ddf, 1},
		{0x200c, 0x200d, 1},
		{0xff9e, 0xff9f, 1},
	},
	R32: []Range32{
		{0x1d165, 0x1d165, 1},
		{0x1d16e, 0x1d172, 1},
	},
}

var _Other_Default_Ignorable_Code_Point = &RangeTable{
	R16: []Range16{
		{0x034f, 0x034f, 1},
		{0x115f, 0x1160, 1},
		{0x2065, 0x2069, 1},
		{0x3164, 0x3164, 1},
		{0xffa0, 0xffa0, 1},
		{0xfff0, 0xfff8, 1},
	},
	R32: []Range32{
		{0xe0000, 0xe0000, 1},
		{0xe0002, 0xe001f, 1},
		{0xe0080, 0xe00ff, 1},
		{0xe01f0, 0xe0fff, 1},
	},
}

var _White_Space = &RangeTable{
	R16: []Range16{
		{0x0009, 0x000d, 1},
		{0x0020, 0x0020, 1},
		{0x0085, 0x0085, 1},
		{0x00a0, 0x00a0, 1},
		{0x1680, 0x1680, 1},
		{0x180e, 0x180e, 1},
		{0x2000, 0x200a, 1},
		{0x2028, 0x2029, 1},
		{0x202f, 0x202f, 1},
		{0x205f, 0x205f, 1},
		{0x3000, 0x3000, 1},
	},
}

var (
	ASCII_Hex_Digit                    = _ASCII_Hex_Digit                    // ASCII_Hex_Digit is the set of Unicode characters with property ASCII_Hex_Digit.
	Bidi_Control                       = _Bidi_Control                       // Bidi_Control is the set of Unicode characters with property Bidi_Control.
	Dash                               = _Dash                               // Dash is the set of Unicode characters with property Dash.
	Deprecated                         = _Deprecated                         // Deprecated is the set of Unicode characters with property Deprecated.
	Diacritic                          = _Diacritic                          // Diacritic is the set of Unicode characters with property Diacritic.
	Extender                           = _Extender                           // Extender is the set of Unicode characters with property Extender.
	Hex_Digit                          = _Hex_Digit                          // Hex_Digit is the set of Unicode characters with property Hex_Digit.
	Hyphen                             = _Hyphen                             // Hyphen is the set of Unicode characters with property Hyphen.
	IDS_Binary_Operator                = _IDS_Binary_Operator                // IDS_Binary_Operator is the set of Unicode characters with property IDS_Binary_Operator.
	IDS_Trinary_Operator               = _IDS_Trinary_Operator               // IDS_Trinary_Operator is the set of Unicode characters with property IDS_Trinary_Operator.
	Ideographic                        = _Ideographic                        // Ideographic is the set of Unicode characters with property Ideographic.
	Join_Control                       = _Join_Control                       // Join_Control is the set of Unicode characters with property Join_Control.
	Logical_Order_Exception            = _Logical_Order_Exception            // Logical_Order_Exception is the set of Unicode characters with property Logical_Order_Exception.
	Noncharacter_Code_Point            = _Noncharacter_Code_Point            // Noncharacter_Code_Point is the set of Unicode characters with property Noncharacter_Code_Point.
	Other_Alphabetic                   = _Other_Alphabetic                   // Other_Alphabetic is the set of Unicode characters with property Other_Alphabetic.
	Other_Default_Ignorable_Code_Point = _Other_Default_Ignorable_Code_Point // Other_Default_Ignorable_Code_Point is the set of Unicode characters with property Other_Default_Ignorable_Code_Point.
	Other_Grapheme_Extend              = _Other_Grapheme_Extend              // Other_Grapheme_Extend is the set of Unicode characters with property Other_Grapheme_Extend.
	Other_ID_Continue                  = _Other_ID_Continue                  // Other_ID_Continue is the set of Unicode characters with property Other_ID_Continue.
	Other_ID_Start                     = _Other_ID_Start                     // Other_ID_Start is the set of Unicode characters with property Other_ID_Start.
	Other_Lowercase                    = _Other_Lowercase                    // Other_Lowercase is the set of Unicode characters with property Other_Lowercase.
	Other_Math                         = _Other_Math                         // Other_Math is the set of Unicode characters with property Other_Math.
	Other_Uppercase                    = _Other_Uppercase                    // Other_Uppercase is the set of Unicode characters with property Other_Uppercase.
	Pattern_Syntax                     = _Pattern_Syntax                     // Pattern_Syntax is the set of Unicode characters with property Pattern_Syntax.
	Pattern_White_Space                = _Pattern_White_Space                // Pattern_White_Space is the set of Unicode characters with property Pattern_White_Space.
	Quotation_Mark                     = _Quotation_Mark                     // Quotation_Mark is the set of Unicode characters with property Quotation_Mark.
	Radical                            = _Radical                            // Radical is the set of Unicode characters with property Radical.
	STerm                              = _STerm                              // STerm is the set of Unicode characters with property STerm.
	Soft_Dotted                        = _Soft_Dotted                        // Soft_Dotted is the set of Unicode characters with property Soft_Dotted.
	Terminal_Punctuation               = _Terminal_Punctuation               // Terminal_Punctuation is the set of Unicode characters with property Terminal_Punctuation.
	Unified_Ideograph                  = _Unified_Ideograph                  // Unified_Ideograph is the set of Unicode characters with property Unified_Ideograph.
	Variation_Selector                 = _Variation_Selector                 // Variation_Selector is the set of Unicode characters with property Variation_Selector.
	White_Space                        = _White_Space                        // White_Space is the set of Unicode characters with property White_Space.
)

// Generated by running
//	maketables --data=http://www.unicode.org/Public/6.0.0/ucd/UnicodeData.txt --casefolding=http://www.unicode.org/Public/6.0.0/ucd/CaseFolding.txt
// DO NOT EDIT

// CaseRanges is the table describing case mappings for all letters with
// non-self mappings.
var CaseRanges = _CaseRanges
var _CaseRanges = []CaseRange{
	{0x0041, 0x005A, d{0, 32, 0}},
	{0x0061, 0x007A, d{-32, 0, -32}},
	{0x00B5, 0x00B5, d{743, 0, 743}},
	{0x00C0, 0x00D6, d{0, 32, 0}},
	{0x00D8, 0x00DE, d{0, 32, 0}},
	{0x00E0, 0x00F6, d{-32, 0, -32}},
	{0x00F8, 0x00FE, d{-32, 0, -32}},
	{0x00FF, 0x00FF, d{121, 0, 121}},
	{0x0100, 0x012F, d{UpperLower, UpperLower, UpperLower}},
	{0x0130, 0x0130, d{0, -199, 0}},
	{0x0131, 0x0131, d{-232, 0, -232}},
	{0x0132, 0x0137, d{UpperLower, UpperLower, UpperLower}},
	{0x0139, 0x0148, d{UpperLower, UpperLower, UpperLower}},
	{0x014A, 0x0177, d{UpperLower, UpperLower, UpperLower}},
	{0x0178, 0x0178, d{0, -121, 0}},
	{0x0179, 0x017E, d{UpperLower, UpperLower, UpperLower}},
	{0x017F, 0x017F, d{-300, 0, -300}},
	{0x0180, 0x0180, d{195, 0, 195}},
	{0x0181, 0x0181, d{0, 210, 0}},
	{0x0182, 0x0185, d{UpperLower, UpperLower, UpperLower}},
	{0x0186, 0x0186, d{0, 206, 0}},
	{0x0187, 0x0188, d{UpperLower, UpperLower, UpperLower}},
	{0x0189, 0x018A, d{0, 205, 0}},
	{0x018B, 0x018C, d{UpperLower, UpperLower, UpperLower}},
	{0x018E, 0x018E, d{0, 79, 0}},
	{0x018F, 0x018F, d{0, 202, 0}},
	{0x0190, 0x0190, d{0, 203, 0}},
	{0x0191, 0x0192, d{UpperLower, UpperLower, UpperLower}},
	{0x0193, 0x0193, d{0, 205, 0}},
	{0x0194, 0x0194, d{0, 207, 0}},
	{0x0195, 0x0195, d{97, 0, 97}},
	{0x0196, 0x0196, d{0, 211, 0}},
	{0x0197, 0x0197, d{0, 209, 0}},
	{0x0198, 0x0199, d{UpperLower, UpperLower, UpperLower}},
	{0x019A, 0x019A, d{163, 0, 163}},
	{0x019C, 0x019C, d{0, 211, 0}},
	{0x019D, 0x019D, d{0, 213, 0}},
	{0x019E, 0x019E, d{130, 0, 130}},
	{0x019F, 0x019F, d{0, 214, 0}},
	{0x01A0, 0x01A5, d{UpperLower, UpperLower, UpperLower}},
	{0x01A6, 0x01A6, d{0, 218, 0}},
	{0x01A7, 0x01A8, d{UpperLower, UpperLower, UpperLower}},
	{0x01A9, 0x01A9, d{0, 218, 0}},
	{0x01AC, 0x01AD, d{UpperLower, UpperLower, UpperLower}},
	{0x01AE, 0x01AE, d{0, 218, 0}},
	{0x01AF, 0x01B0, d{UpperLower, UpperLower, UpperLower}},
	{0x01B1, 0x01B2, d{0, 217, 0}},
	{0x01B3, 0x01B6, d{UpperLower, UpperLower, UpperLower}},
	{0x01B7, 0x01B7, d{0, 219, 0}},
	{0x01B8, 0x01B9, d{UpperLower, UpperLower, UpperLower}},
	{0x01BC, 0x01BD, d{UpperLower, UpperLower, UpperLower}},
	{0x01BF, 0x01BF, d{56, 0, 56}},
	{0x01C4, 0x01C4, d{0, 2, 1}},
	{0x01C5, 0x01C5, d{-1, 1, 0}},
	{0x01C6, 0x01C6, d{-2, 0, -1}},
	{0x01C7, 0x01C7, d{0, 2, 1}},
	{0x01C8, 0x01C8, d{-1, 1, 0}},
	{0x01C9, 0x01C9, d{-2, 0, -1}},
	{0x01CA, 0x01CA, d{0, 2, 1}},
	{0x01CB, 0x01CB, d{-1, 1, 0}},
	{0x01CC, 0x01CC, d{-2, 0, -1}},
	{0x01CD, 0x01DC, d{UpperLower, UpperLower, UpperLower}},
	{0x01DD, 0x01DD, d{-79, 0, -79}},
	{0x01DE, 0x01EF, d{UpperLower, UpperLower, UpperLower}},
	{0x01F1, 0x01F1, d{0, 2, 1}},
	{0x01F2, 0x01F2, d{-1, 1, 0}},
	{0x01F3, 0x01F3, d{-2, 0, -1}},
	{0x01F4, 0x01F5, d{UpperLower, UpperLower, UpperLower}},
	{0x01F6, 0x01F6, d{0, -97, 0}},
	{0x01F7, 0x01F7, d{0, -56, 0}},
	{0x01F8, 0x021F, d{UpperLower, UpperLower, UpperLower}},
	{0x0220, 0x0220, d{0, -130, 0}},
	{0x0222, 0x0233, d{UpperLower, UpperLower, UpperLower}},
	{0x023A, 0x023A, d{0, 10795, 0}},
	{0x023B, 0x023C, d{UpperLower, UpperLower, UpperLower}},
	{0x023D, 0x023D, d{0, -163, 0}},
	{0x023E, 0x023E, d{0, 10792, 0}},
	{0x023F, 0x0240, d{10815, 0, 10815}},
	{0x0241, 0x0242, d{UpperLower, UpperLower, UpperLower}},
	{0x0243, 0x0243, d{0, -195, 0}},
	{0x0244, 0x0244, d{0, 69, 0}},
	{0x0245, 0x0245, d{0, 71, 0}},
	{0x0246, 0x024F, d{UpperLower, UpperLower, UpperLower}},
	{0x0250, 0x0250, d{10783, 0, 10783}},
	{0x0251, 0x0251, d{10780, 0, 10780}},
	{0x0252, 0x0252, d{10782, 0, 10782}},
	{0x0253, 0x0253, d{-210, 0, -210}},
	{0x0254, 0x0254, d{-206, 0, -206}},
	{0x0256, 0x0257, d{-205, 0, -205}},
	{0x0259, 0x0259, d{-202, 0, -202}},
	{0x025B, 0x025B, d{-203, 0, -203}},
	{0x0260, 0x0260, d{-205, 0, -205}},
	{0x0263, 0x0263, d{-207, 0, -207}},
	{0x0265, 0x0265, d{42280, 0, 42280}},
	{0x0268, 0x0268, d{-209, 0, -209}},
	{0x0269, 0x0269, d{-211, 0, -211}},
	{0x026B, 0x026B, d{10743, 0, 10743}},
	{0x026F, 0x026F, d{-211, 0, -211}},
	{0x0271, 0x0271, d{10749, 0, 10749}},
	{0x0272, 0x0272, d{-213, 0, -213}},
	{0x0275, 0x0275, d{-214, 0, -214}},
	{0x027D, 0x027D, d{10727, 0, 10727}},
	{0x0280, 0x0280, d{-218, 0, -218}},
	{0x0283, 0x0283, d{-218, 0, -218}},
	{0x0288, 0x0288, d{-218, 0, -218}},
	{0x0289, 0x0289, d{-69, 0, -69}},
	{0x028A, 0x028B, d{-217, 0, -217}},
	{0x028C, 0x028C, d{-71, 0, -71}},
	{0x0292, 0x0292, d{-219, 0, -219}},
	{0x0345, 0x0345, d{84, 0, 84}},
	{0x0370, 0x0373, d{UpperLower, UpperLower, UpperLower}},
	{0x0376, 0x0377, d{UpperLower, UpperLower, UpperLower}},
	{0x037B, 0x037D, d{130, 0, 130}},
	{0x0386, 0x0386, d{0, 38, 0}},
	{0x0388, 0x038A, d{0, 37, 0}},
	{0x038C, 0x038C, d{0, 64, 0}},
	{0x038E, 0x038F, d{0, 63, 0}},
	{0x0391, 0x03A1, d{0, 32, 0}},
	{0x03A3, 0x03AB, d{0, 32, 0}},
	{0x03AC, 0x03AC, d{-38, 0, -38}},
	{0x03AD, 0x03AF, d{-37, 0, -37}},
	{0x03B1, 0x03C1, d{-32, 0, -32}},
	{0x03C2, 0x03C2, d{-31, 0, -31}},
	{0x03C3, 0x03CB, d{-32, 0, -32}},
	{0x03CC, 0x03CC, d{-64, 0, -64}},
	{0x03CD, 0x03CE, d{-63, 0, -63}},
	{0x03CF, 0x03CF, d{0, 8, 0}},
	{0x03D0, 0x03D0, d{-62, 0, -62}},
	{0x03D1, 0x03D1, d{-57, 0, -57}},
	{0x03D5, 0x03D5, d{-47, 0, -47}},
	{0x03D6, 0x03D6, d{-54, 0, -54}},
	{0x03D7, 0x03D7, d{-8, 0, -8}},
	{0x03D8, 0x03EF, d{UpperLower, UpperLower, UpperLower}},
	{0x03F0, 0x03F0, d{-86, 0, -86}},
	{0x03F1, 0x03F1, d{-80, 0, -80}},
	{0x03F2, 0x03F2, d{7, 0, 7}},
	{0x03F4, 0x03F4, d{0, -60, 0}},
	{0x03F5, 0x03F5, d{-96, 0, -96}},
	{0x03F7, 0x03F8, d{UpperLower, UpperLower, UpperLower}},
	{0x03F9, 0x03F9, d{0, -7, 0}},
	{0x03FA, 0x03FB, d{UpperLower, UpperLower, UpperLower}},
	{0x03FD, 0x03FF, d{0, -130, 0}},
	{0x0400, 0x040F, d{0, 80, 0}},
	{0x0410, 0x042F, d{0, 32, 0}},
	{0x0430, 0x044F, d{-32, 0, -32}},
	{0x0450, 0x045F, d{-80, 0, -80}},
	{0x0460, 0x0481, d{UpperLower, UpperLower, UpperLower}},
	{0x048A, 0x04BF, d{UpperLower, UpperLower, UpperLower}},
	{0x04C0, 0x04C0, d{0, 15, 0}},
	{0x04C1, 0x04CE, d{UpperLower, UpperLower, UpperLower}},
	{0x04CF, 0x04CF, d{-15, 0, -15}},
	{0x04D0, 0x0527, d{UpperLower, UpperLower, UpperLower}},
	{0x0531, 0x0556, d{0, 48, 0}},
	{0x0561, 0x0586, d{-48, 0, -48}},
	{0x10A0, 0x10C5, d{0, 7264, 0}},
	{0x1D79, 0x1D79, d{35332, 0, 35332}},
	{0x1D7D, 0x1D7D, d{3814, 0, 3814}},
	{0x1E00, 0x1E95, d{UpperLower, UpperLower, UpperLower}},
	{0x1E9B, 0x1E9B, d{-59, 0, -59}},
	{0x1E9E, 0x1E9E, d{0, -7615, 0}},
	{0x1EA0, 0x1EFF, d{UpperLower, UpperLower, UpperLower}},
	{0x1F00, 0x1F07, d{8, 0, 8}},
	{0x1F08, 0x1F0F, d{0, -8, 0}},
	{0x1F10, 0x1F15, d{8, 0, 8}},
	{0x1F18, 0x1F1D, d{0, -8, 0}},
	{0x1F20, 0x1F27, d{8, 0, 8}},
	{0x1F28, 0x1F2F, d{0, -8, 0}},
	{0x1F30, 0x1F37, d{8, 0, 8}},
	{0x1F38, 0x1F3F, d{0, -8, 0}},
	{0x1F40, 0x1F45, d{8, 0, 8}},
	{0x1F48, 0x1F4D, d{0, -8, 0}},
	{0x1F51, 0x1F51, d{8, 0, 8}},
	{0x1F53, 0x1F53, d{8, 0, 8}},
	{0x1F55, 0x1F55, d{8, 0, 8}},
	{0x1F57, 0x1F57, d{8, 0, 8}},
	{0x1F59, 0x1F59, d{0, -8, 0}},
	{0x1F5B, 0x1F5B, d{0, -8, 0}},
	{0x1F5D, 0x1F5D, d{0, -8, 0}},
	{0x1F5F, 0x1F5F, d{0, -8, 0}},
	{0x1F60, 0x1F67, d{8, 0, 8}},
	{0x1F68, 0x1F6F, d{0, -8, 0}},
	{0x1F70, 0x1F71, d{74, 0, 74}},
	{0x1F72, 0x1F75, d{86, 0, 86}},
	{0x1F76, 0x1F77, d{100, 0, 100}},
	{0x1F78, 0x1F79, d{128, 0, 128}},
	{0x1F7A, 0x1F7B, d{112, 0, 112}},
	{0x1F7C, 0x1F7D, d{126, 0, 126}},
	{0x1F80, 0x1F87, d{8, 0, 8}},
	{0x1F88, 0x1F8F, d{0, -8, 0}},
	{0x1F90, 0x1F97, d{8, 0, 8}},
	{0x1F98, 0x1F9F, d{0, -8, 0}},
	{0x1FA0, 0x1FA7, d{8, 0, 8}},
	{0x1FA8, 0x1FAF, d{0, -8, 0}},
	{0x1FB0, 0x1FB1, d{8, 0, 8}},
	{0x1FB3, 0x1FB3, d{9, 0, 9}},
	{0x1FB8, 0x1FB9, d{0, -8, 0}},
	{0x1FBA, 0x1FBB, d{0, -74, 0}},
	{0x1FBC, 0x1FBC, d{0, -9, 0}},
	{0x1FBE, 0x1FBE, d{-7205, 0, -7205}},
	{0x1FC3, 0x1FC3, d{9, 0, 9}},
	{0x1FC8, 0x1FCB, d{0, -86, 0}},
	{0x1FCC, 0x1FCC, d{0, -9, 0}},
	{0x1FD0, 0x1FD1, d{8, 0, 8}},
	{0x1FD8, 0x1FD9, d{0, -8, 0}},
	{0x1FDA, 0x1FDB, d{0, -100, 0}},
	{0x1FE0, 0x1FE1, d{8, 0, 8}},
	{0x1FE5, 0x1FE5, d{7, 0, 7}},
	{0x1FE8, 0x1FE9, d{0, -8, 0}},
	{0x1FEA, 0x1FEB, d{0, -112, 0}},
	{0x1FEC, 0x1FEC, d{0, -7, 0}},
	{0x1FF3, 0x1FF3, d{9, 0, 9}},
	{0x1FF8, 0x1FF9, d{0, -128, 0}},
	{0x1FFA, 0x1FFB, d{0, -126, 0}},
	{0x1FFC, 0x1FFC, d{0, -9, 0}},
	{0x2126, 0x2126, d{0, -7517, 0}},
	{0x212A, 0x212A, d{0, -8383, 0}},
	{0x212B, 0x212B, d{0, -8262, 0}},
	{0x2132, 0x2132, d{0, 28, 0}},
	{0x214E, 0x214E, d{-28, 0, -28}},
	{0x2160, 0x216F, d{0, 16, 0}},
	{0x2170, 0x217F, d{-16, 0, -16}},
	{0x2183, 0x2184, d{UpperLower, UpperLower, UpperLower}},
	{0x24B6, 0x24CF, d{0, 26, 0}},
	{0x24D0, 0x24E9, d{-26, 0, -26}},
	{0x2C00, 0x2C2E, d{0, 48, 0}},
	{0x2C30, 0x2C5E, d{-48, 0, -48}},
	{0x2C60, 0x2C61, d{UpperLower, UpperLower, UpperLower}},
	{0x2C62, 0x2C62, d{0, -10743, 0}},
	{0x2C63, 0x2C63, d{0, -3814, 0}},
	{0x2C64, 0x2C64, d{0, -10727, 0}},
	{0x2C65, 0x2C65, d{-10795, 0, -10795}},
	{0x2C66, 0x2C66, d{-10792, 0, -10792}},
	{0x2C67, 0x2C6C, d{UpperLower, UpperLower, UpperLower}},
	{0x2C6D, 0x2C6D, d{0, -10780, 0}},
	{0x2C6E, 0x2C6E, d{0, -10749, 0}},
	{0x2C6F, 0x2C6F, d{0, -10783, 0}},
	{0x2C70, 0x2C70, d{0, -10782, 0}},
	{0x2C72, 0x2C73, d{UpperLower, UpperLower, UpperLower}},
	{0x2C75, 0x2C76, d{UpperLower, UpperLower, UpperLower}},
	{0x2C7E, 0x2C7F, d{0, -10815, 0}},
	{0x2C80, 0x2CE3, d{UpperLower, UpperLower, UpperLower}},
	{0x2CEB, 0x2CEE, d{UpperLower, UpperLower, UpperLower}},
	{0x2D00, 0x2D25, d{-7264, 0, -7264}},
	{0xA640, 0xA66D, d{UpperLower, UpperLower, UpperLower}},
	{0xA680, 0xA697, d{UpperLower, UpperLower, UpperLower}},
	{0xA722, 0xA72F, d{UpperLower, UpperLower, UpperLower}},
	{0xA732, 0xA76F, d{UpperLower, UpperLower, UpperLower}},
	{0xA779, 0xA77C, d{UpperLower, UpperLower, UpperLower}},
	{0xA77D, 0xA77D, d{0, -35332, 0}},
	{0xA77E, 0xA787, d{UpperLower, UpperLower, UpperLower}},
	{0xA78B, 0xA78C, d{UpperLower, UpperLower, UpperLower}},
	{0xA78D, 0xA78D, d{0, -42280, 0}},
	{0xA790, 0xA791, d{UpperLower, UpperLower, UpperLower}},
	{0xA7A0, 0xA7A9, d{UpperLower, UpperLower, UpperLower}},
	{0xFF21, 0xFF3A, d{0, 32, 0}},
	{0xFF41, 0xFF5A, d{-32, 0, -32}},
	{0x10400, 0x10427, d{0, 40, 0}},
	{0x10428, 0x1044F, d{-40, 0, -40}},
}
var properties = [MaxLatin1 + 1]uint8{
	0x00: pC,       // '\x00'
	0x01: pC,       // '\x01'
	0x02: pC,       // '\x02'
	0x03: pC,       // '\x03'
	0x04: pC,       // '\x04'
	0x05: pC,       // '\x05'
	0x06: pC,       // '\x06'
	0x07: pC,       // '\a'
	0x08: pC,       // '\b'
	0x09: pC,       // '\t'
	0x0A: pC,       // '\n'
	0x0B: pC,       // '\v'
	0x0C: pC,       // '\f'
	0x0D: pC,       // '\r'
	0x0E: pC,       // '\x0e'
	0x0F: pC,       // '\x0f'
	0x10: pC,       // '\x10'
	0x11: pC,       // '\x11'
	0x12: pC,       // '\x12'
	0x13: pC,       // '\x13'
	0x14: pC,       // '\x14'
	0x15: pC,       // '\x15'
	0x16: pC,       // '\x16'
	0x17: pC,       // '\x17'
	0x18: pC,       // '\x18'
	0x19: pC,       // '\x19'
	0x1A: pC,       // '\x1a'
	0x1B: pC,       // '\x1b'
	0x1C: pC,       // '\x1c'
	0x1D: pC,       // '\x1d'
	0x1E: pC,       // '\x1e'
	0x1F: pC,       // '\x1f'
	0x20: pZ | pp,  // ' '
	0x21: pP | pp,  // '!'
	0x22: pP | pp,  // '"'
	0x23: pP | pp,  // '#'
	0x24: pS | pp,  // '$'
	0x25: pP | pp,  // '%'
	0x26: pP | pp,  // '&'
	0x27: pP | pp,  // '\''
	0x28: pP | pp,  // '('
	0x29: pP | pp,  // ')'
	0x2A: pP | pp,  // '*'
	0x2B: pS | pp,  // '+'
	0x2C: pP | pp,  // ','
	0x2D: pP | pp,  // '-'
	0x2E: pP | pp,  // '.'
	0x2F: pP | pp,  // '/'
	0x30: pN | pp,  // '0'
	0x31: pN | pp,  // '1'
	0x32: pN | pp,  // '2'
	0x33: pN | pp,  // '3'
	0x34: pN | pp,  // '4'
	0x35: pN | pp,  // '5'
	0x36: pN | pp,  // '6'
	0x37: pN | pp,  // '7'
	0x38: pN | pp,  // '8'
	0x39: pN | pp,  // '9'
	0x3A: pP | pp,  // ':'
	0x3B: pP | pp,  // ';'
	0x3C: pS | pp,  // '<'
	0x3D: pS | pp,  // '='
	0x3E: pS | pp,  // '>'
	0x3F: pP | pp,  // '?'
	0x40: pP | pp,  // '@'
	0x41: pLu | pp, // 'A'
	0x42: pLu | pp, // 'B'
	0x43: pLu | pp, // 'C'
	0x44: pLu | pp, // 'D'
	0x45: pLu | pp, // 'E'
	0x46: pLu | pp, // 'F'
	0x47: pLu | pp, // 'G'
	0x48: pLu | pp, // 'H'
	0x49: pLu | pp, // 'I'
	0x4A: pLu | pp, // 'J'
	0x4B: pLu | pp, // 'K'
	0x4C: pLu | pp, // 'L'
	0x4D: pLu | pp, // 'M'
	0x4E: pLu | pp, // 'N'
	0x4F: pLu | pp, // 'O'
	0x50: pLu | pp, // 'P'
	0x51: pLu | pp, // 'Q'
	0x52: pLu | pp, // 'R'
	0x53: pLu | pp, // 'S'
	0x54: pLu | pp, // 'T'
	0x55: pLu | pp, // 'U'
	0x56: pLu | pp, // 'V'
	0x57: pLu | pp, // 'W'
	0x58: pLu | pp, // 'X'
	0x59: pLu | pp, // 'Y'
	0x5A: pLu | pp, // 'Z'
	0x5B: pP | pp,  // '['
	0x5C: pP | pp,  // '\\'
	0x5D: pP | pp,  // ']'
	0x5E: pS | pp,  // '^'
	0x5F: pP | pp,  // '_'
	0x60: pS | pp,  // '`'
	0x61: pLl | pp, // 'a'
	0x62: pLl | pp, // 'b'
	0x63: pLl | pp, // 'c'
	0x64: pLl | pp, // 'd'
	0x65: pLl | pp, // 'e'
	0x66: pLl | pp, // 'f'
	0x67: pLl | pp, // 'g'
	0x68: pLl | pp, // 'h'
	0x69: pLl | pp, // 'i'
	0x6A: pLl | pp, // 'j'
	0x6B: pLl | pp, // 'k'
	0x6C: pLl | pp, // 'l'
	0x6D: pLl | pp, // 'm'
	0x6E: pLl | pp, // 'n'
	0x6F: pLl | pp, // 'o'
	0x70: pLl | pp, // 'p'
	0x71: pLl | pp, // 'q'
	0x72: pLl | pp, // 'r'
	0x73: pLl | pp, // 's'
	0x74: pLl | pp, // 't'
	0x75: pLl | pp, // 'u'
	0x76: pLl | pp, // 'v'
	0x77: pLl | pp, // 'w'
	0x78: pLl | pp, // 'x'
	0x79: pLl | pp, // 'y'
	0x7A: pLl | pp, // 'z'
	0x7B: pP | pp,  // '{'
	0x7C: pS | pp,  // '|'
	0x7D: pP | pp,  // '}'
	0x7E: pS | pp,  // '~'
	0x7F: pC,       // '\u007f'
	0x80: pC,       // '\u0080'
	0x81: pC,       // '\u0081'
	0x82: pC,       // '\u0082'
	0x83: pC,       // '\u0083'
	0x84: pC,       // '\u0084'
	0x85: pC,       // '\u0085'
	0x86: pC,       // '\u0086'
	0x87: pC,       // '\u0087'
	0x88: pC,       // '\u0088'
	0x89: pC,       // '\u0089'
	0x8A: pC,       // '\u008a'
	0x8B: pC,       // '\u008b'
	0x8C: pC,       // '\u008c'
	0x8D: pC,       // '\u008d'
	0x8E: pC,       // '\u008e'
	0x8F: pC,       // '\u008f'
	0x90: pC,       // '\u0090'
	0x91: pC,       // '\u0091'
	0x92: pC,       // '\u0092'
	0x93: pC,       // '\u0093'
	0x94: pC,       // '\u0094'
	0x95: pC,       // '\u0095'
	0x96: pC,       // '\u0096'
	0x97: pC,       // '\u0097'
	0x98: pC,       // '\u0098'
	0x99: pC,       // '\u0099'
	0x9A: pC,       // '\u009a'
	0x9B: pC,       // '\u009b'
	0x9C: pC,       // '\u009c'
	0x9D: pC,       // '\u009d'
	0x9E: pC,       // '\u009e'
	0x9F: pC,       // '\u009f'
	0xA0: pZ,       // '\u00a0'
	0xA1: pP | pp,  // '¡'
	0xA2: pS | pp,  // '¢'
	0xA3: pS | pp,  // '£'
	0xA4: pS | pp,  // '¤'
	0xA5: pS | pp,  // '¥'
	0xA6: pS | pp,  // '¦'
	0xA7: pS | pp,  // '§'
	0xA8: pS | pp,  // '¨'
	0xA9: pS | pp,  // '©'
	0xAA: pLl | pp, // 'ª'
	0xAB: pP | pp,  // '«'
	0xAC: pS | pp,  // '¬'
	0xAD: 0,        // '\u00ad'
	0xAE: pS | pp,  // '®'
	0xAF: pS | pp,  // '¯'
	0xB0: pS | pp,  // '°'
	0xB1: pS | pp,  // '±'
	0xB2: pN | pp,  // '²'
	0xB3: pN | pp,  // '³'
	0xB4: pS | pp,  // '´'
	0xB5: pLl | pp, // 'µ'
	0xB6: pS | pp,  // '¶'
	0xB7: pP | pp,  // '·'
	0xB8: pS | pp,  // '¸'
	0xB9: pN | pp,  // '¹'
	0xBA: pLl | pp, // 'º'
	0xBB: pP | pp,  // '»'
	0xBC: pN | pp,  // '¼'
	0xBD: pN | pp,  // '½'
	0xBE: pN | pp,  // '¾'
	0xBF: pP | pp,  // '¿'
	0xC0: pLu | pp, // 'À'
	0xC1: pLu | pp, // 'Á'
	0xC2: pLu | pp, // 'Â'
	0xC3: pLu | pp, // 'Ã'
	0xC4: pLu | pp, // 'Ä'
	0xC5: pLu | pp, // 'Å'
	0xC6: pLu | pp, // 'Æ'
	0xC7: pLu | pp, // 'Ç'
	0xC8: pLu | pp, // 'È'
	0xC9: pLu | pp, // 'É'
	0xCA: pLu | pp, // 'Ê'
	0xCB: pLu | pp, // 'Ë'
	0xCC: pLu | pp, // 'Ì'
	0xCD: pLu | pp, // 'Í'
	0xCE: pLu | pp, // 'Î'
	0xCF: pLu | pp, // 'Ï'
	0xD0: pLu | pp, // 'Ð'
	0xD1: pLu | pp, // 'Ñ'
	0xD2: pLu | pp, // 'Ò'
	0xD3: pLu | pp, // 'Ó'
	0xD4: pLu | pp, // 'Ô'
	0xD5: pLu | pp, // 'Õ'
	0xD6: pLu | pp, // 'Ö'
	0xD7: pS | pp,  // '×'
	0xD8: pLu | pp, // 'Ø'
	0xD9: pLu | pp, // 'Ù'
	0xDA: pLu | pp, // 'Ú'
	0xDB: pLu | pp, // 'Û'
	0xDC: pLu | pp, // 'Ü'
	0xDD: pLu | pp, // 'Ý'
	0xDE: pLu | pp, // 'Þ'
	0xDF: pLl | pp, // 'ß'
	0xE0: pLl | pp, // 'à'
	0xE1: pLl | pp, // 'á'
	0xE2: pLl | pp, // 'â'
	0xE3: pLl | pp, // 'ã'
	0xE4: pLl | pp, // 'ä'
	0xE5: pLl | pp, // 'å'
	0xE6: pLl | pp, // 'æ'
	0xE7: pLl | pp, // 'ç'
	0xE8: pLl | pp, // 'è'
	0xE9: pLl | pp, // 'é'
	0xEA: pLl | pp, // 'ê'
	0xEB: pLl | pp, // 'ë'
	0xEC: pLl | pp, // 'ì'
	0xED: pLl | pp, // 'í'
	0xEE: pLl | pp, // 'î'
	0xEF: pLl | pp, // 'ï'
	0xF0: pLl | pp, // 'ð'
	0xF1: pLl | pp, // 'ñ'
	0xF2: pLl | pp, // 'ò'
	0xF3: pLl | pp, // 'ó'
	0xF4: pLl | pp, // 'ô'
	0xF5: pLl | pp, // 'õ'
	0xF6: pLl | pp, // 'ö'
	0xF7: pS | pp,  // '÷'
	0xF8: pLl | pp, // 'ø'
	0xF9: pLl | pp, // 'ù'
	0xFA: pLl | pp, // 'ú'
	0xFB: pLl | pp, // 'û'
	0xFC: pLl | pp, // 'ü'
	0xFD: pLl | pp, // 'ý'
	0xFE: pLl | pp, // 'þ'
	0xFF: pLl | pp, // 'ÿ'
}

var caseOrbit = []foldPair{
	{0x004B, 0x006B},
	{0x0053, 0x0073},
	{0x006B, 0x212A},
	{0x0073, 0x017F},
	{0x00B5, 0x039C},
	{0x00C5, 0x00E5},
	{0x00DF, 0x1E9E},
	{0x00E5, 0x212B},
	{0x0130, 0x0130},
	{0x0131, 0x0131},
	{0x017F, 0x0053},
	{0x01C4, 0x01C5},
	{0x01C5, 0x01C6},
	{0x01C6, 0x01C4},
	{0x01C7, 0x01C8},
	{0x01C8, 0x01C9},
	{0x01C9, 0x01C7},
	{0x01CA, 0x01CB},
	{0x01CB, 0x01CC},
	{0x01CC, 0x01CA},
	{0x01F1, 0x01F2},
	{0x01F2, 0x01F3},
	{0x01F3, 0x01F1},
	{0x0345, 0x0399},
	{0x0392, 0x03B2},
	{0x0395, 0x03B5},
	{0x0398, 0x03B8},
	{0x0399, 0x03B9},
	{0x039A, 0x03BA},
	{0x039C, 0x03BC},
	{0x03A0, 0x03C0},
	{0x03A1, 0x03C1},
	{0x03A3, 0x03C2},
	{0x03A6, 0x03C6},
	{0x03A9, 0x03C9},
	{0x03B2, 0x03D0},
	{0x03B5, 0x03F5},
	{0x03B8, 0x03D1},
	{0x03B9, 0x1FBE},
	{0x03BA, 0x03F0},
	{0x03BC, 0x00B5},
	{0x03C0, 0x03D6},
	{0x03C1, 0x03F1},
	{0x03C2, 0x03C3},
	{0x03C3, 0x03A3},
	{0x03C6, 0x03D5},
	{0x03C9, 0x2126},
	{0x03D0, 0x0392},
	{0x03D1, 0x03F4},
	{0x03D5, 0x03A6},
	{0x03D6, 0x03A0},
	{0x03F0, 0x039A},
	{0x03F1, 0x03A1},
	{0x03F4, 0x0398},
	{0x03F5, 0x0395},
	{0x1E60, 0x1E61},
	{0x1E61, 0x1E9B},
	{0x1E9B, 0x1E60},
	{0x1E9E, 0x00DF},
	{0x1FBE, 0x0345},
	{0x2126, 0x03A9},
	{0x212A, 0x004B},
	{0x212B, 0x00C5},
}

// FoldCategory maps a category name to a table of
// code points outside the category that are equivalent under
// simple case folding to code points inside the category.
// If there is no entry for a category name, there are no such points.
var FoldCategory = map[string]*RangeTable{
	"Ll":        foldLl,
	"Inherited": foldInherited,
	"M":         foldM,
	"L":         foldL,
	"Mn":        foldMn,
	"Common":    foldCommon,
	"Greek":     foldGreek,
	"Lu":        foldLu,
	"Lt":        foldLt,
}

var foldLl = &RangeTable{
	R16: []Range16{
		{0x0041, 0x005a, 1},
		{0x00c0, 0x00d6, 1},
		{0x00d8, 0x00de, 1},
		{0x0100, 0x012e, 2},
		{0x0132, 0x0136, 2},
		{0x0139, 0x0147, 2},
		{0x014a, 0x0178, 2},
		{0x0179, 0x017d, 2},
		{0x0181, 0x0182, 1},
		{0x0184, 0x0186, 2},
		{0x0187, 0x0189, 2},
		{0x018a, 0x018b, 1},
		{0x018e, 0x0191, 1},
		{0x0193, 0x0194, 1},
		{0x0196, 0x0198, 1},
		{0x019c, 0x019d, 1},
		{0x019f, 0x01a0, 1},
		{0x01a2, 0x01a6, 2},
		{0x01a7, 0x01a9, 2},
		{0x01ac, 0x01ae, 2},
		{0x01af, 0x01b1, 2},
		{0x01b2, 0x01b3, 1},
		{0x01b5, 0x01b7, 2},
		{0x01b8, 0x01bc, 4},
		{0x01c4, 0x01c5, 1},
		{0x01c7, 0x01c8, 1},
		{0x01ca, 0x01cb, 1},
		{0x01cd, 0x01db, 2},
		{0x01de, 0x01ee, 2},
		{0x01f1, 0x01f2, 1},
		{0x01f4, 0x01f6, 2},
		{0x01f7, 0x01f8, 1},
		{0x01fa, 0x0232, 2},
		{0x023a, 0x023b, 1},
		{0x023d, 0x023e, 1},
		{0x0241, 0x0243, 2},
		{0x0244, 0x0246, 1},
		{0x0248, 0x024e, 2},
		{0x0345, 0x0370, 43},
		{0x0372, 0x0376, 4},
		{0x0386, 0x0388, 2},
		{0x0389, 0x038a, 1},
		{0x038c, 0x038e, 2},
		{0x038f, 0x0391, 2},
		{0x0392, 0x03a1, 1},
		{0x03a3, 0x03ab, 1},
		{0x03cf, 0x03d8, 9},
		{0x03da, 0x03ee, 2},
		{0x03f4, 0x03f7, 3},
		{0x03f9, 0x03fa, 1},
		{0x03fd, 0x042f, 1},
		{0x0460, 0x0480, 2},
		{0x048a, 0x04c0, 2},
		{0x04c1, 0x04cd, 2},
		{0x04d0, 0x0526, 2},
		{0x0531, 0x0556, 1},
		{0x10a0, 0x10c5, 1},
		{0x1e00, 0x1e94, 2},
		{0x1e9e, 0x1efe, 2},
		{0x1f08, 0x1f0f, 1},
		{0x1f18, 0x1f1d, 1},
		{0x1f28, 0x1f2f, 1},
		{0x1f38, 0x1f3f, 1},
		{0x1f48, 0x1f4d, 1},
		{0x1f59, 0x1f5f, 2},
		{0x1f68, 0x1f6f, 1},
		{0x1f88, 0x1f8f, 1},
		{0x1f98, 0x1f9f, 1},
		{0x1fa8, 0x1faf, 1},
		{0x1fb8, 0x1fbc, 1},
		{0x1fc8, 0x1fcc, 1},
		{0x1fd8, 0x1fdb, 1},
		{0x1fe8, 0x1fec, 1},
		{0x1ff8, 0x1ffc, 1},
		{0x2126, 0x212a, 4},
		{0x212b, 0x2132, 7},
		{0x2183, 0x2c00, 2685},
		{0x2c01, 0x2c2e, 1},
		{0x2c60, 0x2c62, 2},
		{0x2c63, 0x2c64, 1},
		{0x2c67, 0x2c6d, 2},
		{0x2c6e, 0x2c70, 1},
		{0x2c72, 0x2c75, 3},
		{0x2c7e, 0x2c80, 1},
		{0x2c82, 0x2ce2, 2},
		{0x2ceb, 0x2ced, 2},
		{0xa640, 0xa66c, 2},
		{0xa680, 0xa696, 2},
		{0xa722, 0xa72e, 2},
		{0xa732, 0xa76e, 2},
		{0xa779, 0xa77d, 2},
		{0xa77e, 0xa786, 2},
		{0xa78b, 0xa78d, 2},
		{0xa790, 0xa7a0, 16},
		{0xa7a2, 0xa7a8, 2},
		{0xff21, 0xff3a, 1},
	},
	R32: []Range32{
		{0x10400, 0x10427, 1},
	},
}

var foldInherited = &RangeTable{
	R16: []Range16{
		{0x0399, 0x03b9, 32},
		{0x1fbe, 0x1fbe, 1},
	},
}

var foldM = &RangeTable{
	R16: []Range16{
		{0x0399, 0x03b9, 32},
		{0x1fbe, 0x1fbe, 1},
	},
}

var foldL = &RangeTable{
	R16: []Range16{
		{0x0345, 0x0345, 1},
	},
}

var foldMn = &RangeTable{
	R16: []Range16{
		{0x0399, 0x03b9, 32},
		{0x1fbe, 0x1fbe, 1},
	},
}

var foldCommon = &RangeTable{
	R16: []Range16{
		{0x039c, 0x03bc, 32},
	},
}

var foldGreek = &RangeTable{
	R16: []Range16{
		{0x00b5, 0x0345, 656},
	},
}

var foldLu = &RangeTable{
	R16: []Range16{
		{0x0061, 0x007a, 1},
		{0x00b5, 0x00df, 42},
		{0x00e0, 0x00f6, 1},
		{0x00f8, 0x00ff, 1},
		{0x0101, 0x012f, 2},
		{0x0133, 0x0137, 2},
		{0x013a, 0x0148, 2},
		{0x014b, 0x0177, 2},
		{0x017a, 0x017e, 2},
		{0x017f, 0x0180, 1},
		{0x0183, 0x0185, 2},
		{0x0188, 0x018c, 4},
		{0x0192, 0x0195, 3},
		{0x0199, 0x019a, 1},
		{0x019e, 0x01a1, 3},
		{0x01a3, 0x01a5, 2},
		{0x01a8, 0x01ad, 5},
		{0x01b0, 0x01b4, 4},
		{0x01b6, 0x01b9, 3},
		{0x01bd, 0x01bf, 2},
		{0x01c5, 0x01c6, 1},
		{0x01c8, 0x01c9, 1},
		{0x01cb, 0x01cc, 1},
		{0x01ce, 0x01dc, 2},
		{0x01dd, 0x01ef, 2},
		{0x01f2, 0x01f3, 1},
		{0x01f5, 0x01f9, 4},
		{0x01fb, 0x021f, 2},
		{0x0223, 0x0233, 2},
		{0x023c, 0x023f, 3},
		{0x0240, 0x0242, 2},
		{0x0247, 0x024f, 2},
		{0x0250, 0x0254, 1},
		{0x0256, 0x0257, 1},
		{0x0259, 0x025b, 2},
		{0x0260, 0x0263, 3},
		{0x0265, 0x0268, 3},
		{0x0269, 0x026b, 2},
		{0x026f, 0x0271, 2},
		{0x0272, 0x0275, 3},
		{0x027d, 0x0283, 3},
		{0x0288, 0x028c, 1},
		{0x0292, 0x0345, 179},
		{0x0371, 0x0373, 2},
		{0x0377, 0x037b, 4},
		{0x037c, 0x037d, 1},
		{0x03ac, 0x03af, 1},
		{0x03b1, 0x03ce, 1},
		{0x03d0, 0x03d1, 1},
		{0x03d5, 0x03d7, 1},
		{0x03d9, 0x03ef, 2},
		{0x03f0, 0x03f2, 1},
		{0x03f5, 0x03fb, 3},
		{0x0430, 0x045f, 1},
		{0x0461, 0x0481, 2},
		{0x048b, 0x04bf, 2},
		{0x04c2, 0x04ce, 2},
		{0x04cf, 0x0527, 2},
		{0x0561, 0x0586, 1},
		{0x1d79, 0x1d7d, 4},
		{0x1e01, 0x1e95, 2},
		{0x1e9b, 0x1ea1, 6},
		{0x1ea3, 0x1eff, 2},
		{0x1f00, 0x1f07, 1},
		{0x1f10, 0x1f15, 1},
		{0x1f20, 0x1f27, 1},
		{0x1f30, 0x1f37, 1},
		{0x1f40, 0x1f45, 1},
		{0x1f51, 0x1f57, 2},
		{0x1f60, 0x1f67, 1},
		{0x1f70, 0x1f7d, 1},
		{0x1fb0, 0x1fb1, 1},
		{0x1fbe, 0x1fd0, 18},
		{0x1fd1, 0x1fe0, 15},
		{0x1fe1, 0x1fe5, 4},
		{0x214e, 0x2184, 54},
		{0x2c30, 0x2c5e, 1},
		{0x2c61, 0x2c65, 4},
		{0x2c66, 0x2c6c, 2},
		{0x2c73, 0x2c76, 3},
		{0x2c81, 0x2ce3, 2},
		{0x2cec, 0x2cee, 2},
		{0x2d00, 0x2d25, 1},
		{0xa641, 0xa66d, 2},
		{0xa681, 0xa697, 2},
		{0xa723, 0xa72f, 2},
		{0xa733, 0xa76f, 2},
		{0xa77a, 0xa77c, 2},
		{0xa77f, 0xa787, 2},
		{0xa78c, 0xa791, 5},
		{0xa7a1, 0xa7a9, 2},
		{0xff41, 0xff5a, 1},
	},
	R32: []Range32{
		{0x10428, 0x1044f, 1},
	},
}

var foldLt = &RangeTable{
	R16: []Range16{
		{0x01c4, 0x01c6, 2},
		{0x01c7, 0x01c9, 2},
		{0x01ca, 0x01cc, 2},
		{0x01f1, 0x01f3, 2},
		{0x1f80, 0x1f87, 1},
		{0x1f90, 0x1f97, 1},
		{0x1fa0, 0x1fa7, 1},
		{0x1fb3, 0x1fc3, 16},
		{0x1ff3, 0x1ff3, 1},
	},
}

// FoldScript maps a script name to a table of
// code points outside the script that are equivalent under
// simple case folding to code points inside the script.
// If there is no entry for a script name, there are no such points.
var FoldScript = map[string]*RangeTable{}

// Range entries: 3391 16-bit, 659 32-bit, 4050 total.
// Range bytes: 20346 16-bit, 7908 32-bit, 28254 total.

// Fold orbit bytes: 63 pairs, 252 bytes
