// # generated by cmplxdivide.c

package main

var tests = []Test{
	Test{cmplx(0, 0), cmplx(0, 0), cmplx(nan, nan)},
	Test{cmplx(0, 0), cmplx(0, 1), cmplx(0, 0)},
	Test{cmplx(0, 0), cmplx(0, -1), cmplx(negzero, 0)},
	Test{cmplx(0, 0), cmplx(0, 2), cmplx(0, 0)},
	Test{cmplx(0, 0), cmplx(0, nan), cmplx(nan, nan)},
	Test{cmplx(0, 0), cmplx(0, inf), cmplx(0, 0)},
	Test{cmplx(0, 0), cmplx(0, -inf), cmplx(negzero, 0)},
	Test{cmplx(0, 0), cmplx(1, 0), cmplx(0, 0)},
	Test{cmplx(0, 0), cmplx(1, 1), cmplx(0, 0)},
	Test{cmplx(0, 0), cmplx(1, -1), cmplx(0, 0)},
	Test{cmplx(0, 0), cmplx(1, 2), cmplx(0, 0)},
	Test{cmplx(0, 0), cmplx(1, nan), cmplx(nan, nan)},
	Test{cmplx(0, 0), cmplx(1, inf), cmplx(0, 0)},
	Test{cmplx(0, 0), cmplx(1, -inf), cmplx(negzero, 0)},
	Test{cmplx(0, 0), cmplx(-1, 0), cmplx(negzero, negzero)},
	Test{cmplx(0, 0), cmplx(-1, 1), cmplx(negzero, negzero)},
	Test{cmplx(0, 0), cmplx(-1, -1), cmplx(negzero, negzero)},
	Test{cmplx(0, 0), cmplx(-1, 2), cmplx(0, negzero)},
	Test{cmplx(0, 0), cmplx(-1, nan), cmplx(nan, nan)},
	Test{cmplx(0, 0), cmplx(-1, inf), cmplx(0, negzero)},
	Test{cmplx(0, 0), cmplx(-1, -inf), cmplx(negzero, negzero)},
	Test{cmplx(0, 0), cmplx(2, 0), cmplx(0, 0)},
	Test{cmplx(0, 0), cmplx(2, 1), cmplx(0, 0)},
	Test{cmplx(0, 0), cmplx(2, -1), cmplx(0, 0)},
	Test{cmplx(0, 0), cmplx(2, 2), cmplx(0, 0)},
	Test{cmplx(0, 0), cmplx(2, nan), cmplx(nan, nan)},
	Test{cmplx(0, 0), cmplx(2, inf), cmplx(0, 0)},
	Test{cmplx(0, 0), cmplx(2, -inf), cmplx(negzero, 0)},
	Test{cmplx(0, 0), cmplx(nan, 0), cmplx(nan, nan)},
	Test{cmplx(0, 0), cmplx(nan, 1), cmplx(nan, nan)},
	Test{cmplx(0, 0), cmplx(nan, -1), cmplx(nan, nan)},
	Test{cmplx(0, 0), cmplx(nan, 2), cmplx(nan, nan)},
	Test{cmplx(0, 0), cmplx(nan, nan), cmplx(nan, nan)},
	Test{cmplx(0, 0), cmplx(nan, inf), cmplx(0, 0)},
	Test{cmplx(0, 0), cmplx(nan, -inf), cmplx(0, 0)},
	Test{cmplx(0, 0), cmplx(inf, 0), cmplx(0, 0)},
	Test{cmplx(0, 0), cmplx(inf, 1), cmplx(0, 0)},
	Test{cmplx(0, 0), cmplx(inf, -1), cmplx(0, 0)},
	Test{cmplx(0, 0), cmplx(inf, 2), cmplx(0, 0)},
	Test{cmplx(0, 0), cmplx(inf, nan), cmplx(0, 0)},
	Test{cmplx(0, 0), cmplx(inf, inf), cmplx(0, 0)},
	Test{cmplx(0, 0), cmplx(inf, -inf), cmplx(0, 0)},
	Test{cmplx(0, 0), cmplx(-inf, 0), cmplx(negzero, negzero)},
	Test{cmplx(0, 0), cmplx(-inf, 1), cmplx(negzero, negzero)},
	Test{cmplx(0, 0), cmplx(-inf, -1), cmplx(negzero, negzero)},
	Test{cmplx(0, 0), cmplx(-inf, 2), cmplx(negzero, negzero)},
	Test{cmplx(0, 0), cmplx(-inf, nan), cmplx(0, negzero)},
	Test{cmplx(0, 0), cmplx(-inf, inf), cmplx(0, negzero)},
	Test{cmplx(0, 0), cmplx(-inf, -inf), cmplx(negzero, 0)},
	Test{cmplx(0, 1), cmplx(0, 0), cmplx(nan, inf)},
	Test{cmplx(0, 1), cmplx(0, 1), cmplx(1, 0)},
	Test{cmplx(0, 1), cmplx(0, -1), cmplx(-1, 0)},
	Test{cmplx(0, 1), cmplx(0, 2), cmplx(0.5, 0)},
	Test{cmplx(0, 1), cmplx(0, nan), cmplx(nan, nan)},
	Test{cmplx(0, 1), cmplx(0, inf), cmplx(0, 0)},
	Test{cmplx(0, 1), cmplx(0, -inf), cmplx(negzero, 0)},
	Test{cmplx(0, 1), cmplx(1, 0), cmplx(0, 1)},
	Test{cmplx(0, 1), cmplx(1, 1), cmplx(0.5, 0.5)},
	Test{cmplx(0, 1), cmplx(1, -1), cmplx(-0.5, 0.5)},
	Test{cmplx(0, 1), cmplx(1, 2), cmplx(0.4, 0.2)},
	Test{cmplx(0, 1), cmplx(1, nan), cmplx(nan, nan)},
	Test{cmplx(0, 1), cmplx(1, inf), cmplx(0, 0)},
	Test{cmplx(0, 1), cmplx(1, -inf), cmplx(negzero, 0)},
	Test{cmplx(0, 1), cmplx(-1, 0), cmplx(negzero, -1)},
	Test{cmplx(0, 1), cmplx(-1, 1), cmplx(0.5, -0.5)},
	Test{cmplx(0, 1), cmplx(-1, -1), cmplx(-0.5, -0.5)},
	Test{cmplx(0, 1), cmplx(-1, 2), cmplx(0.4, -0.2)},
	Test{cmplx(0, 1), cmplx(-1, nan), cmplx(nan, nan)},
	Test{cmplx(0, 1), cmplx(-1, inf), cmplx(0, negzero)},
	Test{cmplx(0, 1), cmplx(-1, -inf), cmplx(negzero, negzero)},
	Test{cmplx(0, 1), cmplx(2, 0), cmplx(0, 0.5)},
	Test{cmplx(0, 1), cmplx(2, 1), cmplx(0.2, 0.4)},
	Test{cmplx(0, 1), cmplx(2, -1), cmplx(-0.2, 0.4)},
	Test{cmplx(0, 1), cmplx(2, 2), cmplx(0.25, 0.25)},
	Test{cmplx(0, 1), cmplx(2, nan), cmplx(nan, nan)},
	Test{cmplx(0, 1), cmplx(2, inf), cmplx(0, 0)},
	Test{cmplx(0, 1), cmplx(2, -inf), cmplx(negzero, 0)},
	Test{cmplx(0, 1), cmplx(nan, 0), cmplx(nan, nan)},
	Test{cmplx(0, 1), cmplx(nan, 1), cmplx(nan, nan)},
	Test{cmplx(0, 1), cmplx(nan, -1), cmplx(nan, nan)},
	Test{cmplx(0, 1), cmplx(nan, 2), cmplx(nan, nan)},
	Test{cmplx(0, 1), cmplx(nan, nan), cmplx(nan, nan)},
	Test{cmplx(0, 1), cmplx(nan, inf), cmplx(0, 0)},
	Test{cmplx(0, 1), cmplx(nan, -inf), cmplx(negzero, 0)},
	Test{cmplx(0, 1), cmplx(inf, 0), cmplx(0, 0)},
	Test{cmplx(0, 1), cmplx(inf, 1), cmplx(0, 0)},
	Test{cmplx(0, 1), cmplx(inf, -1), cmplx(0, 0)},
	Test{cmplx(0, 1), cmplx(inf, 2), cmplx(0, 0)},
	Test{cmplx(0, 1), cmplx(inf, nan), cmplx(0, 0)},
	Test{cmplx(0, 1), cmplx(inf, inf), cmplx(0, 0)},
	Test{cmplx(0, 1), cmplx(inf, -inf), cmplx(negzero, 0)},
	Test{cmplx(0, 1), cmplx(-inf, 0), cmplx(negzero, negzero)},
	Test{cmplx(0, 1), cmplx(-inf, 1), cmplx(negzero, negzero)},
	Test{cmplx(0, 1), cmplx(-inf, -1), cmplx(negzero, negzero)},
	Test{cmplx(0, 1), cmplx(-inf, 2), cmplx(negzero, negzero)},
	Test{cmplx(0, 1), cmplx(-inf, nan), cmplx(0, negzero)},
	Test{cmplx(0, 1), cmplx(-inf, inf), cmplx(0, negzero)},
	Test{cmplx(0, 1), cmplx(-inf, -inf), cmplx(negzero, negzero)},
	Test{cmplx(0, -1), cmplx(0, 0), cmplx(nan, -inf)},
	Test{cmplx(0, -1), cmplx(0, 1), cmplx(-1, negzero)},
	Test{cmplx(0, -1), cmplx(0, -1), cmplx(1, negzero)},
	Test{cmplx(0, -1), cmplx(0, 2), cmplx(-0.5, negzero)},
	Test{cmplx(0, -1), cmplx(0, nan), cmplx(nan, nan)},
	Test{cmplx(0, -1), cmplx(0, inf), cmplx(negzero, negzero)},
	Test{cmplx(0, -1), cmplx(0, -inf), cmplx(0, negzero)},
	Test{cmplx(0, -1), cmplx(1, 0), cmplx(0, -1)},
	Test{cmplx(0, -1), cmplx(1, 1), cmplx(-0.5, -0.5)},
	Test{cmplx(0, -1), cmplx(1, -1), cmplx(0.5, -0.5)},
	Test{cmplx(0, -1), cmplx(1, 2), cmplx(-0.4, -0.2)},
	Test{cmplx(0, -1), cmplx(1, nan), cmplx(nan, nan)},
	Test{cmplx(0, -1), cmplx(1, inf), cmplx(negzero, negzero)},
	Test{cmplx(0, -1), cmplx(1, -inf), cmplx(0, negzero)},
	Test{cmplx(0, -1), cmplx(-1, 0), cmplx(negzero, 1)},
	Test{cmplx(0, -1), cmplx(-1, 1), cmplx(-0.5, 0.5)},
	Test{cmplx(0, -1), cmplx(-1, -1), cmplx(0.5, 0.5)},
	Test{cmplx(0, -1), cmplx(-1, 2), cmplx(-0.4, 0.2)},
	Test{cmplx(0, -1), cmplx(-1, nan), cmplx(nan, nan)},
	Test{cmplx(0, -1), cmplx(-1, inf), cmplx(negzero, 0)},
	Test{cmplx(0, -1), cmplx(-1, -inf), cmplx(0, 0)},
	Test{cmplx(0, -1), cmplx(2, 0), cmplx(0, -0.5)},
	Test{cmplx(0, -1), cmplx(2, 1), cmplx(-0.2, -0.4)},
	Test{cmplx(0, -1), cmplx(2, -1), cmplx(0.2, -0.4)},
	Test{cmplx(0, -1), cmplx(2, 2), cmplx(-0.25, -0.25)},
	Test{cmplx(0, -1), cmplx(2, nan), cmplx(nan, nan)},
	Test{cmplx(0, -1), cmplx(2, inf), cmplx(negzero, negzero)},
	Test{cmplx(0, -1), cmplx(2, -inf), cmplx(0, negzero)},
	Test{cmplx(0, -1), cmplx(nan, 0), cmplx(nan, nan)},
	Test{cmplx(0, -1), cmplx(nan, 1), cmplx(nan, nan)},
	Test{cmplx(0, -1), cmplx(nan, -1), cmplx(nan, nan)},
	Test{cmplx(0, -1), cmplx(nan, 2), cmplx(nan, nan)},
	Test{cmplx(0, -1), cmplx(nan, nan), cmplx(nan, nan)},
	Test{cmplx(0, -1), cmplx(nan, inf), cmplx(negzero, negzero)},
	Test{cmplx(0, -1), cmplx(nan, -inf), cmplx(0, 0)},
	Test{cmplx(0, -1), cmplx(inf, 0), cmplx(0, negzero)},
	Test{cmplx(0, -1), cmplx(inf, 1), cmplx(0, negzero)},
	Test{cmplx(0, -1), cmplx(inf, -1), cmplx(0, negzero)},
	Test{cmplx(0, -1), cmplx(inf, 2), cmplx(0, negzero)},
	Test{cmplx(0, -1), cmplx(inf, nan), cmplx(0, negzero)},
	Test{cmplx(0, -1), cmplx(inf, inf), cmplx(negzero, negzero)},
	Test{cmplx(0, -1), cmplx(inf, -inf), cmplx(0, negzero)},
	Test{cmplx(0, -1), cmplx(-inf, 0), cmplx(negzero, 0)},
	Test{cmplx(0, -1), cmplx(-inf, 1), cmplx(negzero, 0)},
	Test{cmplx(0, -1), cmplx(-inf, -1), cmplx(negzero, 0)},
	Test{cmplx(0, -1), cmplx(-inf, 2), cmplx(negzero, 0)},
	Test{cmplx(0, -1), cmplx(-inf, nan), cmplx(negzero, 0)},
	Test{cmplx(0, -1), cmplx(-inf, inf), cmplx(negzero, 0)},
	Test{cmplx(0, -1), cmplx(-inf, -inf), cmplx(0, 0)},
	Test{cmplx(0, 2), cmplx(0, 0), cmplx(nan, inf)},
	Test{cmplx(0, 2), cmplx(0, 1), cmplx(2, 0)},
	Test{cmplx(0, 2), cmplx(0, -1), cmplx(-2, 0)},
	Test{cmplx(0, 2), cmplx(0, 2), cmplx(1, 0)},
	Test{cmplx(0, 2), cmplx(0, nan), cmplx(nan, nan)},
	Test{cmplx(0, 2), cmplx(0, inf), cmplx(0, 0)},
	Test{cmplx(0, 2), cmplx(0, -inf), cmplx(negzero, 0)},
	Test{cmplx(0, 2), cmplx(1, 0), cmplx(0, 2)},
	Test{cmplx(0, 2), cmplx(1, 1), cmplx(1, 1)},
	Test{cmplx(0, 2), cmplx(1, -1), cmplx(-1, 1)},
	Test{cmplx(0, 2), cmplx(1, 2), cmplx(0.8, 0.4)},
	Test{cmplx(0, 2), cmplx(1, nan), cmplx(nan, nan)},
	Test{cmplx(0, 2), cmplx(1, inf), cmplx(0, 0)},
	Test{cmplx(0, 2), cmplx(1, -inf), cmplx(negzero, 0)},
	Test{cmplx(0, 2), cmplx(-1, 0), cmplx(negzero, -2)},
	Test{cmplx(0, 2), cmplx(-1, 1), cmplx(1, -1)},
	Test{cmplx(0, 2), cmplx(-1, -1), cmplx(-1, -1)},
	Test{cmplx(0, 2), cmplx(-1, 2), cmplx(0.8, -0.4)},
	Test{cmplx(0, 2), cmplx(-1, nan), cmplx(nan, nan)},
	Test{cmplx(0, 2), cmplx(-1, inf), cmplx(0, negzero)},
	Test{cmplx(0, 2), cmplx(-1, -inf), cmplx(negzero, negzero)},
	Test{cmplx(0, 2), cmplx(2, 0), cmplx(0, 1)},
	Test{cmplx(0, 2), cmplx(2, 1), cmplx(0.4, 0.8)},
	Test{cmplx(0, 2), cmplx(2, -1), cmplx(-0.4, 0.8)},
	Test{cmplx(0, 2), cmplx(2, 2), cmplx(0.5, 0.5)},
	Test{cmplx(0, 2), cmplx(2, nan), cmplx(nan, nan)},
	Test{cmplx(0, 2), cmplx(2, inf), cmplx(0, 0)},
	Test{cmplx(0, 2), cmplx(2, -inf), cmplx(negzero, 0)},
	Test{cmplx(0, 2), cmplx(nan, 0), cmplx(nan, nan)},
	Test{cmplx(0, 2), cmplx(nan, 1), cmplx(nan, nan)},
	Test{cmplx(0, 2), cmplx(nan, -1), cmplx(nan, nan)},
	Test{cmplx(0, 2), cmplx(nan, 2), cmplx(nan, nan)},
	Test{cmplx(0, 2), cmplx(nan, nan), cmplx(nan, nan)},
	Test{cmplx(0, 2), cmplx(nan, inf), cmplx(0, 0)},
	Test{cmplx(0, 2), cmplx(nan, -inf), cmplx(negzero, 0)},
	Test{cmplx(0, 2), cmplx(inf, 0), cmplx(0, 0)},
	Test{cmplx(0, 2), cmplx(inf, 1), cmplx(0, 0)},
	Test{cmplx(0, 2), cmplx(inf, -1), cmplx(0, 0)},
	Test{cmplx(0, 2), cmplx(inf, 2), cmplx(0, 0)},
	Test{cmplx(0, 2), cmplx(inf, nan), cmplx(0, 0)},
	Test{cmplx(0, 2), cmplx(inf, inf), cmplx(0, 0)},
	Test{cmplx(0, 2), cmplx(inf, -inf), cmplx(negzero, 0)},
	Test{cmplx(0, 2), cmplx(-inf, 0), cmplx(negzero, negzero)},
	Test{cmplx(0, 2), cmplx(-inf, 1), cmplx(negzero, negzero)},
	Test{cmplx(0, 2), cmplx(-inf, -1), cmplx(negzero, negzero)},
	Test{cmplx(0, 2), cmplx(-inf, 2), cmplx(negzero, negzero)},
	Test{cmplx(0, 2), cmplx(-inf, nan), cmplx(0, negzero)},
	Test{cmplx(0, 2), cmplx(-inf, inf), cmplx(0, negzero)},
	Test{cmplx(0, 2), cmplx(-inf, -inf), cmplx(negzero, negzero)},
	Test{cmplx(0, nan), cmplx(0, 0), cmplx(nan, nan)},
	Test{cmplx(0, nan), cmplx(0, 1), cmplx(nan, nan)},
	Test{cmplx(0, nan), cmplx(0, -1), cmplx(nan, nan)},
	Test{cmplx(0, nan), cmplx(0, 2), cmplx(nan, nan)},
	Test{cmplx(0, nan), cmplx(0, nan), cmplx(nan, nan)},
	Test{cmplx(0, nan), cmplx(0, inf), cmplx(nan, nan)},
	Test{cmplx(0, nan), cmplx(0, -inf), cmplx(nan, nan)},
	Test{cmplx(0, nan), cmplx(1, 0), cmplx(nan, nan)},
	Test{cmplx(0, nan), cmplx(1, 1), cmplx(nan, nan)},
	Test{cmplx(0, nan), cmplx(1, -1), cmplx(nan, nan)},
	Test{cmplx(0, nan), cmplx(1, 2), cmplx(nan, nan)},
	Test{cmplx(0, nan), cmplx(1, nan), cmplx(nan, nan)},
	Test{cmplx(0, nan), cmplx(1, inf), cmplx(nan, nan)},
	Test{cmplx(0, nan), cmplx(1, -inf), cmplx(nan, nan)},
	Test{cmplx(0, nan), cmplx(-1, 0), cmplx(nan, nan)},
	Test{cmplx(0, nan), cmplx(-1, 1), cmplx(nan, nan)},
	Test{cmplx(0, nan), cmplx(-1, -1), cmplx(nan, nan)},
	Test{cmplx(0, nan), cmplx(-1, 2), cmplx(nan, nan)},
	Test{cmplx(0, nan), cmplx(-1, nan), cmplx(nan, nan)},
	Test{cmplx(0, nan), cmplx(-1, inf), cmplx(nan, nan)},
	Test{cmplx(0, nan), cmplx(-1, -inf), cmplx(nan, nan)},
	Test{cmplx(0, nan), cmplx(2, 0), cmplx(nan, nan)},
	Test{cmplx(0, nan), cmplx(2, 1), cmplx(nan, nan)},
	Test{cmplx(0, nan), cmplx(2, -1), cmplx(nan, nan)},
	Test{cmplx(0, nan), cmplx(2, 2), cmplx(nan, nan)},
	Test{cmplx(0, nan), cmplx(2, nan), cmplx(nan, nan)},
	Test{cmplx(0, nan), cmplx(2, inf), cmplx(nan, nan)},
	Test{cmplx(0, nan), cmplx(2, -inf), cmplx(nan, nan)},
	Test{cmplx(0, nan), cmplx(nan, 0), cmplx(nan, nan)},
	Test{cmplx(0, nan), cmplx(nan, 1), cmplx(nan, nan)},
	Test{cmplx(0, nan), cmplx(nan, -1), cmplx(nan, nan)},
	Test{cmplx(0, nan), cmplx(nan, 2), cmplx(nan, nan)},
	Test{cmplx(0, nan), cmplx(nan, nan), cmplx(nan, nan)},
	Test{cmplx(0, nan), cmplx(nan, inf), cmplx(nan, nan)},
	Test{cmplx(0, nan), cmplx(nan, -inf), cmplx(nan, nan)},
	Test{cmplx(0, nan), cmplx(inf, 0), cmplx(nan, nan)},
	Test{cmplx(0, nan), cmplx(inf, 1), cmplx(nan, nan)},
	Test{cmplx(0, nan), cmplx(inf, -1), cmplx(nan, nan)},
	Test{cmplx(0, nan), cmplx(inf, 2), cmplx(nan, nan)},
	Test{cmplx(0, nan), cmplx(inf, nan), cmplx(nan, nan)},
	Test{cmplx(0, nan), cmplx(inf, inf), cmplx(nan, nan)},
	Test{cmplx(0, nan), cmplx(inf, -inf), cmplx(nan, nan)},
	Test{cmplx(0, nan), cmplx(-inf, 0), cmplx(nan, nan)},
	Test{cmplx(0, nan), cmplx(-inf, 1), cmplx(nan, nan)},
	Test{cmplx(0, nan), cmplx(-inf, -1), cmplx(nan, nan)},
	Test{cmplx(0, nan), cmplx(-inf, 2), cmplx(nan, nan)},
	Test{cmplx(0, nan), cmplx(-inf, nan), cmplx(nan, nan)},
	Test{cmplx(0, nan), cmplx(-inf, inf), cmplx(nan, nan)},
	Test{cmplx(0, nan), cmplx(-inf, -inf), cmplx(nan, nan)},
	Test{cmplx(0, inf), cmplx(0, 0), cmplx(nan, inf)},
	Test{cmplx(0, inf), cmplx(0, 1), cmplx(inf, nan)},
	Test{cmplx(0, inf), cmplx(0, -1), cmplx(-inf, nan)},
	Test{cmplx(0, inf), cmplx(0, 2), cmplx(inf, nan)},
	Test{cmplx(0, inf), cmplx(0, nan), cmplx(nan, nan)},
	Test{cmplx(0, inf), cmplx(0, inf), cmplx(nan, nan)},
	Test{cmplx(0, inf), cmplx(0, -inf), cmplx(nan, nan)},
	Test{cmplx(0, inf), cmplx(1, 0), cmplx(nan, inf)},
	Test{cmplx(0, inf), cmplx(1, 1), cmplx(inf, inf)},
	Test{cmplx(0, inf), cmplx(1, -1), cmplx(-inf, inf)},
	Test{cmplx(0, inf), cmplx(1, 2), cmplx(inf, inf)},
	Test{cmplx(0, inf), cmplx(1, nan), cmplx(nan, nan)},
	Test{cmplx(0, inf), cmplx(1, inf), cmplx(nan, nan)},
	Test{cmplx(0, inf), cmplx(1, -inf), cmplx(nan, nan)},
	Test{cmplx(0, inf), cmplx(-1, 0), cmplx(nan, -inf)},
	Test{cmplx(0, inf), cmplx(-1, 1), cmplx(inf, -inf)},
	Test{cmplx(0, inf), cmplx(-1, -1), cmplx(-inf, -inf)},
	Test{cmplx(0, inf), cmplx(-1, 2), cmplx(inf, -inf)},
	Test{cmplx(0, inf), cmplx(-1, nan), cmplx(nan, nan)},
	Test{cmplx(0, inf), cmplx(-1, inf), cmplx(nan, nan)},
	Test{cmplx(0, inf), cmplx(-1, -inf), cmplx(nan, nan)},
	Test{cmplx(0, inf), cmplx(2, 0), cmplx(nan, inf)},
	Test{cmplx(0, inf), cmplx(2, 1), cmplx(inf, inf)},
	Test{cmplx(0, inf), cmplx(2, -1), cmplx(-inf, inf)},
	Test{cmplx(0, inf), cmplx(2, 2), cmplx(inf, inf)},
	Test{cmplx(0, inf), cmplx(2, nan), cmplx(nan, nan)},
	Test{cmplx(0, inf), cmplx(2, inf), cmplx(nan, nan)},
	Test{cmplx(0, inf), cmplx(2, -inf), cmplx(nan, nan)},
	Test{cmplx(0, inf), cmplx(nan, 0), cmplx(nan, nan)},
	Test{cmplx(0, inf), cmplx(nan, 1), cmplx(nan, nan)},
	Test{cmplx(0, inf), cmplx(nan, -1), cmplx(nan, nan)},
	Test{cmplx(0, inf), cmplx(nan, 2), cmplx(nan, nan)},
	Test{cmplx(0, inf), cmplx(nan, nan), cmplx(nan, nan)},
	Test{cmplx(0, inf), cmplx(nan, inf), cmplx(nan, nan)},
	Test{cmplx(0, inf), cmplx(nan, -inf), cmplx(nan, nan)},
	Test{cmplx(0, inf), cmplx(inf, 0), cmplx(nan, nan)},
	Test{cmplx(0, inf), cmplx(inf, 1), cmplx(nan, nan)},
	Test{cmplx(0, inf), cmplx(inf, -1), cmplx(nan, nan)},
	Test{cmplx(0, inf), cmplx(inf, 2), cmplx(nan, nan)},
	Test{cmplx(0, inf), cmplx(inf, nan), cmplx(nan, nan)},
	Test{cmplx(0, inf), cmplx(inf, inf), cmplx(nan, nan)},
	Test{cmplx(0, inf), cmplx(inf, -inf), cmplx(nan, nan)},
	Test{cmplx(0, inf), cmplx(-inf, 0), cmplx(nan, nan)},
	Test{cmplx(0, inf), cmplx(-inf, 1), cmplx(nan, nan)},
	Test{cmplx(0, inf), cmplx(-inf, -1), cmplx(nan, nan)},
	Test{cmplx(0, inf), cmplx(-inf, 2), cmplx(nan, nan)},
	Test{cmplx(0, inf), cmplx(-inf, nan), cmplx(nan, nan)},
	Test{cmplx(0, inf), cmplx(-inf, inf), cmplx(nan, nan)},
	Test{cmplx(0, inf), cmplx(-inf, -inf), cmplx(nan, nan)},
	Test{cmplx(0, -inf), cmplx(0, 0), cmplx(nan, -inf)},
	Test{cmplx(0, -inf), cmplx(0, 1), cmplx(-inf, nan)},
	Test{cmplx(0, -inf), cmplx(0, -1), cmplx(inf, nan)},
	Test{cmplx(0, -inf), cmplx(0, 2), cmplx(-inf, nan)},
	Test{cmplx(0, -inf), cmplx(0, nan), cmplx(nan, nan)},
	Test{cmplx(0, -inf), cmplx(0, inf), cmplx(nan, nan)},
	Test{cmplx(0, -inf), cmplx(0, -inf), cmplx(nan, nan)},
	Test{cmplx(0, -inf), cmplx(1, 0), cmplx(nan, -inf)},
	Test{cmplx(0, -inf), cmplx(1, 1), cmplx(-inf, -inf)},
	Test{cmplx(0, -inf), cmplx(1, -1), cmplx(inf, -inf)},
	Test{cmplx(0, -inf), cmplx(1, 2), cmplx(-inf, -inf)},
	Test{cmplx(0, -inf), cmplx(1, nan), cmplx(nan, nan)},
	Test{cmplx(0, -inf), cmplx(1, inf), cmplx(nan, nan)},
	Test{cmplx(0, -inf), cmplx(1, -inf), cmplx(nan, nan)},
	Test{cmplx(0, -inf), cmplx(-1, 0), cmplx(nan, inf)},
	Test{cmplx(0, -inf), cmplx(-1, 1), cmplx(-inf, inf)},
	Test{cmplx(0, -inf), cmplx(-1, -1), cmplx(inf, inf)},
	Test{cmplx(0, -inf), cmplx(-1, 2), cmplx(-inf, inf)},
	Test{cmplx(0, -inf), cmplx(-1, nan), cmplx(nan, nan)},
	Test{cmplx(0, -inf), cmplx(-1, inf), cmplx(nan, nan)},
	Test{cmplx(0, -inf), cmplx(-1, -inf), cmplx(nan, nan)},
	Test{cmplx(0, -inf), cmplx(2, 0), cmplx(nan, -inf)},
	Test{cmplx(0, -inf), cmplx(2, 1), cmplx(-inf, -inf)},
	Test{cmplx(0, -inf), cmplx(2, -1), cmplx(inf, -inf)},
	Test{cmplx(0, -inf), cmplx(2, 2), cmplx(-inf, -inf)},
	Test{cmplx(0, -inf), cmplx(2, nan), cmplx(nan, nan)},
	Test{cmplx(0, -inf), cmplx(2, inf), cmplx(nan, nan)},
	Test{cmplx(0, -inf), cmplx(2, -inf), cmplx(nan, nan)},
	Test{cmplx(0, -inf), cmplx(nan, 0), cmplx(nan, nan)},
	Test{cmplx(0, -inf), cmplx(nan, 1), cmplx(nan, nan)},
	Test{cmplx(0, -inf), cmplx(nan, -1), cmplx(nan, nan)},
	Test{cmplx(0, -inf), cmplx(nan, 2), cmplx(nan, nan)},
	Test{cmplx(0, -inf), cmplx(nan, nan), cmplx(nan, nan)},
	Test{cmplx(0, -inf), cmplx(nan, inf), cmplx(nan, nan)},
	Test{cmplx(0, -inf), cmplx(nan, -inf), cmplx(nan, nan)},
	Test{cmplx(0, -inf), cmplx(inf, 0), cmplx(nan, nan)},
	Test{cmplx(0, -inf), cmplx(inf, 1), cmplx(nan, nan)},
	Test{cmplx(0, -inf), cmplx(inf, -1), cmplx(nan, nan)},
	Test{cmplx(0, -inf), cmplx(inf, 2), cmplx(nan, nan)},
	Test{cmplx(0, -inf), cmplx(inf, nan), cmplx(nan, nan)},
	Test{cmplx(0, -inf), cmplx(inf, inf), cmplx(nan, nan)},
	Test{cmplx(0, -inf), cmplx(inf, -inf), cmplx(nan, nan)},
	Test{cmplx(0, -inf), cmplx(-inf, 0), cmplx(nan, nan)},
	Test{cmplx(0, -inf), cmplx(-inf, 1), cmplx(nan, nan)},
	Test{cmplx(0, -inf), cmplx(-inf, -1), cmplx(nan, nan)},
	Test{cmplx(0, -inf), cmplx(-inf, 2), cmplx(nan, nan)},
	Test{cmplx(0, -inf), cmplx(-inf, nan), cmplx(nan, nan)},
	Test{cmplx(0, -inf), cmplx(-inf, inf), cmplx(nan, nan)},
	Test{cmplx(0, -inf), cmplx(-inf, -inf), cmplx(nan, nan)},
	Test{cmplx(1, 0), cmplx(0, 0), cmplx(inf, nan)},
	Test{cmplx(1, 0), cmplx(0, 1), cmplx(0, -1)},
	Test{cmplx(1, 0), cmplx(0, -1), cmplx(negzero, 1)},
	Test{cmplx(1, 0), cmplx(0, 2), cmplx(0, -0.5)},
	Test{cmplx(1, 0), cmplx(0, nan), cmplx(nan, nan)},
	Test{cmplx(1, 0), cmplx(0, inf), cmplx(0, negzero)},
	Test{cmplx(1, 0), cmplx(0, -inf), cmplx(negzero, 0)},
	Test{cmplx(1, 0), cmplx(1, 0), cmplx(1, 0)},
	Test{cmplx(1, 0), cmplx(1, 1), cmplx(0.5, -0.5)},
	Test{cmplx(1, 0), cmplx(1, -1), cmplx(0.5, 0.5)},
	Test{cmplx(1, 0), cmplx(1, 2), cmplx(0.2, -0.4)},
	Test{cmplx(1, 0), cmplx(1, nan), cmplx(nan, nan)},
	Test{cmplx(1, 0), cmplx(1, inf), cmplx(0, negzero)},
	Test{cmplx(1, 0), cmplx(1, -inf), cmplx(negzero, 0)},
	Test{cmplx(1, 0), cmplx(-1, 0), cmplx(-1, negzero)},
	Test{cmplx(1, 0), cmplx(-1, 1), cmplx(-0.5, -0.5)},
	Test{cmplx(1, 0), cmplx(-1, -1), cmplx(-0.5, 0.5)},
	Test{cmplx(1, 0), cmplx(-1, 2), cmplx(-0.2, -0.4)},
	Test{cmplx(1, 0), cmplx(-1, nan), cmplx(nan, nan)},
	Test{cmplx(1, 0), cmplx(-1, inf), cmplx(0, negzero)},
	Test{cmplx(1, 0), cmplx(-1, -inf), cmplx(negzero, 0)},
	Test{cmplx(1, 0), cmplx(2, 0), cmplx(0.5, 0)},
	Test{cmplx(1, 0), cmplx(2, 1), cmplx(0.4, -0.2)},
	Test{cmplx(1, 0), cmplx(2, -1), cmplx(0.4, 0.2)},
	Test{cmplx(1, 0), cmplx(2, 2), cmplx(0.25, -0.25)},
	Test{cmplx(1, 0), cmplx(2, nan), cmplx(nan, nan)},
	Test{cmplx(1, 0), cmplx(2, inf), cmplx(0, negzero)},
	Test{cmplx(1, 0), cmplx(2, -inf), cmplx(negzero, 0)},
	Test{cmplx(1, 0), cmplx(nan, 0), cmplx(nan, nan)},
	Test{cmplx(1, 0), cmplx(nan, 1), cmplx(nan, nan)},
	Test{cmplx(1, 0), cmplx(nan, -1), cmplx(nan, nan)},
	Test{cmplx(1, 0), cmplx(nan, 2), cmplx(nan, nan)},
	Test{cmplx(1, 0), cmplx(nan, nan), cmplx(nan, nan)},
	Test{cmplx(1, 0), cmplx(nan, inf), cmplx(0, negzero)},
	Test{cmplx(1, 0), cmplx(nan, -inf), cmplx(0, 0)},
	Test{cmplx(1, 0), cmplx(inf, 0), cmplx(0, 0)},
	Test{cmplx(1, 0), cmplx(inf, 1), cmplx(0, 0)},
	Test{cmplx(1, 0), cmplx(inf, -1), cmplx(0, 0)},
	Test{cmplx(1, 0), cmplx(inf, 2), cmplx(0, 0)},
	Test{cmplx(1, 0), cmplx(inf, nan), cmplx(0, 0)},
	Test{cmplx(1, 0), cmplx(inf, inf), cmplx(0, negzero)},
	Test{cmplx(1, 0), cmplx(inf, -inf), cmplx(0, 0)},
	Test{cmplx(1, 0), cmplx(-inf, 0), cmplx(negzero, negzero)},
	Test{cmplx(1, 0), cmplx(-inf, 1), cmplx(negzero, negzero)},
	Test{cmplx(1, 0), cmplx(-inf, -1), cmplx(negzero, negzero)},
	Test{cmplx(1, 0), cmplx(-inf, 2), cmplx(negzero, negzero)},
	Test{cmplx(1, 0), cmplx(-inf, nan), cmplx(negzero, negzero)},
	Test{cmplx(1, 0), cmplx(-inf, inf), cmplx(negzero, negzero)},
	Test{cmplx(1, 0), cmplx(-inf, -inf), cmplx(negzero, 0)},
	Test{cmplx(1, 1), cmplx(0, 0), cmplx(inf, inf)},
	Test{cmplx(1, 1), cmplx(0, 1), cmplx(1, -1)},
	Test{cmplx(1, 1), cmplx(0, -1), cmplx(-1, 1)},
	Test{cmplx(1, 1), cmplx(0, 2), cmplx(0.5, -0.5)},
	Test{cmplx(1, 1), cmplx(0, nan), cmplx(nan, nan)},
	Test{cmplx(1, 1), cmplx(0, inf), cmplx(0, negzero)},
	Test{cmplx(1, 1), cmplx(0, -inf), cmplx(negzero, 0)},
	Test{cmplx(1, 1), cmplx(1, 0), cmplx(1, 1)},
	Test{cmplx(1, 1), cmplx(1, 1), cmplx(1, 0)},
	Test{cmplx(1, 1), cmplx(1, -1), cmplx(0, 1)},
	Test{cmplx(1, 1), cmplx(1, 2), cmplx(0.6, -0.2)},
	Test{cmplx(1, 1), cmplx(1, nan), cmplx(nan, nan)},
	Test{cmplx(1, 1), cmplx(1, inf), cmplx(0, negzero)},
	Test{cmplx(1, 1), cmplx(1, -inf), cmplx(negzero, 0)},
	Test{cmplx(1, 1), cmplx(-1, 0), cmplx(-1, -1)},
	Test{cmplx(1, 1), cmplx(-1, 1), cmplx(negzero, -1)},
	Test{cmplx(1, 1), cmplx(-1, -1), cmplx(-1, negzero)},
	Test{cmplx(1, 1), cmplx(-1, 2), cmplx(0.2, -0.6)},
	Test{cmplx(1, 1), cmplx(-1, nan), cmplx(nan, nan)},
	Test{cmplx(1, 1), cmplx(-1, inf), cmplx(0, negzero)},
	Test{cmplx(1, 1), cmplx(-1, -inf), cmplx(negzero, 0)},
	Test{cmplx(1, 1), cmplx(2, 0), cmplx(0.5, 0.5)},
	Test{cmplx(1, 1), cmplx(2, 1), cmplx(0.6, 0.2)},
	Test{cmplx(1, 1), cmplx(2, -1), cmplx(0.2, 0.6)},
	Test{cmplx(1, 1), cmplx(2, 2), cmplx(0.5, 0)},
	Test{cmplx(1, 1), cmplx(2, nan), cmplx(nan, nan)},
	Test{cmplx(1, 1), cmplx(2, inf), cmplx(0, negzero)},
	Test{cmplx(1, 1), cmplx(2, -inf), cmplx(negzero, 0)},
	Test{cmplx(1, 1), cmplx(nan, 0), cmplx(nan, nan)},
	Test{cmplx(1, 1), cmplx(nan, 1), cmplx(nan, nan)},
	Test{cmplx(1, 1), cmplx(nan, -1), cmplx(nan, nan)},
	Test{cmplx(1, 1), cmplx(nan, 2), cmplx(nan, nan)},
	Test{cmplx(1, 1), cmplx(nan, nan), cmplx(nan, nan)},
	Test{cmplx(1, 1), cmplx(nan, inf), cmplx(0, negzero)},
	Test{cmplx(1, 1), cmplx(nan, -inf), cmplx(negzero, 0)},
	Test{cmplx(1, 1), cmplx(inf, 0), cmplx(0, 0)},
	Test{cmplx(1, 1), cmplx(inf, 1), cmplx(0, 0)},
	Test{cmplx(1, 1), cmplx(inf, -1), cmplx(0, 0)},
	Test{cmplx(1, 1), cmplx(inf, 2), cmplx(0, 0)},
	Test{cmplx(1, 1), cmplx(inf, nan), cmplx(0, 0)},
	Test{cmplx(1, 1), cmplx(inf, inf), cmplx(0, 0)},
	Test{cmplx(1, 1), cmplx(inf, -inf), cmplx(0, 0)},
	Test{cmplx(1, 1), cmplx(-inf, 0), cmplx(negzero, negzero)},
	Test{cmplx(1, 1), cmplx(-inf, 1), cmplx(negzero, negzero)},
	Test{cmplx(1, 1), cmplx(-inf, -1), cmplx(negzero, negzero)},
	Test{cmplx(1, 1), cmplx(-inf, 2), cmplx(negzero, negzero)},
	Test{cmplx(1, 1), cmplx(-inf, nan), cmplx(negzero, negzero)},
	Test{cmplx(1, 1), cmplx(-inf, inf), cmplx(0, negzero)},
	Test{cmplx(1, 1), cmplx(-inf, -inf), cmplx(negzero, 0)},
	Test{cmplx(1, -1), cmplx(0, 0), cmplx(inf, -inf)},
	Test{cmplx(1, -1), cmplx(0, 1), cmplx(-1, -1)},
	Test{cmplx(1, -1), cmplx(0, -1), cmplx(1, 1)},
	Test{cmplx(1, -1), cmplx(0, 2), cmplx(-0.5, -0.5)},
	Test{cmplx(1, -1), cmplx(0, nan), cmplx(nan, nan)},
	Test{cmplx(1, -1), cmplx(0, inf), cmplx(negzero, negzero)},
	Test{cmplx(1, -1), cmplx(0, -inf), cmplx(0, 0)},
	Test{cmplx(1, -1), cmplx(1, 0), cmplx(1, -1)},
	Test{cmplx(1, -1), cmplx(1, 1), cmplx(0, -1)},
	Test{cmplx(1, -1), cmplx(1, -1), cmplx(1, 0)},
	Test{cmplx(1, -1), cmplx(1, 2), cmplx(-0.2, -0.6)},
	Test{cmplx(1, -1), cmplx(1, nan), cmplx(nan, nan)},
	Test{cmplx(1, -1), cmplx(1, inf), cmplx(negzero, negzero)},
	Test{cmplx(1, -1), cmplx(1, -inf), cmplx(0, 0)},
	Test{cmplx(1, -1), cmplx(-1, 0), cmplx(-1, 1)},
	Test{cmplx(1, -1), cmplx(-1, 1), cmplx(-1, negzero)},
	Test{cmplx(1, -1), cmplx(-1, -1), cmplx(negzero, 1)},
	Test{cmplx(1, -1), cmplx(-1, 2), cmplx(-0.6, -0.2)},
	Test{cmplx(1, -1), cmplx(-1, nan), cmplx(nan, nan)},
	Test{cmplx(1, -1), cmplx(-1, inf), cmplx(negzero, negzero)},
	Test{cmplx(1, -1), cmplx(-1, -inf), cmplx(0, 0)},
	Test{cmplx(1, -1), cmplx(2, 0), cmplx(0.5, -0.5)},
	Test{cmplx(1, -1), cmplx(2, 1), cmplx(0.2, -0.6)},
	Test{cmplx(1, -1), cmplx(2, -1), cmplx(0.6, -0.2)},
	Test{cmplx(1, -1), cmplx(2, 2), cmplx(0, -0.5)},
	Test{cmplx(1, -1), cmplx(2, nan), cmplx(nan, nan)},
	Test{cmplx(1, -1), cmplx(2, inf), cmplx(negzero, negzero)},
	Test{cmplx(1, -1), cmplx(2, -inf), cmplx(0, 0)},
	Test{cmplx(1, -1), cmplx(nan, 0), cmplx(nan, nan)},
	Test{cmplx(1, -1), cmplx(nan, 1), cmplx(nan, nan)},
	Test{cmplx(1, -1), cmplx(nan, -1), cmplx(nan, nan)},
	Test{cmplx(1, -1), cmplx(nan, 2), cmplx(nan, nan)},
	Test{cmplx(1, -1), cmplx(nan, nan), cmplx(nan, nan)},
	Test{cmplx(1, -1), cmplx(nan, inf), cmplx(negzero, negzero)},
	Test{cmplx(1, -1), cmplx(nan, -inf), cmplx(0, 0)},
	Test{cmplx(1, -1), cmplx(inf, 0), cmplx(0, negzero)},
	Test{cmplx(1, -1), cmplx(inf, 1), cmplx(0, negzero)},
	Test{cmplx(1, -1), cmplx(inf, -1), cmplx(0, negzero)},
	Test{cmplx(1, -1), cmplx(inf, 2), cmplx(0, negzero)},
	Test{cmplx(1, -1), cmplx(inf, nan), cmplx(0, negzero)},
	Test{cmplx(1, -1), cmplx(inf, inf), cmplx(0, negzero)},
	Test{cmplx(1, -1), cmplx(inf, -inf), cmplx(0, 0)},
	Test{cmplx(1, -1), cmplx(-inf, 0), cmplx(negzero, 0)},
	Test{cmplx(1, -1), cmplx(-inf, 1), cmplx(negzero, 0)},
	Test{cmplx(1, -1), cmplx(-inf, -1), cmplx(negzero, 0)},
	Test{cmplx(1, -1), cmplx(-inf, 2), cmplx(negzero, 0)},
	Test{cmplx(1, -1), cmplx(-inf, nan), cmplx(negzero, 0)},
	Test{cmplx(1, -1), cmplx(-inf, inf), cmplx(negzero, 0)},
	Test{cmplx(1, -1), cmplx(-inf, -inf), cmplx(0, 0)},
	Test{cmplx(1, 2), cmplx(0, 0), cmplx(inf, inf)},
	Test{cmplx(1, 2), cmplx(0, 1), cmplx(2, -1)},
	Test{cmplx(1, 2), cmplx(0, -1), cmplx(-2, 1)},
	Test{cmplx(1, 2), cmplx(0, 2), cmplx(1, -0.5)},
	Test{cmplx(1, 2), cmplx(0, nan), cmplx(nan, nan)},
	Test{cmplx(1, 2), cmplx(0, inf), cmplx(0, negzero)},
	Test{cmplx(1, 2), cmplx(0, -inf), cmplx(negzero, 0)},
	Test{cmplx(1, 2), cmplx(1, 0), cmplx(1, 2)},
	Test{cmplx(1, 2), cmplx(1, 1), cmplx(1.5, 0.5)},
	Test{cmplx(1, 2), cmplx(1, -1), cmplx(-0.5, 1.5)},
	Test{cmplx(1, 2), cmplx(1, 2), cmplx(1, 0)},
	Test{cmplx(1, 2), cmplx(1, nan), cmplx(nan, nan)},
	Test{cmplx(1, 2), cmplx(1, inf), cmplx(0, negzero)},
	Test{cmplx(1, 2), cmplx(1, -inf), cmplx(negzero, 0)},
	Test{cmplx(1, 2), cmplx(-1, 0), cmplx(-1, -2)},
	Test{cmplx(1, 2), cmplx(-1, 1), cmplx(0.5, -1.5)},
	Test{cmplx(1, 2), cmplx(-1, -1), cmplx(-1.5, -0.5)},
	Test{cmplx(1, 2), cmplx(-1, 2), cmplx(0.6, -0.8)},
	Test{cmplx(1, 2), cmplx(-1, nan), cmplx(nan, nan)},
	Test{cmplx(1, 2), cmplx(-1, inf), cmplx(0, negzero)},
	Test{cmplx(1, 2), cmplx(-1, -inf), cmplx(negzero, 0)},
	Test{cmplx(1, 2), cmplx(2, 0), cmplx(0.5, 1)},
	Test{cmplx(1, 2), cmplx(2, 1), cmplx(0.8, 0.6)},
	Test{cmplx(1, 2), cmplx(2, -1), cmplx(0, 1)},
	Test{cmplx(1, 2), cmplx(2, 2), cmplx(0.75, 0.25)},
	Test{cmplx(1, 2), cmplx(2, nan), cmplx(nan, nan)},
	Test{cmplx(1, 2), cmplx(2, inf), cmplx(0, negzero)},
	Test{cmplx(1, 2), cmplx(2, -inf), cmplx(negzero, 0)},
	Test{cmplx(1, 2), cmplx(nan, 0), cmplx(nan, nan)},
	Test{cmplx(1, 2), cmplx(nan, 1), cmplx(nan, nan)},
	Test{cmplx(1, 2), cmplx(nan, -1), cmplx(nan, nan)},
	Test{cmplx(1, 2), cmplx(nan, 2), cmplx(nan, nan)},
	Test{cmplx(1, 2), cmplx(nan, nan), cmplx(nan, nan)},
	Test{cmplx(1, 2), cmplx(nan, inf), cmplx(0, negzero)},
	Test{cmplx(1, 2), cmplx(nan, -inf), cmplx(negzero, 0)},
	Test{cmplx(1, 2), cmplx(inf, 0), cmplx(0, 0)},
	Test{cmplx(1, 2), cmplx(inf, 1), cmplx(0, 0)},
	Test{cmplx(1, 2), cmplx(inf, -1), cmplx(0, 0)},
	Test{cmplx(1, 2), cmplx(inf, 2), cmplx(0, 0)},
	Test{cmplx(1, 2), cmplx(inf, nan), cmplx(0, 0)},
	Test{cmplx(1, 2), cmplx(inf, inf), cmplx(0, 0)},
	Test{cmplx(1, 2), cmplx(inf, -inf), cmplx(negzero, 0)},
	Test{cmplx(1, 2), cmplx(-inf, 0), cmplx(negzero, negzero)},
	Test{cmplx(1, 2), cmplx(-inf, 1), cmplx(negzero, negzero)},
	Test{cmplx(1, 2), cmplx(-inf, -1), cmplx(negzero, negzero)},
	Test{cmplx(1, 2), cmplx(-inf, 2), cmplx(negzero, negzero)},
	Test{cmplx(1, 2), cmplx(-inf, nan), cmplx(negzero, negzero)},
	Test{cmplx(1, 2), cmplx(-inf, inf), cmplx(0, negzero)},
	Test{cmplx(1, 2), cmplx(-inf, -inf), cmplx(negzero, negzero)},
	Test{cmplx(1, nan), cmplx(0, 0), cmplx(nan, nan)},
	Test{cmplx(1, nan), cmplx(0, 1), cmplx(nan, nan)},
	Test{cmplx(1, nan), cmplx(0, -1), cmplx(nan, nan)},
	Test{cmplx(1, nan), cmplx(0, 2), cmplx(nan, nan)},
	Test{cmplx(1, nan), cmplx(0, nan), cmplx(nan, nan)},
	Test{cmplx(1, nan), cmplx(0, inf), cmplx(nan, nan)},
	Test{cmplx(1, nan), cmplx(0, -inf), cmplx(nan, nan)},
	Test{cmplx(1, nan), cmplx(1, 0), cmplx(nan, nan)},
	Test{cmplx(1, nan), cmplx(1, 1), cmplx(nan, nan)},
	Test{cmplx(1, nan), cmplx(1, -1), cmplx(nan, nan)},
	Test{cmplx(1, nan), cmplx(1, 2), cmplx(nan, nan)},
	Test{cmplx(1, nan), cmplx(1, nan), cmplx(nan, nan)},
	Test{cmplx(1, nan), cmplx(1, inf), cmplx(nan, nan)},
	Test{cmplx(1, nan), cmplx(1, -inf), cmplx(nan, nan)},
	Test{cmplx(1, nan), cmplx(-1, 0), cmplx(nan, nan)},
	Test{cmplx(1, nan), cmplx(-1, 1), cmplx(nan, nan)},
	Test{cmplx(1, nan), cmplx(-1, -1), cmplx(nan, nan)},
	Test{cmplx(1, nan), cmplx(-1, 2), cmplx(nan, nan)},
	Test{cmplx(1, nan), cmplx(-1, nan), cmplx(nan, nan)},
	Test{cmplx(1, nan), cmplx(-1, inf), cmplx(nan, nan)},
	Test{cmplx(1, nan), cmplx(-1, -inf), cmplx(nan, nan)},
	Test{cmplx(1, nan), cmplx(2, 0), cmplx(nan, nan)},
	Test{cmplx(1, nan), cmplx(2, 1), cmplx(nan, nan)},
	Test{cmplx(1, nan), cmplx(2, -1), cmplx(nan, nan)},
	Test{cmplx(1, nan), cmplx(2, 2), cmplx(nan, nan)},
	Test{cmplx(1, nan), cmplx(2, nan), cmplx(nan, nan)},
	Test{cmplx(1, nan), cmplx(2, inf), cmplx(nan, nan)},
	Test{cmplx(1, nan), cmplx(2, -inf), cmplx(nan, nan)},
	Test{cmplx(1, nan), cmplx(nan, 0), cmplx(nan, nan)},
	Test{cmplx(1, nan), cmplx(nan, 1), cmplx(nan, nan)},
	Test{cmplx(1, nan), cmplx(nan, -1), cmplx(nan, nan)},
	Test{cmplx(1, nan), cmplx(nan, 2), cmplx(nan, nan)},
	Test{cmplx(1, nan), cmplx(nan, nan), cmplx(nan, nan)},
	Test{cmplx(1, nan), cmplx(nan, inf), cmplx(nan, nan)},
	Test{cmplx(1, nan), cmplx(nan, -inf), cmplx(nan, nan)},
	Test{cmplx(1, nan), cmplx(inf, 0), cmplx(nan, nan)},
	Test{cmplx(1, nan), cmplx(inf, 1), cmplx(nan, nan)},
	Test{cmplx(1, nan), cmplx(inf, -1), cmplx(nan, nan)},
	Test{cmplx(1, nan), cmplx(inf, 2), cmplx(nan, nan)},
	Test{cmplx(1, nan), cmplx(inf, nan), cmplx(nan, nan)},
	Test{cmplx(1, nan), cmplx(inf, inf), cmplx(nan, nan)},
	Test{cmplx(1, nan), cmplx(inf, -inf), cmplx(nan, nan)},
	Test{cmplx(1, nan), cmplx(-inf, 0), cmplx(nan, nan)},
	Test{cmplx(1, nan), cmplx(-inf, 1), cmplx(nan, nan)},
	Test{cmplx(1, nan), cmplx(-inf, -1), cmplx(nan, nan)},
	Test{cmplx(1, nan), cmplx(-inf, 2), cmplx(nan, nan)},
	Test{cmplx(1, nan), cmplx(-inf, nan), cmplx(nan, nan)},
	Test{cmplx(1, nan), cmplx(-inf, inf), cmplx(nan, nan)},
	Test{cmplx(1, nan), cmplx(-inf, -inf), cmplx(nan, nan)},
	Test{cmplx(1, inf), cmplx(0, 0), cmplx(inf, inf)},
	Test{cmplx(1, inf), cmplx(0, 1), cmplx(inf, nan)},
	Test{cmplx(1, inf), cmplx(0, -1), cmplx(-inf, nan)},
	Test{cmplx(1, inf), cmplx(0, 2), cmplx(inf, nan)},
	Test{cmplx(1, inf), cmplx(0, nan), cmplx(nan, nan)},
	Test{cmplx(1, inf), cmplx(0, inf), cmplx(nan, nan)},
	Test{cmplx(1, inf), cmplx(0, -inf), cmplx(nan, nan)},
	Test{cmplx(1, inf), cmplx(1, 0), cmplx(nan, inf)},
	Test{cmplx(1, inf), cmplx(1, 1), cmplx(inf, inf)},
	Test{cmplx(1, inf), cmplx(1, -1), cmplx(-inf, inf)},
	Test{cmplx(1, inf), cmplx(1, 2), cmplx(inf, inf)},
	Test{cmplx(1, inf), cmplx(1, nan), cmplx(nan, nan)},
	Test{cmplx(1, inf), cmplx(1, inf), cmplx(nan, nan)},
	Test{cmplx(1, inf), cmplx(1, -inf), cmplx(nan, nan)},
	Test{cmplx(1, inf), cmplx(-1, 0), cmplx(nan, -inf)},
	Test{cmplx(1, inf), cmplx(-1, 1), cmplx(inf, -inf)},
	Test{cmplx(1, inf), cmplx(-1, -1), cmplx(-inf, -inf)},
	Test{cmplx(1, inf), cmplx(-1, 2), cmplx(inf, -inf)},
	Test{cmplx(1, inf), cmplx(-1, nan), cmplx(nan, nan)},
	Test{cmplx(1, inf), cmplx(-1, inf), cmplx(nan, nan)},
	Test{cmplx(1, inf), cmplx(-1, -inf), cmplx(nan, nan)},
	Test{cmplx(1, inf), cmplx(2, 0), cmplx(nan, inf)},
	Test{cmplx(1, inf), cmplx(2, 1), cmplx(inf, inf)},
	Test{cmplx(1, inf), cmplx(2, -1), cmplx(-inf, inf)},
	Test{cmplx(1, inf), cmplx(2, 2), cmplx(inf, inf)},
	Test{cmplx(1, inf), cmplx(2, nan), cmplx(nan, nan)},
	Test{cmplx(1, inf), cmplx(2, inf), cmplx(nan, nan)},
	Test{cmplx(1, inf), cmplx(2, -inf), cmplx(nan, nan)},
	Test{cmplx(1, inf), cmplx(nan, 0), cmplx(nan, nan)},
	Test{cmplx(1, inf), cmplx(nan, 1), cmplx(nan, nan)},
	Test{cmplx(1, inf), cmplx(nan, -1), cmplx(nan, nan)},
	Test{cmplx(1, inf), cmplx(nan, 2), cmplx(nan, nan)},
	Test{cmplx(1, inf), cmplx(nan, nan), cmplx(nan, nan)},
	Test{cmplx(1, inf), cmplx(nan, inf), cmplx(nan, nan)},
	Test{cmplx(1, inf), cmplx(nan, -inf), cmplx(nan, nan)},
	Test{cmplx(1, inf), cmplx(inf, 0), cmplx(nan, nan)},
	Test{cmplx(1, inf), cmplx(inf, 1), cmplx(nan, nan)},
	Test{cmplx(1, inf), cmplx(inf, -1), cmplx(nan, nan)},
	Test{cmplx(1, inf), cmplx(inf, 2), cmplx(nan, nan)},
	Test{cmplx(1, inf), cmplx(inf, nan), cmplx(nan, nan)},
	Test{cmplx(1, inf), cmplx(inf, inf), cmplx(nan, nan)},
	Test{cmplx(1, inf), cmplx(inf, -inf), cmplx(nan, nan)},
	Test{cmplx(1, inf), cmplx(-inf, 0), cmplx(nan, nan)},
	Test{cmplx(1, inf), cmplx(-inf, 1), cmplx(nan, nan)},
	Test{cmplx(1, inf), cmplx(-inf, -1), cmplx(nan, nan)},
	Test{cmplx(1, inf), cmplx(-inf, 2), cmplx(nan, nan)},
	Test{cmplx(1, inf), cmplx(-inf, nan), cmplx(nan, nan)},
	Test{cmplx(1, inf), cmplx(-inf, inf), cmplx(nan, nan)},
	Test{cmplx(1, inf), cmplx(-inf, -inf), cmplx(nan, nan)},
	Test{cmplx(1, -inf), cmplx(0, 0), cmplx(inf, -inf)},
	Test{cmplx(1, -inf), cmplx(0, 1), cmplx(-inf, nan)},
	Test{cmplx(1, -inf), cmplx(0, -1), cmplx(inf, nan)},
	Test{cmplx(1, -inf), cmplx(0, 2), cmplx(-inf, nan)},
	Test{cmplx(1, -inf), cmplx(0, nan), cmplx(nan, nan)},
	Test{cmplx(1, -inf), cmplx(0, inf), cmplx(nan, nan)},
	Test{cmplx(1, -inf), cmplx(0, -inf), cmplx(nan, nan)},
	Test{cmplx(1, -inf), cmplx(1, 0), cmplx(nan, -inf)},
	Test{cmplx(1, -inf), cmplx(1, 1), cmplx(-inf, -inf)},
	Test{cmplx(1, -inf), cmplx(1, -1), cmplx(inf, -inf)},
	Test{cmplx(1, -inf), cmplx(1, 2), cmplx(-inf, -inf)},
	Test{cmplx(1, -inf), cmplx(1, nan), cmplx(nan, nan)},
	Test{cmplx(1, -inf), cmplx(1, inf), cmplx(nan, nan)},
	Test{cmplx(1, -inf), cmplx(1, -inf), cmplx(nan, nan)},
	Test{cmplx(1, -inf), cmplx(-1, 0), cmplx(nan, inf)},
	Test{cmplx(1, -inf), cmplx(-1, 1), cmplx(-inf, inf)},
	Test{cmplx(1, -inf), cmplx(-1, -1), cmplx(inf, inf)},
	Test{cmplx(1, -inf), cmplx(-1, 2), cmplx(-inf, inf)},
	Test{cmplx(1, -inf), cmplx(-1, nan), cmplx(nan, nan)},
	Test{cmplx(1, -inf), cmplx(-1, inf), cmplx(nan, nan)},
	Test{cmplx(1, -inf), cmplx(-1, -inf), cmplx(nan, nan)},
	Test{cmplx(1, -inf), cmplx(2, 0), cmplx(nan, -inf)},
	Test{cmplx(1, -inf), cmplx(2, 1), cmplx(-inf, -inf)},
	Test{cmplx(1, -inf), cmplx(2, -1), cmplx(inf, -inf)},
	Test{cmplx(1, -inf), cmplx(2, 2), cmplx(-inf, -inf)},
	Test{cmplx(1, -inf), cmplx(2, nan), cmplx(nan, nan)},
	Test{cmplx(1, -inf), cmplx(2, inf), cmplx(nan, nan)},
	Test{cmplx(1, -inf), cmplx(2, -inf), cmplx(nan, nan)},
	Test{cmplx(1, -inf), cmplx(nan, 0), cmplx(nan, nan)},
	Test{cmplx(1, -inf), cmplx(nan, 1), cmplx(nan, nan)},
	Test{cmplx(1, -inf), cmplx(nan, -1), cmplx(nan, nan)},
	Test{cmplx(1, -inf), cmplx(nan, 2), cmplx(nan, nan)},
	Test{cmplx(1, -inf), cmplx(nan, nan), cmplx(nan, nan)},
	Test{cmplx(1, -inf), cmplx(nan, inf), cmplx(nan, nan)},
	Test{cmplx(1, -inf), cmplx(nan, -inf), cmplx(nan, nan)},
	Test{cmplx(1, -inf), cmplx(inf, 0), cmplx(nan, nan)},
	Test{cmplx(1, -inf), cmplx(inf, 1), cmplx(nan, nan)},
	Test{cmplx(1, -inf), cmplx(inf, -1), cmplx(nan, nan)},
	Test{cmplx(1, -inf), cmplx(inf, 2), cmplx(nan, nan)},
	Test{cmplx(1, -inf), cmplx(inf, nan), cmplx(nan, nan)},
	Test{cmplx(1, -inf), cmplx(inf, inf), cmplx(nan, nan)},
	Test{cmplx(1, -inf), cmplx(inf, -inf), cmplx(nan, nan)},
	Test{cmplx(1, -inf), cmplx(-inf, 0), cmplx(nan, nan)},
	Test{cmplx(1, -inf), cmplx(-inf, 1), cmplx(nan, nan)},
	Test{cmplx(1, -inf), cmplx(-inf, -1), cmplx(nan, nan)},
	Test{cmplx(1, -inf), cmplx(-inf, 2), cmplx(nan, nan)},
	Test{cmplx(1, -inf), cmplx(-inf, nan), cmplx(nan, nan)},
	Test{cmplx(1, -inf), cmplx(-inf, inf), cmplx(nan, nan)},
	Test{cmplx(1, -inf), cmplx(-inf, -inf), cmplx(nan, nan)},
	Test{cmplx(-1, 0), cmplx(0, 0), cmplx(-inf, nan)},
	Test{cmplx(-1, 0), cmplx(0, 1), cmplx(0, 1)},
	Test{cmplx(-1, 0), cmplx(0, -1), cmplx(negzero, -1)},
	Test{cmplx(-1, 0), cmplx(0, 2), cmplx(0, 0.5)},
	Test{cmplx(-1, 0), cmplx(0, nan), cmplx(nan, nan)},
	Test{cmplx(-1, 0), cmplx(0, inf), cmplx(0, 0)},
	Test{cmplx(-1, 0), cmplx(0, -inf), cmplx(negzero, negzero)},
	Test{cmplx(-1, 0), cmplx(1, 0), cmplx(-1, 0)},
	Test{cmplx(-1, 0), cmplx(1, 1), cmplx(-0.5, 0.5)},
	Test{cmplx(-1, 0), cmplx(1, -1), cmplx(-0.5, -0.5)},
	Test{cmplx(-1, 0), cmplx(1, 2), cmplx(-0.2, 0.4)},
	Test{cmplx(-1, 0), cmplx(1, nan), cmplx(nan, nan)},
	Test{cmplx(-1, 0), cmplx(1, inf), cmplx(0, 0)},
	Test{cmplx(-1, 0), cmplx(1, -inf), cmplx(negzero, negzero)},
	Test{cmplx(-1, 0), cmplx(-1, 0), cmplx(1, negzero)},
	Test{cmplx(-1, 0), cmplx(-1, 1), cmplx(0.5, 0.5)},
	Test{cmplx(-1, 0), cmplx(-1, -1), cmplx(0.5, -0.5)},
	Test{cmplx(-1, 0), cmplx(-1, 2), cmplx(0.2, 0.4)},
	Test{cmplx(-1, 0), cmplx(-1, nan), cmplx(nan, nan)},
	Test{cmplx(-1, 0), cmplx(-1, inf), cmplx(0, 0)},
	Test{cmplx(-1, 0), cmplx(-1, -inf), cmplx(negzero, negzero)},
	Test{cmplx(-1, 0), cmplx(2, 0), cmplx(-0.5, 0)},
	Test{cmplx(-1, 0), cmplx(2, 1), cmplx(-0.4, 0.2)},
	Test{cmplx(-1, 0), cmplx(2, -1), cmplx(-0.4, -0.2)},
	Test{cmplx(-1, 0), cmplx(2, 2), cmplx(-0.25, 0.25)},
	Test{cmplx(-1, 0), cmplx(2, nan), cmplx(nan, nan)},
	Test{cmplx(-1, 0), cmplx(2, inf), cmplx(0, 0)},
	Test{cmplx(-1, 0), cmplx(2, -inf), cmplx(negzero, negzero)},
	Test{cmplx(-1, 0), cmplx(nan, 0), cmplx(nan, nan)},
	Test{cmplx(-1, 0), cmplx(nan, 1), cmplx(nan, nan)},
	Test{cmplx(-1, 0), cmplx(nan, -1), cmplx(nan, nan)},
	Test{cmplx(-1, 0), cmplx(nan, 2), cmplx(nan, nan)},
	Test{cmplx(-1, 0), cmplx(nan, nan), cmplx(nan, nan)},
	Test{cmplx(-1, 0), cmplx(nan, inf), cmplx(0, 0)},
	Test{cmplx(-1, 0), cmplx(nan, -inf), cmplx(negzero, negzero)},
	Test{cmplx(-1, 0), cmplx(inf, 0), cmplx(negzero, 0)},
	Test{cmplx(-1, 0), cmplx(inf, 1), cmplx(negzero, 0)},
	Test{cmplx(-1, 0), cmplx(inf, -1), cmplx(negzero, 0)},
	Test{cmplx(-1, 0), cmplx(inf, 2), cmplx(negzero, 0)},
	Test{cmplx(-1, 0), cmplx(inf, nan), cmplx(negzero, 0)},
	Test{cmplx(-1, 0), cmplx(inf, inf), cmplx(negzero, 0)},
	Test{cmplx(-1, 0), cmplx(inf, -inf), cmplx(negzero, negzero)},
	Test{cmplx(-1, 0), cmplx(-inf, 0), cmplx(0, negzero)},
	Test{cmplx(-1, 0), cmplx(-inf, 1), cmplx(0, negzero)},
	Test{cmplx(-1, 0), cmplx(-inf, -1), cmplx(0, negzero)},
	Test{cmplx(-1, 0), cmplx(-inf, 2), cmplx(0, negzero)},
	Test{cmplx(-1, 0), cmplx(-inf, nan), cmplx(0, 0)},
	Test{cmplx(-1, 0), cmplx(-inf, inf), cmplx(0, 0)},
	Test{cmplx(-1, 0), cmplx(-inf, -inf), cmplx(0, negzero)},
	Test{cmplx(-1, 1), cmplx(0, 0), cmplx(-inf, inf)},
	Test{cmplx(-1, 1), cmplx(0, 1), cmplx(1, 1)},
	Test{cmplx(-1, 1), cmplx(0, -1), cmplx(-1, -1)},
	Test{cmplx(-1, 1), cmplx(0, 2), cmplx(0.5, 0.5)},
	Test{cmplx(-1, 1), cmplx(0, nan), cmplx(nan, nan)},
	Test{cmplx(-1, 1), cmplx(0, inf), cmplx(0, 0)},
	Test{cmplx(-1, 1), cmplx(0, -inf), cmplx(negzero, negzero)},
	Test{cmplx(-1, 1), cmplx(1, 0), cmplx(-1, 1)},
	Test{cmplx(-1, 1), cmplx(1, 1), cmplx(0, 1)},
	Test{cmplx(-1, 1), cmplx(1, -1), cmplx(-1, 0)},
	Test{cmplx(-1, 1), cmplx(1, 2), cmplx(0.2, 0.6)},
	Test{cmplx(-1, 1), cmplx(1, nan), cmplx(nan, nan)},
	Test{cmplx(-1, 1), cmplx(1, inf), cmplx(0, 0)},
	Test{cmplx(-1, 1), cmplx(1, -inf), cmplx(negzero, negzero)},
	Test{cmplx(-1, 1), cmplx(-1, 0), cmplx(1, -1)},
	Test{cmplx(-1, 1), cmplx(-1, 1), cmplx(1, negzero)},
	Test{cmplx(-1, 1), cmplx(-1, -1), cmplx(negzero, -1)},
	Test{cmplx(-1, 1), cmplx(-1, 2), cmplx(0.6, 0.2)},
	Test{cmplx(-1, 1), cmplx(-1, nan), cmplx(nan, nan)},
	Test{cmplx(-1, 1), cmplx(-1, inf), cmplx(0, 0)},
	Test{cmplx(-1, 1), cmplx(-1, -inf), cmplx(negzero, negzero)},
	Test{cmplx(-1, 1), cmplx(2, 0), cmplx(-0.5, 0.5)},
	Test{cmplx(-1, 1), cmplx(2, 1), cmplx(-0.2, 0.6)},
	Test{cmplx(-1, 1), cmplx(2, -1), cmplx(-0.6, 0.2)},
	Test{cmplx(-1, 1), cmplx(2, 2), cmplx(0, 0.5)},
	Test{cmplx(-1, 1), cmplx(2, nan), cmplx(nan, nan)},
	Test{cmplx(-1, 1), cmplx(2, inf), cmplx(0, 0)},
	Test{cmplx(-1, 1), cmplx(2, -inf), cmplx(negzero, negzero)},
	Test{cmplx(-1, 1), cmplx(nan, 0), cmplx(nan, nan)},
	Test{cmplx(-1, 1), cmplx(nan, 1), cmplx(nan, nan)},
	Test{cmplx(-1, 1), cmplx(nan, -1), cmplx(nan, nan)},
	Test{cmplx(-1, 1), cmplx(nan, 2), cmplx(nan, nan)},
	Test{cmplx(-1, 1), cmplx(nan, nan), cmplx(nan, nan)},
	Test{cmplx(-1, 1), cmplx(nan, inf), cmplx(0, 0)},
	Test{cmplx(-1, 1), cmplx(nan, -inf), cmplx(negzero, negzero)},
	Test{cmplx(-1, 1), cmplx(inf, 0), cmplx(negzero, 0)},
	Test{cmplx(-1, 1), cmplx(inf, 1), cmplx(negzero, 0)},
	Test{cmplx(-1, 1), cmplx(inf, -1), cmplx(negzero, 0)},
	Test{cmplx(-1, 1), cmplx(inf, 2), cmplx(negzero, 0)},
	Test{cmplx(-1, 1), cmplx(inf, nan), cmplx(negzero, 0)},
	Test{cmplx(-1, 1), cmplx(inf, inf), cmplx(0, 0)},
	Test{cmplx(-1, 1), cmplx(inf, -inf), cmplx(negzero, 0)},
	Test{cmplx(-1, 1), cmplx(-inf, 0), cmplx(0, negzero)},
	Test{cmplx(-1, 1), cmplx(-inf, 1), cmplx(0, negzero)},
	Test{cmplx(-1, 1), cmplx(-inf, -1), cmplx(0, negzero)},
	Test{cmplx(-1, 1), cmplx(-inf, 2), cmplx(0, negzero)},
	Test{cmplx(-1, 1), cmplx(-inf, nan), cmplx(0, negzero)},
	Test{cmplx(-1, 1), cmplx(-inf, inf), cmplx(0, 0)},
	Test{cmplx(-1, 1), cmplx(-inf, -inf), cmplx(0, negzero)},
	Test{cmplx(-1, -1), cmplx(0, 0), cmplx(-inf, -inf)},
	Test{cmplx(-1, -1), cmplx(0, 1), cmplx(-1, 1)},
	Test{cmplx(-1, -1), cmplx(0, -1), cmplx(1, -1)},
	Test{cmplx(-1, -1), cmplx(0, 2), cmplx(-0.5, 0.5)},
	Test{cmplx(-1, -1), cmplx(0, nan), cmplx(nan, nan)},
	Test{cmplx(-1, -1), cmplx(0, inf), cmplx(negzero, 0)},
	Test{cmplx(-1, -1), cmplx(0, -inf), cmplx(0, negzero)},
	Test{cmplx(-1, -1), cmplx(1, 0), cmplx(-1, -1)},
	Test{cmplx(-1, -1), cmplx(1, 1), cmplx(-1, 0)},
	Test{cmplx(-1, -1), cmplx(1, -1), cmplx(0, -1)},
	Test{cmplx(-1, -1), cmplx(1, 2), cmplx(-0.6, 0.2)},
	Test{cmplx(-1, -1), cmplx(1, nan), cmplx(nan, nan)},
	Test{cmplx(-1, -1), cmplx(1, inf), cmplx(negzero, 0)},
	Test{cmplx(-1, -1), cmplx(1, -inf), cmplx(0, negzero)},
	Test{cmplx(-1, -1), cmplx(-1, 0), cmplx(1, 1)},
	Test{cmplx(-1, -1), cmplx(-1, 1), cmplx(negzero, 1)},
	Test{cmplx(-1, -1), cmplx(-1, -1), cmplx(1, negzero)},
	Test{cmplx(-1, -1), cmplx(-1, 2), cmplx(-0.2, 0.6)},
	Test{cmplx(-1, -1), cmplx(-1, nan), cmplx(nan, nan)},
	Test{cmplx(-1, -1), cmplx(-1, inf), cmplx(negzero, 0)},
	Test{cmplx(-1, -1), cmplx(-1, -inf), cmplx(0, negzero)},
	Test{cmplx(-1, -1), cmplx(2, 0), cmplx(-0.5, -0.5)},
	Test{cmplx(-1, -1), cmplx(2, 1), cmplx(-0.6, -0.2)},
	Test{cmplx(-1, -1), cmplx(2, -1), cmplx(-0.2, -0.6)},
	Test{cmplx(-1, -1), cmplx(2, 2), cmplx(-0.5, 0)},
	Test{cmplx(-1, -1), cmplx(2, nan), cmplx(nan, nan)},
	Test{cmplx(-1, -1), cmplx(2, inf), cmplx(negzero, 0)},
	Test{cmplx(-1, -1), cmplx(2, -inf), cmplx(0, negzero)},
	Test{cmplx(-1, -1), cmplx(nan, 0), cmplx(nan, nan)},
	Test{cmplx(-1, -1), cmplx(nan, 1), cmplx(nan, nan)},
	Test{cmplx(-1, -1), cmplx(nan, -1), cmplx(nan, nan)},
	Test{cmplx(-1, -1), cmplx(nan, 2), cmplx(nan, nan)},
	Test{cmplx(-1, -1), cmplx(nan, nan), cmplx(nan, nan)},
	Test{cmplx(-1, -1), cmplx(nan, inf), cmplx(negzero, 0)},
	Test{cmplx(-1, -1), cmplx(nan, -inf), cmplx(0, negzero)},
	Test{cmplx(-1, -1), cmplx(inf, 0), cmplx(negzero, negzero)},
	Test{cmplx(-1, -1), cmplx(inf, 1), cmplx(negzero, negzero)},
	Test{cmplx(-1, -1), cmplx(inf, -1), cmplx(negzero, negzero)},
	Test{cmplx(-1, -1), cmplx(inf, 2), cmplx(negzero, negzero)},
	Test{cmplx(-1, -1), cmplx(inf, nan), cmplx(negzero, negzero)},
	Test{cmplx(-1, -1), cmplx(inf, inf), cmplx(negzero, 0)},
	Test{cmplx(-1, -1), cmplx(inf, -inf), cmplx(0, negzero)},
	Test{cmplx(-1, -1), cmplx(-inf, 0), cmplx(0, 0)},
	Test{cmplx(-1, -1), cmplx(-inf, 1), cmplx(0, 0)},
	Test{cmplx(-1, -1), cmplx(-inf, -1), cmplx(0, 0)},
	Test{cmplx(-1, -1), cmplx(-inf, 2), cmplx(0, 0)},
	Test{cmplx(-1, -1), cmplx(-inf, nan), cmplx(0, 0)},
	Test{cmplx(-1, -1), cmplx(-inf, inf), cmplx(0, 0)},
	Test{cmplx(-1, -1), cmplx(-inf, -inf), cmplx(0, 0)},
	Test{cmplx(-1, 2), cmplx(0, 0), cmplx(-inf, inf)},
	Test{cmplx(-1, 2), cmplx(0, 1), cmplx(2, 1)},
	Test{cmplx(-1, 2), cmplx(0, -1), cmplx(-2, -1)},
	Test{cmplx(-1, 2), cmplx(0, 2), cmplx(1, 0.5)},
	Test{cmplx(-1, 2), cmplx(0, nan), cmplx(nan, nan)},
	Test{cmplx(-1, 2), cmplx(0, inf), cmplx(0, 0)},
	Test{cmplx(-1, 2), cmplx(0, -inf), cmplx(negzero, negzero)},
	Test{cmplx(-1, 2), cmplx(1, 0), cmplx(-1, 2)},
	Test{cmplx(-1, 2), cmplx(1, 1), cmplx(0.5, 1.5)},
	Test{cmplx(-1, 2), cmplx(1, -1), cmplx(-1.5, 0.5)},
	Test{cmplx(-1, 2), cmplx(1, 2), cmplx(0.6, 0.8)},
	Test{cmplx(-1, 2), cmplx(1, nan), cmplx(nan, nan)},
	Test{cmplx(-1, 2), cmplx(1, inf), cmplx(0, 0)},
	Test{cmplx(-1, 2), cmplx(1, -inf), cmplx(negzero, negzero)},
	Test{cmplx(-1, 2), cmplx(-1, 0), cmplx(1, -2)},
	Test{cmplx(-1, 2), cmplx(-1, 1), cmplx(1.5, -0.5)},
	Test{cmplx(-1, 2), cmplx(-1, -1), cmplx(-0.5, -1.5)},
	Test{cmplx(-1, 2), cmplx(-1, 2), cmplx(1, 0)},
	Test{cmplx(-1, 2), cmplx(-1, nan), cmplx(nan, nan)},
	Test{cmplx(-1, 2), cmplx(-1, inf), cmplx(0, 0)},
	Test{cmplx(-1, 2), cmplx(-1, -inf), cmplx(negzero, negzero)},
	Test{cmplx(-1, 2), cmplx(2, 0), cmplx(-0.5, 1)},
	Test{cmplx(-1, 2), cmplx(2, 1), cmplx(0, 1)},
	Test{cmplx(-1, 2), cmplx(2, -1), cmplx(-0.8, 0.6)},
	Test{cmplx(-1, 2), cmplx(2, 2), cmplx(0.25, 0.75)},
	Test{cmplx(-1, 2), cmplx(2, nan), cmplx(nan, nan)},
	Test{cmplx(-1, 2), cmplx(2, inf), cmplx(0, 0)},
	Test{cmplx(-1, 2), cmplx(2, -inf), cmplx(negzero, negzero)},
	Test{cmplx(-1, 2), cmplx(nan, 0), cmplx(nan, nan)},
	Test{cmplx(-1, 2), cmplx(nan, 1), cmplx(nan, nan)},
	Test{cmplx(-1, 2), cmplx(nan, -1), cmplx(nan, nan)},
	Test{cmplx(-1, 2), cmplx(nan, 2), cmplx(nan, nan)},
	Test{cmplx(-1, 2), cmplx(nan, nan), cmplx(nan, nan)},
	Test{cmplx(-1, 2), cmplx(nan, inf), cmplx(0, 0)},
	Test{cmplx(-1, 2), cmplx(nan, -inf), cmplx(negzero, negzero)},
	Test{cmplx(-1, 2), cmplx(inf, 0), cmplx(negzero, 0)},
	Test{cmplx(-1, 2), cmplx(inf, 1), cmplx(negzero, 0)},
	Test{cmplx(-1, 2), cmplx(inf, -1), cmplx(negzero, 0)},
	Test{cmplx(-1, 2), cmplx(inf, 2), cmplx(negzero, 0)},
	Test{cmplx(-1, 2), cmplx(inf, nan), cmplx(negzero, 0)},
	Test{cmplx(-1, 2), cmplx(inf, inf), cmplx(0, 0)},
	Test{cmplx(-1, 2), cmplx(inf, -inf), cmplx(negzero, 0)},
	Test{cmplx(-1, 2), cmplx(-inf, 0), cmplx(0, negzero)},
	Test{cmplx(-1, 2), cmplx(-inf, 1), cmplx(0, negzero)},
	Test{cmplx(-1, 2), cmplx(-inf, -1), cmplx(0, negzero)},
	Test{cmplx(-1, 2), cmplx(-inf, 2), cmplx(0, negzero)},
	Test{cmplx(-1, 2), cmplx(-inf, nan), cmplx(0, negzero)},
	Test{cmplx(-1, 2), cmplx(-inf, inf), cmplx(0, negzero)},
	Test{cmplx(-1, 2), cmplx(-inf, -inf), cmplx(negzero, negzero)},
	Test{cmplx(-1, nan), cmplx(0, 0), cmplx(nan, nan)},
	Test{cmplx(-1, nan), cmplx(0, 1), cmplx(nan, nan)},
	Test{cmplx(-1, nan), cmplx(0, -1), cmplx(nan, nan)},
	Test{cmplx(-1, nan), cmplx(0, 2), cmplx(nan, nan)},
	Test{cmplx(-1, nan), cmplx(0, nan), cmplx(nan, nan)},
	Test{cmplx(-1, nan), cmplx(0, inf), cmplx(nan, nan)},
	Test{cmplx(-1, nan), cmplx(0, -inf), cmplx(nan, nan)},
	Test{cmplx(-1, nan), cmplx(1, 0), cmplx(nan, nan)},
	Test{cmplx(-1, nan), cmplx(1, 1), cmplx(nan, nan)},
	Test{cmplx(-1, nan), cmplx(1, -1), cmplx(nan, nan)},
	Test{cmplx(-1, nan), cmplx(1, 2), cmplx(nan, nan)},
	Test{cmplx(-1, nan), cmplx(1, nan), cmplx(nan, nan)},
	Test{cmplx(-1, nan), cmplx(1, inf), cmplx(nan, nan)},
	Test{cmplx(-1, nan), cmplx(1, -inf), cmplx(nan, nan)},
	Test{cmplx(-1, nan), cmplx(-1, 0), cmplx(nan, nan)},
	Test{cmplx(-1, nan), cmplx(-1, 1), cmplx(nan, nan)},
	Test{cmplx(-1, nan), cmplx(-1, -1), cmplx(nan, nan)},
	Test{cmplx(-1, nan), cmplx(-1, 2), cmplx(nan, nan)},
	Test{cmplx(-1, nan), cmplx(-1, nan), cmplx(nan, nan)},
	Test{cmplx(-1, nan), cmplx(-1, inf), cmplx(nan, nan)},
	Test{cmplx(-1, nan), cmplx(-1, -inf), cmplx(nan, nan)},
	Test{cmplx(-1, nan), cmplx(2, 0), cmplx(nan, nan)},
	Test{cmplx(-1, nan), cmplx(2, 1), cmplx(nan, nan)},
	Test{cmplx(-1, nan), cmplx(2, -1), cmplx(nan, nan)},
	Test{cmplx(-1, nan), cmplx(2, 2), cmplx(nan, nan)},
	Test{cmplx(-1, nan), cmplx(2, nan), cmplx(nan, nan)},
	Test{cmplx(-1, nan), cmplx(2, inf), cmplx(nan, nan)},
	Test{cmplx(-1, nan), cmplx(2, -inf), cmplx(nan, nan)},
	Test{cmplx(-1, nan), cmplx(nan, 0), cmplx(nan, nan)},
	Test{cmplx(-1, nan), cmplx(nan, 1), cmplx(nan, nan)},
	Test{cmplx(-1, nan), cmplx(nan, -1), cmplx(nan, nan)},
	Test{cmplx(-1, nan), cmplx(nan, 2), cmplx(nan, nan)},
	Test{cmplx(-1, nan), cmplx(nan, nan), cmplx(nan, nan)},
	Test{cmplx(-1, nan), cmplx(nan, inf), cmplx(nan, nan)},
	Test{cmplx(-1, nan), cmplx(nan, -inf), cmplx(nan, nan)},
	Test{cmplx(-1, nan), cmplx(inf, 0), cmplx(nan, nan)},
	Test{cmplx(-1, nan), cmplx(inf, 1), cmplx(nan, nan)},
	Test{cmplx(-1, nan), cmplx(inf, -1), cmplx(nan, nan)},
	Test{cmplx(-1, nan), cmplx(inf, 2), cmplx(nan, nan)},
	Test{cmplx(-1, nan), cmplx(inf, nan), cmplx(nan, nan)},
	Test{cmplx(-1, nan), cmplx(inf, inf), cmplx(nan, nan)},
	Test{cmplx(-1, nan), cmplx(inf, -inf), cmplx(nan, nan)},
	Test{cmplx(-1, nan), cmplx(-inf, 0), cmplx(nan, nan)},
	Test{cmplx(-1, nan), cmplx(-inf, 1), cmplx(nan, nan)},
	Test{cmplx(-1, nan), cmplx(-inf, -1), cmplx(nan, nan)},
	Test{cmplx(-1, nan), cmplx(-inf, 2), cmplx(nan, nan)},
	Test{cmplx(-1, nan), cmplx(-inf, nan), cmplx(nan, nan)},
	Test{cmplx(-1, nan), cmplx(-inf, inf), cmplx(nan, nan)},
	Test{cmplx(-1, nan), cmplx(-inf, -inf), cmplx(nan, nan)},
	Test{cmplx(-1, inf), cmplx(0, 0), cmplx(-inf, inf)},
	Test{cmplx(-1, inf), cmplx(0, 1), cmplx(inf, nan)},
	Test{cmplx(-1, inf), cmplx(0, -1), cmplx(-inf, nan)},
	Test{cmplx(-1, inf), cmplx(0, 2), cmplx(inf, nan)},
	Test{cmplx(-1, inf), cmplx(0, nan), cmplx(nan, nan)},
	Test{cmplx(-1, inf), cmplx(0, inf), cmplx(nan, nan)},
	Test{cmplx(-1, inf), cmplx(0, -inf), cmplx(nan, nan)},
	Test{cmplx(-1, inf), cmplx(1, 0), cmplx(nan, inf)},
	Test{cmplx(-1, inf), cmplx(1, 1), cmplx(inf, inf)},
	Test{cmplx(-1, inf), cmplx(1, -1), cmplx(-inf, inf)},
	Test{cmplx(-1, inf), cmplx(1, 2), cmplx(inf, inf)},
	Test{cmplx(-1, inf), cmplx(1, nan), cmplx(nan, nan)},
	Test{cmplx(-1, inf), cmplx(1, inf), cmplx(nan, nan)},
	Test{cmplx(-1, inf), cmplx(1, -inf), cmplx(nan, nan)},
	Test{cmplx(-1, inf), cmplx(-1, 0), cmplx(nan, -inf)},
	Test{cmplx(-1, inf), cmplx(-1, 1), cmplx(inf, -inf)},
	Test{cmplx(-1, inf), cmplx(-1, -1), cmplx(-inf, -inf)},
	Test{cmplx(-1, inf), cmplx(-1, 2), cmplx(inf, -inf)},
	Test{cmplx(-1, inf), cmplx(-1, nan), cmplx(nan, nan)},
	Test{cmplx(-1, inf), cmplx(-1, inf), cmplx(nan, nan)},
	Test{cmplx(-1, inf), cmplx(-1, -inf), cmplx(nan, nan)},
	Test{cmplx(-1, inf), cmplx(2, 0), cmplx(nan, inf)},
	Test{cmplx(-1, inf), cmplx(2, 1), cmplx(inf, inf)},
	Test{cmplx(-1, inf), cmplx(2, -1), cmplx(-inf, inf)},
	Test{cmplx(-1, inf), cmplx(2, 2), cmplx(inf, inf)},
	Test{cmplx(-1, inf), cmplx(2, nan), cmplx(nan, nan)},
	Test{cmplx(-1, inf), cmplx(2, inf), cmplx(nan, nan)},
	Test{cmplx(-1, inf), cmplx(2, -inf), cmplx(nan, nan)},
	Test{cmplx(-1, inf), cmplx(nan, 0), cmplx(nan, nan)},
	Test{cmplx(-1, inf), cmplx(nan, 1), cmplx(nan, nan)},
	Test{cmplx(-1, inf), cmplx(nan, -1), cmplx(nan, nan)},
	Test{cmplx(-1, inf), cmplx(nan, 2), cmplx(nan, nan)},
	Test{cmplx(-1, inf), cmplx(nan, nan), cmplx(nan, nan)},
	Test{cmplx(-1, inf), cmplx(nan, inf), cmplx(nan, nan)},
	Test{cmplx(-1, inf), cmplx(nan, -inf), cmplx(nan, nan)},
	Test{cmplx(-1, inf), cmplx(inf, 0), cmplx(nan, nan)},
	Test{cmplx(-1, inf), cmplx(inf, 1), cmplx(nan, nan)},
	Test{cmplx(-1, inf), cmplx(inf, -1), cmplx(nan, nan)},
	Test{cmplx(-1, inf), cmplx(inf, 2), cmplx(nan, nan)},
	Test{cmplx(-1, inf), cmplx(inf, nan), cmplx(nan, nan)},
	Test{cmplx(-1, inf), cmplx(inf, inf), cmplx(nan, nan)},
	Test{cmplx(-1, inf), cmplx(inf, -inf), cmplx(nan, nan)},
	Test{cmplx(-1, inf), cmplx(-inf, 0), cmplx(nan, nan)},
	Test{cmplx(-1, inf), cmplx(-inf, 1), cmplx(nan, nan)},
	Test{cmplx(-1, inf), cmplx(-inf, -1), cmplx(nan, nan)},
	Test{cmplx(-1, inf), cmplx(-inf, 2), cmplx(nan, nan)},
	Test{cmplx(-1, inf), cmplx(-inf, nan), cmplx(nan, nan)},
	Test{cmplx(-1, inf), cmplx(-inf, inf), cmplx(nan, nan)},
	Test{cmplx(-1, inf), cmplx(-inf, -inf), cmplx(nan, nan)},
	Test{cmplx(-1, -inf), cmplx(0, 0), cmplx(-inf, -inf)},
	Test{cmplx(-1, -inf), cmplx(0, 1), cmplx(-inf, nan)},
	Test{cmplx(-1, -inf), cmplx(0, -1), cmplx(inf, nan)},
	Test{cmplx(-1, -inf), cmplx(0, 2), cmplx(-inf, nan)},
	Test{cmplx(-1, -inf), cmplx(0, nan), cmplx(nan, nan)},
	Test{cmplx(-1, -inf), cmplx(0, inf), cmplx(nan, nan)},
	Test{cmplx(-1, -inf), cmplx(0, -inf), cmplx(nan, nan)},
	Test{cmplx(-1, -inf), cmplx(1, 0), cmplx(nan, -inf)},
	Test{cmplx(-1, -inf), cmplx(1, 1), cmplx(-inf, -inf)},
	Test{cmplx(-1, -inf), cmplx(1, -1), cmplx(inf, -inf)},
	Test{cmplx(-1, -inf), cmplx(1, 2), cmplx(-inf, -inf)},
	Test{cmplx(-1, -inf), cmplx(1, nan), cmplx(nan, nan)},
	Test{cmplx(-1, -inf), cmplx(1, inf), cmplx(nan, nan)},
	Test{cmplx(-1, -inf), cmplx(1, -inf), cmplx(nan, nan)},
	Test{cmplx(-1, -inf), cmplx(-1, 0), cmplx(nan, inf)},
	Test{cmplx(-1, -inf), cmplx(-1, 1), cmplx(-inf, inf)},
	Test{cmplx(-1, -inf), cmplx(-1, -1), cmplx(inf, inf)},
	Test{cmplx(-1, -inf), cmplx(-1, 2), cmplx(-inf, inf)},
	Test{cmplx(-1, -inf), cmplx(-1, nan), cmplx(nan, nan)},
	Test{cmplx(-1, -inf), cmplx(-1, inf), cmplx(nan, nan)},
	Test{cmplx(-1, -inf), cmplx(-1, -inf), cmplx(nan, nan)},
	Test{cmplx(-1, -inf), cmplx(2, 0), cmplx(nan, -inf)},
	Test{cmplx(-1, -inf), cmplx(2, 1), cmplx(-inf, -inf)},
	Test{cmplx(-1, -inf), cmplx(2, -1), cmplx(inf, -inf)},
	Test{cmplx(-1, -inf), cmplx(2, 2), cmplx(-inf, -inf)},
	Test{cmplx(-1, -inf), cmplx(2, nan), cmplx(nan, nan)},
	Test{cmplx(-1, -inf), cmplx(2, inf), cmplx(nan, nan)},
	Test{cmplx(-1, -inf), cmplx(2, -inf), cmplx(nan, nan)},
	Test{cmplx(-1, -inf), cmplx(nan, 0), cmplx(nan, nan)},
	Test{cmplx(-1, -inf), cmplx(nan, 1), cmplx(nan, nan)},
	Test{cmplx(-1, -inf), cmplx(nan, -1), cmplx(nan, nan)},
	Test{cmplx(-1, -inf), cmplx(nan, 2), cmplx(nan, nan)},
	Test{cmplx(-1, -inf), cmplx(nan, nan), cmplx(nan, nan)},
	Test{cmplx(-1, -inf), cmplx(nan, inf), cmplx(nan, nan)},
	Test{cmplx(-1, -inf), cmplx(nan, -inf), cmplx(nan, nan)},
	Test{cmplx(-1, -inf), cmplx(inf, 0), cmplx(nan, nan)},
	Test{cmplx(-1, -inf), cmplx(inf, 1), cmplx(nan, nan)},
	Test{cmplx(-1, -inf), cmplx(inf, -1), cmplx(nan, nan)},
	Test{cmplx(-1, -inf), cmplx(inf, 2), cmplx(nan, nan)},
	Test{cmplx(-1, -inf), cmplx(inf, nan), cmplx(nan, nan)},
	Test{cmplx(-1, -inf), cmplx(inf, inf), cmplx(nan, nan)},
	Test{cmplx(-1, -inf), cmplx(inf, -inf), cmplx(nan, nan)},
	Test{cmplx(-1, -inf), cmplx(-inf, 0), cmplx(nan, nan)},
	Test{cmplx(-1, -inf), cmplx(-inf, 1), cmplx(nan, nan)},
	Test{cmplx(-1, -inf), cmplx(-inf, -1), cmplx(nan, nan)},
	Test{cmplx(-1, -inf), cmplx(-inf, 2), cmplx(nan, nan)},
	Test{cmplx(-1, -inf), cmplx(-inf, nan), cmplx(nan, nan)},
	Test{cmplx(-1, -inf), cmplx(-inf, inf), cmplx(nan, nan)},
	Test{cmplx(-1, -inf), cmplx(-inf, -inf), cmplx(nan, nan)},
	Test{cmplx(2, 0), cmplx(0, 0), cmplx(inf, nan)},
	Test{cmplx(2, 0), cmplx(0, 1), cmplx(0, -2)},
	Test{cmplx(2, 0), cmplx(0, -1), cmplx(negzero, 2)},
	Test{cmplx(2, 0), cmplx(0, 2), cmplx(0, -1)},
	Test{cmplx(2, 0), cmplx(0, nan), cmplx(nan, nan)},
	Test{cmplx(2, 0), cmplx(0, inf), cmplx(0, negzero)},
	Test{cmplx(2, 0), cmplx(0, -inf), cmplx(negzero, 0)},
	Test{cmplx(2, 0), cmplx(1, 0), cmplx(2, 0)},
	Test{cmplx(2, 0), cmplx(1, 1), cmplx(1, -1)},
	Test{cmplx(2, 0), cmplx(1, -1), cmplx(1, 1)},
	Test{cmplx(2, 0), cmplx(1, 2), cmplx(0.4, -0.8)},
	Test{cmplx(2, 0), cmplx(1, nan), cmplx(nan, nan)},
	Test{cmplx(2, 0), cmplx(1, inf), cmplx(0, negzero)},
	Test{cmplx(2, 0), cmplx(1, -inf), cmplx(negzero, 0)},
	Test{cmplx(2, 0), cmplx(-1, 0), cmplx(-2, negzero)},
	Test{cmplx(2, 0), cmplx(-1, 1), cmplx(-1, -1)},
	Test{cmplx(2, 0), cmplx(-1, -1), cmplx(-1, 1)},
	Test{cmplx(2, 0), cmplx(-1, 2), cmplx(-0.4, -0.8)},
	Test{cmplx(2, 0), cmplx(-1, nan), cmplx(nan, nan)},
	Test{cmplx(2, 0), cmplx(-1, inf), cmplx(0, negzero)},
	Test{cmplx(2, 0), cmplx(-1, -inf), cmplx(negzero, 0)},
	Test{cmplx(2, 0), cmplx(2, 0), cmplx(1, 0)},
	Test{cmplx(2, 0), cmplx(2, 1), cmplx(0.8, -0.4)},
	Test{cmplx(2, 0), cmplx(2, -1), cmplx(0.8, 0.4)},
	Test{cmplx(2, 0), cmplx(2, 2), cmplx(0.5, -0.5)},
	Test{cmplx(2, 0), cmplx(2, nan), cmplx(nan, nan)},
	Test{cmplx(2, 0), cmplx(2, inf), cmplx(0, negzero)},
	Test{cmplx(2, 0), cmplx(2, -inf), cmplx(negzero, 0)},
	Test{cmplx(2, 0), cmplx(nan, 0), cmplx(nan, nan)},
	Test{cmplx(2, 0), cmplx(nan, 1), cmplx(nan, nan)},
	Test{cmplx(2, 0), cmplx(nan, -1), cmplx(nan, nan)},
	Test{cmplx(2, 0), cmplx(nan, 2), cmplx(nan, nan)},
	Test{cmplx(2, 0), cmplx(nan, nan), cmplx(nan, nan)},
	Test{cmplx(2, 0), cmplx(nan, inf), cmplx(0, negzero)},
	Test{cmplx(2, 0), cmplx(nan, -inf), cmplx(0, 0)},
	Test{cmplx(2, 0), cmplx(inf, 0), cmplx(0, 0)},
	Test{cmplx(2, 0), cmplx(inf, 1), cmplx(0, 0)},
	Test{cmplx(2, 0), cmplx(inf, -1), cmplx(0, 0)},
	Test{cmplx(2, 0), cmplx(inf, 2), cmplx(0, 0)},
	Test{cmplx(2, 0), cmplx(inf, nan), cmplx(0, 0)},
	Test{cmplx(2, 0), cmplx(inf, inf), cmplx(0, negzero)},
	Test{cmplx(2, 0), cmplx(inf, -inf), cmplx(0, 0)},
	Test{cmplx(2, 0), cmplx(-inf, 0), cmplx(negzero, negzero)},
	Test{cmplx(2, 0), cmplx(-inf, 1), cmplx(negzero, negzero)},
	Test{cmplx(2, 0), cmplx(-inf, -1), cmplx(negzero, negzero)},
	Test{cmplx(2, 0), cmplx(-inf, 2), cmplx(negzero, negzero)},
	Test{cmplx(2, 0), cmplx(-inf, nan), cmplx(negzero, negzero)},
	Test{cmplx(2, 0), cmplx(-inf, inf), cmplx(negzero, negzero)},
	Test{cmplx(2, 0), cmplx(-inf, -inf), cmplx(negzero, 0)},
	Test{cmplx(2, 1), cmplx(0, 0), cmplx(inf, inf)},
	Test{cmplx(2, 1), cmplx(0, 1), cmplx(1, -2)},
	Test{cmplx(2, 1), cmplx(0, -1), cmplx(-1, 2)},
	Test{cmplx(2, 1), cmplx(0, 2), cmplx(0.5, -1)},
	Test{cmplx(2, 1), cmplx(0, nan), cmplx(nan, nan)},
	Test{cmplx(2, 1), cmplx(0, inf), cmplx(0, negzero)},
	Test{cmplx(2, 1), cmplx(0, -inf), cmplx(negzero, 0)},
	Test{cmplx(2, 1), cmplx(1, 0), cmplx(2, 1)},
	Test{cmplx(2, 1), cmplx(1, 1), cmplx(1.5, -0.5)},
	Test{cmplx(2, 1), cmplx(1, -1), cmplx(0.5, 1.5)},
	Test{cmplx(2, 1), cmplx(1, 2), cmplx(0.8, -0.6)},
	Test{cmplx(2, 1), cmplx(1, nan), cmplx(nan, nan)},
	Test{cmplx(2, 1), cmplx(1, inf), cmplx(0, negzero)},
	Test{cmplx(2, 1), cmplx(1, -inf), cmplx(negzero, 0)},
	Test{cmplx(2, 1), cmplx(-1, 0), cmplx(-2, -1)},
	Test{cmplx(2, 1), cmplx(-1, 1), cmplx(-0.5, -1.5)},
	Test{cmplx(2, 1), cmplx(-1, -1), cmplx(-1.5, 0.5)},
	Test{cmplx(2, 1), cmplx(-1, 2), cmplx(0, -1)},
	Test{cmplx(2, 1), cmplx(-1, nan), cmplx(nan, nan)},
	Test{cmplx(2, 1), cmplx(-1, inf), cmplx(0, negzero)},
	Test{cmplx(2, 1), cmplx(-1, -inf), cmplx(negzero, 0)},
	Test{cmplx(2, 1), cmplx(2, 0), cmplx(1, 0.5)},
	Test{cmplx(2, 1), cmplx(2, 1), cmplx(1, 0)},
	Test{cmplx(2, 1), cmplx(2, -1), cmplx(0.6, 0.8)},
	Test{cmplx(2, 1), cmplx(2, 2), cmplx(0.75, -0.25)},
	Test{cmplx(2, 1), cmplx(2, nan), cmplx(nan, nan)},
	Test{cmplx(2, 1), cmplx(2, inf), cmplx(0, negzero)},
	Test{cmplx(2, 1), cmplx(2, -inf), cmplx(negzero, 0)},
	Test{cmplx(2, 1), cmplx(nan, 0), cmplx(nan, nan)},
	Test{cmplx(2, 1), cmplx(nan, 1), cmplx(nan, nan)},
	Test{cmplx(2, 1), cmplx(nan, -1), cmplx(nan, nan)},
	Test{cmplx(2, 1), cmplx(nan, 2), cmplx(nan, nan)},
	Test{cmplx(2, 1), cmplx(nan, nan), cmplx(nan, nan)},
	Test{cmplx(2, 1), cmplx(nan, inf), cmplx(0, negzero)},
	Test{cmplx(2, 1), cmplx(nan, -inf), cmplx(negzero, 0)},
	Test{cmplx(2, 1), cmplx(inf, 0), cmplx(0, 0)},
	Test{cmplx(2, 1), cmplx(inf, 1), cmplx(0, 0)},
	Test{cmplx(2, 1), cmplx(inf, -1), cmplx(0, 0)},
	Test{cmplx(2, 1), cmplx(inf, 2), cmplx(0, 0)},
	Test{cmplx(2, 1), cmplx(inf, nan), cmplx(0, 0)},
	Test{cmplx(2, 1), cmplx(inf, inf), cmplx(0, negzero)},
	Test{cmplx(2, 1), cmplx(inf, -inf), cmplx(0, 0)},
	Test{cmplx(2, 1), cmplx(-inf, 0), cmplx(negzero, negzero)},
	Test{cmplx(2, 1), cmplx(-inf, 1), cmplx(negzero, negzero)},
	Test{cmplx(2, 1), cmplx(-inf, -1), cmplx(negzero, negzero)},
	Test{cmplx(2, 1), cmplx(-inf, 2), cmplx(negzero, negzero)},
	Test{cmplx(2, 1), cmplx(-inf, nan), cmplx(negzero, negzero)},
	Test{cmplx(2, 1), cmplx(-inf, inf), cmplx(negzero, negzero)},
	Test{cmplx(2, 1), cmplx(-inf, -inf), cmplx(negzero, 0)},
	Test{cmplx(2, -1), cmplx(0, 0), cmplx(inf, -inf)},
	Test{cmplx(2, -1), cmplx(0, 1), cmplx(-1, -2)},
	Test{cmplx(2, -1), cmplx(0, -1), cmplx(1, 2)},
	Test{cmplx(2, -1), cmplx(0, 2), cmplx(-0.5, -1)},
	Test{cmplx(2, -1), cmplx(0, nan), cmplx(nan, nan)},
	Test{cmplx(2, -1), cmplx(0, inf), cmplx(negzero, negzero)},
	Test{cmplx(2, -1), cmplx(0, -inf), cmplx(0, 0)},
	Test{cmplx(2, -1), cmplx(1, 0), cmplx(2, -1)},
	Test{cmplx(2, -1), cmplx(1, 1), cmplx(0.5, -1.5)},
	Test{cmplx(2, -1), cmplx(1, -1), cmplx(1.5, 0.5)},
	Test{cmplx(2, -1), cmplx(1, 2), cmplx(0, -1)},
	Test{cmplx(2, -1), cmplx(1, nan), cmplx(nan, nan)},
	Test{cmplx(2, -1), cmplx(1, inf), cmplx(negzero, negzero)},
	Test{cmplx(2, -1), cmplx(1, -inf), cmplx(0, 0)},
	Test{cmplx(2, -1), cmplx(-1, 0), cmplx(-2, 1)},
	Test{cmplx(2, -1), cmplx(-1, 1), cmplx(-1.5, -0.5)},
	Test{cmplx(2, -1), cmplx(-1, -1), cmplx(-0.5, 1.5)},
	Test{cmplx(2, -1), cmplx(-1, 2), cmplx(-0.8, -0.6)},
	Test{cmplx(2, -1), cmplx(-1, nan), cmplx(nan, nan)},
	Test{cmplx(2, -1), cmplx(-1, inf), cmplx(negzero, negzero)},
	Test{cmplx(2, -1), cmplx(-1, -inf), cmplx(0, 0)},
	Test{cmplx(2, -1), cmplx(2, 0), cmplx(1, -0.5)},
	Test{cmplx(2, -1), cmplx(2, 1), cmplx(0.6, -0.8)},
	Test{cmplx(2, -1), cmplx(2, -1), cmplx(1, 0)},
	Test{cmplx(2, -1), cmplx(2, 2), cmplx(0.25, -0.75)},
	Test{cmplx(2, -1), cmplx(2, nan), cmplx(nan, nan)},
	Test{cmplx(2, -1), cmplx(2, inf), cmplx(negzero, negzero)},
	Test{cmplx(2, -1), cmplx(2, -inf), cmplx(0, 0)},
	Test{cmplx(2, -1), cmplx(nan, 0), cmplx(nan, nan)},
	Test{cmplx(2, -1), cmplx(nan, 1), cmplx(nan, nan)},
	Test{cmplx(2, -1), cmplx(nan, -1), cmplx(nan, nan)},
	Test{cmplx(2, -1), cmplx(nan, 2), cmplx(nan, nan)},
	Test{cmplx(2, -1), cmplx(nan, nan), cmplx(nan, nan)},
	Test{cmplx(2, -1), cmplx(nan, inf), cmplx(negzero, negzero)},
	Test{cmplx(2, -1), cmplx(nan, -inf), cmplx(0, 0)},
	Test{cmplx(2, -1), cmplx(inf, 0), cmplx(0, negzero)},
	Test{cmplx(2, -1), cmplx(inf, 1), cmplx(0, negzero)},
	Test{cmplx(2, -1), cmplx(inf, -1), cmplx(0, negzero)},
	Test{cmplx(2, -1), cmplx(inf, 2), cmplx(0, negzero)},
	Test{cmplx(2, -1), cmplx(inf, nan), cmplx(0, negzero)},
	Test{cmplx(2, -1), cmplx(inf, inf), cmplx(0, negzero)},
	Test{cmplx(2, -1), cmplx(inf, -inf), cmplx(0, 0)},
	Test{cmplx(2, -1), cmplx(-inf, 0), cmplx(negzero, 0)},
	Test{cmplx(2, -1), cmplx(-inf, 1), cmplx(negzero, 0)},
	Test{cmplx(2, -1), cmplx(-inf, -1), cmplx(negzero, 0)},
	Test{cmplx(2, -1), cmplx(-inf, 2), cmplx(negzero, 0)},
	Test{cmplx(2, -1), cmplx(-inf, nan), cmplx(negzero, 0)},
	Test{cmplx(2, -1), cmplx(-inf, inf), cmplx(negzero, negzero)},
	Test{cmplx(2, -1), cmplx(-inf, -inf), cmplx(negzero, 0)},
	Test{cmplx(2, 2), cmplx(0, 0), cmplx(inf, inf)},
	Test{cmplx(2, 2), cmplx(0, 1), cmplx(2, -2)},
	Test{cmplx(2, 2), cmplx(0, -1), cmplx(-2, 2)},
	Test{cmplx(2, 2), cmplx(0, 2), cmplx(1, -1)},
	Test{cmplx(2, 2), cmplx(0, nan), cmplx(nan, nan)},
	Test{cmplx(2, 2), cmplx(0, inf), cmplx(0, negzero)},
	Test{cmplx(2, 2), cmplx(0, -inf), cmplx(negzero, 0)},
	Test{cmplx(2, 2), cmplx(1, 0), cmplx(2, 2)},
	Test{cmplx(2, 2), cmplx(1, 1), cmplx(2, 0)},
	Test{cmplx(2, 2), cmplx(1, -1), cmplx(0, 2)},
	Test{cmplx(2, 2), cmplx(1, 2), cmplx(1.2, -0.4)},
	Test{cmplx(2, 2), cmplx(1, nan), cmplx(nan, nan)},
	Test{cmplx(2, 2), cmplx(1, inf), cmplx(0, negzero)},
	Test{cmplx(2, 2), cmplx(1, -inf), cmplx(negzero, 0)},
	Test{cmplx(2, 2), cmplx(-1, 0), cmplx(-2, -2)},
	Test{cmplx(2, 2), cmplx(-1, 1), cmplx(negzero, -2)},
	Test{cmplx(2, 2), cmplx(-1, -1), cmplx(-2, negzero)},
	Test{cmplx(2, 2), cmplx(-1, 2), cmplx(0.4, -1.2)},
	Test{cmplx(2, 2), cmplx(-1, nan), cmplx(nan, nan)},
	Test{cmplx(2, 2), cmplx(-1, inf), cmplx(0, negzero)},
	Test{cmplx(2, 2), cmplx(-1, -inf), cmplx(negzero, 0)},
	Test{cmplx(2, 2), cmplx(2, 0), cmplx(1, 1)},
	Test{cmplx(2, 2), cmplx(2, 1), cmplx(1.2, 0.4)},
	Test{cmplx(2, 2), cmplx(2, -1), cmplx(0.4, 1.2)},
	Test{cmplx(2, 2), cmplx(2, 2), cmplx(1, 0)},
	Test{cmplx(2, 2), cmplx(2, nan), cmplx(nan, nan)},
	Test{cmplx(2, 2), cmplx(2, inf), cmplx(0, negzero)},
	Test{cmplx(2, 2), cmplx(2, -inf), cmplx(negzero, 0)},
	Test{cmplx(2, 2), cmplx(nan, 0), cmplx(nan, nan)},
	Test{cmplx(2, 2), cmplx(nan, 1), cmplx(nan, nan)},
	Test{cmplx(2, 2), cmplx(nan, -1), cmplx(nan, nan)},
	Test{cmplx(2, 2), cmplx(nan, 2), cmplx(nan, nan)},
	Test{cmplx(2, 2), cmplx(nan, nan), cmplx(nan, nan)},
	Test{cmplx(2, 2), cmplx(nan, inf), cmplx(0, negzero)},
	Test{cmplx(2, 2), cmplx(nan, -inf), cmplx(negzero, 0)},
	Test{cmplx(2, 2), cmplx(inf, 0), cmplx(0, 0)},
	Test{cmplx(2, 2), cmplx(inf, 1), cmplx(0, 0)},
	Test{cmplx(2, 2), cmplx(inf, -1), cmplx(0, 0)},
	Test{cmplx(2, 2), cmplx(inf, 2), cmplx(0, 0)},
	Test{cmplx(2, 2), cmplx(inf, nan), cmplx(0, 0)},
	Test{cmplx(2, 2), cmplx(inf, inf), cmplx(0, 0)},
	Test{cmplx(2, 2), cmplx(inf, -inf), cmplx(0, 0)},
	Test{cmplx(2, 2), cmplx(-inf, 0), cmplx(negzero, negzero)},
	Test{cmplx(2, 2), cmplx(-inf, 1), cmplx(negzero, negzero)},
	Test{cmplx(2, 2), cmplx(-inf, -1), cmplx(negzero, negzero)},
	Test{cmplx(2, 2), cmplx(-inf, 2), cmplx(negzero, negzero)},
	Test{cmplx(2, 2), cmplx(-inf, nan), cmplx(negzero, negzero)},
	Test{cmplx(2, 2), cmplx(-inf, inf), cmplx(0, negzero)},
	Test{cmplx(2, 2), cmplx(-inf, -inf), cmplx(negzero, 0)},
	Test{cmplx(2, nan), cmplx(0, 0), cmplx(nan, nan)},
	Test{cmplx(2, nan), cmplx(0, 1), cmplx(nan, nan)},
	Test{cmplx(2, nan), cmplx(0, -1), cmplx(nan, nan)},
	Test{cmplx(2, nan), cmplx(0, 2), cmplx(nan, nan)},
	Test{cmplx(2, nan), cmplx(0, nan), cmplx(nan, nan)},
	Test{cmplx(2, nan), cmplx(0, inf), cmplx(nan, nan)},
	Test{cmplx(2, nan), cmplx(0, -inf), cmplx(nan, nan)},
	Test{cmplx(2, nan), cmplx(1, 0), cmplx(nan, nan)},
	Test{cmplx(2, nan), cmplx(1, 1), cmplx(nan, nan)},
	Test{cmplx(2, nan), cmplx(1, -1), cmplx(nan, nan)},
	Test{cmplx(2, nan), cmplx(1, 2), cmplx(nan, nan)},
	Test{cmplx(2, nan), cmplx(1, nan), cmplx(nan, nan)},
	Test{cmplx(2, nan), cmplx(1, inf), cmplx(nan, nan)},
	Test{cmplx(2, nan), cmplx(1, -inf), cmplx(nan, nan)},
	Test{cmplx(2, nan), cmplx(-1, 0), cmplx(nan, nan)},
	Test{cmplx(2, nan), cmplx(-1, 1), cmplx(nan, nan)},
	Test{cmplx(2, nan), cmplx(-1, -1), cmplx(nan, nan)},
	Test{cmplx(2, nan), cmplx(-1, 2), cmplx(nan, nan)},
	Test{cmplx(2, nan), cmplx(-1, nan), cmplx(nan, nan)},
	Test{cmplx(2, nan), cmplx(-1, inf), cmplx(nan, nan)},
	Test{cmplx(2, nan), cmplx(-1, -inf), cmplx(nan, nan)},
	Test{cmplx(2, nan), cmplx(2, 0), cmplx(nan, nan)},
	Test{cmplx(2, nan), cmplx(2, 1), cmplx(nan, nan)},
	Test{cmplx(2, nan), cmplx(2, -1), cmplx(nan, nan)},
	Test{cmplx(2, nan), cmplx(2, 2), cmplx(nan, nan)},
	Test{cmplx(2, nan), cmplx(2, nan), cmplx(nan, nan)},
	Test{cmplx(2, nan), cmplx(2, inf), cmplx(nan, nan)},
	Test{cmplx(2, nan), cmplx(2, -inf), cmplx(nan, nan)},
	Test{cmplx(2, nan), cmplx(nan, 0), cmplx(nan, nan)},
	Test{cmplx(2, nan), cmplx(nan, 1), cmplx(nan, nan)},
	Test{cmplx(2, nan), cmplx(nan, -1), cmplx(nan, nan)},
	Test{cmplx(2, nan), cmplx(nan, 2), cmplx(nan, nan)},
	Test{cmplx(2, nan), cmplx(nan, nan), cmplx(nan, nan)},
	Test{cmplx(2, nan), cmplx(nan, inf), cmplx(nan, nan)},
	Test{cmplx(2, nan), cmplx(nan, -inf), cmplx(nan, nan)},
	Test{cmplx(2, nan), cmplx(inf, 0), cmplx(nan, nan)},
	Test{cmplx(2, nan), cmplx(inf, 1), cmplx(nan, nan)},
	Test{cmplx(2, nan), cmplx(inf, -1), cmplx(nan, nan)},
	Test{cmplx(2, nan), cmplx(inf, 2), cmplx(nan, nan)},
	Test{cmplx(2, nan), cmplx(inf, nan), cmplx(nan, nan)},
	Test{cmplx(2, nan), cmplx(inf, inf), cmplx(nan, nan)},
	Test{cmplx(2, nan), cmplx(inf, -inf), cmplx(nan, nan)},
	Test{cmplx(2, nan), cmplx(-inf, 0), cmplx(nan, nan)},
	Test{cmplx(2, nan), cmplx(-inf, 1), cmplx(nan, nan)},
	Test{cmplx(2, nan), cmplx(-inf, -1), cmplx(nan, nan)},
	Test{cmplx(2, nan), cmplx(-inf, 2), cmplx(nan, nan)},
	Test{cmplx(2, nan), cmplx(-inf, nan), cmplx(nan, nan)},
	Test{cmplx(2, nan), cmplx(-inf, inf), cmplx(nan, nan)},
	Test{cmplx(2, nan), cmplx(-inf, -inf), cmplx(nan, nan)},
	Test{cmplx(2, inf), cmplx(0, 0), cmplx(inf, inf)},
	Test{cmplx(2, inf), cmplx(0, 1), cmplx(inf, nan)},
	Test{cmplx(2, inf), cmplx(0, -1), cmplx(-inf, nan)},
	Test{cmplx(2, inf), cmplx(0, 2), cmplx(inf, nan)},
	Test{cmplx(2, inf), cmplx(0, nan), cmplx(nan, nan)},
	Test{cmplx(2, inf), cmplx(0, inf), cmplx(nan, nan)},
	Test{cmplx(2, inf), cmplx(0, -inf), cmplx(nan, nan)},
	Test{cmplx(2, inf), cmplx(1, 0), cmplx(nan, inf)},
	Test{cmplx(2, inf), cmplx(1, 1), cmplx(inf, inf)},
	Test{cmplx(2, inf), cmplx(1, -1), cmplx(-inf, inf)},
	Test{cmplx(2, inf), cmplx(1, 2), cmplx(inf, inf)},
	Test{cmplx(2, inf), cmplx(1, nan), cmplx(nan, nan)},
	Test{cmplx(2, inf), cmplx(1, inf), cmplx(nan, nan)},
	Test{cmplx(2, inf), cmplx(1, -inf), cmplx(nan, nan)},
	Test{cmplx(2, inf), cmplx(-1, 0), cmplx(nan, -inf)},
	Test{cmplx(2, inf), cmplx(-1, 1), cmplx(inf, -inf)},
	Test{cmplx(2, inf), cmplx(-1, -1), cmplx(-inf, -inf)},
	Test{cmplx(2, inf), cmplx(-1, 2), cmplx(inf, -inf)},
	Test{cmplx(2, inf), cmplx(-1, nan), cmplx(nan, nan)},
	Test{cmplx(2, inf), cmplx(-1, inf), cmplx(nan, nan)},
	Test{cmplx(2, inf), cmplx(-1, -inf), cmplx(nan, nan)},
	Test{cmplx(2, inf), cmplx(2, 0), cmplx(nan, inf)},
	Test{cmplx(2, inf), cmplx(2, 1), cmplx(inf, inf)},
	Test{cmplx(2, inf), cmplx(2, -1), cmplx(-inf, inf)},
	Test{cmplx(2, inf), cmplx(2, 2), cmplx(inf, inf)},
	Test{cmplx(2, inf), cmplx(2, nan), cmplx(nan, nan)},
	Test{cmplx(2, inf), cmplx(2, inf), cmplx(nan, nan)},
	Test{cmplx(2, inf), cmplx(2, -inf), cmplx(nan, nan)},
	Test{cmplx(2, inf), cmplx(nan, 0), cmplx(nan, nan)},
	Test{cmplx(2, inf), cmplx(nan, 1), cmplx(nan, nan)},
	Test{cmplx(2, inf), cmplx(nan, -1), cmplx(nan, nan)},
	Test{cmplx(2, inf), cmplx(nan, 2), cmplx(nan, nan)},
	Test{cmplx(2, inf), cmplx(nan, nan), cmplx(nan, nan)},
	Test{cmplx(2, inf), cmplx(nan, inf), cmplx(nan, nan)},
	Test{cmplx(2, inf), cmplx(nan, -inf), cmplx(nan, nan)},
	Test{cmplx(2, inf), cmplx(inf, 0), cmplx(nan, nan)},
	Test{cmplx(2, inf), cmplx(inf, 1), cmplx(nan, nan)},
	Test{cmplx(2, inf), cmplx(inf, -1), cmplx(nan, nan)},
	Test{cmplx(2, inf), cmplx(inf, 2), cmplx(nan, nan)},
	Test{cmplx(2, inf), cmplx(inf, nan), cmplx(nan, nan)},
	Test{cmplx(2, inf), cmplx(inf, inf), cmplx(nan, nan)},
	Test{cmplx(2, inf), cmplx(inf, -inf), cmplx(nan, nan)},
	Test{cmplx(2, inf), cmplx(-inf, 0), cmplx(nan, nan)},
	Test{cmplx(2, inf), cmplx(-inf, 1), cmplx(nan, nan)},
	Test{cmplx(2, inf), cmplx(-inf, -1), cmplx(nan, nan)},
	Test{cmplx(2, inf), cmplx(-inf, 2), cmplx(nan, nan)},
	Test{cmplx(2, inf), cmplx(-inf, nan), cmplx(nan, nan)},
	Test{cmplx(2, inf), cmplx(-inf, inf), cmplx(nan, nan)},
	Test{cmplx(2, inf), cmplx(-inf, -inf), cmplx(nan, nan)},
	Test{cmplx(2, -inf), cmplx(0, 0), cmplx(inf, -inf)},
	Test{cmplx(2, -inf), cmplx(0, 1), cmplx(-inf, nan)},
	Test{cmplx(2, -inf), cmplx(0, -1), cmplx(inf, nan)},
	Test{cmplx(2, -inf), cmplx(0, 2), cmplx(-inf, nan)},
	Test{cmplx(2, -inf), cmplx(0, nan), cmplx(nan, nan)},
	Test{cmplx(2, -inf), cmplx(0, inf), cmplx(nan, nan)},
	Test{cmplx(2, -inf), cmplx(0, -inf), cmplx(nan, nan)},
	Test{cmplx(2, -inf), cmplx(1, 0), cmplx(nan, -inf)},
	Test{cmplx(2, -inf), cmplx(1, 1), cmplx(-inf, -inf)},
	Test{cmplx(2, -inf), cmplx(1, -1), cmplx(inf, -inf)},
	Test{cmplx(2, -inf), cmplx(1, 2), cmplx(-inf, -inf)},
	Test{cmplx(2, -inf), cmplx(1, nan), cmplx(nan, nan)},
	Test{cmplx(2, -inf), cmplx(1, inf), cmplx(nan, nan)},
	Test{cmplx(2, -inf), cmplx(1, -inf), cmplx(nan, nan)},
	Test{cmplx(2, -inf), cmplx(-1, 0), cmplx(nan, inf)},
	Test{cmplx(2, -inf), cmplx(-1, 1), cmplx(-inf, inf)},
	Test{cmplx(2, -inf), cmplx(-1, -1), cmplx(inf, inf)},
	Test{cmplx(2, -inf), cmplx(-1, 2), cmplx(-inf, inf)},
	Test{cmplx(2, -inf), cmplx(-1, nan), cmplx(nan, nan)},
	Test{cmplx(2, -inf), cmplx(-1, inf), cmplx(nan, nan)},
	Test{cmplx(2, -inf), cmplx(-1, -inf), cmplx(nan, nan)},
	Test{cmplx(2, -inf), cmplx(2, 0), cmplx(nan, -inf)},
	Test{cmplx(2, -inf), cmplx(2, 1), cmplx(-inf, -inf)},
	Test{cmplx(2, -inf), cmplx(2, -1), cmplx(inf, -inf)},
	Test{cmplx(2, -inf), cmplx(2, 2), cmplx(-inf, -inf)},
	Test{cmplx(2, -inf), cmplx(2, nan), cmplx(nan, nan)},
	Test{cmplx(2, -inf), cmplx(2, inf), cmplx(nan, nan)},
	Test{cmplx(2, -inf), cmplx(2, -inf), cmplx(nan, nan)},
	Test{cmplx(2, -inf), cmplx(nan, 0), cmplx(nan, nan)},
	Test{cmplx(2, -inf), cmplx(nan, 1), cmplx(nan, nan)},
	Test{cmplx(2, -inf), cmplx(nan, -1), cmplx(nan, nan)},
	Test{cmplx(2, -inf), cmplx(nan, 2), cmplx(nan, nan)},
	Test{cmplx(2, -inf), cmplx(nan, nan), cmplx(nan, nan)},
	Test{cmplx(2, -inf), cmplx(nan, inf), cmplx(nan, nan)},
	Test{cmplx(2, -inf), cmplx(nan, -inf), cmplx(nan, nan)},
	Test{cmplx(2, -inf), cmplx(inf, 0), cmplx(nan, nan)},
	Test{cmplx(2, -inf), cmplx(inf, 1), cmplx(nan, nan)},
	Test{cmplx(2, -inf), cmplx(inf, -1), cmplx(nan, nan)},
	Test{cmplx(2, -inf), cmplx(inf, 2), cmplx(nan, nan)},
	Test{cmplx(2, -inf), cmplx(inf, nan), cmplx(nan, nan)},
	Test{cmplx(2, -inf), cmplx(inf, inf), cmplx(nan, nan)},
	Test{cmplx(2, -inf), cmplx(inf, -inf), cmplx(nan, nan)},
	Test{cmplx(2, -inf), cmplx(-inf, 0), cmplx(nan, nan)},
	Test{cmplx(2, -inf), cmplx(-inf, 1), cmplx(nan, nan)},
	Test{cmplx(2, -inf), cmplx(-inf, -1), cmplx(nan, nan)},
	Test{cmplx(2, -inf), cmplx(-inf, 2), cmplx(nan, nan)},
	Test{cmplx(2, -inf), cmplx(-inf, nan), cmplx(nan, nan)},
	Test{cmplx(2, -inf), cmplx(-inf, inf), cmplx(nan, nan)},
	Test{cmplx(2, -inf), cmplx(-inf, -inf), cmplx(nan, nan)},
	Test{cmplx(nan, 0), cmplx(0, 0), cmplx(nan, nan)},
	Test{cmplx(nan, 0), cmplx(0, 1), cmplx(nan, nan)},
	Test{cmplx(nan, 0), cmplx(0, -1), cmplx(nan, nan)},
	Test{cmplx(nan, 0), cmplx(0, 2), cmplx(nan, nan)},
	Test{cmplx(nan, 0), cmplx(0, nan), cmplx(nan, nan)},
	Test{cmplx(nan, 0), cmplx(0, inf), cmplx(nan, nan)},
	Test{cmplx(nan, 0), cmplx(0, -inf), cmplx(nan, nan)},
	Test{cmplx(nan, 0), cmplx(1, 0), cmplx(nan, nan)},
	Test{cmplx(nan, 0), cmplx(1, 1), cmplx(nan, nan)},
	Test{cmplx(nan, 0), cmplx(1, -1), cmplx(nan, nan)},
	Test{cmplx(nan, 0), cmplx(1, 2), cmplx(nan, nan)},
	Test{cmplx(nan, 0), cmplx(1, nan), cmplx(nan, nan)},
	Test{cmplx(nan, 0), cmplx(1, inf), cmplx(nan, nan)},
	Test{cmplx(nan, 0), cmplx(1, -inf), cmplx(nan, nan)},
	Test{cmplx(nan, 0), cmplx(-1, 0), cmplx(nan, nan)},
	Test{cmplx(nan, 0), cmplx(-1, 1), cmplx(nan, nan)},
	Test{cmplx(nan, 0), cmplx(-1, -1), cmplx(nan, nan)},
	Test{cmplx(nan, 0), cmplx(-1, 2), cmplx(nan, nan)},
	Test{cmplx(nan, 0), cmplx(-1, nan), cmplx(nan, nan)},
	Test{cmplx(nan, 0), cmplx(-1, inf), cmplx(nan, nan)},
	Test{cmplx(nan, 0), cmplx(-1, -inf), cmplx(nan, nan)},
	Test{cmplx(nan, 0), cmplx(2, 0), cmplx(nan, nan)},
	Test{cmplx(nan, 0), cmplx(2, 1), cmplx(nan, nan)},
	Test{cmplx(nan, 0), cmplx(2, -1), cmplx(nan, nan)},
	Test{cmplx(nan, 0), cmplx(2, 2), cmplx(nan, nan)},
	Test{cmplx(nan, 0), cmplx(2, nan), cmplx(nan, nan)},
	Test{cmplx(nan, 0), cmplx(2, inf), cmplx(nan, nan)},
	Test{cmplx(nan, 0), cmplx(2, -inf), cmplx(nan, nan)},
	Test{cmplx(nan, 0), cmplx(nan, 0), cmplx(nan, nan)},
	Test{cmplx(nan, 0), cmplx(nan, 1), cmplx(nan, nan)},
	Test{cmplx(nan, 0), cmplx(nan, -1), cmplx(nan, nan)},
	Test{cmplx(nan, 0), cmplx(nan, 2), cmplx(nan, nan)},
	Test{cmplx(nan, 0), cmplx(nan, nan), cmplx(nan, nan)},
	Test{cmplx(nan, 0), cmplx(nan, inf), cmplx(nan, nan)},
	Test{cmplx(nan, 0), cmplx(nan, -inf), cmplx(nan, nan)},
	Test{cmplx(nan, 0), cmplx(inf, 0), cmplx(nan, nan)},
	Test{cmplx(nan, 0), cmplx(inf, 1), cmplx(nan, nan)},
	Test{cmplx(nan, 0), cmplx(inf, -1), cmplx(nan, nan)},
	Test{cmplx(nan, 0), cmplx(inf, 2), cmplx(nan, nan)},
	Test{cmplx(nan, 0), cmplx(inf, nan), cmplx(nan, nan)},
	Test{cmplx(nan, 0), cmplx(inf, inf), cmplx(nan, nan)},
	Test{cmplx(nan, 0), cmplx(inf, -inf), cmplx(nan, nan)},
	Test{cmplx(nan, 0), cmplx(-inf, 0), cmplx(nan, nan)},
	Test{cmplx(nan, 0), cmplx(-inf, 1), cmplx(nan, nan)},
	Test{cmplx(nan, 0), cmplx(-inf, -1), cmplx(nan, nan)},
	Test{cmplx(nan, 0), cmplx(-inf, 2), cmplx(nan, nan)},
	Test{cmplx(nan, 0), cmplx(-inf, nan), cmplx(nan, nan)},
	Test{cmplx(nan, 0), cmplx(-inf, inf), cmplx(nan, nan)},
	Test{cmplx(nan, 0), cmplx(-inf, -inf), cmplx(nan, nan)},
	Test{cmplx(nan, 1), cmplx(0, 0), cmplx(nan, nan)},
	Test{cmplx(nan, 1), cmplx(0, 1), cmplx(nan, nan)},
	Test{cmplx(nan, 1), cmplx(0, -1), cmplx(nan, nan)},
	Test{cmplx(nan, 1), cmplx(0, 2), cmplx(nan, nan)},
	Test{cmplx(nan, 1), cmplx(0, nan), cmplx(nan, nan)},
	Test{cmplx(nan, 1), cmplx(0, inf), cmplx(nan, nan)},
	Test{cmplx(nan, 1), cmplx(0, -inf), cmplx(nan, nan)},
	Test{cmplx(nan, 1), cmplx(1, 0), cmplx(nan, nan)},
	Test{cmplx(nan, 1), cmplx(1, 1), cmplx(nan, nan)},
	Test{cmplx(nan, 1), cmplx(1, -1), cmplx(nan, nan)},
	Test{cmplx(nan, 1), cmplx(1, 2), cmplx(nan, nan)},
	Test{cmplx(nan, 1), cmplx(1, nan), cmplx(nan, nan)},
	Test{cmplx(nan, 1), cmplx(1, inf), cmplx(nan, nan)},
	Test{cmplx(nan, 1), cmplx(1, -inf), cmplx(nan, nan)},
	Test{cmplx(nan, 1), cmplx(-1, 0), cmplx(nan, nan)},
	Test{cmplx(nan, 1), cmplx(-1, 1), cmplx(nan, nan)},
	Test{cmplx(nan, 1), cmplx(-1, -1), cmplx(nan, nan)},
	Test{cmplx(nan, 1), cmplx(-1, 2), cmplx(nan, nan)},
	Test{cmplx(nan, 1), cmplx(-1, nan), cmplx(nan, nan)},
	Test{cmplx(nan, 1), cmplx(-1, inf), cmplx(nan, nan)},
	Test{cmplx(nan, 1), cmplx(-1, -inf), cmplx(nan, nan)},
	Test{cmplx(nan, 1), cmplx(2, 0), cmplx(nan, nan)},
	Test{cmplx(nan, 1), cmplx(2, 1), cmplx(nan, nan)},
	Test{cmplx(nan, 1), cmplx(2, -1), cmplx(nan, nan)},
	Test{cmplx(nan, 1), cmplx(2, 2), cmplx(nan, nan)},
	Test{cmplx(nan, 1), cmplx(2, nan), cmplx(nan, nan)},
	Test{cmplx(nan, 1), cmplx(2, inf), cmplx(nan, nan)},
	Test{cmplx(nan, 1), cmplx(2, -inf), cmplx(nan, nan)},
	Test{cmplx(nan, 1), cmplx(nan, 0), cmplx(nan, nan)},
	Test{cmplx(nan, 1), cmplx(nan, 1), cmplx(nan, nan)},
	Test{cmplx(nan, 1), cmplx(nan, -1), cmplx(nan, nan)},
	Test{cmplx(nan, 1), cmplx(nan, 2), cmplx(nan, nan)},
	Test{cmplx(nan, 1), cmplx(nan, nan), cmplx(nan, nan)},
	Test{cmplx(nan, 1), cmplx(nan, inf), cmplx(nan, nan)},
	Test{cmplx(nan, 1), cmplx(nan, -inf), cmplx(nan, nan)},
	Test{cmplx(nan, 1), cmplx(inf, 0), cmplx(nan, nan)},
	Test{cmplx(nan, 1), cmplx(inf, 1), cmplx(nan, nan)},
	Test{cmplx(nan, 1), cmplx(inf, -1), cmplx(nan, nan)},
	Test{cmplx(nan, 1), cmplx(inf, 2), cmplx(nan, nan)},
	Test{cmplx(nan, 1), cmplx(inf, nan), cmplx(nan, nan)},
	Test{cmplx(nan, 1), cmplx(inf, inf), cmplx(nan, nan)},
	Test{cmplx(nan, 1), cmplx(inf, -inf), cmplx(nan, nan)},
	Test{cmplx(nan, 1), cmplx(-inf, 0), cmplx(nan, nan)},
	Test{cmplx(nan, 1), cmplx(-inf, 1), cmplx(nan, nan)},
	Test{cmplx(nan, 1), cmplx(-inf, -1), cmplx(nan, nan)},
	Test{cmplx(nan, 1), cmplx(-inf, 2), cmplx(nan, nan)},
	Test{cmplx(nan, 1), cmplx(-inf, nan), cmplx(nan, nan)},
	Test{cmplx(nan, 1), cmplx(-inf, inf), cmplx(nan, nan)},
	Test{cmplx(nan, 1), cmplx(-inf, -inf), cmplx(nan, nan)},
	Test{cmplx(nan, -1), cmplx(0, 0), cmplx(nan, nan)},
	Test{cmplx(nan, -1), cmplx(0, 1), cmplx(nan, nan)},
	Test{cmplx(nan, -1), cmplx(0, -1), cmplx(nan, nan)},
	Test{cmplx(nan, -1), cmplx(0, 2), cmplx(nan, nan)},
	Test{cmplx(nan, -1), cmplx(0, nan), cmplx(nan, nan)},
	Test{cmplx(nan, -1), cmplx(0, inf), cmplx(nan, nan)},
	Test{cmplx(nan, -1), cmplx(0, -inf), cmplx(nan, nan)},
	Test{cmplx(nan, -1), cmplx(1, 0), cmplx(nan, nan)},
	Test{cmplx(nan, -1), cmplx(1, 1), cmplx(nan, nan)},
	Test{cmplx(nan, -1), cmplx(1, -1), cmplx(nan, nan)},
	Test{cmplx(nan, -1), cmplx(1, 2), cmplx(nan, nan)},
	Test{cmplx(nan, -1), cmplx(1, nan), cmplx(nan, nan)},
	Test{cmplx(nan, -1), cmplx(1, inf), cmplx(nan, nan)},
	Test{cmplx(nan, -1), cmplx(1, -inf), cmplx(nan, nan)},
	Test{cmplx(nan, -1), cmplx(-1, 0), cmplx(nan, nan)},
	Test{cmplx(nan, -1), cmplx(-1, 1), cmplx(nan, nan)},
	Test{cmplx(nan, -1), cmplx(-1, -1), cmplx(nan, nan)},
	Test{cmplx(nan, -1), cmplx(-1, 2), cmplx(nan, nan)},
	Test{cmplx(nan, -1), cmplx(-1, nan), cmplx(nan, nan)},
	Test{cmplx(nan, -1), cmplx(-1, inf), cmplx(nan, nan)},
	Test{cmplx(nan, -1), cmplx(-1, -inf), cmplx(nan, nan)},
	Test{cmplx(nan, -1), cmplx(2, 0), cmplx(nan, nan)},
	Test{cmplx(nan, -1), cmplx(2, 1), cmplx(nan, nan)},
	Test{cmplx(nan, -1), cmplx(2, -1), cmplx(nan, nan)},
	Test{cmplx(nan, -1), cmplx(2, 2), cmplx(nan, nan)},
	Test{cmplx(nan, -1), cmplx(2, nan), cmplx(nan, nan)},
	Test{cmplx(nan, -1), cmplx(2, inf), cmplx(nan, nan)},
	Test{cmplx(nan, -1), cmplx(2, -inf), cmplx(nan, nan)},
	Test{cmplx(nan, -1), cmplx(nan, 0), cmplx(nan, nan)},
	Test{cmplx(nan, -1), cmplx(nan, 1), cmplx(nan, nan)},
	Test{cmplx(nan, -1), cmplx(nan, -1), cmplx(nan, nan)},
	Test{cmplx(nan, -1), cmplx(nan, 2), cmplx(nan, nan)},
	Test{cmplx(nan, -1), cmplx(nan, nan), cmplx(nan, nan)},
	Test{cmplx(nan, -1), cmplx(nan, inf), cmplx(nan, nan)},
	Test{cmplx(nan, -1), cmplx(nan, -inf), cmplx(nan, nan)},
	Test{cmplx(nan, -1), cmplx(inf, 0), cmplx(nan, nan)},
	Test{cmplx(nan, -1), cmplx(inf, 1), cmplx(nan, nan)},
	Test{cmplx(nan, -1), cmplx(inf, -1), cmplx(nan, nan)},
	Test{cmplx(nan, -1), cmplx(inf, 2), cmplx(nan, nan)},
	Test{cmplx(nan, -1), cmplx(inf, nan), cmplx(nan, nan)},
	Test{cmplx(nan, -1), cmplx(inf, inf), cmplx(nan, nan)},
	Test{cmplx(nan, -1), cmplx(inf, -inf), cmplx(nan, nan)},
	Test{cmplx(nan, -1), cmplx(-inf, 0), cmplx(nan, nan)},
	Test{cmplx(nan, -1), cmplx(-inf, 1), cmplx(nan, nan)},
	Test{cmplx(nan, -1), cmplx(-inf, -1), cmplx(nan, nan)},
	Test{cmplx(nan, -1), cmplx(-inf, 2), cmplx(nan, nan)},
	Test{cmplx(nan, -1), cmplx(-inf, nan), cmplx(nan, nan)},
	Test{cmplx(nan, -1), cmplx(-inf, inf), cmplx(nan, nan)},
	Test{cmplx(nan, -1), cmplx(-inf, -inf), cmplx(nan, nan)},
	Test{cmplx(nan, 2), cmplx(0, 0), cmplx(nan, nan)},
	Test{cmplx(nan, 2), cmplx(0, 1), cmplx(nan, nan)},
	Test{cmplx(nan, 2), cmplx(0, -1), cmplx(nan, nan)},
	Test{cmplx(nan, 2), cmplx(0, 2), cmplx(nan, nan)},
	Test{cmplx(nan, 2), cmplx(0, nan), cmplx(nan, nan)},
	Test{cmplx(nan, 2), cmplx(0, inf), cmplx(nan, nan)},
	Test{cmplx(nan, 2), cmplx(0, -inf), cmplx(nan, nan)},
	Test{cmplx(nan, 2), cmplx(1, 0), cmplx(nan, nan)},
	Test{cmplx(nan, 2), cmplx(1, 1), cmplx(nan, nan)},
	Test{cmplx(nan, 2), cmplx(1, -1), cmplx(nan, nan)},
	Test{cmplx(nan, 2), cmplx(1, 2), cmplx(nan, nan)},
	Test{cmplx(nan, 2), cmplx(1, nan), cmplx(nan, nan)},
	Test{cmplx(nan, 2), cmplx(1, inf), cmplx(nan, nan)},
	Test{cmplx(nan, 2), cmplx(1, -inf), cmplx(nan, nan)},
	Test{cmplx(nan, 2), cmplx(-1, 0), cmplx(nan, nan)},
	Test{cmplx(nan, 2), cmplx(-1, 1), cmplx(nan, nan)},
	Test{cmplx(nan, 2), cmplx(-1, -1), cmplx(nan, nan)},
	Test{cmplx(nan, 2), cmplx(-1, 2), cmplx(nan, nan)},
	Test{cmplx(nan, 2), cmplx(-1, nan), cmplx(nan, nan)},
	Test{cmplx(nan, 2), cmplx(-1, inf), cmplx(nan, nan)},
	Test{cmplx(nan, 2), cmplx(-1, -inf), cmplx(nan, nan)},
	Test{cmplx(nan, 2), cmplx(2, 0), cmplx(nan, nan)},
	Test{cmplx(nan, 2), cmplx(2, 1), cmplx(nan, nan)},
	Test{cmplx(nan, 2), cmplx(2, -1), cmplx(nan, nan)},
	Test{cmplx(nan, 2), cmplx(2, 2), cmplx(nan, nan)},
	Test{cmplx(nan, 2), cmplx(2, nan), cmplx(nan, nan)},
	Test{cmplx(nan, 2), cmplx(2, inf), cmplx(nan, nan)},
	Test{cmplx(nan, 2), cmplx(2, -inf), cmplx(nan, nan)},
	Test{cmplx(nan, 2), cmplx(nan, 0), cmplx(nan, nan)},
	Test{cmplx(nan, 2), cmplx(nan, 1), cmplx(nan, nan)},
	Test{cmplx(nan, 2), cmplx(nan, -1), cmplx(nan, nan)},
	Test{cmplx(nan, 2), cmplx(nan, 2), cmplx(nan, nan)},
	Test{cmplx(nan, 2), cmplx(nan, nan), cmplx(nan, nan)},
	Test{cmplx(nan, 2), cmplx(nan, inf), cmplx(nan, nan)},
	Test{cmplx(nan, 2), cmplx(nan, -inf), cmplx(nan, nan)},
	Test{cmplx(nan, 2), cmplx(inf, 0), cmplx(nan, nan)},
	Test{cmplx(nan, 2), cmplx(inf, 1), cmplx(nan, nan)},
	Test{cmplx(nan, 2), cmplx(inf, -1), cmplx(nan, nan)},
	Test{cmplx(nan, 2), cmplx(inf, 2), cmplx(nan, nan)},
	Test{cmplx(nan, 2), cmplx(inf, nan), cmplx(nan, nan)},
	Test{cmplx(nan, 2), cmplx(inf, inf), cmplx(nan, nan)},
	Test{cmplx(nan, 2), cmplx(inf, -inf), cmplx(nan, nan)},
	Test{cmplx(nan, 2), cmplx(-inf, 0), cmplx(nan, nan)},
	Test{cmplx(nan, 2), cmplx(-inf, 1), cmplx(nan, nan)},
	Test{cmplx(nan, 2), cmplx(-inf, -1), cmplx(nan, nan)},
	Test{cmplx(nan, 2), cmplx(-inf, 2), cmplx(nan, nan)},
	Test{cmplx(nan, 2), cmplx(-inf, nan), cmplx(nan, nan)},
	Test{cmplx(nan, 2), cmplx(-inf, inf), cmplx(nan, nan)},
	Test{cmplx(nan, 2), cmplx(-inf, -inf), cmplx(nan, nan)},
	Test{cmplx(nan, nan), cmplx(0, 0), cmplx(nan, nan)},
	Test{cmplx(nan, nan), cmplx(0, 1), cmplx(nan, nan)},
	Test{cmplx(nan, nan), cmplx(0, -1), cmplx(nan, nan)},
	Test{cmplx(nan, nan), cmplx(0, 2), cmplx(nan, nan)},
	Test{cmplx(nan, nan), cmplx(0, nan), cmplx(nan, nan)},
	Test{cmplx(nan, nan), cmplx(0, inf), cmplx(nan, nan)},
	Test{cmplx(nan, nan), cmplx(0, -inf), cmplx(nan, nan)},
	Test{cmplx(nan, nan), cmplx(1, 0), cmplx(nan, nan)},
	Test{cmplx(nan, nan), cmplx(1, 1), cmplx(nan, nan)},
	Test{cmplx(nan, nan), cmplx(1, -1), cmplx(nan, nan)},
	Test{cmplx(nan, nan), cmplx(1, 2), cmplx(nan, nan)},
	Test{cmplx(nan, nan), cmplx(1, nan), cmplx(nan, nan)},
	Test{cmplx(nan, nan), cmplx(1, inf), cmplx(nan, nan)},
	Test{cmplx(nan, nan), cmplx(1, -inf), cmplx(nan, nan)},
	Test{cmplx(nan, nan), cmplx(-1, 0), cmplx(nan, nan)},
	Test{cmplx(nan, nan), cmplx(-1, 1), cmplx(nan, nan)},
	Test{cmplx(nan, nan), cmplx(-1, -1), cmplx(nan, nan)},
	Test{cmplx(nan, nan), cmplx(-1, 2), cmplx(nan, nan)},
	Test{cmplx(nan, nan), cmplx(-1, nan), cmplx(nan, nan)},
	Test{cmplx(nan, nan), cmplx(-1, inf), cmplx(nan, nan)},
	Test{cmplx(nan, nan), cmplx(-1, -inf), cmplx(nan, nan)},
	Test{cmplx(nan, nan), cmplx(2, 0), cmplx(nan, nan)},
	Test{cmplx(nan, nan), cmplx(2, 1), cmplx(nan, nan)},
	Test{cmplx(nan, nan), cmplx(2, -1), cmplx(nan, nan)},
	Test{cmplx(nan, nan), cmplx(2, 2), cmplx(nan, nan)},
	Test{cmplx(nan, nan), cmplx(2, nan), cmplx(nan, nan)},
	Test{cmplx(nan, nan), cmplx(2, inf), cmplx(nan, nan)},
	Test{cmplx(nan, nan), cmplx(2, -inf), cmplx(nan, nan)},
	Test{cmplx(nan, nan), cmplx(nan, 0), cmplx(nan, nan)},
	Test{cmplx(nan, nan), cmplx(nan, 1), cmplx(nan, nan)},
	Test{cmplx(nan, nan), cmplx(nan, -1), cmplx(nan, nan)},
	Test{cmplx(nan, nan), cmplx(nan, 2), cmplx(nan, nan)},
	Test{cmplx(nan, nan), cmplx(nan, nan), cmplx(nan, nan)},
	Test{cmplx(nan, nan), cmplx(nan, inf), cmplx(nan, nan)},
	Test{cmplx(nan, nan), cmplx(nan, -inf), cmplx(nan, nan)},
	Test{cmplx(nan, nan), cmplx(inf, 0), cmplx(nan, nan)},
	Test{cmplx(nan, nan), cmplx(inf, 1), cmplx(nan, nan)},
	Test{cmplx(nan, nan), cmplx(inf, -1), cmplx(nan, nan)},
	Test{cmplx(nan, nan), cmplx(inf, 2), cmplx(nan, nan)},
	Test{cmplx(nan, nan), cmplx(inf, nan), cmplx(nan, nan)},
	Test{cmplx(nan, nan), cmplx(inf, inf), cmplx(nan, nan)},
	Test{cmplx(nan, nan), cmplx(inf, -inf), cmplx(nan, nan)},
	Test{cmplx(nan, nan), cmplx(-inf, 0), cmplx(nan, nan)},
	Test{cmplx(nan, nan), cmplx(-inf, 1), cmplx(nan, nan)},
	Test{cmplx(nan, nan), cmplx(-inf, -1), cmplx(nan, nan)},
	Test{cmplx(nan, nan), cmplx(-inf, 2), cmplx(nan, nan)},
	Test{cmplx(nan, nan), cmplx(-inf, nan), cmplx(nan, nan)},
	Test{cmplx(nan, nan), cmplx(-inf, inf), cmplx(nan, nan)},
	Test{cmplx(nan, nan), cmplx(-inf, -inf), cmplx(nan, nan)},
	Test{cmplx(nan, inf), cmplx(0, 0), cmplx(nan, inf)},
	Test{cmplx(nan, inf), cmplx(0, 1), cmplx(inf, nan)},
	Test{cmplx(nan, inf), cmplx(0, -1), cmplx(-inf, nan)},
	Test{cmplx(nan, inf), cmplx(0, 2), cmplx(inf, nan)},
	Test{cmplx(nan, inf), cmplx(0, nan), cmplx(nan, nan)},
	Test{cmplx(nan, inf), cmplx(0, inf), cmplx(nan, nan)},
	Test{cmplx(nan, inf), cmplx(0, -inf), cmplx(nan, nan)},
	Test{cmplx(nan, inf), cmplx(1, 0), cmplx(nan, inf)},
	Test{cmplx(nan, inf), cmplx(1, 1), cmplx(inf, inf)},
	Test{cmplx(nan, inf), cmplx(1, -1), cmplx(-inf, inf)},
	Test{cmplx(nan, inf), cmplx(1, 2), cmplx(inf, inf)},
	Test{cmplx(nan, inf), cmplx(1, nan), cmplx(nan, nan)},
	Test{cmplx(nan, inf), cmplx(1, inf), cmplx(nan, nan)},
	Test{cmplx(nan, inf), cmplx(1, -inf), cmplx(nan, nan)},
	Test{cmplx(nan, inf), cmplx(-1, 0), cmplx(nan, -inf)},
	Test{cmplx(nan, inf), cmplx(-1, 1), cmplx(inf, -inf)},
	Test{cmplx(nan, inf), cmplx(-1, -1), cmplx(-inf, -inf)},
	Test{cmplx(nan, inf), cmplx(-1, 2), cmplx(inf, -inf)},
	Test{cmplx(nan, inf), cmplx(-1, nan), cmplx(nan, nan)},
	Test{cmplx(nan, inf), cmplx(-1, inf), cmplx(nan, nan)},
	Test{cmplx(nan, inf), cmplx(-1, -inf), cmplx(nan, nan)},
	Test{cmplx(nan, inf), cmplx(2, 0), cmplx(nan, inf)},
	Test{cmplx(nan, inf), cmplx(2, 1), cmplx(inf, inf)},
	Test{cmplx(nan, inf), cmplx(2, -1), cmplx(-inf, inf)},
	Test{cmplx(nan, inf), cmplx(2, 2), cmplx(inf, inf)},
	Test{cmplx(nan, inf), cmplx(2, nan), cmplx(nan, nan)},
	Test{cmplx(nan, inf), cmplx(2, inf), cmplx(nan, nan)},
	Test{cmplx(nan, inf), cmplx(2, -inf), cmplx(nan, nan)},
	Test{cmplx(nan, inf), cmplx(nan, 0), cmplx(nan, nan)},
	Test{cmplx(nan, inf), cmplx(nan, 1), cmplx(nan, nan)},
	Test{cmplx(nan, inf), cmplx(nan, -1), cmplx(nan, nan)},
	Test{cmplx(nan, inf), cmplx(nan, 2), cmplx(nan, nan)},
	Test{cmplx(nan, inf), cmplx(nan, nan), cmplx(nan, nan)},
	Test{cmplx(nan, inf), cmplx(nan, inf), cmplx(nan, nan)},
	Test{cmplx(nan, inf), cmplx(nan, -inf), cmplx(nan, nan)},
	Test{cmplx(nan, inf), cmplx(inf, 0), cmplx(nan, nan)},
	Test{cmplx(nan, inf), cmplx(inf, 1), cmplx(nan, nan)},
	Test{cmplx(nan, inf), cmplx(inf, -1), cmplx(nan, nan)},
	Test{cmplx(nan, inf), cmplx(inf, 2), cmplx(nan, nan)},
	Test{cmplx(nan, inf), cmplx(inf, nan), cmplx(nan, nan)},
	Test{cmplx(nan, inf), cmplx(inf, inf), cmplx(nan, nan)},
	Test{cmplx(nan, inf), cmplx(inf, -inf), cmplx(nan, nan)},
	Test{cmplx(nan, inf), cmplx(-inf, 0), cmplx(nan, nan)},
	Test{cmplx(nan, inf), cmplx(-inf, 1), cmplx(nan, nan)},
	Test{cmplx(nan, inf), cmplx(-inf, -1), cmplx(nan, nan)},
	Test{cmplx(nan, inf), cmplx(-inf, 2), cmplx(nan, nan)},
	Test{cmplx(nan, inf), cmplx(-inf, nan), cmplx(nan, nan)},
	Test{cmplx(nan, inf), cmplx(-inf, inf), cmplx(nan, nan)},
	Test{cmplx(nan, inf), cmplx(-inf, -inf), cmplx(nan, nan)},
	Test{cmplx(nan, -inf), cmplx(0, 0), cmplx(nan, -inf)},
	Test{cmplx(nan, -inf), cmplx(0, 1), cmplx(-inf, nan)},
	Test{cmplx(nan, -inf), cmplx(0, -1), cmplx(inf, nan)},
	Test{cmplx(nan, -inf), cmplx(0, 2), cmplx(-inf, nan)},
	Test{cmplx(nan, -inf), cmplx(0, nan), cmplx(nan, nan)},
	Test{cmplx(nan, -inf), cmplx(0, inf), cmplx(nan, nan)},
	Test{cmplx(nan, -inf), cmplx(0, -inf), cmplx(nan, nan)},
	Test{cmplx(nan, -inf), cmplx(1, 0), cmplx(nan, -inf)},
	Test{cmplx(nan, -inf), cmplx(1, 1), cmplx(-inf, -inf)},
	Test{cmplx(nan, -inf), cmplx(1, -1), cmplx(inf, -inf)},
	Test{cmplx(nan, -inf), cmplx(1, 2), cmplx(-inf, -inf)},
	Test{cmplx(nan, -inf), cmplx(1, nan), cmplx(nan, nan)},
	Test{cmplx(nan, -inf), cmplx(1, inf), cmplx(nan, nan)},
	Test{cmplx(nan, -inf), cmplx(1, -inf), cmplx(nan, nan)},
	Test{cmplx(nan, -inf), cmplx(-1, 0), cmplx(nan, inf)},
	Test{cmplx(nan, -inf), cmplx(-1, 1), cmplx(-inf, inf)},
	Test{cmplx(nan, -inf), cmplx(-1, -1), cmplx(inf, inf)},
	Test{cmplx(nan, -inf), cmplx(-1, 2), cmplx(-inf, inf)},
	Test{cmplx(nan, -inf), cmplx(-1, nan), cmplx(nan, nan)},
	Test{cmplx(nan, -inf), cmplx(-1, inf), cmplx(nan, nan)},
	Test{cmplx(nan, -inf), cmplx(-1, -inf), cmplx(nan, nan)},
	Test{cmplx(nan, -inf), cmplx(2, 0), cmplx(nan, -inf)},
	Test{cmplx(nan, -inf), cmplx(2, 1), cmplx(-inf, -inf)},
	Test{cmplx(nan, -inf), cmplx(2, -1), cmplx(inf, -inf)},
	Test{cmplx(nan, -inf), cmplx(2, 2), cmplx(-inf, -inf)},
	Test{cmplx(nan, -inf), cmplx(2, nan), cmplx(nan, nan)},
	Test{cmplx(nan, -inf), cmplx(2, inf), cmplx(nan, nan)},
	Test{cmplx(nan, -inf), cmplx(2, -inf), cmplx(nan, nan)},
	Test{cmplx(nan, -inf), cmplx(nan, 0), cmplx(nan, nan)},
	Test{cmplx(nan, -inf), cmplx(nan, 1), cmplx(nan, nan)},
	Test{cmplx(nan, -inf), cmplx(nan, -1), cmplx(nan, nan)},
	Test{cmplx(nan, -inf), cmplx(nan, 2), cmplx(nan, nan)},
	Test{cmplx(nan, -inf), cmplx(nan, nan), cmplx(nan, nan)},
	Test{cmplx(nan, -inf), cmplx(nan, inf), cmplx(nan, nan)},
	Test{cmplx(nan, -inf), cmplx(nan, -inf), cmplx(nan, nan)},
	Test{cmplx(nan, -inf), cmplx(inf, 0), cmplx(nan, nan)},
	Test{cmplx(nan, -inf), cmplx(inf, 1), cmplx(nan, nan)},
	Test{cmplx(nan, -inf), cmplx(inf, -1), cmplx(nan, nan)},
	Test{cmplx(nan, -inf), cmplx(inf, 2), cmplx(nan, nan)},
	Test{cmplx(nan, -inf), cmplx(inf, nan), cmplx(nan, nan)},
	Test{cmplx(nan, -inf), cmplx(inf, inf), cmplx(nan, nan)},
	Test{cmplx(nan, -inf), cmplx(inf, -inf), cmplx(nan, nan)},
	Test{cmplx(nan, -inf), cmplx(-inf, 0), cmplx(nan, nan)},
	Test{cmplx(nan, -inf), cmplx(-inf, 1), cmplx(nan, nan)},
	Test{cmplx(nan, -inf), cmplx(-inf, -1), cmplx(nan, nan)},
	Test{cmplx(nan, -inf), cmplx(-inf, 2), cmplx(nan, nan)},
	Test{cmplx(nan, -inf), cmplx(-inf, nan), cmplx(nan, nan)},
	Test{cmplx(nan, -inf), cmplx(-inf, inf), cmplx(nan, nan)},
	Test{cmplx(nan, -inf), cmplx(-inf, -inf), cmplx(nan, nan)},
	Test{cmplx(inf, 0), cmplx(0, 0), cmplx(inf, nan)},
	Test{cmplx(inf, 0), cmplx(0, 1), cmplx(nan, -inf)},
	Test{cmplx(inf, 0), cmplx(0, -1), cmplx(nan, inf)},
	Test{cmplx(inf, 0), cmplx(0, 2), cmplx(nan, -inf)},
	Test{cmplx(inf, 0), cmplx(0, nan), cmplx(nan, nan)},
	Test{cmplx(inf, 0), cmplx(0, inf), cmplx(nan, nan)},
	Test{cmplx(inf, 0), cmplx(0, -inf), cmplx(nan, nan)},
	Test{cmplx(inf, 0), cmplx(1, 0), cmplx(inf, nan)},
	Test{cmplx(inf, 0), cmplx(1, 1), cmplx(inf, -inf)},
	Test{cmplx(inf, 0), cmplx(1, -1), cmplx(inf, inf)},
	Test{cmplx(inf, 0), cmplx(1, 2), cmplx(inf, -inf)},
	Test{cmplx(inf, 0), cmplx(1, nan), cmplx(nan, nan)},
	Test{cmplx(inf, 0), cmplx(1, inf), cmplx(nan, nan)},
	Test{cmplx(inf, 0), cmplx(1, -inf), cmplx(nan, nan)},
	Test{cmplx(inf, 0), cmplx(-1, 0), cmplx(-inf, nan)},
	Test{cmplx(inf, 0), cmplx(-1, 1), cmplx(-inf, -inf)},
	Test{cmplx(inf, 0), cmplx(-1, -1), cmplx(-inf, inf)},
	Test{cmplx(inf, 0), cmplx(-1, 2), cmplx(-inf, -inf)},
	Test{cmplx(inf, 0), cmplx(-1, nan), cmplx(nan, nan)},
	Test{cmplx(inf, 0), cmplx(-1, inf), cmplx(nan, nan)},
	Test{cmplx(inf, 0), cmplx(-1, -inf), cmplx(nan, nan)},
	Test{cmplx(inf, 0), cmplx(2, 0), cmplx(inf, nan)},
	Test{cmplx(inf, 0), cmplx(2, 1), cmplx(inf, -inf)},
	Test{cmplx(inf, 0), cmplx(2, -1), cmplx(inf, inf)},
	Test{cmplx(inf, 0), cmplx(2, 2), cmplx(inf, -inf)},
	Test{cmplx(inf, 0), cmplx(2, nan), cmplx(nan, nan)},
	Test{cmplx(inf, 0), cmplx(2, inf), cmplx(nan, nan)},
	Test{cmplx(inf, 0), cmplx(2, -inf), cmplx(nan, nan)},
	Test{cmplx(inf, 0), cmplx(nan, 0), cmplx(nan, nan)},
	Test{cmplx(inf, 0), cmplx(nan, 1), cmplx(nan, nan)},
	Test{cmplx(inf, 0), cmplx(nan, -1), cmplx(nan, nan)},
	Test{cmplx(inf, 0), cmplx(nan, 2), cmplx(nan, nan)},
	Test{cmplx(inf, 0), cmplx(nan, nan), cmplx(nan, nan)},
	Test{cmplx(inf, 0), cmplx(nan, inf), cmplx(nan, nan)},
	Test{cmplx(inf, 0), cmplx(nan, -inf), cmplx(nan, nan)},
	Test{cmplx(inf, 0), cmplx(inf, 0), cmplx(nan, nan)},
	Test{cmplx(inf, 0), cmplx(inf, 1), cmplx(nan, nan)},
	Test{cmplx(inf, 0), cmplx(inf, -1), cmplx(nan, nan)},
	Test{cmplx(inf, 0), cmplx(inf, 2), cmplx(nan, nan)},
	Test{cmplx(inf, 0), cmplx(inf, nan), cmplx(nan, nan)},
	Test{cmplx(inf, 0), cmplx(inf, inf), cmplx(nan, nan)},
	Test{cmplx(inf, 0), cmplx(inf, -inf), cmplx(nan, nan)},
	Test{cmplx(inf, 0), cmplx(-inf, 0), cmplx(nan, nan)},
	Test{cmplx(inf, 0), cmplx(-inf, 1), cmplx(nan, nan)},
	Test{cmplx(inf, 0), cmplx(-inf, -1), cmplx(nan, nan)},
	Test{cmplx(inf, 0), cmplx(-inf, 2), cmplx(nan, nan)},
	Test{cmplx(inf, 0), cmplx(-inf, nan), cmplx(nan, nan)},
	Test{cmplx(inf, 0), cmplx(-inf, inf), cmplx(nan, nan)},
	Test{cmplx(inf, 0), cmplx(-inf, -inf), cmplx(nan, nan)},
	Test{cmplx(inf, 1), cmplx(0, 0), cmplx(inf, inf)},
	Test{cmplx(inf, 1), cmplx(0, 1), cmplx(nan, -inf)},
	Test{cmplx(inf, 1), cmplx(0, -1), cmplx(nan, inf)},
	Test{cmplx(inf, 1), cmplx(0, 2), cmplx(nan, -inf)},
	Test{cmplx(inf, 1), cmplx(0, nan), cmplx(nan, nan)},
	Test{cmplx(inf, 1), cmplx(0, inf), cmplx(nan, nan)},
	Test{cmplx(inf, 1), cmplx(0, -inf), cmplx(nan, nan)},
	Test{cmplx(inf, 1), cmplx(1, 0), cmplx(inf, nan)},
	Test{cmplx(inf, 1), cmplx(1, 1), cmplx(inf, -inf)},
	Test{cmplx(inf, 1), cmplx(1, -1), cmplx(inf, inf)},
	Test{cmplx(inf, 1), cmplx(1, 2), cmplx(inf, -inf)},
	Test{cmplx(inf, 1), cmplx(1, nan), cmplx(nan, nan)},
	Test{cmplx(inf, 1), cmplx(1, inf), cmplx(nan, nan)},
	Test{cmplx(inf, 1), cmplx(1, -inf), cmplx(nan, nan)},
	Test{cmplx(inf, 1), cmplx(-1, 0), cmplx(-inf, nan)},
	Test{cmplx(inf, 1), cmplx(-1, 1), cmplx(-inf, -inf)},
	Test{cmplx(inf, 1), cmplx(-1, -1), cmplx(-inf, inf)},
	Test{cmplx(inf, 1), cmplx(-1, 2), cmplx(-inf, -inf)},
	Test{cmplx(inf, 1), cmplx(-1, nan), cmplx(nan, nan)},
	Test{cmplx(inf, 1), cmplx(-1, inf), cmplx(nan, nan)},
	Test{cmplx(inf, 1), cmplx(-1, -inf), cmplx(nan, nan)},
	Test{cmplx(inf, 1), cmplx(2, 0), cmplx(inf, nan)},
	Test{cmplx(inf, 1), cmplx(2, 1), cmplx(inf, -inf)},
	Test{cmplx(inf, 1), cmplx(2, -1), cmplx(inf, inf)},
	Test{cmplx(inf, 1), cmplx(2, 2), cmplx(inf, -inf)},
	Test{cmplx(inf, 1), cmplx(2, nan), cmplx(nan, nan)},
	Test{cmplx(inf, 1), cmplx(2, inf), cmplx(nan, nan)},
	Test{cmplx(inf, 1), cmplx(2, -inf), cmplx(nan, nan)},
	Test{cmplx(inf, 1), cmplx(nan, 0), cmplx(nan, nan)},
	Test{cmplx(inf, 1), cmplx(nan, 1), cmplx(nan, nan)},
	Test{cmplx(inf, 1), cmplx(nan, -1), cmplx(nan, nan)},
	Test{cmplx(inf, 1), cmplx(nan, 2), cmplx(nan, nan)},
	Test{cmplx(inf, 1), cmplx(nan, nan), cmplx(nan, nan)},
	Test{cmplx(inf, 1), cmplx(nan, inf), cmplx(nan, nan)},
	Test{cmplx(inf, 1), cmplx(nan, -inf), cmplx(nan, nan)},
	Test{cmplx(inf, 1), cmplx(inf, 0), cmplx(nan, nan)},
	Test{cmplx(inf, 1), cmplx(inf, 1), cmplx(nan, nan)},
	Test{cmplx(inf, 1), cmplx(inf, -1), cmplx(nan, nan)},
	Test{cmplx(inf, 1), cmplx(inf, 2), cmplx(nan, nan)},
	Test{cmplx(inf, 1), cmplx(inf, nan), cmplx(nan, nan)},
	Test{cmplx(inf, 1), cmplx(inf, inf), cmplx(nan, nan)},
	Test{cmplx(inf, 1), cmplx(inf, -inf), cmplx(nan, nan)},
	Test{cmplx(inf, 1), cmplx(-inf, 0), cmplx(nan, nan)},
	Test{cmplx(inf, 1), cmplx(-inf, 1), cmplx(nan, nan)},
	Test{cmplx(inf, 1), cmplx(-inf, -1), cmplx(nan, nan)},
	Test{cmplx(inf, 1), cmplx(-inf, 2), cmplx(nan, nan)},
	Test{cmplx(inf, 1), cmplx(-inf, nan), cmplx(nan, nan)},
	Test{cmplx(inf, 1), cmplx(-inf, inf), cmplx(nan, nan)},
	Test{cmplx(inf, 1), cmplx(-inf, -inf), cmplx(nan, nan)},
	Test{cmplx(inf, -1), cmplx(0, 0), cmplx(inf, -inf)},
	Test{cmplx(inf, -1), cmplx(0, 1), cmplx(nan, -inf)},
	Test{cmplx(inf, -1), cmplx(0, -1), cmplx(nan, inf)},
	Test{cmplx(inf, -1), cmplx(0, 2), cmplx(nan, -inf)},
	Test{cmplx(inf, -1), cmplx(0, nan), cmplx(nan, nan)},
	Test{cmplx(inf, -1), cmplx(0, inf), cmplx(nan, nan)},
	Test{cmplx(inf, -1), cmplx(0, -inf), cmplx(nan, nan)},
	Test{cmplx(inf, -1), cmplx(1, 0), cmplx(inf, nan)},
	Test{cmplx(inf, -1), cmplx(1, 1), cmplx(inf, -inf)},
	Test{cmplx(inf, -1), cmplx(1, -1), cmplx(inf, inf)},
	Test{cmplx(inf, -1), cmplx(1, 2), cmplx(inf, -inf)},
	Test{cmplx(inf, -1), cmplx(1, nan), cmplx(nan, nan)},
	Test{cmplx(inf, -1), cmplx(1, inf), cmplx(nan, nan)},
	Test{cmplx(inf, -1), cmplx(1, -inf), cmplx(nan, nan)},
	Test{cmplx(inf, -1), cmplx(-1, 0), cmplx(-inf, nan)},
	Test{cmplx(inf, -1), cmplx(-1, 1), cmplx(-inf, -inf)},
	Test{cmplx(inf, -1), cmplx(-1, -1), cmplx(-inf, inf)},
	Test{cmplx(inf, -1), cmplx(-1, 2), cmplx(-inf, -inf)},
	Test{cmplx(inf, -1), cmplx(-1, nan), cmplx(nan, nan)},
	Test{cmplx(inf, -1), cmplx(-1, inf), cmplx(nan, nan)},
	Test{cmplx(inf, -1), cmplx(-1, -inf), cmplx(nan, nan)},
	Test{cmplx(inf, -1), cmplx(2, 0), cmplx(inf, nan)},
	Test{cmplx(inf, -1), cmplx(2, 1), cmplx(inf, -inf)},
	Test{cmplx(inf, -1), cmplx(2, -1), cmplx(inf, inf)},
	Test{cmplx(inf, -1), cmplx(2, 2), cmplx(inf, -inf)},
	Test{cmplx(inf, -1), cmplx(2, nan), cmplx(nan, nan)},
	Test{cmplx(inf, -1), cmplx(2, inf), cmplx(nan, nan)},
	Test{cmplx(inf, -1), cmplx(2, -inf), cmplx(nan, nan)},
	Test{cmplx(inf, -1), cmplx(nan, 0), cmplx(nan, nan)},
	Test{cmplx(inf, -1), cmplx(nan, 1), cmplx(nan, nan)},
	Test{cmplx(inf, -1), cmplx(nan, -1), cmplx(nan, nan)},
	Test{cmplx(inf, -1), cmplx(nan, 2), cmplx(nan, nan)},
	Test{cmplx(inf, -1), cmplx(nan, nan), cmplx(nan, nan)},
	Test{cmplx(inf, -1), cmplx(nan, inf), cmplx(nan, nan)},
	Test{cmplx(inf, -1), cmplx(nan, -inf), cmplx(nan, nan)},
	Test{cmplx(inf, -1), cmplx(inf, 0), cmplx(nan, nan)},
	Test{cmplx(inf, -1), cmplx(inf, 1), cmplx(nan, nan)},
	Test{cmplx(inf, -1), cmplx(inf, -1), cmplx(nan, nan)},
	Test{cmplx(inf, -1), cmplx(inf, 2), cmplx(nan, nan)},
	Test{cmplx(inf, -1), cmplx(inf, nan), cmplx(nan, nan)},
	Test{cmplx(inf, -1), cmplx(inf, inf), cmplx(nan, nan)},
	Test{cmplx(inf, -1), cmplx(inf, -inf), cmplx(nan, nan)},
	Test{cmplx(inf, -1), cmplx(-inf, 0), cmplx(nan, nan)},
	Test{cmplx(inf, -1), cmplx(-inf, 1), cmplx(nan, nan)},
	Test{cmplx(inf, -1), cmplx(-inf, -1), cmplx(nan, nan)},
	Test{cmplx(inf, -1), cmplx(-inf, 2), cmplx(nan, nan)},
	Test{cmplx(inf, -1), cmplx(-inf, nan), cmplx(nan, nan)},
	Test{cmplx(inf, -1), cmplx(-inf, inf), cmplx(nan, nan)},
	Test{cmplx(inf, -1), cmplx(-inf, -inf), cmplx(nan, nan)},
	Test{cmplx(inf, 2), cmplx(0, 0), cmplx(inf, inf)},
	Test{cmplx(inf, 2), cmplx(0, 1), cmplx(nan, -inf)},
	Test{cmplx(inf, 2), cmplx(0, -1), cmplx(nan, inf)},
	Test{cmplx(inf, 2), cmplx(0, 2), cmplx(nan, -inf)},
	Test{cmplx(inf, 2), cmplx(0, nan), cmplx(nan, nan)},
	Test{cmplx(inf, 2), cmplx(0, inf), cmplx(nan, nan)},
	Test{cmplx(inf, 2), cmplx(0, -inf), cmplx(nan, nan)},
	Test{cmplx(inf, 2), cmplx(1, 0), cmplx(inf, nan)},
	Test{cmplx(inf, 2), cmplx(1, 1), cmplx(inf, -inf)},
	Test{cmplx(inf, 2), cmplx(1, -1), cmplx(inf, inf)},
	Test{cmplx(inf, 2), cmplx(1, 2), cmplx(inf, -inf)},
	Test{cmplx(inf, 2), cmplx(1, nan), cmplx(nan, nan)},
	Test{cmplx(inf, 2), cmplx(1, inf), cmplx(nan, nan)},
	Test{cmplx(inf, 2), cmplx(1, -inf), cmplx(nan, nan)},
	Test{cmplx(inf, 2), cmplx(-1, 0), cmplx(-inf, nan)},
	Test{cmplx(inf, 2), cmplx(-1, 1), cmplx(-inf, -inf)},
	Test{cmplx(inf, 2), cmplx(-1, -1), cmplx(-inf, inf)},
	Test{cmplx(inf, 2), cmplx(-1, 2), cmplx(-inf, -inf)},
	Test{cmplx(inf, 2), cmplx(-1, nan), cmplx(nan, nan)},
	Test{cmplx(inf, 2), cmplx(-1, inf), cmplx(nan, nan)},
	Test{cmplx(inf, 2), cmplx(-1, -inf), cmplx(nan, nan)},
	Test{cmplx(inf, 2), cmplx(2, 0), cmplx(inf, nan)},
	Test{cmplx(inf, 2), cmplx(2, 1), cmplx(inf, -inf)},
	Test{cmplx(inf, 2), cmplx(2, -1), cmplx(inf, inf)},
	Test{cmplx(inf, 2), cmplx(2, 2), cmplx(inf, -inf)},
	Test{cmplx(inf, 2), cmplx(2, nan), cmplx(nan, nan)},
	Test{cmplx(inf, 2), cmplx(2, inf), cmplx(nan, nan)},
	Test{cmplx(inf, 2), cmplx(2, -inf), cmplx(nan, nan)},
	Test{cmplx(inf, 2), cmplx(nan, 0), cmplx(nan, nan)},
	Test{cmplx(inf, 2), cmplx(nan, 1), cmplx(nan, nan)},
	Test{cmplx(inf, 2), cmplx(nan, -1), cmplx(nan, nan)},
	Test{cmplx(inf, 2), cmplx(nan, 2), cmplx(nan, nan)},
	Test{cmplx(inf, 2), cmplx(nan, nan), cmplx(nan, nan)},
	Test{cmplx(inf, 2), cmplx(nan, inf), cmplx(nan, nan)},
	Test{cmplx(inf, 2), cmplx(nan, -inf), cmplx(nan, nan)},
	Test{cmplx(inf, 2), cmplx(inf, 0), cmplx(nan, nan)},
	Test{cmplx(inf, 2), cmplx(inf, 1), cmplx(nan, nan)},
	Test{cmplx(inf, 2), cmplx(inf, -1), cmplx(nan, nan)},
	Test{cmplx(inf, 2), cmplx(inf, 2), cmplx(nan, nan)},
	Test{cmplx(inf, 2), cmplx(inf, nan), cmplx(nan, nan)},
	Test{cmplx(inf, 2), cmplx(inf, inf), cmplx(nan, nan)},
	Test{cmplx(inf, 2), cmplx(inf, -inf), cmplx(nan, nan)},
	Test{cmplx(inf, 2), cmplx(-inf, 0), cmplx(nan, nan)},
	Test{cmplx(inf, 2), cmplx(-inf, 1), cmplx(nan, nan)},
	Test{cmplx(inf, 2), cmplx(-inf, -1), cmplx(nan, nan)},
	Test{cmplx(inf, 2), cmplx(-inf, 2), cmplx(nan, nan)},
	Test{cmplx(inf, 2), cmplx(-inf, nan), cmplx(nan, nan)},
	Test{cmplx(inf, 2), cmplx(-inf, inf), cmplx(nan, nan)},
	Test{cmplx(inf, 2), cmplx(-inf, -inf), cmplx(nan, nan)},
	Test{cmplx(inf, nan), cmplx(0, 0), cmplx(inf, nan)},
	Test{cmplx(inf, nan), cmplx(0, 1), cmplx(nan, -inf)},
	Test{cmplx(inf, nan), cmplx(0, -1), cmplx(nan, inf)},
	Test{cmplx(inf, nan), cmplx(0, 2), cmplx(nan, -inf)},
	Test{cmplx(inf, nan), cmplx(0, nan), cmplx(nan, nan)},
	Test{cmplx(inf, nan), cmplx(0, inf), cmplx(nan, nan)},
	Test{cmplx(inf, nan), cmplx(0, -inf), cmplx(nan, nan)},
	Test{cmplx(inf, nan), cmplx(1, 0), cmplx(inf, nan)},
	Test{cmplx(inf, nan), cmplx(1, 1), cmplx(inf, -inf)},
	Test{cmplx(inf, nan), cmplx(1, -1), cmplx(inf, inf)},
	Test{cmplx(inf, nan), cmplx(1, 2), cmplx(inf, -inf)},
	Test{cmplx(inf, nan), cmplx(1, nan), cmplx(nan, nan)},
	Test{cmplx(inf, nan), cmplx(1, inf), cmplx(nan, nan)},
	Test{cmplx(inf, nan), cmplx(1, -inf), cmplx(nan, nan)},
	Test{cmplx(inf, nan), cmplx(-1, 0), cmplx(-inf, nan)},
	Test{cmplx(inf, nan), cmplx(-1, 1), cmplx(-inf, -inf)},
	Test{cmplx(inf, nan), cmplx(-1, -1), cmplx(-inf, inf)},
	Test{cmplx(inf, nan), cmplx(-1, 2), cmplx(-inf, -inf)},
	Test{cmplx(inf, nan), cmplx(-1, nan), cmplx(nan, nan)},
	Test{cmplx(inf, nan), cmplx(-1, inf), cmplx(nan, nan)},
	Test{cmplx(inf, nan), cmplx(-1, -inf), cmplx(nan, nan)},
	Test{cmplx(inf, nan), cmplx(2, 0), cmplx(inf, nan)},
	Test{cmplx(inf, nan), cmplx(2, 1), cmplx(inf, -inf)},
	Test{cmplx(inf, nan), cmplx(2, -1), cmplx(inf, inf)},
	Test{cmplx(inf, nan), cmplx(2, 2), cmplx(inf, -inf)},
	Test{cmplx(inf, nan), cmplx(2, nan), cmplx(nan, nan)},
	Test{cmplx(inf, nan), cmplx(2, inf), cmplx(nan, nan)},
	Test{cmplx(inf, nan), cmplx(2, -inf), cmplx(nan, nan)},
	Test{cmplx(inf, nan), cmplx(nan, 0), cmplx(nan, nan)},
	Test{cmplx(inf, nan), cmplx(nan, 1), cmplx(nan, nan)},
	Test{cmplx(inf, nan), cmplx(nan, -1), cmplx(nan, nan)},
	Test{cmplx(inf, nan), cmplx(nan, 2), cmplx(nan, nan)},
	Test{cmplx(inf, nan), cmplx(nan, nan), cmplx(nan, nan)},
	Test{cmplx(inf, nan), cmplx(nan, inf), cmplx(nan, nan)},
	Test{cmplx(inf, nan), cmplx(nan, -inf), cmplx(nan, nan)},
	Test{cmplx(inf, nan), cmplx(inf, 0), cmplx(nan, nan)},
	Test{cmplx(inf, nan), cmplx(inf, 1), cmplx(nan, nan)},
	Test{cmplx(inf, nan), cmplx(inf, -1), cmplx(nan, nan)},
	Test{cmplx(inf, nan), cmplx(inf, 2), cmplx(nan, nan)},
	Test{cmplx(inf, nan), cmplx(inf, nan), cmplx(nan, nan)},
	Test{cmplx(inf, nan), cmplx(inf, inf), cmplx(nan, nan)},
	Test{cmplx(inf, nan), cmplx(inf, -inf), cmplx(nan, nan)},
	Test{cmplx(inf, nan), cmplx(-inf, 0), cmplx(nan, nan)},
	Test{cmplx(inf, nan), cmplx(-inf, 1), cmplx(nan, nan)},
	Test{cmplx(inf, nan), cmplx(-inf, -1), cmplx(nan, nan)},
	Test{cmplx(inf, nan), cmplx(-inf, 2), cmplx(nan, nan)},
	Test{cmplx(inf, nan), cmplx(-inf, nan), cmplx(nan, nan)},
	Test{cmplx(inf, nan), cmplx(-inf, inf), cmplx(nan, nan)},
	Test{cmplx(inf, nan), cmplx(-inf, -inf), cmplx(nan, nan)},
	Test{cmplx(inf, inf), cmplx(0, 0), cmplx(inf, inf)},
	Test{cmplx(inf, inf), cmplx(0, 1), cmplx(inf, -inf)},
	Test{cmplx(inf, inf), cmplx(0, -1), cmplx(-inf, inf)},
	Test{cmplx(inf, inf), cmplx(0, 2), cmplx(inf, -inf)},
	Test{cmplx(inf, inf), cmplx(0, nan), cmplx(nan, nan)},
	Test{cmplx(inf, inf), cmplx(0, inf), cmplx(nan, nan)},
	Test{cmplx(inf, inf), cmplx(0, -inf), cmplx(nan, nan)},
	Test{cmplx(inf, inf), cmplx(1, 0), cmplx(inf, inf)},
	Test{cmplx(inf, inf), cmplx(1, 1), cmplx(inf, nan)},
	Test{cmplx(inf, inf), cmplx(1, -1), cmplx(nan, inf)},
	Test{cmplx(inf, inf), cmplx(1, 2), cmplx(inf, nan)},
	Test{cmplx(inf, inf), cmplx(1, nan), cmplx(nan, nan)},
	Test{cmplx(inf, inf), cmplx(1, inf), cmplx(nan, nan)},
	Test{cmplx(inf, inf), cmplx(1, -inf), cmplx(nan, nan)},
	Test{cmplx(inf, inf), cmplx(-1, 0), cmplx(-inf, -inf)},
	Test{cmplx(inf, inf), cmplx(-1, 1), cmplx(nan, -inf)},
	Test{cmplx(inf, inf), cmplx(-1, -1), cmplx(-inf, nan)},
	Test{cmplx(inf, inf), cmplx(-1, 2), cmplx(nan, -inf)},
	Test{cmplx(inf, inf), cmplx(-1, nan), cmplx(nan, nan)},
	Test{cmplx(inf, inf), cmplx(-1, inf), cmplx(nan, nan)},
	Test{cmplx(inf, inf), cmplx(-1, -inf), cmplx(nan, nan)},
	Test{cmplx(inf, inf), cmplx(2, 0), cmplx(inf, inf)},
	Test{cmplx(inf, inf), cmplx(2, 1), cmplx(inf, nan)},
	Test{cmplx(inf, inf), cmplx(2, -1), cmplx(nan, inf)},
	Test{cmplx(inf, inf), cmplx(2, 2), cmplx(inf, nan)},
	Test{cmplx(inf, inf), cmplx(2, nan), cmplx(nan, nan)},
	Test{cmplx(inf, inf), cmplx(2, inf), cmplx(nan, nan)},
	Test{cmplx(inf, inf), cmplx(2, -inf), cmplx(nan, nan)},
	Test{cmplx(inf, inf), cmplx(nan, 0), cmplx(nan, nan)},
	Test{cmplx(inf, inf), cmplx(nan, 1), cmplx(nan, nan)},
	Test{cmplx(inf, inf), cmplx(nan, -1), cmplx(nan, nan)},
	Test{cmplx(inf, inf), cmplx(nan, 2), cmplx(nan, nan)},
	Test{cmplx(inf, inf), cmplx(nan, nan), cmplx(nan, nan)},
	Test{cmplx(inf, inf), cmplx(nan, inf), cmplx(nan, nan)},
	Test{cmplx(inf, inf), cmplx(nan, -inf), cmplx(nan, nan)},
	Test{cmplx(inf, inf), cmplx(inf, 0), cmplx(nan, nan)},
	Test{cmplx(inf, inf), cmplx(inf, 1), cmplx(nan, nan)},
	Test{cmplx(inf, inf), cmplx(inf, -1), cmplx(nan, nan)},
	Test{cmplx(inf, inf), cmplx(inf, 2), cmplx(nan, nan)},
	Test{cmplx(inf, inf), cmplx(inf, nan), cmplx(nan, nan)},
	Test{cmplx(inf, inf), cmplx(inf, inf), cmplx(nan, nan)},
	Test{cmplx(inf, inf), cmplx(inf, -inf), cmplx(nan, nan)},
	Test{cmplx(inf, inf), cmplx(-inf, 0), cmplx(nan, nan)},
	Test{cmplx(inf, inf), cmplx(-inf, 1), cmplx(nan, nan)},
	Test{cmplx(inf, inf), cmplx(-inf, -1), cmplx(nan, nan)},
	Test{cmplx(inf, inf), cmplx(-inf, 2), cmplx(nan, nan)},
	Test{cmplx(inf, inf), cmplx(-inf, nan), cmplx(nan, nan)},
	Test{cmplx(inf, inf), cmplx(-inf, inf), cmplx(nan, nan)},
	Test{cmplx(inf, inf), cmplx(-inf, -inf), cmplx(nan, nan)},
	Test{cmplx(inf, -inf), cmplx(0, 0), cmplx(inf, -inf)},
	Test{cmplx(inf, -inf), cmplx(0, 1), cmplx(-inf, -inf)},
	Test{cmplx(inf, -inf), cmplx(0, -1), cmplx(inf, inf)},
	Test{cmplx(inf, -inf), cmplx(0, 2), cmplx(-inf, -inf)},
	Test{cmplx(inf, -inf), cmplx(0, nan), cmplx(nan, nan)},
	Test{cmplx(inf, -inf), cmplx(0, inf), cmplx(nan, nan)},
	Test{cmplx(inf, -inf), cmplx(0, -inf), cmplx(nan, nan)},
	Test{cmplx(inf, -inf), cmplx(1, 0), cmplx(inf, -inf)},
	Test{cmplx(inf, -inf), cmplx(1, 1), cmplx(nan, -inf)},
	Test{cmplx(inf, -inf), cmplx(1, -1), cmplx(inf, nan)},
	Test{cmplx(inf, -inf), cmplx(1, 2), cmplx(nan, -inf)},
	Test{cmplx(inf, -inf), cmplx(1, nan), cmplx(nan, nan)},
	Test{cmplx(inf, -inf), cmplx(1, inf), cmplx(nan, nan)},
	Test{cmplx(inf, -inf), cmplx(1, -inf), cmplx(nan, nan)},
	Test{cmplx(inf, -inf), cmplx(-1, 0), cmplx(-inf, inf)},
	Test{cmplx(inf, -inf), cmplx(-1, 1), cmplx(-inf, nan)},
	Test{cmplx(inf, -inf), cmplx(-1, -1), cmplx(nan, inf)},
	Test{cmplx(inf, -inf), cmplx(-1, 2), cmplx(-inf, nan)},
	Test{cmplx(inf, -inf), cmplx(-1, nan), cmplx(nan, nan)},
	Test{cmplx(inf, -inf), cmplx(-1, inf), cmplx(nan, nan)},
	Test{cmplx(inf, -inf), cmplx(-1, -inf), cmplx(nan, nan)},
	Test{cmplx(inf, -inf), cmplx(2, 0), cmplx(inf, -inf)},
	Test{cmplx(inf, -inf), cmplx(2, 1), cmplx(nan, -inf)},
	Test{cmplx(inf, -inf), cmplx(2, -1), cmplx(inf, nan)},
	Test{cmplx(inf, -inf), cmplx(2, 2), cmplx(nan, -inf)},
	Test{cmplx(inf, -inf), cmplx(2, nan), cmplx(nan, nan)},
	Test{cmplx(inf, -inf), cmplx(2, inf), cmplx(nan, nan)},
	Test{cmplx(inf, -inf), cmplx(2, -inf), cmplx(nan, nan)},
	Test{cmplx(inf, -inf), cmplx(nan, 0), cmplx(nan, nan)},
	Test{cmplx(inf, -inf), cmplx(nan, 1), cmplx(nan, nan)},
	Test{cmplx(inf, -inf), cmplx(nan, -1), cmplx(nan, nan)},
	Test{cmplx(inf, -inf), cmplx(nan, 2), cmplx(nan, nan)},
	Test{cmplx(inf, -inf), cmplx(nan, nan), cmplx(nan, nan)},
	Test{cmplx(inf, -inf), cmplx(nan, inf), cmplx(nan, nan)},
	Test{cmplx(inf, -inf), cmplx(nan, -inf), cmplx(nan, nan)},
	Test{cmplx(inf, -inf), cmplx(inf, 0), cmplx(nan, nan)},
	Test{cmplx(inf, -inf), cmplx(inf, 1), cmplx(nan, nan)},
	Test{cmplx(inf, -inf), cmplx(inf, -1), cmplx(nan, nan)},
	Test{cmplx(inf, -inf), cmplx(inf, 2), cmplx(nan, nan)},
	Test{cmplx(inf, -inf), cmplx(inf, nan), cmplx(nan, nan)},
	Test{cmplx(inf, -inf), cmplx(inf, inf), cmplx(nan, nan)},
	Test{cmplx(inf, -inf), cmplx(inf, -inf), cmplx(nan, nan)},
	Test{cmplx(inf, -inf), cmplx(-inf, 0), cmplx(nan, nan)},
	Test{cmplx(inf, -inf), cmplx(-inf, 1), cmplx(nan, nan)},
	Test{cmplx(inf, -inf), cmplx(-inf, -1), cmplx(nan, nan)},
	Test{cmplx(inf, -inf), cmplx(-inf, 2), cmplx(nan, nan)},
	Test{cmplx(inf, -inf), cmplx(-inf, nan), cmplx(nan, nan)},
	Test{cmplx(inf, -inf), cmplx(-inf, inf), cmplx(nan, nan)},
	Test{cmplx(inf, -inf), cmplx(-inf, -inf), cmplx(nan, nan)},
	Test{cmplx(-inf, 0), cmplx(0, 0), cmplx(-inf, nan)},
	Test{cmplx(-inf, 0), cmplx(0, 1), cmplx(nan, inf)},
	Test{cmplx(-inf, 0), cmplx(0, -1), cmplx(nan, -inf)},
	Test{cmplx(-inf, 0), cmplx(0, 2), cmplx(nan, inf)},
	Test{cmplx(-inf, 0), cmplx(0, nan), cmplx(nan, nan)},
	Test{cmplx(-inf, 0), cmplx(0, inf), cmplx(nan, nan)},
	Test{cmplx(-inf, 0), cmplx(0, -inf), cmplx(nan, nan)},
	Test{cmplx(-inf, 0), cmplx(1, 0), cmplx(-inf, nan)},
	Test{cmplx(-inf, 0), cmplx(1, 1), cmplx(-inf, inf)},
	Test{cmplx(-inf, 0), cmplx(1, -1), cmplx(-inf, -inf)},
	Test{cmplx(-inf, 0), cmplx(1, 2), cmplx(-inf, inf)},
	Test{cmplx(-inf, 0), cmplx(1, nan), cmplx(nan, nan)},
	Test{cmplx(-inf, 0), cmplx(1, inf), cmplx(nan, nan)},
	Test{cmplx(-inf, 0), cmplx(1, -inf), cmplx(nan, nan)},
	Test{cmplx(-inf, 0), cmplx(-1, 0), cmplx(inf, nan)},
	Test{cmplx(-inf, 0), cmplx(-1, 1), cmplx(inf, inf)},
	Test{cmplx(-inf, 0), cmplx(-1, -1), cmplx(inf, -inf)},
	Test{cmplx(-inf, 0), cmplx(-1, 2), cmplx(inf, inf)},
	Test{cmplx(-inf, 0), cmplx(-1, nan), cmplx(nan, nan)},
	Test{cmplx(-inf, 0), cmplx(-1, inf), cmplx(nan, nan)},
	Test{cmplx(-inf, 0), cmplx(-1, -inf), cmplx(nan, nan)},
	Test{cmplx(-inf, 0), cmplx(2, 0), cmplx(-inf, nan)},
	Test{cmplx(-inf, 0), cmplx(2, 1), cmplx(-inf, inf)},
	Test{cmplx(-inf, 0), cmplx(2, -1), cmplx(-inf, -inf)},
	Test{cmplx(-inf, 0), cmplx(2, 2), cmplx(-inf, inf)},
	Test{cmplx(-inf, 0), cmplx(2, nan), cmplx(nan, nan)},
	Test{cmplx(-inf, 0), cmplx(2, inf), cmplx(nan, nan)},
	Test{cmplx(-inf, 0), cmplx(2, -inf), cmplx(nan, nan)},
	Test{cmplx(-inf, 0), cmplx(nan, 0), cmplx(nan, nan)},
	Test{cmplx(-inf, 0), cmplx(nan, 1), cmplx(nan, nan)},
	Test{cmplx(-inf, 0), cmplx(nan, -1), cmplx(nan, nan)},
	Test{cmplx(-inf, 0), cmplx(nan, 2), cmplx(nan, nan)},
	Test{cmplx(-inf, 0), cmplx(nan, nan), cmplx(nan, nan)},
	Test{cmplx(-inf, 0), cmplx(nan, inf), cmplx(nan, nan)},
	Test{cmplx(-inf, 0), cmplx(nan, -inf), cmplx(nan, nan)},
	Test{cmplx(-inf, 0), cmplx(inf, 0), cmplx(nan, nan)},
	Test{cmplx(-inf, 0), cmplx(inf, 1), cmplx(nan, nan)},
	Test{cmplx(-inf, 0), cmplx(inf, -1), cmplx(nan, nan)},
	Test{cmplx(-inf, 0), cmplx(inf, 2), cmplx(nan, nan)},
	Test{cmplx(-inf, 0), cmplx(inf, nan), cmplx(nan, nan)},
	Test{cmplx(-inf, 0), cmplx(inf, inf), cmplx(nan, nan)},
	Test{cmplx(-inf, 0), cmplx(inf, -inf), cmplx(nan, nan)},
	Test{cmplx(-inf, 0), cmplx(-inf, 0), cmplx(nan, nan)},
	Test{cmplx(-inf, 0), cmplx(-inf, 1), cmplx(nan, nan)},
	Test{cmplx(-inf, 0), cmplx(-inf, -1), cmplx(nan, nan)},
	Test{cmplx(-inf, 0), cmplx(-inf, 2), cmplx(nan, nan)},
	Test{cmplx(-inf, 0), cmplx(-inf, nan), cmplx(nan, nan)},
	Test{cmplx(-inf, 0), cmplx(-inf, inf), cmplx(nan, nan)},
	Test{cmplx(-inf, 0), cmplx(-inf, -inf), cmplx(nan, nan)},
	Test{cmplx(-inf, 1), cmplx(0, 0), cmplx(-inf, inf)},
	Test{cmplx(-inf, 1), cmplx(0, 1), cmplx(nan, inf)},
	Test{cmplx(-inf, 1), cmplx(0, -1), cmplx(nan, -inf)},
	Test{cmplx(-inf, 1), cmplx(0, 2), cmplx(nan, inf)},
	Test{cmplx(-inf, 1), cmplx(0, nan), cmplx(nan, nan)},
	Test{cmplx(-inf, 1), cmplx(0, inf), cmplx(nan, nan)},
	Test{cmplx(-inf, 1), cmplx(0, -inf), cmplx(nan, nan)},
	Test{cmplx(-inf, 1), cmplx(1, 0), cmplx(-inf, nan)},
	Test{cmplx(-inf, 1), cmplx(1, 1), cmplx(-inf, inf)},
	Test{cmplx(-inf, 1), cmplx(1, -1), cmplx(-inf, -inf)},
	Test{cmplx(-inf, 1), cmplx(1, 2), cmplx(-inf, inf)},
	Test{cmplx(-inf, 1), cmplx(1, nan), cmplx(nan, nan)},
	Test{cmplx(-inf, 1), cmplx(1, inf), cmplx(nan, nan)},
	Test{cmplx(-inf, 1), cmplx(1, -inf), cmplx(nan, nan)},
	Test{cmplx(-inf, 1), cmplx(-1, 0), cmplx(inf, nan)},
	Test{cmplx(-inf, 1), cmplx(-1, 1), cmplx(inf, inf)},
	Test{cmplx(-inf, 1), cmplx(-1, -1), cmplx(inf, -inf)},
	Test{cmplx(-inf, 1), cmplx(-1, 2), cmplx(inf, inf)},
	Test{cmplx(-inf, 1), cmplx(-1, nan), cmplx(nan, nan)},
	Test{cmplx(-inf, 1), cmplx(-1, inf), cmplx(nan, nan)},
	Test{cmplx(-inf, 1), cmplx(-1, -inf), cmplx(nan, nan)},
	Test{cmplx(-inf, 1), cmplx(2, 0), cmplx(-inf, nan)},
	Test{cmplx(-inf, 1), cmplx(2, 1), cmplx(-inf, inf)},
	Test{cmplx(-inf, 1), cmplx(2, -1), cmplx(-inf, -inf)},
	Test{cmplx(-inf, 1), cmplx(2, 2), cmplx(-inf, inf)},
	Test{cmplx(-inf, 1), cmplx(2, nan), cmplx(nan, nan)},
	Test{cmplx(-inf, 1), cmplx(2, inf), cmplx(nan, nan)},
	Test{cmplx(-inf, 1), cmplx(2, -inf), cmplx(nan, nan)},
	Test{cmplx(-inf, 1), cmplx(nan, 0), cmplx(nan, nan)},
	Test{cmplx(-inf, 1), cmplx(nan, 1), cmplx(nan, nan)},
	Test{cmplx(-inf, 1), cmplx(nan, -1), cmplx(nan, nan)},
	Test{cmplx(-inf, 1), cmplx(nan, 2), cmplx(nan, nan)},
	Test{cmplx(-inf, 1), cmplx(nan, nan), cmplx(nan, nan)},
	Test{cmplx(-inf, 1), cmplx(nan, inf), cmplx(nan, nan)},
	Test{cmplx(-inf, 1), cmplx(nan, -inf), cmplx(nan, nan)},
	Test{cmplx(-inf, 1), cmplx(inf, 0), cmplx(nan, nan)},
	Test{cmplx(-inf, 1), cmplx(inf, 1), cmplx(nan, nan)},
	Test{cmplx(-inf, 1), cmplx(inf, -1), cmplx(nan, nan)},
	Test{cmplx(-inf, 1), cmplx(inf, 2), cmplx(nan, nan)},
	Test{cmplx(-inf, 1), cmplx(inf, nan), cmplx(nan, nan)},
	Test{cmplx(-inf, 1), cmplx(inf, inf), cmplx(nan, nan)},
	Test{cmplx(-inf, 1), cmplx(inf, -inf), cmplx(nan, nan)},
	Test{cmplx(-inf, 1), cmplx(-inf, 0), cmplx(nan, nan)},
	Test{cmplx(-inf, 1), cmplx(-inf, 1), cmplx(nan, nan)},
	Test{cmplx(-inf, 1), cmplx(-inf, -1), cmplx(nan, nan)},
	Test{cmplx(-inf, 1), cmplx(-inf, 2), cmplx(nan, nan)},
	Test{cmplx(-inf, 1), cmplx(-inf, nan), cmplx(nan, nan)},
	Test{cmplx(-inf, 1), cmplx(-inf, inf), cmplx(nan, nan)},
	Test{cmplx(-inf, 1), cmplx(-inf, -inf), cmplx(nan, nan)},
	Test{cmplx(-inf, -1), cmplx(0, 0), cmplx(-inf, -inf)},
	Test{cmplx(-inf, -1), cmplx(0, 1), cmplx(nan, inf)},
	Test{cmplx(-inf, -1), cmplx(0, -1), cmplx(nan, -inf)},
	Test{cmplx(-inf, -1), cmplx(0, 2), cmplx(nan, inf)},
	Test{cmplx(-inf, -1), cmplx(0, nan), cmplx(nan, nan)},
	Test{cmplx(-inf, -1), cmplx(0, inf), cmplx(nan, nan)},
	Test{cmplx(-inf, -1), cmplx(0, -inf), cmplx(nan, nan)},
	Test{cmplx(-inf, -1), cmplx(1, 0), cmplx(-inf, nan)},
	Test{cmplx(-inf, -1), cmplx(1, 1), cmplx(-inf, inf)},
	Test{cmplx(-inf, -1), cmplx(1, -1), cmplx(-inf, -inf)},
	Test{cmplx(-inf, -1), cmplx(1, 2), cmplx(-inf, inf)},
	Test{cmplx(-inf, -1), cmplx(1, nan), cmplx(nan, nan)},
	Test{cmplx(-inf, -1), cmplx(1, inf), cmplx(nan, nan)},
	Test{cmplx(-inf, -1), cmplx(1, -inf), cmplx(nan, nan)},
	Test{cmplx(-inf, -1), cmplx(-1, 0), cmplx(inf, nan)},
	Test{cmplx(-inf, -1), cmplx(-1, 1), cmplx(inf, inf)},
	Test{cmplx(-inf, -1), cmplx(-1, -1), cmplx(inf, -inf)},
	Test{cmplx(-inf, -1), cmplx(-1, 2), cmplx(inf, inf)},
	Test{cmplx(-inf, -1), cmplx(-1, nan), cmplx(nan, nan)},
	Test{cmplx(-inf, -1), cmplx(-1, inf), cmplx(nan, nan)},
	Test{cmplx(-inf, -1), cmplx(-1, -inf), cmplx(nan, nan)},
	Test{cmplx(-inf, -1), cmplx(2, 0), cmplx(-inf, nan)},
	Test{cmplx(-inf, -1), cmplx(2, 1), cmplx(-inf, inf)},
	Test{cmplx(-inf, -1), cmplx(2, -1), cmplx(-inf, -inf)},
	Test{cmplx(-inf, -1), cmplx(2, 2), cmplx(-inf, inf)},
	Test{cmplx(-inf, -1), cmplx(2, nan), cmplx(nan, nan)},
	Test{cmplx(-inf, -1), cmplx(2, inf), cmplx(nan, nan)},
	Test{cmplx(-inf, -1), cmplx(2, -inf), cmplx(nan, nan)},
	Test{cmplx(-inf, -1), cmplx(nan, 0), cmplx(nan, nan)},
	Test{cmplx(-inf, -1), cmplx(nan, 1), cmplx(nan, nan)},
	Test{cmplx(-inf, -1), cmplx(nan, -1), cmplx(nan, nan)},
	Test{cmplx(-inf, -1), cmplx(nan, 2), cmplx(nan, nan)},
	Test{cmplx(-inf, -1), cmplx(nan, nan), cmplx(nan, nan)},
	Test{cmplx(-inf, -1), cmplx(nan, inf), cmplx(nan, nan)},
	Test{cmplx(-inf, -1), cmplx(nan, -inf), cmplx(nan, nan)},
	Test{cmplx(-inf, -1), cmplx(inf, 0), cmplx(nan, nan)},
	Test{cmplx(-inf, -1), cmplx(inf, 1), cmplx(nan, nan)},
	Test{cmplx(-inf, -1), cmplx(inf, -1), cmplx(nan, nan)},
	Test{cmplx(-inf, -1), cmplx(inf, 2), cmplx(nan, nan)},
	Test{cmplx(-inf, -1), cmplx(inf, nan), cmplx(nan, nan)},
	Test{cmplx(-inf, -1), cmplx(inf, inf), cmplx(nan, nan)},
	Test{cmplx(-inf, -1), cmplx(inf, -inf), cmplx(nan, nan)},
	Test{cmplx(-inf, -1), cmplx(-inf, 0), cmplx(nan, nan)},
	Test{cmplx(-inf, -1), cmplx(-inf, 1), cmplx(nan, nan)},
	Test{cmplx(-inf, -1), cmplx(-inf, -1), cmplx(nan, nan)},
	Test{cmplx(-inf, -1), cmplx(-inf, 2), cmplx(nan, nan)},
	Test{cmplx(-inf, -1), cmplx(-inf, nan), cmplx(nan, nan)},
	Test{cmplx(-inf, -1), cmplx(-inf, inf), cmplx(nan, nan)},
	Test{cmplx(-inf, -1), cmplx(-inf, -inf), cmplx(nan, nan)},
	Test{cmplx(-inf, 2), cmplx(0, 0), cmplx(-inf, inf)},
	Test{cmplx(-inf, 2), cmplx(0, 1), cmplx(nan, inf)},
	Test{cmplx(-inf, 2), cmplx(0, -1), cmplx(nan, -inf)},
	Test{cmplx(-inf, 2), cmplx(0, 2), cmplx(nan, inf)},
	Test{cmplx(-inf, 2), cmplx(0, nan), cmplx(nan, nan)},
	Test{cmplx(-inf, 2), cmplx(0, inf), cmplx(nan, nan)},
	Test{cmplx(-inf, 2), cmplx(0, -inf), cmplx(nan, nan)},
	Test{cmplx(-inf, 2), cmplx(1, 0), cmplx(-inf, nan)},
	Test{cmplx(-inf, 2), cmplx(1, 1), cmplx(-inf, inf)},
	Test{cmplx(-inf, 2), cmplx(1, -1), cmplx(-inf, -inf)},
	Test{cmplx(-inf, 2), cmplx(1, 2), cmplx(-inf, inf)},
	Test{cmplx(-inf, 2), cmplx(1, nan), cmplx(nan, nan)},
	Test{cmplx(-inf, 2), cmplx(1, inf), cmplx(nan, nan)},
	Test{cmplx(-inf, 2), cmplx(1, -inf), cmplx(nan, nan)},
	Test{cmplx(-inf, 2), cmplx(-1, 0), cmplx(inf, nan)},
	Test{cmplx(-inf, 2), cmplx(-1, 1), cmplx(inf, inf)},
	Test{cmplx(-inf, 2), cmplx(-1, -1), cmplx(inf, -inf)},
	Test{cmplx(-inf, 2), cmplx(-1, 2), cmplx(inf, inf)},
	Test{cmplx(-inf, 2), cmplx(-1, nan), cmplx(nan, nan)},
	Test{cmplx(-inf, 2), cmplx(-1, inf), cmplx(nan, nan)},
	Test{cmplx(-inf, 2), cmplx(-1, -inf), cmplx(nan, nan)},
	Test{cmplx(-inf, 2), cmplx(2, 0), cmplx(-inf, nan)},
	Test{cmplx(-inf, 2), cmplx(2, 1), cmplx(-inf, inf)},
	Test{cmplx(-inf, 2), cmplx(2, -1), cmplx(-inf, -inf)},
	Test{cmplx(-inf, 2), cmplx(2, 2), cmplx(-inf, inf)},
	Test{cmplx(-inf, 2), cmplx(2, nan), cmplx(nan, nan)},
	Test{cmplx(-inf, 2), cmplx(2, inf), cmplx(nan, nan)},
	Test{cmplx(-inf, 2), cmplx(2, -inf), cmplx(nan, nan)},
	Test{cmplx(-inf, 2), cmplx(nan, 0), cmplx(nan, nan)},
	Test{cmplx(-inf, 2), cmplx(nan, 1), cmplx(nan, nan)},
	Test{cmplx(-inf, 2), cmplx(nan, -1), cmplx(nan, nan)},
	Test{cmplx(-inf, 2), cmplx(nan, 2), cmplx(nan, nan)},
	Test{cmplx(-inf, 2), cmplx(nan, nan), cmplx(nan, nan)},
	Test{cmplx(-inf, 2), cmplx(nan, inf), cmplx(nan, nan)},
	Test{cmplx(-inf, 2), cmplx(nan, -inf), cmplx(nan, nan)},
	Test{cmplx(-inf, 2), cmplx(inf, 0), cmplx(nan, nan)},
	Test{cmplx(-inf, 2), cmplx(inf, 1), cmplx(nan, nan)},
	Test{cmplx(-inf, 2), cmplx(inf, -1), cmplx(nan, nan)},
	Test{cmplx(-inf, 2), cmplx(inf, 2), cmplx(nan, nan)},
	Test{cmplx(-inf, 2), cmplx(inf, nan), cmplx(nan, nan)},
	Test{cmplx(-inf, 2), cmplx(inf, inf), cmplx(nan, nan)},
	Test{cmplx(-inf, 2), cmplx(inf, -inf), cmplx(nan, nan)},
	Test{cmplx(-inf, 2), cmplx(-inf, 0), cmplx(nan, nan)},
	Test{cmplx(-inf, 2), cmplx(-inf, 1), cmplx(nan, nan)},
	Test{cmplx(-inf, 2), cmplx(-inf, -1), cmplx(nan, nan)},
	Test{cmplx(-inf, 2), cmplx(-inf, 2), cmplx(nan, nan)},
	Test{cmplx(-inf, 2), cmplx(-inf, nan), cmplx(nan, nan)},
	Test{cmplx(-inf, 2), cmplx(-inf, inf), cmplx(nan, nan)},
	Test{cmplx(-inf, 2), cmplx(-inf, -inf), cmplx(nan, nan)},
	Test{cmplx(-inf, nan), cmplx(0, 0), cmplx(-inf, nan)},
	Test{cmplx(-inf, nan), cmplx(0, 1), cmplx(nan, inf)},
	Test{cmplx(-inf, nan), cmplx(0, -1), cmplx(nan, -inf)},
	Test{cmplx(-inf, nan), cmplx(0, 2), cmplx(nan, inf)},
	Test{cmplx(-inf, nan), cmplx(0, nan), cmplx(nan, nan)},
	Test{cmplx(-inf, nan), cmplx(0, inf), cmplx(nan, nan)},
	Test{cmplx(-inf, nan), cmplx(0, -inf), cmplx(nan, nan)},
	Test{cmplx(-inf, nan), cmplx(1, 0), cmplx(-inf, nan)},
	Test{cmplx(-inf, nan), cmplx(1, 1), cmplx(-inf, inf)},
	Test{cmplx(-inf, nan), cmplx(1, -1), cmplx(-inf, -inf)},
	Test{cmplx(-inf, nan), cmplx(1, 2), cmplx(-inf, inf)},
	Test{cmplx(-inf, nan), cmplx(1, nan), cmplx(nan, nan)},
	Test{cmplx(-inf, nan), cmplx(1, inf), cmplx(nan, nan)},
	Test{cmplx(-inf, nan), cmplx(1, -inf), cmplx(nan, nan)},
	Test{cmplx(-inf, nan), cmplx(-1, 0), cmplx(inf, nan)},
	Test{cmplx(-inf, nan), cmplx(-1, 1), cmplx(inf, inf)},
	Test{cmplx(-inf, nan), cmplx(-1, -1), cmplx(inf, -inf)},
	Test{cmplx(-inf, nan), cmplx(-1, 2), cmplx(inf, inf)},
	Test{cmplx(-inf, nan), cmplx(-1, nan), cmplx(nan, nan)},
	Test{cmplx(-inf, nan), cmplx(-1, inf), cmplx(nan, nan)},
	Test{cmplx(-inf, nan), cmplx(-1, -inf), cmplx(nan, nan)},
	Test{cmplx(-inf, nan), cmplx(2, 0), cmplx(-inf, nan)},
	Test{cmplx(-inf, nan), cmplx(2, 1), cmplx(-inf, inf)},
	Test{cmplx(-inf, nan), cmplx(2, -1), cmplx(-inf, -inf)},
	Test{cmplx(-inf, nan), cmplx(2, 2), cmplx(-inf, inf)},
	Test{cmplx(-inf, nan), cmplx(2, nan), cmplx(nan, nan)},
	Test{cmplx(-inf, nan), cmplx(2, inf), cmplx(nan, nan)},
	Test{cmplx(-inf, nan), cmplx(2, -inf), cmplx(nan, nan)},
	Test{cmplx(-inf, nan), cmplx(nan, 0), cmplx(nan, nan)},
	Test{cmplx(-inf, nan), cmplx(nan, 1), cmplx(nan, nan)},
	Test{cmplx(-inf, nan), cmplx(nan, -1), cmplx(nan, nan)},
	Test{cmplx(-inf, nan), cmplx(nan, 2), cmplx(nan, nan)},
	Test{cmplx(-inf, nan), cmplx(nan, nan), cmplx(nan, nan)},
	Test{cmplx(-inf, nan), cmplx(nan, inf), cmplx(nan, nan)},
	Test{cmplx(-inf, nan), cmplx(nan, -inf), cmplx(nan, nan)},
	Test{cmplx(-inf, nan), cmplx(inf, 0), cmplx(nan, nan)},
	Test{cmplx(-inf, nan), cmplx(inf, 1), cmplx(nan, nan)},
	Test{cmplx(-inf, nan), cmplx(inf, -1), cmplx(nan, nan)},
	Test{cmplx(-inf, nan), cmplx(inf, 2), cmplx(nan, nan)},
	Test{cmplx(-inf, nan), cmplx(inf, nan), cmplx(nan, nan)},
	Test{cmplx(-inf, nan), cmplx(inf, inf), cmplx(nan, nan)},
	Test{cmplx(-inf, nan), cmplx(inf, -inf), cmplx(nan, nan)},
	Test{cmplx(-inf, nan), cmplx(-inf, 0), cmplx(nan, nan)},
	Test{cmplx(-inf, nan), cmplx(-inf, 1), cmplx(nan, nan)},
	Test{cmplx(-inf, nan), cmplx(-inf, -1), cmplx(nan, nan)},
	Test{cmplx(-inf, nan), cmplx(-inf, 2), cmplx(nan, nan)},
	Test{cmplx(-inf, nan), cmplx(-inf, nan), cmplx(nan, nan)},
	Test{cmplx(-inf, nan), cmplx(-inf, inf), cmplx(nan, nan)},
	Test{cmplx(-inf, nan), cmplx(-inf, -inf), cmplx(nan, nan)},
	Test{cmplx(-inf, inf), cmplx(0, 0), cmplx(-inf, inf)},
	Test{cmplx(-inf, inf), cmplx(0, 1), cmplx(inf, inf)},
	Test{cmplx(-inf, inf), cmplx(0, -1), cmplx(-inf, -inf)},
	Test{cmplx(-inf, inf), cmplx(0, 2), cmplx(inf, inf)},
	Test{cmplx(-inf, inf), cmplx(0, nan), cmplx(nan, nan)},
	Test{cmplx(-inf, inf), cmplx(0, inf), cmplx(nan, nan)},
	Test{cmplx(-inf, inf), cmplx(0, -inf), cmplx(nan, nan)},
	Test{cmplx(-inf, inf), cmplx(1, 0), cmplx(-inf, inf)},
	Test{cmplx(-inf, inf), cmplx(1, 1), cmplx(nan, inf)},
	Test{cmplx(-inf, inf), cmplx(1, -1), cmplx(-inf, nan)},
	Test{cmplx(-inf, inf), cmplx(1, 2), cmplx(nan, inf)},
	Test{cmplx(-inf, inf), cmplx(1, nan), cmplx(nan, nan)},
	Test{cmplx(-inf, inf), cmplx(1, inf), cmplx(nan, nan)},
	Test{cmplx(-inf, inf), cmplx(1, -inf), cmplx(nan, nan)},
	Test{cmplx(-inf, inf), cmplx(-1, 0), cmplx(inf, -inf)},
	Test{cmplx(-inf, inf), cmplx(-1, 1), cmplx(inf, nan)},
	Test{cmplx(-inf, inf), cmplx(-1, -1), cmplx(nan, -inf)},
	Test{cmplx(-inf, inf), cmplx(-1, 2), cmplx(inf, nan)},
	Test{cmplx(-inf, inf), cmplx(-1, nan), cmplx(nan, nan)},
	Test{cmplx(-inf, inf), cmplx(-1, inf), cmplx(nan, nan)},
	Test{cmplx(-inf, inf), cmplx(-1, -inf), cmplx(nan, nan)},
	Test{cmplx(-inf, inf), cmplx(2, 0), cmplx(-inf, inf)},
	Test{cmplx(-inf, inf), cmplx(2, 1), cmplx(nan, inf)},
	Test{cmplx(-inf, inf), cmplx(2, -1), cmplx(-inf, nan)},
	Test{cmplx(-inf, inf), cmplx(2, 2), cmplx(nan, inf)},
	Test{cmplx(-inf, inf), cmplx(2, nan), cmplx(nan, nan)},
	Test{cmplx(-inf, inf), cmplx(2, inf), cmplx(nan, nan)},
	Test{cmplx(-inf, inf), cmplx(2, -inf), cmplx(nan, nan)},
	Test{cmplx(-inf, inf), cmplx(nan, 0), cmplx(nan, nan)},
	Test{cmplx(-inf, inf), cmplx(nan, 1), cmplx(nan, nan)},
	Test{cmplx(-inf, inf), cmplx(nan, -1), cmplx(nan, nan)},
	Test{cmplx(-inf, inf), cmplx(nan, 2), cmplx(nan, nan)},
	Test{cmplx(-inf, inf), cmplx(nan, nan), cmplx(nan, nan)},
	Test{cmplx(-inf, inf), cmplx(nan, inf), cmplx(nan, nan)},
	Test{cmplx(-inf, inf), cmplx(nan, -inf), cmplx(nan, nan)},
	Test{cmplx(-inf, inf), cmplx(inf, 0), cmplx(nan, nan)},
	Test{cmplx(-inf, inf), cmplx(inf, 1), cmplx(nan, nan)},
	Test{cmplx(-inf, inf), cmplx(inf, -1), cmplx(nan, nan)},
	Test{cmplx(-inf, inf), cmplx(inf, 2), cmplx(nan, nan)},
	Test{cmplx(-inf, inf), cmplx(inf, nan), cmplx(nan, nan)},
	Test{cmplx(-inf, inf), cmplx(inf, inf), cmplx(nan, nan)},
	Test{cmplx(-inf, inf), cmplx(inf, -inf), cmplx(nan, nan)},
	Test{cmplx(-inf, inf), cmplx(-inf, 0), cmplx(nan, nan)},
	Test{cmplx(-inf, inf), cmplx(-inf, 1), cmplx(nan, nan)},
	Test{cmplx(-inf, inf), cmplx(-inf, -1), cmplx(nan, nan)},
	Test{cmplx(-inf, inf), cmplx(-inf, 2), cmplx(nan, nan)},
	Test{cmplx(-inf, inf), cmplx(-inf, nan), cmplx(nan, nan)},
	Test{cmplx(-inf, inf), cmplx(-inf, inf), cmplx(nan, nan)},
	Test{cmplx(-inf, inf), cmplx(-inf, -inf), cmplx(nan, nan)},
	Test{cmplx(-inf, -inf), cmplx(0, 0), cmplx(-inf, -inf)},
	Test{cmplx(-inf, -inf), cmplx(0, 1), cmplx(-inf, inf)},
	Test{cmplx(-inf, -inf), cmplx(0, -1), cmplx(inf, -inf)},
	Test{cmplx(-inf, -inf), cmplx(0, 2), cmplx(-inf, inf)},
	Test{cmplx(-inf, -inf), cmplx(0, nan), cmplx(nan, nan)},
	Test{cmplx(-inf, -inf), cmplx(0, inf), cmplx(nan, nan)},
	Test{cmplx(-inf, -inf), cmplx(0, -inf), cmplx(nan, nan)},
	Test{cmplx(-inf, -inf), cmplx(1, 0), cmplx(-inf, -inf)},
	Test{cmplx(-inf, -inf), cmplx(1, 1), cmplx(-inf, nan)},
	Test{cmplx(-inf, -inf), cmplx(1, -1), cmplx(nan, -inf)},
	Test{cmplx(-inf, -inf), cmplx(1, 2), cmplx(-inf, nan)},
	Test{cmplx(-inf, -inf), cmplx(1, nan), cmplx(nan, nan)},
	Test{cmplx(-inf, -inf), cmplx(1, inf), cmplx(nan, nan)},
	Test{cmplx(-inf, -inf), cmplx(1, -inf), cmplx(nan, nan)},
	Test{cmplx(-inf, -inf), cmplx(-1, 0), cmplx(inf, inf)},
	Test{cmplx(-inf, -inf), cmplx(-1, 1), cmplx(nan, inf)},
	Test{cmplx(-inf, -inf), cmplx(-1, -1), cmplx(inf, nan)},
	Test{cmplx(-inf, -inf), cmplx(-1, 2), cmplx(nan, inf)},
	Test{cmplx(-inf, -inf), cmplx(-1, nan), cmplx(nan, nan)},
	Test{cmplx(-inf, -inf), cmplx(-1, inf), cmplx(nan, nan)},
	Test{cmplx(-inf, -inf), cmplx(-1, -inf), cmplx(nan, nan)},
	Test{cmplx(-inf, -inf), cmplx(2, 0), cmplx(-inf, -inf)},
	Test{cmplx(-inf, -inf), cmplx(2, 1), cmplx(-inf, nan)},
	Test{cmplx(-inf, -inf), cmplx(2, -1), cmplx(nan, -inf)},
	Test{cmplx(-inf, -inf), cmplx(2, 2), cmplx(-inf, nan)},
	Test{cmplx(-inf, -inf), cmplx(2, nan), cmplx(nan, nan)},
	Test{cmplx(-inf, -inf), cmplx(2, inf), cmplx(nan, nan)},
	Test{cmplx(-inf, -inf), cmplx(2, -inf), cmplx(nan, nan)},
	Test{cmplx(-inf, -inf), cmplx(nan, 0), cmplx(nan, nan)},
	Test{cmplx(-inf, -inf), cmplx(nan, 1), cmplx(nan, nan)},
	Test{cmplx(-inf, -inf), cmplx(nan, -1), cmplx(nan, nan)},
	Test{cmplx(-inf, -inf), cmplx(nan, 2), cmplx(nan, nan)},
	Test{cmplx(-inf, -inf), cmplx(nan, nan), cmplx(nan, nan)},
	Test{cmplx(-inf, -inf), cmplx(nan, inf), cmplx(nan, nan)},
	Test{cmplx(-inf, -inf), cmplx(nan, -inf), cmplx(nan, nan)},
	Test{cmplx(-inf, -inf), cmplx(inf, 0), cmplx(nan, nan)},
	Test{cmplx(-inf, -inf), cmplx(inf, 1), cmplx(nan, nan)},
	Test{cmplx(-inf, -inf), cmplx(inf, -1), cmplx(nan, nan)},
	Test{cmplx(-inf, -inf), cmplx(inf, 2), cmplx(nan, nan)},
	Test{cmplx(-inf, -inf), cmplx(inf, nan), cmplx(nan, nan)},
	Test{cmplx(-inf, -inf), cmplx(inf, inf), cmplx(nan, nan)},
	Test{cmplx(-inf, -inf), cmplx(inf, -inf), cmplx(nan, nan)},
	Test{cmplx(-inf, -inf), cmplx(-inf, 0), cmplx(nan, nan)},
	Test{cmplx(-inf, -inf), cmplx(-inf, 1), cmplx(nan, nan)},
	Test{cmplx(-inf, -inf), cmplx(-inf, -1), cmplx(nan, nan)},
	Test{cmplx(-inf, -inf), cmplx(-inf, 2), cmplx(nan, nan)},
	Test{cmplx(-inf, -inf), cmplx(-inf, nan), cmplx(nan, nan)},
	Test{cmplx(-inf, -inf), cmplx(-inf, inf), cmplx(nan, nan)},
	Test{cmplx(-inf, -inf), cmplx(-inf, -inf), cmplx(nan, nan)},
}
