// { dg-do compile { target i?86-*-cygwin* i?86-*-mingw* x86_64-*-mingw*} }
//  Test that non-virtual MI thunks are exported.


// To build the dll and client app:
// g++ -shared -o MI.dll dllexport-MI1.C
// g++ -o MItest.exe dllimport-MI1.C -L. MI.dll

#define BUILDING_MI_DLL
#include "dll-MI1.h"

MBase::~MBase(){}

int D1::vf() const { return D1_return; }

D2::D2() { }
D2::D2 (D2 const&) { }
int D2::vf() const { return D2_return; }

int MI1::vf() const { return D1::vf();}

// a dllexported object 
DLL_IMPEXP MI1 dllMI1;

// use default copy ctor 
DLL_IMPEXP MI1 dllMI1Copy =  dllMI1;

// Scan for export of some methods that are undefined in dllimportMI1.C,

// { dg-final { scan-assembler "-export:\[\\\\\"\]*_ZNK2D12vfEv" } }
// { dg-final { scan-assembler "-export:\[\\\\\"\]*_ZNK2D22vfEv" } }
// { dg-final { scan-assembler "-export:\[\\\\\"\]*_ZNK3MI12vfEv" } }

// and MI thunks,

// { dg-final { scan-assembler "-export:\[\\\\\"\]*_ZThn4_NK3MI12vfEv" } }
// { dg-final { scan-assembler "-export:\[\\\\\"\]*_ZTv0_n12_NK2D12vfEv" } }

// and a vtable data variable.

// { dg-final { scan-assembler "-export:\[\\\\\"\]*_ZTV2D1\[\\\"\]*,data" } }

// an explicit copy ctor
// { dg-final { scan-assembler "-export:\[\\\\\"\]*_ZN2D2C2ERKS_" } }

// but not implicit copy ctor generated by compiler
// nor implicit dtor

// { dg-final { scan-assembler-not "-export:\[\\\\\"\]*_ZN2D1C2ERKS_" } }
// { dg-final { scan-assembler-not "-export:\[\\\\\"\]*_ZN2D1D2Ev" } }

