#! /bin/sh

arch="$1"
if [ -z "$1" ]; then
    echo >&2 "usage: $0 <architecture>"
    exit 1
fi

[ -z "$TARGET_ARCH" ] && verbose=y

#vendor=$(if dpkg-vendor --derives-from Ubuntu; then echo ubuntu; else echo debian; fi)
gcc_ver=$(dpkg-parsechangelog |egrep ^Source:|cut -f2 -d' '|cut -f2 -d'-')

cross=cross
case "$arch" in
    arm64)
	pkg_all=libgcc-${gcc_ver}-dev-arm64-cross;;
    ppc64)
	pkg_all=libgcc-${gcc_ver}-dev-ppc64-cross;;
    mips64r6el)
	pkg_all=libgcc-${gcc_ver}-dev-mips64r6el-cross;;
    *)
	echo >&2 "usage: $0 <architecture>"
	echo >&2 "  select from arm64, ppc64, mips64r6el"
	exit 1
esac
case "$(dpkg-architecture -qDEB_HOST_ARCH)" in
    arm64)
	pkg_any=gcc-${gcc_ver}-arm-linux-gnueabihf-base;;
    ppc64)
	pkg_any=gcc-${gcc_ver}-powerpc64le-linux-gnu-base;;
    ppc64el)
	pkg_any=gcc-${gcc_ver}-powerpc-linux-gnu-base;;
    amd64|i386|x32)
	case "$arch" in
	    arm64)
		pkg_any=gcc-${gcc_ver}-aarch64-linux-gnu-base;;
	    ppc64)
		pkg_any=gcc-${gcc_ver}-powerpc64-linux-gnu-base;;
	esac;;
esac

v_deb_gcc=$(apt-cache policy gcc-${gcc_ver}-source | awk '/^ \*\*\*/ {print $2}')

v_deb_gcc_cross=$(apt-cache show --no-all-versions $pkg_all 2>/dev/null | awk '/^Version/ {print $2}')

if [ -n "$verbose" ]; then
    echo >&2 "gcc: $v_deb_gcc / $v_deb_gcc_cross"
fi

if [ -n "$v_deb_gcc_cross" ]; then
    v_deb_gcc_cross_v=$(echo $v_deb_gcc_cross | sed 's/\(.*\)c[ros]*.*/\1/')
    v_deb_gcc_cross_c=$(echo $v_deb_gcc_cross | sed 's/.*c[ros]*\(.*\)/\1/')
    case "$v_deb_gcc_cross_c" in
	*.*) v_deb_gcc_cross_c=$(echo $v_deb_gcc_cross_c | awk -F. '{print $1}')
    esac
else
    v_deb_gcc_cross_v=$v_deb_gcc
    v_deb_gcc_cross_c=0
fi

if [ -n "$verbose" ]; then
    echo >&2 ""
    echo >&2 "old gcc version: $v_deb_gcc_cross_v / $v_deb_gcc_cross_c"
fi

echo ${v_deb_gcc_cross_v}cross${v_deb_gcc_cross_c}
