/* GBINDADMIN, a GTK+ frontend for ISC BIND
 * Copyright C 2005, 2006 Magnus Loef <magnus-swe@telia.com> 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307, USA.
 *
*/


#include <gtk/gtk.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "widgets.h"
#include "gettext.h"
#include "show_info.h"
#include "allocate.h"

extern char CHROOT_PATH_BUF[1024];
extern char SYSLOG_PATH_BUF[1024];



void populate_root_servers_tab(struct w *widgets)
{
    FILE *fp;
    long conf_size=0;
    char *line, *buffy;
    gchar *file, *info, *utf8=NULL;
    GtkTextBuffer *text_buffer;

    text_buffer = gtk_text_view_get_buffer(GTK_TEXT_VIEW(widgets->rs_textview));

    file = g_strdup_printf("%s/etc/root.hints", CHROOT_PATH_BUF);
    if((fp=fopen(file, "r"))==NULL)
    {
        info = g_strdup_printf(_("Could not find:\n%s\n"), CHROOT_PATH_BUF);
        show_info(info);
        g_free(info);
        return;
    }
    fseek(fp, 0, SEEK_END);
    conf_size = ftell(fp);
    rewind(fp);

    line = allocate(conf_size+1);
    buffy = allocate(conf_size+1);

    while(fgets(line, conf_size, fp)!=NULL)
    {
	strcat(buffy, line);
    }
    fclose(fp);
    free(line);

    utf8 = g_locale_to_utf8(buffy, strlen(buffy), NULL, NULL, NULL);
    free(buffy);
    if( utf8!=NULL )
    {
	/* Strlen error on NULL, thats why.. */
        gtk_text_buffer_set_text(text_buffer, utf8, strlen(utf8));
        g_free(utf8);
    }
}
