/*
 * Copyright (C) 2012-2014 Open Source Robotics Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
*/

#ifndef _TEST_LOGS_CMP_H_
#define _TEST_LOGS_CMP_H_

#include "gazebo/gazebo_config.h"

#ifdef __GNUC__
    #define MAYBE_UNUSED __attribute__((used))
#elif defined _MSC_VER
    #pragma warning(disable: Cxxxxx)
    #define MAYBE_UNUSED
#else
    #define MAYBE_UNUSED
#endif


static std::string pr2StateLog =
"<?xml version='1.0'?>\n<gazebo_log>\n<header>\n<log_version>1.0</log_version>\n<gazebo_version>1.4.6</gazebo_version>\n<rand_seed>32606</rand_seed>\n</header>\n\n<chunk encoding='txt'><![CDATA[\n<sdf version ='1.3'>\n<world name='default'>\n  <model name='ground_plane'>\n    <static>1</static>\n    <link name='link'>\n      <collision name='collision'>\n        <geometry>\n          <plane>\n            <normal>0.000000 0.000000 1.000000</normal>\n            <size>100.000000 100.000000</size>\n          </plane>\n        </geometry>\n        <surface>\n          <friction>\n            <ode>\n              <mu>100.000000</mu>\n              <mu2>50.000000</mu2>\n            </ode>\n          </friction>\n          <bounce/>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='visual'>\n        <cast_shadows>0</cast_shadows>\n        <geometry>\n          <plane>\n            <normal>0.000000 0.000000 1.000000</normal>\n            <size>100.000000 100.000000</size>\n          </plane>\n        </geometry>\n        <material>\n          <script>\n            <uri>file://media/materials/scripts/gazebo.material</uri>\n            <name>Gazebo/Grey</name>\n          </script>\n        </material>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <self_collide>0</self_collide>\n      <kinematic>0</kinematic>\n      <gravity>1</gravity>\n    </link>\n  </model>\n  <light name='sun' type='directional'>\n    <cast_shadows>1</cast_shadows>\n    <pose>0.000000 0.000000 10.000000 0.000000 0.000000 0.000000</pose>\n    <diffuse>0.800000 0.800000 0.800000 1.000000</diffuse>\n    <specular>0.100000 0.100000 0.100000 1.000000</specular>\n    <attenuation>\n      <range>1000.000000</range>\n      <constant>0.900000</constant>\n      <linear>0.010000</linear>\n      <quadratic>0.001000</quadratic>\n    </attenuation>\n    <direction>-0.500000 0.500000 -1.000000</direction>\n  </light>\n  <model name='pr2'>\n    <static>0</static>\n    <link name='base_footprint'>\n      <self_collide>0</self_collide>\n      <inertial>\n        <mass>118.001000</mass>\n        <pose>-0.062421 0.000000 0.201365 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>8.431730</ixx>\n          <ixy>-0.009720</ixy>\n          <ixz>1.901570</ixz>\n          <iyy>8.533050</iyy>\n          <iyz>-0.007380</iyz>\n          <izz>3.787470</izz>\n        </inertia>\n      </inertial>\n      <collision name='base_footprint_geom'>\n        <pose>0.000000 0.000000 0.071000 0.000000 0.000000 0.000000</pose>\n        <geometry>\n          <box>\n            <size>0.001000 0.001000 0.001000</size>\n          </box>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='base_footprint_geom_visual'>\n        <geometry>\n          <box>\n            <size>0.010000 0.010000 0.010000</size>\n          </box>\n        </geometry>\n      </visual>\n      <collision name='base_footprint_geom_base_bellow_link'>\n        <pose>-0.290000 0.000000 0.851000 0.000000 0.000000 0.000000</pose>\n        <geometry>\n          <box>\n            <size>0.050000 0.370000 0.300000</size>\n          </box>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='base_footprint_geom_base_bellow_link_visual'>\n        <pose>-0.290000 0.000000 0.851000 0.000000 0.000000 0.000000</pose>\n        <geometry>\n          <box>\n            <size>0.050000 0.370000 0.300000</size>\n          </box>\n        </geometry>\n      </visual>\n      <collision name='base_footprint_geom_base_link'>\n        <pose>0.000000 0.000000 0.051000 0.000000 0.000000 0.000000</pose>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/base_v0/base_L.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='base_footprint_geom_base_link_visual'>\n        <pose>0.000000 0.000000 0.051000 0.000000 0.000000 0.000000</pose>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/base_v0/base.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <sensor name='base_contact_sensor' type='contact'>\n        <update_rate>100.000000</update_rate>\n        <always_on>0</always_on>\n        <visualize>0</visualize>\n        <contact>\n          <collision>base_footprint_geom_base_link</collision>\n          <topic>__default_topic__</topic>\n        </contact>\n        <plugin name='gazebo_contact' filename='libContactPlugin.so'/>\n      </sensor>\n      <sensor name='base_laser' type='ray'>\n        <always_on>0</always_on>\n        <visualize>0</visualize>\n        <update_rate>20.000000</update_rate>\n        <pose>0.275000 0.000000 0.303000 0.000000 0.000000 0.000000</pose>\n        <ray>\n          <scan>\n            <horizontal>\n              <samples>640</samples>\n              <resolution>1.000000</resolution>\n              <min_angle>-2.268900</min_angle>\n              <max_angle>2.268900</max_angle>\n            </horizontal>\n          </scan>\n          <range>\n            <min>0.080000</min>\n            <max>10.000000</max>\n            <resolution>0.010000</resolution>\n          </range>\n        </ray>\n        <plugin name='laser' filename='libRayPlugin.so'/>\n      </sensor>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n      <gravity>1</gravity>\n    </link>\n    <link name='bl_caster_rotation_link'>\n      <self_collide>0</self_collide>\n      <pose>-0.224600 0.224600 0.079200 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>3.473080</mass>\n        <pose>0.000000 0.000000 0.070000 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.012412</ixx>\n          <ixy>-0.000712</ixy>\n          <ixz>0.000503</ixz>\n          <iyy>0.015218</iyy>\n          <iyz>-0.000004</iyz>\n          <izz>0.011764</izz>\n        </inertia>\n      </inertial>\n      <collision name='bl_caster_rotation_link_geom'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/base_v0/caster_L.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='bl_caster_rotation_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/base_v0/caster.stl</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n      <gravity>1</gravity>\n    </link>\n    <link name='bl_caster_l_wheel_link'>\n      <self_collide>0</self_collide>\n      <pose>-0.224600 0.273600 0.079200 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.440360</mass>\n        <inertia>\n          <ixx>0.012412</ixx>\n          <ixy>-0.000712</ixy>\n          <ixz>0.000503</ixz>\n          <iyy>0.015218</iyy>\n          <iyz>-0.000004</iyz>\n          <izz>0.011764</izz>\n        </inertia>\n      </inertial>\n      <collision name='bl_caster_l_wheel_link_geom'>\n        <pose>0.000000 0.000000 0.000000 1.570800 0.000000 0.000000</pose>\n        <geometry>\n          <cylinder>\n            <radius>0.074792</radius>\n            <length>0.034000</length>\n          </cylinder>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='bl_caster_l_wheel_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/base_v0/wheel.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n      <gravity>1</gravity>\n    </link>\n    <link name='bl_caster_r_wheel_link'>\n      <self_collide>0</self_collide>\n      <pose>-0.224600 0.175600 0.079200 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.440360</mass>\n        <inertia>\n          <ixx>0.012412</ixx>\n          <ixy>0.000712</ixy>\n          <ixz>0.000503</ixz>\n          <iyy>0.015218</iyy>\n          <iyz>0.000004</iyz>\n          <izz>0.011764</izz>\n        </inertia>\n      </inertial>\n      <collision name='bl_caster_r_wheel_link_geom'>\n        <pose>0.000000 0.000000 0.000000 1.570800 0.000000 0.000000</pose>\n        <geometry>\n          <cylinder>\n            <radius>0.074792</radius>\n            <length>0.034000</length>\n          </cylinder>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='bl_caster_r_wheel_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/base_v0/wheel.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n      <gravity>1</gravity>\n    </link>\n    <link name='br_caster_rotation_link'>\n      <self_collide>0</self_collide>\n      <pose>-0.224600 -0.224600 0.079200 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>3.473080</mass>\n        <pose>0.000000 0.000000 0.070000 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.012412</ixx>\n          <ixy>-0.000712</ixy>\n          <ixz>0.000503</ixz>\n          <iyy>0.015218</iyy>\n          <iyz>-0.000004</iyz>\n          <izz>0.011764</izz>\n        </inertia>\n      </inertial>\n      <collision name='br_caster_rotation_link_geom'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/base_v0/caster_L.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='br_caster_rotation_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/base_v0/caster.stl</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n      <gravity>1</gravity>\n    </link>\n    <link name='br_caster_l_wheel_link'>\n      <self_collide>0</self_collide>\n      <pose>-0.224600 -0.175600 0.079200 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.440360</mass>\n        <inertia>\n          <ixx>0.012412</ixx>\n          <ixy>-0.000712</ixy>\n          <ixz>0.000503</ixz>\n          <iyy>0.015218</iyy>\n          <iyz>-0.000004</iyz>\n          <izz>0.011764</izz>\n        </inertia>\n      </inertial>\n      <collision name='br_caster_l_wheel_link_geom'>\n        <pose>0.000000 0.000000 0.000000 1.570800 0.000000 0.000000</pose>\n        <geometry>\n          <cylinder>\n            <radius>0.074792</radius>\n            <length>0.034000</length>\n          </cylinder>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='br_caster_l_wheel_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/base_v0/wheel.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n      <gravity>1</gravity>\n    </link>\n    <link name='br_caster_r_wheel_link'>\n      <self_collide>0</self_collide>\n      <pose>-0.224600 -0.273600 0.079200 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.440360</mass>\n        <inertia>\n          <ixx>0.012412</ixx>\n          <ixy>-0.000712</ixy>\n          <ixz>0.000503</ixz>\n          <iyy>0.015218</iyy>\n          <iyz>-0.000004</iyz>\n          <izz>0.011764</izz>\n        </inertia>\n      </inertial>\n      <collision name='br_caster_r_wheel_link_geom'>\n        <pose>0.000000 0.000000 0.000000 1.570800 0.000000 0.000000</pose>\n        <geometry>\n          <cylinder>\n            <radius>0.074792</radius>\n            <length>0.034000</length>\n          </cylinder>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='br_caster_r_wheel_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/base_v0/wheel.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n      <gravity>1</gravity>\n    </link>\n    <link name='fl_caster_rotation_link'>\n      <self_collide>0</self_collide>\n      <pose>0.224600 0.224600 0.079200 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>3.473080</mass>\n        <pose>0.000000 0.000000 0.070000 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.012412</ixx>\n          <ixy>-0.000712</ixy>\n          <ixz>0.000503</ixz>\n          <iyy>0.015218</iyy>\n          <iyz>-0.000004</iyz>\n          <izz>0.011764</izz>\n        </inertia>\n      </inertial>\n      <collision name='fl_caster_rotation_link_geom'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/base_v0/caster_L.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='fl_caster_rotation_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/base_v0/caster.stl</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n      <gravity>1</gravity>\n    </link>\n    <link name='fl_caster_l_wheel_link'>\n      <self_collide>0</self_collide>\n      <pose>0.224600 0.273600 0.079200 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.440360</mass>\n        <inertia>\n          <ixx>0.012412</ixx>\n          <ixy>-0.000712</ixy>\n          <ixz>0.000503</ixz>\n          <iyy>0.015218</iyy>\n          <iyz>-0.000004</iyz>\n          <izz>0.011764</izz>\n        </inertia>\n      </inertial>\n      <collision name='fl_caster_l_wheel_link_geom'>\n        <pose>0.000000 0.000000 0.000000 1.570800 0.000000 0.000000</pose>\n        <geometry>\n          <cylinder>\n            <radius>0.074792</radius>\n            <length>0.034000</length>\n          </cylinder>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='fl_caster_l_wheel_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/base_v0/wheel.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n      <gravity>1</gravity>\n    </link>\n    <link name='fl_caster_r_wheel_link'>\n      <self_collide>0</self_collide>\n      <pose>0.224600 0.175600 0.079200 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.440360</mass>\n        <inertia>\n          <ixx>0.012412</ixx>\n          <ixy>-0.000712</ixy>\n          <ixz>0.000503</ixz>\n          <iyy>0.015218</iyy>\n          <iyz>-0.000004</iyz>\n          <izz>0.011764</izz>\n        </inertia>\n      </inertial>\n      <collision name='fl_caster_r_wheel_link_geom'>\n        <pose>0.000000 0.000000 0.000000 1.570800 0.000000 0.000000</pose>\n        <geometry>\n          <cylinder>\n            <radius>0.074792</radius>\n            <length>0.034000</length>\n          </cylinder>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='fl_caster_r_wheel_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/base_v0/wheel.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n      <gravity>1</gravity>\n    </link>\n    <link name='fr_caster_rotation_link'>\n      <self_collide>0</self_collide>\n      <pose>0.224600 -0.224600 0.079200 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>3.473080</mass>\n        <pose>0.000000 0.000000 0.070000 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.012412</ixx>\n          <ixy>-0.000712</ixy>\n          <ixz>0.000503</ixz>\n          <iyy>0.015218</iyy>\n          <iyz>-0.000004</iyz>\n          <izz>0.011764</izz>\n        </inertia>\n      </inertial>\n      <collision name='fr_caster_rotation_link_geom'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/base_v0/caster_L.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='fr_caster_rotation_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/base_v0/caster.stl</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n      <gravity>1</gravity>\n    </link>\n    <link name='fr_caster_l_wheel_link'>\n      <self_collide>0</self_collide>\n      <pose>0.224600 -0.175600 0.079200 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.440360</mass>\n        <inertia>\n          <ixx>0.012412</ixx>\n          <ixy>-0.000712</ixy>\n          <ixz>0.000503</ixz>\n          <iyy>0.015218</iyy>\n          <iyz>-0.000004</iyz>\n          <izz>0.011764</izz>\n        </inertia>\n      </inertial>\n      <collision name='fr_caster_l_wheel_link_geom'>\n        <pose>0.000000 0.000000 0.000000 1.570800 0.000000 0.000000</pose>\n        <geometry>\n          <cylinder>\n            <radius>0.074792</radius>\n            <length>0.034000</length>\n          </cylinder>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='fr_caster_l_wheel_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/base_v0/wheel.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n      <gravity>1</gravity>\n    </link>\n    <link name='fr_caster_r_wheel_link'>\n      <self_collide>0</self_collide>\n      <pose>0.224600 -0.273600 0.079200 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.440360</mass>\n        <inertia>\n          <ixx>0.012412</ixx>\n          <ixy>-0.000712</ixy>\n          <ixz>0.000503</ixz>\n          <iyy>0.015218</iyy>\n          <iyz>-0.000004</iyz>\n          <izz>0.011764</izz>\n        </inertia>\n      </inertial>\n      <collision name='fr_caster_r_wheel_link_geom'>\n        <pose>0.000000 0.000000 0.000000 1.570800 0.000000 0.000000</pose>\n        <geometry>\n          <cylinder>\n            <radius>0.074792</radius>\n            <length>0.034000</length>\n          </cylinder>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='fr_caster_r_wheel_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/base_v0/wheel.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n      <gravity>1</gravity>\n    </link>\n    <link name='torso_lift_link'>\n      <self_collide>0</self_collide>\n      <pose>-0.050000 0.000000 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>36.449000</mass>\n        <pose>-0.099499 -0.000004 -0.086764 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>2.792330</ixx>\n          <ixy>0.004280</ixy>\n          <ixz>-0.160631</ixz>\n          <iyy>2.521060</iyy>\n          <iyz>0.029689</iyz>\n          <izz>0.536551</izz>\n        </inertia>\n      </inertial>\n      <collision name='torso_lift_link_geom'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/torso_v0/torso_lift_L.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='torso_lift_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/torso_v0/torso_lift.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <sensor name='torso_lift_contact_sensor' type='contact'>\n        <update_rate>100.000000</update_rate>\n        <always_on>0</always_on>\n        <visualize>0</visualize>\n        <contact>\n          <collision>torso_lift_link_geom</collision>\n          <topic>__default_topic__</topic>\n        </contact>\n      </sensor>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n      <gravity>1</gravity>\n    </link>\n    <link name='head_pan_link'>\n      <self_collide>0</self_collide>\n      <pose>-0.067070 0.000000 1.172130 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>6.339000</mass>\n        <pose>0.010907 0.031693 0.090507 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.032498</ixx>\n          <ixy>0.000636</ixy>\n          <ixz>0.002585</ixz>\n          <iyy>0.046546</iyy>\n          <iyz>-0.002453</iyz>\n          <izz>0.057653</izz>\n        </inertia>\n      </inertial>\n      <collision name='head_pan_link_geom'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/head_v0/head_pan_L.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='head_pan_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/head_v0/head_pan.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n      <gravity>1</gravity>\n    </link>\n    <link name='head_tilt_link'>\n      <projector name='projector_wg6802418_projector_wg6802418'>\n        <texture>stereo_projection_pattern_high_res_red.png</texture>\n        <fov>0.959931</fov>\n        <near_clip>0.100000</near_clip>\n        <far_clip>10.000000</far_clip>\n        <pose>0.023200 0.110000 0.119100 0.000000 -1.570793 0.000000</pose>\n      </projector>\n      <self_collide>0</self_collide>\n      <pose>0.000930 0.000000 1.172130 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>5.319000</mass>\n        <pose>-0.005151 -0.014635 0.072819 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.126134</ixx>\n          <ixy>0.000237</ixy>\n          <ixz>0.011881</ixz>\n          <iyy>0.165102</iyy>\n          <iyz>0.001606</iyz>\n          <izz>0.166947</izz>\n        </inertia>\n      </inertial>\n      <collision name='head_tilt_link_geom'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/head_v0/head_tilt_L.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='head_tilt_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/head_v0/head_tilt.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <collision name='head_tilt_link_geom_head_mount_kinect_ir_link'>\n        <pose>-0.147067 0.012500 0.291953 0.000000 0.000000 0.000000</pose>\n        <geometry>\n          <sphere>\n            <radius>0.000500</radius>\n          </sphere>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='head_tilt_link_geom_head_mount_kinect_ir_link_visual'>\n        <pose>-0.147067 0.012500 0.291953 0.000000 0.000000 0.000000</pose>\n        <geometry>\n          <sphere>\n            <radius>0.000250</radius>\n          </sphere>\n        </geometry>\n        <material>\n          <script>\n            <uri>__default__</uri>\n            <name>__default__</name>\n          </script>\n        </material>\n      </visual>\n      <collision name='head_tilt_link_geom_head_mount_kinect_rgb_link'>\n        <pose>-0.147067 0.017500 0.291953 0.000000 0.000000 0.000000</pose>\n        <geometry>\n          <sphere>\n            <radius>0.000500</radius>\n          </sphere>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='head_tilt_link_geom_head_mount_kinect_rgb_link_visual'>\n        <pose>-0.147067 0.017500 0.291953 0.000000 0.000000 0.000000</pose>\n        <geometry>\n          <sphere>\n            <radius>0.000250</radius>\n          </sphere>\n        </geometry>\n        <material>\n          <script>\n            <uri>__default__</uri>\n            <name>__default__</name>\n          </script>\n        </material>\n      </visual>\n      <collision name='head_tilt_link_geom_head_mount_link'>\n        <pose>-0.114800 0.000000 0.155500 0.000000 0.000000 0.000000</pose>\n        <geometry>\n          <sphere>\n            <radius>0.000500</radius>\n          </sphere>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='head_tilt_link_geom_head_mount_link_visual'>\n        <pose>-0.114800 0.000000 0.155500 0.000000 0.000000 0.000000</pose>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/sensors/kinect_prosilica_v0/115x100_swept_back--coarse.STL</uri>\n            <scale>0.001000 0.001000 0.001000</scale>\n          </mesh>\n        </geometry>\n      </visual>\n      <collision name='head_tilt_link_geom_head_mount_prosilica_link'>\n        <pose>-0.161257 0.012500 0.244421 0.000000 0.000000 0.000000</pose>\n        <geometry>\n          <sphere>\n            <radius>0.000500</radius>\n          </sphere>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='head_tilt_link_geom_head_mount_prosilica_link_visual'>\n        <pose>-0.161257 0.012500 0.244421 0.000000 0.000000 0.000000</pose>\n        <geometry>\n          <sphere>\n            <radius>0.000250</radius>\n          </sphere>\n        </geometry>\n        <material>\n          <script>\n            <uri>__default__</uri>\n            <name>__default__</name>\n          </script>\n        </material>\n      </visual>\n      <collision name='head_tilt_link_geom_head_plate_frame'>\n        <pose>0.023200 0.000000 0.064500 0.000000 0.000000 0.000000</pose>\n        <geometry>\n          <box>\n            <size>0.010000 0.010000 0.010000</size>\n          </box>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='head_tilt_link_geom_head_plate_frame_visual'>\n        <pose>0.023200 0.000000 0.064500 0.000000 0.000000 0.000000</pose>\n        <geometry>\n          <box>\n            <size>0.010000 0.010000 0.010000</size>\n          </box>\n        </geometry>\n        <material>\n          <script>\n            <uri>__default__</uri>\n            <name>__default__</name>\n          </script>\n        </material>\n      </visual>\n      <sensor name='head_mount_sensor' type='camera'>\n        <always_on>0</always_on>\n        <visualize>0</visualize>\n        <update_rate>1.000000</update_rate>\n        <pose>-0.147067 0.012500 0.291953 0.000000 0.000000 0.000000</pose>\n        <camera name='__default__'>\n          <horizontal_fov>0.994838</horizontal_fov>\n          <image>\n            <width>640</width>\n            <height>480</height>\n            <format>L8</format>\n          </image>\n          <clip>\n            <near>0.010000</near>\n            <far>5.000000</far>\n          </clip>\n        </camera>\n      </sensor>\n      <sensor name='head_mount_prosilica_link_sensor' type='camera'>\n        <update_rate>1.000000</update_rate>\n        <pose>-0.161257 0.012500 0.244421 0.000000 0.000000 0.000000</pose>\n        <always_on>0</always_on>\n        <visualize>0</visualize>\n        <camera name='__default__'>\n          <horizontal_fov>1.120501</horizontal_fov>\n          <image>\n            <width>320</width>\n            <height>240</height>\n            <format>R8G8B8</format>\n          </image>\n          <clip>\n            <near>0.100000</near>\n            <far>100.000000</far>\n          </clip>\n        </camera>\n      </sensor>\n      <sensor name='head_mount_prosilica_link_sim_pcd_sensor' type='camera'>\n        <update_rate>1.000000</update_rate>\n        <pose>-0.161257 0.012500 0.244421 0.000000 0.000000 0.000000</pose>\n        <always_on>0</always_on>\n        <visualize>0</visualize>\n        <camera name='__default__'>\n          <horizontal_fov>1.120501</horizontal_fov>\n          <image>\n            <width>320</width>\n            <height>240</height>\n            <format>R8G8B8</format>\n          </image>\n          <clip>\n            <near>0.100000</near>\n            <far>100.000000</far>\n          </clip>\n        </camera>\n      </sensor>\n      <sensor name='narrow_stereo_gazebo_l_stereo_camera_sensor' type='camera'>\n        <always_on>0</always_on>\n        <visualize>0</visualize>\n        <update_rate>25.000000</update_rate>\n        <pose>0.068200 0.060000 0.114600 0.000000 0.000000 0.000000</pose>\n        <camera name='__default__'>\n          <horizontal_fov>0.785398</horizontal_fov>\n          <image>\n            <width>640</width>\n            <height>480</height>\n            <format>L8</format>\n          </image>\n          <clip>\n            <near>0.100000</near>\n            <far>100.000000</far>\n          </clip>\n        </camera>\n      </sensor>\n      <sensor name='narrow_stereo_gazebo_r_stereo_camera_sensor' type='camera'>\n        <always_on>0</always_on>\n        <visualize>0</visualize>\n        <update_rate>25.000000</update_rate>\n        <pose>0.068200 -0.030000 0.114600 0.000000 0.000000 0.000000</pose>\n        <camera name='__default__'>\n          <horizontal_fov>0.785398</horizontal_fov>\n          <image>\n            <width>640</width>\n            <height>480</height>\n            <format>L8</format>\n          </image>\n          <clip>\n            <near>0.100000</near>\n            <far>100.000000</far>\n          </clip>\n        </camera>\n      </sensor>\n      <sensor name='wide_stereo_gazebo_l_stereo_camera_sensor' type='camera'>\n        <update_rate>25.000000</update_rate>\n        <pose>0.068200 0.030000 0.114600 0.000000 0.000000 0.000000</pose>\n        <always_on>0</always_on>\n        <visualize>0</visualize>\n        <camera name='__default__'>\n          <horizontal_fov>1.570796</horizontal_fov>\n          <image>\n            <width>640</width>\n            <height>480</height>\n            <format>BAYER_BGGR8</format>\n          </image>\n          <clip>\n            <near>0.100000</near>\n            <far>100.000000</far>\n          </clip>\n        </camera>\n      </sensor>\n      <sensor name='wide_stereo_gazebo_r_stereo_camera_sensor' type='camera'>\n        <update_rate>25.000000</update_rate>\n        <pose>0.068200 -0.060000 0.114600 0.000000 0.000000 0.000000</pose>\n        <always_on>0</always_on>\n        <visualize>0</visualize>\n        <camera name='__default__'>\n          <horizontal_fov>1.570796</horizontal_fov>\n          <image>\n            <width>640</width>\n            <height>480</height>\n            <format>BAYER_BGGR8</format>\n          </image>\n          <clip>\n            <near>0.100000</near>\n            <far>100.000000</far>\n          </clip>\n        </camera>\n      </sensor>\n      <sensor name='high_def_sensor' type='camera'>\n        <update_rate>20.000000</update_rate>\n        <pose>0.069657 -0.110000 0.119100 0.000000 0.000000 0.000000</pose>\n        <always_on>0</always_on>\n        <visualize>0</visualize>\n        <camera name='__default__'>\n          <horizontal_fov>0.785398</horizontal_fov>\n          <image>\n            <width>2448</width>\n            <height>2050</height>\n            <format>R8G8B8</format>\n          </image>\n          <clip>\n            <near>0.100000</near>\n            <far>100.000000</far>\n          </clip>\n        </camera>\n      </sensor>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n      <gravity>1</gravity>\n    </link>\n    <link name='l_shoulder_pan_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>-0.050000 0.188000 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>25.799300</mass>\n        <pose>-0.001201 0.024513 -0.098231 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.866179</ixx>\n          <ixy>-0.060865</ixy>\n          <ixz>-0.121181</ixz>\n          <iyy>0.874217</iyy>\n          <iyz>-0.058866</iyz>\n          <izz>0.273538</izz>\n        </inertia>\n      </inertial>\n      <collision name='l_shoulder_pan_link_geom'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/shoulder_v0/shoulder_pan.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='l_shoulder_pan_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/shoulder_v0/shoulder_pan.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='l_shoulder_lift_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.050000 0.188000 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>2.749880</mass>\n        <pose>0.021950 -0.026640 -0.031270 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.021056</ixx>\n          <ixy>0.004967</ixy>\n          <ixz>-0.001948</ixz>\n          <iyy>0.021272</iyy>\n          <iyz>0.001104</iyz>\n          <izz>0.019758</izz>\n        </inertia>\n      </inertial>\n      <collision name='l_shoulder_lift_link_geom'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/shoulder_v0/shoulder_lift.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='l_shoulder_lift_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/shoulder_v0/shoulder_lift.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='l_upper_arm_roll_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.050000 0.188000 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>6.117690</mass>\n        <pose>0.210551 0.016309 -0.000561 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.025306</ixx>\n          <ixy>-0.003393</ixy>\n          <ixz>0.000608</ixz>\n          <iyy>0.084737</iyy>\n          <iyz>-0.000200</iyz>\n          <izz>0.086016</izz>\n        </inertia>\n      </inertial>\n      <collision name='l_upper_arm_roll_link_geom'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/shoulder_v0/upper_arm_roll_L.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='l_upper_arm_roll_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/shoulder_v0/upper_arm_roll.stl</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <collision name='l_upper_arm_roll_link_geom_l_upper_arm_link'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/upper_arm_v0/upper_arm.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='l_upper_arm_roll_link_geom_l_upper_arm_link_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/upper_arm_v0/upper_arm.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='l_elbow_flex_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.450000 0.188000 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>1.903270</mass>\n        <pose>0.010140 0.000320 -0.012110 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.003465</ixx>\n          <ixy>0.000041</ixy>\n          <ixz>0.000432</ixz>\n          <iyy>0.004416</iyy>\n          <iyz>-0.000040</iyz>\n          <izz>0.003592</izz>\n        </inertia>\n      </inertial>\n      <collision name='l_elbow_flex_link_geom'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/upper_arm_v0/elbow_flex.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='l_elbow_flex_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/upper_arm_v0/elbow_flex.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='l_forearm_roll_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.450000 0.188000 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>2.689680</mass>\n        <pose>0.180727 -0.000163 -0.008583 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.014668</ixx>\n          <ixy>0.000052</ixy>\n          <ixz>0.000656</ixz>\n          <iyy>0.026279</iyy>\n          <iyz>-0.000013</iyz>\n          <izz>0.027775</izz>\n        </inertia>\n      </inertial>\n      <collision name='l_forearm_roll_link_geom'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/upper_arm_v0/forearm_roll_L.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='l_forearm_roll_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/upper_arm_v0/forearm_roll.stl</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <collision name='l_forearm_roll_link_geom_l_forearm_link'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/forearm_v0/forearm.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='l_forearm_roll_link_geom_l_forearm_link_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/forearm_v0/forearm.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <sensor name='l_forearm_cam_sensor' type='camera'>\n        <update_rate>25.000000</update_rate>\n        <pose>0.135000 0.000000 0.044000 -1.570800 -0.562869 0.000000</pose>\n        <always_on>0</always_on>\n        <visualize>0</visualize>\n        <camera name='__default__'>\n          <horizontal_fov>1.570796</horizontal_fov>\n          <image>\n            <width>640</width>\n            <height>480</height>\n            <format>R8G8B8</format>\n          </image>\n          <clip>\n            <near>0.100000</near>\n            <far>100.000000</far>\n          </clip>\n        </camera>\n      </sensor>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='l_wrist_flex_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.771000 0.188000 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.614020</mass>\n        <pose>-0.001570 0.000000 -0.000750 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.000652</ixx>\n          <ixy>0.000000</ixy>\n          <ixz>0.000003</ixz>\n          <iyy>0.000198</iyy>\n          <iyz>0.000000</iyz>\n          <izz>0.000645</izz>\n        </inertia>\n      </inertial>\n      <collision name='l_wrist_flex_link_geom'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/forearm_v0/wrist_flex.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='l_wrist_flex_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/forearm_v0/wrist_flex.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='l_wrist_roll_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.771000 0.188000 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.681070</mass>\n        <pose>0.056408 0.000451 -0.001014 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.011352</ixx>\n          <ixy>-0.000016</ixy>\n          <ixz>-0.000001</ixz>\n          <iyy>0.011677</iyy>\n          <iyz>-0.000001</iyz>\n          <izz>0.011866</izz>\n        </inertia>\n      </inertial>\n      <collision name='l_wrist_roll_link_geom'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/forearm_v0/wrist_roll_L.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='l_wrist_roll_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/forearm_v0/wrist_roll.stl</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <collision name='l_wrist_roll_link_geom_l_gripper_motor_accelerometer_link'>\n        <geometry>\n          <box>\n            <size>0.001000 0.001000 0.001000</size>\n          </box>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='l_wrist_roll_link_geom_l_gripper_motor_accelerometer_link_visual'>\n        <geometry>\n          <box>\n            <size>0.001000 0.001000 0.001000</size>\n          </box>\n        </geometry>\n      </visual>\n      <collision name='l_wrist_roll_link_geom_l_gripper_palm_link'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/gripper_v0/gripper_palm.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='l_wrist_roll_link_geom_l_gripper_palm_link_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/gripper_v0/gripper_palm.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='l_gripper_l_finger_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.847910 0.198000 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.171260</mass>\n        <pose>0.035980 0.017300 -0.001640 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.000078</ixx>\n          <ixy>0.000001</ixy>\n          <ixz>-0.000010</ixz>\n          <iyy>0.000197</iyy>\n          <iyz>-0.000003</iyz>\n          <izz>0.000181</izz>\n        </inertia>\n      </inertial>\n      <collision name='l_gripper_l_finger_link_geom'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/gripper_v0/l_finger.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <friction>\n            <ode>\n              <mu>500.000000</mu>\n              <mu2>500.000000</mu2>\n              <slip1>0.000000</slip1>\n              <slip2>0.000000</slip2>\n            </ode>\n          </friction>\n          <contact>\n            <ode>\n              <kp>1000000.000000</kp>\n              <kd>1.000000</kd>\n              <max_vel>100.000000</max_vel>\n              <min_depth>0.000000</min_depth>\n            </ode>\n          </contact>\n          <bounce/>\n        </surface>\n      </collision>\n      <visual name='l_gripper_l_finger_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/gripper_v0/l_finger.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='l_gripper_l_finger_tip_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.939280 0.202950 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.044190</mass>\n        <pose>0.004230 0.002840 0.000000 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.000008</ixx>\n          <ixy>0.000006</ixy>\n          <ixz>0.000000</ixz>\n          <iyy>0.000010</iyy>\n          <iyz>0.000000</iyz>\n          <izz>0.000015</izz>\n        </inertia>\n      </inertial>\n      <collision name='l_gripper_l_finger_tip_link_geom'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/gripper_v0/l_finger_tip.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <friction>\n            <ode>\n              <mu>500.000000</mu>\n              <mu2>500.000000</mu2>\n              <slip1>0.000000</slip1>\n              <slip2>0.000000</slip2>\n            </ode>\n          </friction>\n          <contact>\n            <ode>\n              <kp>10000000.000000</kp>\n              <kd>1.000000</kd>\n              <max_vel>100.000000</max_vel>\n              <min_depth>0.000000</min_depth>\n            </ode>\n          </contact>\n          <bounce/>\n        </surface>\n      </collision>\n      <visual name='l_gripper_l_finger_tip_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/gripper_v0/l_finger_tip.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <sensor name='l_gripper_l_finger_tip_contact_sensor' type='contact'>\n        <update_rate>100.000000</update_rate>\n        <always_on>0</always_on>\n        <visualize>0</visualize>\n        <contact>\n          <collision>l_gripper_l_finger_tip_link_geom</collision>\n          <topic>__default_topic__</topic>\n        </contact>\n      </sensor>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='l_gripper_motor_slider_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.939280 0.188000 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.010000</mass>\n        <inertia>\n          <ixx>0.001000</ixx>\n          <ixy>0.000000</ixy>\n          <ixz>0.000000</ixz>\n          <iyy>0.001000</iyy>\n          <iyz>0.000000</iyz>\n          <izz>0.001000</izz>\n        </inertia>\n      </inertial>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='l_gripper_motor_screw_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.939280 0.188000 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.010000</mass>\n        <inertia>\n          <ixx>0.000100</ixx>\n          <ixy>0.000000</ixy>\n          <ixz>0.000000</ixz>\n          <iyy>0.000100</iyy>\n          <iyz>0.000000</iyz>\n          <izz>0.000100</izz>\n        </inertia>\n      </inertial>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='l_gripper_r_finger_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.847910 0.178000 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.173890</mass>\n        <pose>0.035760 -0.017360 -0.000950 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.000077</ixx>\n          <ixy>-0.000002</ixy>\n          <ixz>-0.000008</ixz>\n          <iyy>0.000198</iyy>\n          <iyz>0.000002</iyz>\n          <izz>0.000181</izz>\n        </inertia>\n      </inertial>\n      <collision name='l_gripper_r_finger_link_geom'>\n        <pose>0.000000 0.000000 0.000000 -3.141590 0.000000 0.000000</pose>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/gripper_v0/l_finger.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <friction>\n            <ode>\n              <mu>500.000000</mu>\n              <mu2>500.000000</mu2>\n              <slip1>0.000000</slip1>\n              <slip2>0.000000</slip2>\n            </ode>\n          </friction>\n          <contact>\n            <ode>\n              <kp>1000000.000000</kp>\n              <kd>1.000000</kd>\n              <max_vel>100.000000</max_vel>\n              <min_depth>0.000000</min_depth>\n            </ode>\n          </contact>\n          <bounce/>\n        </surface>\n      </collision>\n      <visual name='l_gripper_r_finger_link_geom_visual'>\n        <pose>0.000000 0.000000 0.000000 -3.141590 0.000000 0.000000</pose>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/gripper_v0/l_finger.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='l_gripper_r_finger_tip_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.939280 0.173050 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.044190</mass>\n        <pose>0.004230 -0.002840 0.000000 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.000008</ixx>\n          <ixy>-0.000006</ixy>\n          <ixz>0.000000</ixz>\n          <iyy>0.000010</iyy>\n          <iyz>0.000000</iyz>\n          <izz>0.000015</izz>\n        </inertia>\n      </inertial>\n      <collision name='l_gripper_r_finger_tip_link_geom'>\n        <pose>0.000000 0.000000 0.000000 -3.141590 0.000000 0.000000</pose>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/gripper_v0/l_finger_tip.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <friction>\n            <ode>\n              <mu>500.000000</mu>\n              <mu2>500.000000</mu2>\n              <slip1>0.000000</slip1>\n              <slip2>0.000000</slip2>\n            </ode>\n          </friction>\n          <contact>\n            <ode>\n              <kp>10000000.000000</kp>\n              <kd>1.000000</kd>\n              <max_vel>100.000000</max_vel>\n              <min_depth>0.000000</min_depth>\n            </ode>\n          </contact>\n          <bounce/>\n        </surface>\n      </collision>\n      <visual name='l_gripper_r_finger_tip_link_geom_visual'>\n        <pose>0.000000 0.000000 0.000000 -3.141590 0.000000 0.000000</pose>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/gripper_v0/l_finger_tip.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <sensor name='l_gripper_r_finger_tip_contact_sensor' type='contact'>\n        <update_rate>100.000000</update_rate>\n        <always_on>0</always_on>\n        <visualize>0</visualize>\n        <contact>\n          <collision>l_gripper_r_finger_tip_link_geom</collision>\n          <topic>__default_topic__</topic>\n        </contact>\n      </sensor>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='laser_tilt_mount_link'>\n      <self_collide>0</self_collide>\n      <pose>0.048930 0.000000 1.017680 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.592000</mass>\n        <pose>-0.001134 0.001667 -0.007067 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.001296</ixx>\n          <ixy>0.000023</ixy>\n          <ixz>0.000037</ixz>\n          <iyy>0.001086</iyy>\n          <iyz>0.000035</iyz>\n          <izz>0.000895</izz>\n        </inertia>\n      </inertial>\n      <collision name='laser_tilt_mount_link_geom'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/tilting_laser_v0/tilting_hokuyo_L.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <friction>\n            <ode>\n              <mu>0.000000</mu>\n              <mu2>0.000000</mu2>\n              <slip1>0.000000</slip1>\n              <slip2>0.000000</slip2>\n            </ode>\n          </friction>\n          <contact>\n            <ode>\n              <kp>1000000000000.000000</kp>\n              <kd>10000.000000</kd>\n              <max_vel>100.000000</max_vel>\n              <min_depth>0.000000</min_depth>\n            </ode>\n          </contact>\n          <bounce/>\n        </surface>\n      </collision>\n      <visual name='laser_tilt_mount_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/tilting_laser_v0/tilting_hokuyo.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <sensor name='laser_tilt' type='ray'>\n        <update_rate>40.000000</update_rate>\n        <pose>0.000000 0.000000 0.030000 0.000000 0.000000 0.000000</pose>\n        <always_on>0</always_on>\n        <visualize>0</visualize>\n        <ray>\n          <scan>\n            <horizontal>\n              <samples>640</samples>\n              <resolution>1.000000</resolution>\n              <min_angle>-1.396263</min_angle>\n              <max_angle>1.396263</max_angle>\n            </horizontal>\n          </scan>\n          <range>\n            <min>0.080000</min>\n            <max>10.000000</max>\n            <resolution>0.010000</resolution>\n          </range>\n        </ray>\n      </sensor>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n      <gravity>1</gravity>\n    </link>\n    <link name='r_shoulder_pan_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>-0.050000 -0.188000 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>25.799300</mass>\n        <pose>-0.001201 0.024513 -0.098231 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.866179</ixx>\n          <ixy>-0.060865</ixy>\n          <ixz>-0.121181</ixz>\n          <iyy>0.874217</iyy>\n          <iyz>-0.058866</iyz>\n          <izz>0.273538</izz>\n        </inertia>\n      </inertial>\n      <collision name='r_shoulder_pan_link_geom'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/shoulder_v0/shoulder_pan.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <friction>\n            <ode>\n              <mu>0.000000</mu>\n              <mu2>0.000000</mu2>\n              <slip1>0.000000</slip1>\n              <slip2>0.000000</slip2>\n            </ode>\n          </friction>\n          <contact>\n            <ode>\n              <kp>1000000000000.000000</kp>\n              <kd>10000.000000</kd>\n              <max_vel>100.000000</max_vel>\n              <min_depth>0.000000</min_depth>\n            </ode>\n          </contact>\n          <bounce/>\n        </surface>\n      </collision>\n      <visual name='r_shoulder_pan_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/shoulder_v0/shoulder_pan.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='r_shoulder_lift_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.050000 -0.188000 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>2.749880</mass>\n        <pose>0.021950 -0.026640 -0.031270 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.021056</ixx>\n          <ixy>0.004967</ixy>\n          <ixz>-0.001948</ixz>\n          <iyy>0.021272</iyy>\n          <iyz>0.001104</iyz>\n          <izz>0.019758</izz>\n        </inertia>\n      </inertial>\n      <collision name='r_shoulder_lift_link_geom'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/shoulder_v0/shoulder_lift.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <friction>\n            <ode>\n              <mu>0.000000</mu>\n              <mu2>0.000000</mu2>\n              <slip1>0.000000</slip1>\n              <slip2>0.000000</slip2>\n            </ode>\n          </friction>\n          <contact>\n            <ode>\n              <kp>1000000000000.000000</kp>\n              <kd>10000.000000</kd>\n              <max_vel>100.000000</max_vel>\n              <min_depth>0.000000</min_depth>\n            </ode>\n          </contact>\n          <bounce/>\n        </surface>\n      </collision>\n      <visual name='r_shoulder_lift_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/shoulder_v0/shoulder_lift.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='r_upper_arm_roll_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.050000 -0.188000 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>6.117690</mass>\n        <pose>0.210482 -0.015945 -0.000197 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.025378</ixx>\n          <ixy>0.003757</ixy>\n          <ixz>-0.000709</ixz>\n          <iyy>0.084737</iyy>\n          <iyz>-0.000179</iyz>\n          <izz>0.086088</izz>\n        </inertia>\n      </inertial>\n      <collision name='r_upper_arm_roll_link_geom'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/shoulder_v0/upper_arm_roll_L.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='r_upper_arm_roll_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/shoulder_v0/upper_arm_roll.stl</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <collision name='r_upper_arm_roll_link_geom_r_upper_arm_link'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/upper_arm_v0/upper_arm.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='r_upper_arm_roll_link_geom_r_upper_arm_link_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/upper_arm_v0/upper_arm.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='r_elbow_flex_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.450000 -0.188000 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>1.903270</mass>\n        <pose>0.010140 0.000320 -0.012110 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.003465</ixx>\n          <ixy>0.000041</ixy>\n          <ixz>0.000432</ixz>\n          <iyy>0.004416</iyy>\n          <iyz>-0.000040</iyz>\n          <izz>0.003592</izz>\n        </inertia>\n      </inertial>\n      <collision name='r_elbow_flex_link_geom'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/upper_arm_v0/elbow_flex.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='r_elbow_flex_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/upper_arm_v0/elbow_flex.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='r_forearm_roll_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.450000 -0.188000 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>2.689680</mass>\n        <pose>0.180727 -0.000163 -0.008583 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.014668</ixx>\n          <ixy>0.000052</ixy>\n          <ixz>0.000656</ixz>\n          <iyy>0.026279</iyy>\n          <iyz>-0.000013</iyz>\n          <izz>0.027775</izz>\n        </inertia>\n      </inertial>\n      <collision name='r_forearm_roll_link_geom'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/upper_arm_v0/forearm_roll_L.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='r_forearm_roll_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/upper_arm_v0/forearm_roll.stl</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <collision name='r_forearm_roll_link_geom_r_forearm_link'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/forearm_v0/forearm.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='r_forearm_roll_link_geom_r_forearm_link_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/forearm_v0/forearm.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <sensor name='r_forearm_cam_sensor' type='camera'>\n        <update_rate>25.000000</update_rate>\n        <pose>0.135000 0.000000 0.044000 1.570800 -0.562869 -0.000000</pose>\n        <always_on>0</always_on>\n        <visualize>0</visualize>\n        <camera name='__default__'>\n          <horizontal_fov>1.570796</horizontal_fov>\n          <image>\n            <width>640</width>\n            <height>480</height>\n            <format>R8G8B8</format>\n          </image>\n          <clip>\n            <near>0.100000</near>\n            <far>100.000000</far>\n          </clip>\n        </camera>\n      </sensor>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='r_wrist_flex_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.771000 -0.188000 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.614020</mass>\n        <pose>-0.001570 0.000000 -0.000750 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.000652</ixx>\n          <ixy>0.000000</ixy>\n          <ixz>0.000003</ixz>\n          <iyy>0.000198</iyy>\n          <iyz>0.000000</iyz>\n          <izz>0.000645</izz>\n        </inertia>\n      </inertial>\n      <collision name='r_wrist_flex_link_geom'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/forearm_v0/wrist_flex.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='r_wrist_flex_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/forearm_v0/wrist_flex.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='r_wrist_roll_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.771000 -0.188000 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.681070</mass>\n        <pose>0.056408 0.000451 -0.001014 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.011352</ixx>\n          <ixy>-0.000016</ixy>\n          <ixz>-0.000001</ixz>\n          <iyy>0.011677</iyy>\n          <iyz>-0.000001</iyz>\n          <izz>0.011866</izz>\n        </inertia>\n      </inertial>\n      <collision name='r_wrist_roll_link_geom'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/forearm_v0/wrist_roll_L.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='r_wrist_roll_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/forearm_v0/wrist_roll.stl</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <collision name='r_wrist_roll_link_geom_r_gripper_motor_accelerometer_link'>\n        <geometry>\n          <box>\n            <size>0.001000 0.001000 0.001000</size>\n          </box>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='r_wrist_roll_link_geom_r_gripper_motor_accelerometer_link_visual'>\n        <geometry>\n          <box>\n            <size>0.001000 0.001000 0.001000</size>\n          </box>\n        </geometry>\n      </visual>\n      <collision name='r_wrist_roll_link_geom_r_gripper_palm_link'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/gripper_v0/gripper_palm.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='r_wrist_roll_link_geom_r_gripper_palm_link_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/gripper_v0/gripper_palm.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='r_gripper_l_finger_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.847910 -0.178000 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.171260</mass>\n        <pose>0.035980 0.017300 -0.001640 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.000078</ixx>\n          <ixy>0.000001</ixy>\n          <ixz>0.000010</ixz>\n          <iyy>0.000197</iyy>\n          <iyz>-0.000003</iyz>\n          <izz>0.000181</izz>\n        </inertia>\n      </inertial>\n      <collision name='r_gripper_l_finger_link_geom'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/gripper_v0/l_finger.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <friction>\n            <ode>\n              <mu>500.000000</mu>\n              <mu2>500.000000</mu2>\n              <slip1>0.000000</slip1>\n              <slip2>0.000000</slip2>\n            </ode>\n          </friction>\n          <contact>\n            <ode>\n              <kp>1000000.000000</kp>\n              <kd>1.000000</kd>\n              <max_vel>100.000000</max_vel>\n              <min_depth>0.000000</min_depth>\n            </ode>\n          </contact>\n          <bounce/>\n        </surface>\n      </collision>\n      <visual name='r_gripper_l_finger_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/gripper_v0/l_finger.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='r_gripper_l_finger_tip_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.939280 -0.173050 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.044190</mass>\n        <pose>0.004230 0.002840 0.000000 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.000008</ixx>\n          <ixy>0.000006</ixy>\n          <ixz>0.000000</ixz>\n          <iyy>0.000010</iyy>\n          <iyz>0.000000</iyz>\n          <izz>0.000015</izz>\n        </inertia>\n      </inertial>\n      <collision name='r_gripper_l_finger_tip_link_geom'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/gripper_v0/l_finger_tip.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <friction>\n            <ode>\n              <mu>500.000000</mu>\n              <mu2>500.000000</mu2>\n              <slip1>0.000000</slip1>\n              <slip2>0.000000</slip2>\n            </ode>\n          </friction>\n          <contact>\n            <ode>\n              <kp>10000000.000000</kp>\n              <kd>1.000000</kd>\n              <max_vel>100.000000</max_vel>\n              <min_depth>0.000000</min_depth>\n            </ode>\n          </contact>\n          <bounce/>\n        </surface>\n      </collision>\n      <visual name='r_gripper_l_finger_tip_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/gripper_v0/l_finger_tip.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <sensor name='r_gripper_l_finger_tip_contact_sensor' type='contact'>\n        <update_rate>100.000000</update_rate>\n        <always_on>0</always_on>\n        <visualize>0</visualize>\n        <contact>\n          <collision>r_gripper_l_finger_tip_link_geom</collision>\n          <topic>__default_topic__</topic>\n        </contact>\n      </sensor>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='r_gripper_motor_slider_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.939280 -0.188000 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.010000</mass>\n        <inertia>\n          <ixx>0.001000</ixx>\n          <ixy>0.000000</ixy>\n          <ixz>0.000000</ixz>\n          <iyy>0.001000</iyy>\n          <iyz>0.000000</iyz>\n          <izz>0.001000</izz>\n        </inertia>\n      </inertial>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='r_gripper_motor_screw_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.939280 -0.188000 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.010000</mass>\n        <inertia>\n          <ixx>0.000100</ixx>\n          <ixy>0.000000</ixy>\n          <ixz>0.000000</ixz>\n          <iyy>0.000100</iyy>\n          <iyz>0.000000</iyz>\n          <izz>0.000100</izz>\n        </inertia>\n      </inertial>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='r_gripper_r_finger_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.847910 -0.198000 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.173890</mass>\n        <pose>0.035760 -0.017360 -0.000950 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.000077</ixx>\n          <ixy>-0.000002</ixy>\n          <ixz>-0.000008</ixz>\n          <iyy>0.000198</iyy>\n          <iyz>0.000002</iyz>\n          <izz>0.000181</izz>\n        </inertia>\n      </inertial>\n      <collision name='r_gripper_r_finger_link_geom'>\n        <pose>0.000000 0.000000 0.000000 -3.141590 0.000000 0.000000</pose>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/gripper_v0/l_finger.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <friction>\n            <ode>\n              <mu>500.000000</mu>\n              <mu2>500.000000</mu2>\n              <slip1>0.000000</slip1>\n              <slip2>0.000000</slip2>\n            </ode>\n          </friction>\n          <contact>\n            <ode>\n              <kp>1000000.000000</kp>\n              <kd>1.000000</kd>\n              <max_vel>100.000000</max_vel>\n              <min_depth>0.000000</min_depth>\n            </ode>\n          </contact>\n          <bounce/>\n        </surface>\n      </collision>\n      <visual name='r_gripper_r_finger_link_geom_visual'>\n        <pose>0.000000 0.000000 0.000000 -3.141590 0.000000 0.000000</pose>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/gripper_v0/l_finger.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='r_gripper_r_finger_tip_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.939280 -0.202950 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.044190</mass>\n        <pose>0.004230 -0.002840 0.000000 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.000008</ixx>\n          <ixy>-0.000006</ixy>\n          <ixz>0.000000</ixz>\n          <iyy>0.000010</iyy>\n          <iyz>0.000000</iyz>\n          <izz>0.000015</izz>\n        </inertia>\n      </inertial>\n      <collision name='r_gripper_r_finger_tip_link_geom'>\n        <pose>0.000000 0.000000 0.000000 -3.141590 0.000000 0.000000</pose>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/gripper_v0/l_finger_tip.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <friction>\n            <ode>\n              <mu>500.000000</mu>\n              <mu2>500.000000</mu2>\n              <slip1>0.000000</slip1>\n              <slip2>0.000000</slip2>\n            </ode>\n          </friction>\n          <contact>\n            <ode>\n              <kp>10000000.000000</kp>\n              <kd>1.000000</kd>\n              <max_vel>100.000000</max_vel>\n              <min_depth>0.000000</min_depth>\n            </ode>\n          </contact>\n          <bounce/>\n        </surface>\n      </collision>\n      <visual name='r_gripper_r_finger_tip_link_geom_visual'>\n        <pose>0.000000 0.000000 0.000000 -3.141590 0.000000 0.000000</pose>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/gripper_v0/l_finger_tip.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <sensor name='r_gripper_r_finger_tip_contact_sensor' type='contact'>\n        <update_rate>100.000000</update_rate>\n        <always_on>0</always_on>\n        <visualize>0</visualize>\n        <contact>\n          <collision>r_gripper_r_finger_tip_link_geom</collision>\n          <topic>__default_topic__</topic>\n        </contact>\n      </sensor>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='torso_lift_motor_screw_link'>\n      <self_collide>0</self_collide>\n      <pose>-0.150000 0.000000 0.751000 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>1.000000</mass>\n        <inertia>\n          <ixx>0.001000</ixx>\n          <ixy>0.000000</ixy>\n          <ixz>0.000000</ixz>\n          <iyy>0.001000</iyy>\n          <iyz>0.000000</iyz>\n          <izz>0.001000</izz>\n        </inertia>\n      </inertial>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n      <gravity>1</gravity>\n    </link>\n    <link name='r_gripper_l_parallel_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.829910 -0.157000 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.171260</mass>\n        <pose>0.035980 0.017300 -0.001640 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.000078</ixx>\n          <ixy>0.000001</ixy>\n          <ixz>-0.000010</ixz>\n          <iyy>0.000197</iyy>\n          <iyz>-0.000003</iyz>\n          <izz>0.000181</izz>\n        </inertia>\n      </inertial>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='r_gripper_r_parallel_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.829910 -0.219000 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.173890</mass>\n        <pose>0.035760 -0.017360 -0.000950 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.000077</ixx>\n          <ixy>-0.000002</ixy>\n          <ixz>-0.000008</ixz>\n          <iyy>0.000198</iyy>\n          <iyz>0.000002</iyz>\n          <izz>0.000181</izz>\n        </inertia>\n      </inertial>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='l_gripper_l_parallel_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.829910 0.219000 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.171260</mass>\n        <pose>0.035980 0.017300 -0.001640 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.000078</ixx>\n          <ixy>0.000001</ixy>\n          <ixz>0.000010</ixz>\n          <iyy>0.000197</iyy>\n          <iyz>-0.000003</iyz>\n          <izz>0.000181</izz>\n        </inertia>\n      </inertial>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='l_gripper_r_parallel_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.829910 0.157000 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.173890</mass>\n        <pose>0.035760 -0.017360 -0.000950 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.000077</ixx>\n          <ixy>-0.000002</ixy>\n          <ixz>0.000008</ixz>\n          <iyy>0.000198</iyy>\n          <iyz>0.000002</iyz>\n          <izz>0.000181</izz>\n        </inertia>\n      </inertial>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <joint name='bl_caster_rotation_joint' type='revolute'>\n      <parent>base_footprint</parent>\n      <child>bl_caster_rotation_link</child>\n      <axis>\n        <xyz>0.000000 0.000000 1.000000</xyz>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='bl_caster_l_wheel_joint' type='revolute'>\n      <parent>bl_caster_rotation_link</parent>\n      <child>bl_caster_l_wheel_link</child>\n      <axis>\n        <xyz>0.000000 1.000000 0.000000</xyz>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='bl_caster_r_wheel_joint' type='revolute'>\n      <parent>bl_caster_rotation_link</parent>\n      <child>bl_caster_r_wheel_link</child>\n      <axis>\n        <xyz>0.000000 1.000000 0.000000</xyz>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='br_caster_rotation_joint' type='revolute'>\n      <parent>base_footprint</parent>\n      <child>br_caster_rotation_link</child>\n      <axis>\n        <xyz>0.000000 0.000000 1.000000</xyz>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='br_caster_l_wheel_joint' type='revolute'>\n      <parent>br_caster_rotation_link</parent>\n      <child>br_caster_l_wheel_link</child>\n      <axis>\n        <xyz>0.000000 1.000000 0.000000</xyz>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='br_caster_r_wheel_joint' type='revolute'>\n      <parent>br_caster_rotation_link</parent>\n      <child>br_caster_r_wheel_link</child>\n      <axis>\n        <xyz>0.000000 1.000000 0.000000</xyz>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='fl_caster_rotation_joint' type='revolute'>\n      <parent>base_footprint</parent>\n      <child>fl_caster_rotation_link</child>\n      <axis>\n        <xyz>0.000000 0.000000 1.000000</xyz>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='fl_caster_l_wheel_joint' type='revolute'>\n      <parent>fl_caster_rotation_link</parent>\n      <child>fl_caster_l_wheel_link</child>\n      <axis>\n        <xyz>0.000000 1.000000 0.000000</xyz>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='fl_caster_r_wheel_joint' type='revolute'>\n      <parent>fl_caster_rotation_link</parent>\n      <child>fl_caster_r_wheel_link</child>\n      <axis>\n        <xyz>0.000000 1.000000 0.000000</xyz>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='fr_caster_rotation_joint' type='revolute'>\n      <parent>base_footprint</parent>\n      <child>fr_caster_rotation_link</child>\n      <axis>\n        <xyz>0.000000 0.000000 1.000000</xyz>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='fr_caster_l_wheel_joint' type='revolute'>\n      <parent>fr_caster_rotation_link</parent>\n      <child>fr_caster_l_wheel_link</child>\n      <axis>\n        <xyz>0.000000 1.000000 0.000000</xyz>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='fr_caster_r_wheel_joint' type='revolute'>\n      <parent>fr_caster_rotation_link</parent>\n      <child>fr_caster_r_wheel_link</child>\n      <axis>\n        <xyz>0.000000 1.000000 0.000000</xyz>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='torso_lift_joint' type='prismatic'>\n      <parent>base_footprint</parent>\n      <child>torso_lift_link</child>\n      <axis>\n        <xyz>0.000000 0.000000 1.000000</xyz>\n        <limit>\n          <lower>0.000000</lower>\n          <upper>0.330000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='head_pan_joint' type='revolute'>\n      <parent>torso_lift_link</parent>\n      <child>head_pan_link</child>\n      <axis>\n        <xyz>0.000000 0.000000 1.000000</xyz>\n        <dynamics>\n          <damping>2.000000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-3.006993</lower>\n          <upper>3.006993</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='head_tilt_joint' type='revolute'>\n      <parent>head_pan_link</parent>\n      <child>head_tilt_link</child>\n      <axis>\n        <xyz>0.000000 1.000000 0.000000</xyz>\n        <dynamics>\n          <damping>10.000000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-0.471237</lower>\n          <upper>1.396260</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='l_shoulder_pan_joint' type='revolute'>\n      <parent>torso_lift_link</parent>\n      <child>l_shoulder_pan_link</child>\n      <axis>\n        <xyz>0.000000 0.000000 1.000000</xyz>\n        <dynamics>\n          <damping>10.000000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-0.714602</lower>\n          <upper>2.285404</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='l_shoulder_lift_joint' type='revolute'>\n      <parent>l_shoulder_pan_link</parent>\n      <child>l_shoulder_lift_link</child>\n      <axis>\n        <xyz>0.000000 1.000000 0.000000</xyz>\n        <dynamics>\n          <damping>10.000000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-0.523601</lower>\n          <upper>1.396300</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='l_upper_arm_roll_joint' type='revolute'>\n      <parent>l_shoulder_lift_link</parent>\n      <child>l_upper_arm_roll_link</child>\n      <axis>\n        <xyz>1.000000 0.000000 0.000000</xyz>\n        <dynamics>\n          <damping>0.100000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-0.800000</lower>\n          <upper>3.900008</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='l_elbow_flex_joint' type='revolute'>\n      <parent>l_upper_arm_roll_link</parent>\n      <child>l_elbow_flex_link</child>\n      <axis>\n        <xyz>0.000000 1.000000 0.000000</xyz>\n        <dynamics>\n          <damping>1.000000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-2.321305</lower>\n          <upper>0.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='l_forearm_roll_joint' type='revolute'>\n      <parent>l_elbow_flex_link</parent>\n      <child>l_forearm_roll_link</child>\n      <axis>\n        <xyz>1.000000 0.000000 0.000000</xyz>\n        <dynamics>\n          <damping>0.100000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='l_wrist_flex_joint' type='revolute'>\n      <parent>l_forearm_roll_link</parent>\n      <child>l_wrist_flex_link</child>\n      <axis>\n        <xyz>0.000000 1.000000 0.000000</xyz>\n        <dynamics>\n          <damping>0.100000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-2.180004</lower>\n          <upper>0.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='l_wrist_roll_joint' type='revolute'>\n      <parent>l_wrist_flex_link</parent>\n      <child>l_wrist_roll_link</child>\n      <axis>\n        <xyz>1.000000 0.000000 0.000000</xyz>\n        <dynamics>\n          <damping>0.100000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='l_gripper_l_finger_joint' type='revolute'>\n      <parent>l_wrist_roll_link</parent>\n      <child>l_gripper_l_finger_link</child>\n      <axis>\n        <xyz>0.000000 0.000000 1.000000</xyz>\n        <dynamics>\n          <damping>0.020000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>0.000000</lower>\n          <upper>0.548000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='l_gripper_l_finger_tip_joint' type='revolute'>\n      <parent>l_gripper_l_finger_link</parent>\n      <child>l_gripper_l_finger_tip_link</child>\n      <axis>\n        <xyz>0.000000 0.000000 -1.000000</xyz>\n        <dynamics>\n          <damping>0.001000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>0.000000</lower>\n          <upper>0.548000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='l_gripper_motor_slider_joint' type='prismatic'>\n      <parent>l_wrist_roll_link</parent>\n      <child>l_gripper_motor_slider_link</child>\n      <axis>\n        <xyz>1.000000 0.000000 0.000000</xyz>\n        <limit>\n          <lower>-0.100000</lower>\n          <upper>0.100000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='l_gripper_motor_screw_joint' type='revolute'>\n      <parent>l_gripper_motor_slider_link</parent>\n      <child>l_gripper_motor_screw_link</child>\n      <axis>\n        <xyz>0.000000 1.000000 0.000000</xyz>\n        <dynamics>\n          <damping>0.000100</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='l_gripper_r_finger_joint' type='revolute'>\n      <parent>l_wrist_roll_link</parent>\n      <child>l_gripper_r_finger_link</child>\n      <axis>\n        <xyz>0.000000 0.000000 -1.000000</xyz>\n        <dynamics>\n          <damping>0.020000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>0.000000</lower>\n          <upper>0.548000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='l_gripper_r_finger_tip_joint' type='revolute'>\n      <parent>l_gripper_r_finger_link</parent>\n      <child>l_gripper_r_finger_tip_link</child>\n      <axis>\n        <xyz>0.000000 0.000000 1.000000</xyz>\n        <dynamics>\n          <damping>0.001000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>0.000000</lower>\n          <upper>0.548000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='laser_tilt_mount_joint' type='revolute'>\n      <parent>torso_lift_link</parent>\n      <child>laser_tilt_mount_link</child>\n      <axis>\n        <xyz>0.000000 1.000000 0.000000</xyz>\n        <dynamics>\n          <damping>0.008000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-0.785400</lower>\n          <upper>1.483530</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='r_shoulder_pan_joint' type='revolute'>\n      <parent>torso_lift_link</parent>\n      <child>r_shoulder_pan_link</child>\n      <axis>\n        <xyz>0.000000 0.000000 1.000000</xyz>\n        <dynamics>\n          <damping>10.000000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-2.285404</lower>\n          <upper>0.714602</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='r_shoulder_lift_joint' type='revolute'>\n      <parent>r_shoulder_pan_link</parent>\n      <child>r_shoulder_lift_link</child>\n      <axis>\n        <xyz>0.000000 1.000000 0.000000</xyz>\n        <dynamics>\n          <damping>10.000000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-0.523601</lower>\n          <upper>1.396300</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='r_upper_arm_roll_joint' type='revolute'>\n      <parent>r_shoulder_lift_link</parent>\n      <child>r_upper_arm_roll_link</child>\n      <axis>\n        <xyz>1.000000 0.000000 0.000000</xyz>\n        <dynamics>\n          <damping>0.100000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-3.900008</lower>\n          <upper>0.800000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='r_elbow_flex_joint' type='revolute'>\n      <parent>r_upper_arm_roll_link</parent>\n      <child>r_elbow_flex_link</child>\n      <axis>\n        <xyz>0.000000 1.000000 0.000000</xyz>\n        <dynamics>\n          <damping>1.000000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-2.321305</lower>\n          <upper>0.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='r_forearm_roll_joint' type='revolute'>\n      <parent>r_elbow_flex_link</parent>\n      <child>r_forearm_roll_link</child>\n      <axis>\n        <xyz>1.000000 0.000000 0.000000</xyz>\n        <dynamics>\n          <damping>0.100000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='r_wrist_flex_joint' type='revolute'>\n      <parent>r_forearm_roll_link</parent>\n      <child>r_wrist_flex_link</child>\n      <axis>\n        <xyz>0.000000 1.000000 0.000000</xyz>\n        <dynamics>\n          <damping>0.100000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-2.180004</lower>\n          <upper>0.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='r_wrist_roll_joint' type='revolute'>\n      <parent>r_wrist_flex_link</parent>\n      <child>r_wrist_roll_link</child>\n      <axis>\n        <xyz>1.000000 0.000000 0.000000</xyz>\n        <dynamics>\n          <damping>0.100000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='r_gripper_l_finger_joint' type='revolute'>\n      <parent>r_wrist_roll_link</parent>\n      <child>r_gripper_l_finger_link</child>\n      <axis>\n        <xyz>0.000000 0.000000 1.000000</xyz>\n        <dynamics>\n          <damping>0.020000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>0.000000</lower>\n          <upper>0.548000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='r_gripper_l_finger_tip_joint' type='revolute'>\n      <parent>r_gripper_l_finger_link</parent>\n      <child>r_gripper_l_finger_tip_link</child>\n      <axis>\n        <xyz>0.000000 0.000000 -1.000000</xyz>\n        <dynamics>\n          <damping>0.001000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>0.000000</lower>\n          <upper>0.548000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='r_gripper_motor_slider_joint' type='prismatic'>\n      <parent>r_wrist_roll_link</parent>\n      <child>r_gripper_motor_slider_link</child>\n      <axis>\n        <xyz>1.000000 0.000000 0.000000</xyz>\n        <dynamics>\n          <damping>0.000000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-0.100000</lower>\n          <upper>0.100000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='r_gripper_motor_screw_joint' type='revolute'>\n      <parent>r_gripper_motor_slider_link</parent>\n      <child>r_gripper_motor_screw_link</child>\n      <axis>\n        <xyz>0.000000 1.000000 0.000000</xyz>\n        <dynamics>\n          <damping>0.000100</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='r_gripper_r_finger_joint' type='revolute'>\n      <parent>r_wrist_roll_link</parent>\n      <child>r_gripper_r_finger_link</child>\n      <axis>\n        <xyz>0.000000 0.000000 -1.000000</xyz>\n        <dynamics>\n          <damping>0.020000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>0.000000</lower>\n          <upper>0.548000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='r_gripper_r_finger_tip_joint' type='revolute'>\n      <parent>r_gripper_r_finger_link</parent>\n      <child>r_gripper_r_finger_tip_link</child>\n      <axis>\n        <xyz>0.000000 0.000000 1.000000</xyz>\n        <dynamics>\n          <damping>0.001000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>0.000000</lower>\n          <upper>0.548000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='torso_lift_motor_screw_joint' type='revolute'>\n      <parent>base_footprint</parent>\n      <child>torso_lift_motor_screw_link</child>\n      <axis>\n        <xyz>0.000000 0.000000 1.000000</xyz>\n        <dynamics>\n          <damping>0.000100</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='torso_lift_screw_torso_lift_joint' type='screw'>\n      <parent>torso_lift_link</parent>\n      <child>torso_lift_motor_screw_link</child>\n      <thread_pitch>3141.600000</thread_pitch>\n      <axis>\n        <xyz>0.000000 0.000000 1.000000</xyz>\n        <dynamics>\n          <damping>0.000000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='r_gripper_r_screw_screw_joint' type='screw'>\n      <parent>r_gripper_r_finger_tip_link</parent>\n      <child>r_gripper_motor_screw_link</child>\n      <thread_pitch>-3141.600000</thread_pitch>\n      <axis>\n        <xyz>0.000000 1.000000 0.000000</xyz>\n        <dynamics>\n          <damping>0.000000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='r_gripper_l_screw_screw_joint' type='screw'>\n      <parent>r_gripper_l_finger_tip_link</parent>\n      <child>r_gripper_motor_screw_link</child>\n      <thread_pitch>3141.600000</thread_pitch>\n      <axis>\n        <xyz>0.000000 1.000000 0.000000</xyz>\n        <dynamics>\n          <damping>0.000000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='r_gripper_r_parallel_root_joint' type='revolute'>\n      <pose>0.058910 -0.031000 0.000000 0.000000 0.000000 0.000000</pose>\n      <parent>r_gripper_r_parallel_link</parent>\n      <child>r_wrist_roll_link</child>\n      <axis>\n        <xyz>0.000000 0.000000 -1.000000</xyz>\n        <dynamics>\n          <damping>0.200000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='r_gripper_l_parallel_root_joint' type='revolute'>\n      <pose>0.058910 0.031000 0.000000 0.000000 0.000000 0.000000</pose>\n      <parent>r_gripper_l_parallel_link</parent>\n      <child>r_wrist_roll_link</child>\n      <axis>\n        <xyz>0.000000 0.000000 1.000000</xyz>\n        <dynamics>\n          <damping>0.200000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='r_gripper_r_parallel_tip_joint' type='revolute'>\n      <pose>-0.018000 -0.021000 0.000000 0.000000 0.000000 0.000000</pose>\n      <parent>r_gripper_r_parallel_link</parent>\n      <child>r_gripper_r_finger_tip_link</child>\n      <axis>\n        <xyz>0.000000 0.000000 1.000000</xyz>\n        <dynamics>\n          <damping>0.000000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='r_gripper_l_parallel_tip_joint' type='revolute'>\n      <pose>-0.018000 0.021000 0.000000 0.000000 0.000000 0.000000</pose>\n      <parent>r_gripper_l_parallel_link</parent>\n      <child>r_gripper_l_finger_tip_link</child>\n      <axis>\n        <xyz>0.000000 0.000000 1.000000</xyz>\n        <dynamics>\n          <damping>0.000000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='r_gripper_joint' type='prismatic'>\n      <parent>r_gripper_r_finger_tip_link</parent>\n      <child>r_gripper_l_finger_tip_link</child>\n      <axis>\n        <xyz>0.000000 1.000000 0.000000</xyz>\n        <dynamics>\n          <damping>0.000000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='l_gripper_r_screw_screw_joint' type='screw'>\n      <parent>l_gripper_r_finger_tip_link</parent>\n      <child>l_gripper_motor_screw_link</child>\n      <thread_pitch>-3141.600000</thread_pitch>\n      <axis>\n        <xyz>0.000000 1.000000 0.000000</xyz>\n        <dynamics>\n          <damping>0.000000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='l_gripper_l_screw_screw_joint' type='screw'>\n      <parent>l_gripper_l_finger_tip_link</parent>\n      <child>l_gripper_motor_screw_link</child>\n      <thread_pitch>3141.600000</thread_pitch>\n      <axis>\n        <xyz>0.000000 1.000000 0.000000</xyz>\n        <dynamics>\n          <damping>0.000000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='l_gripper_r_parallel_root_joint' type='revolute'>\n      <pose>0.058910 -0.031000 0.000000 0.000000 0.000000 0.000000</pose>\n      <parent>l_gripper_r_parallel_link</parent>\n      <child>l_wrist_roll_link</child>\n      <axis>\n        <xyz>0.000000 0.000000 -1.000000</xyz>\n        <dynamics>\n          <damping>0.200000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='l_gripper_l_parallel_root_joint' type='revolute'>\n      <pose>0.058910 0.031000 0.000000 0.000000 0.000000 0.000000</pose>\n      <parent>l_gripper_l_parallel_link</parent>\n      <child>l_wrist_roll_link</child>\n      <axis>\n        <xyz>0.000000 0.000000 1.000000</xyz>\n        <dynamics>\n          <damping>0.200000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='l_gripper_r_parallel_tip_joint' type='revolute'>\n      <pose>-0.018000 -0.021000 0.000000 0.000000 0.000000 0.000000</pose>\n      <parent>l_gripper_r_parallel_link</parent>\n      <child>l_gripper_r_finger_tip_link</child>\n      <axis>\n        <xyz>0.000000 0.000000 1.000000</xyz>\n        <dynamics>\n          <damping>0.000000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='l_gripper_l_parallel_tip_joint' type='revolute'>\n      <pose>-0.018000 0.021000 0.000000 0.000000 0.000000 0.000000</pose>\n      <parent>l_gripper_l_parallel_link</parent>\n      <child>l_gripper_l_finger_tip_link</child>\n      <axis>\n        <xyz>0.000000 0.000000 1.000000</xyz>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='l_gripper_joint' type='prismatic'>\n      <parent>l_gripper_r_finger_tip_link</parent>\n      <child>l_gripper_l_finger_tip_link</child>\n      <axis>\n        <xyz>0.000000 1.000000 0.000000</xyz>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n  </model>\n  <physics type='ode'>\n    <update_rate>1000.000000</update_rate>\n    <gravity>0.000000 0.000000 -9.800000</gravity>\n  </physics>\n  <scene>\n    <ambient>0.200000 0.200000 0.200000 1.000000</ambient>\n    <background>0.700000 0.700000 0.700000 1.000000</background>\n    <shadows>1</shadows>\n  </scene>\n  <state world_name='default'>\n    <sim_time>0 0</sim_time>\n    <real_time>0 0</real_time>\n    <wall_time>1360301755 667456998</wall_time>\n  </state>\n</world>\n</sdf>]]></chunk>\n<chunk encoding='txt'><![CDATA[\n<sdf version='1.4'>\n<state world_name='default'>\n<sim_time>0 21343973</sim_time>\n<real_time>0 1000000</real_time>\n<wall_time>1360301758 939690376</wall_time>\n<model name='pr2'><pose>0.000 0.000 -0.000 0.000 -0.000 0.000 </pose><link name='base_footprint'><pose>0.00000 0.00000 0.00000 0.00000 -0.00000 0.00000 </pose><velocity>0.0001 0.0000 -0.0080 0.0002 -0.0005 -0.0001 </velocity></link><link name='bl_caster_l_wheel_link'><pose>-0.00000 0.00000 -0.00000 0.00000 -0.00000 0.00000 </pose><velocity>0.0002 0.0001 -0.0080 0.0002 0.0000 -0.0000 </velocity></link><link name='bl_caster_r_wheel_link'><pose>0.00000 0.00000 -0.00000 0.00000 -0.00000 0.00000 </pose><velocity>0.0002 0.0001 -0.0080 0.0002 -0.0000 -0.0000 </velocity></link><link name='bl_caster_rotation_link'><pose>0.00000 0.00000 -0.00000 0.00000 -0.00000 0.00000 </pose><velocity>0.0002 0.0001 -0.0080 0.0002 -0.0005 -0.0000 </velocity></link><link name='br_caster_l_wheel_link'><pose>0.00000 -0.00000 -0.00000 0.00000 -0.00000 0.00000 </pose><velocity>0.0002 0.0001 -0.0081 0.0002 0.0000 -0.0000 </velocity></link><link name='br_caster_r_wheel_link'><pose>0.00000 -0.00000 -0.00000 0.00000 -0.00000 0.00000 </pose><velocity>0.0002 0.0001 -0.0081 0.0002 0.0000 -0.0000 </velocity></link><link name='br_caster_rotation_link'><pose>0.00000 -0.00000 -0.00000 0.00000 -0.00000 0.00000 </pose><velocity>0.0001 0.0001 -0.0081 0.0002 -0.0005 -0.0000 </velocity></link><link name='fl_caster_l_wheel_link'><pose>-0.00000 -0.00000 -0.00000 0.00000 -0.00000 0.00000 </pose><velocity>0.0002 0.0000 -0.0078 0.0002 0.0000 -0.0000 </velocity></link><link name='fl_caster_r_wheel_link'><pose>0.00000 -0.00000 -0.00000 0.00000 -0.00000 0.00000 </pose><velocity>0.0002 0.0000 -0.0078 0.0002 0.0000 -0.0000 </velocity></link><link name='fl_caster_rotation_link'><pose>0.00000 -0.00000 -0.00000 0.00000 -0.00000 0.00000 </pose><velocity>0.0002 0.0000 -0.0078 0.0002 -0.0005 -0.0000 </velocity></link><link name='fr_caster_l_wheel_link'><pose>0.00000 -0.00000 -0.00000 0.00000 -0.00000 0.00000 </pose><velocity>0.0002 0.0000 -0.0079 0.0001 0.0000 -0.0000 </velocity></link><link name='fr_caster_r_wheel_link'><pose>0.00000 0.00000 -0.00000 0.00000 -0.00000 0.00000 </pose><velocity>0.0002 0.0000 -0.0079 0.0002 0.0000 -0.0000 </velocity></link><link name='fr_caster_rotation_link'><pose>0.00000 -0.00000 -0.00000 0.00000 -0.00000 0.00000 </pose><velocity>0.0001 0.0000 -0.0079 0.0002 -0.0005 -0.0000 </velocity></link><link name='head_pan_link'><pose>-0.00000 0.00000 0.00000 0.00000 -0.00000 0.00000 </pose><velocity>-0.0004 -0.0001 -0.0065 0.0003 -0.0005 -0.0000 </velocity></link><link name='head_tilt_link'><pose>-0.00000 0.00000 0.00000 0.00000 0.00000 0.00000 </pose><velocity>-0.0004 -0.0001 -0.0065 0.0002 0.0003 -0.0000 </velocity></link><link name='l_elbow_flex_link'><pose>-0.00000 0.00000 0.00001 0.00001 -0.00001 0.00000 </pose><velocity>-0.0000 0.0001 -0.0011 0.0105 -0.0104 0.0001 </velocity></link><link name='l_forearm_roll_link'><pose>-0.00000 0.00000 0.00001 0.00000 -0.00001 0.00000 </pose><velocity>-0.0001 -0.0000 0.0006 0.0001 -0.0109 0.0001 </velocity></link><link name='l_gripper_l_finger_link'><pose>-0.00000 0.00000 0.00001 0.00000 0.00000 0.00000 </pose><velocity>-0.0002 -0.0000 0.0017 0.0001 0.0034 0.0004 </velocity></link><link name='l_gripper_l_finger_tip_link'><pose>-0.00000 0.00000 0.00001 -0.00000 0.00000 0.00000 </pose><velocity>-0.0002 0.0000 0.0015 -0.0005 0.0029 0.0008 </velocity></link><link name='l_gripper_l_parallel_link'><pose>-0.00000 0.00000 0.00001 0.00000 0.00000 0.00000 </pose><velocity>-0.0002 -0.0000 0.0017 -0.0001 0.0037 0.0005 </velocity></link><link name='l_gripper_motor_screw_link'><pose>-0.00000 0.00000 0.00001 0.00000 0.00000 0.00000 </pose><velocity>-0.0002 0.0000 0.0015 -0.0000 0.0004 0.0001 </velocity></link><link name='l_gripper_motor_slider_link'><pose>-0.00000 0.00000 0.00001 0.00000 0.00000 0.00000 </pose><velocity>-0.0002 0.0000 0.0015 -0.0000 0.0033 0.0001 </velocity></link><link name='l_gripper_r_finger_link'><pose>-0.00000 0.00000 0.00001 0.00000 0.00001 0.00000 </pose><velocity>-0.0002 -0.0000 0.0017 0.0005 0.0041 0.0002 </velocity></link><link name='l_gripper_r_finger_tip_link'><pose>-0.00000 0.00000 0.00001 -0.00000 0.00000 0.00000 </pose><velocity>-0.0002 -0.0000 0.0015 -0.0003 0.0029 0.0008 </velocity></link><link name='l_gripper_r_parallel_link'><pose>-0.00000 0.00000 0.00001 0.00000 0.00001 0.00000 </pose><velocity>-0.0002 -0.0000 0.0017 0.0007 0.0041 -0.0002 </velocity></link><link name='l_shoulder_lift_link'><pose>-0.00000 0.00000 0.00000 0.00000 -0.00001 0.00000 </pose><velocity>0.0002 -0.0001 -0.0061 0.0002 -0.0130 -0.0000 </velocity></link><link name='l_shoulder_pan_link'><pose>-0.00000 -0.00000 0.00000 0.00000 -0.00000 0.00000 </pose><velocity>-0.0001 -0.0000 -0.0065 0.0002 -0.0005 0.0000 </velocity></link><link name='l_upper_arm_roll_link'><pose>-0.00000 0.00000 0.00000 0.00001 -0.00001 0.00000 </pose><velocity>-0.0002 -0.0000 -0.0035 0.0106 -0.0130 0.0000 </velocity></link><link name='l_wrist_flex_link'><pose>-0.00000 0.00000 0.00001 0.00000 -0.00002 0.00000 </pose><velocity>-0.0002 -0.0000 0.0021 0.0001 -0.0168 0.0001 </velocity></link><link name='l_wrist_roll_link'><pose>-0.00000 0.00000 0.00001 0.00000 0.00000 0.00000 </pose><velocity>-0.0002 -0.0000 0.0019 -0.0000 0.0033 0.0001 </velocity></link><link name='laser_tilt_mount_link'><pose>-0.00000 0.00000 0.00000 0.00000 -0.00000 0.00000 </pose><velocity>-0.0003 -0.0001 -0.0065 0.0002 -0.0030 -0.0000 </velocity></link><link name='r_elbow_flex_link'><pose>0.00000 0.00000 0.00001 -0.00001 -0.00001 -0.00000 </pose><velocity>-0.0000 -0.0001 -0.0011 -0.0101 -0.0098 0.0001 </velocity></link><link name='r_forearm_roll_link'><pose>-0.00000 0.00000 0.00001 0.00000 -0.00001 0.00000 </pose><velocity>-0.0001 0.0000 0.0007 0.0000 -0.0110 0.0001 </velocity></link><link name='r_gripper_l_finger_link'><pose>0.00000 0.00000 0.00001 -0.00000 0.00001 0.00000 </pose><velocity>-0.0002 0.0000 0.0016 -0.0004 0.0046 -0.0000 </velocity></link><link name='r_gripper_l_finger_tip_link'><pose>0.00000 0.00000 0.00001 0.00000 0.00001 0.00000 </pose><velocity>-0.0001 0.0000 0.0013 0.0003 0.0047 0.0000 </velocity></link><link name='r_gripper_l_parallel_link'><pose>0.00000 0.00000 0.00001 -0.00000 0.00001 0.00000 </pose><velocity>-0.0002 0.0000 0.0017 -0.0006 0.0045 -0.0002 </velocity></link><link name='r_gripper_motor_screw_link'><pose>0.00000 0.00000 0.00001 0.00000 0.00000 0.00000 </pose><velocity>-0.0001 0.0000 0.0013 -0.0000 0.0005 0.0001 </velocity></link><link name='r_gripper_motor_slider_link'><pose>0.00000 0.00000 0.00001 0.00000 0.00001 0.00000 </pose><velocity>-0.0001 0.0000 0.0014 -0.0000 0.0040 0.0000 </velocity></link><link name='r_gripper_r_finger_link'><pose>0.00000 0.00000 0.00001 0.00000 0.00001 0.00000 </pose><velocity>-0.0001 0.0000 0.0016 0.0015 0.0052 0.0001 </velocity></link><link name='r_gripper_r_finger_tip_link'><pose>0.00000 0.00000 0.00001 0.00000 0.00001 0.00000 </pose><velocity>-0.0001 0.0000 0.0013 0.0005 0.0051 -0.0000 </velocity></link><link name='r_gripper_r_parallel_link'><pose>0.00000 0.00000 0.00001 0.00000 0.00001 0.00000 </pose><velocity>-0.0001 0.0000 0.0017 0.0005 0.0044 -0.0000 </velocity></link><link name='r_shoulder_lift_link'><pose>-0.00000 0.00000 0.00000 0.00000 -0.00001 0.00000 </pose><velocity>0.0002 -0.0000 -0.0062 0.0002 -0.0133 0.0001 </velocity></link><link name='r_shoulder_pan_link'><pose>-0.00000 0.00000 0.00000 0.00000 -0.00000 0.00000 </pose><velocity>-0.0001 -0.0000 -0.0065 0.0002 -0.0005 0.0001 </velocity></link><link name='r_upper_arm_roll_link'><pose>-0.00000 0.00000 0.00000 -0.00001 -0.00001 0.00000 </pose><velocity>-0.0002 -0.0000 -0.0035 -0.0101 -0.0133 0.0001 </velocity></link><link name='r_wrist_flex_link'><pose>0.00000 0.00000 0.00001 0.00000 0.00001 0.00000 </pose><velocity>-0.0002 0.0000 0.0021 0.0000 0.0100 -0.0000 </velocity></link><link name='r_wrist_roll_link'><pose>0.00000 0.00000 0.00001 0.00000 0.00000 0.00000 </pose><velocity>-0.0002 0.0000 0.0019 -0.0000 0.0039 0.0000 </velocity></link><link name='torso_lift_link'><pose>-0.00000 -0.00000 0.00000 0.00000 -0.00000 0.00000 </pose><velocity>-0.0001 -0.0000 -0.0066 0.0003 -0.0006 -0.0001 </velocity></link><link name='torso_lift_motor_screw_link'><pose>-0.00000 -0.00000 -0.00000 -0.00000 -0.00000 0.00008 </pose><velocity>-0.0002 -0.0001 -0.0086 -0.0004 -0.0005 0.0793 </velocity></link></model></sdf></state>\n]]></chunk>\n<chunk encoding='txt'><![CDATA[\n<sdf version='1.4'>\n<state world_name='default'>\n<sim_time>0 28958235</sim_time>\n<real_time>0 2000000</real_time>\n<wall_time>1360301758 947304437</wall_time>\n<model name='pr2'><pose>0.000 0.000 -0.000 0.000 -0.000 0.000 </pose><link name='base_footprint'><pose>0.00000 0.00000 0.00000 0.00000 -0.00000 0.00000 </pose><velocity>0.0001 0.0000 -0.0074 0.0002 -0.0005 -0.0001 </velocity></link><link name='bl_caster_l_wheel_link'><pose>-0.00000 0.00000 -0.00000 0.00000 0.00000 0.00000 </pose><velocity>0.0002 0.0001 -0.0074 0.0002 0.0000 -0.0000 </velocity></link><link name='bl_caster_r_wheel_link'><pose>0.00000 0.00000 -0.00000 0.00000 0.00000 0.00000 </pose><velocity>0.0002 0.0001 -0.0075 0.0002 -0.0000 -0.0000 </velocity></link><link name='bl_caster_rotation_link'><pose>0.00000 0.00000 -0.00000 0.00000 -0.00000 0.00000 </pose><velocity>0.0002 0.0001 -0.0074 0.0001 -0.0005 -0.0000 </velocity></link><link name='br_caster_l_wheel_link'><pose>-0.00000 0.00000 -0.00000 0.00000 0.00000 0.00000 </pose><velocity>0.0002 0.0001 -0.0075 0.0002 0.0000 -0.0000 </velocity></link><link name='br_caster_r_wheel_link'><pose>0.00000 0.00000 -0.00000 0.00000 0.00000 0.00000 </pose><velocity>0.0002 0.0001 -0.0075 0.0002 0.0000 -0.0000 </velocity></link><link name='br_caster_rotation_link'><pose>-0.00000 0.00000 -0.00000 0.00000 -0.00000 0.00000 </pose><velocity>0.0001 0.0001 -0.0075 0.0003 -0.0005 -0.0000 </velocity></link><link name='fl_caster_l_wheel_link'><pose>-0.00000 0.00000 -0.00000 0.00000 0.00000 0.00000 </pose><velocity>0.0002 0.0001 -0.0072 0.0002 0.0000 -0.0000 </velocity></link><link name='fl_caster_r_wheel_link'><pose>0.00000 -0.00000 -0.00000 0.00000 0.00000 0.00000 </pose><velocity>0.0002 0.0001 -0.0072 0.0001 0.0000 -0.0000 </velocity></link><link name='fl_caster_rotation_link'><pose>0.00000 0.00000 -0.00000 0.00000 -0.00000 0.00000 </pose><velocity>0.0002 0.0000 -0.0072 0.0002 -0.0005 -0.0000 </velocity></link><link name='fr_caster_l_wheel_link'><pose>-0.00000 0.00000 -0.00000 0.00000 0.00000 0.00000 </pose><velocity>0.0002 0.0001 -0.0073 0.0002 0.0000 -0.0000 </velocity></link><link name='fr_caster_r_wheel_link'><pose>0.00000 0.00000 -0.00000 0.00000 0.00000 0.00000 </pose><velocity>0.0002 0.0001 -0.0073 0.0002 0.0000 -0.0000 </velocity></link><link name='fr_caster_rotation_link'><pose>-0.00000 -0.00000 -0.00000 0.00000 -0.00000 0.00000 </pose><velocity>0.0001 0.0000 -0.0073 0.0001 -0.0005 -0.0000 </velocity></link><link name='head_pan_link'><pose>-0.00000 0.00000 0.00000 0.00000 -0.00000 0.00000 </pose><velocity>-0.0004 -0.0002 -0.0072 0.0000 -0.0005 0.0000 </velocity></link><link name='head_tilt_link'><pose>-0.00000 0.00000 0.00000 0.00000 0.00000 0.00000 </pose><velocity>-0.0003 -0.0001 -0.0072 0.0001 0.0003 -0.0000 </velocity></link><link name='l_elbow_flex_link'><pose>0.00000 0.00000 0.00001 0.00002 -0.00002 0.00000 </pose><velocity>0.0000 0.0001 -0.0015 0.0125 -0.0139 0.0002 </velocity></link><link name='l_forearm_roll_link'><pose>-0.00000 0.00000 0.00001 0.00000 -0.00002 0.00000 </pose><velocity>-0.0000 -0.0000 0.0010 0.0002 -0.0137 0.0000 </velocity></link><link name='l_gripper_l_finger_link'><pose>0.00000 0.00000 0.00002 -0.00000 0.00002 0.00000 </pose><velocity>-0.0001 -0.0000 0.0014 -0.0006 0.0143 -0.0001 </velocity></link><link name='l_gripper_l_finger_tip_link'><pose>-0.00000 0.00000 0.00002 0.00000 0.00002 0.00000 </pose><velocity>-0.0001 -0.0000 0.0005 0.0006 0.0146 -0.0007 </velocity></link><link name='l_gripper_l_parallel_link'><pose>-0.00000 0.00000 0.00002 -0.00000 0.00002 -0.00000 </pose><velocity>-0.0001 -0.0000 0.0017 -0.0002 0.0136 -0.0003 </velocity></link><link name='l_gripper_motor_slider_link'><pose>0.00000 0.00000 0.00002 0.00000 0.00002 0.00000 </pose><velocity>-0.0001 -0.0000 0.0006 0.0000 0.0143 0.0001 </velocity></link><link name='l_gripper_r_finger_link'><pose>0.00000 0.00000 0.00002 -0.00000 0.00002 -0.00000 </pose><velocity>-0.0001 -0.0000 0.0014 -0.0008 0.0132 -0.0001 </velocity></link><link name='l_gripper_r_finger_tip_link'><pose>0.00000 0.00000 0.00002 0.00000 0.00002 0.00000 </pose><velocity>-0.0001 -0.0000 0.0006 0.0007 0.0150 -0.0007 </velocity></link><link name='l_gripper_r_parallel_link'><pose>0.00000 0.00000 0.00002 -0.00000 0.00002 0.00000 </pose><velocity>-0.0001 -0.0000 0.0016 -0.0009 0.0135 0.0004 </velocity></link><link name='l_shoulder_lift_link'><pose>-0.00000 0.00000 0.00000 0.00000 -0.00003 0.00000 </pose><velocity>0.0002 -0.0001 -0.0069 0.0002 -0.0135 0.0001 </velocity></link><link name='l_shoulder_pan_link'><pose>-0.00000 0.00000 0.00000 0.00000 -0.00000 0.00000 </pose><velocity>-0.0001 -0.0000 -0.0071 0.0002 -0.0005 0.0000 </velocity></link><link name='l_upper_arm_roll_link'><pose>0.00000 0.00000 0.00000 0.00002 -0.00003 0.00000 </pose><velocity>-0.0002 -0.0001 -0.0041 0.0123 -0.0137 0.0002 </velocity></link><link name='l_wrist_flex_link'><pose>0.00000 0.00000 0.00002 0.00000 0.00002 0.00000 </pose><velocity>-0.0001 -0.0000 0.0030 0.0002 0.0384 0.0000 </velocity></link><link name='l_wrist_roll_link'><pose>0.00000 0.00000 0.00002 0.00000 0.00002 0.00000 </pose><velocity>-0.0001 -0.0000 0.0022 0.0000 0.0142 0.0001 </velocity></link><link name='laser_tilt_mount_link'><pose>-0.00000 0.00000 0.00000 0.00000 -0.00001 0.00000 </pose><velocity>-0.0003 -0.0001 -0.0073 0.0002 -0.0026 -0.0001 </velocity></link><link name='r_elbow_flex_link'><pose>0.00000 0.00000 0.00001 -0.00002 -0.00002 0.00000 </pose><velocity>-0.0001 -0.0001 -0.0016 -0.0121 -0.0126 0.0000 </velocity></link><link name='r_forearm_roll_link'><pose>0.00000 0.00000 0.00001 0.00000 -0.00002 0.00000 </pose><velocity>-0.0001 0.0000 0.0005 -0.0000 -0.0130 0.0001 </velocity></link><link name='r_gripper_l_finger_link'><pose>-0.00000 0.00000 0.00002 0.00000 0.00000 0.00000 </pose><velocity>-0.0002 0.0000 0.0027 0.0006 -0.0039 0.0004 </velocity></link><link name='r_gripper_l_finger_tip_link'><pose>-0.00000 0.00000 0.00002 0.00000 0.00000 0.00000 </pose><velocity>-0.0002 0.0000 0.0030 -0.0001 -0.0032 0.0001 </velocity></link><link name='r_gripper_l_parallel_link'><pose>-0.00000 0.00000 0.00002 0.00000 0.00000 0.00000 </pose><velocity>-0.0002 0.0000 0.0027 0.0006 -0.0043 0.0000 </velocity></link><link name='r_gripper_motor_screw_link'><pose>-0.00000 0.00000 0.00002 0.00000 0.00000 0.00000 </pose><velocity>-0.0002 0.0000 0.0029 -0.0000 0.0008 0.0001 </velocity></link><link name='r_gripper_motor_slider_link'><pose>-0.00000 0.00000 0.00002 0.00000 0.00000 0.00000 </pose><velocity>-0.0002 0.0001 0.0029 -0.0000 -0.0036 0.0001 </velocity></link><link name='r_gripper_r_finger_link'><pose>-0.00000 0.00000 0.00002 0.00000 0.00000 0.00000 </pose><velocity>-0.0002 0.0000 0.0027 -0.0009 -0.0045 -0.0002 </velocity></link><link name='r_gripper_r_finger_tip_link'><pose>-0.00000 0.00000 0.00002 -0.00000 0.00000 -0.00000 </pose><velocity>-0.0002 0.0000 0.0030 -0.0017 -0.0040 0.0001 </velocity></link><link name='r_gripper_r_parallel_link'><pose>-0.00000 0.00000 0.00002 -0.00000 0.00000 0.00000 </pose><velocity>-0.0002 0.0000 0.0027 -0.0012 -0.0044 -0.0001 </velocity></link><link name='r_shoulder_lift_link'><pose>0.00000 0.00000 0.00000 0.00000 -0.00003 0.00000 </pose><velocity>0.0002 -0.0001 -0.0069 0.0000 -0.0136 0.0000 </velocity></link><link name='r_shoulder_pan_link'><pose>-0.00000 0.00000 0.00000 0.00000 -0.00000 0.00000 </pose><velocity>-0.0001 -0.0000 -0.0073 0.0002 -0.0006 0.0001 </velocity></link><link name='r_upper_arm_roll_link'><pose>0.00000 0.00000 0.00000 -0.00002 -0.00003 0.00000 </pose><velocity>-0.0002 0.0000 -0.0041 -0.0120 -0.0135 -0.0000 </velocity></link><link name='r_wrist_flex_link'><pose>-0.00000 0.00000 0.00002 0.00000 -0.00004 0.00000 </pose><velocity>-0.0002 0.0000 0.0023 -0.0000 -0.0484 0.0002 </velocity></link><link name='r_wrist_roll_link'><pose>-0.00000 0.00000 0.00002 0.00000 0.00000 0.00000 </pose><velocity>-0.0002 0.0000 0.0024 -0.0000 -0.0043 0.0001 </velocity></link><link name='torso_lift_link'><pose>0.00000 0.00000 0.00000 0.00000 -0.00000 0.00000 </pose><velocity>-0.0001 -0.0000 -0.0072 0.0001 -0.0004 -0.0001 </velocity></link><link name='torso_lift_motor_screw_link'><pose>-0.00000 0.00000 -0.00000 0.00000 -0.00000 0.00018 </pose><velocity>-0.0002 -0.0000 -0.0075 0.0007 -0.0007 0.1039 </velocity></link></model></sdf></state>\n]]></chunk>\n</gazebo_log>";

static std::string pr2PoseStateLog =
"<?xml version='1.0'?>\n<gazebo_log>\n<header>\n<log_version>1.0</log_version>\n<gazebo_version>1.4.6</gazebo_version>\n<rand_seed>32606</rand_seed>\n</header>\n\n<chunk encoding='txt'><![CDATA[\n<sdf version ='1.3'>\n<world name='default'>\n  <model name='ground_plane'>\n    <static>1</static>\n    <link name='link'>\n      <collision name='collision'>\n        <geometry>\n          <plane>\n            <normal>0.000000 0.000000 1.000000</normal>\n            <size>100.000000 100.000000</size>\n          </plane>\n        </geometry>\n        <surface>\n          <friction>\n            <ode>\n              <mu>100.000000</mu>\n              <mu2>50.000000</mu2>\n            </ode>\n          </friction>\n          <bounce/>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='visual'>\n        <cast_shadows>0</cast_shadows>\n        <geometry>\n          <plane>\n            <normal>0.000000 0.000000 1.000000</normal>\n            <size>100.000000 100.000000</size>\n          </plane>\n        </geometry>\n        <material>\n          <script>\n            <uri>file://media/materials/scripts/gazebo.material</uri>\n            <name>Gazebo/Grey</name>\n          </script>\n        </material>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <self_collide>0</self_collide>\n      <kinematic>0</kinematic>\n      <gravity>1</gravity>\n    </link>\n  </model>\n  <light name='sun' type='directional'>\n    <cast_shadows>1</cast_shadows>\n    <pose>0.000000 0.000000 10.000000 0.000000 0.000000 0.000000</pose>\n    <diffuse>0.800000 0.800000 0.800000 1.000000</diffuse>\n    <specular>0.100000 0.100000 0.100000 1.000000</specular>\n    <attenuation>\n      <range>1000.000000</range>\n      <constant>0.900000</constant>\n      <linear>0.010000</linear>\n      <quadratic>0.001000</quadratic>\n    </attenuation>\n    <direction>-0.500000 0.500000 -1.000000</direction>\n  </light>\n  <model name='pr2'>\n    <static>0</static>\n    <link name='base_footprint'>\n      <self_collide>0</self_collide>\n      <inertial>\n        <mass>118.001000</mass>\n        <pose>-0.062421 0.000000 0.201365 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>8.431730</ixx>\n          <ixy>-0.009720</ixy>\n          <ixz>1.901570</ixz>\n          <iyy>8.533050</iyy>\n          <iyz>-0.007380</iyz>\n          <izz>3.787470</izz>\n        </inertia>\n      </inertial>\n      <collision name='base_footprint_geom'>\n        <pose>0.000000 0.000000 0.071000 0.000000 0.000000 0.000000</pose>\n        <geometry>\n          <box>\n            <size>0.001000 0.001000 0.001000</size>\n          </box>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='base_footprint_geom_visual'>\n        <geometry>\n          <box>\n            <size>0.010000 0.010000 0.010000</size>\n          </box>\n        </geometry>\n      </visual>\n      <collision name='base_footprint_geom_base_bellow_link'>\n        <pose>-0.290000 0.000000 0.851000 0.000000 0.000000 0.000000</pose>\n        <geometry>\n          <box>\n            <size>0.050000 0.370000 0.300000</size>\n          </box>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='base_footprint_geom_base_bellow_link_visual'>\n        <pose>-0.290000 0.000000 0.851000 0.000000 0.000000 0.000000</pose>\n        <geometry>\n          <box>\n            <size>0.050000 0.370000 0.300000</size>\n          </box>\n        </geometry>\n      </visual>\n      <collision name='base_footprint_geom_base_link'>\n        <pose>0.000000 0.000000 0.051000 0.000000 0.000000 0.000000</pose>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/base_v0/base_L.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='base_footprint_geom_base_link_visual'>\n        <pose>0.000000 0.000000 0.051000 0.000000 0.000000 0.000000</pose>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/base_v0/base.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <sensor name='base_contact_sensor' type='contact'>\n        <update_rate>100.000000</update_rate>\n        <always_on>0</always_on>\n        <visualize>0</visualize>\n        <contact>\n          <collision>base_footprint_geom_base_link</collision>\n          <topic>__default_topic__</topic>\n        </contact>\n        <plugin name='gazebo_contact' filename='libContactPlugin.so'/>\n      </sensor>\n      <sensor name='base_laser' type='ray'>\n        <always_on>0</always_on>\n        <visualize>0</visualize>\n        <update_rate>20.000000</update_rate>\n        <pose>0.275000 0.000000 0.303000 0.000000 0.000000 0.000000</pose>\n        <ray>\n          <scan>\n            <horizontal>\n              <samples>640</samples>\n              <resolution>1.000000</resolution>\n              <min_angle>-2.268900</min_angle>\n              <max_angle>2.268900</max_angle>\n            </horizontal>\n          </scan>\n          <range>\n            <min>0.080000</min>\n            <max>10.000000</max>\n            <resolution>0.010000</resolution>\n          </range>\n        </ray>\n        <plugin name='laser' filename='libRayPlugin.so'/>\n      </sensor>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n      <gravity>1</gravity>\n    </link>\n    <link name='bl_caster_rotation_link'>\n      <self_collide>0</self_collide>\n      <pose>-0.224600 0.224600 0.079200 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>3.473080</mass>\n        <pose>0.000000 0.000000 0.070000 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.012412</ixx>\n          <ixy>-0.000712</ixy>\n          <ixz>0.000503</ixz>\n          <iyy>0.015218</iyy>\n          <iyz>-0.000004</iyz>\n          <izz>0.011764</izz>\n        </inertia>\n      </inertial>\n      <collision name='bl_caster_rotation_link_geom'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/base_v0/caster_L.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='bl_caster_rotation_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/base_v0/caster.stl</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n      <gravity>1</gravity>\n    </link>\n    <link name='bl_caster_l_wheel_link'>\n      <self_collide>0</self_collide>\n      <pose>-0.224600 0.273600 0.079200 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.440360</mass>\n        <inertia>\n          <ixx>0.012412</ixx>\n          <ixy>-0.000712</ixy>\n          <ixz>0.000503</ixz>\n          <iyy>0.015218</iyy>\n          <iyz>-0.000004</iyz>\n          <izz>0.011764</izz>\n        </inertia>\n      </inertial>\n      <collision name='bl_caster_l_wheel_link_geom'>\n        <pose>0.000000 0.000000 0.000000 1.570800 0.000000 0.000000</pose>\n        <geometry>\n          <cylinder>\n            <radius>0.074792</radius>\n            <length>0.034000</length>\n          </cylinder>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='bl_caster_l_wheel_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/base_v0/wheel.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n      <gravity>1</gravity>\n    </link>\n    <link name='bl_caster_r_wheel_link'>\n      <self_collide>0</self_collide>\n      <pose>-0.224600 0.175600 0.079200 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.440360</mass>\n        <inertia>\n          <ixx>0.012412</ixx>\n          <ixy>0.000712</ixy>\n          <ixz>0.000503</ixz>\n          <iyy>0.015218</iyy>\n          <iyz>0.000004</iyz>\n          <izz>0.011764</izz>\n        </inertia>\n      </inertial>\n      <collision name='bl_caster_r_wheel_link_geom'>\n        <pose>0.000000 0.000000 0.000000 1.570800 0.000000 0.000000</pose>\n        <geometry>\n          <cylinder>\n            <radius>0.074792</radius>\n            <length>0.034000</length>\n          </cylinder>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='bl_caster_r_wheel_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/base_v0/wheel.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n      <gravity>1</gravity>\n    </link>\n    <link name='br_caster_rotation_link'>\n      <self_collide>0</self_collide>\n      <pose>-0.224600 -0.224600 0.079200 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>3.473080</mass>\n        <pose>0.000000 0.000000 0.070000 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.012412</ixx>\n          <ixy>-0.000712</ixy>\n          <ixz>0.000503</ixz>\n          <iyy>0.015218</iyy>\n          <iyz>-0.000004</iyz>\n          <izz>0.011764</izz>\n        </inertia>\n      </inertial>\n      <collision name='br_caster_rotation_link_geom'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/base_v0/caster_L.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='br_caster_rotation_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/base_v0/caster.stl</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n      <gravity>1</gravity>\n    </link>\n    <link name='br_caster_l_wheel_link'>\n      <self_collide>0</self_collide>\n      <pose>-0.224600 -0.175600 0.079200 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.440360</mass>\n        <inertia>\n          <ixx>0.012412</ixx>\n          <ixy>-0.000712</ixy>\n          <ixz>0.000503</ixz>\n          <iyy>0.015218</iyy>\n          <iyz>-0.000004</iyz>\n          <izz>0.011764</izz>\n        </inertia>\n      </inertial>\n      <collision name='br_caster_l_wheel_link_geom'>\n        <pose>0.000000 0.000000 0.000000 1.570800 0.000000 0.000000</pose>\n        <geometry>\n          <cylinder>\n            <radius>0.074792</radius>\n            <length>0.034000</length>\n          </cylinder>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='br_caster_l_wheel_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/base_v0/wheel.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n      <gravity>1</gravity>\n    </link>\n    <link name='br_caster_r_wheel_link'>\n      <self_collide>0</self_collide>\n      <pose>-0.224600 -0.273600 0.079200 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.440360</mass>\n        <inertia>\n          <ixx>0.012412</ixx>\n          <ixy>-0.000712</ixy>\n          <ixz>0.000503</ixz>\n          <iyy>0.015218</iyy>\n          <iyz>-0.000004</iyz>\n          <izz>0.011764</izz>\n        </inertia>\n      </inertial>\n      <collision name='br_caster_r_wheel_link_geom'>\n        <pose>0.000000 0.000000 0.000000 1.570800 0.000000 0.000000</pose>\n        <geometry>\n          <cylinder>\n            <radius>0.074792</radius>\n            <length>0.034000</length>\n          </cylinder>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='br_caster_r_wheel_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/base_v0/wheel.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n      <gravity>1</gravity>\n    </link>\n    <link name='fl_caster_rotation_link'>\n      <self_collide>0</self_collide>\n      <pose>0.224600 0.224600 0.079200 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>3.473080</mass>\n        <pose>0.000000 0.000000 0.070000 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.012412</ixx>\n          <ixy>-0.000712</ixy>\n          <ixz>0.000503</ixz>\n          <iyy>0.015218</iyy>\n          <iyz>-0.000004</iyz>\n          <izz>0.011764</izz>\n        </inertia>\n      </inertial>\n      <collision name='fl_caster_rotation_link_geom'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/base_v0/caster_L.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='fl_caster_rotation_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/base_v0/caster.stl</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n      <gravity>1</gravity>\n    </link>\n    <link name='fl_caster_l_wheel_link'>\n      <self_collide>0</self_collide>\n      <pose>0.224600 0.273600 0.079200 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.440360</mass>\n        <inertia>\n          <ixx>0.012412</ixx>\n          <ixy>-0.000712</ixy>\n          <ixz>0.000503</ixz>\n          <iyy>0.015218</iyy>\n          <iyz>-0.000004</iyz>\n          <izz>0.011764</izz>\n        </inertia>\n      </inertial>\n      <collision name='fl_caster_l_wheel_link_geom'>\n        <pose>0.000000 0.000000 0.000000 1.570800 0.000000 0.000000</pose>\n        <geometry>\n          <cylinder>\n            <radius>0.074792</radius>\n            <length>0.034000</length>\n          </cylinder>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='fl_caster_l_wheel_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/base_v0/wheel.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n      <gravity>1</gravity>\n    </link>\n    <link name='fl_caster_r_wheel_link'>\n      <self_collide>0</self_collide>\n      <pose>0.224600 0.175600 0.079200 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.440360</mass>\n        <inertia>\n          <ixx>0.012412</ixx>\n          <ixy>-0.000712</ixy>\n          <ixz>0.000503</ixz>\n          <iyy>0.015218</iyy>\n          <iyz>-0.000004</iyz>\n          <izz>0.011764</izz>\n        </inertia>\n      </inertial>\n      <collision name='fl_caster_r_wheel_link_geom'>\n        <pose>0.000000 0.000000 0.000000 1.570800 0.000000 0.000000</pose>\n        <geometry>\n          <cylinder>\n            <radius>0.074792</radius>\n            <length>0.034000</length>\n          </cylinder>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='fl_caster_r_wheel_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/base_v0/wheel.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n      <gravity>1</gravity>\n    </link>\n    <link name='fr_caster_rotation_link'>\n      <self_collide>0</self_collide>\n      <pose>0.224600 -0.224600 0.079200 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>3.473080</mass>\n        <pose>0.000000 0.000000 0.070000 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.012412</ixx>\n          <ixy>-0.000712</ixy>\n          <ixz>0.000503</ixz>\n          <iyy>0.015218</iyy>\n          <iyz>-0.000004</iyz>\n          <izz>0.011764</izz>\n        </inertia>\n      </inertial>\n      <collision name='fr_caster_rotation_link_geom'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/base_v0/caster_L.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='fr_caster_rotation_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/base_v0/caster.stl</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n      <gravity>1</gravity>\n    </link>\n    <link name='fr_caster_l_wheel_link'>\n      <self_collide>0</self_collide>\n      <pose>0.224600 -0.175600 0.079200 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.440360</mass>\n        <inertia>\n          <ixx>0.012412</ixx>\n          <ixy>-0.000712</ixy>\n          <ixz>0.000503</ixz>\n          <iyy>0.015218</iyy>\n          <iyz>-0.000004</iyz>\n          <izz>0.011764</izz>\n        </inertia>\n      </inertial>\n      <collision name='fr_caster_l_wheel_link_geom'>\n        <pose>0.000000 0.000000 0.000000 1.570800 0.000000 0.000000</pose>\n        <geometry>\n          <cylinder>\n            <radius>0.074792</radius>\n            <length>0.034000</length>\n          </cylinder>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='fr_caster_l_wheel_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/base_v0/wheel.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n      <gravity>1</gravity>\n    </link>\n    <link name='fr_caster_r_wheel_link'>\n      <self_collide>0</self_collide>\n      <pose>0.224600 -0.273600 0.079200 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.440360</mass>\n        <inertia>\n          <ixx>0.012412</ixx>\n          <ixy>-0.000712</ixy>\n          <ixz>0.000503</ixz>\n          <iyy>0.015218</iyy>\n          <iyz>-0.000004</iyz>\n          <izz>0.011764</izz>\n        </inertia>\n      </inertial>\n      <collision name='fr_caster_r_wheel_link_geom'>\n        <pose>0.000000 0.000000 0.000000 1.570800 0.000000 0.000000</pose>\n        <geometry>\n          <cylinder>\n            <radius>0.074792</radius>\n            <length>0.034000</length>\n          </cylinder>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='fr_caster_r_wheel_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/base_v0/wheel.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n      <gravity>1</gravity>\n    </link>\n    <link name='torso_lift_link'>\n      <self_collide>0</self_collide>\n      <pose>-0.050000 0.000000 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>36.449000</mass>\n        <pose>-0.099499 -0.000004 -0.086764 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>2.792330</ixx>\n          <ixy>0.004280</ixy>\n          <ixz>-0.160631</ixz>\n          <iyy>2.521060</iyy>\n          <iyz>0.029689</iyz>\n          <izz>0.536551</izz>\n        </inertia>\n      </inertial>\n      <collision name='torso_lift_link_geom'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/torso_v0/torso_lift_L.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='torso_lift_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/torso_v0/torso_lift.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <sensor name='torso_lift_contact_sensor' type='contact'>\n        <update_rate>100.000000</update_rate>\n        <always_on>0</always_on>\n        <visualize>0</visualize>\n        <contact>\n          <collision>torso_lift_link_geom</collision>\n          <topic>__default_topic__</topic>\n        </contact>\n      </sensor>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n      <gravity>1</gravity>\n    </link>\n    <link name='head_pan_link'>\n      <self_collide>0</self_collide>\n      <pose>-0.067070 0.000000 1.172130 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>6.339000</mass>\n        <pose>0.010907 0.031693 0.090507 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.032498</ixx>\n          <ixy>0.000636</ixy>\n          <ixz>0.002585</ixz>\n          <iyy>0.046546</iyy>\n          <iyz>-0.002453</iyz>\n          <izz>0.057653</izz>\n        </inertia>\n      </inertial>\n      <collision name='head_pan_link_geom'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/head_v0/head_pan_L.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='head_pan_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/head_v0/head_pan.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n      <gravity>1</gravity>\n    </link>\n    <link name='head_tilt_link'>\n      <projector name='projector_wg6802418_projector_wg6802418'>\n        <texture>stereo_projection_pattern_high_res_red.png</texture>\n        <fov>0.959931</fov>\n        <near_clip>0.100000</near_clip>\n        <far_clip>10.000000</far_clip>\n        <pose>0.023200 0.110000 0.119100 0.000000 -1.570793 0.000000</pose>\n      </projector>\n      <self_collide>0</self_collide>\n      <pose>0.000930 0.000000 1.172130 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>5.319000</mass>\n        <pose>-0.005151 -0.014635 0.072819 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.126134</ixx>\n          <ixy>0.000237</ixy>\n          <ixz>0.011881</ixz>\n          <iyy>0.165102</iyy>\n          <iyz>0.001606</iyz>\n          <izz>0.166947</izz>\n        </inertia>\n      </inertial>\n      <collision name='head_tilt_link_geom'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/head_v0/head_tilt_L.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='head_tilt_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/head_v0/head_tilt.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <collision name='head_tilt_link_geom_head_mount_kinect_ir_link'>\n        <pose>-0.147067 0.012500 0.291953 0.000000 0.000000 0.000000</pose>\n        <geometry>\n          <sphere>\n            <radius>0.000500</radius>\n          </sphere>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='head_tilt_link_geom_head_mount_kinect_ir_link_visual'>\n        <pose>-0.147067 0.012500 0.291953 0.000000 0.000000 0.000000</pose>\n        <geometry>\n          <sphere>\n            <radius>0.000250</radius>\n          </sphere>\n        </geometry>\n        <material>\n          <script>\n            <uri>__default__</uri>\n            <name>__default__</name>\n          </script>\n        </material>\n      </visual>\n      <collision name='head_tilt_link_geom_head_mount_kinect_rgb_link'>\n        <pose>-0.147067 0.017500 0.291953 0.000000 0.000000 0.000000</pose>\n        <geometry>\n          <sphere>\n            <radius>0.000500</radius>\n          </sphere>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='head_tilt_link_geom_head_mount_kinect_rgb_link_visual'>\n        <pose>-0.147067 0.017500 0.291953 0.000000 0.000000 0.000000</pose>\n        <geometry>\n          <sphere>\n            <radius>0.000250</radius>\n          </sphere>\n        </geometry>\n        <material>\n          <script>\n            <uri>__default__</uri>\n            <name>__default__</name>\n          </script>\n        </material>\n      </visual>\n      <collision name='head_tilt_link_geom_head_mount_link'>\n        <pose>-0.114800 0.000000 0.155500 0.000000 0.000000 0.000000</pose>\n        <geometry>\n          <sphere>\n            <radius>0.000500</radius>\n          </sphere>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='head_tilt_link_geom_head_mount_link_visual'>\n        <pose>-0.114800 0.000000 0.155500 0.000000 0.000000 0.000000</pose>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/sensors/kinect_prosilica_v0/115x100_swept_back--coarse.STL</uri>\n            <scale>0.001000 0.001000 0.001000</scale>\n          </mesh>\n        </geometry>\n      </visual>\n      <collision name='head_tilt_link_geom_head_mount_prosilica_link'>\n        <pose>-0.161257 0.012500 0.244421 0.000000 0.000000 0.000000</pose>\n        <geometry>\n          <sphere>\n            <radius>0.000500</radius>\n          </sphere>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='head_tilt_link_geom_head_mount_prosilica_link_visual'>\n        <pose>-0.161257 0.012500 0.244421 0.000000 0.000000 0.000000</pose>\n        <geometry>\n          <sphere>\n            <radius>0.000250</radius>\n          </sphere>\n        </geometry>\n        <material>\n          <script>\n            <uri>__default__</uri>\n            <name>__default__</name>\n          </script>\n        </material>\n      </visual>\n      <collision name='head_tilt_link_geom_head_plate_frame'>\n        <pose>0.023200 0.000000 0.064500 0.000000 0.000000 0.000000</pose>\n        <geometry>\n          <box>\n            <size>0.010000 0.010000 0.010000</size>\n          </box>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='head_tilt_link_geom_head_plate_frame_visual'>\n        <pose>0.023200 0.000000 0.064500 0.000000 0.000000 0.000000</pose>\n        <geometry>\n          <box>\n            <size>0.010000 0.010000 0.010000</size>\n          </box>\n        </geometry>\n        <material>\n          <script>\n            <uri>__default__</uri>\n            <name>__default__</name>\n          </script>\n        </material>\n      </visual>\n      <sensor name='head_mount_sensor' type='camera'>\n        <always_on>0</always_on>\n        <visualize>0</visualize>\n        <update_rate>1.000000</update_rate>\n        <pose>-0.147067 0.012500 0.291953 0.000000 0.000000 0.000000</pose>\n        <camera name='__default__'>\n          <horizontal_fov>0.994838</horizontal_fov>\n          <image>\n            <width>640</width>\n            <height>480</height>\n            <format>L8</format>\n          </image>\n          <clip>\n            <near>0.010000</near>\n            <far>5.000000</far>\n          </clip>\n        </camera>\n      </sensor>\n      <sensor name='head_mount_prosilica_link_sensor' type='camera'>\n        <update_rate>1.000000</update_rate>\n        <pose>-0.161257 0.012500 0.244421 0.000000 0.000000 0.000000</pose>\n        <always_on>0</always_on>\n        <visualize>0</visualize>\n        <camera name='__default__'>\n          <horizontal_fov>1.120501</horizontal_fov>\n          <image>\n            <width>320</width>\n            <height>240</height>\n            <format>R8G8B8</format>\n          </image>\n          <clip>\n            <near>0.100000</near>\n            <far>100.000000</far>\n          </clip>\n        </camera>\n      </sensor>\n      <sensor name='head_mount_prosilica_link_sim_pcd_sensor' type='camera'>\n        <update_rate>1.000000</update_rate>\n        <pose>-0.161257 0.012500 0.244421 0.000000 0.000000 0.000000</pose>\n        <always_on>0</always_on>\n        <visualize>0</visualize>\n        <camera name='__default__'>\n          <horizontal_fov>1.120501</horizontal_fov>\n          <image>\n            <width>320</width>\n            <height>240</height>\n            <format>R8G8B8</format>\n          </image>\n          <clip>\n            <near>0.100000</near>\n            <far>100.000000</far>\n          </clip>\n        </camera>\n      </sensor>\n      <sensor name='narrow_stereo_gazebo_l_stereo_camera_sensor' type='camera'>\n        <always_on>0</always_on>\n        <visualize>0</visualize>\n        <update_rate>25.000000</update_rate>\n        <pose>0.068200 0.060000 0.114600 0.000000 0.000000 0.000000</pose>\n        <camera name='__default__'>\n          <horizontal_fov>0.785398</horizontal_fov>\n          <image>\n            <width>640</width>\n            <height>480</height>\n            <format>L8</format>\n          </image>\n          <clip>\n            <near>0.100000</near>\n            <far>100.000000</far>\n          </clip>\n        </camera>\n      </sensor>\n      <sensor name='narrow_stereo_gazebo_r_stereo_camera_sensor' type='camera'>\n        <always_on>0</always_on>\n        <visualize>0</visualize>\n        <update_rate>25.000000</update_rate>\n        <pose>0.068200 -0.030000 0.114600 0.000000 0.000000 0.000000</pose>\n        <camera name='__default__'>\n          <horizontal_fov>0.785398</horizontal_fov>\n          <image>\n            <width>640</width>\n            <height>480</height>\n            <format>L8</format>\n          </image>\n          <clip>\n            <near>0.100000</near>\n            <far>100.000000</far>\n          </clip>\n        </camera>\n      </sensor>\n      <sensor name='wide_stereo_gazebo_l_stereo_camera_sensor' type='camera'>\n        <update_rate>25.000000</update_rate>\n        <pose>0.068200 0.030000 0.114600 0.000000 0.000000 0.000000</pose>\n        <always_on>0</always_on>\n        <visualize>0</visualize>\n        <camera name='__default__'>\n          <horizontal_fov>1.570796</horizontal_fov>\n          <image>\n            <width>640</width>\n            <height>480</height>\n            <format>BAYER_BGGR8</format>\n          </image>\n          <clip>\n            <near>0.100000</near>\n            <far>100.000000</far>\n          </clip>\n        </camera>\n      </sensor>\n      <sensor name='wide_stereo_gazebo_r_stereo_camera_sensor' type='camera'>\n        <update_rate>25.000000</update_rate>\n        <pose>0.068200 -0.060000 0.114600 0.000000 0.000000 0.000000</pose>\n        <always_on>0</always_on>\n        <visualize>0</visualize>\n        <camera name='__default__'>\n          <horizontal_fov>1.570796</horizontal_fov>\n          <image>\n            <width>640</width>\n            <height>480</height>\n            <format>BAYER_BGGR8</format>\n          </image>\n          <clip>\n            <near>0.100000</near>\n            <far>100.000000</far>\n          </clip>\n        </camera>\n      </sensor>\n      <sensor name='high_def_sensor' type='camera'>\n        <update_rate>20.000000</update_rate>\n        <pose>0.069657 -0.110000 0.119100 0.000000 0.000000 0.000000</pose>\n        <always_on>0</always_on>\n        <visualize>0</visualize>\n        <camera name='__default__'>\n          <horizontal_fov>0.785398</horizontal_fov>\n          <image>\n            <width>2448</width>\n            <height>2050</height>\n            <format>R8G8B8</format>\n          </image>\n          <clip>\n            <near>0.100000</near>\n            <far>100.000000</far>\n          </clip>\n        </camera>\n      </sensor>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n      <gravity>1</gravity>\n    </link>\n    <link name='l_shoulder_pan_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>-0.050000 0.188000 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>25.799300</mass>\n        <pose>-0.001201 0.024513 -0.098231 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.866179</ixx>\n          <ixy>-0.060865</ixy>\n          <ixz>-0.121181</ixz>\n          <iyy>0.874217</iyy>\n          <iyz>-0.058866</iyz>\n          <izz>0.273538</izz>\n        </inertia>\n      </inertial>\n      <collision name='l_shoulder_pan_link_geom'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/shoulder_v0/shoulder_pan.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='l_shoulder_pan_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/shoulder_v0/shoulder_pan.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='l_shoulder_lift_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.050000 0.188000 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>2.749880</mass>\n        <pose>0.021950 -0.026640 -0.031270 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.021056</ixx>\n          <ixy>0.004967</ixy>\n          <ixz>-0.001948</ixz>\n          <iyy>0.021272</iyy>\n          <iyz>0.001104</iyz>\n          <izz>0.019758</izz>\n        </inertia>\n      </inertial>\n      <collision name='l_shoulder_lift_link_geom'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/shoulder_v0/shoulder_lift.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='l_shoulder_lift_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/shoulder_v0/shoulder_lift.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='l_upper_arm_roll_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.050000 0.188000 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>6.117690</mass>\n        <pose>0.210551 0.016309 -0.000561 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.025306</ixx>\n          <ixy>-0.003393</ixy>\n          <ixz>0.000608</ixz>\n          <iyy>0.084737</iyy>\n          <iyz>-0.000200</iyz>\n          <izz>0.086016</izz>\n        </inertia>\n      </inertial>\n      <collision name='l_upper_arm_roll_link_geom'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/shoulder_v0/upper_arm_roll_L.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='l_upper_arm_roll_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/shoulder_v0/upper_arm_roll.stl</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <collision name='l_upper_arm_roll_link_geom_l_upper_arm_link'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/upper_arm_v0/upper_arm.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='l_upper_arm_roll_link_geom_l_upper_arm_link_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/upper_arm_v0/upper_arm.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='l_elbow_flex_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.450000 0.188000 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>1.903270</mass>\n        <pose>0.010140 0.000320 -0.012110 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.003465</ixx>\n          <ixy>0.000041</ixy>\n          <ixz>0.000432</ixz>\n          <iyy>0.004416</iyy>\n          <iyz>-0.000040</iyz>\n          <izz>0.003592</izz>\n        </inertia>\n      </inertial>\n      <collision name='l_elbow_flex_link_geom'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/upper_arm_v0/elbow_flex.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='l_elbow_flex_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/upper_arm_v0/elbow_flex.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='l_forearm_roll_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.450000 0.188000 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>2.689680</mass>\n        <pose>0.180727 -0.000163 -0.008583 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.014668</ixx>\n          <ixy>0.000052</ixy>\n          <ixz>0.000656</ixz>\n          <iyy>0.026279</iyy>\n          <iyz>-0.000013</iyz>\n          <izz>0.027775</izz>\n        </inertia>\n      </inertial>\n      <collision name='l_forearm_roll_link_geom'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/upper_arm_v0/forearm_roll_L.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='l_forearm_roll_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/upper_arm_v0/forearm_roll.stl</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <collision name='l_forearm_roll_link_geom_l_forearm_link'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/forearm_v0/forearm.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='l_forearm_roll_link_geom_l_forearm_link_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/forearm_v0/forearm.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <sensor name='l_forearm_cam_sensor' type='camera'>\n        <update_rate>25.000000</update_rate>\n        <pose>0.135000 0.000000 0.044000 -1.570800 -0.562869 0.000000</pose>\n        <always_on>0</always_on>\n        <visualize>0</visualize>\n        <camera name='__default__'>\n          <horizontal_fov>1.570796</horizontal_fov>\n          <image>\n            <width>640</width>\n            <height>480</height>\n            <format>R8G8B8</format>\n          </image>\n          <clip>\n            <near>0.100000</near>\n            <far>100.000000</far>\n          </clip>\n        </camera>\n      </sensor>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='l_wrist_flex_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.771000 0.188000 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.614020</mass>\n        <pose>-0.001570 0.000000 -0.000750 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.000652</ixx>\n          <ixy>0.000000</ixy>\n          <ixz>0.000003</ixz>\n          <iyy>0.000198</iyy>\n          <iyz>0.000000</iyz>\n          <izz>0.000645</izz>\n        </inertia>\n      </inertial>\n      <collision name='l_wrist_flex_link_geom'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/forearm_v0/wrist_flex.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='l_wrist_flex_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/forearm_v0/wrist_flex.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='l_wrist_roll_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.771000 0.188000 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.681070</mass>\n        <pose>0.056408 0.000451 -0.001014 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.011352</ixx>\n          <ixy>-0.000016</ixy>\n          <ixz>-0.000001</ixz>\n          <iyy>0.011677</iyy>\n          <iyz>-0.000001</iyz>\n          <izz>0.011866</izz>\n        </inertia>\n      </inertial>\n      <collision name='l_wrist_roll_link_geom'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/forearm_v0/wrist_roll_L.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='l_wrist_roll_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/forearm_v0/wrist_roll.stl</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <collision name='l_wrist_roll_link_geom_l_gripper_motor_accelerometer_link'>\n        <geometry>\n          <box>\n            <size>0.001000 0.001000 0.001000</size>\n          </box>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='l_wrist_roll_link_geom_l_gripper_motor_accelerometer_link_visual'>\n        <geometry>\n          <box>\n            <size>0.001000 0.001000 0.001000</size>\n          </box>\n        </geometry>\n      </visual>\n      <collision name='l_wrist_roll_link_geom_l_gripper_palm_link'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/gripper_v0/gripper_palm.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='l_wrist_roll_link_geom_l_gripper_palm_link_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/gripper_v0/gripper_palm.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='l_gripper_l_finger_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.847910 0.198000 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.171260</mass>\n        <pose>0.035980 0.017300 -0.001640 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.000078</ixx>\n          <ixy>0.000001</ixy>\n          <ixz>-0.000010</ixz>\n          <iyy>0.000197</iyy>\n          <iyz>-0.000003</iyz>\n          <izz>0.000181</izz>\n        </inertia>\n      </inertial>\n      <collision name='l_gripper_l_finger_link_geom'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/gripper_v0/l_finger.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <friction>\n            <ode>\n              <mu>500.000000</mu>\n              <mu2>500.000000</mu2>\n              <slip1>0.000000</slip1>\n              <slip2>0.000000</slip2>\n            </ode>\n          </friction>\n          <contact>\n            <ode>\n              <kp>1000000.000000</kp>\n              <kd>1.000000</kd>\n              <max_vel>100.000000</max_vel>\n              <min_depth>0.000000</min_depth>\n            </ode>\n          </contact>\n          <bounce/>\n        </surface>\n      </collision>\n      <visual name='l_gripper_l_finger_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/gripper_v0/l_finger.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='l_gripper_l_finger_tip_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.939280 0.202950 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.044190</mass>\n        <pose>0.004230 0.002840 0.000000 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.000008</ixx>\n          <ixy>0.000006</ixy>\n          <ixz>0.000000</ixz>\n          <iyy>0.000010</iyy>\n          <iyz>0.000000</iyz>\n          <izz>0.000015</izz>\n        </inertia>\n      </inertial>\n      <collision name='l_gripper_l_finger_tip_link_geom'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/gripper_v0/l_finger_tip.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <friction>\n            <ode>\n              <mu>500.000000</mu>\n              <mu2>500.000000</mu2>\n              <slip1>0.000000</slip1>\n              <slip2>0.000000</slip2>\n            </ode>\n          </friction>\n          <contact>\n            <ode>\n              <kp>10000000.000000</kp>\n              <kd>1.000000</kd>\n              <max_vel>100.000000</max_vel>\n              <min_depth>0.000000</min_depth>\n            </ode>\n          </contact>\n          <bounce/>\n        </surface>\n      </collision>\n      <visual name='l_gripper_l_finger_tip_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/gripper_v0/l_finger_tip.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <sensor name='l_gripper_l_finger_tip_contact_sensor' type='contact'>\n        <update_rate>100.000000</update_rate>\n        <always_on>0</always_on>\n        <visualize>0</visualize>\n        <contact>\n          <collision>l_gripper_l_finger_tip_link_geom</collision>\n          <topic>__default_topic__</topic>\n        </contact>\n      </sensor>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='l_gripper_motor_slider_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.939280 0.188000 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.010000</mass>\n        <inertia>\n          <ixx>0.001000</ixx>\n          <ixy>0.000000</ixy>\n          <ixz>0.000000</ixz>\n          <iyy>0.001000</iyy>\n          <iyz>0.000000</iyz>\n          <izz>0.001000</izz>\n        </inertia>\n      </inertial>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='l_gripper_motor_screw_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.939280 0.188000 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.010000</mass>\n        <inertia>\n          <ixx>0.000100</ixx>\n          <ixy>0.000000</ixy>\n          <ixz>0.000000</ixz>\n          <iyy>0.000100</iyy>\n          <iyz>0.000000</iyz>\n          <izz>0.000100</izz>\n        </inertia>\n      </inertial>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='l_gripper_r_finger_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.847910 0.178000 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.173890</mass>\n        <pose>0.035760 -0.017360 -0.000950 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.000077</ixx>\n          <ixy>-0.000002</ixy>\n          <ixz>-0.000008</ixz>\n          <iyy>0.000198</iyy>\n          <iyz>0.000002</iyz>\n          <izz>0.000181</izz>\n        </inertia>\n      </inertial>\n      <collision name='l_gripper_r_finger_link_geom'>\n        <pose>0.000000 0.000000 0.000000 -3.141590 0.000000 0.000000</pose>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/gripper_v0/l_finger.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <friction>\n            <ode>\n              <mu>500.000000</mu>\n              <mu2>500.000000</mu2>\n              <slip1>0.000000</slip1>\n              <slip2>0.000000</slip2>\n            </ode>\n          </friction>\n          <contact>\n            <ode>\n              <kp>1000000.000000</kp>\n              <kd>1.000000</kd>\n              <max_vel>100.000000</max_vel>\n              <min_depth>0.000000</min_depth>\n            </ode>\n          </contact>\n          <bounce/>\n        </surface>\n      </collision>\n      <visual name='l_gripper_r_finger_link_geom_visual'>\n        <pose>0.000000 0.000000 0.000000 -3.141590 0.000000 0.000000</pose>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/gripper_v0/l_finger.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='l_gripper_r_finger_tip_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.939280 0.173050 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.044190</mass>\n        <pose>0.004230 -0.002840 0.000000 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.000008</ixx>\n          <ixy>-0.000006</ixy>\n          <ixz>0.000000</ixz>\n          <iyy>0.000010</iyy>\n          <iyz>0.000000</iyz>\n          <izz>0.000015</izz>\n        </inertia>\n      </inertial>\n      <collision name='l_gripper_r_finger_tip_link_geom'>\n        <pose>0.000000 0.000000 0.000000 -3.141590 0.000000 0.000000</pose>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/gripper_v0/l_finger_tip.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <friction>\n            <ode>\n              <mu>500.000000</mu>\n              <mu2>500.000000</mu2>\n              <slip1>0.000000</slip1>\n              <slip2>0.000000</slip2>\n            </ode>\n          </friction>\n          <contact>\n            <ode>\n              <kp>10000000.000000</kp>\n              <kd>1.000000</kd>\n              <max_vel>100.000000</max_vel>\n              <min_depth>0.000000</min_depth>\n            </ode>\n          </contact>\n          <bounce/>\n        </surface>\n      </collision>\n      <visual name='l_gripper_r_finger_tip_link_geom_visual'>\n        <pose>0.000000 0.000000 0.000000 -3.141590 0.000000 0.000000</pose>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/gripper_v0/l_finger_tip.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <sensor name='l_gripper_r_finger_tip_contact_sensor' type='contact'>\n        <update_rate>100.000000</update_rate>\n        <always_on>0</always_on>\n        <visualize>0</visualize>\n        <contact>\n          <collision>l_gripper_r_finger_tip_link_geom</collision>\n          <topic>__default_topic__</topic>\n        </contact>\n      </sensor>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='laser_tilt_mount_link'>\n      <self_collide>0</self_collide>\n      <pose>0.048930 0.000000 1.017680 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.592000</mass>\n        <pose>-0.001134 0.001667 -0.007067 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.001296</ixx>\n          <ixy>0.000023</ixy>\n          <ixz>0.000037</ixz>\n          <iyy>0.001086</iyy>\n          <iyz>0.000035</iyz>\n          <izz>0.000895</izz>\n        </inertia>\n      </inertial>\n      <collision name='laser_tilt_mount_link_geom'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/tilting_laser_v0/tilting_hokuyo_L.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <friction>\n            <ode>\n              <mu>0.000000</mu>\n              <mu2>0.000000</mu2>\n              <slip1>0.000000</slip1>\n              <slip2>0.000000</slip2>\n            </ode>\n          </friction>\n          <contact>\n            <ode>\n              <kp>1000000000000.000000</kp>\n              <kd>10000.000000</kd>\n              <max_vel>100.000000</max_vel>\n              <min_depth>0.000000</min_depth>\n            </ode>\n          </contact>\n          <bounce/>\n        </surface>\n      </collision>\n      <visual name='laser_tilt_mount_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/tilting_laser_v0/tilting_hokuyo.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <sensor name='laser_tilt' type='ray'>\n        <update_rate>40.000000</update_rate>\n        <pose>0.000000 0.000000 0.030000 0.000000 0.000000 0.000000</pose>\n        <always_on>0</always_on>\n        <visualize>0</visualize>\n        <ray>\n          <scan>\n            <horizontal>\n              <samples>640</samples>\n              <resolution>1.000000</resolution>\n              <min_angle>-1.396263</min_angle>\n              <max_angle>1.396263</max_angle>\n            </horizontal>\n          </scan>\n          <range>\n            <min>0.080000</min>\n            <max>10.000000</max>\n            <resolution>0.010000</resolution>\n          </range>\n        </ray>\n      </sensor>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n      <gravity>1</gravity>\n    </link>\n    <link name='r_shoulder_pan_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>-0.050000 -0.188000 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>25.799300</mass>\n        <pose>-0.001201 0.024513 -0.098231 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.866179</ixx>\n          <ixy>-0.060865</ixy>\n          <ixz>-0.121181</ixz>\n          <iyy>0.874217</iyy>\n          <iyz>-0.058866</iyz>\n          <izz>0.273538</izz>\n        </inertia>\n      </inertial>\n      <collision name='r_shoulder_pan_link_geom'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/shoulder_v0/shoulder_pan.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <friction>\n            <ode>\n              <mu>0.000000</mu>\n              <mu2>0.000000</mu2>\n              <slip1>0.000000</slip1>\n              <slip2>0.000000</slip2>\n            </ode>\n          </friction>\n          <contact>\n            <ode>\n              <kp>1000000000000.000000</kp>\n              <kd>10000.000000</kd>\n              <max_vel>100.000000</max_vel>\n              <min_depth>0.000000</min_depth>\n            </ode>\n          </contact>\n          <bounce/>\n        </surface>\n      </collision>\n      <visual name='r_shoulder_pan_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/shoulder_v0/shoulder_pan.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='r_shoulder_lift_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.050000 -0.188000 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>2.749880</mass>\n        <pose>0.021950 -0.026640 -0.031270 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.021056</ixx>\n          <ixy>0.004967</ixy>\n          <ixz>-0.001948</ixz>\n          <iyy>0.021272</iyy>\n          <iyz>0.001104</iyz>\n          <izz>0.019758</izz>\n        </inertia>\n      </inertial>\n      <collision name='r_shoulder_lift_link_geom'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/shoulder_v0/shoulder_lift.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <friction>\n            <ode>\n              <mu>0.000000</mu>\n              <mu2>0.000000</mu2>\n              <slip1>0.000000</slip1>\n              <slip2>0.000000</slip2>\n            </ode>\n          </friction>\n          <contact>\n            <ode>\n              <kp>1000000000000.000000</kp>\n              <kd>10000.000000</kd>\n              <max_vel>100.000000</max_vel>\n              <min_depth>0.000000</min_depth>\n            </ode>\n          </contact>\n          <bounce/>\n        </surface>\n      </collision>\n      <visual name='r_shoulder_lift_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/shoulder_v0/shoulder_lift.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='r_upper_arm_roll_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.050000 -0.188000 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>6.117690</mass>\n        <pose>0.210482 -0.015945 -0.000197 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.025378</ixx>\n          <ixy>0.003757</ixy>\n          <ixz>-0.000709</ixz>\n          <iyy>0.084737</iyy>\n          <iyz>-0.000179</iyz>\n          <izz>0.086088</izz>\n        </inertia>\n      </inertial>\n      <collision name='r_upper_arm_roll_link_geom'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/shoulder_v0/upper_arm_roll_L.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='r_upper_arm_roll_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/shoulder_v0/upper_arm_roll.stl</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <collision name='r_upper_arm_roll_link_geom_r_upper_arm_link'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/upper_arm_v0/upper_arm.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='r_upper_arm_roll_link_geom_r_upper_arm_link_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/upper_arm_v0/upper_arm.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='r_elbow_flex_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.450000 -0.188000 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>1.903270</mass>\n        <pose>0.010140 0.000320 -0.012110 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.003465</ixx>\n          <ixy>0.000041</ixy>\n          <ixz>0.000432</ixz>\n          <iyy>0.004416</iyy>\n          <iyz>-0.000040</iyz>\n          <izz>0.003592</izz>\n        </inertia>\n      </inertial>\n      <collision name='r_elbow_flex_link_geom'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/upper_arm_v0/elbow_flex.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='r_elbow_flex_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/upper_arm_v0/elbow_flex.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='r_forearm_roll_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.450000 -0.188000 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>2.689680</mass>\n        <pose>0.180727 -0.000163 -0.008583 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.014668</ixx>\n          <ixy>0.000052</ixy>\n          <ixz>0.000656</ixz>\n          <iyy>0.026279</iyy>\n          <iyz>-0.000013</iyz>\n          <izz>0.027775</izz>\n        </inertia>\n      </inertial>\n      <collision name='r_forearm_roll_link_geom'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/upper_arm_v0/forearm_roll_L.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='r_forearm_roll_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/upper_arm_v0/forearm_roll.stl</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <collision name='r_forearm_roll_link_geom_r_forearm_link'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/forearm_v0/forearm.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='r_forearm_roll_link_geom_r_forearm_link_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/forearm_v0/forearm.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <sensor name='r_forearm_cam_sensor' type='camera'>\n        <update_rate>25.000000</update_rate>\n        <pose>0.135000 0.000000 0.044000 1.570800 -0.562869 -0.000000</pose>\n        <always_on>0</always_on>\n        <visualize>0</visualize>\n        <camera name='__default__'>\n          <horizontal_fov>1.570796</horizontal_fov>\n          <image>\n            <width>640</width>\n            <height>480</height>\n            <format>R8G8B8</format>\n          </image>\n          <clip>\n            <near>0.100000</near>\n            <far>100.000000</far>\n          </clip>\n        </camera>\n      </sensor>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='r_wrist_flex_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.771000 -0.188000 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.614020</mass>\n        <pose>-0.001570 0.000000 -0.000750 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.000652</ixx>\n          <ixy>0.000000</ixy>\n          <ixz>0.000003</ixz>\n          <iyy>0.000198</iyy>\n          <iyz>0.000000</iyz>\n          <izz>0.000645</izz>\n        </inertia>\n      </inertial>\n      <collision name='r_wrist_flex_link_geom'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/forearm_v0/wrist_flex.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='r_wrist_flex_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/forearm_v0/wrist_flex.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='r_wrist_roll_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.771000 -0.188000 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.681070</mass>\n        <pose>0.056408 0.000451 -0.001014 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.011352</ixx>\n          <ixy>-0.000016</ixy>\n          <ixz>-0.000001</ixz>\n          <iyy>0.011677</iyy>\n          <iyz>-0.000001</iyz>\n          <izz>0.011866</izz>\n        </inertia>\n      </inertial>\n      <collision name='r_wrist_roll_link_geom'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/forearm_v0/wrist_roll_L.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='r_wrist_roll_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/forearm_v0/wrist_roll.stl</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <collision name='r_wrist_roll_link_geom_r_gripper_motor_accelerometer_link'>\n        <geometry>\n          <box>\n            <size>0.001000 0.001000 0.001000</size>\n          </box>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='r_wrist_roll_link_geom_r_gripper_motor_accelerometer_link_visual'>\n        <geometry>\n          <box>\n            <size>0.001000 0.001000 0.001000</size>\n          </box>\n        </geometry>\n      </visual>\n      <collision name='r_wrist_roll_link_geom_r_gripper_palm_link'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/gripper_v0/gripper_palm.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='r_wrist_roll_link_geom_r_gripper_palm_link_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/gripper_v0/gripper_palm.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='r_gripper_l_finger_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.847910 -0.178000 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.171260</mass>\n        <pose>0.035980 0.017300 -0.001640 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.000078</ixx>\n          <ixy>0.000001</ixy>\n          <ixz>0.000010</ixz>\n          <iyy>0.000197</iyy>\n          <iyz>-0.000003</iyz>\n          <izz>0.000181</izz>\n        </inertia>\n      </inertial>\n      <collision name='r_gripper_l_finger_link_geom'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/gripper_v0/l_finger.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <friction>\n            <ode>\n              <mu>500.000000</mu>\n              <mu2>500.000000</mu2>\n              <slip1>0.000000</slip1>\n              <slip2>0.000000</slip2>\n            </ode>\n          </friction>\n          <contact>\n            <ode>\n              <kp>1000000.000000</kp>\n              <kd>1.000000</kd>\n              <max_vel>100.000000</max_vel>\n              <min_depth>0.000000</min_depth>\n            </ode>\n          </contact>\n          <bounce/>\n        </surface>\n      </collision>\n      <visual name='r_gripper_l_finger_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/gripper_v0/l_finger.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='r_gripper_l_finger_tip_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.939280 -0.173050 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.044190</mass>\n        <pose>0.004230 0.002840 0.000000 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.000008</ixx>\n          <ixy>0.000006</ixy>\n          <ixz>0.000000</ixz>\n          <iyy>0.000010</iyy>\n          <iyz>0.000000</iyz>\n          <izz>0.000015</izz>\n        </inertia>\n      </inertial>\n      <collision name='r_gripper_l_finger_tip_link_geom'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/gripper_v0/l_finger_tip.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <friction>\n            <ode>\n              <mu>500.000000</mu>\n              <mu2>500.000000</mu2>\n              <slip1>0.000000</slip1>\n              <slip2>0.000000</slip2>\n            </ode>\n          </friction>\n          <contact>\n            <ode>\n              <kp>10000000.000000</kp>\n              <kd>1.000000</kd>\n              <max_vel>100.000000</max_vel>\n              <min_depth>0.000000</min_depth>\n            </ode>\n          </contact>\n          <bounce/>\n        </surface>\n      </collision>\n      <visual name='r_gripper_l_finger_tip_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/gripper_v0/l_finger_tip.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <sensor name='r_gripper_l_finger_tip_contact_sensor' type='contact'>\n        <update_rate>100.000000</update_rate>\n        <always_on>0</always_on>\n        <visualize>0</visualize>\n        <contact>\n          <collision>r_gripper_l_finger_tip_link_geom</collision>\n          <topic>__default_topic__</topic>\n        </contact>\n      </sensor>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='r_gripper_motor_slider_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.939280 -0.188000 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.010000</mass>\n        <inertia>\n          <ixx>0.001000</ixx>\n          <ixy>0.000000</ixy>\n          <ixz>0.000000</ixz>\n          <iyy>0.001000</iyy>\n          <iyz>0.000000</iyz>\n          <izz>0.001000</izz>\n        </inertia>\n      </inertial>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='r_gripper_motor_screw_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.939280 -0.188000 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.010000</mass>\n        <inertia>\n          <ixx>0.000100</ixx>\n          <ixy>0.000000</ixy>\n          <ixz>0.000000</ixz>\n          <iyy>0.000100</iyy>\n          <iyz>0.000000</iyz>\n          <izz>0.000100</izz>\n        </inertia>\n      </inertial>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='r_gripper_r_finger_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.847910 -0.198000 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.173890</mass>\n        <pose>0.035760 -0.017360 -0.000950 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.000077</ixx>\n          <ixy>-0.000002</ixy>\n          <ixz>-0.000008</ixz>\n          <iyy>0.000198</iyy>\n          <iyz>0.000002</iyz>\n          <izz>0.000181</izz>\n        </inertia>\n      </inertial>\n      <collision name='r_gripper_r_finger_link_geom'>\n        <pose>0.000000 0.000000 0.000000 -3.141590 0.000000 0.000000</pose>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/gripper_v0/l_finger.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <friction>\n            <ode>\n              <mu>500.000000</mu>\n              <mu2>500.000000</mu2>\n              <slip1>0.000000</slip1>\n              <slip2>0.000000</slip2>\n            </ode>\n          </friction>\n          <contact>\n            <ode>\n              <kp>1000000.000000</kp>\n              <kd>1.000000</kd>\n              <max_vel>100.000000</max_vel>\n              <min_depth>0.000000</min_depth>\n            </ode>\n          </contact>\n          <bounce/>\n        </surface>\n      </collision>\n      <visual name='r_gripper_r_finger_link_geom_visual'>\n        <pose>0.000000 0.000000 0.000000 -3.141590 0.000000 0.000000</pose>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/gripper_v0/l_finger.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='r_gripper_r_finger_tip_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.939280 -0.202950 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.044190</mass>\n        <pose>0.004230 -0.002840 0.000000 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.000008</ixx>\n          <ixy>-0.000006</ixy>\n          <ixz>0.000000</ixz>\n          <iyy>0.000010</iyy>\n          <iyz>0.000000</iyz>\n          <izz>0.000015</izz>\n        </inertia>\n      </inertial>\n      <collision name='r_gripper_r_finger_tip_link_geom'>\n        <pose>0.000000 0.000000 0.000000 -3.141590 0.000000 0.000000</pose>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/gripper_v0/l_finger_tip.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <friction>\n            <ode>\n              <mu>500.000000</mu>\n              <mu2>500.000000</mu2>\n              <slip1>0.000000</slip1>\n              <slip2>0.000000</slip2>\n            </ode>\n          </friction>\n          <contact>\n            <ode>\n              <kp>10000000.000000</kp>\n              <kd>1.000000</kd>\n              <max_vel>100.000000</max_vel>\n              <min_depth>0.000000</min_depth>\n            </ode>\n          </contact>\n          <bounce/>\n        </surface>\n      </collision>\n      <visual name='r_gripper_r_finger_tip_link_geom_visual'>\n        <pose>0.000000 0.000000 0.000000 -3.141590 0.000000 0.000000</pose>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/gripper_v0/l_finger_tip.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <sensor name='r_gripper_r_finger_tip_contact_sensor' type='contact'>\n        <update_rate>100.000000</update_rate>\n        <always_on>0</always_on>\n        <visualize>0</visualize>\n        <contact>\n          <collision>r_gripper_r_finger_tip_link_geom</collision>\n          <topic>__default_topic__</topic>\n        </contact>\n      </sensor>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='torso_lift_motor_screw_link'>\n      <self_collide>0</self_collide>\n      <pose>-0.150000 0.000000 0.751000 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>1.000000</mass>\n        <inertia>\n          <ixx>0.001000</ixx>\n          <ixy>0.000000</ixy>\n          <ixz>0.000000</ixz>\n          <iyy>0.001000</iyy>\n          <iyz>0.000000</iyz>\n          <izz>0.001000</izz>\n        </inertia>\n      </inertial>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n      <gravity>1</gravity>\n    </link>\n    <link name='r_gripper_l_parallel_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.829910 -0.157000 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.171260</mass>\n        <pose>0.035980 0.017300 -0.001640 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.000078</ixx>\n          <ixy>0.000001</ixy>\n          <ixz>-0.000010</ixz>\n          <iyy>0.000197</iyy>\n          <iyz>-0.000003</iyz>\n          <izz>0.000181</izz>\n        </inertia>\n      </inertial>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='r_gripper_r_parallel_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.829910 -0.219000 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.173890</mass>\n        <pose>0.035760 -0.017360 -0.000950 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.000077</ixx>\n          <ixy>-0.000002</ixy>\n          <ixz>-0.000008</ixz>\n          <iyy>0.000198</iyy>\n          <iyz>0.000002</iyz>\n          <izz>0.000181</izz>\n        </inertia>\n      </inertial>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='l_gripper_l_parallel_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.829910 0.219000 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.171260</mass>\n        <pose>0.035980 0.017300 -0.001640 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.000078</ixx>\n          <ixy>0.000001</ixy>\n          <ixz>0.000010</ixz>\n          <iyy>0.000197</iyy>\n          <iyz>-0.000003</iyz>\n          <izz>0.000181</izz>\n        </inertia>\n      </inertial>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='l_gripper_r_parallel_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.829910 0.157000 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.173890</mass>\n        <pose>0.035760 -0.017360 -0.000950 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.000077</ixx>\n          <ixy>-0.000002</ixy>\n          <ixz>0.000008</ixz>\n          <iyy>0.000198</iyy>\n          <iyz>0.000002</iyz>\n          <izz>0.000181</izz>\n        </inertia>\n      </inertial>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <joint name='bl_caster_rotation_joint' type='revolute'>\n      <parent>base_footprint</parent>\n      <child>bl_caster_rotation_link</child>\n      <axis>\n        <xyz>0.000000 0.000000 1.000000</xyz>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='bl_caster_l_wheel_joint' type='revolute'>\n      <parent>bl_caster_rotation_link</parent>\n      <child>bl_caster_l_wheel_link</child>\n      <axis>\n        <xyz>0.000000 1.000000 0.000000</xyz>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='bl_caster_r_wheel_joint' type='revolute'>\n      <parent>bl_caster_rotation_link</parent>\n      <child>bl_caster_r_wheel_link</child>\n      <axis>\n        <xyz>0.000000 1.000000 0.000000</xyz>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='br_caster_rotation_joint' type='revolute'>\n      <parent>base_footprint</parent>\n      <child>br_caster_rotation_link</child>\n      <axis>\n        <xyz>0.000000 0.000000 1.000000</xyz>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='br_caster_l_wheel_joint' type='revolute'>\n      <parent>br_caster_rotation_link</parent>\n      <child>br_caster_l_wheel_link</child>\n      <axis>\n        <xyz>0.000000 1.000000 0.000000</xyz>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='br_caster_r_wheel_joint' type='revolute'>\n      <parent>br_caster_rotation_link</parent>\n      <child>br_caster_r_wheel_link</child>\n      <axis>\n        <xyz>0.000000 1.000000 0.000000</xyz>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='fl_caster_rotation_joint' type='revolute'>\n      <parent>base_footprint</parent>\n      <child>fl_caster_rotation_link</child>\n      <axis>\n        <xyz>0.000000 0.000000 1.000000</xyz>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='fl_caster_l_wheel_joint' type='revolute'>\n      <parent>fl_caster_rotation_link</parent>\n      <child>fl_caster_l_wheel_link</child>\n      <axis>\n        <xyz>0.000000 1.000000 0.000000</xyz>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='fl_caster_r_wheel_joint' type='revolute'>\n      <parent>fl_caster_rotation_link</parent>\n      <child>fl_caster_r_wheel_link</child>\n      <axis>\n        <xyz>0.000000 1.000000 0.000000</xyz>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='fr_caster_rotation_joint' type='revolute'>\n      <parent>base_footprint</parent>\n      <child>fr_caster_rotation_link</child>\n      <axis>\n        <xyz>0.000000 0.000000 1.000000</xyz>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='fr_caster_l_wheel_joint' type='revolute'>\n      <parent>fr_caster_rotation_link</parent>\n      <child>fr_caster_l_wheel_link</child>\n      <axis>\n        <xyz>0.000000 1.000000 0.000000</xyz>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='fr_caster_r_wheel_joint' type='revolute'>\n      <parent>fr_caster_rotation_link</parent>\n      <child>fr_caster_r_wheel_link</child>\n      <axis>\n        <xyz>0.000000 1.000000 0.000000</xyz>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='torso_lift_joint' type='prismatic'>\n      <parent>base_footprint</parent>\n      <child>torso_lift_link</child>\n      <axis>\n        <xyz>0.000000 0.000000 1.000000</xyz>\n        <limit>\n          <lower>0.000000</lower>\n          <upper>0.330000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='head_pan_joint' type='revolute'>\n      <parent>torso_lift_link</parent>\n      <child>head_pan_link</child>\n      <axis>\n        <xyz>0.000000 0.000000 1.000000</xyz>\n        <dynamics>\n          <damping>2.000000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-3.006993</lower>\n          <upper>3.006993</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='head_tilt_joint' type='revolute'>\n      <parent>head_pan_link</parent>\n      <child>head_tilt_link</child>\n      <axis>\n        <xyz>0.000000 1.000000 0.000000</xyz>\n        <dynamics>\n          <damping>10.000000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-0.471237</lower>\n          <upper>1.396260</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='l_shoulder_pan_joint' type='revolute'>\n      <parent>torso_lift_link</parent>\n      <child>l_shoulder_pan_link</child>\n      <axis>\n        <xyz>0.000000 0.000000 1.000000</xyz>\n        <dynamics>\n          <damping>10.000000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-0.714602</lower>\n          <upper>2.285404</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='l_shoulder_lift_joint' type='revolute'>\n      <parent>l_shoulder_pan_link</parent>\n      <child>l_shoulder_lift_link</child>\n      <axis>\n        <xyz>0.000000 1.000000 0.000000</xyz>\n        <dynamics>\n          <damping>10.000000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-0.523601</lower>\n          <upper>1.396300</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='l_upper_arm_roll_joint' type='revolute'>\n      <parent>l_shoulder_lift_link</parent>\n      <child>l_upper_arm_roll_link</child>\n      <axis>\n        <xyz>1.000000 0.000000 0.000000</xyz>\n        <dynamics>\n          <damping>0.100000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-0.800000</lower>\n          <upper>3.900008</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='l_elbow_flex_joint' type='revolute'>\n      <parent>l_upper_arm_roll_link</parent>\n      <child>l_elbow_flex_link</child>\n      <axis>\n        <xyz>0.000000 1.000000 0.000000</xyz>\n        <dynamics>\n          <damping>1.000000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-2.321305</lower>\n          <upper>0.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='l_forearm_roll_joint' type='revolute'>\n      <parent>l_elbow_flex_link</parent>\n      <child>l_forearm_roll_link</child>\n      <axis>\n        <xyz>1.000000 0.000000 0.000000</xyz>\n        <dynamics>\n          <damping>0.100000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='l_wrist_flex_joint' type='revolute'>\n      <parent>l_forearm_roll_link</parent>\n      <child>l_wrist_flex_link</child>\n      <axis>\n        <xyz>0.000000 1.000000 0.000000</xyz>\n        <dynamics>\n          <damping>0.100000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-2.180004</lower>\n          <upper>0.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='l_wrist_roll_joint' type='revolute'>\n      <parent>l_wrist_flex_link</parent>\n      <child>l_wrist_roll_link</child>\n      <axis>\n        <xyz>1.000000 0.000000 0.000000</xyz>\n        <dynamics>\n          <damping>0.100000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='l_gripper_l_finger_joint' type='revolute'>\n      <parent>l_wrist_roll_link</parent>\n      <child>l_gripper_l_finger_link</child>\n      <axis>\n        <xyz>0.000000 0.000000 1.000000</xyz>\n        <dynamics>\n          <damping>0.020000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>0.000000</lower>\n          <upper>0.548000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='l_gripper_l_finger_tip_joint' type='revolute'>\n      <parent>l_gripper_l_finger_link</parent>\n      <child>l_gripper_l_finger_tip_link</child>\n      <axis>\n        <xyz>0.000000 0.000000 -1.000000</xyz>\n        <dynamics>\n          <damping>0.001000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>0.000000</lower>\n          <upper>0.548000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='l_gripper_motor_slider_joint' type='prismatic'>\n      <parent>l_wrist_roll_link</parent>\n      <child>l_gripper_motor_slider_link</child>\n      <axis>\n        <xyz>1.000000 0.000000 0.000000</xyz>\n        <limit>\n          <lower>-0.100000</lower>\n          <upper>0.100000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='l_gripper_motor_screw_joint' type='revolute'>\n      <parent>l_gripper_motor_slider_link</parent>\n      <child>l_gripper_motor_screw_link</child>\n      <axis>\n        <xyz>0.000000 1.000000 0.000000</xyz>\n        <dynamics>\n          <damping>0.000100</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='l_gripper_r_finger_joint' type='revolute'>\n      <parent>l_wrist_roll_link</parent>\n      <child>l_gripper_r_finger_link</child>\n      <axis>\n        <xyz>0.000000 0.000000 -1.000000</xyz>\n        <dynamics>\n          <damping>0.020000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>0.000000</lower>\n          <upper>0.548000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='l_gripper_r_finger_tip_joint' type='revolute'>\n      <parent>l_gripper_r_finger_link</parent>\n      <child>l_gripper_r_finger_tip_link</child>\n      <axis>\n        <xyz>0.000000 0.000000 1.000000</xyz>\n        <dynamics>\n          <damping>0.001000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>0.000000</lower>\n          <upper>0.548000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='laser_tilt_mount_joint' type='revolute'>\n      <parent>torso_lift_link</parent>\n      <child>laser_tilt_mount_link</child>\n      <axis>\n        <xyz>0.000000 1.000000 0.000000</xyz>\n        <dynamics>\n          <damping>0.008000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-0.785400</lower>\n          <upper>1.483530</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='r_shoulder_pan_joint' type='revolute'>\n      <parent>torso_lift_link</parent>\n      <child>r_shoulder_pan_link</child>\n      <axis>\n        <xyz>0.000000 0.000000 1.000000</xyz>\n        <dynamics>\n          <damping>10.000000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-2.285404</lower>\n          <upper>0.714602</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='r_shoulder_lift_joint' type='revolute'>\n      <parent>r_shoulder_pan_link</parent>\n      <child>r_shoulder_lift_link</child>\n      <axis>\n        <xyz>0.000000 1.000000 0.000000</xyz>\n        <dynamics>\n          <damping>10.000000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-0.523601</lower>\n          <upper>1.396300</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='r_upper_arm_roll_joint' type='revolute'>\n      <parent>r_shoulder_lift_link</parent>\n      <child>r_upper_arm_roll_link</child>\n      <axis>\n        <xyz>1.000000 0.000000 0.000000</xyz>\n        <dynamics>\n          <damping>0.100000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-3.900008</lower>\n          <upper>0.800000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='r_elbow_flex_joint' type='revolute'>\n      <parent>r_upper_arm_roll_link</parent>\n      <child>r_elbow_flex_link</child>\n      <axis>\n        <xyz>0.000000 1.000000 0.000000</xyz>\n        <dynamics>\n          <damping>1.000000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-2.321305</lower>\n          <upper>0.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='r_forearm_roll_joint' type='revolute'>\n      <parent>r_elbow_flex_link</parent>\n      <child>r_forearm_roll_link</child>\n      <axis>\n        <xyz>1.000000 0.000000 0.000000</xyz>\n        <dynamics>\n          <damping>0.100000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='r_wrist_flex_joint' type='revolute'>\n      <parent>r_forearm_roll_link</parent>\n      <child>r_wrist_flex_link</child>\n      <axis>\n        <xyz>0.000000 1.000000 0.000000</xyz>\n        <dynamics>\n          <damping>0.100000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-2.180004</lower>\n          <upper>0.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='r_wrist_roll_joint' type='revolute'>\n      <parent>r_wrist_flex_link</parent>\n      <child>r_wrist_roll_link</child>\n      <axis>\n        <xyz>1.000000 0.000000 0.000000</xyz>\n        <dynamics>\n          <damping>0.100000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='r_gripper_l_finger_joint' type='revolute'>\n      <parent>r_wrist_roll_link</parent>\n      <child>r_gripper_l_finger_link</child>\n      <axis>\n        <xyz>0.000000 0.000000 1.000000</xyz>\n        <dynamics>\n          <damping>0.020000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>0.000000</lower>\n          <upper>0.548000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='r_gripper_l_finger_tip_joint' type='revolute'>\n      <parent>r_gripper_l_finger_link</parent>\n      <child>r_gripper_l_finger_tip_link</child>\n      <axis>\n        <xyz>0.000000 0.000000 -1.000000</xyz>\n        <dynamics>\n          <damping>0.001000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>0.000000</lower>\n          <upper>0.548000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='r_gripper_motor_slider_joint' type='prismatic'>\n      <parent>r_wrist_roll_link</parent>\n      <child>r_gripper_motor_slider_link</child>\n      <axis>\n        <xyz>1.000000 0.000000 0.000000</xyz>\n        <dynamics>\n          <damping>0.000000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-0.100000</lower>\n          <upper>0.100000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='r_gripper_motor_screw_joint' type='revolute'>\n      <parent>r_gripper_motor_slider_link</parent>\n      <child>r_gripper_motor_screw_link</child>\n      <axis>\n        <xyz>0.000000 1.000000 0.000000</xyz>\n        <dynamics>\n          <damping>0.000100</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='r_gripper_r_finger_joint' type='revolute'>\n      <parent>r_wrist_roll_link</parent>\n      <child>r_gripper_r_finger_link</child>\n      <axis>\n        <xyz>0.000000 0.000000 -1.000000</xyz>\n        <dynamics>\n          <damping>0.020000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>0.000000</lower>\n          <upper>0.548000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='r_gripper_r_finger_tip_joint' type='revolute'>\n      <parent>r_gripper_r_finger_link</parent>\n      <child>r_gripper_r_finger_tip_link</child>\n      <axis>\n        <xyz>0.000000 0.000000 1.000000</xyz>\n        <dynamics>\n          <damping>0.001000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>0.000000</lower>\n          <upper>0.548000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='torso_lift_motor_screw_joint' type='revolute'>\n      <parent>base_footprint</parent>\n      <child>torso_lift_motor_screw_link</child>\n      <axis>\n        <xyz>0.000000 0.000000 1.000000</xyz>\n        <dynamics>\n          <damping>0.000100</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='torso_lift_screw_torso_lift_joint' type='screw'>\n      <parent>torso_lift_link</parent>\n      <child>torso_lift_motor_screw_link</child>\n      <thread_pitch>3141.600000</thread_pitch>\n      <axis>\n        <xyz>0.000000 0.000000 1.000000</xyz>\n        <dynamics>\n          <damping>0.000000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='r_gripper_r_screw_screw_joint' type='screw'>\n      <parent>r_gripper_r_finger_tip_link</parent>\n      <child>r_gripper_motor_screw_link</child>\n      <thread_pitch>-3141.600000</thread_pitch>\n      <axis>\n        <xyz>0.000000 1.000000 0.000000</xyz>\n        <dynamics>\n          <damping>0.000000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='r_gripper_l_screw_screw_joint' type='screw'>\n      <parent>r_gripper_l_finger_tip_link</parent>\n      <child>r_gripper_motor_screw_link</child>\n      <thread_pitch>3141.600000</thread_pitch>\n      <axis>\n        <xyz>0.000000 1.000000 0.000000</xyz>\n        <dynamics>\n          <damping>0.000000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='r_gripper_r_parallel_root_joint' type='revolute'>\n      <pose>0.058910 -0.031000 0.000000 0.000000 0.000000 0.000000</pose>\n      <parent>r_gripper_r_parallel_link</parent>\n      <child>r_wrist_roll_link</child>\n      <axis>\n        <xyz>0.000000 0.000000 -1.000000</xyz>\n        <dynamics>\n          <damping>0.200000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='r_gripper_l_parallel_root_joint' type='revolute'>\n      <pose>0.058910 0.031000 0.000000 0.000000 0.000000 0.000000</pose>\n      <parent>r_gripper_l_parallel_link</parent>\n      <child>r_wrist_roll_link</child>\n      <axis>\n        <xyz>0.000000 0.000000 1.000000</xyz>\n        <dynamics>\n          <damping>0.200000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='r_gripper_r_parallel_tip_joint' type='revolute'>\n      <pose>-0.018000 -0.021000 0.000000 0.000000 0.000000 0.000000</pose>\n      <parent>r_gripper_r_parallel_link</parent>\n      <child>r_gripper_r_finger_tip_link</child>\n      <axis>\n        <xyz>0.000000 0.000000 1.000000</xyz>\n        <dynamics>\n          <damping>0.000000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='r_gripper_l_parallel_tip_joint' type='revolute'>\n      <pose>-0.018000 0.021000 0.000000 0.000000 0.000000 0.000000</pose>\n      <parent>r_gripper_l_parallel_link</parent>\n      <child>r_gripper_l_finger_tip_link</child>\n      <axis>\n        <xyz>0.000000 0.000000 1.000000</xyz>\n        <dynamics>\n          <damping>0.000000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='r_gripper_joint' type='prismatic'>\n      <parent>r_gripper_r_finger_tip_link</parent>\n      <child>r_gripper_l_finger_tip_link</child>\n      <axis>\n        <xyz>0.000000 1.000000 0.000000</xyz>\n        <dynamics>\n          <damping>0.000000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='l_gripper_r_screw_screw_joint' type='screw'>\n      <parent>l_gripper_r_finger_tip_link</parent>\n      <child>l_gripper_motor_screw_link</child>\n      <thread_pitch>-3141.600000</thread_pitch>\n      <axis>\n        <xyz>0.000000 1.000000 0.000000</xyz>\n        <dynamics>\n          <damping>0.000000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='l_gripper_l_screw_screw_joint' type='screw'>\n      <parent>l_gripper_l_finger_tip_link</parent>\n      <child>l_gripper_motor_screw_link</child>\n      <thread_pitch>3141.600000</thread_pitch>\n      <axis>\n        <xyz>0.000000 1.000000 0.000000</xyz>\n        <dynamics>\n          <damping>0.000000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='l_gripper_r_parallel_root_joint' type='revolute'>\n      <pose>0.058910 -0.031000 0.000000 0.000000 0.000000 0.000000</pose>\n      <parent>l_gripper_r_parallel_link</parent>\n      <child>l_wrist_roll_link</child>\n      <axis>\n        <xyz>0.000000 0.000000 -1.000000</xyz>\n        <dynamics>\n          <damping>0.200000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='l_gripper_l_parallel_root_joint' type='revolute'>\n      <pose>0.058910 0.031000 0.000000 0.000000 0.000000 0.000000</pose>\n      <parent>l_gripper_l_parallel_link</parent>\n      <child>l_wrist_roll_link</child>\n      <axis>\n        <xyz>0.000000 0.000000 1.000000</xyz>\n        <dynamics>\n          <damping>0.200000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='l_gripper_r_parallel_tip_joint' type='revolute'>\n      <pose>-0.018000 -0.021000 0.000000 0.000000 0.000000 0.000000</pose>\n      <parent>l_gripper_r_parallel_link</parent>\n      <child>l_gripper_r_finger_tip_link</child>\n      <axis>\n        <xyz>0.000000 0.000000 1.000000</xyz>\n        <dynamics>\n          <damping>0.000000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='l_gripper_l_parallel_tip_joint' type='revolute'>\n      <pose>-0.018000 0.021000 0.000000 0.000000 0.000000 0.000000</pose>\n      <parent>l_gripper_l_parallel_link</parent>\n      <child>l_gripper_l_finger_tip_link</child>\n      <axis>\n        <xyz>0.000000 0.000000 1.000000</xyz>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='l_gripper_joint' type='prismatic'>\n      <parent>l_gripper_r_finger_tip_link</parent>\n      <child>l_gripper_l_finger_tip_link</child>\n      <axis>\n        <xyz>0.000000 1.000000 0.000000</xyz>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n  </model>\n  <physics type='ode'>\n    <update_rate>1000.000000</update_rate>\n    <gravity>0.000000 0.000000 -9.800000</gravity>\n  </physics>\n  <scene>\n    <ambient>0.200000 0.200000 0.200000 1.000000</ambient>\n    <background>0.700000 0.700000 0.700000 1.000000</background>\n    <shadows>1</shadows>\n  </scene>\n  <state world_name='default'>\n    <sim_time>0 0</sim_time>\n    <real_time>0 0</real_time>\n    <wall_time>1360301755 667456998</wall_time>\n  </state>\n</world>\n</sdf>]]></chunk>\n<chunk encoding='txt'><![CDATA[\n<sdf version='1.4'>\n<state world_name='default'>\n<sim_time>0 21343973</sim_time>\n<real_time>0 1000000</real_time>\n<wall_time>1360301758 939690376</wall_time>\n<model name='pr2'>\n<pose>0.000000 0.000000 -0.000008 0.000000 0.000000 0.000000</pose>\n</model>\n</sdf></state>\n]]></chunk>\n<chunk encoding='txt'><![CDATA[\n<sdf version='1.4'>\n<state world_name='default'>\n<sim_time>0 28958235</sim_time>\n<real_time>0 2000000</real_time>\n<wall_time>1360301758 947304437</wall_time>\n<model name='pr2'>\n<pose>0.000000 0.000000 -0.000015 0.000000 -0.000001 0.000000</pose>\n</model>\n</sdf></state>\n]]></chunk>\n</gazebo_log>";

static std::string pr2PoseXStateLog =
"<?xml version='1.0'?>\n<gazebo_log>\n<header>\n<log_version>1.0</log_version>\n<gazebo_version>1.4.6</gazebo_version>\n<rand_seed>32606</rand_seed>\n</header>\n\n<chunk encoding='txt'><![CDATA[\n<sdf version ='1.3'>\n<world name='default'>\n  <model name='ground_plane'>\n    <static>1</static>\n    <link name='link'>\n      <collision name='collision'>\n        <geometry>\n          <plane>\n            <normal>0.000000 0.000000 1.000000</normal>\n            <size>100.000000 100.000000</size>\n          </plane>\n        </geometry>\n        <surface>\n          <friction>\n            <ode>\n              <mu>100.000000</mu>\n              <mu2>50.000000</mu2>\n            </ode>\n          </friction>\n          <bounce/>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='visual'>\n        <cast_shadows>0</cast_shadows>\n        <geometry>\n          <plane>\n            <normal>0.000000 0.000000 1.000000</normal>\n            <size>100.000000 100.000000</size>\n          </plane>\n        </geometry>\n        <material>\n          <script>\n            <uri>file://media/materials/scripts/gazebo.material</uri>\n            <name>Gazebo/Grey</name>\n          </script>\n        </material>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <self_collide>0</self_collide>\n      <kinematic>0</kinematic>\n      <gravity>1</gravity>\n    </link>\n  </model>\n  <light name='sun' type='directional'>\n    <cast_shadows>1</cast_shadows>\n    <pose>0.000000 0.000000 10.000000 0.000000 0.000000 0.000000</pose>\n    <diffuse>0.800000 0.800000 0.800000 1.000000</diffuse>\n    <specular>0.100000 0.100000 0.100000 1.000000</specular>\n    <attenuation>\n      <range>1000.000000</range>\n      <constant>0.900000</constant>\n      <linear>0.010000</linear>\n      <quadratic>0.001000</quadratic>\n    </attenuation>\n    <direction>-0.500000 0.500000 -1.000000</direction>\n  </light>\n  <model name='pr2'>\n    <static>0</static>\n    <link name='base_footprint'>\n      <self_collide>0</self_collide>\n      <inertial>\n        <mass>118.001000</mass>\n        <pose>-0.062421 0.000000 0.201365 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>8.431730</ixx>\n          <ixy>-0.009720</ixy>\n          <ixz>1.901570</ixz>\n          <iyy>8.533050</iyy>\n          <iyz>-0.007380</iyz>\n          <izz>3.787470</izz>\n        </inertia>\n      </inertial>\n      <collision name='base_footprint_geom'>\n        <pose>0.000000 0.000000 0.071000 0.000000 0.000000 0.000000</pose>\n        <geometry>\n          <box>\n            <size>0.001000 0.001000 0.001000</size>\n          </box>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='base_footprint_geom_visual'>\n        <geometry>\n          <box>\n            <size>0.010000 0.010000 0.010000</size>\n          </box>\n        </geometry>\n      </visual>\n      <collision name='base_footprint_geom_base_bellow_link'>\n        <pose>-0.290000 0.000000 0.851000 0.000000 0.000000 0.000000</pose>\n        <geometry>\n          <box>\n            <size>0.050000 0.370000 0.300000</size>\n          </box>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='base_footprint_geom_base_bellow_link_visual'>\n        <pose>-0.290000 0.000000 0.851000 0.000000 0.000000 0.000000</pose>\n        <geometry>\n          <box>\n            <size>0.050000 0.370000 0.300000</size>\n          </box>\n        </geometry>\n      </visual>\n      <collision name='base_footprint_geom_base_link'>\n        <pose>0.000000 0.000000 0.051000 0.000000 0.000000 0.000000</pose>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/base_v0/base_L.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='base_footprint_geom_base_link_visual'>\n        <pose>0.000000 0.000000 0.051000 0.000000 0.000000 0.000000</pose>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/base_v0/base.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <sensor name='base_contact_sensor' type='contact'>\n        <update_rate>100.000000</update_rate>\n        <always_on>0</always_on>\n        <visualize>0</visualize>\n        <contact>\n          <collision>base_footprint_geom_base_link</collision>\n          <topic>__default_topic__</topic>\n        </contact>\n        <plugin name='gazebo_contact' filename='libContactPlugin.so'/>\n      </sensor>\n      <sensor name='base_laser' type='ray'>\n        <always_on>0</always_on>\n        <visualize>0</visualize>\n        <update_rate>20.000000</update_rate>\n        <pose>0.275000 0.000000 0.303000 0.000000 0.000000 0.000000</pose>\n        <ray>\n          <scan>\n            <horizontal>\n              <samples>640</samples>\n              <resolution>1.000000</resolution>\n              <min_angle>-2.268900</min_angle>\n              <max_angle>2.268900</max_angle>\n            </horizontal>\n          </scan>\n          <range>\n            <min>0.080000</min>\n            <max>10.000000</max>\n            <resolution>0.010000</resolution>\n          </range>\n        </ray>\n        <plugin name='laser' filename='libRayPlugin.so'/>\n      </sensor>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n      <gravity>1</gravity>\n    </link>\n    <link name='bl_caster_rotation_link'>\n      <self_collide>0</self_collide>\n      <pose>-0.224600 0.224600 0.079200 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>3.473080</mass>\n        <pose>0.000000 0.000000 0.070000 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.012412</ixx>\n          <ixy>-0.000712</ixy>\n          <ixz>0.000503</ixz>\n          <iyy>0.015218</iyy>\n          <iyz>-0.000004</iyz>\n          <izz>0.011764</izz>\n        </inertia>\n      </inertial>\n      <collision name='bl_caster_rotation_link_geom'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/base_v0/caster_L.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='bl_caster_rotation_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/base_v0/caster.stl</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n      <gravity>1</gravity>\n    </link>\n    <link name='bl_caster_l_wheel_link'>\n      <self_collide>0</self_collide>\n      <pose>-0.224600 0.273600 0.079200 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.440360</mass>\n        <inertia>\n          <ixx>0.012412</ixx>\n          <ixy>-0.000712</ixy>\n          <ixz>0.000503</ixz>\n          <iyy>0.015218</iyy>\n          <iyz>-0.000004</iyz>\n          <izz>0.011764</izz>\n        </inertia>\n      </inertial>\n      <collision name='bl_caster_l_wheel_link_geom'>\n        <pose>0.000000 0.000000 0.000000 1.570800 0.000000 0.000000</pose>\n        <geometry>\n          <cylinder>\n            <radius>0.074792</radius>\n            <length>0.034000</length>\n          </cylinder>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='bl_caster_l_wheel_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/base_v0/wheel.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n      <gravity>1</gravity>\n    </link>\n    <link name='bl_caster_r_wheel_link'>\n      <self_collide>0</self_collide>\n      <pose>-0.224600 0.175600 0.079200 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.440360</mass>\n        <inertia>\n          <ixx>0.012412</ixx>\n          <ixy>0.000712</ixy>\n          <ixz>0.000503</ixz>\n          <iyy>0.015218</iyy>\n          <iyz>0.000004</iyz>\n          <izz>0.011764</izz>\n        </inertia>\n      </inertial>\n      <collision name='bl_caster_r_wheel_link_geom'>\n        <pose>0.000000 0.000000 0.000000 1.570800 0.000000 0.000000</pose>\n        <geometry>\n          <cylinder>\n            <radius>0.074792</radius>\n            <length>0.034000</length>\n          </cylinder>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='bl_caster_r_wheel_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/base_v0/wheel.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n      <gravity>1</gravity>\n    </link>\n    <link name='br_caster_rotation_link'>\n      <self_collide>0</self_collide>\n      <pose>-0.224600 -0.224600 0.079200 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>3.473080</mass>\n        <pose>0.000000 0.000000 0.070000 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.012412</ixx>\n          <ixy>-0.000712</ixy>\n          <ixz>0.000503</ixz>\n          <iyy>0.015218</iyy>\n          <iyz>-0.000004</iyz>\n          <izz>0.011764</izz>\n        </inertia>\n      </inertial>\n      <collision name='br_caster_rotation_link_geom'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/base_v0/caster_L.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='br_caster_rotation_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/base_v0/caster.stl</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n      <gravity>1</gravity>\n    </link>\n    <link name='br_caster_l_wheel_link'>\n      <self_collide>0</self_collide>\n      <pose>-0.224600 -0.175600 0.079200 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.440360</mass>\n        <inertia>\n          <ixx>0.012412</ixx>\n          <ixy>-0.000712</ixy>\n          <ixz>0.000503</ixz>\n          <iyy>0.015218</iyy>\n          <iyz>-0.000004</iyz>\n          <izz>0.011764</izz>\n        </inertia>\n      </inertial>\n      <collision name='br_caster_l_wheel_link_geom'>\n        <pose>0.000000 0.000000 0.000000 1.570800 0.000000 0.000000</pose>\n        <geometry>\n          <cylinder>\n            <radius>0.074792</radius>\n            <length>0.034000</length>\n          </cylinder>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='br_caster_l_wheel_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/base_v0/wheel.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n      <gravity>1</gravity>\n    </link>\n    <link name='br_caster_r_wheel_link'>\n      <self_collide>0</self_collide>\n      <pose>-0.224600 -0.273600 0.079200 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.440360</mass>\n        <inertia>\n          <ixx>0.012412</ixx>\n          <ixy>-0.000712</ixy>\n          <ixz>0.000503</ixz>\n          <iyy>0.015218</iyy>\n          <iyz>-0.000004</iyz>\n          <izz>0.011764</izz>\n        </inertia>\n      </inertial>\n      <collision name='br_caster_r_wheel_link_geom'>\n        <pose>0.000000 0.000000 0.000000 1.570800 0.000000 0.000000</pose>\n        <geometry>\n          <cylinder>\n            <radius>0.074792</radius>\n            <length>0.034000</length>\n          </cylinder>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='br_caster_r_wheel_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/base_v0/wheel.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n      <gravity>1</gravity>\n    </link>\n    <link name='fl_caster_rotation_link'>\n      <self_collide>0</self_collide>\n      <pose>0.224600 0.224600 0.079200 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>3.473080</mass>\n        <pose>0.000000 0.000000 0.070000 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.012412</ixx>\n          <ixy>-0.000712</ixy>\n          <ixz>0.000503</ixz>\n          <iyy>0.015218</iyy>\n          <iyz>-0.000004</iyz>\n          <izz>0.011764</izz>\n        </inertia>\n      </inertial>\n      <collision name='fl_caster_rotation_link_geom'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/base_v0/caster_L.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='fl_caster_rotation_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/base_v0/caster.stl</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n      <gravity>1</gravity>\n    </link>\n    <link name='fl_caster_l_wheel_link'>\n      <self_collide>0</self_collide>\n      <pose>0.224600 0.273600 0.079200 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.440360</mass>\n        <inertia>\n          <ixx>0.012412</ixx>\n          <ixy>-0.000712</ixy>\n          <ixz>0.000503</ixz>\n          <iyy>0.015218</iyy>\n          <iyz>-0.000004</iyz>\n          <izz>0.011764</izz>\n        </inertia>\n      </inertial>\n      <collision name='fl_caster_l_wheel_link_geom'>\n        <pose>0.000000 0.000000 0.000000 1.570800 0.000000 0.000000</pose>\n        <geometry>\n          <cylinder>\n            <radius>0.074792</radius>\n            <length>0.034000</length>\n          </cylinder>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='fl_caster_l_wheel_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/base_v0/wheel.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n      <gravity>1</gravity>\n    </link>\n    <link name='fl_caster_r_wheel_link'>\n      <self_collide>0</self_collide>\n      <pose>0.224600 0.175600 0.079200 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.440360</mass>\n        <inertia>\n          <ixx>0.012412</ixx>\n          <ixy>-0.000712</ixy>\n          <ixz>0.000503</ixz>\n          <iyy>0.015218</iyy>\n          <iyz>-0.000004</iyz>\n          <izz>0.011764</izz>\n        </inertia>\n      </inertial>\n      <collision name='fl_caster_r_wheel_link_geom'>\n        <pose>0.000000 0.000000 0.000000 1.570800 0.000000 0.000000</pose>\n        <geometry>\n          <cylinder>\n            <radius>0.074792</radius>\n            <length>0.034000</length>\n          </cylinder>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='fl_caster_r_wheel_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/base_v0/wheel.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n      <gravity>1</gravity>\n    </link>\n    <link name='fr_caster_rotation_link'>\n      <self_collide>0</self_collide>\n      <pose>0.224600 -0.224600 0.079200 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>3.473080</mass>\n        <pose>0.000000 0.000000 0.070000 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.012412</ixx>\n          <ixy>-0.000712</ixy>\n          <ixz>0.000503</ixz>\n          <iyy>0.015218</iyy>\n          <iyz>-0.000004</iyz>\n          <izz>0.011764</izz>\n        </inertia>\n      </inertial>\n      <collision name='fr_caster_rotation_link_geom'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/base_v0/caster_L.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='fr_caster_rotation_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/base_v0/caster.stl</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n      <gravity>1</gravity>\n    </link>\n    <link name='fr_caster_l_wheel_link'>\n      <self_collide>0</self_collide>\n      <pose>0.224600 -0.175600 0.079200 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.440360</mass>\n        <inertia>\n          <ixx>0.012412</ixx>\n          <ixy>-0.000712</ixy>\n          <ixz>0.000503</ixz>\n          <iyy>0.015218</iyy>\n          <iyz>-0.000004</iyz>\n          <izz>0.011764</izz>\n        </inertia>\n      </inertial>\n      <collision name='fr_caster_l_wheel_link_geom'>\n        <pose>0.000000 0.000000 0.000000 1.570800 0.000000 0.000000</pose>\n        <geometry>\n          <cylinder>\n            <radius>0.074792</radius>\n            <length>0.034000</length>\n          </cylinder>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='fr_caster_l_wheel_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/base_v0/wheel.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n      <gravity>1</gravity>\n    </link>\n    <link name='fr_caster_r_wheel_link'>\n      <self_collide>0</self_collide>\n      <pose>0.224600 -0.273600 0.079200 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.440360</mass>\n        <inertia>\n          <ixx>0.012412</ixx>\n          <ixy>-0.000712</ixy>\n          <ixz>0.000503</ixz>\n          <iyy>0.015218</iyy>\n          <iyz>-0.000004</iyz>\n          <izz>0.011764</izz>\n        </inertia>\n      </inertial>\n      <collision name='fr_caster_r_wheel_link_geom'>\n        <pose>0.000000 0.000000 0.000000 1.570800 0.000000 0.000000</pose>\n        <geometry>\n          <cylinder>\n            <radius>0.074792</radius>\n            <length>0.034000</length>\n          </cylinder>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='fr_caster_r_wheel_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/base_v0/wheel.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n      <gravity>1</gravity>\n    </link>\n    <link name='torso_lift_link'>\n      <self_collide>0</self_collide>\n      <pose>-0.050000 0.000000 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>36.449000</mass>\n        <pose>-0.099499 -0.000004 -0.086764 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>2.792330</ixx>\n          <ixy>0.004280</ixy>\n          <ixz>-0.160631</ixz>\n          <iyy>2.521060</iyy>\n          <iyz>0.029689</iyz>\n          <izz>0.536551</izz>\n        </inertia>\n      </inertial>\n      <collision name='torso_lift_link_geom'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/torso_v0/torso_lift_L.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='torso_lift_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/torso_v0/torso_lift.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <sensor name='torso_lift_contact_sensor' type='contact'>\n        <update_rate>100.000000</update_rate>\n        <always_on>0</always_on>\n        <visualize>0</visualize>\n        <contact>\n          <collision>torso_lift_link_geom</collision>\n          <topic>__default_topic__</topic>\n        </contact>\n      </sensor>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n      <gravity>1</gravity>\n    </link>\n    <link name='head_pan_link'>\n      <self_collide>0</self_collide>\n      <pose>-0.067070 0.000000 1.172130 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>6.339000</mass>\n        <pose>0.010907 0.031693 0.090507 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.032498</ixx>\n          <ixy>0.000636</ixy>\n          <ixz>0.002585</ixz>\n          <iyy>0.046546</iyy>\n          <iyz>-0.002453</iyz>\n          <izz>0.057653</izz>\n        </inertia>\n      </inertial>\n      <collision name='head_pan_link_geom'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/head_v0/head_pan_L.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='head_pan_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/head_v0/head_pan.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n      <gravity>1</gravity>\n    </link>\n    <link name='head_tilt_link'>\n      <projector name='projector_wg6802418_projector_wg6802418'>\n        <texture>stereo_projection_pattern_high_res_red.png</texture>\n        <fov>0.959931</fov>\n        <near_clip>0.100000</near_clip>\n        <far_clip>10.000000</far_clip>\n        <pose>0.023200 0.110000 0.119100 0.000000 -1.570793 0.000000</pose>\n      </projector>\n      <self_collide>0</self_collide>\n      <pose>0.000930 0.000000 1.172130 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>5.319000</mass>\n        <pose>-0.005151 -0.014635 0.072819 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.126134</ixx>\n          <ixy>0.000237</ixy>\n          <ixz>0.011881</ixz>\n          <iyy>0.165102</iyy>\n          <iyz>0.001606</iyz>\n          <izz>0.166947</izz>\n        </inertia>\n      </inertial>\n      <collision name='head_tilt_link_geom'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/head_v0/head_tilt_L.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='head_tilt_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/head_v0/head_tilt.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <collision name='head_tilt_link_geom_head_mount_kinect_ir_link'>\n        <pose>-0.147067 0.012500 0.291953 0.000000 0.000000 0.000000</pose>\n        <geometry>\n          <sphere>\n            <radius>0.000500</radius>\n          </sphere>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='head_tilt_link_geom_head_mount_kinect_ir_link_visual'>\n        <pose>-0.147067 0.012500 0.291953 0.000000 0.000000 0.000000</pose>\n        <geometry>\n          <sphere>\n            <radius>0.000250</radius>\n          </sphere>\n        </geometry>\n        <material>\n          <script>\n            <uri>__default__</uri>\n            <name>__default__</name>\n          </script>\n        </material>\n      </visual>\n      <collision name='head_tilt_link_geom_head_mount_kinect_rgb_link'>\n        <pose>-0.147067 0.017500 0.291953 0.000000 0.000000 0.000000</pose>\n        <geometry>\n          <sphere>\n            <radius>0.000500</radius>\n          </sphere>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='head_tilt_link_geom_head_mount_kinect_rgb_link_visual'>\n        <pose>-0.147067 0.017500 0.291953 0.000000 0.000000 0.000000</pose>\n        <geometry>\n          <sphere>\n            <radius>0.000250</radius>\n          </sphere>\n        </geometry>\n        <material>\n          <script>\n            <uri>__default__</uri>\n            <name>__default__</name>\n          </script>\n        </material>\n      </visual>\n      <collision name='head_tilt_link_geom_head_mount_link'>\n        <pose>-0.114800 0.000000 0.155500 0.000000 0.000000 0.000000</pose>\n        <geometry>\n          <sphere>\n            <radius>0.000500</radius>\n          </sphere>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='head_tilt_link_geom_head_mount_link_visual'>\n        <pose>-0.114800 0.000000 0.155500 0.000000 0.000000 0.000000</pose>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/sensors/kinect_prosilica_v0/115x100_swept_back--coarse.STL</uri>\n            <scale>0.001000 0.001000 0.001000</scale>\n          </mesh>\n        </geometry>\n      </visual>\n      <collision name='head_tilt_link_geom_head_mount_prosilica_link'>\n        <pose>-0.161257 0.012500 0.244421 0.000000 0.000000 0.000000</pose>\n        <geometry>\n          <sphere>\n            <radius>0.000500</radius>\n          </sphere>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='head_tilt_link_geom_head_mount_prosilica_link_visual'>\n        <pose>-0.161257 0.012500 0.244421 0.000000 0.000000 0.000000</pose>\n        <geometry>\n          <sphere>\n            <radius>0.000250</radius>\n          </sphere>\n        </geometry>\n        <material>\n          <script>\n            <uri>__default__</uri>\n            <name>__default__</name>\n          </script>\n        </material>\n      </visual>\n      <collision name='head_tilt_link_geom_head_plate_frame'>\n        <pose>0.023200 0.000000 0.064500 0.000000 0.000000 0.000000</pose>\n        <geometry>\n          <box>\n            <size>0.010000 0.010000 0.010000</size>\n          </box>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='head_tilt_link_geom_head_plate_frame_visual'>\n        <pose>0.023200 0.000000 0.064500 0.000000 0.000000 0.000000</pose>\n        <geometry>\n          <box>\n            <size>0.010000 0.010000 0.010000</size>\n          </box>\n        </geometry>\n        <material>\n          <script>\n            <uri>__default__</uri>\n            <name>__default__</name>\n          </script>\n        </material>\n      </visual>\n      <sensor name='head_mount_sensor' type='camera'>\n        <always_on>0</always_on>\n        <visualize>0</visualize>\n        <update_rate>1.000000</update_rate>\n        <pose>-0.147067 0.012500 0.291953 0.000000 0.000000 0.000000</pose>\n        <camera name='__default__'>\n          <horizontal_fov>0.994838</horizontal_fov>\n          <image>\n            <width>640</width>\n            <height>480</height>\n            <format>L8</format>\n          </image>\n          <clip>\n            <near>0.010000</near>\n            <far>5.000000</far>\n          </clip>\n        </camera>\n      </sensor>\n      <sensor name='head_mount_prosilica_link_sensor' type='camera'>\n        <update_rate>1.000000</update_rate>\n        <pose>-0.161257 0.012500 0.244421 0.000000 0.000000 0.000000</pose>\n        <always_on>0</always_on>\n        <visualize>0</visualize>\n        <camera name='__default__'>\n          <horizontal_fov>1.120501</horizontal_fov>\n          <image>\n            <width>320</width>\n            <height>240</height>\n            <format>R8G8B8</format>\n          </image>\n          <clip>\n            <near>0.100000</near>\n            <far>100.000000</far>\n          </clip>\n        </camera>\n      </sensor>\n      <sensor name='head_mount_prosilica_link_sim_pcd_sensor' type='camera'>\n        <update_rate>1.000000</update_rate>\n        <pose>-0.161257 0.012500 0.244421 0.000000 0.000000 0.000000</pose>\n        <always_on>0</always_on>\n        <visualize>0</visualize>\n        <camera name='__default__'>\n          <horizontal_fov>1.120501</horizontal_fov>\n          <image>\n            <width>320</width>\n            <height>240</height>\n            <format>R8G8B8</format>\n          </image>\n          <clip>\n            <near>0.100000</near>\n            <far>100.000000</far>\n          </clip>\n        </camera>\n      </sensor>\n      <sensor name='narrow_stereo_gazebo_l_stereo_camera_sensor' type='camera'>\n        <always_on>0</always_on>\n        <visualize>0</visualize>\n        <update_rate>25.000000</update_rate>\n        <pose>0.068200 0.060000 0.114600 0.000000 0.000000 0.000000</pose>\n        <camera name='__default__'>\n          <horizontal_fov>0.785398</horizontal_fov>\n          <image>\n            <width>640</width>\n            <height>480</height>\n            <format>L8</format>\n          </image>\n          <clip>\n            <near>0.100000</near>\n            <far>100.000000</far>\n          </clip>\n        </camera>\n      </sensor>\n      <sensor name='narrow_stereo_gazebo_r_stereo_camera_sensor' type='camera'>\n        <always_on>0</always_on>\n        <visualize>0</visualize>\n        <update_rate>25.000000</update_rate>\n        <pose>0.068200 -0.030000 0.114600 0.000000 0.000000 0.000000</pose>\n        <camera name='__default__'>\n          <horizontal_fov>0.785398</horizontal_fov>\n          <image>\n            <width>640</width>\n            <height>480</height>\n            <format>L8</format>\n          </image>\n          <clip>\n            <near>0.100000</near>\n            <far>100.000000</far>\n          </clip>\n        </camera>\n      </sensor>\n      <sensor name='wide_stereo_gazebo_l_stereo_camera_sensor' type='camera'>\n        <update_rate>25.000000</update_rate>\n        <pose>0.068200 0.030000 0.114600 0.000000 0.000000 0.000000</pose>\n        <always_on>0</always_on>\n        <visualize>0</visualize>\n        <camera name='__default__'>\n          <horizontal_fov>1.570796</horizontal_fov>\n          <image>\n            <width>640</width>\n            <height>480</height>\n            <format>BAYER_BGGR8</format>\n          </image>\n          <clip>\n            <near>0.100000</near>\n            <far>100.000000</far>\n          </clip>\n        </camera>\n      </sensor>\n      <sensor name='wide_stereo_gazebo_r_stereo_camera_sensor' type='camera'>\n        <update_rate>25.000000</update_rate>\n        <pose>0.068200 -0.060000 0.114600 0.000000 0.000000 0.000000</pose>\n        <always_on>0</always_on>\n        <visualize>0</visualize>\n        <camera name='__default__'>\n          <horizontal_fov>1.570796</horizontal_fov>\n          <image>\n            <width>640</width>\n            <height>480</height>\n            <format>BAYER_BGGR8</format>\n          </image>\n          <clip>\n            <near>0.100000</near>\n            <far>100.000000</far>\n          </clip>\n        </camera>\n      </sensor>\n      <sensor name='high_def_sensor' type='camera'>\n        <update_rate>20.000000</update_rate>\n        <pose>0.069657 -0.110000 0.119100 0.000000 0.000000 0.000000</pose>\n        <always_on>0</always_on>\n        <visualize>0</visualize>\n        <camera name='__default__'>\n          <horizontal_fov>0.785398</horizontal_fov>\n          <image>\n            <width>2448</width>\n            <height>2050</height>\n            <format>R8G8B8</format>\n          </image>\n          <clip>\n            <near>0.100000</near>\n            <far>100.000000</far>\n          </clip>\n        </camera>\n      </sensor>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n      <gravity>1</gravity>\n    </link>\n    <link name='l_shoulder_pan_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>-0.050000 0.188000 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>25.799300</mass>\n        <pose>-0.001201 0.024513 -0.098231 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.866179</ixx>\n          <ixy>-0.060865</ixy>\n          <ixz>-0.121181</ixz>\n          <iyy>0.874217</iyy>\n          <iyz>-0.058866</iyz>\n          <izz>0.273538</izz>\n        </inertia>\n      </inertial>\n      <collision name='l_shoulder_pan_link_geom'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/shoulder_v0/shoulder_pan.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='l_shoulder_pan_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/shoulder_v0/shoulder_pan.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='l_shoulder_lift_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.050000 0.188000 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>2.749880</mass>\n        <pose>0.021950 -0.026640 -0.031270 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.021056</ixx>\n          <ixy>0.004967</ixy>\n          <ixz>-0.001948</ixz>\n          <iyy>0.021272</iyy>\n          <iyz>0.001104</iyz>\n          <izz>0.019758</izz>\n        </inertia>\n      </inertial>\n      <collision name='l_shoulder_lift_link_geom'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/shoulder_v0/shoulder_lift.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='l_shoulder_lift_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/shoulder_v0/shoulder_lift.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='l_upper_arm_roll_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.050000 0.188000 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>6.117690</mass>\n        <pose>0.210551 0.016309 -0.000561 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.025306</ixx>\n          <ixy>-0.003393</ixy>\n          <ixz>0.000608</ixz>\n          <iyy>0.084737</iyy>\n          <iyz>-0.000200</iyz>\n          <izz>0.086016</izz>\n        </inertia>\n      </inertial>\n      <collision name='l_upper_arm_roll_link_geom'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/shoulder_v0/upper_arm_roll_L.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='l_upper_arm_roll_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/shoulder_v0/upper_arm_roll.stl</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <collision name='l_upper_arm_roll_link_geom_l_upper_arm_link'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/upper_arm_v0/upper_arm.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='l_upper_arm_roll_link_geom_l_upper_arm_link_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/upper_arm_v0/upper_arm.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='l_elbow_flex_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.450000 0.188000 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>1.903270</mass>\n        <pose>0.010140 0.000320 -0.012110 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.003465</ixx>\n          <ixy>0.000041</ixy>\n          <ixz>0.000432</ixz>\n          <iyy>0.004416</iyy>\n          <iyz>-0.000040</iyz>\n          <izz>0.003592</izz>\n        </inertia>\n      </inertial>\n      <collision name='l_elbow_flex_link_geom'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/upper_arm_v0/elbow_flex.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='l_elbow_flex_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/upper_arm_v0/elbow_flex.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='l_forearm_roll_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.450000 0.188000 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>2.689680</mass>\n        <pose>0.180727 -0.000163 -0.008583 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.014668</ixx>\n          <ixy>0.000052</ixy>\n          <ixz>0.000656</ixz>\n          <iyy>0.026279</iyy>\n          <iyz>-0.000013</iyz>\n          <izz>0.027775</izz>\n        </inertia>\n      </inertial>\n      <collision name='l_forearm_roll_link_geom'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/upper_arm_v0/forearm_roll_L.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='l_forearm_roll_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/upper_arm_v0/forearm_roll.stl</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <collision name='l_forearm_roll_link_geom_l_forearm_link'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/forearm_v0/forearm.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='l_forearm_roll_link_geom_l_forearm_link_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/forearm_v0/forearm.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <sensor name='l_forearm_cam_sensor' type='camera'>\n        <update_rate>25.000000</update_rate>\n        <pose>0.135000 0.000000 0.044000 -1.570800 -0.562869 0.000000</pose>\n        <always_on>0</always_on>\n        <visualize>0</visualize>\n        <camera name='__default__'>\n          <horizontal_fov>1.570796</horizontal_fov>\n          <image>\n            <width>640</width>\n            <height>480</height>\n            <format>R8G8B8</format>\n          </image>\n          <clip>\n            <near>0.100000</near>\n            <far>100.000000</far>\n          </clip>\n        </camera>\n      </sensor>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='l_wrist_flex_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.771000 0.188000 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.614020</mass>\n        <pose>-0.001570 0.000000 -0.000750 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.000652</ixx>\n          <ixy>0.000000</ixy>\n          <ixz>0.000003</ixz>\n          <iyy>0.000198</iyy>\n          <iyz>0.000000</iyz>\n          <izz>0.000645</izz>\n        </inertia>\n      </inertial>\n      <collision name='l_wrist_flex_link_geom'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/forearm_v0/wrist_flex.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='l_wrist_flex_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/forearm_v0/wrist_flex.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='l_wrist_roll_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.771000 0.188000 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.681070</mass>\n        <pose>0.056408 0.000451 -0.001014 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.011352</ixx>\n          <ixy>-0.000016</ixy>\n          <ixz>-0.000001</ixz>\n          <iyy>0.011677</iyy>\n          <iyz>-0.000001</iyz>\n          <izz>0.011866</izz>\n        </inertia>\n      </inertial>\n      <collision name='l_wrist_roll_link_geom'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/forearm_v0/wrist_roll_L.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='l_wrist_roll_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/forearm_v0/wrist_roll.stl</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <collision name='l_wrist_roll_link_geom_l_gripper_motor_accelerometer_link'>\n        <geometry>\n          <box>\n            <size>0.001000 0.001000 0.001000</size>\n          </box>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='l_wrist_roll_link_geom_l_gripper_motor_accelerometer_link_visual'>\n        <geometry>\n          <box>\n            <size>0.001000 0.001000 0.001000</size>\n          </box>\n        </geometry>\n      </visual>\n      <collision name='l_wrist_roll_link_geom_l_gripper_palm_link'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/gripper_v0/gripper_palm.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='l_wrist_roll_link_geom_l_gripper_palm_link_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/gripper_v0/gripper_palm.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='l_gripper_l_finger_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.847910 0.198000 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.171260</mass>\n        <pose>0.035980 0.017300 -0.001640 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.000078</ixx>\n          <ixy>0.000001</ixy>\n          <ixz>-0.000010</ixz>\n          <iyy>0.000197</iyy>\n          <iyz>-0.000003</iyz>\n          <izz>0.000181</izz>\n        </inertia>\n      </inertial>\n      <collision name='l_gripper_l_finger_link_geom'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/gripper_v0/l_finger.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <friction>\n            <ode>\n              <mu>500.000000</mu>\n              <mu2>500.000000</mu2>\n              <slip1>0.000000</slip1>\n              <slip2>0.000000</slip2>\n            </ode>\n          </friction>\n          <contact>\n            <ode>\n              <kp>1000000.000000</kp>\n              <kd>1.000000</kd>\n              <max_vel>100.000000</max_vel>\n              <min_depth>0.000000</min_depth>\n            </ode>\n          </contact>\n          <bounce/>\n        </surface>\n      </collision>\n      <visual name='l_gripper_l_finger_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/gripper_v0/l_finger.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='l_gripper_l_finger_tip_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.939280 0.202950 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.044190</mass>\n        <pose>0.004230 0.002840 0.000000 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.000008</ixx>\n          <ixy>0.000006</ixy>\n          <ixz>0.000000</ixz>\n          <iyy>0.000010</iyy>\n          <iyz>0.000000</iyz>\n          <izz>0.000015</izz>\n        </inertia>\n      </inertial>\n      <collision name='l_gripper_l_finger_tip_link_geom'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/gripper_v0/l_finger_tip.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <friction>\n            <ode>\n              <mu>500.000000</mu>\n              <mu2>500.000000</mu2>\n              <slip1>0.000000</slip1>\n              <slip2>0.000000</slip2>\n            </ode>\n          </friction>\n          <contact>\n            <ode>\n              <kp>10000000.000000</kp>\n              <kd>1.000000</kd>\n              <max_vel>100.000000</max_vel>\n              <min_depth>0.000000</min_depth>\n            </ode>\n          </contact>\n          <bounce/>\n        </surface>\n      </collision>\n      <visual name='l_gripper_l_finger_tip_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/gripper_v0/l_finger_tip.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <sensor name='l_gripper_l_finger_tip_contact_sensor' type='contact'>\n        <update_rate>100.000000</update_rate>\n        <always_on>0</always_on>\n        <visualize>0</visualize>\n        <contact>\n          <collision>l_gripper_l_finger_tip_link_geom</collision>\n          <topic>__default_topic__</topic>\n        </contact>\n      </sensor>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='l_gripper_motor_slider_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.939280 0.188000 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.010000</mass>\n        <inertia>\n          <ixx>0.001000</ixx>\n          <ixy>0.000000</ixy>\n          <ixz>0.000000</ixz>\n          <iyy>0.001000</iyy>\n          <iyz>0.000000</iyz>\n          <izz>0.001000</izz>\n        </inertia>\n      </inertial>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='l_gripper_motor_screw_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.939280 0.188000 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.010000</mass>\n        <inertia>\n          <ixx>0.000100</ixx>\n          <ixy>0.000000</ixy>\n          <ixz>0.000000</ixz>\n          <iyy>0.000100</iyy>\n          <iyz>0.000000</iyz>\n          <izz>0.000100</izz>\n        </inertia>\n      </inertial>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='l_gripper_r_finger_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.847910 0.178000 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.173890</mass>\n        <pose>0.035760 -0.017360 -0.000950 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.000077</ixx>\n          <ixy>-0.000002</ixy>\n          <ixz>-0.000008</ixz>\n          <iyy>0.000198</iyy>\n          <iyz>0.000002</iyz>\n          <izz>0.000181</izz>\n        </inertia>\n      </inertial>\n      <collision name='l_gripper_r_finger_link_geom'>\n        <pose>0.000000 0.000000 0.000000 -3.141590 0.000000 0.000000</pose>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/gripper_v0/l_finger.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <friction>\n            <ode>\n              <mu>500.000000</mu>\n              <mu2>500.000000</mu2>\n              <slip1>0.000000</slip1>\n              <slip2>0.000000</slip2>\n            </ode>\n          </friction>\n          <contact>\n            <ode>\n              <kp>1000000.000000</kp>\n              <kd>1.000000</kd>\n              <max_vel>100.000000</max_vel>\n              <min_depth>0.000000</min_depth>\n            </ode>\n          </contact>\n          <bounce/>\n        </surface>\n      </collision>\n      <visual name='l_gripper_r_finger_link_geom_visual'>\n        <pose>0.000000 0.000000 0.000000 -3.141590 0.000000 0.000000</pose>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/gripper_v0/l_finger.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='l_gripper_r_finger_tip_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.939280 0.173050 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.044190</mass>\n        <pose>0.004230 -0.002840 0.000000 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.000008</ixx>\n          <ixy>-0.000006</ixy>\n          <ixz>0.000000</ixz>\n          <iyy>0.000010</iyy>\n          <iyz>0.000000</iyz>\n          <izz>0.000015</izz>\n        </inertia>\n      </inertial>\n      <collision name='l_gripper_r_finger_tip_link_geom'>\n        <pose>0.000000 0.000000 0.000000 -3.141590 0.000000 0.000000</pose>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/gripper_v0/l_finger_tip.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <friction>\n            <ode>\n              <mu>500.000000</mu>\n              <mu2>500.000000</mu2>\n              <slip1>0.000000</slip1>\n              <slip2>0.000000</slip2>\n            </ode>\n          </friction>\n          <contact>\n            <ode>\n              <kp>10000000.000000</kp>\n              <kd>1.000000</kd>\n              <max_vel>100.000000</max_vel>\n              <min_depth>0.000000</min_depth>\n            </ode>\n          </contact>\n          <bounce/>\n        </surface>\n      </collision>\n      <visual name='l_gripper_r_finger_tip_link_geom_visual'>\n        <pose>0.000000 0.000000 0.000000 -3.141590 0.000000 0.000000</pose>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/gripper_v0/l_finger_tip.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <sensor name='l_gripper_r_finger_tip_contact_sensor' type='contact'>\n        <update_rate>100.000000</update_rate>\n        <always_on>0</always_on>\n        <visualize>0</visualize>\n        <contact>\n          <collision>l_gripper_r_finger_tip_link_geom</collision>\n          <topic>__default_topic__</topic>\n        </contact>\n      </sensor>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='laser_tilt_mount_link'>\n      <self_collide>0</self_collide>\n      <pose>0.048930 0.000000 1.017680 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.592000</mass>\n        <pose>-0.001134 0.001667 -0.007067 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.001296</ixx>\n          <ixy>0.000023</ixy>\n          <ixz>0.000037</ixz>\n          <iyy>0.001086</iyy>\n          <iyz>0.000035</iyz>\n          <izz>0.000895</izz>\n        </inertia>\n      </inertial>\n      <collision name='laser_tilt_mount_link_geom'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/tilting_laser_v0/tilting_hokuyo_L.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <friction>\n            <ode>\n              <mu>0.000000</mu>\n              <mu2>0.000000</mu2>\n              <slip1>0.000000</slip1>\n              <slip2>0.000000</slip2>\n            </ode>\n          </friction>\n          <contact>\n            <ode>\n              <kp>1000000000000.000000</kp>\n              <kd>10000.000000</kd>\n              <max_vel>100.000000</max_vel>\n              <min_depth>0.000000</min_depth>\n            </ode>\n          </contact>\n          <bounce/>\n        </surface>\n      </collision>\n      <visual name='laser_tilt_mount_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/tilting_laser_v0/tilting_hokuyo.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <sensor name='laser_tilt' type='ray'>\n        <update_rate>40.000000</update_rate>\n        <pose>0.000000 0.000000 0.030000 0.000000 0.000000 0.000000</pose>\n        <always_on>0</always_on>\n        <visualize>0</visualize>\n        <ray>\n          <scan>\n            <horizontal>\n              <samples>640</samples>\n              <resolution>1.000000</resolution>\n              <min_angle>-1.396263</min_angle>\n              <max_angle>1.396263</max_angle>\n            </horizontal>\n          </scan>\n          <range>\n            <min>0.080000</min>\n            <max>10.000000</max>\n            <resolution>0.010000</resolution>\n          </range>\n        </ray>\n      </sensor>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n      <gravity>1</gravity>\n    </link>\n    <link name='r_shoulder_pan_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>-0.050000 -0.188000 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>25.799300</mass>\n        <pose>-0.001201 0.024513 -0.098231 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.866179</ixx>\n          <ixy>-0.060865</ixy>\n          <ixz>-0.121181</ixz>\n          <iyy>0.874217</iyy>\n          <iyz>-0.058866</iyz>\n          <izz>0.273538</izz>\n        </inertia>\n      </inertial>\n      <collision name='r_shoulder_pan_link_geom'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/shoulder_v0/shoulder_pan.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <friction>\n            <ode>\n              <mu>0.000000</mu>\n              <mu2>0.000000</mu2>\n              <slip1>0.000000</slip1>\n              <slip2>0.000000</slip2>\n            </ode>\n          </friction>\n          <contact>\n            <ode>\n              <kp>1000000000000.000000</kp>\n              <kd>10000.000000</kd>\n              <max_vel>100.000000</max_vel>\n              <min_depth>0.000000</min_depth>\n            </ode>\n          </contact>\n          <bounce/>\n        </surface>\n      </collision>\n      <visual name='r_shoulder_pan_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/shoulder_v0/shoulder_pan.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='r_shoulder_lift_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.050000 -0.188000 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>2.749880</mass>\n        <pose>0.021950 -0.026640 -0.031270 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.021056</ixx>\n          <ixy>0.004967</ixy>\n          <ixz>-0.001948</ixz>\n          <iyy>0.021272</iyy>\n          <iyz>0.001104</iyz>\n          <izz>0.019758</izz>\n        </inertia>\n      </inertial>\n      <collision name='r_shoulder_lift_link_geom'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/shoulder_v0/shoulder_lift.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <friction>\n            <ode>\n              <mu>0.000000</mu>\n              <mu2>0.000000</mu2>\n              <slip1>0.000000</slip1>\n              <slip2>0.000000</slip2>\n            </ode>\n          </friction>\n          <contact>\n            <ode>\n              <kp>1000000000000.000000</kp>\n              <kd>10000.000000</kd>\n              <max_vel>100.000000</max_vel>\n              <min_depth>0.000000</min_depth>\n            </ode>\n          </contact>\n          <bounce/>\n        </surface>\n      </collision>\n      <visual name='r_shoulder_lift_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/shoulder_v0/shoulder_lift.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='r_upper_arm_roll_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.050000 -0.188000 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>6.117690</mass>\n        <pose>0.210482 -0.015945 -0.000197 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.025378</ixx>\n          <ixy>0.003757</ixy>\n          <ixz>-0.000709</ixz>\n          <iyy>0.084737</iyy>\n          <iyz>-0.000179</iyz>\n          <izz>0.086088</izz>\n        </inertia>\n      </inertial>\n      <collision name='r_upper_arm_roll_link_geom'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/shoulder_v0/upper_arm_roll_L.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='r_upper_arm_roll_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/shoulder_v0/upper_arm_roll.stl</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <collision name='r_upper_arm_roll_link_geom_r_upper_arm_link'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/upper_arm_v0/upper_arm.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='r_upper_arm_roll_link_geom_r_upper_arm_link_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/upper_arm_v0/upper_arm.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='r_elbow_flex_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.450000 -0.188000 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>1.903270</mass>\n        <pose>0.010140 0.000320 -0.012110 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.003465</ixx>\n          <ixy>0.000041</ixy>\n          <ixz>0.000432</ixz>\n          <iyy>0.004416</iyy>\n          <iyz>-0.000040</iyz>\n          <izz>0.003592</izz>\n        </inertia>\n      </inertial>\n      <collision name='r_elbow_flex_link_geom'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/upper_arm_v0/elbow_flex.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='r_elbow_flex_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/upper_arm_v0/elbow_flex.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='r_forearm_roll_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.450000 -0.188000 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>2.689680</mass>\n        <pose>0.180727 -0.000163 -0.008583 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.014668</ixx>\n          <ixy>0.000052</ixy>\n          <ixz>0.000656</ixz>\n          <iyy>0.026279</iyy>\n          <iyz>-0.000013</iyz>\n          <izz>0.027775</izz>\n        </inertia>\n      </inertial>\n      <collision name='r_forearm_roll_link_geom'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/upper_arm_v0/forearm_roll_L.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='r_forearm_roll_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/upper_arm_v0/forearm_roll.stl</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <collision name='r_forearm_roll_link_geom_r_forearm_link'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/forearm_v0/forearm.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='r_forearm_roll_link_geom_r_forearm_link_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/forearm_v0/forearm.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <sensor name='r_forearm_cam_sensor' type='camera'>\n        <update_rate>25.000000</update_rate>\n        <pose>0.135000 0.000000 0.044000 1.570800 -0.562869 -0.000000</pose>\n        <always_on>0</always_on>\n        <visualize>0</visualize>\n        <camera name='__default__'>\n          <horizontal_fov>1.570796</horizontal_fov>\n          <image>\n            <width>640</width>\n            <height>480</height>\n            <format>R8G8B8</format>\n          </image>\n          <clip>\n            <near>0.100000</near>\n            <far>100.000000</far>\n          </clip>\n        </camera>\n      </sensor>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='r_wrist_flex_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.771000 -0.188000 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.614020</mass>\n        <pose>-0.001570 0.000000 -0.000750 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.000652</ixx>\n          <ixy>0.000000</ixy>\n          <ixz>0.000003</ixz>\n          <iyy>0.000198</iyy>\n          <iyz>0.000000</iyz>\n          <izz>0.000645</izz>\n        </inertia>\n      </inertial>\n      <collision name='r_wrist_flex_link_geom'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/forearm_v0/wrist_flex.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='r_wrist_flex_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/forearm_v0/wrist_flex.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='r_wrist_roll_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.771000 -0.188000 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.681070</mass>\n        <pose>0.056408 0.000451 -0.001014 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.011352</ixx>\n          <ixy>-0.000016</ixy>\n          <ixz>-0.000001</ixz>\n          <iyy>0.011677</iyy>\n          <iyz>-0.000001</iyz>\n          <izz>0.011866</izz>\n        </inertia>\n      </inertial>\n      <collision name='r_wrist_roll_link_geom'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/forearm_v0/wrist_roll_L.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='r_wrist_roll_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/forearm_v0/wrist_roll.stl</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <collision name='r_wrist_roll_link_geom_r_gripper_motor_accelerometer_link'>\n        <geometry>\n          <box>\n            <size>0.001000 0.001000 0.001000</size>\n          </box>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='r_wrist_roll_link_geom_r_gripper_motor_accelerometer_link_visual'>\n        <geometry>\n          <box>\n            <size>0.001000 0.001000 0.001000</size>\n          </box>\n        </geometry>\n      </visual>\n      <collision name='r_wrist_roll_link_geom_r_gripper_palm_link'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/gripper_v0/gripper_palm.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='r_wrist_roll_link_geom_r_gripper_palm_link_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/gripper_v0/gripper_palm.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='r_gripper_l_finger_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.847910 -0.178000 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.171260</mass>\n        <pose>0.035980 0.017300 -0.001640 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.000078</ixx>\n          <ixy>0.000001</ixy>\n          <ixz>0.000010</ixz>\n          <iyy>0.000197</iyy>\n          <iyz>-0.000003</iyz>\n          <izz>0.000181</izz>\n        </inertia>\n      </inertial>\n      <collision name='r_gripper_l_finger_link_geom'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/gripper_v0/l_finger.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <friction>\n            <ode>\n              <mu>500.000000</mu>\n              <mu2>500.000000</mu2>\n              <slip1>0.000000</slip1>\n              <slip2>0.000000</slip2>\n            </ode>\n          </friction>\n          <contact>\n            <ode>\n              <kp>1000000.000000</kp>\n              <kd>1.000000</kd>\n              <max_vel>100.000000</max_vel>\n              <min_depth>0.000000</min_depth>\n            </ode>\n          </contact>\n          <bounce/>\n        </surface>\n      </collision>\n      <visual name='r_gripper_l_finger_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/gripper_v0/l_finger.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='r_gripper_l_finger_tip_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.939280 -0.173050 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.044190</mass>\n        <pose>0.004230 0.002840 0.000000 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.000008</ixx>\n          <ixy>0.000006</ixy>\n          <ixz>0.000000</ixz>\n          <iyy>0.000010</iyy>\n          <iyz>0.000000</iyz>\n          <izz>0.000015</izz>\n        </inertia>\n      </inertial>\n      <collision name='r_gripper_l_finger_tip_link_geom'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/gripper_v0/l_finger_tip.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <friction>\n            <ode>\n              <mu>500.000000</mu>\n              <mu2>500.000000</mu2>\n              <slip1>0.000000</slip1>\n              <slip2>0.000000</slip2>\n            </ode>\n          </friction>\n          <contact>\n            <ode>\n              <kp>10000000.000000</kp>\n              <kd>1.000000</kd>\n              <max_vel>100.000000</max_vel>\n              <min_depth>0.000000</min_depth>\n            </ode>\n          </contact>\n          <bounce/>\n        </surface>\n      </collision>\n      <visual name='r_gripper_l_finger_tip_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/gripper_v0/l_finger_tip.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <sensor name='r_gripper_l_finger_tip_contact_sensor' type='contact'>\n        <update_rate>100.000000</update_rate>\n        <always_on>0</always_on>\n        <visualize>0</visualize>\n        <contact>\n          <collision>r_gripper_l_finger_tip_link_geom</collision>\n          <topic>__default_topic__</topic>\n        </contact>\n      </sensor>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='r_gripper_motor_slider_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.939280 -0.188000 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.010000</mass>\n        <inertia>\n          <ixx>0.001000</ixx>\n          <ixy>0.000000</ixy>\n          <ixz>0.000000</ixz>\n          <iyy>0.001000</iyy>\n          <iyz>0.000000</iyz>\n          <izz>0.001000</izz>\n        </inertia>\n      </inertial>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='r_gripper_motor_screw_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.939280 -0.188000 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.010000</mass>\n        <inertia>\n          <ixx>0.000100</ixx>\n          <ixy>0.000000</ixy>\n          <ixz>0.000000</ixz>\n          <iyy>0.000100</iyy>\n          <iyz>0.000000</iyz>\n          <izz>0.000100</izz>\n        </inertia>\n      </inertial>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='r_gripper_r_finger_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.847910 -0.198000 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.173890</mass>\n        <pose>0.035760 -0.017360 -0.000950 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.000077</ixx>\n          <ixy>-0.000002</ixy>\n          <ixz>-0.000008</ixz>\n          <iyy>0.000198</iyy>\n          <iyz>0.000002</iyz>\n          <izz>0.000181</izz>\n        </inertia>\n      </inertial>\n      <collision name='r_gripper_r_finger_link_geom'>\n        <pose>0.000000 0.000000 0.000000 -3.141590 0.000000 0.000000</pose>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/gripper_v0/l_finger.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <friction>\n            <ode>\n              <mu>500.000000</mu>\n              <mu2>500.000000</mu2>\n              <slip1>0.000000</slip1>\n              <slip2>0.000000</slip2>\n            </ode>\n          </friction>\n          <contact>\n            <ode>\n              <kp>1000000.000000</kp>\n              <kd>1.000000</kd>\n              <max_vel>100.000000</max_vel>\n              <min_depth>0.000000</min_depth>\n            </ode>\n          </contact>\n          <bounce/>\n        </surface>\n      </collision>\n      <visual name='r_gripper_r_finger_link_geom_visual'>\n        <pose>0.000000 0.000000 0.000000 -3.141590 0.000000 0.000000</pose>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/gripper_v0/l_finger.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='r_gripper_r_finger_tip_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.939280 -0.202950 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.044190</mass>\n        <pose>0.004230 -0.002840 0.000000 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.000008</ixx>\n          <ixy>-0.000006</ixy>\n          <ixz>0.000000</ixz>\n          <iyy>0.000010</iyy>\n          <iyz>0.000000</iyz>\n          <izz>0.000015</izz>\n        </inertia>\n      </inertial>\n      <collision name='r_gripper_r_finger_tip_link_geom'>\n        <pose>0.000000 0.000000 0.000000 -3.141590 0.000000 0.000000</pose>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/gripper_v0/l_finger_tip.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <friction>\n            <ode>\n              <mu>500.000000</mu>\n              <mu2>500.000000</mu2>\n              <slip1>0.000000</slip1>\n              <slip2>0.000000</slip2>\n            </ode>\n          </friction>\n          <contact>\n            <ode>\n              <kp>10000000.000000</kp>\n              <kd>1.000000</kd>\n              <max_vel>100.000000</max_vel>\n              <min_depth>0.000000</min_depth>\n            </ode>\n          </contact>\n          <bounce/>\n        </surface>\n      </collision>\n      <visual name='r_gripper_r_finger_tip_link_geom_visual'>\n        <pose>0.000000 0.000000 0.000000 -3.141590 0.000000 0.000000</pose>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/gripper_v0/l_finger_tip.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <sensor name='r_gripper_r_finger_tip_contact_sensor' type='contact'>\n        <update_rate>100.000000</update_rate>\n        <always_on>0</always_on>\n        <visualize>0</visualize>\n        <contact>\n          <collision>r_gripper_r_finger_tip_link_geom</collision>\n          <topic>__default_topic__</topic>\n        </contact>\n      </sensor>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='torso_lift_motor_screw_link'>\n      <self_collide>0</self_collide>\n      <pose>-0.150000 0.000000 0.751000 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>1.000000</mass>\n        <inertia>\n          <ixx>0.001000</ixx>\n          <ixy>0.000000</ixy>\n          <ixz>0.000000</ixz>\n          <iyy>0.001000</iyy>\n          <iyz>0.000000</iyz>\n          <izz>0.001000</izz>\n        </inertia>\n      </inertial>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n      <gravity>1</gravity>\n    </link>\n    <link name='r_gripper_l_parallel_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.829910 -0.157000 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.171260</mass>\n        <pose>0.035980 0.017300 -0.001640 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.000078</ixx>\n          <ixy>0.000001</ixy>\n          <ixz>-0.000010</ixz>\n          <iyy>0.000197</iyy>\n          <iyz>-0.000003</iyz>\n          <izz>0.000181</izz>\n        </inertia>\n      </inertial>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='r_gripper_r_parallel_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.829910 -0.219000 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.173890</mass>\n        <pose>0.035760 -0.017360 -0.000950 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.000077</ixx>\n          <ixy>-0.000002</ixy>\n          <ixz>-0.000008</ixz>\n          <iyy>0.000198</iyy>\n          <iyz>0.000002</iyz>\n          <izz>0.000181</izz>\n        </inertia>\n      </inertial>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='l_gripper_l_parallel_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.829910 0.219000 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.171260</mass>\n        <pose>0.035980 0.017300 -0.001640 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.000078</ixx>\n          <ixy>0.000001</ixy>\n          <ixz>0.000010</ixz>\n          <iyy>0.000197</iyy>\n          <iyz>-0.000003</iyz>\n          <izz>0.000181</izz>\n        </inertia>\n      </inertial>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='l_gripper_r_parallel_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.829910 0.157000 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.173890</mass>\n        <pose>0.035760 -0.017360 -0.000950 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.000077</ixx>\n          <ixy>-0.000002</ixy>\n          <ixz>0.000008</ixz>\n          <iyy>0.000198</iyy>\n          <iyz>0.000002</iyz>\n          <izz>0.000181</izz>\n        </inertia>\n      </inertial>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <joint name='bl_caster_rotation_joint' type='revolute'>\n      <parent>base_footprint</parent>\n      <child>bl_caster_rotation_link</child>\n      <axis>\n        <xyz>0.000000 0.000000 1.000000</xyz>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='bl_caster_l_wheel_joint' type='revolute'>\n      <parent>bl_caster_rotation_link</parent>\n      <child>bl_caster_l_wheel_link</child>\n      <axis>\n        <xyz>0.000000 1.000000 0.000000</xyz>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='bl_caster_r_wheel_joint' type='revolute'>\n      <parent>bl_caster_rotation_link</parent>\n      <child>bl_caster_r_wheel_link</child>\n      <axis>\n        <xyz>0.000000 1.000000 0.000000</xyz>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='br_caster_rotation_joint' type='revolute'>\n      <parent>base_footprint</parent>\n      <child>br_caster_rotation_link</child>\n      <axis>\n        <xyz>0.000000 0.000000 1.000000</xyz>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='br_caster_l_wheel_joint' type='revolute'>\n      <parent>br_caster_rotation_link</parent>\n      <child>br_caster_l_wheel_link</child>\n      <axis>\n        <xyz>0.000000 1.000000 0.000000</xyz>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='br_caster_r_wheel_joint' type='revolute'>\n      <parent>br_caster_rotation_link</parent>\n      <child>br_caster_r_wheel_link</child>\n      <axis>\n        <xyz>0.000000 1.000000 0.000000</xyz>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='fl_caster_rotation_joint' type='revolute'>\n      <parent>base_footprint</parent>\n      <child>fl_caster_rotation_link</child>\n      <axis>\n        <xyz>0.000000 0.000000 1.000000</xyz>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='fl_caster_l_wheel_joint' type='revolute'>\n      <parent>fl_caster_rotation_link</parent>\n      <child>fl_caster_l_wheel_link</child>\n      <axis>\n        <xyz>0.000000 1.000000 0.000000</xyz>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='fl_caster_r_wheel_joint' type='revolute'>\n      <parent>fl_caster_rotation_link</parent>\n      <child>fl_caster_r_wheel_link</child>\n      <axis>\n        <xyz>0.000000 1.000000 0.000000</xyz>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='fr_caster_rotation_joint' type='revolute'>\n      <parent>base_footprint</parent>\n      <child>fr_caster_rotation_link</child>\n      <axis>\n        <xyz>0.000000 0.000000 1.000000</xyz>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='fr_caster_l_wheel_joint' type='revolute'>\n      <parent>fr_caster_rotation_link</parent>\n      <child>fr_caster_l_wheel_link</child>\n      <axis>\n        <xyz>0.000000 1.000000 0.000000</xyz>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='fr_caster_r_wheel_joint' type='revolute'>\n      <parent>fr_caster_rotation_link</parent>\n      <child>fr_caster_r_wheel_link</child>\n      <axis>\n        <xyz>0.000000 1.000000 0.000000</xyz>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='torso_lift_joint' type='prismatic'>\n      <parent>base_footprint</parent>\n      <child>torso_lift_link</child>\n      <axis>\n        <xyz>0.000000 0.000000 1.000000</xyz>\n        <limit>\n          <lower>0.000000</lower>\n          <upper>0.330000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='head_pan_joint' type='revolute'>\n      <parent>torso_lift_link</parent>\n      <child>head_pan_link</child>\n      <axis>\n        <xyz>0.000000 0.000000 1.000000</xyz>\n        <dynamics>\n          <damping>2.000000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-3.006993</lower>\n          <upper>3.006993</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='head_tilt_joint' type='revolute'>\n      <parent>head_pan_link</parent>\n      <child>head_tilt_link</child>\n      <axis>\n        <xyz>0.000000 1.000000 0.000000</xyz>\n        <dynamics>\n          <damping>10.000000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-0.471237</lower>\n          <upper>1.396260</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='l_shoulder_pan_joint' type='revolute'>\n      <parent>torso_lift_link</parent>\n      <child>l_shoulder_pan_link</child>\n      <axis>\n        <xyz>0.000000 0.000000 1.000000</xyz>\n        <dynamics>\n          <damping>10.000000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-0.714602</lower>\n          <upper>2.285404</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='l_shoulder_lift_joint' type='revolute'>\n      <parent>l_shoulder_pan_link</parent>\n      <child>l_shoulder_lift_link</child>\n      <axis>\n        <xyz>0.000000 1.000000 0.000000</xyz>\n        <dynamics>\n          <damping>10.000000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-0.523601</lower>\n          <upper>1.396300</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='l_upper_arm_roll_joint' type='revolute'>\n      <parent>l_shoulder_lift_link</parent>\n      <child>l_upper_arm_roll_link</child>\n      <axis>\n        <xyz>1.000000 0.000000 0.000000</xyz>\n        <dynamics>\n          <damping>0.100000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-0.800000</lower>\n          <upper>3.900008</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='l_elbow_flex_joint' type='revolute'>\n      <parent>l_upper_arm_roll_link</parent>\n      <child>l_elbow_flex_link</child>\n      <axis>\n        <xyz>0.000000 1.000000 0.000000</xyz>\n        <dynamics>\n          <damping>1.000000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-2.321305</lower>\n          <upper>0.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='l_forearm_roll_joint' type='revolute'>\n      <parent>l_elbow_flex_link</parent>\n      <child>l_forearm_roll_link</child>\n      <axis>\n        <xyz>1.000000 0.000000 0.000000</xyz>\n        <dynamics>\n          <damping>0.100000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='l_wrist_flex_joint' type='revolute'>\n      <parent>l_forearm_roll_link</parent>\n      <child>l_wrist_flex_link</child>\n      <axis>\n        <xyz>0.000000 1.000000 0.000000</xyz>\n        <dynamics>\n          <damping>0.100000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-2.180004</lower>\n          <upper>0.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='l_wrist_roll_joint' type='revolute'>\n      <parent>l_wrist_flex_link</parent>\n      <child>l_wrist_roll_link</child>\n      <axis>\n        <xyz>1.000000 0.000000 0.000000</xyz>\n        <dynamics>\n          <damping>0.100000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='l_gripper_l_finger_joint' type='revolute'>\n      <parent>l_wrist_roll_link</parent>\n      <child>l_gripper_l_finger_link</child>\n      <axis>\n        <xyz>0.000000 0.000000 1.000000</xyz>\n        <dynamics>\n          <damping>0.020000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>0.000000</lower>\n          <upper>0.548000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='l_gripper_l_finger_tip_joint' type='revolute'>\n      <parent>l_gripper_l_finger_link</parent>\n      <child>l_gripper_l_finger_tip_link</child>\n      <axis>\n        <xyz>0.000000 0.000000 -1.000000</xyz>\n        <dynamics>\n          <damping>0.001000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>0.000000</lower>\n          <upper>0.548000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='l_gripper_motor_slider_joint' type='prismatic'>\n      <parent>l_wrist_roll_link</parent>\n      <child>l_gripper_motor_slider_link</child>\n      <axis>\n        <xyz>1.000000 0.000000 0.000000</xyz>\n        <limit>\n          <lower>-0.100000</lower>\n          <upper>0.100000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='l_gripper_motor_screw_joint' type='revolute'>\n      <parent>l_gripper_motor_slider_link</parent>\n      <child>l_gripper_motor_screw_link</child>\n      <axis>\n        <xyz>0.000000 1.000000 0.000000</xyz>\n        <dynamics>\n          <damping>0.000100</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='l_gripper_r_finger_joint' type='revolute'>\n      <parent>l_wrist_roll_link</parent>\n      <child>l_gripper_r_finger_link</child>\n      <axis>\n        <xyz>0.000000 0.000000 -1.000000</xyz>\n        <dynamics>\n          <damping>0.020000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>0.000000</lower>\n          <upper>0.548000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='l_gripper_r_finger_tip_joint' type='revolute'>\n      <parent>l_gripper_r_finger_link</parent>\n      <child>l_gripper_r_finger_tip_link</child>\n      <axis>\n        <xyz>0.000000 0.000000 1.000000</xyz>\n        <dynamics>\n          <damping>0.001000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>0.000000</lower>\n          <upper>0.548000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='laser_tilt_mount_joint' type='revolute'>\n      <parent>torso_lift_link</parent>\n      <child>laser_tilt_mount_link</child>\n      <axis>\n        <xyz>0.000000 1.000000 0.000000</xyz>\n        <dynamics>\n          <damping>0.008000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-0.785400</lower>\n          <upper>1.483530</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='r_shoulder_pan_joint' type='revolute'>\n      <parent>torso_lift_link</parent>\n      <child>r_shoulder_pan_link</child>\n      <axis>\n        <xyz>0.000000 0.000000 1.000000</xyz>\n        <dynamics>\n          <damping>10.000000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-2.285404</lower>\n          <upper>0.714602</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='r_shoulder_lift_joint' type='revolute'>\n      <parent>r_shoulder_pan_link</parent>\n      <child>r_shoulder_lift_link</child>\n      <axis>\n        <xyz>0.000000 1.000000 0.000000</xyz>\n        <dynamics>\n          <damping>10.000000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-0.523601</lower>\n          <upper>1.396300</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='r_upper_arm_roll_joint' type='revolute'>\n      <parent>r_shoulder_lift_link</parent>\n      <child>r_upper_arm_roll_link</child>\n      <axis>\n        <xyz>1.000000 0.000000 0.000000</xyz>\n        <dynamics>\n          <damping>0.100000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-3.900008</lower>\n          <upper>0.800000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='r_elbow_flex_joint' type='revolute'>\n      <parent>r_upper_arm_roll_link</parent>\n      <child>r_elbow_flex_link</child>\n      <axis>\n        <xyz>0.000000 1.000000 0.000000</xyz>\n        <dynamics>\n          <damping>1.000000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-2.321305</lower>\n          <upper>0.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='r_forearm_roll_joint' type='revolute'>\n      <parent>r_elbow_flex_link</parent>\n      <child>r_forearm_roll_link</child>\n      <axis>\n        <xyz>1.000000 0.000000 0.000000</xyz>\n        <dynamics>\n          <damping>0.100000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='r_wrist_flex_joint' type='revolute'>\n      <parent>r_forearm_roll_link</parent>\n      <child>r_wrist_flex_link</child>\n      <axis>\n        <xyz>0.000000 1.000000 0.000000</xyz>\n        <dynamics>\n          <damping>0.100000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-2.180004</lower>\n          <upper>0.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='r_wrist_roll_joint' type='revolute'>\n      <parent>r_wrist_flex_link</parent>\n      <child>r_wrist_roll_link</child>\n      <axis>\n        <xyz>1.000000 0.000000 0.000000</xyz>\n        <dynamics>\n          <damping>0.100000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='r_gripper_l_finger_joint' type='revolute'>\n      <parent>r_wrist_roll_link</parent>\n      <child>r_gripper_l_finger_link</child>\n      <axis>\n        <xyz>0.000000 0.000000 1.000000</xyz>\n        <dynamics>\n          <damping>0.020000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>0.000000</lower>\n          <upper>0.548000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='r_gripper_l_finger_tip_joint' type='revolute'>\n      <parent>r_gripper_l_finger_link</parent>\n      <child>r_gripper_l_finger_tip_link</child>\n      <axis>\n        <xyz>0.000000 0.000000 -1.000000</xyz>\n        <dynamics>\n          <damping>0.001000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>0.000000</lower>\n          <upper>0.548000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='r_gripper_motor_slider_joint' type='prismatic'>\n      <parent>r_wrist_roll_link</parent>\n      <child>r_gripper_motor_slider_link</child>\n      <axis>\n        <xyz>1.000000 0.000000 0.000000</xyz>\n        <dynamics>\n          <damping>0.000000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-0.100000</lower>\n          <upper>0.100000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='r_gripper_motor_screw_joint' type='revolute'>\n      <parent>r_gripper_motor_slider_link</parent>\n      <child>r_gripper_motor_screw_link</child>\n      <axis>\n        <xyz>0.000000 1.000000 0.000000</xyz>\n        <dynamics>\n          <damping>0.000100</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='r_gripper_r_finger_joint' type='revolute'>\n      <parent>r_wrist_roll_link</parent>\n      <child>r_gripper_r_finger_link</child>\n      <axis>\n        <xyz>0.000000 0.000000 -1.000000</xyz>\n        <dynamics>\n          <damping>0.020000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>0.000000</lower>\n          <upper>0.548000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='r_gripper_r_finger_tip_joint' type='revolute'>\n      <parent>r_gripper_r_finger_link</parent>\n      <child>r_gripper_r_finger_tip_link</child>\n      <axis>\n        <xyz>0.000000 0.000000 1.000000</xyz>\n        <dynamics>\n          <damping>0.001000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>0.000000</lower>\n          <upper>0.548000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='torso_lift_motor_screw_joint' type='revolute'>\n      <parent>base_footprint</parent>\n      <child>torso_lift_motor_screw_link</child>\n      <axis>\n        <xyz>0.000000 0.000000 1.000000</xyz>\n        <dynamics>\n          <damping>0.000100</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='torso_lift_screw_torso_lift_joint' type='screw'>\n      <parent>torso_lift_link</parent>\n      <child>torso_lift_motor_screw_link</child>\n      <thread_pitch>3141.600000</thread_pitch>\n      <axis>\n        <xyz>0.000000 0.000000 1.000000</xyz>\n        <dynamics>\n          <damping>0.000000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='r_gripper_r_screw_screw_joint' type='screw'>\n      <parent>r_gripper_r_finger_tip_link</parent>\n      <child>r_gripper_motor_screw_link</child>\n      <thread_pitch>-3141.600000</thread_pitch>\n      <axis>\n        <xyz>0.000000 1.000000 0.000000</xyz>\n        <dynamics>\n          <damping>0.000000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='r_gripper_l_screw_screw_joint' type='screw'>\n      <parent>r_gripper_l_finger_tip_link</parent>\n      <child>r_gripper_motor_screw_link</child>\n      <thread_pitch>3141.600000</thread_pitch>\n      <axis>\n        <xyz>0.000000 1.000000 0.000000</xyz>\n        <dynamics>\n          <damping>0.000000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='r_gripper_r_parallel_root_joint' type='revolute'>\n      <pose>0.058910 -0.031000 0.000000 0.000000 0.000000 0.000000</pose>\n      <parent>r_gripper_r_parallel_link</parent>\n      <child>r_wrist_roll_link</child>\n      <axis>\n        <xyz>0.000000 0.000000 -1.000000</xyz>\n        <dynamics>\n          <damping>0.200000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='r_gripper_l_parallel_root_joint' type='revolute'>\n      <pose>0.058910 0.031000 0.000000 0.000000 0.000000 0.000000</pose>\n      <parent>r_gripper_l_parallel_link</parent>\n      <child>r_wrist_roll_link</child>\n      <axis>\n        <xyz>0.000000 0.000000 1.000000</xyz>\n        <dynamics>\n          <damping>0.200000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='r_gripper_r_parallel_tip_joint' type='revolute'>\n      <pose>-0.018000 -0.021000 0.000000 0.000000 0.000000 0.000000</pose>\n      <parent>r_gripper_r_parallel_link</parent>\n      <child>r_gripper_r_finger_tip_link</child>\n      <axis>\n        <xyz>0.000000 0.000000 1.000000</xyz>\n        <dynamics>\n          <damping>0.000000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='r_gripper_l_parallel_tip_joint' type='revolute'>\n      <pose>-0.018000 0.021000 0.000000 0.000000 0.000000 0.000000</pose>\n      <parent>r_gripper_l_parallel_link</parent>\n      <child>r_gripper_l_finger_tip_link</child>\n      <axis>\n        <xyz>0.000000 0.000000 1.000000</xyz>\n        <dynamics>\n          <damping>0.000000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='r_gripper_joint' type='prismatic'>\n      <parent>r_gripper_r_finger_tip_link</parent>\n      <child>r_gripper_l_finger_tip_link</child>\n      <axis>\n        <xyz>0.000000 1.000000 0.000000</xyz>\n        <dynamics>\n          <damping>0.000000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='l_gripper_r_screw_screw_joint' type='screw'>\n      <parent>l_gripper_r_finger_tip_link</parent>\n      <child>l_gripper_motor_screw_link</child>\n      <thread_pitch>-3141.600000</thread_pitch>\n      <axis>\n        <xyz>0.000000 1.000000 0.000000</xyz>\n        <dynamics>\n          <damping>0.000000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='l_gripper_l_screw_screw_joint' type='screw'>\n      <parent>l_gripper_l_finger_tip_link</parent>\n      <child>l_gripper_motor_screw_link</child>\n      <thread_pitch>3141.600000</thread_pitch>\n      <axis>\n        <xyz>0.000000 1.000000 0.000000</xyz>\n        <dynamics>\n          <damping>0.000000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='l_gripper_r_parallel_root_joint' type='revolute'>\n      <pose>0.058910 -0.031000 0.000000 0.000000 0.000000 0.000000</pose>\n      <parent>l_gripper_r_parallel_link</parent>\n      <child>l_wrist_roll_link</child>\n      <axis>\n        <xyz>0.000000 0.000000 -1.000000</xyz>\n        <dynamics>\n          <damping>0.200000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='l_gripper_l_parallel_root_joint' type='revolute'>\n      <pose>0.058910 0.031000 0.000000 0.000000 0.000000 0.000000</pose>\n      <parent>l_gripper_l_parallel_link</parent>\n      <child>l_wrist_roll_link</child>\n      <axis>\n        <xyz>0.000000 0.000000 1.000000</xyz>\n        <dynamics>\n          <damping>0.200000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='l_gripper_r_parallel_tip_joint' type='revolute'>\n      <pose>-0.018000 -0.021000 0.000000 0.000000 0.000000 0.000000</pose>\n      <parent>l_gripper_r_parallel_link</parent>\n      <child>l_gripper_r_finger_tip_link</child>\n      <axis>\n        <xyz>0.000000 0.000000 1.000000</xyz>\n        <dynamics>\n          <damping>0.000000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='l_gripper_l_parallel_tip_joint' type='revolute'>\n      <pose>-0.018000 0.021000 0.000000 0.000000 0.000000 0.000000</pose>\n      <parent>l_gripper_l_parallel_link</parent>\n      <child>l_gripper_l_finger_tip_link</child>\n      <axis>\n        <xyz>0.000000 0.000000 1.000000</xyz>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='l_gripper_joint' type='prismatic'>\n      <parent>l_gripper_r_finger_tip_link</parent>\n      <child>l_gripper_l_finger_tip_link</child>\n      <axis>\n        <xyz>0.000000 1.000000 0.000000</xyz>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n  </model>\n  <physics type='ode'>\n    <update_rate>1000.000000</update_rate>\n    <gravity>0.000000 0.000000 -9.800000</gravity>\n  </physics>\n  <scene>\n    <ambient>0.200000 0.200000 0.200000 1.000000</ambient>\n    <background>0.700000 0.700000 0.700000 1.000000</background>\n    <shadows>1</shadows>\n  </scene>\n  <state world_name='default'>\n    <sim_time>0 0</sim_time>\n    <real_time>0 0</real_time>\n    <wall_time>1360301755 667456998</wall_time>\n  </state>\n</world>\n</sdf>]]></chunk>\n<chunk encoding='txt'><![CDATA[\n<sdf version='1.4'>\n<state world_name='default'>\n<sim_time>0 21343973</sim_time>\n<real_time>0 1000000</real_time>\n<wall_time>1360301758 939690376</wall_time>\n<model name='pr2'>\n0.000000 \n</model>\n</sdf></state>\n]]></chunk>\n<chunk encoding='txt'><![CDATA[\n<sdf version='1.4'>\n<state world_name='default'>\n<sim_time>0 28958235</sim_time>\n<real_time>0 2000000</real_time>\n<wall_time>1360301758 947304437</wall_time>\n<model name='pr2'>\n0.000000 \n</model>\n</sdf></state>\n]]></chunk>\n</gazebo_log>";

static std::string pr2PoseXYStateLog =
"<?xml version='1.0'?>\n<gazebo_log>\n<header>\n<log_version>1.0</log_version>\n<gazebo_version>1.4.6</gazebo_version>\n<rand_seed>32606</rand_seed>\n</header>\n\n<chunk encoding='txt'><![CDATA[\n<sdf version ='1.3'>\n<world name='default'>\n  <model name='ground_plane'>\n    <static>1</static>\n    <link name='link'>\n      <collision name='collision'>\n        <geometry>\n          <plane>\n            <normal>0.000000 0.000000 1.000000</normal>\n            <size>100.000000 100.000000</size>\n          </plane>\n        </geometry>\n        <surface>\n          <friction>\n            <ode>\n              <mu>100.000000</mu>\n              <mu2>50.000000</mu2>\n            </ode>\n          </friction>\n          <bounce/>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='visual'>\n        <cast_shadows>0</cast_shadows>\n        <geometry>\n          <plane>\n            <normal>0.000000 0.000000 1.000000</normal>\n            <size>100.000000 100.000000</size>\n          </plane>\n        </geometry>\n        <material>\n          <script>\n            <uri>file://media/materials/scripts/gazebo.material</uri>\n            <name>Gazebo/Grey</name>\n          </script>\n        </material>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <self_collide>0</self_collide>\n      <kinematic>0</kinematic>\n      <gravity>1</gravity>\n    </link>\n  </model>\n  <light name='sun' type='directional'>\n    <cast_shadows>1</cast_shadows>\n    <pose>0.000000 0.000000 10.000000 0.000000 0.000000 0.000000</pose>\n    <diffuse>0.800000 0.800000 0.800000 1.000000</diffuse>\n    <specular>0.100000 0.100000 0.100000 1.000000</specular>\n    <attenuation>\n      <range>1000.000000</range>\n      <constant>0.900000</constant>\n      <linear>0.010000</linear>\n      <quadratic>0.001000</quadratic>\n    </attenuation>\n    <direction>-0.500000 0.500000 -1.000000</direction>\n  </light>\n  <model name='pr2'>\n    <static>0</static>\n    <link name='base_footprint'>\n      <self_collide>0</self_collide>\n      <inertial>\n        <mass>118.001000</mass>\n        <pose>-0.062421 0.000000 0.201365 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>8.431730</ixx>\n          <ixy>-0.009720</ixy>\n          <ixz>1.901570</ixz>\n          <iyy>8.533050</iyy>\n          <iyz>-0.007380</iyz>\n          <izz>3.787470</izz>\n        </inertia>\n      </inertial>\n      <collision name='base_footprint_geom'>\n        <pose>0.000000 0.000000 0.071000 0.000000 0.000000 0.000000</pose>\n        <geometry>\n          <box>\n            <size>0.001000 0.001000 0.001000</size>\n          </box>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='base_footprint_geom_visual'>\n        <geometry>\n          <box>\n            <size>0.010000 0.010000 0.010000</size>\n          </box>\n        </geometry>\n      </visual>\n      <collision name='base_footprint_geom_base_bellow_link'>\n        <pose>-0.290000 0.000000 0.851000 0.000000 0.000000 0.000000</pose>\n        <geometry>\n          <box>\n            <size>0.050000 0.370000 0.300000</size>\n          </box>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='base_footprint_geom_base_bellow_link_visual'>\n        <pose>-0.290000 0.000000 0.851000 0.000000 0.000000 0.000000</pose>\n        <geometry>\n          <box>\n            <size>0.050000 0.370000 0.300000</size>\n          </box>\n        </geometry>\n      </visual>\n      <collision name='base_footprint_geom_base_link'>\n        <pose>0.000000 0.000000 0.051000 0.000000 0.000000 0.000000</pose>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/base_v0/base_L.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='base_footprint_geom_base_link_visual'>\n        <pose>0.000000 0.000000 0.051000 0.000000 0.000000 0.000000</pose>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/base_v0/base.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <sensor name='base_contact_sensor' type='contact'>\n        <update_rate>100.000000</update_rate>\n        <always_on>0</always_on>\n        <visualize>0</visualize>\n        <contact>\n          <collision>base_footprint_geom_base_link</collision>\n          <topic>__default_topic__</topic>\n        </contact>\n        <plugin name='gazebo_contact' filename='libContactPlugin.so'/>\n      </sensor>\n      <sensor name='base_laser' type='ray'>\n        <always_on>0</always_on>\n        <visualize>0</visualize>\n        <update_rate>20.000000</update_rate>\n        <pose>0.275000 0.000000 0.303000 0.000000 0.000000 0.000000</pose>\n        <ray>\n          <scan>\n            <horizontal>\n              <samples>640</samples>\n              <resolution>1.000000</resolution>\n              <min_angle>-2.268900</min_angle>\n              <max_angle>2.268900</max_angle>\n            </horizontal>\n          </scan>\n          <range>\n            <min>0.080000</min>\n            <max>10.000000</max>\n            <resolution>0.010000</resolution>\n          </range>\n        </ray>\n        <plugin name='laser' filename='libRayPlugin.so'/>\n      </sensor>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n      <gravity>1</gravity>\n    </link>\n    <link name='bl_caster_rotation_link'>\n      <self_collide>0</self_collide>\n      <pose>-0.224600 0.224600 0.079200 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>3.473080</mass>\n        <pose>0.000000 0.000000 0.070000 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.012412</ixx>\n          <ixy>-0.000712</ixy>\n          <ixz>0.000503</ixz>\n          <iyy>0.015218</iyy>\n          <iyz>-0.000004</iyz>\n          <izz>0.011764</izz>\n        </inertia>\n      </inertial>\n      <collision name='bl_caster_rotation_link_geom'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/base_v0/caster_L.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='bl_caster_rotation_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/base_v0/caster.stl</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n      <gravity>1</gravity>\n    </link>\n    <link name='bl_caster_l_wheel_link'>\n      <self_collide>0</self_collide>\n      <pose>-0.224600 0.273600 0.079200 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.440360</mass>\n        <inertia>\n          <ixx>0.012412</ixx>\n          <ixy>-0.000712</ixy>\n          <ixz>0.000503</ixz>\n          <iyy>0.015218</iyy>\n          <iyz>-0.000004</iyz>\n          <izz>0.011764</izz>\n        </inertia>\n      </inertial>\n      <collision name='bl_caster_l_wheel_link_geom'>\n        <pose>0.000000 0.000000 0.000000 1.570800 0.000000 0.000000</pose>\n        <geometry>\n          <cylinder>\n            <radius>0.074792</radius>\n            <length>0.034000</length>\n          </cylinder>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='bl_caster_l_wheel_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/base_v0/wheel.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n      <gravity>1</gravity>\n    </link>\n    <link name='bl_caster_r_wheel_link'>\n      <self_collide>0</self_collide>\n      <pose>-0.224600 0.175600 0.079200 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.440360</mass>\n        <inertia>\n          <ixx>0.012412</ixx>\n          <ixy>0.000712</ixy>\n          <ixz>0.000503</ixz>\n          <iyy>0.015218</iyy>\n          <iyz>0.000004</iyz>\n          <izz>0.011764</izz>\n        </inertia>\n      </inertial>\n      <collision name='bl_caster_r_wheel_link_geom'>\n        <pose>0.000000 0.000000 0.000000 1.570800 0.000000 0.000000</pose>\n        <geometry>\n          <cylinder>\n            <radius>0.074792</radius>\n            <length>0.034000</length>\n          </cylinder>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='bl_caster_r_wheel_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/base_v0/wheel.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n      <gravity>1</gravity>\n    </link>\n    <link name='br_caster_rotation_link'>\n      <self_collide>0</self_collide>\n      <pose>-0.224600 -0.224600 0.079200 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>3.473080</mass>\n        <pose>0.000000 0.000000 0.070000 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.012412</ixx>\n          <ixy>-0.000712</ixy>\n          <ixz>0.000503</ixz>\n          <iyy>0.015218</iyy>\n          <iyz>-0.000004</iyz>\n          <izz>0.011764</izz>\n        </inertia>\n      </inertial>\n      <collision name='br_caster_rotation_link_geom'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/base_v0/caster_L.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='br_caster_rotation_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/base_v0/caster.stl</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n      <gravity>1</gravity>\n    </link>\n    <link name='br_caster_l_wheel_link'>\n      <self_collide>0</self_collide>\n      <pose>-0.224600 -0.175600 0.079200 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.440360</mass>\n        <inertia>\n          <ixx>0.012412</ixx>\n          <ixy>-0.000712</ixy>\n          <ixz>0.000503</ixz>\n          <iyy>0.015218</iyy>\n          <iyz>-0.000004</iyz>\n          <izz>0.011764</izz>\n        </inertia>\n      </inertial>\n      <collision name='br_caster_l_wheel_link_geom'>\n        <pose>0.000000 0.000000 0.000000 1.570800 0.000000 0.000000</pose>\n        <geometry>\n          <cylinder>\n            <radius>0.074792</radius>\n            <length>0.034000</length>\n          </cylinder>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='br_caster_l_wheel_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/base_v0/wheel.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n      <gravity>1</gravity>\n    </link>\n    <link name='br_caster_r_wheel_link'>\n      <self_collide>0</self_collide>\n      <pose>-0.224600 -0.273600 0.079200 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.440360</mass>\n        <inertia>\n          <ixx>0.012412</ixx>\n          <ixy>-0.000712</ixy>\n          <ixz>0.000503</ixz>\n          <iyy>0.015218</iyy>\n          <iyz>-0.000004</iyz>\n          <izz>0.011764</izz>\n        </inertia>\n      </inertial>\n      <collision name='br_caster_r_wheel_link_geom'>\n        <pose>0.000000 0.000000 0.000000 1.570800 0.000000 0.000000</pose>\n        <geometry>\n          <cylinder>\n            <radius>0.074792</radius>\n            <length>0.034000</length>\n          </cylinder>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='br_caster_r_wheel_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/base_v0/wheel.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n      <gravity>1</gravity>\n    </link>\n    <link name='fl_caster_rotation_link'>\n      <self_collide>0</self_collide>\n      <pose>0.224600 0.224600 0.079200 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>3.473080</mass>\n        <pose>0.000000 0.000000 0.070000 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.012412</ixx>\n          <ixy>-0.000712</ixy>\n          <ixz>0.000503</ixz>\n          <iyy>0.015218</iyy>\n          <iyz>-0.000004</iyz>\n          <izz>0.011764</izz>\n        </inertia>\n      </inertial>\n      <collision name='fl_caster_rotation_link_geom'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/base_v0/caster_L.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='fl_caster_rotation_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/base_v0/caster.stl</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n      <gravity>1</gravity>\n    </link>\n    <link name='fl_caster_l_wheel_link'>\n      <self_collide>0</self_collide>\n      <pose>0.224600 0.273600 0.079200 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.440360</mass>\n        <inertia>\n          <ixx>0.012412</ixx>\n          <ixy>-0.000712</ixy>\n          <ixz>0.000503</ixz>\n          <iyy>0.015218</iyy>\n          <iyz>-0.000004</iyz>\n          <izz>0.011764</izz>\n        </inertia>\n      </inertial>\n      <collision name='fl_caster_l_wheel_link_geom'>\n        <pose>0.000000 0.000000 0.000000 1.570800 0.000000 0.000000</pose>\n        <geometry>\n          <cylinder>\n            <radius>0.074792</radius>\n            <length>0.034000</length>\n          </cylinder>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='fl_caster_l_wheel_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/base_v0/wheel.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n      <gravity>1</gravity>\n    </link>\n    <link name='fl_caster_r_wheel_link'>\n      <self_collide>0</self_collide>\n      <pose>0.224600 0.175600 0.079200 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.440360</mass>\n        <inertia>\n          <ixx>0.012412</ixx>\n          <ixy>-0.000712</ixy>\n          <ixz>0.000503</ixz>\n          <iyy>0.015218</iyy>\n          <iyz>-0.000004</iyz>\n          <izz>0.011764</izz>\n        </inertia>\n      </inertial>\n      <collision name='fl_caster_r_wheel_link_geom'>\n        <pose>0.000000 0.000000 0.000000 1.570800 0.000000 0.000000</pose>\n        <geometry>\n          <cylinder>\n            <radius>0.074792</radius>\n            <length>0.034000</length>\n          </cylinder>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='fl_caster_r_wheel_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/base_v0/wheel.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n      <gravity>1</gravity>\n    </link>\n    <link name='fr_caster_rotation_link'>\n      <self_collide>0</self_collide>\n      <pose>0.224600 -0.224600 0.079200 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>3.473080</mass>\n        <pose>0.000000 0.000000 0.070000 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.012412</ixx>\n          <ixy>-0.000712</ixy>\n          <ixz>0.000503</ixz>\n          <iyy>0.015218</iyy>\n          <iyz>-0.000004</iyz>\n          <izz>0.011764</izz>\n        </inertia>\n      </inertial>\n      <collision name='fr_caster_rotation_link_geom'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/base_v0/caster_L.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='fr_caster_rotation_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/base_v0/caster.stl</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n      <gravity>1</gravity>\n    </link>\n    <link name='fr_caster_l_wheel_link'>\n      <self_collide>0</self_collide>\n      <pose>0.224600 -0.175600 0.079200 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.440360</mass>\n        <inertia>\n          <ixx>0.012412</ixx>\n          <ixy>-0.000712</ixy>\n          <ixz>0.000503</ixz>\n          <iyy>0.015218</iyy>\n          <iyz>-0.000004</iyz>\n          <izz>0.011764</izz>\n        </inertia>\n      </inertial>\n      <collision name='fr_caster_l_wheel_link_geom'>\n        <pose>0.000000 0.000000 0.000000 1.570800 0.000000 0.000000</pose>\n        <geometry>\n          <cylinder>\n            <radius>0.074792</radius>\n            <length>0.034000</length>\n          </cylinder>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='fr_caster_l_wheel_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/base_v0/wheel.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n      <gravity>1</gravity>\n    </link>\n    <link name='fr_caster_r_wheel_link'>\n      <self_collide>0</self_collide>\n      <pose>0.224600 -0.273600 0.079200 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.440360</mass>\n        <inertia>\n          <ixx>0.012412</ixx>\n          <ixy>-0.000712</ixy>\n          <ixz>0.000503</ixz>\n          <iyy>0.015218</iyy>\n          <iyz>-0.000004</iyz>\n          <izz>0.011764</izz>\n        </inertia>\n      </inertial>\n      <collision name='fr_caster_r_wheel_link_geom'>\n        <pose>0.000000 0.000000 0.000000 1.570800 0.000000 0.000000</pose>\n        <geometry>\n          <cylinder>\n            <radius>0.074792</radius>\n            <length>0.034000</length>\n          </cylinder>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='fr_caster_r_wheel_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/base_v0/wheel.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n      <gravity>1</gravity>\n    </link>\n    <link name='torso_lift_link'>\n      <self_collide>0</self_collide>\n      <pose>-0.050000 0.000000 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>36.449000</mass>\n        <pose>-0.099499 -0.000004 -0.086764 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>2.792330</ixx>\n          <ixy>0.004280</ixy>\n          <ixz>-0.160631</ixz>\n          <iyy>2.521060</iyy>\n          <iyz>0.029689</iyz>\n          <izz>0.536551</izz>\n        </inertia>\n      </inertial>\n      <collision name='torso_lift_link_geom'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/torso_v0/torso_lift_L.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='torso_lift_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/torso_v0/torso_lift.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <sensor name='torso_lift_contact_sensor' type='contact'>\n        <update_rate>100.000000</update_rate>\n        <always_on>0</always_on>\n        <visualize>0</visualize>\n        <contact>\n          <collision>torso_lift_link_geom</collision>\n          <topic>__default_topic__</topic>\n        </contact>\n      </sensor>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n      <gravity>1</gravity>\n    </link>\n    <link name='head_pan_link'>\n      <self_collide>0</self_collide>\n      <pose>-0.067070 0.000000 1.172130 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>6.339000</mass>\n        <pose>0.010907 0.031693 0.090507 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.032498</ixx>\n          <ixy>0.000636</ixy>\n          <ixz>0.002585</ixz>\n          <iyy>0.046546</iyy>\n          <iyz>-0.002453</iyz>\n          <izz>0.057653</izz>\n        </inertia>\n      </inertial>\n      <collision name='head_pan_link_geom'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/head_v0/head_pan_L.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='head_pan_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/head_v0/head_pan.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n      <gravity>1</gravity>\n    </link>\n    <link name='head_tilt_link'>\n      <projector name='projector_wg6802418_projector_wg6802418'>\n        <texture>stereo_projection_pattern_high_res_red.png</texture>\n        <fov>0.959931</fov>\n        <near_clip>0.100000</near_clip>\n        <far_clip>10.000000</far_clip>\n        <pose>0.023200 0.110000 0.119100 0.000000 -1.570793 0.000000</pose>\n      </projector>\n      <self_collide>0</self_collide>\n      <pose>0.000930 0.000000 1.172130 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>5.319000</mass>\n        <pose>-0.005151 -0.014635 0.072819 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.126134</ixx>\n          <ixy>0.000237</ixy>\n          <ixz>0.011881</ixz>\n          <iyy>0.165102</iyy>\n          <iyz>0.001606</iyz>\n          <izz>0.166947</izz>\n        </inertia>\n      </inertial>\n      <collision name='head_tilt_link_geom'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/head_v0/head_tilt_L.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='head_tilt_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/head_v0/head_tilt.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <collision name='head_tilt_link_geom_head_mount_kinect_ir_link'>\n        <pose>-0.147067 0.012500 0.291953 0.000000 0.000000 0.000000</pose>\n        <geometry>\n          <sphere>\n            <radius>0.000500</radius>\n          </sphere>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='head_tilt_link_geom_head_mount_kinect_ir_link_visual'>\n        <pose>-0.147067 0.012500 0.291953 0.000000 0.000000 0.000000</pose>\n        <geometry>\n          <sphere>\n            <radius>0.000250</radius>\n          </sphere>\n        </geometry>\n        <material>\n          <script>\n            <uri>__default__</uri>\n            <name>__default__</name>\n          </script>\n        </material>\n      </visual>\n      <collision name='head_tilt_link_geom_head_mount_kinect_rgb_link'>\n        <pose>-0.147067 0.017500 0.291953 0.000000 0.000000 0.000000</pose>\n        <geometry>\n          <sphere>\n            <radius>0.000500</radius>\n          </sphere>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='head_tilt_link_geom_head_mount_kinect_rgb_link_visual'>\n        <pose>-0.147067 0.017500 0.291953 0.000000 0.000000 0.000000</pose>\n        <geometry>\n          <sphere>\n            <radius>0.000250</radius>\n          </sphere>\n        </geometry>\n        <material>\n          <script>\n            <uri>__default__</uri>\n            <name>__default__</name>\n          </script>\n        </material>\n      </visual>\n      <collision name='head_tilt_link_geom_head_mount_link'>\n        <pose>-0.114800 0.000000 0.155500 0.000000 0.000000 0.000000</pose>\n        <geometry>\n          <sphere>\n            <radius>0.000500</radius>\n          </sphere>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='head_tilt_link_geom_head_mount_link_visual'>\n        <pose>-0.114800 0.000000 0.155500 0.000000 0.000000 0.000000</pose>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/sensors/kinect_prosilica_v0/115x100_swept_back--coarse.STL</uri>\n            <scale>0.001000 0.001000 0.001000</scale>\n          </mesh>\n        </geometry>\n      </visual>\n      <collision name='head_tilt_link_geom_head_mount_prosilica_link'>\n        <pose>-0.161257 0.012500 0.244421 0.000000 0.000000 0.000000</pose>\n        <geometry>\n          <sphere>\n            <radius>0.000500</radius>\n          </sphere>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='head_tilt_link_geom_head_mount_prosilica_link_visual'>\n        <pose>-0.161257 0.012500 0.244421 0.000000 0.000000 0.000000</pose>\n        <geometry>\n          <sphere>\n            <radius>0.000250</radius>\n          </sphere>\n        </geometry>\n        <material>\n          <script>\n            <uri>__default__</uri>\n            <name>__default__</name>\n          </script>\n        </material>\n      </visual>\n      <collision name='head_tilt_link_geom_head_plate_frame'>\n        <pose>0.023200 0.000000 0.064500 0.000000 0.000000 0.000000</pose>\n        <geometry>\n          <box>\n            <size>0.010000 0.010000 0.010000</size>\n          </box>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='head_tilt_link_geom_head_plate_frame_visual'>\n        <pose>0.023200 0.000000 0.064500 0.000000 0.000000 0.000000</pose>\n        <geometry>\n          <box>\n            <size>0.010000 0.010000 0.010000</size>\n          </box>\n        </geometry>\n        <material>\n          <script>\n            <uri>__default__</uri>\n            <name>__default__</name>\n          </script>\n        </material>\n      </visual>\n      <sensor name='head_mount_sensor' type='camera'>\n        <always_on>0</always_on>\n        <visualize>0</visualize>\n        <update_rate>1.000000</update_rate>\n        <pose>-0.147067 0.012500 0.291953 0.000000 0.000000 0.000000</pose>\n        <camera name='__default__'>\n          <horizontal_fov>0.994838</horizontal_fov>\n          <image>\n            <width>640</width>\n            <height>480</height>\n            <format>L8</format>\n          </image>\n          <clip>\n            <near>0.010000</near>\n            <far>5.000000</far>\n          </clip>\n        </camera>\n      </sensor>\n      <sensor name='head_mount_prosilica_link_sensor' type='camera'>\n        <update_rate>1.000000</update_rate>\n        <pose>-0.161257 0.012500 0.244421 0.000000 0.000000 0.000000</pose>\n        <always_on>0</always_on>\n        <visualize>0</visualize>\n        <camera name='__default__'>\n          <horizontal_fov>1.120501</horizontal_fov>\n          <image>\n            <width>320</width>\n            <height>240</height>\n            <format>R8G8B8</format>\n          </image>\n          <clip>\n            <near>0.100000</near>\n            <far>100.000000</far>\n          </clip>\n        </camera>\n      </sensor>\n      <sensor name='head_mount_prosilica_link_sim_pcd_sensor' type='camera'>\n        <update_rate>1.000000</update_rate>\n        <pose>-0.161257 0.012500 0.244421 0.000000 0.000000 0.000000</pose>\n        <always_on>0</always_on>\n        <visualize>0</visualize>\n        <camera name='__default__'>\n          <horizontal_fov>1.120501</horizontal_fov>\n          <image>\n            <width>320</width>\n            <height>240</height>\n            <format>R8G8B8</format>\n          </image>\n          <clip>\n            <near>0.100000</near>\n            <far>100.000000</far>\n          </clip>\n        </camera>\n      </sensor>\n      <sensor name='narrow_stereo_gazebo_l_stereo_camera_sensor' type='camera'>\n        <always_on>0</always_on>\n        <visualize>0</visualize>\n        <update_rate>25.000000</update_rate>\n        <pose>0.068200 0.060000 0.114600 0.000000 0.000000 0.000000</pose>\n        <camera name='__default__'>\n          <horizontal_fov>0.785398</horizontal_fov>\n          <image>\n            <width>640</width>\n            <height>480</height>\n            <format>L8</format>\n          </image>\n          <clip>\n            <near>0.100000</near>\n            <far>100.000000</far>\n          </clip>\n        </camera>\n      </sensor>\n      <sensor name='narrow_stereo_gazebo_r_stereo_camera_sensor' type='camera'>\n        <always_on>0</always_on>\n        <visualize>0</visualize>\n        <update_rate>25.000000</update_rate>\n        <pose>0.068200 -0.030000 0.114600 0.000000 0.000000 0.000000</pose>\n        <camera name='__default__'>\n          <horizontal_fov>0.785398</horizontal_fov>\n          <image>\n            <width>640</width>\n            <height>480</height>\n            <format>L8</format>\n          </image>\n          <clip>\n            <near>0.100000</near>\n            <far>100.000000</far>\n          </clip>\n        </camera>\n      </sensor>\n      <sensor name='wide_stereo_gazebo_l_stereo_camera_sensor' type='camera'>\n        <update_rate>25.000000</update_rate>\n        <pose>0.068200 0.030000 0.114600 0.000000 0.000000 0.000000</pose>\n        <always_on>0</always_on>\n        <visualize>0</visualize>\n        <camera name='__default__'>\n          <horizontal_fov>1.570796</horizontal_fov>\n          <image>\n            <width>640</width>\n            <height>480</height>\n            <format>BAYER_BGGR8</format>\n          </image>\n          <clip>\n            <near>0.100000</near>\n            <far>100.000000</far>\n          </clip>\n        </camera>\n      </sensor>\n      <sensor name='wide_stereo_gazebo_r_stereo_camera_sensor' type='camera'>\n        <update_rate>25.000000</update_rate>\n        <pose>0.068200 -0.060000 0.114600 0.000000 0.000000 0.000000</pose>\n        <always_on>0</always_on>\n        <visualize>0</visualize>\n        <camera name='__default__'>\n          <horizontal_fov>1.570796</horizontal_fov>\n          <image>\n            <width>640</width>\n            <height>480</height>\n            <format>BAYER_BGGR8</format>\n          </image>\n          <clip>\n            <near>0.100000</near>\n            <far>100.000000</far>\n          </clip>\n        </camera>\n      </sensor>\n      <sensor name='high_def_sensor' type='camera'>\n        <update_rate>20.000000</update_rate>\n        <pose>0.069657 -0.110000 0.119100 0.000000 0.000000 0.000000</pose>\n        <always_on>0</always_on>\n        <visualize>0</visualize>\n        <camera name='__default__'>\n          <horizontal_fov>0.785398</horizontal_fov>\n          <image>\n            <width>2448</width>\n            <height>2050</height>\n            <format>R8G8B8</format>\n          </image>\n          <clip>\n            <near>0.100000</near>\n            <far>100.000000</far>\n          </clip>\n        </camera>\n      </sensor>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n      <gravity>1</gravity>\n    </link>\n    <link name='l_shoulder_pan_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>-0.050000 0.188000 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>25.799300</mass>\n        <pose>-0.001201 0.024513 -0.098231 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.866179</ixx>\n          <ixy>-0.060865</ixy>\n          <ixz>-0.121181</ixz>\n          <iyy>0.874217</iyy>\n          <iyz>-0.058866</iyz>\n          <izz>0.273538</izz>\n        </inertia>\n      </inertial>\n      <collision name='l_shoulder_pan_link_geom'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/shoulder_v0/shoulder_pan.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='l_shoulder_pan_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/shoulder_v0/shoulder_pan.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='l_shoulder_lift_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.050000 0.188000 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>2.749880</mass>\n        <pose>0.021950 -0.026640 -0.031270 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.021056</ixx>\n          <ixy>0.004967</ixy>\n          <ixz>-0.001948</ixz>\n          <iyy>0.021272</iyy>\n          <iyz>0.001104</iyz>\n          <izz>0.019758</izz>\n        </inertia>\n      </inertial>\n      <collision name='l_shoulder_lift_link_geom'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/shoulder_v0/shoulder_lift.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='l_shoulder_lift_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/shoulder_v0/shoulder_lift.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='l_upper_arm_roll_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.050000 0.188000 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>6.117690</mass>\n        <pose>0.210551 0.016309 -0.000561 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.025306</ixx>\n          <ixy>-0.003393</ixy>\n          <ixz>0.000608</ixz>\n          <iyy>0.084737</iyy>\n          <iyz>-0.000200</iyz>\n          <izz>0.086016</izz>\n        </inertia>\n      </inertial>\n      <collision name='l_upper_arm_roll_link_geom'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/shoulder_v0/upper_arm_roll_L.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='l_upper_arm_roll_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/shoulder_v0/upper_arm_roll.stl</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <collision name='l_upper_arm_roll_link_geom_l_upper_arm_link'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/upper_arm_v0/upper_arm.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='l_upper_arm_roll_link_geom_l_upper_arm_link_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/upper_arm_v0/upper_arm.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='l_elbow_flex_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.450000 0.188000 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>1.903270</mass>\n        <pose>0.010140 0.000320 -0.012110 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.003465</ixx>\n          <ixy>0.000041</ixy>\n          <ixz>0.000432</ixz>\n          <iyy>0.004416</iyy>\n          <iyz>-0.000040</iyz>\n          <izz>0.003592</izz>\n        </inertia>\n      </inertial>\n      <collision name='l_elbow_flex_link_geom'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/upper_arm_v0/elbow_flex.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='l_elbow_flex_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/upper_arm_v0/elbow_flex.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='l_forearm_roll_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.450000 0.188000 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>2.689680</mass>\n        <pose>0.180727 -0.000163 -0.008583 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.014668</ixx>\n          <ixy>0.000052</ixy>\n          <ixz>0.000656</ixz>\n          <iyy>0.026279</iyy>\n          <iyz>-0.000013</iyz>\n          <izz>0.027775</izz>\n        </inertia>\n      </inertial>\n      <collision name='l_forearm_roll_link_geom'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/upper_arm_v0/forearm_roll_L.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='l_forearm_roll_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/upper_arm_v0/forearm_roll.stl</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <collision name='l_forearm_roll_link_geom_l_forearm_link'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/forearm_v0/forearm.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='l_forearm_roll_link_geom_l_forearm_link_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/forearm_v0/forearm.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <sensor name='l_forearm_cam_sensor' type='camera'>\n        <update_rate>25.000000</update_rate>\n        <pose>0.135000 0.000000 0.044000 -1.570800 -0.562869 0.000000</pose>\n        <always_on>0</always_on>\n        <visualize>0</visualize>\n        <camera name='__default__'>\n          <horizontal_fov>1.570796</horizontal_fov>\n          <image>\n            <width>640</width>\n            <height>480</height>\n            <format>R8G8B8</format>\n          </image>\n          <clip>\n            <near>0.100000</near>\n            <far>100.000000</far>\n          </clip>\n        </camera>\n      </sensor>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='l_wrist_flex_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.771000 0.188000 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.614020</mass>\n        <pose>-0.001570 0.000000 -0.000750 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.000652</ixx>\n          <ixy>0.000000</ixy>\n          <ixz>0.000003</ixz>\n          <iyy>0.000198</iyy>\n          <iyz>0.000000</iyz>\n          <izz>0.000645</izz>\n        </inertia>\n      </inertial>\n      <collision name='l_wrist_flex_link_geom'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/forearm_v0/wrist_flex.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='l_wrist_flex_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/forearm_v0/wrist_flex.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='l_wrist_roll_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.771000 0.188000 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.681070</mass>\n        <pose>0.056408 0.000451 -0.001014 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.011352</ixx>\n          <ixy>-0.000016</ixy>\n          <ixz>-0.000001</ixz>\n          <iyy>0.011677</iyy>\n          <iyz>-0.000001</iyz>\n          <izz>0.011866</izz>\n        </inertia>\n      </inertial>\n      <collision name='l_wrist_roll_link_geom'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/forearm_v0/wrist_roll_L.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='l_wrist_roll_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/forearm_v0/wrist_roll.stl</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <collision name='l_wrist_roll_link_geom_l_gripper_motor_accelerometer_link'>\n        <geometry>\n          <box>\n            <size>0.001000 0.001000 0.001000</size>\n          </box>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='l_wrist_roll_link_geom_l_gripper_motor_accelerometer_link_visual'>\n        <geometry>\n          <box>\n            <size>0.001000 0.001000 0.001000</size>\n          </box>\n        </geometry>\n      </visual>\n      <collision name='l_wrist_roll_link_geom_l_gripper_palm_link'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/gripper_v0/gripper_palm.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='l_wrist_roll_link_geom_l_gripper_palm_link_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/gripper_v0/gripper_palm.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='l_gripper_l_finger_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.847910 0.198000 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.171260</mass>\n        <pose>0.035980 0.017300 -0.001640 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.000078</ixx>\n          <ixy>0.000001</ixy>\n          <ixz>-0.000010</ixz>\n          <iyy>0.000197</iyy>\n          <iyz>-0.000003</iyz>\n          <izz>0.000181</izz>\n        </inertia>\n      </inertial>\n      <collision name='l_gripper_l_finger_link_geom'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/gripper_v0/l_finger.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <friction>\n            <ode>\n              <mu>500.000000</mu>\n              <mu2>500.000000</mu2>\n              <slip1>0.000000</slip1>\n              <slip2>0.000000</slip2>\n            </ode>\n          </friction>\n          <contact>\n            <ode>\n              <kp>1000000.000000</kp>\n              <kd>1.000000</kd>\n              <max_vel>100.000000</max_vel>\n              <min_depth>0.000000</min_depth>\n            </ode>\n          </contact>\n          <bounce/>\n        </surface>\n      </collision>\n      <visual name='l_gripper_l_finger_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/gripper_v0/l_finger.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='l_gripper_l_finger_tip_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.939280 0.202950 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.044190</mass>\n        <pose>0.004230 0.002840 0.000000 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.000008</ixx>\n          <ixy>0.000006</ixy>\n          <ixz>0.000000</ixz>\n          <iyy>0.000010</iyy>\n          <iyz>0.000000</iyz>\n          <izz>0.000015</izz>\n        </inertia>\n      </inertial>\n      <collision name='l_gripper_l_finger_tip_link_geom'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/gripper_v0/l_finger_tip.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <friction>\n            <ode>\n              <mu>500.000000</mu>\n              <mu2>500.000000</mu2>\n              <slip1>0.000000</slip1>\n              <slip2>0.000000</slip2>\n            </ode>\n          </friction>\n          <contact>\n            <ode>\n              <kp>10000000.000000</kp>\n              <kd>1.000000</kd>\n              <max_vel>100.000000</max_vel>\n              <min_depth>0.000000</min_depth>\n            </ode>\n          </contact>\n          <bounce/>\n        </surface>\n      </collision>\n      <visual name='l_gripper_l_finger_tip_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/gripper_v0/l_finger_tip.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <sensor name='l_gripper_l_finger_tip_contact_sensor' type='contact'>\n        <update_rate>100.000000</update_rate>\n        <always_on>0</always_on>\n        <visualize>0</visualize>\n        <contact>\n          <collision>l_gripper_l_finger_tip_link_geom</collision>\n          <topic>__default_topic__</topic>\n        </contact>\n      </sensor>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='l_gripper_motor_slider_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.939280 0.188000 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.010000</mass>\n        <inertia>\n          <ixx>0.001000</ixx>\n          <ixy>0.000000</ixy>\n          <ixz>0.000000</ixz>\n          <iyy>0.001000</iyy>\n          <iyz>0.000000</iyz>\n          <izz>0.001000</izz>\n        </inertia>\n      </inertial>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='l_gripper_motor_screw_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.939280 0.188000 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.010000</mass>\n        <inertia>\n          <ixx>0.000100</ixx>\n          <ixy>0.000000</ixy>\n          <ixz>0.000000</ixz>\n          <iyy>0.000100</iyy>\n          <iyz>0.000000</iyz>\n          <izz>0.000100</izz>\n        </inertia>\n      </inertial>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='l_gripper_r_finger_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.847910 0.178000 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.173890</mass>\n        <pose>0.035760 -0.017360 -0.000950 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.000077</ixx>\n          <ixy>-0.000002</ixy>\n          <ixz>-0.000008</ixz>\n          <iyy>0.000198</iyy>\n          <iyz>0.000002</iyz>\n          <izz>0.000181</izz>\n        </inertia>\n      </inertial>\n      <collision name='l_gripper_r_finger_link_geom'>\n        <pose>0.000000 0.000000 0.000000 -3.141590 0.000000 0.000000</pose>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/gripper_v0/l_finger.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <friction>\n            <ode>\n              <mu>500.000000</mu>\n              <mu2>500.000000</mu2>\n              <slip1>0.000000</slip1>\n              <slip2>0.000000</slip2>\n            </ode>\n          </friction>\n          <contact>\n            <ode>\n              <kp>1000000.000000</kp>\n              <kd>1.000000</kd>\n              <max_vel>100.000000</max_vel>\n              <min_depth>0.000000</min_depth>\n            </ode>\n          </contact>\n          <bounce/>\n        </surface>\n      </collision>\n      <visual name='l_gripper_r_finger_link_geom_visual'>\n        <pose>0.000000 0.000000 0.000000 -3.141590 0.000000 0.000000</pose>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/gripper_v0/l_finger.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='l_gripper_r_finger_tip_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.939280 0.173050 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.044190</mass>\n        <pose>0.004230 -0.002840 0.000000 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.000008</ixx>\n          <ixy>-0.000006</ixy>\n          <ixz>0.000000</ixz>\n          <iyy>0.000010</iyy>\n          <iyz>0.000000</iyz>\n          <izz>0.000015</izz>\n        </inertia>\n      </inertial>\n      <collision name='l_gripper_r_finger_tip_link_geom'>\n        <pose>0.000000 0.000000 0.000000 -3.141590 0.000000 0.000000</pose>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/gripper_v0/l_finger_tip.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <friction>\n            <ode>\n              <mu>500.000000</mu>\n              <mu2>500.000000</mu2>\n              <slip1>0.000000</slip1>\n              <slip2>0.000000</slip2>\n            </ode>\n          </friction>\n          <contact>\n            <ode>\n              <kp>10000000.000000</kp>\n              <kd>1.000000</kd>\n              <max_vel>100.000000</max_vel>\n              <min_depth>0.000000</min_depth>\n            </ode>\n          </contact>\n          <bounce/>\n        </surface>\n      </collision>\n      <visual name='l_gripper_r_finger_tip_link_geom_visual'>\n        <pose>0.000000 0.000000 0.000000 -3.141590 0.000000 0.000000</pose>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/gripper_v0/l_finger_tip.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <sensor name='l_gripper_r_finger_tip_contact_sensor' type='contact'>\n        <update_rate>100.000000</update_rate>\n        <always_on>0</always_on>\n        <visualize>0</visualize>\n        <contact>\n          <collision>l_gripper_r_finger_tip_link_geom</collision>\n          <topic>__default_topic__</topic>\n        </contact>\n      </sensor>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='laser_tilt_mount_link'>\n      <self_collide>0</self_collide>\n      <pose>0.048930 0.000000 1.017680 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.592000</mass>\n        <pose>-0.001134 0.001667 -0.007067 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.001296</ixx>\n          <ixy>0.000023</ixy>\n          <ixz>0.000037</ixz>\n          <iyy>0.001086</iyy>\n          <iyz>0.000035</iyz>\n          <izz>0.000895</izz>\n        </inertia>\n      </inertial>\n      <collision name='laser_tilt_mount_link_geom'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/tilting_laser_v0/tilting_hokuyo_L.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <friction>\n            <ode>\n              <mu>0.000000</mu>\n              <mu2>0.000000</mu2>\n              <slip1>0.000000</slip1>\n              <slip2>0.000000</slip2>\n            </ode>\n          </friction>\n          <contact>\n            <ode>\n              <kp>1000000000000.000000</kp>\n              <kd>10000.000000</kd>\n              <max_vel>100.000000</max_vel>\n              <min_depth>0.000000</min_depth>\n            </ode>\n          </contact>\n          <bounce/>\n        </surface>\n      </collision>\n      <visual name='laser_tilt_mount_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/tilting_laser_v0/tilting_hokuyo.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <sensor name='laser_tilt' type='ray'>\n        <update_rate>40.000000</update_rate>\n        <pose>0.000000 0.000000 0.030000 0.000000 0.000000 0.000000</pose>\n        <always_on>0</always_on>\n        <visualize>0</visualize>\n        <ray>\n          <scan>\n            <horizontal>\n              <samples>640</samples>\n              <resolution>1.000000</resolution>\n              <min_angle>-1.396263</min_angle>\n              <max_angle>1.396263</max_angle>\n            </horizontal>\n          </scan>\n          <range>\n            <min>0.080000</min>\n            <max>10.000000</max>\n            <resolution>0.010000</resolution>\n          </range>\n        </ray>\n      </sensor>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n      <gravity>1</gravity>\n    </link>\n    <link name='r_shoulder_pan_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>-0.050000 -0.188000 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>25.799300</mass>\n        <pose>-0.001201 0.024513 -0.098231 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.866179</ixx>\n          <ixy>-0.060865</ixy>\n          <ixz>-0.121181</ixz>\n          <iyy>0.874217</iyy>\n          <iyz>-0.058866</iyz>\n          <izz>0.273538</izz>\n        </inertia>\n      </inertial>\n      <collision name='r_shoulder_pan_link_geom'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/shoulder_v0/shoulder_pan.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <friction>\n            <ode>\n              <mu>0.000000</mu>\n              <mu2>0.000000</mu2>\n              <slip1>0.000000</slip1>\n              <slip2>0.000000</slip2>\n            </ode>\n          </friction>\n          <contact>\n            <ode>\n              <kp>1000000000000.000000</kp>\n              <kd>10000.000000</kd>\n              <max_vel>100.000000</max_vel>\n              <min_depth>0.000000</min_depth>\n            </ode>\n          </contact>\n          <bounce/>\n        </surface>\n      </collision>\n      <visual name='r_shoulder_pan_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/shoulder_v0/shoulder_pan.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='r_shoulder_lift_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.050000 -0.188000 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>2.749880</mass>\n        <pose>0.021950 -0.026640 -0.031270 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.021056</ixx>\n          <ixy>0.004967</ixy>\n          <ixz>-0.001948</ixz>\n          <iyy>0.021272</iyy>\n          <iyz>0.001104</iyz>\n          <izz>0.019758</izz>\n        </inertia>\n      </inertial>\n      <collision name='r_shoulder_lift_link_geom'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/shoulder_v0/shoulder_lift.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <friction>\n            <ode>\n              <mu>0.000000</mu>\n              <mu2>0.000000</mu2>\n              <slip1>0.000000</slip1>\n              <slip2>0.000000</slip2>\n            </ode>\n          </friction>\n          <contact>\n            <ode>\n              <kp>1000000000000.000000</kp>\n              <kd>10000.000000</kd>\n              <max_vel>100.000000</max_vel>\n              <min_depth>0.000000</min_depth>\n            </ode>\n          </contact>\n          <bounce/>\n        </surface>\n      </collision>\n      <visual name='r_shoulder_lift_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/shoulder_v0/shoulder_lift.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='r_upper_arm_roll_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.050000 -0.188000 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>6.117690</mass>\n        <pose>0.210482 -0.015945 -0.000197 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.025378</ixx>\n          <ixy>0.003757</ixy>\n          <ixz>-0.000709</ixz>\n          <iyy>0.084737</iyy>\n          <iyz>-0.000179</iyz>\n          <izz>0.086088</izz>\n        </inertia>\n      </inertial>\n      <collision name='r_upper_arm_roll_link_geom'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/shoulder_v0/upper_arm_roll_L.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='r_upper_arm_roll_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/shoulder_v0/upper_arm_roll.stl</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <collision name='r_upper_arm_roll_link_geom_r_upper_arm_link'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/upper_arm_v0/upper_arm.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='r_upper_arm_roll_link_geom_r_upper_arm_link_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/upper_arm_v0/upper_arm.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='r_elbow_flex_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.450000 -0.188000 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>1.903270</mass>\n        <pose>0.010140 0.000320 -0.012110 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.003465</ixx>\n          <ixy>0.000041</ixy>\n          <ixz>0.000432</ixz>\n          <iyy>0.004416</iyy>\n          <iyz>-0.000040</iyz>\n          <izz>0.003592</izz>\n        </inertia>\n      </inertial>\n      <collision name='r_elbow_flex_link_geom'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/upper_arm_v0/elbow_flex.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='r_elbow_flex_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/upper_arm_v0/elbow_flex.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='r_forearm_roll_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.450000 -0.188000 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>2.689680</mass>\n        <pose>0.180727 -0.000163 -0.008583 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.014668</ixx>\n          <ixy>0.000052</ixy>\n          <ixz>0.000656</ixz>\n          <iyy>0.026279</iyy>\n          <iyz>-0.000013</iyz>\n          <izz>0.027775</izz>\n        </inertia>\n      </inertial>\n      <collision name='r_forearm_roll_link_geom'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/upper_arm_v0/forearm_roll_L.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='r_forearm_roll_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/upper_arm_v0/forearm_roll.stl</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <collision name='r_forearm_roll_link_geom_r_forearm_link'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/forearm_v0/forearm.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='r_forearm_roll_link_geom_r_forearm_link_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/forearm_v0/forearm.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <sensor name='r_forearm_cam_sensor' type='camera'>\n        <update_rate>25.000000</update_rate>\n        <pose>0.135000 0.000000 0.044000 1.570800 -0.562869 -0.000000</pose>\n        <always_on>0</always_on>\n        <visualize>0</visualize>\n        <camera name='__default__'>\n          <horizontal_fov>1.570796</horizontal_fov>\n          <image>\n            <width>640</width>\n            <height>480</height>\n            <format>R8G8B8</format>\n          </image>\n          <clip>\n            <near>0.100000</near>\n            <far>100.000000</far>\n          </clip>\n        </camera>\n      </sensor>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='r_wrist_flex_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.771000 -0.188000 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.614020</mass>\n        <pose>-0.001570 0.000000 -0.000750 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.000652</ixx>\n          <ixy>0.000000</ixy>\n          <ixz>0.000003</ixz>\n          <iyy>0.000198</iyy>\n          <iyz>0.000000</iyz>\n          <izz>0.000645</izz>\n        </inertia>\n      </inertial>\n      <collision name='r_wrist_flex_link_geom'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/forearm_v0/wrist_flex.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='r_wrist_flex_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/forearm_v0/wrist_flex.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='r_wrist_roll_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.771000 -0.188000 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.681070</mass>\n        <pose>0.056408 0.000451 -0.001014 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.011352</ixx>\n          <ixy>-0.000016</ixy>\n          <ixz>-0.000001</ixz>\n          <iyy>0.011677</iyy>\n          <iyz>-0.000001</iyz>\n          <izz>0.011866</izz>\n        </inertia>\n      </inertial>\n      <collision name='r_wrist_roll_link_geom'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/forearm_v0/wrist_roll_L.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='r_wrist_roll_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/forearm_v0/wrist_roll.stl</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <collision name='r_wrist_roll_link_geom_r_gripper_motor_accelerometer_link'>\n        <geometry>\n          <box>\n            <size>0.001000 0.001000 0.001000</size>\n          </box>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='r_wrist_roll_link_geom_r_gripper_motor_accelerometer_link_visual'>\n        <geometry>\n          <box>\n            <size>0.001000 0.001000 0.001000</size>\n          </box>\n        </geometry>\n      </visual>\n      <collision name='r_wrist_roll_link_geom_r_gripper_palm_link'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/gripper_v0/gripper_palm.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='r_wrist_roll_link_geom_r_gripper_palm_link_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/gripper_v0/gripper_palm.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='r_gripper_l_finger_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.847910 -0.178000 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.171260</mass>\n        <pose>0.035980 0.017300 -0.001640 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.000078</ixx>\n          <ixy>0.000001</ixy>\n          <ixz>0.000010</ixz>\n          <iyy>0.000197</iyy>\n          <iyz>-0.000003</iyz>\n          <izz>0.000181</izz>\n        </inertia>\n      </inertial>\n      <collision name='r_gripper_l_finger_link_geom'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/gripper_v0/l_finger.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <friction>\n            <ode>\n              <mu>500.000000</mu>\n              <mu2>500.000000</mu2>\n              <slip1>0.000000</slip1>\n              <slip2>0.000000</slip2>\n            </ode>\n          </friction>\n          <contact>\n            <ode>\n              <kp>1000000.000000</kp>\n              <kd>1.000000</kd>\n              <max_vel>100.000000</max_vel>\n              <min_depth>0.000000</min_depth>\n            </ode>\n          </contact>\n          <bounce/>\n        </surface>\n      </collision>\n      <visual name='r_gripper_l_finger_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/gripper_v0/l_finger.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='r_gripper_l_finger_tip_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.939280 -0.173050 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.044190</mass>\n        <pose>0.004230 0.002840 0.000000 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.000008</ixx>\n          <ixy>0.000006</ixy>\n          <ixz>0.000000</ixz>\n          <iyy>0.000010</iyy>\n          <iyz>0.000000</iyz>\n          <izz>0.000015</izz>\n        </inertia>\n      </inertial>\n      <collision name='r_gripper_l_finger_tip_link_geom'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/gripper_v0/l_finger_tip.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <friction>\n            <ode>\n              <mu>500.000000</mu>\n              <mu2>500.000000</mu2>\n              <slip1>0.000000</slip1>\n              <slip2>0.000000</slip2>\n            </ode>\n          </friction>\n          <contact>\n            <ode>\n              <kp>10000000.000000</kp>\n              <kd>1.000000</kd>\n              <max_vel>100.000000</max_vel>\n              <min_depth>0.000000</min_depth>\n            </ode>\n          </contact>\n          <bounce/>\n        </surface>\n      </collision>\n      <visual name='r_gripper_l_finger_tip_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/gripper_v0/l_finger_tip.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <sensor name='r_gripper_l_finger_tip_contact_sensor' type='contact'>\n        <update_rate>100.000000</update_rate>\n        <always_on>0</always_on>\n        <visualize>0</visualize>\n        <contact>\n          <collision>r_gripper_l_finger_tip_link_geom</collision>\n          <topic>__default_topic__</topic>\n        </contact>\n      </sensor>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='r_gripper_motor_slider_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.939280 -0.188000 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.010000</mass>\n        <inertia>\n          <ixx>0.001000</ixx>\n          <ixy>0.000000</ixy>\n          <ixz>0.000000</ixz>\n          <iyy>0.001000</iyy>\n          <iyz>0.000000</iyz>\n          <izz>0.001000</izz>\n        </inertia>\n      </inertial>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='r_gripper_motor_screw_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.939280 -0.188000 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.010000</mass>\n        <inertia>\n          <ixx>0.000100</ixx>\n          <ixy>0.000000</ixy>\n          <ixz>0.000000</ixz>\n          <iyy>0.000100</iyy>\n          <iyz>0.000000</iyz>\n          <izz>0.000100</izz>\n        </inertia>\n      </inertial>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='r_gripper_r_finger_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.847910 -0.198000 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.173890</mass>\n        <pose>0.035760 -0.017360 -0.000950 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.000077</ixx>\n          <ixy>-0.000002</ixy>\n          <ixz>-0.000008</ixz>\n          <iyy>0.000198</iyy>\n          <iyz>0.000002</iyz>\n          <izz>0.000181</izz>\n        </inertia>\n      </inertial>\n      <collision name='r_gripper_r_finger_link_geom'>\n        <pose>0.000000 0.000000 0.000000 -3.141590 0.000000 0.000000</pose>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/gripper_v0/l_finger.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <friction>\n            <ode>\n              <mu>500.000000</mu>\n              <mu2>500.000000</mu2>\n              <slip1>0.000000</slip1>\n              <slip2>0.000000</slip2>\n            </ode>\n          </friction>\n          <contact>\n            <ode>\n              <kp>1000000.000000</kp>\n              <kd>1.000000</kd>\n              <max_vel>100.000000</max_vel>\n              <min_depth>0.000000</min_depth>\n            </ode>\n          </contact>\n          <bounce/>\n        </surface>\n      </collision>\n      <visual name='r_gripper_r_finger_link_geom_visual'>\n        <pose>0.000000 0.000000 0.000000 -3.141590 0.000000 0.000000</pose>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/gripper_v0/l_finger.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='r_gripper_r_finger_tip_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.939280 -0.202950 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.044190</mass>\n        <pose>0.004230 -0.002840 0.000000 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.000008</ixx>\n          <ixy>-0.000006</ixy>\n          <ixz>0.000000</ixz>\n          <iyy>0.000010</iyy>\n          <iyz>0.000000</iyz>\n          <izz>0.000015</izz>\n        </inertia>\n      </inertial>\n      <collision name='r_gripper_r_finger_tip_link_geom'>\n        <pose>0.000000 0.000000 0.000000 -3.141590 0.000000 0.000000</pose>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/gripper_v0/l_finger_tip.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <friction>\n            <ode>\n              <mu>500.000000</mu>\n              <mu2>500.000000</mu2>\n              <slip1>0.000000</slip1>\n              <slip2>0.000000</slip2>\n            </ode>\n          </friction>\n          <contact>\n            <ode>\n              <kp>10000000.000000</kp>\n              <kd>1.000000</kd>\n              <max_vel>100.000000</max_vel>\n              <min_depth>0.000000</min_depth>\n            </ode>\n          </contact>\n          <bounce/>\n        </surface>\n      </collision>\n      <visual name='r_gripper_r_finger_tip_link_geom_visual'>\n        <pose>0.000000 0.000000 0.000000 -3.141590 0.000000 0.000000</pose>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/gripper_v0/l_finger_tip.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <sensor name='r_gripper_r_finger_tip_contact_sensor' type='contact'>\n        <update_rate>100.000000</update_rate>\n        <always_on>0</always_on>\n        <visualize>0</visualize>\n        <contact>\n          <collision>r_gripper_r_finger_tip_link_geom</collision>\n          <topic>__default_topic__</topic>\n        </contact>\n      </sensor>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='torso_lift_motor_screw_link'>\n      <self_collide>0</self_collide>\n      <pose>-0.150000 0.000000 0.751000 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>1.000000</mass>\n        <inertia>\n          <ixx>0.001000</ixx>\n          <ixy>0.000000</ixy>\n          <ixz>0.000000</ixz>\n          <iyy>0.001000</iyy>\n          <iyz>0.000000</iyz>\n          <izz>0.001000</izz>\n        </inertia>\n      </inertial>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n      <gravity>1</gravity>\n    </link>\n    <link name='r_gripper_l_parallel_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.829910 -0.157000 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.171260</mass>\n        <pose>0.035980 0.017300 -0.001640 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.000078</ixx>\n          <ixy>0.000001</ixy>\n          <ixz>-0.000010</ixz>\n          <iyy>0.000197</iyy>\n          <iyz>-0.000003</iyz>\n          <izz>0.000181</izz>\n        </inertia>\n      </inertial>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='r_gripper_r_parallel_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.829910 -0.219000 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.173890</mass>\n        <pose>0.035760 -0.017360 -0.000950 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.000077</ixx>\n          <ixy>-0.000002</ixy>\n          <ixz>-0.000008</ixz>\n          <iyy>0.000198</iyy>\n          <iyz>0.000002</iyz>\n          <izz>0.000181</izz>\n        </inertia>\n      </inertial>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='l_gripper_l_parallel_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.829910 0.219000 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.171260</mass>\n        <pose>0.035980 0.017300 -0.001640 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.000078</ixx>\n          <ixy>0.000001</ixy>\n          <ixz>0.000010</ixz>\n          <iyy>0.000197</iyy>\n          <iyz>-0.000003</iyz>\n          <izz>0.000181</izz>\n        </inertia>\n      </inertial>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='l_gripper_r_parallel_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.829910 0.157000 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.173890</mass>\n        <pose>0.035760 -0.017360 -0.000950 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.000077</ixx>\n          <ixy>-0.000002</ixy>\n          <ixz>0.000008</ixz>\n          <iyy>0.000198</iyy>\n          <iyz>0.000002</iyz>\n          <izz>0.000181</izz>\n        </inertia>\n      </inertial>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <joint name='bl_caster_rotation_joint' type='revolute'>\n      <parent>base_footprint</parent>\n      <child>bl_caster_rotation_link</child>\n      <axis>\n        <xyz>0.000000 0.000000 1.000000</xyz>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='bl_caster_l_wheel_joint' type='revolute'>\n      <parent>bl_caster_rotation_link</parent>\n      <child>bl_caster_l_wheel_link</child>\n      <axis>\n        <xyz>0.000000 1.000000 0.000000</xyz>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='bl_caster_r_wheel_joint' type='revolute'>\n      <parent>bl_caster_rotation_link</parent>\n      <child>bl_caster_r_wheel_link</child>\n      <axis>\n        <xyz>0.000000 1.000000 0.000000</xyz>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='br_caster_rotation_joint' type='revolute'>\n      <parent>base_footprint</parent>\n      <child>br_caster_rotation_link</child>\n      <axis>\n        <xyz>0.000000 0.000000 1.000000</xyz>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='br_caster_l_wheel_joint' type='revolute'>\n      <parent>br_caster_rotation_link</parent>\n      <child>br_caster_l_wheel_link</child>\n      <axis>\n        <xyz>0.000000 1.000000 0.000000</xyz>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='br_caster_r_wheel_joint' type='revolute'>\n      <parent>br_caster_rotation_link</parent>\n      <child>br_caster_r_wheel_link</child>\n      <axis>\n        <xyz>0.000000 1.000000 0.000000</xyz>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='fl_caster_rotation_joint' type='revolute'>\n      <parent>base_footprint</parent>\n      <child>fl_caster_rotation_link</child>\n      <axis>\n        <xyz>0.000000 0.000000 1.000000</xyz>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='fl_caster_l_wheel_joint' type='revolute'>\n      <parent>fl_caster_rotation_link</parent>\n      <child>fl_caster_l_wheel_link</child>\n      <axis>\n        <xyz>0.000000 1.000000 0.000000</xyz>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='fl_caster_r_wheel_joint' type='revolute'>\n      <parent>fl_caster_rotation_link</parent>\n      <child>fl_caster_r_wheel_link</child>\n      <axis>\n        <xyz>0.000000 1.000000 0.000000</xyz>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='fr_caster_rotation_joint' type='revolute'>\n      <parent>base_footprint</parent>\n      <child>fr_caster_rotation_link</child>\n      <axis>\n        <xyz>0.000000 0.000000 1.000000</xyz>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='fr_caster_l_wheel_joint' type='revolute'>\n      <parent>fr_caster_rotation_link</parent>\n      <child>fr_caster_l_wheel_link</child>\n      <axis>\n        <xyz>0.000000 1.000000 0.000000</xyz>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='fr_caster_r_wheel_joint' type='revolute'>\n      <parent>fr_caster_rotation_link</parent>\n      <child>fr_caster_r_wheel_link</child>\n      <axis>\n        <xyz>0.000000 1.000000 0.000000</xyz>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='torso_lift_joint' type='prismatic'>\n      <parent>base_footprint</parent>\n      <child>torso_lift_link</child>\n      <axis>\n        <xyz>0.000000 0.000000 1.000000</xyz>\n        <limit>\n          <lower>0.000000</lower>\n          <upper>0.330000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='head_pan_joint' type='revolute'>\n      <parent>torso_lift_link</parent>\n      <child>head_pan_link</child>\n      <axis>\n        <xyz>0.000000 0.000000 1.000000</xyz>\n        <dynamics>\n          <damping>2.000000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-3.006993</lower>\n          <upper>3.006993</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='head_tilt_joint' type='revolute'>\n      <parent>head_pan_link</parent>\n      <child>head_tilt_link</child>\n      <axis>\n        <xyz>0.000000 1.000000 0.000000</xyz>\n        <dynamics>\n          <damping>10.000000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-0.471237</lower>\n          <upper>1.396260</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='l_shoulder_pan_joint' type='revolute'>\n      <parent>torso_lift_link</parent>\n      <child>l_shoulder_pan_link</child>\n      <axis>\n        <xyz>0.000000 0.000000 1.000000</xyz>\n        <dynamics>\n          <damping>10.000000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-0.714602</lower>\n          <upper>2.285404</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='l_shoulder_lift_joint' type='revolute'>\n      <parent>l_shoulder_pan_link</parent>\n      <child>l_shoulder_lift_link</child>\n      <axis>\n        <xyz>0.000000 1.000000 0.000000</xyz>\n        <dynamics>\n          <damping>10.000000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-0.523601</lower>\n          <upper>1.396300</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='l_upper_arm_roll_joint' type='revolute'>\n      <parent>l_shoulder_lift_link</parent>\n      <child>l_upper_arm_roll_link</child>\n      <axis>\n        <xyz>1.000000 0.000000 0.000000</xyz>\n        <dynamics>\n          <damping>0.100000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-0.800000</lower>\n          <upper>3.900008</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='l_elbow_flex_joint' type='revolute'>\n      <parent>l_upper_arm_roll_link</parent>\n      <child>l_elbow_flex_link</child>\n      <axis>\n        <xyz>0.000000 1.000000 0.000000</xyz>\n        <dynamics>\n          <damping>1.000000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-2.321305</lower>\n          <upper>0.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='l_forearm_roll_joint' type='revolute'>\n      <parent>l_elbow_flex_link</parent>\n      <child>l_forearm_roll_link</child>\n      <axis>\n        <xyz>1.000000 0.000000 0.000000</xyz>\n        <dynamics>\n          <damping>0.100000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='l_wrist_flex_joint' type='revolute'>\n      <parent>l_forearm_roll_link</parent>\n      <child>l_wrist_flex_link</child>\n      <axis>\n        <xyz>0.000000 1.000000 0.000000</xyz>\n        <dynamics>\n          <damping>0.100000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-2.180004</lower>\n          <upper>0.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='l_wrist_roll_joint' type='revolute'>\n      <parent>l_wrist_flex_link</parent>\n      <child>l_wrist_roll_link</child>\n      <axis>\n        <xyz>1.000000 0.000000 0.000000</xyz>\n        <dynamics>\n          <damping>0.100000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='l_gripper_l_finger_joint' type='revolute'>\n      <parent>l_wrist_roll_link</parent>\n      <child>l_gripper_l_finger_link</child>\n      <axis>\n        <xyz>0.000000 0.000000 1.000000</xyz>\n        <dynamics>\n          <damping>0.020000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>0.000000</lower>\n          <upper>0.548000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='l_gripper_l_finger_tip_joint' type='revolute'>\n      <parent>l_gripper_l_finger_link</parent>\n      <child>l_gripper_l_finger_tip_link</child>\n      <axis>\n        <xyz>0.000000 0.000000 -1.000000</xyz>\n        <dynamics>\n          <damping>0.001000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>0.000000</lower>\n          <upper>0.548000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='l_gripper_motor_slider_joint' type='prismatic'>\n      <parent>l_wrist_roll_link</parent>\n      <child>l_gripper_motor_slider_link</child>\n      <axis>\n        <xyz>1.000000 0.000000 0.000000</xyz>\n        <limit>\n          <lower>-0.100000</lower>\n          <upper>0.100000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='l_gripper_motor_screw_joint' type='revolute'>\n      <parent>l_gripper_motor_slider_link</parent>\n      <child>l_gripper_motor_screw_link</child>\n      <axis>\n        <xyz>0.000000 1.000000 0.000000</xyz>\n        <dynamics>\n          <damping>0.000100</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='l_gripper_r_finger_joint' type='revolute'>\n      <parent>l_wrist_roll_link</parent>\n      <child>l_gripper_r_finger_link</child>\n      <axis>\n        <xyz>0.000000 0.000000 -1.000000</xyz>\n        <dynamics>\n          <damping>0.020000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>0.000000</lower>\n          <upper>0.548000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='l_gripper_r_finger_tip_joint' type='revolute'>\n      <parent>l_gripper_r_finger_link</parent>\n      <child>l_gripper_r_finger_tip_link</child>\n      <axis>\n        <xyz>0.000000 0.000000 1.000000</xyz>\n        <dynamics>\n          <damping>0.001000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>0.000000</lower>\n          <upper>0.548000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='laser_tilt_mount_joint' type='revolute'>\n      <parent>torso_lift_link</parent>\n      <child>laser_tilt_mount_link</child>\n      <axis>\n        <xyz>0.000000 1.000000 0.000000</xyz>\n        <dynamics>\n          <damping>0.008000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-0.785400</lower>\n          <upper>1.483530</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='r_shoulder_pan_joint' type='revolute'>\n      <parent>torso_lift_link</parent>\n      <child>r_shoulder_pan_link</child>\n      <axis>\n        <xyz>0.000000 0.000000 1.000000</xyz>\n        <dynamics>\n          <damping>10.000000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-2.285404</lower>\n          <upper>0.714602</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='r_shoulder_lift_joint' type='revolute'>\n      <parent>r_shoulder_pan_link</parent>\n      <child>r_shoulder_lift_link</child>\n      <axis>\n        <xyz>0.000000 1.000000 0.000000</xyz>\n        <dynamics>\n          <damping>10.000000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-0.523601</lower>\n          <upper>1.396300</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='r_upper_arm_roll_joint' type='revolute'>\n      <parent>r_shoulder_lift_link</parent>\n      <child>r_upper_arm_roll_link</child>\n      <axis>\n        <xyz>1.000000 0.000000 0.000000</xyz>\n        <dynamics>\n          <damping>0.100000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-3.900008</lower>\n          <upper>0.800000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='r_elbow_flex_joint' type='revolute'>\n      <parent>r_upper_arm_roll_link</parent>\n      <child>r_elbow_flex_link</child>\n      <axis>\n        <xyz>0.000000 1.000000 0.000000</xyz>\n        <dynamics>\n          <damping>1.000000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-2.321305</lower>\n          <upper>0.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='r_forearm_roll_joint' type='revolute'>\n      <parent>r_elbow_flex_link</parent>\n      <child>r_forearm_roll_link</child>\n      <axis>\n        <xyz>1.000000 0.000000 0.000000</xyz>\n        <dynamics>\n          <damping>0.100000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='r_wrist_flex_joint' type='revolute'>\n      <parent>r_forearm_roll_link</parent>\n      <child>r_wrist_flex_link</child>\n      <axis>\n        <xyz>0.000000 1.000000 0.000000</xyz>\n        <dynamics>\n          <damping>0.100000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-2.180004</lower>\n          <upper>0.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='r_wrist_roll_joint' type='revolute'>\n      <parent>r_wrist_flex_link</parent>\n      <child>r_wrist_roll_link</child>\n      <axis>\n        <xyz>1.000000 0.000000 0.000000</xyz>\n        <dynamics>\n          <damping>0.100000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='r_gripper_l_finger_joint' type='revolute'>\n      <parent>r_wrist_roll_link</parent>\n      <child>r_gripper_l_finger_link</child>\n      <axis>\n        <xyz>0.000000 0.000000 1.000000</xyz>\n        <dynamics>\n          <damping>0.020000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>0.000000</lower>\n          <upper>0.548000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='r_gripper_l_finger_tip_joint' type='revolute'>\n      <parent>r_gripper_l_finger_link</parent>\n      <child>r_gripper_l_finger_tip_link</child>\n      <axis>\n        <xyz>0.000000 0.000000 -1.000000</xyz>\n        <dynamics>\n          <damping>0.001000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>0.000000</lower>\n          <upper>0.548000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='r_gripper_motor_slider_joint' type='prismatic'>\n      <parent>r_wrist_roll_link</parent>\n      <child>r_gripper_motor_slider_link</child>\n      <axis>\n        <xyz>1.000000 0.000000 0.000000</xyz>\n        <dynamics>\n          <damping>0.000000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-0.100000</lower>\n          <upper>0.100000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='r_gripper_motor_screw_joint' type='revolute'>\n      <parent>r_gripper_motor_slider_link</parent>\n      <child>r_gripper_motor_screw_link</child>\n      <axis>\n        <xyz>0.000000 1.000000 0.000000</xyz>\n        <dynamics>\n          <damping>0.000100</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='r_gripper_r_finger_joint' type='revolute'>\n      <parent>r_wrist_roll_link</parent>\n      <child>r_gripper_r_finger_link</child>\n      <axis>\n        <xyz>0.000000 0.000000 -1.000000</xyz>\n        <dynamics>\n          <damping>0.020000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>0.000000</lower>\n          <upper>0.548000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='r_gripper_r_finger_tip_joint' type='revolute'>\n      <parent>r_gripper_r_finger_link</parent>\n      <child>r_gripper_r_finger_tip_link</child>\n      <axis>\n        <xyz>0.000000 0.000000 1.000000</xyz>\n        <dynamics>\n          <damping>0.001000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>0.000000</lower>\n          <upper>0.548000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='torso_lift_motor_screw_joint' type='revolute'>\n      <parent>base_footprint</parent>\n      <child>torso_lift_motor_screw_link</child>\n      <axis>\n        <xyz>0.000000 0.000000 1.000000</xyz>\n        <dynamics>\n          <damping>0.000100</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='torso_lift_screw_torso_lift_joint' type='screw'>\n      <parent>torso_lift_link</parent>\n      <child>torso_lift_motor_screw_link</child>\n      <thread_pitch>3141.600000</thread_pitch>\n      <axis>\n        <xyz>0.000000 0.000000 1.000000</xyz>\n        <dynamics>\n          <damping>0.000000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='r_gripper_r_screw_screw_joint' type='screw'>\n      <parent>r_gripper_r_finger_tip_link</parent>\n      <child>r_gripper_motor_screw_link</child>\n      <thread_pitch>-3141.600000</thread_pitch>\n      <axis>\n        <xyz>0.000000 1.000000 0.000000</xyz>\n        <dynamics>\n          <damping>0.000000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='r_gripper_l_screw_screw_joint' type='screw'>\n      <parent>r_gripper_l_finger_tip_link</parent>\n      <child>r_gripper_motor_screw_link</child>\n      <thread_pitch>3141.600000</thread_pitch>\n      <axis>\n        <xyz>0.000000 1.000000 0.000000</xyz>\n        <dynamics>\n          <damping>0.000000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='r_gripper_r_parallel_root_joint' type='revolute'>\n      <pose>0.058910 -0.031000 0.000000 0.000000 0.000000 0.000000</pose>\n      <parent>r_gripper_r_parallel_link</parent>\n      <child>r_wrist_roll_link</child>\n      <axis>\n        <xyz>0.000000 0.000000 -1.000000</xyz>\n        <dynamics>\n          <damping>0.200000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='r_gripper_l_parallel_root_joint' type='revolute'>\n      <pose>0.058910 0.031000 0.000000 0.000000 0.000000 0.000000</pose>\n      <parent>r_gripper_l_parallel_link</parent>\n      <child>r_wrist_roll_link</child>\n      <axis>\n        <xyz>0.000000 0.000000 1.000000</xyz>\n        <dynamics>\n          <damping>0.200000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='r_gripper_r_parallel_tip_joint' type='revolute'>\n      <pose>-0.018000 -0.021000 0.000000 0.000000 0.000000 0.000000</pose>\n      <parent>r_gripper_r_parallel_link</parent>\n      <child>r_gripper_r_finger_tip_link</child>\n      <axis>\n        <xyz>0.000000 0.000000 1.000000</xyz>\n        <dynamics>\n          <damping>0.000000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='r_gripper_l_parallel_tip_joint' type='revolute'>\n      <pose>-0.018000 0.021000 0.000000 0.000000 0.000000 0.000000</pose>\n      <parent>r_gripper_l_parallel_link</parent>\n      <child>r_gripper_l_finger_tip_link</child>\n      <axis>\n        <xyz>0.000000 0.000000 1.000000</xyz>\n        <dynamics>\n          <damping>0.000000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='r_gripper_joint' type='prismatic'>\n      <parent>r_gripper_r_finger_tip_link</parent>\n      <child>r_gripper_l_finger_tip_link</child>\n      <axis>\n        <xyz>0.000000 1.000000 0.000000</xyz>\n        <dynamics>\n          <damping>0.000000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='l_gripper_r_screw_screw_joint' type='screw'>\n      <parent>l_gripper_r_finger_tip_link</parent>\n      <child>l_gripper_motor_screw_link</child>\n      <thread_pitch>-3141.600000</thread_pitch>\n      <axis>\n        <xyz>0.000000 1.000000 0.000000</xyz>\n        <dynamics>\n          <damping>0.000000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='l_gripper_l_screw_screw_joint' type='screw'>\n      <parent>l_gripper_l_finger_tip_link</parent>\n      <child>l_gripper_motor_screw_link</child>\n      <thread_pitch>3141.600000</thread_pitch>\n      <axis>\n        <xyz>0.000000 1.000000 0.000000</xyz>\n        <dynamics>\n          <damping>0.000000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='l_gripper_r_parallel_root_joint' type='revolute'>\n      <pose>0.058910 -0.031000 0.000000 0.000000 0.000000 0.000000</pose>\n      <parent>l_gripper_r_parallel_link</parent>\n      <child>l_wrist_roll_link</child>\n      <axis>\n        <xyz>0.000000 0.000000 -1.000000</xyz>\n        <dynamics>\n          <damping>0.200000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='l_gripper_l_parallel_root_joint' type='revolute'>\n      <pose>0.058910 0.031000 0.000000 0.000000 0.000000 0.000000</pose>\n      <parent>l_gripper_l_parallel_link</parent>\n      <child>l_wrist_roll_link</child>\n      <axis>\n        <xyz>0.000000 0.000000 1.000000</xyz>\n        <dynamics>\n          <damping>0.200000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='l_gripper_r_parallel_tip_joint' type='revolute'>\n      <pose>-0.018000 -0.021000 0.000000 0.000000 0.000000 0.000000</pose>\n      <parent>l_gripper_r_parallel_link</parent>\n      <child>l_gripper_r_finger_tip_link</child>\n      <axis>\n        <xyz>0.000000 0.000000 1.000000</xyz>\n        <dynamics>\n          <damping>0.000000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='l_gripper_l_parallel_tip_joint' type='revolute'>\n      <pose>-0.018000 0.021000 0.000000 0.000000 0.000000 0.000000</pose>\n      <parent>l_gripper_l_parallel_link</parent>\n      <child>l_gripper_l_finger_tip_link</child>\n      <axis>\n        <xyz>0.000000 0.000000 1.000000</xyz>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='l_gripper_joint' type='prismatic'>\n      <parent>l_gripper_r_finger_tip_link</parent>\n      <child>l_gripper_l_finger_tip_link</child>\n      <axis>\n        <xyz>0.000000 1.000000 0.000000</xyz>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n  </model>\n  <physics type='ode'>\n    <update_rate>1000.000000</update_rate>\n    <gravity>0.000000 0.000000 -9.800000</gravity>\n  </physics>\n  <scene>\n    <ambient>0.200000 0.200000 0.200000 1.000000</ambient>\n    <background>0.700000 0.700000 0.700000 1.000000</background>\n    <shadows>1</shadows>\n  </scene>\n  <state world_name='default'>\n    <sim_time>0 0</sim_time>\n    <real_time>0 0</real_time>\n    <wall_time>1360301755 667456998</wall_time>\n  </state>\n</world>\n</sdf>]]></chunk>\n<chunk encoding='txt'><![CDATA[\n<sdf version='1.4'>\n<state world_name='default'>\n<sim_time>0 21343973</sim_time>\n<real_time>0 1000000</real_time>\n<wall_time>1360301758 939690376</wall_time>\n<model name='pr2'>\n0.000000 0.000000 \n</model>\n</sdf></state>\n]]></chunk>\n<chunk encoding='txt'><![CDATA[\n<sdf version='1.4'>\n<state world_name='default'>\n<sim_time>0 28958235</sim_time>\n<real_time>0 2000000</real_time>\n<wall_time>1360301758 947304437</wall_time>\n<model name='pr2'>\n0.000000 0.000000 \n</model>\n</sdf></state>\n]]></chunk>\n</gazebo_log>";

static std::string pr2LinkStateLog =
"<?xml version='1.0'?>\n<gazebo_log>\n<header>\n<log_version>1.0</log_version>\n<gazebo_version>1.4.6</gazebo_version>\n<rand_seed>32606</rand_seed>\n</header>\n\n<chunk encoding='txt'><![CDATA[\n<sdf version ='1.3'>\n<world name='default'>\n  <model name='ground_plane'>\n    <static>1</static>\n    <link name='link'>\n      <collision name='collision'>\n        <geometry>\n          <plane>\n            <normal>0.000000 0.000000 1.000000</normal>\n            <size>100.000000 100.000000</size>\n          </plane>\n        </geometry>\n        <surface>\n          <friction>\n            <ode>\n              <mu>100.000000</mu>\n              <mu2>50.000000</mu2>\n            </ode>\n          </friction>\n          <bounce/>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='visual'>\n        <cast_shadows>0</cast_shadows>\n        <geometry>\n          <plane>\n            <normal>0.000000 0.000000 1.000000</normal>\n            <size>100.000000 100.000000</size>\n          </plane>\n        </geometry>\n        <material>\n          <script>\n            <uri>file://media/materials/scripts/gazebo.material</uri>\n            <name>Gazebo/Grey</name>\n          </script>\n        </material>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <self_collide>0</self_collide>\n      <kinematic>0</kinematic>\n      <gravity>1</gravity>\n    </link>\n  </model>\n  <light name='sun' type='directional'>\n    <cast_shadows>1</cast_shadows>\n    <pose>0.000000 0.000000 10.000000 0.000000 0.000000 0.000000</pose>\n    <diffuse>0.800000 0.800000 0.800000 1.000000</diffuse>\n    <specular>0.100000 0.100000 0.100000 1.000000</specular>\n    <attenuation>\n      <range>1000.000000</range>\n      <constant>0.900000</constant>\n      <linear>0.010000</linear>\n      <quadratic>0.001000</quadratic>\n    </attenuation>\n    <direction>-0.500000 0.500000 -1.000000</direction>\n  </light>\n  <model name='pr2'>\n    <static>0</static>\n    <link name='base_footprint'>\n      <self_collide>0</self_collide>\n      <inertial>\n        <mass>118.001000</mass>\n        <pose>-0.062421 0.000000 0.201365 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>8.431730</ixx>\n          <ixy>-0.009720</ixy>\n          <ixz>1.901570</ixz>\n          <iyy>8.533050</iyy>\n          <iyz>-0.007380</iyz>\n          <izz>3.787470</izz>\n        </inertia>\n      </inertial>\n      <collision name='base_footprint_geom'>\n        <pose>0.000000 0.000000 0.071000 0.000000 0.000000 0.000000</pose>\n        <geometry>\n          <box>\n            <size>0.001000 0.001000 0.001000</size>\n          </box>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='base_footprint_geom_visual'>\n        <geometry>\n          <box>\n            <size>0.010000 0.010000 0.010000</size>\n          </box>\n        </geometry>\n      </visual>\n      <collision name='base_footprint_geom_base_bellow_link'>\n        <pose>-0.290000 0.000000 0.851000 0.000000 0.000000 0.000000</pose>\n        <geometry>\n          <box>\n            <size>0.050000 0.370000 0.300000</size>\n          </box>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='base_footprint_geom_base_bellow_link_visual'>\n        <pose>-0.290000 0.000000 0.851000 0.000000 0.000000 0.000000</pose>\n        <geometry>\n          <box>\n            <size>0.050000 0.370000 0.300000</size>\n          </box>\n        </geometry>\n      </visual>\n      <collision name='base_footprint_geom_base_link'>\n        <pose>0.000000 0.000000 0.051000 0.000000 0.000000 0.000000</pose>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/base_v0/base_L.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='base_footprint_geom_base_link_visual'>\n        <pose>0.000000 0.000000 0.051000 0.000000 0.000000 0.000000</pose>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/base_v0/base.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <sensor name='base_contact_sensor' type='contact'>\n        <update_rate>100.000000</update_rate>\n        <always_on>0</always_on>\n        <visualize>0</visualize>\n        <contact>\n          <collision>base_footprint_geom_base_link</collision>\n          <topic>__default_topic__</topic>\n        </contact>\n        <plugin name='gazebo_contact' filename='libContactPlugin.so'/>\n      </sensor>\n      <sensor name='base_laser' type='ray'>\n        <always_on>0</always_on>\n        <visualize>0</visualize>\n        <update_rate>20.000000</update_rate>\n        <pose>0.275000 0.000000 0.303000 0.000000 0.000000 0.000000</pose>\n        <ray>\n          <scan>\n            <horizontal>\n              <samples>640</samples>\n              <resolution>1.000000</resolution>\n              <min_angle>-2.268900</min_angle>\n              <max_angle>2.268900</max_angle>\n            </horizontal>\n          </scan>\n          <range>\n            <min>0.080000</min>\n            <max>10.000000</max>\n            <resolution>0.010000</resolution>\n          </range>\n        </ray>\n        <plugin name='laser' filename='libRayPlugin.so'/>\n      </sensor>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n      <gravity>1</gravity>\n    </link>\n    <link name='bl_caster_rotation_link'>\n      <self_collide>0</self_collide>\n      <pose>-0.224600 0.224600 0.079200 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>3.473080</mass>\n        <pose>0.000000 0.000000 0.070000 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.012412</ixx>\n          <ixy>-0.000712</ixy>\n          <ixz>0.000503</ixz>\n          <iyy>0.015218</iyy>\n          <iyz>-0.000004</iyz>\n          <izz>0.011764</izz>\n        </inertia>\n      </inertial>\n      <collision name='bl_caster_rotation_link_geom'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/base_v0/caster_L.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='bl_caster_rotation_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/base_v0/caster.stl</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n      <gravity>1</gravity>\n    </link>\n    <link name='bl_caster_l_wheel_link'>\n      <self_collide>0</self_collide>\n      <pose>-0.224600 0.273600 0.079200 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.440360</mass>\n        <inertia>\n          <ixx>0.012412</ixx>\n          <ixy>-0.000712</ixy>\n          <ixz>0.000503</ixz>\n          <iyy>0.015218</iyy>\n          <iyz>-0.000004</iyz>\n          <izz>0.011764</izz>\n        </inertia>\n      </inertial>\n      <collision name='bl_caster_l_wheel_link_geom'>\n        <pose>0.000000 0.000000 0.000000 1.570800 0.000000 0.000000</pose>\n        <geometry>\n          <cylinder>\n            <radius>0.074792</radius>\n            <length>0.034000</length>\n          </cylinder>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='bl_caster_l_wheel_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/base_v0/wheel.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n      <gravity>1</gravity>\n    </link>\n    <link name='bl_caster_r_wheel_link'>\n      <self_collide>0</self_collide>\n      <pose>-0.224600 0.175600 0.079200 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.440360</mass>\n        <inertia>\n          <ixx>0.012412</ixx>\n          <ixy>0.000712</ixy>\n          <ixz>0.000503</ixz>\n          <iyy>0.015218</iyy>\n          <iyz>0.000004</iyz>\n          <izz>0.011764</izz>\n        </inertia>\n      </inertial>\n      <collision name='bl_caster_r_wheel_link_geom'>\n        <pose>0.000000 0.000000 0.000000 1.570800 0.000000 0.000000</pose>\n        <geometry>\n          <cylinder>\n            <radius>0.074792</radius>\n            <length>0.034000</length>\n          </cylinder>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='bl_caster_r_wheel_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/base_v0/wheel.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n      <gravity>1</gravity>\n    </link>\n    <link name='br_caster_rotation_link'>\n      <self_collide>0</self_collide>\n      <pose>-0.224600 -0.224600 0.079200 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>3.473080</mass>\n        <pose>0.000000 0.000000 0.070000 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.012412</ixx>\n          <ixy>-0.000712</ixy>\n          <ixz>0.000503</ixz>\n          <iyy>0.015218</iyy>\n          <iyz>-0.000004</iyz>\n          <izz>0.011764</izz>\n        </inertia>\n      </inertial>\n      <collision name='br_caster_rotation_link_geom'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/base_v0/caster_L.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='br_caster_rotation_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/base_v0/caster.stl</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n      <gravity>1</gravity>\n    </link>\n    <link name='br_caster_l_wheel_link'>\n      <self_collide>0</self_collide>\n      <pose>-0.224600 -0.175600 0.079200 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.440360</mass>\n        <inertia>\n          <ixx>0.012412</ixx>\n          <ixy>-0.000712</ixy>\n          <ixz>0.000503</ixz>\n          <iyy>0.015218</iyy>\n          <iyz>-0.000004</iyz>\n          <izz>0.011764</izz>\n        </inertia>\n      </inertial>\n      <collision name='br_caster_l_wheel_link_geom'>\n        <pose>0.000000 0.000000 0.000000 1.570800 0.000000 0.000000</pose>\n        <geometry>\n          <cylinder>\n            <radius>0.074792</radius>\n            <length>0.034000</length>\n          </cylinder>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='br_caster_l_wheel_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/base_v0/wheel.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n      <gravity>1</gravity>\n    </link>\n    <link name='br_caster_r_wheel_link'>\n      <self_collide>0</self_collide>\n      <pose>-0.224600 -0.273600 0.079200 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.440360</mass>\n        <inertia>\n          <ixx>0.012412</ixx>\n          <ixy>-0.000712</ixy>\n          <ixz>0.000503</ixz>\n          <iyy>0.015218</iyy>\n          <iyz>-0.000004</iyz>\n          <izz>0.011764</izz>\n        </inertia>\n      </inertial>\n      <collision name='br_caster_r_wheel_link_geom'>\n        <pose>0.000000 0.000000 0.000000 1.570800 0.000000 0.000000</pose>\n        <geometry>\n          <cylinder>\n            <radius>0.074792</radius>\n            <length>0.034000</length>\n          </cylinder>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='br_caster_r_wheel_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/base_v0/wheel.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n      <gravity>1</gravity>\n    </link>\n    <link name='fl_caster_rotation_link'>\n      <self_collide>0</self_collide>\n      <pose>0.224600 0.224600 0.079200 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>3.473080</mass>\n        <pose>0.000000 0.000000 0.070000 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.012412</ixx>\n          <ixy>-0.000712</ixy>\n          <ixz>0.000503</ixz>\n          <iyy>0.015218</iyy>\n          <iyz>-0.000004</iyz>\n          <izz>0.011764</izz>\n        </inertia>\n      </inertial>\n      <collision name='fl_caster_rotation_link_geom'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/base_v0/caster_L.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='fl_caster_rotation_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/base_v0/caster.stl</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n      <gravity>1</gravity>\n    </link>\n    <link name='fl_caster_l_wheel_link'>\n      <self_collide>0</self_collide>\n      <pose>0.224600 0.273600 0.079200 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.440360</mass>\n        <inertia>\n          <ixx>0.012412</ixx>\n          <ixy>-0.000712</ixy>\n          <ixz>0.000503</ixz>\n          <iyy>0.015218</iyy>\n          <iyz>-0.000004</iyz>\n          <izz>0.011764</izz>\n        </inertia>\n      </inertial>\n      <collision name='fl_caster_l_wheel_link_geom'>\n        <pose>0.000000 0.000000 0.000000 1.570800 0.000000 0.000000</pose>\n        <geometry>\n          <cylinder>\n            <radius>0.074792</radius>\n            <length>0.034000</length>\n          </cylinder>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='fl_caster_l_wheel_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/base_v0/wheel.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n      <gravity>1</gravity>\n    </link>\n    <link name='fl_caster_r_wheel_link'>\n      <self_collide>0</self_collide>\n      <pose>0.224600 0.175600 0.079200 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.440360</mass>\n        <inertia>\n          <ixx>0.012412</ixx>\n          <ixy>-0.000712</ixy>\n          <ixz>0.000503</ixz>\n          <iyy>0.015218</iyy>\n          <iyz>-0.000004</iyz>\n          <izz>0.011764</izz>\n        </inertia>\n      </inertial>\n      <collision name='fl_caster_r_wheel_link_geom'>\n        <pose>0.000000 0.000000 0.000000 1.570800 0.000000 0.000000</pose>\n        <geometry>\n          <cylinder>\n            <radius>0.074792</radius>\n            <length>0.034000</length>\n          </cylinder>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='fl_caster_r_wheel_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/base_v0/wheel.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n      <gravity>1</gravity>\n    </link>\n    <link name='fr_caster_rotation_link'>\n      <self_collide>0</self_collide>\n      <pose>0.224600 -0.224600 0.079200 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>3.473080</mass>\n        <pose>0.000000 0.000000 0.070000 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.012412</ixx>\n          <ixy>-0.000712</ixy>\n          <ixz>0.000503</ixz>\n          <iyy>0.015218</iyy>\n          <iyz>-0.000004</iyz>\n          <izz>0.011764</izz>\n        </inertia>\n      </inertial>\n      <collision name='fr_caster_rotation_link_geom'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/base_v0/caster_L.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='fr_caster_rotation_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/base_v0/caster.stl</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n      <gravity>1</gravity>\n    </link>\n    <link name='fr_caster_l_wheel_link'>\n      <self_collide>0</self_collide>\n      <pose>0.224600 -0.175600 0.079200 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.440360</mass>\n        <inertia>\n          <ixx>0.012412</ixx>\n          <ixy>-0.000712</ixy>\n          <ixz>0.000503</ixz>\n          <iyy>0.015218</iyy>\n          <iyz>-0.000004</iyz>\n          <izz>0.011764</izz>\n        </inertia>\n      </inertial>\n      <collision name='fr_caster_l_wheel_link_geom'>\n        <pose>0.000000 0.000000 0.000000 1.570800 0.000000 0.000000</pose>\n        <geometry>\n          <cylinder>\n            <radius>0.074792</radius>\n            <length>0.034000</length>\n          </cylinder>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='fr_caster_l_wheel_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/base_v0/wheel.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n      <gravity>1</gravity>\n    </link>\n    <link name='fr_caster_r_wheel_link'>\n      <self_collide>0</self_collide>\n      <pose>0.224600 -0.273600 0.079200 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.440360</mass>\n        <inertia>\n          <ixx>0.012412</ixx>\n          <ixy>-0.000712</ixy>\n          <ixz>0.000503</ixz>\n          <iyy>0.015218</iyy>\n          <iyz>-0.000004</iyz>\n          <izz>0.011764</izz>\n        </inertia>\n      </inertial>\n      <collision name='fr_caster_r_wheel_link_geom'>\n        <pose>0.000000 0.000000 0.000000 1.570800 0.000000 0.000000</pose>\n        <geometry>\n          <cylinder>\n            <radius>0.074792</radius>\n            <length>0.034000</length>\n          </cylinder>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='fr_caster_r_wheel_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/base_v0/wheel.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n      <gravity>1</gravity>\n    </link>\n    <link name='torso_lift_link'>\n      <self_collide>0</self_collide>\n      <pose>-0.050000 0.000000 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>36.449000</mass>\n        <pose>-0.099499 -0.000004 -0.086764 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>2.792330</ixx>\n          <ixy>0.004280</ixy>\n          <ixz>-0.160631</ixz>\n          <iyy>2.521060</iyy>\n          <iyz>0.029689</iyz>\n          <izz>0.536551</izz>\n        </inertia>\n      </inertial>\n      <collision name='torso_lift_link_geom'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/torso_v0/torso_lift_L.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='torso_lift_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/torso_v0/torso_lift.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <sensor name='torso_lift_contact_sensor' type='contact'>\n        <update_rate>100.000000</update_rate>\n        <always_on>0</always_on>\n        <visualize>0</visualize>\n        <contact>\n          <collision>torso_lift_link_geom</collision>\n          <topic>__default_topic__</topic>\n        </contact>\n      </sensor>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n      <gravity>1</gravity>\n    </link>\n    <link name='head_pan_link'>\n      <self_collide>0</self_collide>\n      <pose>-0.067070 0.000000 1.172130 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>6.339000</mass>\n        <pose>0.010907 0.031693 0.090507 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.032498</ixx>\n          <ixy>0.000636</ixy>\n          <ixz>0.002585</ixz>\n          <iyy>0.046546</iyy>\n          <iyz>-0.002453</iyz>\n          <izz>0.057653</izz>\n        </inertia>\n      </inertial>\n      <collision name='head_pan_link_geom'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/head_v0/head_pan_L.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='head_pan_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/head_v0/head_pan.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n      <gravity>1</gravity>\n    </link>\n    <link name='head_tilt_link'>\n      <projector name='projector_wg6802418_projector_wg6802418'>\n        <texture>stereo_projection_pattern_high_res_red.png</texture>\n        <fov>0.959931</fov>\n        <near_clip>0.100000</near_clip>\n        <far_clip>10.000000</far_clip>\n        <pose>0.023200 0.110000 0.119100 0.000000 -1.570793 0.000000</pose>\n      </projector>\n      <self_collide>0</self_collide>\n      <pose>0.000930 0.000000 1.172130 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>5.319000</mass>\n        <pose>-0.005151 -0.014635 0.072819 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.126134</ixx>\n          <ixy>0.000237</ixy>\n          <ixz>0.011881</ixz>\n          <iyy>0.165102</iyy>\n          <iyz>0.001606</iyz>\n          <izz>0.166947</izz>\n        </inertia>\n      </inertial>\n      <collision name='head_tilt_link_geom'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/head_v0/head_tilt_L.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='head_tilt_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/head_v0/head_tilt.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <collision name='head_tilt_link_geom_head_mount_kinect_ir_link'>\n        <pose>-0.147067 0.012500 0.291953 0.000000 0.000000 0.000000</pose>\n        <geometry>\n          <sphere>\n            <radius>0.000500</radius>\n          </sphere>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='head_tilt_link_geom_head_mount_kinect_ir_link_visual'>\n        <pose>-0.147067 0.012500 0.291953 0.000000 0.000000 0.000000</pose>\n        <geometry>\n          <sphere>\n            <radius>0.000250</radius>\n          </sphere>\n        </geometry>\n        <material>\n          <script>\n            <uri>__default__</uri>\n            <name>__default__</name>\n          </script>\n        </material>\n      </visual>\n      <collision name='head_tilt_link_geom_head_mount_kinect_rgb_link'>\n        <pose>-0.147067 0.017500 0.291953 0.000000 0.000000 0.000000</pose>\n        <geometry>\n          <sphere>\n            <radius>0.000500</radius>\n          </sphere>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='head_tilt_link_geom_head_mount_kinect_rgb_link_visual'>\n        <pose>-0.147067 0.017500 0.291953 0.000000 0.000000 0.000000</pose>\n        <geometry>\n          <sphere>\n            <radius>0.000250</radius>\n          </sphere>\n        </geometry>\n        <material>\n          <script>\n            <uri>__default__</uri>\n            <name>__default__</name>\n          </script>\n        </material>\n      </visual>\n      <collision name='head_tilt_link_geom_head_mount_link'>\n        <pose>-0.114800 0.000000 0.155500 0.000000 0.000000 0.000000</pose>\n        <geometry>\n          <sphere>\n            <radius>0.000500</radius>\n          </sphere>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='head_tilt_link_geom_head_mount_link_visual'>\n        <pose>-0.114800 0.000000 0.155500 0.000000 0.000000 0.000000</pose>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/sensors/kinect_prosilica_v0/115x100_swept_back--coarse.STL</uri>\n            <scale>0.001000 0.001000 0.001000</scale>\n          </mesh>\n        </geometry>\n      </visual>\n      <collision name='head_tilt_link_geom_head_mount_prosilica_link'>\n        <pose>-0.161257 0.012500 0.244421 0.000000 0.000000 0.000000</pose>\n        <geometry>\n          <sphere>\n            <radius>0.000500</radius>\n          </sphere>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='head_tilt_link_geom_head_mount_prosilica_link_visual'>\n        <pose>-0.161257 0.012500 0.244421 0.000000 0.000000 0.000000</pose>\n        <geometry>\n          <sphere>\n            <radius>0.000250</radius>\n          </sphere>\n        </geometry>\n        <material>\n          <script>\n            <uri>__default__</uri>\n            <name>__default__</name>\n          </script>\n        </material>\n      </visual>\n      <collision name='head_tilt_link_geom_head_plate_frame'>\n        <pose>0.023200 0.000000 0.064500 0.000000 0.000000 0.000000</pose>\n        <geometry>\n          <box>\n            <size>0.010000 0.010000 0.010000</size>\n          </box>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='head_tilt_link_geom_head_plate_frame_visual'>\n        <pose>0.023200 0.000000 0.064500 0.000000 0.000000 0.000000</pose>\n        <geometry>\n          <box>\n            <size>0.010000 0.010000 0.010000</size>\n          </box>\n        </geometry>\n        <material>\n          <script>\n            <uri>__default__</uri>\n            <name>__default__</name>\n          </script>\n        </material>\n      </visual>\n      <sensor name='head_mount_sensor' type='camera'>\n        <always_on>0</always_on>\n        <visualize>0</visualize>\n        <update_rate>1.000000</update_rate>\n        <pose>-0.147067 0.012500 0.291953 0.000000 0.000000 0.000000</pose>\n        <camera name='__default__'>\n          <horizontal_fov>0.994838</horizontal_fov>\n          <image>\n            <width>640</width>\n            <height>480</height>\n            <format>L8</format>\n          </image>\n          <clip>\n            <near>0.010000</near>\n            <far>5.000000</far>\n          </clip>\n        </camera>\n      </sensor>\n      <sensor name='head_mount_prosilica_link_sensor' type='camera'>\n        <update_rate>1.000000</update_rate>\n        <pose>-0.161257 0.012500 0.244421 0.000000 0.000000 0.000000</pose>\n        <always_on>0</always_on>\n        <visualize>0</visualize>\n        <camera name='__default__'>\n          <horizontal_fov>1.120501</horizontal_fov>\n          <image>\n            <width>320</width>\n            <height>240</height>\n            <format>R8G8B8</format>\n          </image>\n          <clip>\n            <near>0.100000</near>\n            <far>100.000000</far>\n          </clip>\n        </camera>\n      </sensor>\n      <sensor name='head_mount_prosilica_link_sim_pcd_sensor' type='camera'>\n        <update_rate>1.000000</update_rate>\n        <pose>-0.161257 0.012500 0.244421 0.000000 0.000000 0.000000</pose>\n        <always_on>0</always_on>\n        <visualize>0</visualize>\n        <camera name='__default__'>\n          <horizontal_fov>1.120501</horizontal_fov>\n          <image>\n            <width>320</width>\n            <height>240</height>\n            <format>R8G8B8</format>\n          </image>\n          <clip>\n            <near>0.100000</near>\n            <far>100.000000</far>\n          </clip>\n        </camera>\n      </sensor>\n      <sensor name='narrow_stereo_gazebo_l_stereo_camera_sensor' type='camera'>\n        <always_on>0</always_on>\n        <visualize>0</visualize>\n        <update_rate>25.000000</update_rate>\n        <pose>0.068200 0.060000 0.114600 0.000000 0.000000 0.000000</pose>\n        <camera name='__default__'>\n          <horizontal_fov>0.785398</horizontal_fov>\n          <image>\n            <width>640</width>\n            <height>480</height>\n            <format>L8</format>\n          </image>\n          <clip>\n            <near>0.100000</near>\n            <far>100.000000</far>\n          </clip>\n        </camera>\n      </sensor>\n      <sensor name='narrow_stereo_gazebo_r_stereo_camera_sensor' type='camera'>\n        <always_on>0</always_on>\n        <visualize>0</visualize>\n        <update_rate>25.000000</update_rate>\n        <pose>0.068200 -0.030000 0.114600 0.000000 0.000000 0.000000</pose>\n        <camera name='__default__'>\n          <horizontal_fov>0.785398</horizontal_fov>\n          <image>\n            <width>640</width>\n            <height>480</height>\n            <format>L8</format>\n          </image>\n          <clip>\n            <near>0.100000</near>\n            <far>100.000000</far>\n          </clip>\n        </camera>\n      </sensor>\n      <sensor name='wide_stereo_gazebo_l_stereo_camera_sensor' type='camera'>\n        <update_rate>25.000000</update_rate>\n        <pose>0.068200 0.030000 0.114600 0.000000 0.000000 0.000000</pose>\n        <always_on>0</always_on>\n        <visualize>0</visualize>\n        <camera name='__default__'>\n          <horizontal_fov>1.570796</horizontal_fov>\n          <image>\n            <width>640</width>\n            <height>480</height>\n            <format>BAYER_BGGR8</format>\n          </image>\n          <clip>\n            <near>0.100000</near>\n            <far>100.000000</far>\n          </clip>\n        </camera>\n      </sensor>\n      <sensor name='wide_stereo_gazebo_r_stereo_camera_sensor' type='camera'>\n        <update_rate>25.000000</update_rate>\n        <pose>0.068200 -0.060000 0.114600 0.000000 0.000000 0.000000</pose>\n        <always_on>0</always_on>\n        <visualize>0</visualize>\n        <camera name='__default__'>\n          <horizontal_fov>1.570796</horizontal_fov>\n          <image>\n            <width>640</width>\n            <height>480</height>\n            <format>BAYER_BGGR8</format>\n          </image>\n          <clip>\n            <near>0.100000</near>\n            <far>100.000000</far>\n          </clip>\n        </camera>\n      </sensor>\n      <sensor name='high_def_sensor' type='camera'>\n        <update_rate>20.000000</update_rate>\n        <pose>0.069657 -0.110000 0.119100 0.000000 0.000000 0.000000</pose>\n        <always_on>0</always_on>\n        <visualize>0</visualize>\n        <camera name='__default__'>\n          <horizontal_fov>0.785398</horizontal_fov>\n          <image>\n            <width>2448</width>\n            <height>2050</height>\n            <format>R8G8B8</format>\n          </image>\n          <clip>\n            <near>0.100000</near>\n            <far>100.000000</far>\n          </clip>\n        </camera>\n      </sensor>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n      <gravity>1</gravity>\n    </link>\n    <link name='l_shoulder_pan_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>-0.050000 0.188000 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>25.799300</mass>\n        <pose>-0.001201 0.024513 -0.098231 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.866179</ixx>\n          <ixy>-0.060865</ixy>\n          <ixz>-0.121181</ixz>\n          <iyy>0.874217</iyy>\n          <iyz>-0.058866</iyz>\n          <izz>0.273538</izz>\n        </inertia>\n      </inertial>\n      <collision name='l_shoulder_pan_link_geom'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/shoulder_v0/shoulder_pan.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='l_shoulder_pan_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/shoulder_v0/shoulder_pan.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='l_shoulder_lift_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.050000 0.188000 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>2.749880</mass>\n        <pose>0.021950 -0.026640 -0.031270 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.021056</ixx>\n          <ixy>0.004967</ixy>\n          <ixz>-0.001948</ixz>\n          <iyy>0.021272</iyy>\n          <iyz>0.001104</iyz>\n          <izz>0.019758</izz>\n        </inertia>\n      </inertial>\n      <collision name='l_shoulder_lift_link_geom'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/shoulder_v0/shoulder_lift.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='l_shoulder_lift_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/shoulder_v0/shoulder_lift.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='l_upper_arm_roll_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.050000 0.188000 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>6.117690</mass>\n        <pose>0.210551 0.016309 -0.000561 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.025306</ixx>\n          <ixy>-0.003393</ixy>\n          <ixz>0.000608</ixz>\n          <iyy>0.084737</iyy>\n          <iyz>-0.000200</iyz>\n          <izz>0.086016</izz>\n        </inertia>\n      </inertial>\n      <collision name='l_upper_arm_roll_link_geom'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/shoulder_v0/upper_arm_roll_L.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='l_upper_arm_roll_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/shoulder_v0/upper_arm_roll.stl</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <collision name='l_upper_arm_roll_link_geom_l_upper_arm_link'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/upper_arm_v0/upper_arm.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='l_upper_arm_roll_link_geom_l_upper_arm_link_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/upper_arm_v0/upper_arm.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='l_elbow_flex_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.450000 0.188000 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>1.903270</mass>\n        <pose>0.010140 0.000320 -0.012110 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.003465</ixx>\n          <ixy>0.000041</ixy>\n          <ixz>0.000432</ixz>\n          <iyy>0.004416</iyy>\n          <iyz>-0.000040</iyz>\n          <izz>0.003592</izz>\n        </inertia>\n      </inertial>\n      <collision name='l_elbow_flex_link_geom'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/upper_arm_v0/elbow_flex.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='l_elbow_flex_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/upper_arm_v0/elbow_flex.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='l_forearm_roll_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.450000 0.188000 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>2.689680</mass>\n        <pose>0.180727 -0.000163 -0.008583 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.014668</ixx>\n          <ixy>0.000052</ixy>\n          <ixz>0.000656</ixz>\n          <iyy>0.026279</iyy>\n          <iyz>-0.000013</iyz>\n          <izz>0.027775</izz>\n        </inertia>\n      </inertial>\n      <collision name='l_forearm_roll_link_geom'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/upper_arm_v0/forearm_roll_L.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='l_forearm_roll_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/upper_arm_v0/forearm_roll.stl</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <collision name='l_forearm_roll_link_geom_l_forearm_link'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/forearm_v0/forearm.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='l_forearm_roll_link_geom_l_forearm_link_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/forearm_v0/forearm.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <sensor name='l_forearm_cam_sensor' type='camera'>\n        <update_rate>25.000000</update_rate>\n        <pose>0.135000 0.000000 0.044000 -1.570800 -0.562869 0.000000</pose>\n        <always_on>0</always_on>\n        <visualize>0</visualize>\n        <camera name='__default__'>\n          <horizontal_fov>1.570796</horizontal_fov>\n          <image>\n            <width>640</width>\n            <height>480</height>\n            <format>R8G8B8</format>\n          </image>\n          <clip>\n            <near>0.100000</near>\n            <far>100.000000</far>\n          </clip>\n        </camera>\n      </sensor>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='l_wrist_flex_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.771000 0.188000 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.614020</mass>\n        <pose>-0.001570 0.000000 -0.000750 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.000652</ixx>\n          <ixy>0.000000</ixy>\n          <ixz>0.000003</ixz>\n          <iyy>0.000198</iyy>\n          <iyz>0.000000</iyz>\n          <izz>0.000645</izz>\n        </inertia>\n      </inertial>\n      <collision name='l_wrist_flex_link_geom'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/forearm_v0/wrist_flex.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='l_wrist_flex_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/forearm_v0/wrist_flex.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='l_wrist_roll_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.771000 0.188000 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.681070</mass>\n        <pose>0.056408 0.000451 -0.001014 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.011352</ixx>\n          <ixy>-0.000016</ixy>\n          <ixz>-0.000001</ixz>\n          <iyy>0.011677</iyy>\n          <iyz>-0.000001</iyz>\n          <izz>0.011866</izz>\n        </inertia>\n      </inertial>\n      <collision name='l_wrist_roll_link_geom'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/forearm_v0/wrist_roll_L.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='l_wrist_roll_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/forearm_v0/wrist_roll.stl</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <collision name='l_wrist_roll_link_geom_l_gripper_motor_accelerometer_link'>\n        <geometry>\n          <box>\n            <size>0.001000 0.001000 0.001000</size>\n          </box>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='l_wrist_roll_link_geom_l_gripper_motor_accelerometer_link_visual'>\n        <geometry>\n          <box>\n            <size>0.001000 0.001000 0.001000</size>\n          </box>\n        </geometry>\n      </visual>\n      <collision name='l_wrist_roll_link_geom_l_gripper_palm_link'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/gripper_v0/gripper_palm.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='l_wrist_roll_link_geom_l_gripper_palm_link_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/gripper_v0/gripper_palm.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='l_gripper_l_finger_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.847910 0.198000 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.171260</mass>\n        <pose>0.035980 0.017300 -0.001640 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.000078</ixx>\n          <ixy>0.000001</ixy>\n          <ixz>-0.000010</ixz>\n          <iyy>0.000197</iyy>\n          <iyz>-0.000003</iyz>\n          <izz>0.000181</izz>\n        </inertia>\n      </inertial>\n      <collision name='l_gripper_l_finger_link_geom'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/gripper_v0/l_finger.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <friction>\n            <ode>\n              <mu>500.000000</mu>\n              <mu2>500.000000</mu2>\n              <slip1>0.000000</slip1>\n              <slip2>0.000000</slip2>\n            </ode>\n          </friction>\n          <contact>\n            <ode>\n              <kp>1000000.000000</kp>\n              <kd>1.000000</kd>\n              <max_vel>100.000000</max_vel>\n              <min_depth>0.000000</min_depth>\n            </ode>\n          </contact>\n          <bounce/>\n        </surface>\n      </collision>\n      <visual name='l_gripper_l_finger_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/gripper_v0/l_finger.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='l_gripper_l_finger_tip_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.939280 0.202950 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.044190</mass>\n        <pose>0.004230 0.002840 0.000000 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.000008</ixx>\n          <ixy>0.000006</ixy>\n          <ixz>0.000000</ixz>\n          <iyy>0.000010</iyy>\n          <iyz>0.000000</iyz>\n          <izz>0.000015</izz>\n        </inertia>\n      </inertial>\n      <collision name='l_gripper_l_finger_tip_link_geom'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/gripper_v0/l_finger_tip.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <friction>\n            <ode>\n              <mu>500.000000</mu>\n              <mu2>500.000000</mu2>\n              <slip1>0.000000</slip1>\n              <slip2>0.000000</slip2>\n            </ode>\n          </friction>\n          <contact>\n            <ode>\n              <kp>10000000.000000</kp>\n              <kd>1.000000</kd>\n              <max_vel>100.000000</max_vel>\n              <min_depth>0.000000</min_depth>\n            </ode>\n          </contact>\n          <bounce/>\n        </surface>\n      </collision>\n      <visual name='l_gripper_l_finger_tip_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/gripper_v0/l_finger_tip.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <sensor name='l_gripper_l_finger_tip_contact_sensor' type='contact'>\n        <update_rate>100.000000</update_rate>\n        <always_on>0</always_on>\n        <visualize>0</visualize>\n        <contact>\n          <collision>l_gripper_l_finger_tip_link_geom</collision>\n          <topic>__default_topic__</topic>\n        </contact>\n      </sensor>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='l_gripper_motor_slider_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.939280 0.188000 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.010000</mass>\n        <inertia>\n          <ixx>0.001000</ixx>\n          <ixy>0.000000</ixy>\n          <ixz>0.000000</ixz>\n          <iyy>0.001000</iyy>\n          <iyz>0.000000</iyz>\n          <izz>0.001000</izz>\n        </inertia>\n      </inertial>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='l_gripper_motor_screw_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.939280 0.188000 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.010000</mass>\n        <inertia>\n          <ixx>0.000100</ixx>\n          <ixy>0.000000</ixy>\n          <ixz>0.000000</ixz>\n          <iyy>0.000100</iyy>\n          <iyz>0.000000</iyz>\n          <izz>0.000100</izz>\n        </inertia>\n      </inertial>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='l_gripper_r_finger_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.847910 0.178000 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.173890</mass>\n        <pose>0.035760 -0.017360 -0.000950 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.000077</ixx>\n          <ixy>-0.000002</ixy>\n          <ixz>-0.000008</ixz>\n          <iyy>0.000198</iyy>\n          <iyz>0.000002</iyz>\n          <izz>0.000181</izz>\n        </inertia>\n      </inertial>\n      <collision name='l_gripper_r_finger_link_geom'>\n        <pose>0.000000 0.000000 0.000000 -3.141590 0.000000 0.000000</pose>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/gripper_v0/l_finger.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <friction>\n            <ode>\n              <mu>500.000000</mu>\n              <mu2>500.000000</mu2>\n              <slip1>0.000000</slip1>\n              <slip2>0.000000</slip2>\n            </ode>\n          </friction>\n          <contact>\n            <ode>\n              <kp>1000000.000000</kp>\n              <kd>1.000000</kd>\n              <max_vel>100.000000</max_vel>\n              <min_depth>0.000000</min_depth>\n            </ode>\n          </contact>\n          <bounce/>\n        </surface>\n      </collision>\n      <visual name='l_gripper_r_finger_link_geom_visual'>\n        <pose>0.000000 0.000000 0.000000 -3.141590 0.000000 0.000000</pose>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/gripper_v0/l_finger.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='l_gripper_r_finger_tip_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.939280 0.173050 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.044190</mass>\n        <pose>0.004230 -0.002840 0.000000 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.000008</ixx>\n          <ixy>-0.000006</ixy>\n          <ixz>0.000000</ixz>\n          <iyy>0.000010</iyy>\n          <iyz>0.000000</iyz>\n          <izz>0.000015</izz>\n        </inertia>\n      </inertial>\n      <collision name='l_gripper_r_finger_tip_link_geom'>\n        <pose>0.000000 0.000000 0.000000 -3.141590 0.000000 0.000000</pose>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/gripper_v0/l_finger_tip.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <friction>\n            <ode>\n              <mu>500.000000</mu>\n              <mu2>500.000000</mu2>\n              <slip1>0.000000</slip1>\n              <slip2>0.000000</slip2>\n            </ode>\n          </friction>\n          <contact>\n            <ode>\n              <kp>10000000.000000</kp>\n              <kd>1.000000</kd>\n              <max_vel>100.000000</max_vel>\n              <min_depth>0.000000</min_depth>\n            </ode>\n          </contact>\n          <bounce/>\n        </surface>\n      </collision>\n      <visual name='l_gripper_r_finger_tip_link_geom_visual'>\n        <pose>0.000000 0.000000 0.000000 -3.141590 0.000000 0.000000</pose>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/gripper_v0/l_finger_tip.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <sensor name='l_gripper_r_finger_tip_contact_sensor' type='contact'>\n        <update_rate>100.000000</update_rate>\n        <always_on>0</always_on>\n        <visualize>0</visualize>\n        <contact>\n          <collision>l_gripper_r_finger_tip_link_geom</collision>\n          <topic>__default_topic__</topic>\n        </contact>\n      </sensor>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='laser_tilt_mount_link'>\n      <self_collide>0</self_collide>\n      <pose>0.048930 0.000000 1.017680 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.592000</mass>\n        <pose>-0.001134 0.001667 -0.007067 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.001296</ixx>\n          <ixy>0.000023</ixy>\n          <ixz>0.000037</ixz>\n          <iyy>0.001086</iyy>\n          <iyz>0.000035</iyz>\n          <izz>0.000895</izz>\n        </inertia>\n      </inertial>\n      <collision name='laser_tilt_mount_link_geom'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/tilting_laser_v0/tilting_hokuyo_L.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <friction>\n            <ode>\n              <mu>0.000000</mu>\n              <mu2>0.000000</mu2>\n              <slip1>0.000000</slip1>\n              <slip2>0.000000</slip2>\n            </ode>\n          </friction>\n          <contact>\n            <ode>\n              <kp>1000000000000.000000</kp>\n              <kd>10000.000000</kd>\n              <max_vel>100.000000</max_vel>\n              <min_depth>0.000000</min_depth>\n            </ode>\n          </contact>\n          <bounce/>\n        </surface>\n      </collision>\n      <visual name='laser_tilt_mount_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/tilting_laser_v0/tilting_hokuyo.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <sensor name='laser_tilt' type='ray'>\n        <update_rate>40.000000</update_rate>\n        <pose>0.000000 0.000000 0.030000 0.000000 0.000000 0.000000</pose>\n        <always_on>0</always_on>\n        <visualize>0</visualize>\n        <ray>\n          <scan>\n            <horizontal>\n              <samples>640</samples>\n              <resolution>1.000000</resolution>\n              <min_angle>-1.396263</min_angle>\n              <max_angle>1.396263</max_angle>\n            </horizontal>\n          </scan>\n          <range>\n            <min>0.080000</min>\n            <max>10.000000</max>\n            <resolution>0.010000</resolution>\n          </range>\n        </ray>\n      </sensor>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n      <gravity>1</gravity>\n    </link>\n    <link name='r_shoulder_pan_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>-0.050000 -0.188000 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>25.799300</mass>\n        <pose>-0.001201 0.024513 -0.098231 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.866179</ixx>\n          <ixy>-0.060865</ixy>\n          <ixz>-0.121181</ixz>\n          <iyy>0.874217</iyy>\n          <iyz>-0.058866</iyz>\n          <izz>0.273538</izz>\n        </inertia>\n      </inertial>\n      <collision name='r_shoulder_pan_link_geom'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/shoulder_v0/shoulder_pan.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <friction>\n            <ode>\n              <mu>0.000000</mu>\n              <mu2>0.000000</mu2>\n              <slip1>0.000000</slip1>\n              <slip2>0.000000</slip2>\n            </ode>\n          </friction>\n          <contact>\n            <ode>\n              <kp>1000000000000.000000</kp>\n              <kd>10000.000000</kd>\n              <max_vel>100.000000</max_vel>\n              <min_depth>0.000000</min_depth>\n            </ode>\n          </contact>\n          <bounce/>\n        </surface>\n      </collision>\n      <visual name='r_shoulder_pan_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/shoulder_v0/shoulder_pan.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='r_shoulder_lift_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.050000 -0.188000 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>2.749880</mass>\n        <pose>0.021950 -0.026640 -0.031270 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.021056</ixx>\n          <ixy>0.004967</ixy>\n          <ixz>-0.001948</ixz>\n          <iyy>0.021272</iyy>\n          <iyz>0.001104</iyz>\n          <izz>0.019758</izz>\n        </inertia>\n      </inertial>\n      <collision name='r_shoulder_lift_link_geom'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/shoulder_v0/shoulder_lift.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <friction>\n            <ode>\n              <mu>0.000000</mu>\n              <mu2>0.000000</mu2>\n              <slip1>0.000000</slip1>\n              <slip2>0.000000</slip2>\n            </ode>\n          </friction>\n          <contact>\n            <ode>\n              <kp>1000000000000.000000</kp>\n              <kd>10000.000000</kd>\n              <max_vel>100.000000</max_vel>\n              <min_depth>0.000000</min_depth>\n            </ode>\n          </contact>\n          <bounce/>\n        </surface>\n      </collision>\n      <visual name='r_shoulder_lift_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/shoulder_v0/shoulder_lift.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='r_upper_arm_roll_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.050000 -0.188000 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>6.117690</mass>\n        <pose>0.210482 -0.015945 -0.000197 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.025378</ixx>\n          <ixy>0.003757</ixy>\n          <ixz>-0.000709</ixz>\n          <iyy>0.084737</iyy>\n          <iyz>-0.000179</iyz>\n          <izz>0.086088</izz>\n        </inertia>\n      </inertial>\n      <collision name='r_upper_arm_roll_link_geom'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/shoulder_v0/upper_arm_roll_L.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='r_upper_arm_roll_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/shoulder_v0/upper_arm_roll.stl</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <collision name='r_upper_arm_roll_link_geom_r_upper_arm_link'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/upper_arm_v0/upper_arm.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='r_upper_arm_roll_link_geom_r_upper_arm_link_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/upper_arm_v0/upper_arm.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='r_elbow_flex_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.450000 -0.188000 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>1.903270</mass>\n        <pose>0.010140 0.000320 -0.012110 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.003465</ixx>\n          <ixy>0.000041</ixy>\n          <ixz>0.000432</ixz>\n          <iyy>0.004416</iyy>\n          <iyz>-0.000040</iyz>\n          <izz>0.003592</izz>\n        </inertia>\n      </inertial>\n      <collision name='r_elbow_flex_link_geom'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/upper_arm_v0/elbow_flex.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='r_elbow_flex_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/upper_arm_v0/elbow_flex.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='r_forearm_roll_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.450000 -0.188000 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>2.689680</mass>\n        <pose>0.180727 -0.000163 -0.008583 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.014668</ixx>\n          <ixy>0.000052</ixy>\n          <ixz>0.000656</ixz>\n          <iyy>0.026279</iyy>\n          <iyz>-0.000013</iyz>\n          <izz>0.027775</izz>\n        </inertia>\n      </inertial>\n      <collision name='r_forearm_roll_link_geom'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/upper_arm_v0/forearm_roll_L.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='r_forearm_roll_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/upper_arm_v0/forearm_roll.stl</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <collision name='r_forearm_roll_link_geom_r_forearm_link'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/forearm_v0/forearm.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='r_forearm_roll_link_geom_r_forearm_link_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/forearm_v0/forearm.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <sensor name='r_forearm_cam_sensor' type='camera'>\n        <update_rate>25.000000</update_rate>\n        <pose>0.135000 0.000000 0.044000 1.570800 -0.562869 -0.000000</pose>\n        <always_on>0</always_on>\n        <visualize>0</visualize>\n        <camera name='__default__'>\n          <horizontal_fov>1.570796</horizontal_fov>\n          <image>\n            <width>640</width>\n            <height>480</height>\n            <format>R8G8B8</format>\n          </image>\n          <clip>\n            <near>0.100000</near>\n            <far>100.000000</far>\n          </clip>\n        </camera>\n      </sensor>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='r_wrist_flex_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.771000 -0.188000 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.614020</mass>\n        <pose>-0.001570 0.000000 -0.000750 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.000652</ixx>\n          <ixy>0.000000</ixy>\n          <ixz>0.000003</ixz>\n          <iyy>0.000198</iyy>\n          <iyz>0.000000</iyz>\n          <izz>0.000645</izz>\n        </inertia>\n      </inertial>\n      <collision name='r_wrist_flex_link_geom'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/forearm_v0/wrist_flex.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='r_wrist_flex_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/forearm_v0/wrist_flex.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='r_wrist_roll_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.771000 -0.188000 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.681070</mass>\n        <pose>0.056408 0.000451 -0.001014 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.011352</ixx>\n          <ixy>-0.000016</ixy>\n          <ixz>-0.000001</ixz>\n          <iyy>0.011677</iyy>\n          <iyz>-0.000001</iyz>\n          <izz>0.011866</izz>\n        </inertia>\n      </inertial>\n      <collision name='r_wrist_roll_link_geom'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/forearm_v0/wrist_roll_L.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='r_wrist_roll_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/forearm_v0/wrist_roll.stl</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <collision name='r_wrist_roll_link_geom_r_gripper_motor_accelerometer_link'>\n        <geometry>\n          <box>\n            <size>0.001000 0.001000 0.001000</size>\n          </box>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='r_wrist_roll_link_geom_r_gripper_motor_accelerometer_link_visual'>\n        <geometry>\n          <box>\n            <size>0.001000 0.001000 0.001000</size>\n          </box>\n        </geometry>\n      </visual>\n      <collision name='r_wrist_roll_link_geom_r_gripper_palm_link'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/gripper_v0/gripper_palm.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='r_wrist_roll_link_geom_r_gripper_palm_link_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/gripper_v0/gripper_palm.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='r_gripper_l_finger_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.847910 -0.178000 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.171260</mass>\n        <pose>0.035980 0.017300 -0.001640 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.000078</ixx>\n          <ixy>0.000001</ixy>\n          <ixz>0.000010</ixz>\n          <iyy>0.000197</iyy>\n          <iyz>-0.000003</iyz>\n          <izz>0.000181</izz>\n        </inertia>\n      </inertial>\n      <collision name='r_gripper_l_finger_link_geom'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/gripper_v0/l_finger.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <friction>\n            <ode>\n              <mu>500.000000</mu>\n              <mu2>500.000000</mu2>\n              <slip1>0.000000</slip1>\n              <slip2>0.000000</slip2>\n            </ode>\n          </friction>\n          <contact>\n            <ode>\n              <kp>1000000.000000</kp>\n              <kd>1.000000</kd>\n              <max_vel>100.000000</max_vel>\n              <min_depth>0.000000</min_depth>\n            </ode>\n          </contact>\n          <bounce/>\n        </surface>\n      </collision>\n      <visual name='r_gripper_l_finger_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/gripper_v0/l_finger.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='r_gripper_l_finger_tip_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.939280 -0.173050 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.044190</mass>\n        <pose>0.004230 0.002840 0.000000 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.000008</ixx>\n          <ixy>0.000006</ixy>\n          <ixz>0.000000</ixz>\n          <iyy>0.000010</iyy>\n          <iyz>0.000000</iyz>\n          <izz>0.000015</izz>\n        </inertia>\n      </inertial>\n      <collision name='r_gripper_l_finger_tip_link_geom'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/gripper_v0/l_finger_tip.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <friction>\n            <ode>\n              <mu>500.000000</mu>\n              <mu2>500.000000</mu2>\n              <slip1>0.000000</slip1>\n              <slip2>0.000000</slip2>\n            </ode>\n          </friction>\n          <contact>\n            <ode>\n              <kp>10000000.000000</kp>\n              <kd>1.000000</kd>\n              <max_vel>100.000000</max_vel>\n              <min_depth>0.000000</min_depth>\n            </ode>\n          </contact>\n          <bounce/>\n        </surface>\n      </collision>\n      <visual name='r_gripper_l_finger_tip_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/gripper_v0/l_finger_tip.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <sensor name='r_gripper_l_finger_tip_contact_sensor' type='contact'>\n        <update_rate>100.000000</update_rate>\n        <always_on>0</always_on>\n        <visualize>0</visualize>\n        <contact>\n          <collision>r_gripper_l_finger_tip_link_geom</collision>\n          <topic>__default_topic__</topic>\n        </contact>\n      </sensor>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='r_gripper_motor_slider_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.939280 -0.188000 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.010000</mass>\n        <inertia>\n          <ixx>0.001000</ixx>\n          <ixy>0.000000</ixy>\n          <ixz>0.000000</ixz>\n          <iyy>0.001000</iyy>\n          <iyz>0.000000</iyz>\n          <izz>0.001000</izz>\n        </inertia>\n      </inertial>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='r_gripper_motor_screw_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.939280 -0.188000 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.010000</mass>\n        <inertia>\n          <ixx>0.000100</ixx>\n          <ixy>0.000000</ixy>\n          <ixz>0.000000</ixz>\n          <iyy>0.000100</iyy>\n          <iyz>0.000000</iyz>\n          <izz>0.000100</izz>\n        </inertia>\n      </inertial>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='r_gripper_r_finger_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.847910 -0.198000 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.173890</mass>\n        <pose>0.035760 -0.017360 -0.000950 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.000077</ixx>\n          <ixy>-0.000002</ixy>\n          <ixz>-0.000008</ixz>\n          <iyy>0.000198</iyy>\n          <iyz>0.000002</iyz>\n          <izz>0.000181</izz>\n        </inertia>\n      </inertial>\n      <collision name='r_gripper_r_finger_link_geom'>\n        <pose>0.000000 0.000000 0.000000 -3.141590 0.000000 0.000000</pose>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/gripper_v0/l_finger.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <friction>\n            <ode>\n              <mu>500.000000</mu>\n              <mu2>500.000000</mu2>\n              <slip1>0.000000</slip1>\n              <slip2>0.000000</slip2>\n            </ode>\n          </friction>\n          <contact>\n            <ode>\n              <kp>1000000.000000</kp>\n              <kd>1.000000</kd>\n              <max_vel>100.000000</max_vel>\n              <min_depth>0.000000</min_depth>\n            </ode>\n          </contact>\n          <bounce/>\n        </surface>\n      </collision>\n      <visual name='r_gripper_r_finger_link_geom_visual'>\n        <pose>0.000000 0.000000 0.000000 -3.141590 0.000000 0.000000</pose>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/gripper_v0/l_finger.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='r_gripper_r_finger_tip_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.939280 -0.202950 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.044190</mass>\n        <pose>0.004230 -0.002840 0.000000 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.000008</ixx>\n          <ixy>-0.000006</ixy>\n          <ixz>0.000000</ixz>\n          <iyy>0.000010</iyy>\n          <iyz>0.000000</iyz>\n          <izz>0.000015</izz>\n        </inertia>\n      </inertial>\n      <collision name='r_gripper_r_finger_tip_link_geom'>\n        <pose>0.000000 0.000000 0.000000 -3.141590 0.000000 0.000000</pose>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/gripper_v0/l_finger_tip.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <friction>\n            <ode>\n              <mu>500.000000</mu>\n              <mu2>500.000000</mu2>\n              <slip1>0.000000</slip1>\n              <slip2>0.000000</slip2>\n            </ode>\n          </friction>\n          <contact>\n            <ode>\n              <kp>10000000.000000</kp>\n              <kd>1.000000</kd>\n              <max_vel>100.000000</max_vel>\n              <min_depth>0.000000</min_depth>\n            </ode>\n          </contact>\n          <bounce/>\n        </surface>\n      </collision>\n      <visual name='r_gripper_r_finger_tip_link_geom_visual'>\n        <pose>0.000000 0.000000 0.000000 -3.141590 0.000000 0.000000</pose>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/gripper_v0/l_finger_tip.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <sensor name='r_gripper_r_finger_tip_contact_sensor' type='contact'>\n        <update_rate>100.000000</update_rate>\n        <always_on>0</always_on>\n        <visualize>0</visualize>\n        <contact>\n          <collision>r_gripper_r_finger_tip_link_geom</collision>\n          <topic>__default_topic__</topic>\n        </contact>\n      </sensor>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='torso_lift_motor_screw_link'>\n      <self_collide>0</self_collide>\n      <pose>-0.150000 0.000000 0.751000 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>1.000000</mass>\n        <inertia>\n          <ixx>0.001000</ixx>\n          <ixy>0.000000</ixy>\n          <ixz>0.000000</ixz>\n          <iyy>0.001000</iyy>\n          <iyz>0.000000</iyz>\n          <izz>0.001000</izz>\n        </inertia>\n      </inertial>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n      <gravity>1</gravity>\n    </link>\n    <link name='r_gripper_l_parallel_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.829910 -0.157000 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.171260</mass>\n        <pose>0.035980 0.017300 -0.001640 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.000078</ixx>\n          <ixy>0.000001</ixy>\n          <ixz>-0.000010</ixz>\n          <iyy>0.000197</iyy>\n          <iyz>-0.000003</iyz>\n          <izz>0.000181</izz>\n        </inertia>\n      </inertial>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='r_gripper_r_parallel_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.829910 -0.219000 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.173890</mass>\n        <pose>0.035760 -0.017360 -0.000950 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.000077</ixx>\n          <ixy>-0.000002</ixy>\n          <ixz>-0.000008</ixz>\n          <iyy>0.000198</iyy>\n          <iyz>0.000002</iyz>\n          <izz>0.000181</izz>\n        </inertia>\n      </inertial>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='l_gripper_l_parallel_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.829910 0.219000 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.171260</mass>\n        <pose>0.035980 0.017300 -0.001640 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.000078</ixx>\n          <ixy>0.000001</ixy>\n          <ixz>0.000010</ixz>\n          <iyy>0.000197</iyy>\n          <iyz>-0.000003</iyz>\n          <izz>0.000181</izz>\n        </inertia>\n      </inertial>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='l_gripper_r_parallel_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.829910 0.157000 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.173890</mass>\n        <pose>0.035760 -0.017360 -0.000950 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.000077</ixx>\n          <ixy>-0.000002</ixy>\n          <ixz>0.000008</ixz>\n          <iyy>0.000198</iyy>\n          <iyz>0.000002</iyz>\n          <izz>0.000181</izz>\n        </inertia>\n      </inertial>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <joint name='bl_caster_rotation_joint' type='revolute'>\n      <parent>base_footprint</parent>\n      <child>bl_caster_rotation_link</child>\n      <axis>\n        <xyz>0.000000 0.000000 1.000000</xyz>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='bl_caster_l_wheel_joint' type='revolute'>\n      <parent>bl_caster_rotation_link</parent>\n      <child>bl_caster_l_wheel_link</child>\n      <axis>\n        <xyz>0.000000 1.000000 0.000000</xyz>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='bl_caster_r_wheel_joint' type='revolute'>\n      <parent>bl_caster_rotation_link</parent>\n      <child>bl_caster_r_wheel_link</child>\n      <axis>\n        <xyz>0.000000 1.000000 0.000000</xyz>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='br_caster_rotation_joint' type='revolute'>\n      <parent>base_footprint</parent>\n      <child>br_caster_rotation_link</child>\n      <axis>\n        <xyz>0.000000 0.000000 1.000000</xyz>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='br_caster_l_wheel_joint' type='revolute'>\n      <parent>br_caster_rotation_link</parent>\n      <child>br_caster_l_wheel_link</child>\n      <axis>\n        <xyz>0.000000 1.000000 0.000000</xyz>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='br_caster_r_wheel_joint' type='revolute'>\n      <parent>br_caster_rotation_link</parent>\n      <child>br_caster_r_wheel_link</child>\n      <axis>\n        <xyz>0.000000 1.000000 0.000000</xyz>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='fl_caster_rotation_joint' type='revolute'>\n      <parent>base_footprint</parent>\n      <child>fl_caster_rotation_link</child>\n      <axis>\n        <xyz>0.000000 0.000000 1.000000</xyz>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='fl_caster_l_wheel_joint' type='revolute'>\n      <parent>fl_caster_rotation_link</parent>\n      <child>fl_caster_l_wheel_link</child>\n      <axis>\n        <xyz>0.000000 1.000000 0.000000</xyz>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='fl_caster_r_wheel_joint' type='revolute'>\n      <parent>fl_caster_rotation_link</parent>\n      <child>fl_caster_r_wheel_link</child>\n      <axis>\n        <xyz>0.000000 1.000000 0.000000</xyz>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='fr_caster_rotation_joint' type='revolute'>\n      <parent>base_footprint</parent>\n      <child>fr_caster_rotation_link</child>\n      <axis>\n        <xyz>0.000000 0.000000 1.000000</xyz>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='fr_caster_l_wheel_joint' type='revolute'>\n      <parent>fr_caster_rotation_link</parent>\n      <child>fr_caster_l_wheel_link</child>\n      <axis>\n        <xyz>0.000000 1.000000 0.000000</xyz>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='fr_caster_r_wheel_joint' type='revolute'>\n      <parent>fr_caster_rotation_link</parent>\n      <child>fr_caster_r_wheel_link</child>\n      <axis>\n        <xyz>0.000000 1.000000 0.000000</xyz>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='torso_lift_joint' type='prismatic'>\n      <parent>base_footprint</parent>\n      <child>torso_lift_link</child>\n      <axis>\n        <xyz>0.000000 0.000000 1.000000</xyz>\n        <limit>\n          <lower>0.000000</lower>\n          <upper>0.330000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='head_pan_joint' type='revolute'>\n      <parent>torso_lift_link</parent>\n      <child>head_pan_link</child>\n      <axis>\n        <xyz>0.000000 0.000000 1.000000</xyz>\n        <dynamics>\n          <damping>2.000000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-3.006993</lower>\n          <upper>3.006993</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='head_tilt_joint' type='revolute'>\n      <parent>head_pan_link</parent>\n      <child>head_tilt_link</child>\n      <axis>\n        <xyz>0.000000 1.000000 0.000000</xyz>\n        <dynamics>\n          <damping>10.000000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-0.471237</lower>\n          <upper>1.396260</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='l_shoulder_pan_joint' type='revolute'>\n      <parent>torso_lift_link</parent>\n      <child>l_shoulder_pan_link</child>\n      <axis>\n        <xyz>0.000000 0.000000 1.000000</xyz>\n        <dynamics>\n          <damping>10.000000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-0.714602</lower>\n          <upper>2.285404</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='l_shoulder_lift_joint' type='revolute'>\n      <parent>l_shoulder_pan_link</parent>\n      <child>l_shoulder_lift_link</child>\n      <axis>\n        <xyz>0.000000 1.000000 0.000000</xyz>\n        <dynamics>\n          <damping>10.000000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-0.523601</lower>\n          <upper>1.396300</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='l_upper_arm_roll_joint' type='revolute'>\n      <parent>l_shoulder_lift_link</parent>\n      <child>l_upper_arm_roll_link</child>\n      <axis>\n        <xyz>1.000000 0.000000 0.000000</xyz>\n        <dynamics>\n          <damping>0.100000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-0.800000</lower>\n          <upper>3.900008</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='l_elbow_flex_joint' type='revolute'>\n      <parent>l_upper_arm_roll_link</parent>\n      <child>l_elbow_flex_link</child>\n      <axis>\n        <xyz>0.000000 1.000000 0.000000</xyz>\n        <dynamics>\n          <damping>1.000000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-2.321305</lower>\n          <upper>0.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='l_forearm_roll_joint' type='revolute'>\n      <parent>l_elbow_flex_link</parent>\n      <child>l_forearm_roll_link</child>\n      <axis>\n        <xyz>1.000000 0.000000 0.000000</xyz>\n        <dynamics>\n          <damping>0.100000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='l_wrist_flex_joint' type='revolute'>\n      <parent>l_forearm_roll_link</parent>\n      <child>l_wrist_flex_link</child>\n      <axis>\n        <xyz>0.000000 1.000000 0.000000</xyz>\n        <dynamics>\n          <damping>0.100000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-2.180004</lower>\n          <upper>0.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='l_wrist_roll_joint' type='revolute'>\n      <parent>l_wrist_flex_link</parent>\n      <child>l_wrist_roll_link</child>\n      <axis>\n        <xyz>1.000000 0.000000 0.000000</xyz>\n        <dynamics>\n          <damping>0.100000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='l_gripper_l_finger_joint' type='revolute'>\n      <parent>l_wrist_roll_link</parent>\n      <child>l_gripper_l_finger_link</child>\n      <axis>\n        <xyz>0.000000 0.000000 1.000000</xyz>\n        <dynamics>\n          <damping>0.020000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>0.000000</lower>\n          <upper>0.548000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='l_gripper_l_finger_tip_joint' type='revolute'>\n      <parent>l_gripper_l_finger_link</parent>\n      <child>l_gripper_l_finger_tip_link</child>\n      <axis>\n        <xyz>0.000000 0.000000 -1.000000</xyz>\n        <dynamics>\n          <damping>0.001000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>0.000000</lower>\n          <upper>0.548000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='l_gripper_motor_slider_joint' type='prismatic'>\n      <parent>l_wrist_roll_link</parent>\n      <child>l_gripper_motor_slider_link</child>\n      <axis>\n        <xyz>1.000000 0.000000 0.000000</xyz>\n        <limit>\n          <lower>-0.100000</lower>\n          <upper>0.100000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='l_gripper_motor_screw_joint' type='revolute'>\n      <parent>l_gripper_motor_slider_link</parent>\n      <child>l_gripper_motor_screw_link</child>\n      <axis>\n        <xyz>0.000000 1.000000 0.000000</xyz>\n        <dynamics>\n          <damping>0.000100</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='l_gripper_r_finger_joint' type='revolute'>\n      <parent>l_wrist_roll_link</parent>\n      <child>l_gripper_r_finger_link</child>\n      <axis>\n        <xyz>0.000000 0.000000 -1.000000</xyz>\n        <dynamics>\n          <damping>0.020000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>0.000000</lower>\n          <upper>0.548000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='l_gripper_r_finger_tip_joint' type='revolute'>\n      <parent>l_gripper_r_finger_link</parent>\n      <child>l_gripper_r_finger_tip_link</child>\n      <axis>\n        <xyz>0.000000 0.000000 1.000000</xyz>\n        <dynamics>\n          <damping>0.001000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>0.000000</lower>\n          <upper>0.548000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='laser_tilt_mount_joint' type='revolute'>\n      <parent>torso_lift_link</parent>\n      <child>laser_tilt_mount_link</child>\n      <axis>\n        <xyz>0.000000 1.000000 0.000000</xyz>\n        <dynamics>\n          <damping>0.008000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-0.785400</lower>\n          <upper>1.483530</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='r_shoulder_pan_joint' type='revolute'>\n      <parent>torso_lift_link</parent>\n      <child>r_shoulder_pan_link</child>\n      <axis>\n        <xyz>0.000000 0.000000 1.000000</xyz>\n        <dynamics>\n          <damping>10.000000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-2.285404</lower>\n          <upper>0.714602</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='r_shoulder_lift_joint' type='revolute'>\n      <parent>r_shoulder_pan_link</parent>\n      <child>r_shoulder_lift_link</child>\n      <axis>\n        <xyz>0.000000 1.000000 0.000000</xyz>\n        <dynamics>\n          <damping>10.000000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-0.523601</lower>\n          <upper>1.396300</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='r_upper_arm_roll_joint' type='revolute'>\n      <parent>r_shoulder_lift_link</parent>\n      <child>r_upper_arm_roll_link</child>\n      <axis>\n        <xyz>1.000000 0.000000 0.000000</xyz>\n        <dynamics>\n          <damping>0.100000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-3.900008</lower>\n          <upper>0.800000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='r_elbow_flex_joint' type='revolute'>\n      <parent>r_upper_arm_roll_link</parent>\n      <child>r_elbow_flex_link</child>\n      <axis>\n        <xyz>0.000000 1.000000 0.000000</xyz>\n        <dynamics>\n          <damping>1.000000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-2.321305</lower>\n          <upper>0.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='r_forearm_roll_joint' type='revolute'>\n      <parent>r_elbow_flex_link</parent>\n      <child>r_forearm_roll_link</child>\n      <axis>\n        <xyz>1.000000 0.000000 0.000000</xyz>\n        <dynamics>\n          <damping>0.100000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='r_wrist_flex_joint' type='revolute'>\n      <parent>r_forearm_roll_link</parent>\n      <child>r_wrist_flex_link</child>\n      <axis>\n        <xyz>0.000000 1.000000 0.000000</xyz>\n        <dynamics>\n          <damping>0.100000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-2.180004</lower>\n          <upper>0.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='r_wrist_roll_joint' type='revolute'>\n      <parent>r_wrist_flex_link</parent>\n      <child>r_wrist_roll_link</child>\n      <axis>\n        <xyz>1.000000 0.000000 0.000000</xyz>\n        <dynamics>\n          <damping>0.100000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='r_gripper_l_finger_joint' type='revolute'>\n      <parent>r_wrist_roll_link</parent>\n      <child>r_gripper_l_finger_link</child>\n      <axis>\n        <xyz>0.000000 0.000000 1.000000</xyz>\n        <dynamics>\n          <damping>0.020000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>0.000000</lower>\n          <upper>0.548000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='r_gripper_l_finger_tip_joint' type='revolute'>\n      <parent>r_gripper_l_finger_link</parent>\n      <child>r_gripper_l_finger_tip_link</child>\n      <axis>\n        <xyz>0.000000 0.000000 -1.000000</xyz>\n        <dynamics>\n          <damping>0.001000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>0.000000</lower>\n          <upper>0.548000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='r_gripper_motor_slider_joint' type='prismatic'>\n      <parent>r_wrist_roll_link</parent>\n      <child>r_gripper_motor_slider_link</child>\n      <axis>\n        <xyz>1.000000 0.000000 0.000000</xyz>\n        <dynamics>\n          <damping>0.000000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-0.100000</lower>\n          <upper>0.100000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='r_gripper_motor_screw_joint' type='revolute'>\n      <parent>r_gripper_motor_slider_link</parent>\n      <child>r_gripper_motor_screw_link</child>\n      <axis>\n        <xyz>0.000000 1.000000 0.000000</xyz>\n        <dynamics>\n          <damping>0.000100</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='r_gripper_r_finger_joint' type='revolute'>\n      <parent>r_wrist_roll_link</parent>\n      <child>r_gripper_r_finger_link</child>\n      <axis>\n        <xyz>0.000000 0.000000 -1.000000</xyz>\n        <dynamics>\n          <damping>0.020000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>0.000000</lower>\n          <upper>0.548000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='r_gripper_r_finger_tip_joint' type='revolute'>\n      <parent>r_gripper_r_finger_link</parent>\n      <child>r_gripper_r_finger_tip_link</child>\n      <axis>\n        <xyz>0.000000 0.000000 1.000000</xyz>\n        <dynamics>\n          <damping>0.001000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>0.000000</lower>\n          <upper>0.548000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='torso_lift_motor_screw_joint' type='revolute'>\n      <parent>base_footprint</parent>\n      <child>torso_lift_motor_screw_link</child>\n      <axis>\n        <xyz>0.000000 0.000000 1.000000</xyz>\n        <dynamics>\n          <damping>0.000100</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='torso_lift_screw_torso_lift_joint' type='screw'>\n      <parent>torso_lift_link</parent>\n      <child>torso_lift_motor_screw_link</child>\n      <thread_pitch>3141.600000</thread_pitch>\n      <axis>\n        <xyz>0.000000 0.000000 1.000000</xyz>\n        <dynamics>\n          <damping>0.000000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='r_gripper_r_screw_screw_joint' type='screw'>\n      <parent>r_gripper_r_finger_tip_link</parent>\n      <child>r_gripper_motor_screw_link</child>\n      <thread_pitch>-3141.600000</thread_pitch>\n      <axis>\n        <xyz>0.000000 1.000000 0.000000</xyz>\n        <dynamics>\n          <damping>0.000000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='r_gripper_l_screw_screw_joint' type='screw'>\n      <parent>r_gripper_l_finger_tip_link</parent>\n      <child>r_gripper_motor_screw_link</child>\n      <thread_pitch>3141.600000</thread_pitch>\n      <axis>\n        <xyz>0.000000 1.000000 0.000000</xyz>\n        <dynamics>\n          <damping>0.000000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='r_gripper_r_parallel_root_joint' type='revolute'>\n      <pose>0.058910 -0.031000 0.000000 0.000000 0.000000 0.000000</pose>\n      <parent>r_gripper_r_parallel_link</parent>\n      <child>r_wrist_roll_link</child>\n      <axis>\n        <xyz>0.000000 0.000000 -1.000000</xyz>\n        <dynamics>\n          <damping>0.200000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='r_gripper_l_parallel_root_joint' type='revolute'>\n      <pose>0.058910 0.031000 0.000000 0.000000 0.000000 0.000000</pose>\n      <parent>r_gripper_l_parallel_link</parent>\n      <child>r_wrist_roll_link</child>\n      <axis>\n        <xyz>0.000000 0.000000 1.000000</xyz>\n        <dynamics>\n          <damping>0.200000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='r_gripper_r_parallel_tip_joint' type='revolute'>\n      <pose>-0.018000 -0.021000 0.000000 0.000000 0.000000 0.000000</pose>\n      <parent>r_gripper_r_parallel_link</parent>\n      <child>r_gripper_r_finger_tip_link</child>\n      <axis>\n        <xyz>0.000000 0.000000 1.000000</xyz>\n        <dynamics>\n          <damping>0.000000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='r_gripper_l_parallel_tip_joint' type='revolute'>\n      <pose>-0.018000 0.021000 0.000000 0.000000 0.000000 0.000000</pose>\n      <parent>r_gripper_l_parallel_link</parent>\n      <child>r_gripper_l_finger_tip_link</child>\n      <axis>\n        <xyz>0.000000 0.000000 1.000000</xyz>\n        <dynamics>\n          <damping>0.000000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='r_gripper_joint' type='prismatic'>\n      <parent>r_gripper_r_finger_tip_link</parent>\n      <child>r_gripper_l_finger_tip_link</child>\n      <axis>\n        <xyz>0.000000 1.000000 0.000000</xyz>\n        <dynamics>\n          <damping>0.000000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='l_gripper_r_screw_screw_joint' type='screw'>\n      <parent>l_gripper_r_finger_tip_link</parent>\n      <child>l_gripper_motor_screw_link</child>\n      <thread_pitch>-3141.600000</thread_pitch>\n      <axis>\n        <xyz>0.000000 1.000000 0.000000</xyz>\n        <dynamics>\n          <damping>0.000000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='l_gripper_l_screw_screw_joint' type='screw'>\n      <parent>l_gripper_l_finger_tip_link</parent>\n      <child>l_gripper_motor_screw_link</child>\n      <thread_pitch>3141.600000</thread_pitch>\n      <axis>\n        <xyz>0.000000 1.000000 0.000000</xyz>\n        <dynamics>\n          <damping>0.000000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='l_gripper_r_parallel_root_joint' type='revolute'>\n      <pose>0.058910 -0.031000 0.000000 0.000000 0.000000 0.000000</pose>\n      <parent>l_gripper_r_parallel_link</parent>\n      <child>l_wrist_roll_link</child>\n      <axis>\n        <xyz>0.000000 0.000000 -1.000000</xyz>\n        <dynamics>\n          <damping>0.200000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='l_gripper_l_parallel_root_joint' type='revolute'>\n      <pose>0.058910 0.031000 0.000000 0.000000 0.000000 0.000000</pose>\n      <parent>l_gripper_l_parallel_link</parent>\n      <child>l_wrist_roll_link</child>\n      <axis>\n        <xyz>0.000000 0.000000 1.000000</xyz>\n        <dynamics>\n          <damping>0.200000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='l_gripper_r_parallel_tip_joint' type='revolute'>\n      <pose>-0.018000 -0.021000 0.000000 0.000000 0.000000 0.000000</pose>\n      <parent>l_gripper_r_parallel_link</parent>\n      <child>l_gripper_r_finger_tip_link</child>\n      <axis>\n        <xyz>0.000000 0.000000 1.000000</xyz>\n        <dynamics>\n          <damping>0.000000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='l_gripper_l_parallel_tip_joint' type='revolute'>\n      <pose>-0.018000 0.021000 0.000000 0.000000 0.000000 0.000000</pose>\n      <parent>l_gripper_l_parallel_link</parent>\n      <child>l_gripper_l_finger_tip_link</child>\n      <axis>\n        <xyz>0.000000 0.000000 1.000000</xyz>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='l_gripper_joint' type='prismatic'>\n      <parent>l_gripper_r_finger_tip_link</parent>\n      <child>l_gripper_l_finger_tip_link</child>\n      <axis>\n        <xyz>0.000000 1.000000 0.000000</xyz>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n  </model>\n  <physics type='ode'>\n    <update_rate>1000.000000</update_rate>\n    <gravity>0.000000 0.000000 -9.800000</gravity>\n  </physics>\n  <scene>\n    <ambient>0.200000 0.200000 0.200000 1.000000</ambient>\n    <background>0.700000 0.700000 0.700000 1.000000</background>\n    <shadows>1</shadows>\n  </scene>\n  <state world_name='default'>\n    <sim_time>0 0</sim_time>\n    <real_time>0 0</real_time>\n    <wall_time>1360301755 667456998</wall_time>\n  </state>\n</world>\n</sdf>]]></chunk>\n<chunk encoding='txt'><![CDATA[\n<sdf version='1.4'>\n<state world_name='default'>\n<sim_time>0 21343973</sim_time>\n<real_time>0 1000000</real_time>\n<wall_time>1360301758 939690376</wall_time>\n<model name='pr2'>\n<link name='r_upper_arm_roll_link'>\n<pose>0.000000 0.000000 0.000001 -0.000010 -0.000013 0.000000</pose>\n</link>\n</model>\n</sdf></state>\n]]></chunk>\n<chunk encoding='txt'><![CDATA[\n<sdf version='1.4'>\n<state world_name='default'>\n<sim_time>0 28958235</sim_time>\n<real_time>0 2000000</real_time>\n<wall_time>1360301758 947304437</wall_time>\n<model name='pr2'>\n<link name='r_upper_arm_roll_link'>\n<pose>0.000000 0.000000 0.000002 -0.000022 -0.000026 0.000000</pose>\n</link>\n</model>\n</sdf></state>\n]]></chunk>\n</gazebo_log>";

static std::string pr2JointStateLog =
"<?xml version='1.0'?>\n<gazebo_log>\n<header>\n<log_version>1.0</log_version>\n<gazebo_version>1.4.6</gazebo_version>\n<rand_seed>32606</rand_seed>\n</header>\n\n<chunk encoding='txt'><![CDATA[\n<sdf version ='1.3'>\n<world name='default'>\n  <model name='ground_plane'>\n    <static>1</static>\n    <link name='link'>\n      <collision name='collision'>\n        <geometry>\n          <plane>\n            <normal>0.000000 0.000000 1.000000</normal>\n            <size>100.000000 100.000000</size>\n          </plane>\n        </geometry>\n        <surface>\n          <friction>\n            <ode>\n              <mu>100.000000</mu>\n              <mu2>50.000000</mu2>\n            </ode>\n          </friction>\n          <bounce/>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='visual'>\n        <cast_shadows>0</cast_shadows>\n        <geometry>\n          <plane>\n            <normal>0.000000 0.000000 1.000000</normal>\n            <size>100.000000 100.000000</size>\n          </plane>\n        </geometry>\n        <material>\n          <script>\n            <uri>file://media/materials/scripts/gazebo.material</uri>\n            <name>Gazebo/Grey</name>\n          </script>\n        </material>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <self_collide>0</self_collide>\n      <kinematic>0</kinematic>\n      <gravity>1</gravity>\n    </link>\n  </model>\n  <light name='sun' type='directional'>\n    <cast_shadows>1</cast_shadows>\n    <pose>0.000000 0.000000 10.000000 0.000000 0.000000 0.000000</pose>\n    <diffuse>0.800000 0.800000 0.800000 1.000000</diffuse>\n    <specular>0.100000 0.100000 0.100000 1.000000</specular>\n    <attenuation>\n      <range>1000.000000</range>\n      <constant>0.900000</constant>\n      <linear>0.010000</linear>\n      <quadratic>0.001000</quadratic>\n    </attenuation>\n    <direction>-0.500000 0.500000 -1.000000</direction>\n  </light>\n  <model name='pr2'>\n    <static>0</static>\n    <link name='base_footprint'>\n      <self_collide>0</self_collide>\n      <inertial>\n        <mass>118.001000</mass>\n        <pose>-0.062421 0.000000 0.201365 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>8.431730</ixx>\n          <ixy>-0.009720</ixy>\n          <ixz>1.901570</ixz>\n          <iyy>8.533050</iyy>\n          <iyz>-0.007380</iyz>\n          <izz>3.787470</izz>\n        </inertia>\n      </inertial>\n      <collision name='base_footprint_geom'>\n        <pose>0.000000 0.000000 0.071000 0.000000 0.000000 0.000000</pose>\n        <geometry>\n          <box>\n            <size>0.001000 0.001000 0.001000</size>\n          </box>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='base_footprint_geom_visual'>\n        <geometry>\n          <box>\n            <size>0.010000 0.010000 0.010000</size>\n          </box>\n        </geometry>\n      </visual>\n      <collision name='base_footprint_geom_base_bellow_link'>\n        <pose>-0.290000 0.000000 0.851000 0.000000 0.000000 0.000000</pose>\n        <geometry>\n          <box>\n            <size>0.050000 0.370000 0.300000</size>\n          </box>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='base_footprint_geom_base_bellow_link_visual'>\n        <pose>-0.290000 0.000000 0.851000 0.000000 0.000000 0.000000</pose>\n        <geometry>\n          <box>\n            <size>0.050000 0.370000 0.300000</size>\n          </box>\n        </geometry>\n      </visual>\n      <collision name='base_footprint_geom_base_link'>\n        <pose>0.000000 0.000000 0.051000 0.000000 0.000000 0.000000</pose>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/base_v0/base_L.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='base_footprint_geom_base_link_visual'>\n        <pose>0.000000 0.000000 0.051000 0.000000 0.000000 0.000000</pose>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/base_v0/base.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <sensor name='base_contact_sensor' type='contact'>\n        <update_rate>100.000000</update_rate>\n        <always_on>0</always_on>\n        <visualize>0</visualize>\n        <contact>\n          <collision>base_footprint_geom_base_link</collision>\n          <topic>__default_topic__</topic>\n        </contact>\n        <plugin name='gazebo_contact' filename='libContactPlugin.so'/>\n      </sensor>\n      <sensor name='base_laser' type='ray'>\n        <always_on>0</always_on>\n        <visualize>0</visualize>\n        <update_rate>20.000000</update_rate>\n        <pose>0.275000 0.000000 0.303000 0.000000 0.000000 0.000000</pose>\n        <ray>\n          <scan>\n            <horizontal>\n              <samples>640</samples>\n              <resolution>1.000000</resolution>\n              <min_angle>-2.268900</min_angle>\n              <max_angle>2.268900</max_angle>\n            </horizontal>\n          </scan>\n          <range>\n            <min>0.080000</min>\n            <max>10.000000</max>\n            <resolution>0.010000</resolution>\n          </range>\n        </ray>\n        <plugin name='laser' filename='libRayPlugin.so'/>\n      </sensor>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n      <gravity>1</gravity>\n    </link>\n    <link name='bl_caster_rotation_link'>\n      <self_collide>0</self_collide>\n      <pose>-0.224600 0.224600 0.079200 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>3.473080</mass>\n        <pose>0.000000 0.000000 0.070000 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.012412</ixx>\n          <ixy>-0.000712</ixy>\n          <ixz>0.000503</ixz>\n          <iyy>0.015218</iyy>\n          <iyz>-0.000004</iyz>\n          <izz>0.011764</izz>\n        </inertia>\n      </inertial>\n      <collision name='bl_caster_rotation_link_geom'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/base_v0/caster_L.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='bl_caster_rotation_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/base_v0/caster.stl</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n      <gravity>1</gravity>\n    </link>\n    <link name='bl_caster_l_wheel_link'>\n      <self_collide>0</self_collide>\n      <pose>-0.224600 0.273600 0.079200 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.440360</mass>\n        <inertia>\n          <ixx>0.012412</ixx>\n          <ixy>-0.000712</ixy>\n          <ixz>0.000503</ixz>\n          <iyy>0.015218</iyy>\n          <iyz>-0.000004</iyz>\n          <izz>0.011764</izz>\n        </inertia>\n      </inertial>\n      <collision name='bl_caster_l_wheel_link_geom'>\n        <pose>0.000000 0.000000 0.000000 1.570800 0.000000 0.000000</pose>\n        <geometry>\n          <cylinder>\n            <radius>0.074792</radius>\n            <length>0.034000</length>\n          </cylinder>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='bl_caster_l_wheel_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/base_v0/wheel.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n      <gravity>1</gravity>\n    </link>\n    <link name='bl_caster_r_wheel_link'>\n      <self_collide>0</self_collide>\n      <pose>-0.224600 0.175600 0.079200 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.440360</mass>\n        <inertia>\n          <ixx>0.012412</ixx>\n          <ixy>0.000712</ixy>\n          <ixz>0.000503</ixz>\n          <iyy>0.015218</iyy>\n          <iyz>0.000004</iyz>\n          <izz>0.011764</izz>\n        </inertia>\n      </inertial>\n      <collision name='bl_caster_r_wheel_link_geom'>\n        <pose>0.000000 0.000000 0.000000 1.570800 0.000000 0.000000</pose>\n        <geometry>\n          <cylinder>\n            <radius>0.074792</radius>\n            <length>0.034000</length>\n          </cylinder>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='bl_caster_r_wheel_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/base_v0/wheel.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n      <gravity>1</gravity>\n    </link>\n    <link name='br_caster_rotation_link'>\n      <self_collide>0</self_collide>\n      <pose>-0.224600 -0.224600 0.079200 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>3.473080</mass>\n        <pose>0.000000 0.000000 0.070000 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.012412</ixx>\n          <ixy>-0.000712</ixy>\n          <ixz>0.000503</ixz>\n          <iyy>0.015218</iyy>\n          <iyz>-0.000004</iyz>\n          <izz>0.011764</izz>\n        </inertia>\n      </inertial>\n      <collision name='br_caster_rotation_link_geom'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/base_v0/caster_L.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='br_caster_rotation_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/base_v0/caster.stl</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n      <gravity>1</gravity>\n    </link>\n    <link name='br_caster_l_wheel_link'>\n      <self_collide>0</self_collide>\n      <pose>-0.224600 -0.175600 0.079200 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.440360</mass>\n        <inertia>\n          <ixx>0.012412</ixx>\n          <ixy>-0.000712</ixy>\n          <ixz>0.000503</ixz>\n          <iyy>0.015218</iyy>\n          <iyz>-0.000004</iyz>\n          <izz>0.011764</izz>\n        </inertia>\n      </inertial>\n      <collision name='br_caster_l_wheel_link_geom'>\n        <pose>0.000000 0.000000 0.000000 1.570800 0.000000 0.000000</pose>\n        <geometry>\n          <cylinder>\n            <radius>0.074792</radius>\n            <length>0.034000</length>\n          </cylinder>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='br_caster_l_wheel_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/base_v0/wheel.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n      <gravity>1</gravity>\n    </link>\n    <link name='br_caster_r_wheel_link'>\n      <self_collide>0</self_collide>\n      <pose>-0.224600 -0.273600 0.079200 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.440360</mass>\n        <inertia>\n          <ixx>0.012412</ixx>\n          <ixy>-0.000712</ixy>\n          <ixz>0.000503</ixz>\n          <iyy>0.015218</iyy>\n          <iyz>-0.000004</iyz>\n          <izz>0.011764</izz>\n        </inertia>\n      </inertial>\n      <collision name='br_caster_r_wheel_link_geom'>\n        <pose>0.000000 0.000000 0.000000 1.570800 0.000000 0.000000</pose>\n        <geometry>\n          <cylinder>\n            <radius>0.074792</radius>\n            <length>0.034000</length>\n          </cylinder>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='br_caster_r_wheel_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/base_v0/wheel.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n      <gravity>1</gravity>\n    </link>\n    <link name='fl_caster_rotation_link'>\n      <self_collide>0</self_collide>\n      <pose>0.224600 0.224600 0.079200 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>3.473080</mass>\n        <pose>0.000000 0.000000 0.070000 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.012412</ixx>\n          <ixy>-0.000712</ixy>\n          <ixz>0.000503</ixz>\n          <iyy>0.015218</iyy>\n          <iyz>-0.000004</iyz>\n          <izz>0.011764</izz>\n        </inertia>\n      </inertial>\n      <collision name='fl_caster_rotation_link_geom'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/base_v0/caster_L.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='fl_caster_rotation_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/base_v0/caster.stl</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n      <gravity>1</gravity>\n    </link>\n    <link name='fl_caster_l_wheel_link'>\n      <self_collide>0</self_collide>\n      <pose>0.224600 0.273600 0.079200 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.440360</mass>\n        <inertia>\n          <ixx>0.012412</ixx>\n          <ixy>-0.000712</ixy>\n          <ixz>0.000503</ixz>\n          <iyy>0.015218</iyy>\n          <iyz>-0.000004</iyz>\n          <izz>0.011764</izz>\n        </inertia>\n      </inertial>\n      <collision name='fl_caster_l_wheel_link_geom'>\n        <pose>0.000000 0.000000 0.000000 1.570800 0.000000 0.000000</pose>\n        <geometry>\n          <cylinder>\n            <radius>0.074792</radius>\n            <length>0.034000</length>\n          </cylinder>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='fl_caster_l_wheel_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/base_v0/wheel.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n      <gravity>1</gravity>\n    </link>\n    <link name='fl_caster_r_wheel_link'>\n      <self_collide>0</self_collide>\n      <pose>0.224600 0.175600 0.079200 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.440360</mass>\n        <inertia>\n          <ixx>0.012412</ixx>\n          <ixy>-0.000712</ixy>\n          <ixz>0.000503</ixz>\n          <iyy>0.015218</iyy>\n          <iyz>-0.000004</iyz>\n          <izz>0.011764</izz>\n        </inertia>\n      </inertial>\n      <collision name='fl_caster_r_wheel_link_geom'>\n        <pose>0.000000 0.000000 0.000000 1.570800 0.000000 0.000000</pose>\n        <geometry>\n          <cylinder>\n            <radius>0.074792</radius>\n            <length>0.034000</length>\n          </cylinder>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='fl_caster_r_wheel_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/base_v0/wheel.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n      <gravity>1</gravity>\n    </link>\n    <link name='fr_caster_rotation_link'>\n      <self_collide>0</self_collide>\n      <pose>0.224600 -0.224600 0.079200 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>3.473080</mass>\n        <pose>0.000000 0.000000 0.070000 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.012412</ixx>\n          <ixy>-0.000712</ixy>\n          <ixz>0.000503</ixz>\n          <iyy>0.015218</iyy>\n          <iyz>-0.000004</iyz>\n          <izz>0.011764</izz>\n        </inertia>\n      </inertial>\n      <collision name='fr_caster_rotation_link_geom'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/base_v0/caster_L.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='fr_caster_rotation_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/base_v0/caster.stl</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n      <gravity>1</gravity>\n    </link>\n    <link name='fr_caster_l_wheel_link'>\n      <self_collide>0</self_collide>\n      <pose>0.224600 -0.175600 0.079200 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.440360</mass>\n        <inertia>\n          <ixx>0.012412</ixx>\n          <ixy>-0.000712</ixy>\n          <ixz>0.000503</ixz>\n          <iyy>0.015218</iyy>\n          <iyz>-0.000004</iyz>\n          <izz>0.011764</izz>\n        </inertia>\n      </inertial>\n      <collision name='fr_caster_l_wheel_link_geom'>\n        <pose>0.000000 0.000000 0.000000 1.570800 0.000000 0.000000</pose>\n        <geometry>\n          <cylinder>\n            <radius>0.074792</radius>\n            <length>0.034000</length>\n          </cylinder>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='fr_caster_l_wheel_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/base_v0/wheel.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n      <gravity>1</gravity>\n    </link>\n    <link name='fr_caster_r_wheel_link'>\n      <self_collide>0</self_collide>\n      <pose>0.224600 -0.273600 0.079200 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.440360</mass>\n        <inertia>\n          <ixx>0.012412</ixx>\n          <ixy>-0.000712</ixy>\n          <ixz>0.000503</ixz>\n          <iyy>0.015218</iyy>\n          <iyz>-0.000004</iyz>\n          <izz>0.011764</izz>\n        </inertia>\n      </inertial>\n      <collision name='fr_caster_r_wheel_link_geom'>\n        <pose>0.000000 0.000000 0.000000 1.570800 0.000000 0.000000</pose>\n        <geometry>\n          <cylinder>\n            <radius>0.074792</radius>\n            <length>0.034000</length>\n          </cylinder>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='fr_caster_r_wheel_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/base_v0/wheel.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n      <gravity>1</gravity>\n    </link>\n    <link name='torso_lift_link'>\n      <self_collide>0</self_collide>\n      <pose>-0.050000 0.000000 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>36.449000</mass>\n        <pose>-0.099499 -0.000004 -0.086764 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>2.792330</ixx>\n          <ixy>0.004280</ixy>\n          <ixz>-0.160631</ixz>\n          <iyy>2.521060</iyy>\n          <iyz>0.029689</iyz>\n          <izz>0.536551</izz>\n        </inertia>\n      </inertial>\n      <collision name='torso_lift_link_geom'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/torso_v0/torso_lift_L.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='torso_lift_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/torso_v0/torso_lift.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <sensor name='torso_lift_contact_sensor' type='contact'>\n        <update_rate>100.000000</update_rate>\n        <always_on>0</always_on>\n        <visualize>0</visualize>\n        <contact>\n          <collision>torso_lift_link_geom</collision>\n          <topic>__default_topic__</topic>\n        </contact>\n      </sensor>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n      <gravity>1</gravity>\n    </link>\n    <link name='head_pan_link'>\n      <self_collide>0</self_collide>\n      <pose>-0.067070 0.000000 1.172130 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>6.339000</mass>\n        <pose>0.010907 0.031693 0.090507 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.032498</ixx>\n          <ixy>0.000636</ixy>\n          <ixz>0.002585</ixz>\n          <iyy>0.046546</iyy>\n          <iyz>-0.002453</iyz>\n          <izz>0.057653</izz>\n        </inertia>\n      </inertial>\n      <collision name='head_pan_link_geom'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/head_v0/head_pan_L.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='head_pan_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/head_v0/head_pan.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n      <gravity>1</gravity>\n    </link>\n    <link name='head_tilt_link'>\n      <projector name='projector_wg6802418_projector_wg6802418'>\n        <texture>stereo_projection_pattern_high_res_red.png</texture>\n        <fov>0.959931</fov>\n        <near_clip>0.100000</near_clip>\n        <far_clip>10.000000</far_clip>\n        <pose>0.023200 0.110000 0.119100 0.000000 -1.570793 0.000000</pose>\n      </projector>\n      <self_collide>0</self_collide>\n      <pose>0.000930 0.000000 1.172130 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>5.319000</mass>\n        <pose>-0.005151 -0.014635 0.072819 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.126134</ixx>\n          <ixy>0.000237</ixy>\n          <ixz>0.011881</ixz>\n          <iyy>0.165102</iyy>\n          <iyz>0.001606</iyz>\n          <izz>0.166947</izz>\n        </inertia>\n      </inertial>\n      <collision name='head_tilt_link_geom'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/head_v0/head_tilt_L.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='head_tilt_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/head_v0/head_tilt.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <collision name='head_tilt_link_geom_head_mount_kinect_ir_link'>\n        <pose>-0.147067 0.012500 0.291953 0.000000 0.000000 0.000000</pose>\n        <geometry>\n          <sphere>\n            <radius>0.000500</radius>\n          </sphere>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='head_tilt_link_geom_head_mount_kinect_ir_link_visual'>\n        <pose>-0.147067 0.012500 0.291953 0.000000 0.000000 0.000000</pose>\n        <geometry>\n          <sphere>\n            <radius>0.000250</radius>\n          </sphere>\n        </geometry>\n        <material>\n          <script>\n            <uri>__default__</uri>\n            <name>__default__</name>\n          </script>\n        </material>\n      </visual>\n      <collision name='head_tilt_link_geom_head_mount_kinect_rgb_link'>\n        <pose>-0.147067 0.017500 0.291953 0.000000 0.000000 0.000000</pose>\n        <geometry>\n          <sphere>\n            <radius>0.000500</radius>\n          </sphere>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='head_tilt_link_geom_head_mount_kinect_rgb_link_visual'>\n        <pose>-0.147067 0.017500 0.291953 0.000000 0.000000 0.000000</pose>\n        <geometry>\n          <sphere>\n            <radius>0.000250</radius>\n          </sphere>\n        </geometry>\n        <material>\n          <script>\n            <uri>__default__</uri>\n            <name>__default__</name>\n          </script>\n        </material>\n      </visual>\n      <collision name='head_tilt_link_geom_head_mount_link'>\n        <pose>-0.114800 0.000000 0.155500 0.000000 0.000000 0.000000</pose>\n        <geometry>\n          <sphere>\n            <radius>0.000500</radius>\n          </sphere>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='head_tilt_link_geom_head_mount_link_visual'>\n        <pose>-0.114800 0.000000 0.155500 0.000000 0.000000 0.000000</pose>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/sensors/kinect_prosilica_v0/115x100_swept_back--coarse.STL</uri>\n            <scale>0.001000 0.001000 0.001000</scale>\n          </mesh>\n        </geometry>\n      </visual>\n      <collision name='head_tilt_link_geom_head_mount_prosilica_link'>\n        <pose>-0.161257 0.012500 0.244421 0.000000 0.000000 0.000000</pose>\n        <geometry>\n          <sphere>\n            <radius>0.000500</radius>\n          </sphere>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='head_tilt_link_geom_head_mount_prosilica_link_visual'>\n        <pose>-0.161257 0.012500 0.244421 0.000000 0.000000 0.000000</pose>\n        <geometry>\n          <sphere>\n            <radius>0.000250</radius>\n          </sphere>\n        </geometry>\n        <material>\n          <script>\n            <uri>__default__</uri>\n            <name>__default__</name>\n          </script>\n        </material>\n      </visual>\n      <collision name='head_tilt_link_geom_head_plate_frame'>\n        <pose>0.023200 0.000000 0.064500 0.000000 0.000000 0.000000</pose>\n        <geometry>\n          <box>\n            <size>0.010000 0.010000 0.010000</size>\n          </box>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='head_tilt_link_geom_head_plate_frame_visual'>\n        <pose>0.023200 0.000000 0.064500 0.000000 0.000000 0.000000</pose>\n        <geometry>\n          <box>\n            <size>0.010000 0.010000 0.010000</size>\n          </box>\n        </geometry>\n        <material>\n          <script>\n            <uri>__default__</uri>\n            <name>__default__</name>\n          </script>\n        </material>\n      </visual>\n      <sensor name='head_mount_sensor' type='camera'>\n        <always_on>0</always_on>\n        <visualize>0</visualize>\n        <update_rate>1.000000</update_rate>\n        <pose>-0.147067 0.012500 0.291953 0.000000 0.000000 0.000000</pose>\n        <camera name='__default__'>\n          <horizontal_fov>0.994838</horizontal_fov>\n          <image>\n            <width>640</width>\n            <height>480</height>\n            <format>L8</format>\n          </image>\n          <clip>\n            <near>0.010000</near>\n            <far>5.000000</far>\n          </clip>\n        </camera>\n      </sensor>\n      <sensor name='head_mount_prosilica_link_sensor' type='camera'>\n        <update_rate>1.000000</update_rate>\n        <pose>-0.161257 0.012500 0.244421 0.000000 0.000000 0.000000</pose>\n        <always_on>0</always_on>\n        <visualize>0</visualize>\n        <camera name='__default__'>\n          <horizontal_fov>1.120501</horizontal_fov>\n          <image>\n            <width>320</width>\n            <height>240</height>\n            <format>R8G8B8</format>\n          </image>\n          <clip>\n            <near>0.100000</near>\n            <far>100.000000</far>\n          </clip>\n        </camera>\n      </sensor>\n      <sensor name='head_mount_prosilica_link_sim_pcd_sensor' type='camera'>\n        <update_rate>1.000000</update_rate>\n        <pose>-0.161257 0.012500 0.244421 0.000000 0.000000 0.000000</pose>\n        <always_on>0</always_on>\n        <visualize>0</visualize>\n        <camera name='__default__'>\n          <horizontal_fov>1.120501</horizontal_fov>\n          <image>\n            <width>320</width>\n            <height>240</height>\n            <format>R8G8B8</format>\n          </image>\n          <clip>\n            <near>0.100000</near>\n            <far>100.000000</far>\n          </clip>\n        </camera>\n      </sensor>\n      <sensor name='narrow_stereo_gazebo_l_stereo_camera_sensor' type='camera'>\n        <always_on>0</always_on>\n        <visualize>0</visualize>\n        <update_rate>25.000000</update_rate>\n        <pose>0.068200 0.060000 0.114600 0.000000 0.000000 0.000000</pose>\n        <camera name='__default__'>\n          <horizontal_fov>0.785398</horizontal_fov>\n          <image>\n            <width>640</width>\n            <height>480</height>\n            <format>L8</format>\n          </image>\n          <clip>\n            <near>0.100000</near>\n            <far>100.000000</far>\n          </clip>\n        </camera>\n      </sensor>\n      <sensor name='narrow_stereo_gazebo_r_stereo_camera_sensor' type='camera'>\n        <always_on>0</always_on>\n        <visualize>0</visualize>\n        <update_rate>25.000000</update_rate>\n        <pose>0.068200 -0.030000 0.114600 0.000000 0.000000 0.000000</pose>\n        <camera name='__default__'>\n          <horizontal_fov>0.785398</horizontal_fov>\n          <image>\n            <width>640</width>\n            <height>480</height>\n            <format>L8</format>\n          </image>\n          <clip>\n            <near>0.100000</near>\n            <far>100.000000</far>\n          </clip>\n        </camera>\n      </sensor>\n      <sensor name='wide_stereo_gazebo_l_stereo_camera_sensor' type='camera'>\n        <update_rate>25.000000</update_rate>\n        <pose>0.068200 0.030000 0.114600 0.000000 0.000000 0.000000</pose>\n        <always_on>0</always_on>\n        <visualize>0</visualize>\n        <camera name='__default__'>\n          <horizontal_fov>1.570796</horizontal_fov>\n          <image>\n            <width>640</width>\n            <height>480</height>\n            <format>BAYER_BGGR8</format>\n          </image>\n          <clip>\n            <near>0.100000</near>\n            <far>100.000000</far>\n          </clip>\n        </camera>\n      </sensor>\n      <sensor name='wide_stereo_gazebo_r_stereo_camera_sensor' type='camera'>\n        <update_rate>25.000000</update_rate>\n        <pose>0.068200 -0.060000 0.114600 0.000000 0.000000 0.000000</pose>\n        <always_on>0</always_on>\n        <visualize>0</visualize>\n        <camera name='__default__'>\n          <horizontal_fov>1.570796</horizontal_fov>\n          <image>\n            <width>640</width>\n            <height>480</height>\n            <format>BAYER_BGGR8</format>\n          </image>\n          <clip>\n            <near>0.100000</near>\n            <far>100.000000</far>\n          </clip>\n        </camera>\n      </sensor>\n      <sensor name='high_def_sensor' type='camera'>\n        <update_rate>20.000000</update_rate>\n        <pose>0.069657 -0.110000 0.119100 0.000000 0.000000 0.000000</pose>\n        <always_on>0</always_on>\n        <visualize>0</visualize>\n        <camera name='__default__'>\n          <horizontal_fov>0.785398</horizontal_fov>\n          <image>\n            <width>2448</width>\n            <height>2050</height>\n            <format>R8G8B8</format>\n          </image>\n          <clip>\n            <near>0.100000</near>\n            <far>100.000000</far>\n          </clip>\n        </camera>\n      </sensor>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n      <gravity>1</gravity>\n    </link>\n    <link name='l_shoulder_pan_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>-0.050000 0.188000 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>25.799300</mass>\n        <pose>-0.001201 0.024513 -0.098231 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.866179</ixx>\n          <ixy>-0.060865</ixy>\n          <ixz>-0.121181</ixz>\n          <iyy>0.874217</iyy>\n          <iyz>-0.058866</iyz>\n          <izz>0.273538</izz>\n        </inertia>\n      </inertial>\n      <collision name='l_shoulder_pan_link_geom'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/shoulder_v0/shoulder_pan.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='l_shoulder_pan_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/shoulder_v0/shoulder_pan.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='l_shoulder_lift_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.050000 0.188000 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>2.749880</mass>\n        <pose>0.021950 -0.026640 -0.031270 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.021056</ixx>\n          <ixy>0.004967</ixy>\n          <ixz>-0.001948</ixz>\n          <iyy>0.021272</iyy>\n          <iyz>0.001104</iyz>\n          <izz>0.019758</izz>\n        </inertia>\n      </inertial>\n      <collision name='l_shoulder_lift_link_geom'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/shoulder_v0/shoulder_lift.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='l_shoulder_lift_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/shoulder_v0/shoulder_lift.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='l_upper_arm_roll_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.050000 0.188000 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>6.117690</mass>\n        <pose>0.210551 0.016309 -0.000561 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.025306</ixx>\n          <ixy>-0.003393</ixy>\n          <ixz>0.000608</ixz>\n          <iyy>0.084737</iyy>\n          <iyz>-0.000200</iyz>\n          <izz>0.086016</izz>\n        </inertia>\n      </inertial>\n      <collision name='l_upper_arm_roll_link_geom'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/shoulder_v0/upper_arm_roll_L.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='l_upper_arm_roll_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/shoulder_v0/upper_arm_roll.stl</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <collision name='l_upper_arm_roll_link_geom_l_upper_arm_link'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/upper_arm_v0/upper_arm.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='l_upper_arm_roll_link_geom_l_upper_arm_link_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/upper_arm_v0/upper_arm.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='l_elbow_flex_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.450000 0.188000 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>1.903270</mass>\n        <pose>0.010140 0.000320 -0.012110 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.003465</ixx>\n          <ixy>0.000041</ixy>\n          <ixz>0.000432</ixz>\n          <iyy>0.004416</iyy>\n          <iyz>-0.000040</iyz>\n          <izz>0.003592</izz>\n        </inertia>\n      </inertial>\n      <collision name='l_elbow_flex_link_geom'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/upper_arm_v0/elbow_flex.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='l_elbow_flex_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/upper_arm_v0/elbow_flex.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='l_forearm_roll_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.450000 0.188000 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>2.689680</mass>\n        <pose>0.180727 -0.000163 -0.008583 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.014668</ixx>\n          <ixy>0.000052</ixy>\n          <ixz>0.000656</ixz>\n          <iyy>0.026279</iyy>\n          <iyz>-0.000013</iyz>\n          <izz>0.027775</izz>\n        </inertia>\n      </inertial>\n      <collision name='l_forearm_roll_link_geom'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/upper_arm_v0/forearm_roll_L.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='l_forearm_roll_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/upper_arm_v0/forearm_roll.stl</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <collision name='l_forearm_roll_link_geom_l_forearm_link'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/forearm_v0/forearm.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='l_forearm_roll_link_geom_l_forearm_link_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/forearm_v0/forearm.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <sensor name='l_forearm_cam_sensor' type='camera'>\n        <update_rate>25.000000</update_rate>\n        <pose>0.135000 0.000000 0.044000 -1.570800 -0.562869 0.000000</pose>\n        <always_on>0</always_on>\n        <visualize>0</visualize>\n        <camera name='__default__'>\n          <horizontal_fov>1.570796</horizontal_fov>\n          <image>\n            <width>640</width>\n            <height>480</height>\n            <format>R8G8B8</format>\n          </image>\n          <clip>\n            <near>0.100000</near>\n            <far>100.000000</far>\n          </clip>\n        </camera>\n      </sensor>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='l_wrist_flex_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.771000 0.188000 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.614020</mass>\n        <pose>-0.001570 0.000000 -0.000750 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.000652</ixx>\n          <ixy>0.000000</ixy>\n          <ixz>0.000003</ixz>\n          <iyy>0.000198</iyy>\n          <iyz>0.000000</iyz>\n          <izz>0.000645</izz>\n        </inertia>\n      </inertial>\n      <collision name='l_wrist_flex_link_geom'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/forearm_v0/wrist_flex.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='l_wrist_flex_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/forearm_v0/wrist_flex.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='l_wrist_roll_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.771000 0.188000 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.681070</mass>\n        <pose>0.056408 0.000451 -0.001014 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.011352</ixx>\n          <ixy>-0.000016</ixy>\n          <ixz>-0.000001</ixz>\n          <iyy>0.011677</iyy>\n          <iyz>-0.000001</iyz>\n          <izz>0.011866</izz>\n        </inertia>\n      </inertial>\n      <collision name='l_wrist_roll_link_geom'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/forearm_v0/wrist_roll_L.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='l_wrist_roll_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/forearm_v0/wrist_roll.stl</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <collision name='l_wrist_roll_link_geom_l_gripper_motor_accelerometer_link'>\n        <geometry>\n          <box>\n            <size>0.001000 0.001000 0.001000</size>\n          </box>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='l_wrist_roll_link_geom_l_gripper_motor_accelerometer_link_visual'>\n        <geometry>\n          <box>\n            <size>0.001000 0.001000 0.001000</size>\n          </box>\n        </geometry>\n      </visual>\n      <collision name='l_wrist_roll_link_geom_l_gripper_palm_link'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/gripper_v0/gripper_palm.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='l_wrist_roll_link_geom_l_gripper_palm_link_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/gripper_v0/gripper_palm.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='l_gripper_l_finger_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.847910 0.198000 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.171260</mass>\n        <pose>0.035980 0.017300 -0.001640 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.000078</ixx>\n          <ixy>0.000001</ixy>\n          <ixz>-0.000010</ixz>\n          <iyy>0.000197</iyy>\n          <iyz>-0.000003</iyz>\n          <izz>0.000181</izz>\n        </inertia>\n      </inertial>\n      <collision name='l_gripper_l_finger_link_geom'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/gripper_v0/l_finger.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <friction>\n            <ode>\n              <mu>500.000000</mu>\n              <mu2>500.000000</mu2>\n              <slip1>0.000000</slip1>\n              <slip2>0.000000</slip2>\n            </ode>\n          </friction>\n          <contact>\n            <ode>\n              <kp>1000000.000000</kp>\n              <kd>1.000000</kd>\n              <max_vel>100.000000</max_vel>\n              <min_depth>0.000000</min_depth>\n            </ode>\n          </contact>\n          <bounce/>\n        </surface>\n      </collision>\n      <visual name='l_gripper_l_finger_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/gripper_v0/l_finger.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='l_gripper_l_finger_tip_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.939280 0.202950 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.044190</mass>\n        <pose>0.004230 0.002840 0.000000 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.000008</ixx>\n          <ixy>0.000006</ixy>\n          <ixz>0.000000</ixz>\n          <iyy>0.000010</iyy>\n          <iyz>0.000000</iyz>\n          <izz>0.000015</izz>\n        </inertia>\n      </inertial>\n      <collision name='l_gripper_l_finger_tip_link_geom'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/gripper_v0/l_finger_tip.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <friction>\n            <ode>\n              <mu>500.000000</mu>\n              <mu2>500.000000</mu2>\n              <slip1>0.000000</slip1>\n              <slip2>0.000000</slip2>\n            </ode>\n          </friction>\n          <contact>\n            <ode>\n              <kp>10000000.000000</kp>\n              <kd>1.000000</kd>\n              <max_vel>100.000000</max_vel>\n              <min_depth>0.000000</min_depth>\n            </ode>\n          </contact>\n          <bounce/>\n        </surface>\n      </collision>\n      <visual name='l_gripper_l_finger_tip_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/gripper_v0/l_finger_tip.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <sensor name='l_gripper_l_finger_tip_contact_sensor' type='contact'>\n        <update_rate>100.000000</update_rate>\n        <always_on>0</always_on>\n        <visualize>0</visualize>\n        <contact>\n          <collision>l_gripper_l_finger_tip_link_geom</collision>\n          <topic>__default_topic__</topic>\n        </contact>\n      </sensor>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='l_gripper_motor_slider_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.939280 0.188000 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.010000</mass>\n        <inertia>\n          <ixx>0.001000</ixx>\n          <ixy>0.000000</ixy>\n          <ixz>0.000000</ixz>\n          <iyy>0.001000</iyy>\n          <iyz>0.000000</iyz>\n          <izz>0.001000</izz>\n        </inertia>\n      </inertial>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='l_gripper_motor_screw_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.939280 0.188000 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.010000</mass>\n        <inertia>\n          <ixx>0.000100</ixx>\n          <ixy>0.000000</ixy>\n          <ixz>0.000000</ixz>\n          <iyy>0.000100</iyy>\n          <iyz>0.000000</iyz>\n          <izz>0.000100</izz>\n        </inertia>\n      </inertial>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='l_gripper_r_finger_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.847910 0.178000 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.173890</mass>\n        <pose>0.035760 -0.017360 -0.000950 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.000077</ixx>\n          <ixy>-0.000002</ixy>\n          <ixz>-0.000008</ixz>\n          <iyy>0.000198</iyy>\n          <iyz>0.000002</iyz>\n          <izz>0.000181</izz>\n        </inertia>\n      </inertial>\n      <collision name='l_gripper_r_finger_link_geom'>\n        <pose>0.000000 0.000000 0.000000 -3.141590 0.000000 0.000000</pose>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/gripper_v0/l_finger.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <friction>\n            <ode>\n              <mu>500.000000</mu>\n              <mu2>500.000000</mu2>\n              <slip1>0.000000</slip1>\n              <slip2>0.000000</slip2>\n            </ode>\n          </friction>\n          <contact>\n            <ode>\n              <kp>1000000.000000</kp>\n              <kd>1.000000</kd>\n              <max_vel>100.000000</max_vel>\n              <min_depth>0.000000</min_depth>\n            </ode>\n          </contact>\n          <bounce/>\n        </surface>\n      </collision>\n      <visual name='l_gripper_r_finger_link_geom_visual'>\n        <pose>0.000000 0.000000 0.000000 -3.141590 0.000000 0.000000</pose>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/gripper_v0/l_finger.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='l_gripper_r_finger_tip_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.939280 0.173050 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.044190</mass>\n        <pose>0.004230 -0.002840 0.000000 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.000008</ixx>\n          <ixy>-0.000006</ixy>\n          <ixz>0.000000</ixz>\n          <iyy>0.000010</iyy>\n          <iyz>0.000000</iyz>\n          <izz>0.000015</izz>\n        </inertia>\n      </inertial>\n      <collision name='l_gripper_r_finger_tip_link_geom'>\n        <pose>0.000000 0.000000 0.000000 -3.141590 0.000000 0.000000</pose>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/gripper_v0/l_finger_tip.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <friction>\n            <ode>\n              <mu>500.000000</mu>\n              <mu2>500.000000</mu2>\n              <slip1>0.000000</slip1>\n              <slip2>0.000000</slip2>\n            </ode>\n          </friction>\n          <contact>\n            <ode>\n              <kp>10000000.000000</kp>\n              <kd>1.000000</kd>\n              <max_vel>100.000000</max_vel>\n              <min_depth>0.000000</min_depth>\n            </ode>\n          </contact>\n          <bounce/>\n        </surface>\n      </collision>\n      <visual name='l_gripper_r_finger_tip_link_geom_visual'>\n        <pose>0.000000 0.000000 0.000000 -3.141590 0.000000 0.000000</pose>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/gripper_v0/l_finger_tip.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <sensor name='l_gripper_r_finger_tip_contact_sensor' type='contact'>\n        <update_rate>100.000000</update_rate>\n        <always_on>0</always_on>\n        <visualize>0</visualize>\n        <contact>\n          <collision>l_gripper_r_finger_tip_link_geom</collision>\n          <topic>__default_topic__</topic>\n        </contact>\n      </sensor>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='laser_tilt_mount_link'>\n      <self_collide>0</self_collide>\n      <pose>0.048930 0.000000 1.017680 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.592000</mass>\n        <pose>-0.001134 0.001667 -0.007067 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.001296</ixx>\n          <ixy>0.000023</ixy>\n          <ixz>0.000037</ixz>\n          <iyy>0.001086</iyy>\n          <iyz>0.000035</iyz>\n          <izz>0.000895</izz>\n        </inertia>\n      </inertial>\n      <collision name='laser_tilt_mount_link_geom'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/tilting_laser_v0/tilting_hokuyo_L.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <friction>\n            <ode>\n              <mu>0.000000</mu>\n              <mu2>0.000000</mu2>\n              <slip1>0.000000</slip1>\n              <slip2>0.000000</slip2>\n            </ode>\n          </friction>\n          <contact>\n            <ode>\n              <kp>1000000000000.000000</kp>\n              <kd>10000.000000</kd>\n              <max_vel>100.000000</max_vel>\n              <min_depth>0.000000</min_depth>\n            </ode>\n          </contact>\n          <bounce/>\n        </surface>\n      </collision>\n      <visual name='laser_tilt_mount_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/tilting_laser_v0/tilting_hokuyo.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <sensor name='laser_tilt' type='ray'>\n        <update_rate>40.000000</update_rate>\n        <pose>0.000000 0.000000 0.030000 0.000000 0.000000 0.000000</pose>\n        <always_on>0</always_on>\n        <visualize>0</visualize>\n        <ray>\n          <scan>\n            <horizontal>\n              <samples>640</samples>\n              <resolution>1.000000</resolution>\n              <min_angle>-1.396263</min_angle>\n              <max_angle>1.396263</max_angle>\n            </horizontal>\n          </scan>\n          <range>\n            <min>0.080000</min>\n            <max>10.000000</max>\n            <resolution>0.010000</resolution>\n          </range>\n        </ray>\n      </sensor>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n      <gravity>1</gravity>\n    </link>\n    <link name='r_shoulder_pan_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>-0.050000 -0.188000 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>25.799300</mass>\n        <pose>-0.001201 0.024513 -0.098231 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.866179</ixx>\n          <ixy>-0.060865</ixy>\n          <ixz>-0.121181</ixz>\n          <iyy>0.874217</iyy>\n          <iyz>-0.058866</iyz>\n          <izz>0.273538</izz>\n        </inertia>\n      </inertial>\n      <collision name='r_shoulder_pan_link_geom'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/shoulder_v0/shoulder_pan.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <friction>\n            <ode>\n              <mu>0.000000</mu>\n              <mu2>0.000000</mu2>\n              <slip1>0.000000</slip1>\n              <slip2>0.000000</slip2>\n            </ode>\n          </friction>\n          <contact>\n            <ode>\n              <kp>1000000000000.000000</kp>\n              <kd>10000.000000</kd>\n              <max_vel>100.000000</max_vel>\n              <min_depth>0.000000</min_depth>\n            </ode>\n          </contact>\n          <bounce/>\n        </surface>\n      </collision>\n      <visual name='r_shoulder_pan_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/shoulder_v0/shoulder_pan.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='r_shoulder_lift_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.050000 -0.188000 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>2.749880</mass>\n        <pose>0.021950 -0.026640 -0.031270 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.021056</ixx>\n          <ixy>0.004967</ixy>\n          <ixz>-0.001948</ixz>\n          <iyy>0.021272</iyy>\n          <iyz>0.001104</iyz>\n          <izz>0.019758</izz>\n        </inertia>\n      </inertial>\n      <collision name='r_shoulder_lift_link_geom'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/shoulder_v0/shoulder_lift.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <friction>\n            <ode>\n              <mu>0.000000</mu>\n              <mu2>0.000000</mu2>\n              <slip1>0.000000</slip1>\n              <slip2>0.000000</slip2>\n            </ode>\n          </friction>\n          <contact>\n            <ode>\n              <kp>1000000000000.000000</kp>\n              <kd>10000.000000</kd>\n              <max_vel>100.000000</max_vel>\n              <min_depth>0.000000</min_depth>\n            </ode>\n          </contact>\n          <bounce/>\n        </surface>\n      </collision>\n      <visual name='r_shoulder_lift_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/shoulder_v0/shoulder_lift.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='r_upper_arm_roll_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.050000 -0.188000 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>6.117690</mass>\n        <pose>0.210482 -0.015945 -0.000197 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.025378</ixx>\n          <ixy>0.003757</ixy>\n          <ixz>-0.000709</ixz>\n          <iyy>0.084737</iyy>\n          <iyz>-0.000179</iyz>\n          <izz>0.086088</izz>\n        </inertia>\n      </inertial>\n      <collision name='r_upper_arm_roll_link_geom'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/shoulder_v0/upper_arm_roll_L.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='r_upper_arm_roll_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/shoulder_v0/upper_arm_roll.stl</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <collision name='r_upper_arm_roll_link_geom_r_upper_arm_link'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/upper_arm_v0/upper_arm.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='r_upper_arm_roll_link_geom_r_upper_arm_link_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/upper_arm_v0/upper_arm.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='r_elbow_flex_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.450000 -0.188000 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>1.903270</mass>\n        <pose>0.010140 0.000320 -0.012110 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.003465</ixx>\n          <ixy>0.000041</ixy>\n          <ixz>0.000432</ixz>\n          <iyy>0.004416</iyy>\n          <iyz>-0.000040</iyz>\n          <izz>0.003592</izz>\n        </inertia>\n      </inertial>\n      <collision name='r_elbow_flex_link_geom'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/upper_arm_v0/elbow_flex.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='r_elbow_flex_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/upper_arm_v0/elbow_flex.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='r_forearm_roll_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.450000 -0.188000 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>2.689680</mass>\n        <pose>0.180727 -0.000163 -0.008583 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.014668</ixx>\n          <ixy>0.000052</ixy>\n          <ixz>0.000656</ixz>\n          <iyy>0.026279</iyy>\n          <iyz>-0.000013</iyz>\n          <izz>0.027775</izz>\n        </inertia>\n      </inertial>\n      <collision name='r_forearm_roll_link_geom'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/upper_arm_v0/forearm_roll_L.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='r_forearm_roll_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/upper_arm_v0/forearm_roll.stl</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <collision name='r_forearm_roll_link_geom_r_forearm_link'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/forearm_v0/forearm.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='r_forearm_roll_link_geom_r_forearm_link_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/forearm_v0/forearm.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <sensor name='r_forearm_cam_sensor' type='camera'>\n        <update_rate>25.000000</update_rate>\n        <pose>0.135000 0.000000 0.044000 1.570800 -0.562869 -0.000000</pose>\n        <always_on>0</always_on>\n        <visualize>0</visualize>\n        <camera name='__default__'>\n          <horizontal_fov>1.570796</horizontal_fov>\n          <image>\n            <width>640</width>\n            <height>480</height>\n            <format>R8G8B8</format>\n          </image>\n          <clip>\n            <near>0.100000</near>\n            <far>100.000000</far>\n          </clip>\n        </camera>\n      </sensor>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='r_wrist_flex_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.771000 -0.188000 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.614020</mass>\n        <pose>-0.001570 0.000000 -0.000750 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.000652</ixx>\n          <ixy>0.000000</ixy>\n          <ixz>0.000003</ixz>\n          <iyy>0.000198</iyy>\n          <iyz>0.000000</iyz>\n          <izz>0.000645</izz>\n        </inertia>\n      </inertial>\n      <collision name='r_wrist_flex_link_geom'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/forearm_v0/wrist_flex.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='r_wrist_flex_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/forearm_v0/wrist_flex.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='r_wrist_roll_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.771000 -0.188000 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.681070</mass>\n        <pose>0.056408 0.000451 -0.001014 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.011352</ixx>\n          <ixy>-0.000016</ixy>\n          <ixz>-0.000001</ixz>\n          <iyy>0.011677</iyy>\n          <iyz>-0.000001</iyz>\n          <izz>0.011866</izz>\n        </inertia>\n      </inertial>\n      <collision name='r_wrist_roll_link_geom'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/forearm_v0/wrist_roll_L.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='r_wrist_roll_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/forearm_v0/wrist_roll.stl</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <collision name='r_wrist_roll_link_geom_r_gripper_motor_accelerometer_link'>\n        <geometry>\n          <box>\n            <size>0.001000 0.001000 0.001000</size>\n          </box>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='r_wrist_roll_link_geom_r_gripper_motor_accelerometer_link_visual'>\n        <geometry>\n          <box>\n            <size>0.001000 0.001000 0.001000</size>\n          </box>\n        </geometry>\n      </visual>\n      <collision name='r_wrist_roll_link_geom_r_gripper_palm_link'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/gripper_v0/gripper_palm.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <bounce/>\n          <friction>\n            <ode/>\n          </friction>\n          <contact>\n            <ode/>\n          </contact>\n        </surface>\n      </collision>\n      <visual name='r_wrist_roll_link_geom_r_gripper_palm_link_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/gripper_v0/gripper_palm.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='r_gripper_l_finger_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.847910 -0.178000 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.171260</mass>\n        <pose>0.035980 0.017300 -0.001640 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.000078</ixx>\n          <ixy>0.000001</ixy>\n          <ixz>0.000010</ixz>\n          <iyy>0.000197</iyy>\n          <iyz>-0.000003</iyz>\n          <izz>0.000181</izz>\n        </inertia>\n      </inertial>\n      <collision name='r_gripper_l_finger_link_geom'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/gripper_v0/l_finger.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <friction>\n            <ode>\n              <mu>500.000000</mu>\n              <mu2>500.000000</mu2>\n              <slip1>0.000000</slip1>\n              <slip2>0.000000</slip2>\n            </ode>\n          </friction>\n          <contact>\n            <ode>\n              <kp>1000000.000000</kp>\n              <kd>1.000000</kd>\n              <max_vel>100.000000</max_vel>\n              <min_depth>0.000000</min_depth>\n            </ode>\n          </contact>\n          <bounce/>\n        </surface>\n      </collision>\n      <visual name='r_gripper_l_finger_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/gripper_v0/l_finger.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='r_gripper_l_finger_tip_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.939280 -0.173050 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.044190</mass>\n        <pose>0.004230 0.002840 0.000000 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.000008</ixx>\n          <ixy>0.000006</ixy>\n          <ixz>0.000000</ixz>\n          <iyy>0.000010</iyy>\n          <iyz>0.000000</iyz>\n          <izz>0.000015</izz>\n        </inertia>\n      </inertial>\n      <collision name='r_gripper_l_finger_tip_link_geom'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/gripper_v0/l_finger_tip.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <friction>\n            <ode>\n              <mu>500.000000</mu>\n              <mu2>500.000000</mu2>\n              <slip1>0.000000</slip1>\n              <slip2>0.000000</slip2>\n            </ode>\n          </friction>\n          <contact>\n            <ode>\n              <kp>10000000.000000</kp>\n              <kd>1.000000</kd>\n              <max_vel>100.000000</max_vel>\n              <min_depth>0.000000</min_depth>\n            </ode>\n          </contact>\n          <bounce/>\n        </surface>\n      </collision>\n      <visual name='r_gripper_l_finger_tip_link_geom_visual'>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/gripper_v0/l_finger_tip.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <sensor name='r_gripper_l_finger_tip_contact_sensor' type='contact'>\n        <update_rate>100.000000</update_rate>\n        <always_on>0</always_on>\n        <visualize>0</visualize>\n        <contact>\n          <collision>r_gripper_l_finger_tip_link_geom</collision>\n          <topic>__default_topic__</topic>\n        </contact>\n      </sensor>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='r_gripper_motor_slider_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.939280 -0.188000 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.010000</mass>\n        <inertia>\n          <ixx>0.001000</ixx>\n          <ixy>0.000000</ixy>\n          <ixz>0.000000</ixz>\n          <iyy>0.001000</iyy>\n          <iyz>0.000000</iyz>\n          <izz>0.001000</izz>\n        </inertia>\n      </inertial>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='r_gripper_motor_screw_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.939280 -0.188000 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.010000</mass>\n        <inertia>\n          <ixx>0.000100</ixx>\n          <ixy>0.000000</ixy>\n          <ixz>0.000000</ixz>\n          <iyy>0.000100</iyy>\n          <iyz>0.000000</iyz>\n          <izz>0.000100</izz>\n        </inertia>\n      </inertial>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='r_gripper_r_finger_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.847910 -0.198000 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.173890</mass>\n        <pose>0.035760 -0.017360 -0.000950 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.000077</ixx>\n          <ixy>-0.000002</ixy>\n          <ixz>-0.000008</ixz>\n          <iyy>0.000198</iyy>\n          <iyz>0.000002</iyz>\n          <izz>0.000181</izz>\n        </inertia>\n      </inertial>\n      <collision name='r_gripper_r_finger_link_geom'>\n        <pose>0.000000 0.000000 0.000000 -3.141590 0.000000 0.000000</pose>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/gripper_v0/l_finger.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <friction>\n            <ode>\n              <mu>500.000000</mu>\n              <mu2>500.000000</mu2>\n              <slip1>0.000000</slip1>\n              <slip2>0.000000</slip2>\n            </ode>\n          </friction>\n          <contact>\n            <ode>\n              <kp>1000000.000000</kp>\n              <kd>1.000000</kd>\n              <max_vel>100.000000</max_vel>\n              <min_depth>0.000000</min_depth>\n            </ode>\n          </contact>\n          <bounce/>\n        </surface>\n      </collision>\n      <visual name='r_gripper_r_finger_link_geom_visual'>\n        <pose>0.000000 0.000000 0.000000 -3.141590 0.000000 0.000000</pose>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/gripper_v0/l_finger.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='r_gripper_r_finger_tip_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.939280 -0.202950 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.044190</mass>\n        <pose>0.004230 -0.002840 0.000000 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.000008</ixx>\n          <ixy>-0.000006</ixy>\n          <ixz>0.000000</ixz>\n          <iyy>0.000010</iyy>\n          <iyz>0.000000</iyz>\n          <izz>0.000015</izz>\n        </inertia>\n      </inertial>\n      <collision name='r_gripper_r_finger_tip_link_geom'>\n        <pose>0.000000 0.000000 0.000000 -3.141590 0.000000 0.000000</pose>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/gripper_v0/l_finger_tip.stl</uri>\n          </mesh>\n        </geometry>\n        <surface>\n          <friction>\n            <ode>\n              <mu>500.000000</mu>\n              <mu2>500.000000</mu2>\n              <slip1>0.000000</slip1>\n              <slip2>0.000000</slip2>\n            </ode>\n          </friction>\n          <contact>\n            <ode>\n              <kp>10000000.000000</kp>\n              <kd>1.000000</kd>\n              <max_vel>100.000000</max_vel>\n              <min_depth>0.000000</min_depth>\n            </ode>\n          </contact>\n          <bounce/>\n        </surface>\n      </collision>\n      <visual name='r_gripper_r_finger_tip_link_geom_visual'>\n        <pose>0.000000 0.000000 0.000000 -3.141590 0.000000 0.000000</pose>\n        <geometry>\n          <mesh>\n            <uri>model://pr2/meshes/gripper_v0/l_finger_tip.dae</uri>\n          </mesh>\n        </geometry>\n      </visual>\n      <sensor name='r_gripper_r_finger_tip_contact_sensor' type='contact'>\n        <update_rate>100.000000</update_rate>\n        <always_on>0</always_on>\n        <visualize>0</visualize>\n        <contact>\n          <collision>r_gripper_r_finger_tip_link_geom</collision>\n          <topic>__default_topic__</topic>\n        </contact>\n      </sensor>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='torso_lift_motor_screw_link'>\n      <self_collide>0</self_collide>\n      <pose>-0.150000 0.000000 0.751000 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>1.000000</mass>\n        <inertia>\n          <ixx>0.001000</ixx>\n          <ixy>0.000000</ixy>\n          <ixz>0.000000</ixz>\n          <iyy>0.001000</iyy>\n          <iyz>0.000000</iyz>\n          <izz>0.001000</izz>\n        </inertia>\n      </inertial>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n      <gravity>1</gravity>\n    </link>\n    <link name='r_gripper_l_parallel_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.829910 -0.157000 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.171260</mass>\n        <pose>0.035980 0.017300 -0.001640 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.000078</ixx>\n          <ixy>0.000001</ixy>\n          <ixz>-0.000010</ixz>\n          <iyy>0.000197</iyy>\n          <iyz>-0.000003</iyz>\n          <izz>0.000181</izz>\n        </inertia>\n      </inertial>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='r_gripper_r_parallel_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.829910 -0.219000 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.173890</mass>\n        <pose>0.035760 -0.017360 -0.000950 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.000077</ixx>\n          <ixy>-0.000002</ixy>\n          <ixz>-0.000008</ixz>\n          <iyy>0.000198</iyy>\n          <iyz>0.000002</iyz>\n          <izz>0.000181</izz>\n        </inertia>\n      </inertial>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='l_gripper_l_parallel_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.829910 0.219000 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.171260</mass>\n        <pose>0.035980 0.017300 -0.001640 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.000078</ixx>\n          <ixy>0.000001</ixy>\n          <ixz>0.000010</ixz>\n          <iyy>0.000197</iyy>\n          <iyz>-0.000003</iyz>\n          <izz>0.000181</izz>\n        </inertia>\n      </inertial>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <link name='l_gripper_r_parallel_link'>\n      <self_collide>0</self_collide>\n      <gravity>0</gravity>\n      <pose>0.829910 0.157000 0.790675 0.000000 0.000000 0.000000</pose>\n      <inertial>\n        <mass>0.173890</mass>\n        <pose>0.035760 -0.017360 -0.000950 0.000000 0.000000 0.000000</pose>\n        <inertia>\n          <ixx>0.000077</ixx>\n          <ixy>-0.000002</ixy>\n          <ixz>0.000008</ixz>\n          <iyy>0.000198</iyy>\n          <iyz>0.000002</iyz>\n          <izz>0.000181</izz>\n        </inertia>\n      </inertial>\n      <velocity_decay>\n        <linear>0.000000</linear>\n        <angular>0.000000</angular>\n      </velocity_decay>\n      <kinematic>0</kinematic>\n    </link>\n    <joint name='bl_caster_rotation_joint' type='revolute'>\n      <parent>base_footprint</parent>\n      <child>bl_caster_rotation_link</child>\n      <axis>\n        <xyz>0.000000 0.000000 1.000000</xyz>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='bl_caster_l_wheel_joint' type='revolute'>\n      <parent>bl_caster_rotation_link</parent>\n      <child>bl_caster_l_wheel_link</child>\n      <axis>\n        <xyz>0.000000 1.000000 0.000000</xyz>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='bl_caster_r_wheel_joint' type='revolute'>\n      <parent>bl_caster_rotation_link</parent>\n      <child>bl_caster_r_wheel_link</child>\n      <axis>\n        <xyz>0.000000 1.000000 0.000000</xyz>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='br_caster_rotation_joint' type='revolute'>\n      <parent>base_footprint</parent>\n      <child>br_caster_rotation_link</child>\n      <axis>\n        <xyz>0.000000 0.000000 1.000000</xyz>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='br_caster_l_wheel_joint' type='revolute'>\n      <parent>br_caster_rotation_link</parent>\n      <child>br_caster_l_wheel_link</child>\n      <axis>\n        <xyz>0.000000 1.000000 0.000000</xyz>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='br_caster_r_wheel_joint' type='revolute'>\n      <parent>br_caster_rotation_link</parent>\n      <child>br_caster_r_wheel_link</child>\n      <axis>\n        <xyz>0.000000 1.000000 0.000000</xyz>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='fl_caster_rotation_joint' type='revolute'>\n      <parent>base_footprint</parent>\n      <child>fl_caster_rotation_link</child>\n      <axis>\n        <xyz>0.000000 0.000000 1.000000</xyz>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='fl_caster_l_wheel_joint' type='revolute'>\n      <parent>fl_caster_rotation_link</parent>\n      <child>fl_caster_l_wheel_link</child>\n      <axis>\n        <xyz>0.000000 1.000000 0.000000</xyz>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='fl_caster_r_wheel_joint' type='revolute'>\n      <parent>fl_caster_rotation_link</parent>\n      <child>fl_caster_r_wheel_link</child>\n      <axis>\n        <xyz>0.000000 1.000000 0.000000</xyz>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='fr_caster_rotation_joint' type='revolute'>\n      <parent>base_footprint</parent>\n      <child>fr_caster_rotation_link</child>\n      <axis>\n        <xyz>0.000000 0.000000 1.000000</xyz>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='fr_caster_l_wheel_joint' type='revolute'>\n      <parent>fr_caster_rotation_link</parent>\n      <child>fr_caster_l_wheel_link</child>\n      <axis>\n        <xyz>0.000000 1.000000 0.000000</xyz>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='fr_caster_r_wheel_joint' type='revolute'>\n      <parent>fr_caster_rotation_link</parent>\n      <child>fr_caster_r_wheel_link</child>\n      <axis>\n        <xyz>0.000000 1.000000 0.000000</xyz>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='torso_lift_joint' type='prismatic'>\n      <parent>base_footprint</parent>\n      <child>torso_lift_link</child>\n      <axis>\n        <xyz>0.000000 0.000000 1.000000</xyz>\n        <limit>\n          <lower>0.000000</lower>\n          <upper>0.330000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='head_pan_joint' type='revolute'>\n      <parent>torso_lift_link</parent>\n      <child>head_pan_link</child>\n      <axis>\n        <xyz>0.000000 0.000000 1.000000</xyz>\n        <dynamics>\n          <damping>2.000000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-3.006993</lower>\n          <upper>3.006993</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='head_tilt_joint' type='revolute'>\n      <parent>head_pan_link</parent>\n      <child>head_tilt_link</child>\n      <axis>\n        <xyz>0.000000 1.000000 0.000000</xyz>\n        <dynamics>\n          <damping>10.000000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-0.471237</lower>\n          <upper>1.396260</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='l_shoulder_pan_joint' type='revolute'>\n      <parent>torso_lift_link</parent>\n      <child>l_shoulder_pan_link</child>\n      <axis>\n        <xyz>0.000000 0.000000 1.000000</xyz>\n        <dynamics>\n          <damping>10.000000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-0.714602</lower>\n          <upper>2.285404</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='l_shoulder_lift_joint' type='revolute'>\n      <parent>l_shoulder_pan_link</parent>\n      <child>l_shoulder_lift_link</child>\n      <axis>\n        <xyz>0.000000 1.000000 0.000000</xyz>\n        <dynamics>\n          <damping>10.000000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-0.523601</lower>\n          <upper>1.396300</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='l_upper_arm_roll_joint' type='revolute'>\n      <parent>l_shoulder_lift_link</parent>\n      <child>l_upper_arm_roll_link</child>\n      <axis>\n        <xyz>1.000000 0.000000 0.000000</xyz>\n        <dynamics>\n          <damping>0.100000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-0.800000</lower>\n          <upper>3.900008</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='l_elbow_flex_joint' type='revolute'>\n      <parent>l_upper_arm_roll_link</parent>\n      <child>l_elbow_flex_link</child>\n      <axis>\n        <xyz>0.000000 1.000000 0.000000</xyz>\n        <dynamics>\n          <damping>1.000000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-2.321305</lower>\n          <upper>0.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='l_forearm_roll_joint' type='revolute'>\n      <parent>l_elbow_flex_link</parent>\n      <child>l_forearm_roll_link</child>\n      <axis>\n        <xyz>1.000000 0.000000 0.000000</xyz>\n        <dynamics>\n          <damping>0.100000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='l_wrist_flex_joint' type='revolute'>\n      <parent>l_forearm_roll_link</parent>\n      <child>l_wrist_flex_link</child>\n      <axis>\n        <xyz>0.000000 1.000000 0.000000</xyz>\n        <dynamics>\n          <damping>0.100000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-2.180004</lower>\n          <upper>0.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='l_wrist_roll_joint' type='revolute'>\n      <parent>l_wrist_flex_link</parent>\n      <child>l_wrist_roll_link</child>\n      <axis>\n        <xyz>1.000000 0.000000 0.000000</xyz>\n        <dynamics>\n          <damping>0.100000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='l_gripper_l_finger_joint' type='revolute'>\n      <parent>l_wrist_roll_link</parent>\n      <child>l_gripper_l_finger_link</child>\n      <axis>\n        <xyz>0.000000 0.000000 1.000000</xyz>\n        <dynamics>\n          <damping>0.020000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>0.000000</lower>\n          <upper>0.548000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='l_gripper_l_finger_tip_joint' type='revolute'>\n      <parent>l_gripper_l_finger_link</parent>\n      <child>l_gripper_l_finger_tip_link</child>\n      <axis>\n        <xyz>0.000000 0.000000 -1.000000</xyz>\n        <dynamics>\n          <damping>0.001000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>0.000000</lower>\n          <upper>0.548000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='l_gripper_motor_slider_joint' type='prismatic'>\n      <parent>l_wrist_roll_link</parent>\n      <child>l_gripper_motor_slider_link</child>\n      <axis>\n        <xyz>1.000000 0.000000 0.000000</xyz>\n        <limit>\n          <lower>-0.100000</lower>\n          <upper>0.100000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='l_gripper_motor_screw_joint' type='revolute'>\n      <parent>l_gripper_motor_slider_link</parent>\n      <child>l_gripper_motor_screw_link</child>\n      <axis>\n        <xyz>0.000000 1.000000 0.000000</xyz>\n        <dynamics>\n          <damping>0.000100</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='l_gripper_r_finger_joint' type='revolute'>\n      <parent>l_wrist_roll_link</parent>\n      <child>l_gripper_r_finger_link</child>\n      <axis>\n        <xyz>0.000000 0.000000 -1.000000</xyz>\n        <dynamics>\n          <damping>0.020000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>0.000000</lower>\n          <upper>0.548000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='l_gripper_r_finger_tip_joint' type='revolute'>\n      <parent>l_gripper_r_finger_link</parent>\n      <child>l_gripper_r_finger_tip_link</child>\n      <axis>\n        <xyz>0.000000 0.000000 1.000000</xyz>\n        <dynamics>\n          <damping>0.001000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>0.000000</lower>\n          <upper>0.548000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='laser_tilt_mount_joint' type='revolute'>\n      <parent>torso_lift_link</parent>\n      <child>laser_tilt_mount_link</child>\n      <axis>\n        <xyz>0.000000 1.000000 0.000000</xyz>\n        <dynamics>\n          <damping>0.008000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-0.785400</lower>\n          <upper>1.483530</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='r_shoulder_pan_joint' type='revolute'>\n      <parent>torso_lift_link</parent>\n      <child>r_shoulder_pan_link</child>\n      <axis>\n        <xyz>0.000000 0.000000 1.000000</xyz>\n        <dynamics>\n          <damping>10.000000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-2.285404</lower>\n          <upper>0.714602</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='r_shoulder_lift_joint' type='revolute'>\n      <parent>r_shoulder_pan_link</parent>\n      <child>r_shoulder_lift_link</child>\n      <axis>\n        <xyz>0.000000 1.000000 0.000000</xyz>\n        <dynamics>\n          <damping>10.000000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-0.523601</lower>\n          <upper>1.396300</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='r_upper_arm_roll_joint' type='revolute'>\n      <parent>r_shoulder_lift_link</parent>\n      <child>r_upper_arm_roll_link</child>\n      <axis>\n        <xyz>1.000000 0.000000 0.000000</xyz>\n        <dynamics>\n          <damping>0.100000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-3.900008</lower>\n          <upper>0.800000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='r_elbow_flex_joint' type='revolute'>\n      <parent>r_upper_arm_roll_link</parent>\n      <child>r_elbow_flex_link</child>\n      <axis>\n        <xyz>0.000000 1.000000 0.000000</xyz>\n        <dynamics>\n          <damping>1.000000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-2.321305</lower>\n          <upper>0.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='r_forearm_roll_joint' type='revolute'>\n      <parent>r_elbow_flex_link</parent>\n      <child>r_forearm_roll_link</child>\n      <axis>\n        <xyz>1.000000 0.000000 0.000000</xyz>\n        <dynamics>\n          <damping>0.100000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='r_wrist_flex_joint' type='revolute'>\n      <parent>r_forearm_roll_link</parent>\n      <child>r_wrist_flex_link</child>\n      <axis>\n        <xyz>0.000000 1.000000 0.000000</xyz>\n        <dynamics>\n          <damping>0.100000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-2.180004</lower>\n          <upper>0.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='r_wrist_roll_joint' type='revolute'>\n      <parent>r_wrist_flex_link</parent>\n      <child>r_wrist_roll_link</child>\n      <axis>\n        <xyz>1.000000 0.000000 0.000000</xyz>\n        <dynamics>\n          <damping>0.100000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='r_gripper_l_finger_joint' type='revolute'>\n      <parent>r_wrist_roll_link</parent>\n      <child>r_gripper_l_finger_link</child>\n      <axis>\n        <xyz>0.000000 0.000000 1.000000</xyz>\n        <dynamics>\n          <damping>0.020000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>0.000000</lower>\n          <upper>0.548000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='r_gripper_l_finger_tip_joint' type='revolute'>\n      <parent>r_gripper_l_finger_link</parent>\n      <child>r_gripper_l_finger_tip_link</child>\n      <axis>\n        <xyz>0.000000 0.000000 -1.000000</xyz>\n        <dynamics>\n          <damping>0.001000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>0.000000</lower>\n          <upper>0.548000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='r_gripper_motor_slider_joint' type='prismatic'>\n      <parent>r_wrist_roll_link</parent>\n      <child>r_gripper_motor_slider_link</child>\n      <axis>\n        <xyz>1.000000 0.000000 0.000000</xyz>\n        <dynamics>\n          <damping>0.000000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-0.100000</lower>\n          <upper>0.100000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='r_gripper_motor_screw_joint' type='revolute'>\n      <parent>r_gripper_motor_slider_link</parent>\n      <child>r_gripper_motor_screw_link</child>\n      <axis>\n        <xyz>0.000000 1.000000 0.000000</xyz>\n        <dynamics>\n          <damping>0.000100</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='r_gripper_r_finger_joint' type='revolute'>\n      <parent>r_wrist_roll_link</parent>\n      <child>r_gripper_r_finger_link</child>\n      <axis>\n        <xyz>0.000000 0.000000 -1.000000</xyz>\n        <dynamics>\n          <damping>0.020000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>0.000000</lower>\n          <upper>0.548000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='r_gripper_r_finger_tip_joint' type='revolute'>\n      <parent>r_gripper_r_finger_link</parent>\n      <child>r_gripper_r_finger_tip_link</child>\n      <axis>\n        <xyz>0.000000 0.000000 1.000000</xyz>\n        <dynamics>\n          <damping>0.001000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>0.000000</lower>\n          <upper>0.548000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='torso_lift_motor_screw_joint' type='revolute'>\n      <parent>base_footprint</parent>\n      <child>torso_lift_motor_screw_link</child>\n      <axis>\n        <xyz>0.000000 0.000000 1.000000</xyz>\n        <dynamics>\n          <damping>0.000100</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='torso_lift_screw_torso_lift_joint' type='screw'>\n      <parent>torso_lift_link</parent>\n      <child>torso_lift_motor_screw_link</child>\n      <thread_pitch>3141.600000</thread_pitch>\n      <axis>\n        <xyz>0.000000 0.000000 1.000000</xyz>\n        <dynamics>\n          <damping>0.000000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='r_gripper_r_screw_screw_joint' type='screw'>\n      <parent>r_gripper_r_finger_tip_link</parent>\n      <child>r_gripper_motor_screw_link</child>\n      <thread_pitch>-3141.600000</thread_pitch>\n      <axis>\n        <xyz>0.000000 1.000000 0.000000</xyz>\n        <dynamics>\n          <damping>0.000000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='r_gripper_l_screw_screw_joint' type='screw'>\n      <parent>r_gripper_l_finger_tip_link</parent>\n      <child>r_gripper_motor_screw_link</child>\n      <thread_pitch>3141.600000</thread_pitch>\n      <axis>\n        <xyz>0.000000 1.000000 0.000000</xyz>\n        <dynamics>\n          <damping>0.000000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='r_gripper_r_parallel_root_joint' type='revolute'>\n      <pose>0.058910 -0.031000 0.000000 0.000000 0.000000 0.000000</pose>\n      <parent>r_gripper_r_parallel_link</parent>\n      <child>r_wrist_roll_link</child>\n      <axis>\n        <xyz>0.000000 0.000000 -1.000000</xyz>\n        <dynamics>\n          <damping>0.200000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='r_gripper_l_parallel_root_joint' type='revolute'>\n      <pose>0.058910 0.031000 0.000000 0.000000 0.000000 0.000000</pose>\n      <parent>r_gripper_l_parallel_link</parent>\n      <child>r_wrist_roll_link</child>\n      <axis>\n        <xyz>0.000000 0.000000 1.000000</xyz>\n        <dynamics>\n          <damping>0.200000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='r_gripper_r_parallel_tip_joint' type='revolute'>\n      <pose>-0.018000 -0.021000 0.000000 0.000000 0.000000 0.000000</pose>\n      <parent>r_gripper_r_parallel_link</parent>\n      <child>r_gripper_r_finger_tip_link</child>\n      <axis>\n        <xyz>0.000000 0.000000 1.000000</xyz>\n        <dynamics>\n          <damping>0.000000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='r_gripper_l_parallel_tip_joint' type='revolute'>\n      <pose>-0.018000 0.021000 0.000000 0.000000 0.000000 0.000000</pose>\n      <parent>r_gripper_l_parallel_link</parent>\n      <child>r_gripper_l_finger_tip_link</child>\n      <axis>\n        <xyz>0.000000 0.000000 1.000000</xyz>\n        <dynamics>\n          <damping>0.000000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='r_gripper_joint' type='prismatic'>\n      <parent>r_gripper_r_finger_tip_link</parent>\n      <child>r_gripper_l_finger_tip_link</child>\n      <axis>\n        <xyz>0.000000 1.000000 0.000000</xyz>\n        <dynamics>\n          <damping>0.000000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='l_gripper_r_screw_screw_joint' type='screw'>\n      <parent>l_gripper_r_finger_tip_link</parent>\n      <child>l_gripper_motor_screw_link</child>\n      <thread_pitch>-3141.600000</thread_pitch>\n      <axis>\n        <xyz>0.000000 1.000000 0.000000</xyz>\n        <dynamics>\n          <damping>0.000000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='l_gripper_l_screw_screw_joint' type='screw'>\n      <parent>l_gripper_l_finger_tip_link</parent>\n      <child>l_gripper_motor_screw_link</child>\n      <thread_pitch>3141.600000</thread_pitch>\n      <axis>\n        <xyz>0.000000 1.000000 0.000000</xyz>\n        <dynamics>\n          <damping>0.000000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='l_gripper_r_parallel_root_joint' type='revolute'>\n      <pose>0.058910 -0.031000 0.000000 0.000000 0.000000 0.000000</pose>\n      <parent>l_gripper_r_parallel_link</parent>\n      <child>l_wrist_roll_link</child>\n      <axis>\n        <xyz>0.000000 0.000000 -1.000000</xyz>\n        <dynamics>\n          <damping>0.200000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='l_gripper_l_parallel_root_joint' type='revolute'>\n      <pose>0.058910 0.031000 0.000000 0.000000 0.000000 0.000000</pose>\n      <parent>l_gripper_l_parallel_link</parent>\n      <child>l_wrist_roll_link</child>\n      <axis>\n        <xyz>0.000000 0.000000 1.000000</xyz>\n        <dynamics>\n          <damping>0.200000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='l_gripper_r_parallel_tip_joint' type='revolute'>\n      <pose>-0.018000 -0.021000 0.000000 0.000000 0.000000 0.000000</pose>\n      <parent>l_gripper_r_parallel_link</parent>\n      <child>l_gripper_r_finger_tip_link</child>\n      <axis>\n        <xyz>0.000000 0.000000 1.000000</xyz>\n        <dynamics>\n          <damping>0.000000</damping>\n          <friction>0.000000</friction>\n        </dynamics>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='l_gripper_l_parallel_tip_joint' type='revolute'>\n      <pose>-0.018000 0.021000 0.000000 0.000000 0.000000 0.000000</pose>\n      <parent>l_gripper_l_parallel_link</parent>\n      <child>l_gripper_l_finger_tip_link</child>\n      <axis>\n        <xyz>0.000000 0.000000 1.000000</xyz>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n    <joint name='l_gripper_joint' type='prismatic'>\n      <parent>l_gripper_r_finger_tip_link</parent>\n      <child>l_gripper_l_finger_tip_link</child>\n      <axis>\n        <xyz>0.000000 1.000000 0.000000</xyz>\n        <limit>\n          <lower>-10000000000000000.000000</lower>\n          <upper>10000000000000000.000000</upper>\n          <effort>0.000000</effort>\n          <velocity>4.000000</velocity>\n        </limit>\n      </axis>\n    </joint>\n  </model>\n  <physics type='ode'>\n    <update_rate>1000.000000</update_rate>\n    <gravity>0.000000 0.000000 -9.800000</gravity>\n  </physics>\n  <scene>\n    <ambient>0.200000 0.200000 0.200000 1.000000</ambient>\n    <background>0.700000 0.700000 0.700000 1.000000</background>\n    <shadows>1</shadows>\n  </scene>\n  <state world_name='default'>\n    <sim_time>0 0</sim_time>\n    <real_time>0 0</real_time>\n    <wall_time>1360301755 667456998</wall_time>\n  </state>\n</world>\n</sdf>]]></chunk>\n<chunk encoding='txt'><![CDATA[\n<sdf version='1.4'>\n<state world_name='default'>\n<sim_time>0 21343973</sim_time>\n<real_time>0 1000000</real_time>\n<wall_time>1360301758 939690376</wall_time>\n<model name='pr2'>\n</model>\n</sdf></state>\n]]></chunk>\n<chunk encoding='txt'><![CDATA[\n<sdf version='1.4'>\n<state world_name='default'>\n<sim_time>0 28958235</sim_time>\n<real_time>0 2000000</real_time>\n<wall_time>1360301758 947304437</wall_time>\n<model name='pr2'>\n</model>\n</sdf></state>\n]]></chunk>\n</gazebo_log>";

#endif
