/*
 * Copyright (C) 2012-2014 Open Source Robotics Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
*/
#ifndef _SSAOLOGIC_HH_
#define _SSAOLOGIC_HH_

#include <OgreCompositorInstance.h>
#include <OgreCompositorLogic.h>
#include <map>

#include "gazebo/rendering/deferred_shading/ListenerFactoryLogic.hh"
#include "gazebo/util/system.hh"

namespace gazebo
{
  namespace rendering
  {
    class GAZEBO_VISIBLE SSAOLogic : public ListenerFactoryLogic
    {
      /// @copydoc ListenerFactoryLogic::createListener
      protected: virtual Ogre::CompositorInstance::Listener *createListener(
                     Ogre::CompositorInstance* instance);
    };
  }
}
#endif
