import re
from zope.interface import implementer
from twisted.web import template
from . import iformal


_IDENTIFIER_REGEX = re.compile('^[a-zA-Z_][a-zA-Z0-9_]*$')


def titleFromName(name):

    def _():

        it = iter(name)
        last = None

        while 1:
            try:
                ch = next(it)
            except StopIteration:
                return
            if ch == '_':
                if last != '_':
                    yield ' '
            elif last in (None,'_'):
                yield ch.upper()
            elif ch.isupper() and not last.isupper():
                yield ' '
                yield ch.upper()
            else:
                yield ch
            last = ch

    return ''.join(_())

def keytocssid(fieldKey, *extras):
    return render_cssid(fieldKey, *extras)

def render_cssid(fieldKey, *extras):
    """
    Render the CSS id for the form field's key.
    """
    l = [template.slot('formName'), '-', '-'.join(fieldKey.split('.'))]
    for extra in extras:
        l.append('-')
        l.append(str(extra))
    return l



def validIdentifier(name):
    """
    Test that name is a valid Python identifier.
    """
    return _IDENTIFIER_REGEX.match(name) is not None

@implementer( iformal.IKey, iformal.ILabel )
class SequenceKeyLabelAdapter(object):

    def __init__(self, original):
        self.original = original

    def key(self):
        return str(self.original[0])

    def label(self):
        return str(self.original[1])


@implementer(iformal.ILabel)
class StringableLabelAdapter(object):

    def __init__(self, original):
        self.original = str(original)

    def label(self):
        return self.original
