import string
import os
import sys
import math

from Tkinter import *
from plot import Gnuplot
from folder import folder

def UVVis(root,screen,logfile,start,end,numpts,FWHM,UVplot,gnuplotexec): # inputfilename is the name of a TD-DFT output file

    screen.write("Starting UVVis.py\n")

    start=int(start); end=int(end); numpts=int(numpts)
    FWHM=float(FWHM)

    screen.write("Finding the number of the HOMO\n")
    evalue,sym,HOMO,optional=logfile.getenergylevels()

##    if optional:
##        screen.write("GaussSum does not yet handle unrestricted TD.\n")
##        screen.write("Please send the author an example file if you wish him to add support.\n")
##        return False

    # Read in all the transition info
    # Note: rotatory lengths have units 1e-40
    energy_eV,wave,osc,sym,CIS,rotatory=logfile.getUV_Vis()
    if len(energy_eV)==0:
        screen.write("No electronic transitions found!\n")
        return False
    energy_wavenum=[x*8065.6 for x in energy_eV] # Conversion from eV to wavenumbers

    # Create output directory if necessary
    gaussdir=folder(screen,logfile)

    if UVplot==True:
#######################################################
#                 UV-Visible section                  #
#######################################################

    # Read in orbital_data.txt if it exists(which contains info on the contribs)
        NGroups=0
        try:
            inputfile=open(os.path.join(gaussdir,"orbital_data.txt"),"r")
        except IOError:
            orbdata=False
            screen.write("orbital_data.txt not found\n")
        else:
            orbdata=True
            screen.write("Using orbital_data.txt\n")

        if orbdata:
            thisHOMO,NBasis,NGroups,groupname,groupatoms,contrib,evalue,optional=readorbital_data(inputfile)
            if thisHOMO!=HOMO:
                screen.write("Disagreement on HOMO...orbital_data.txt says "+str(thisHOMO+1)+"\n"+logfile.filename+" says "+str(HOMO+1)+"\n")
                return False
            inputfile.close()



        if orbdata:
            screenCD=[]
            for i in range(len(energy_eV)): # For each transition
                screenCD.append("")
                # charge density [before, after] for each of the groups for each of the transitions

        majorCIS=[]; minorCIS=[]
        for i in range(len(energy_eV)):
            majorCIS.append("")
            minorCIS.append("")

        for i in range(len(energy_eV)): # For each transition
            if orbdata:
                CD=[]
                for j in range(NGroups):
                    CD.append([0,0])
            totcontribs=0
            for j in range(len(CIS[i])): # For each contribution
                totcontribs=totcontribs+abs(CIS[i][j][2]) # tot up the contribs (what about the negative ones??)
                contr=int(abs(CIS[i][j][2])*100+.5)
                if orbdata:
                    for k in range(NGroups):
                        CD[k][0]=CD[k][0]+abs(CIS[i][j][2])*contrib[CIS[i][j][0]-1][k]
                        CD[k][1]=CD[k][1]+abs(CIS[i][j][2])*contrib[CIS[i][j][1]-1][k]
                if contr>=10: # Major contributions (>=10%)
                    sign=""
                    if CIS[i][j][2]<0:
                        sign="-"
                    if majorCIS[i]!="":
                        majorCIS[i]=majorCIS[i]+", "
                    majorCIS[i]=majorCIS[i]+levelname(CIS[i][j][0]-1,HOMO)+"->"+levelname(CIS[i][j][1]-1,HOMO)+" ("+sign+str(contr)+"%)"
                elif contr>=2: #Minor contributions (>=2%)
                    sign=""
                    if CIS[i][j][2]<0:
                        sign="-"
                    if minorCIS[i]!="":
                        minorCIS[i]=minorCIS[i]+", "
                    minorCIS[i]=minorCIS[i]+levelname(CIS[i][j][0]-1,HOMO)+"->"+levelname(CIS[i][j][1]-1,HOMO)+" ("+sign+str(contr)+"%)"
                    
                    
            if orbdata:
                for j in range(len(groupname)): # The charge densities are scaled so that they add to one
                    CD[j][0]=CD[j][0]/totcontribs
                    CD[j][1]=CD[j][1]/totcontribs
                    screenCD[i]=screenCD[i]+percent(CD[j][0])+"-->"+percent(CD[j][1])+" ("+percent(round(CD[j][1],2)-round(CD[j][0],2))+")\t"
                                                                                    
            

    # Write UVData.txt containing info on the transitions

        fileoutput=""

        for i in range(len(energy_eV)): # For each transition
            fileoutput=fileoutput+str(i+1)+"\t"+str(energy_eV[i])+"\t"+str(wave[i])+"\t"+str(osc[i])+"\t"+sym[i]+"\t"+majorCIS[i]+"\t"+minorCIS[i]
            if orbdata:
                fileoutput=fileoutput+"\t"+screenCD[i]
            fileoutput=fileoutput+"\n"


        screen.write("Writing the transition info to UVData.txt\n")
        outputfile=open(os.path.join(gaussdir,"UVData.txt"),"w")
        outputfile.write("HOMO is "+str(HOMO+1)+"\nNo.\tEnergy (eV)\tWavelength (nm)\tOsc. Strength\tSymmetry\tMajor contribs\tMinor contribs")
        for i in range(NGroups):
            outputfile.write("\t"+groupname[i])
        outputfile.write("\n"+fileoutput)
        outputfile.close()

    # Write UVSpectrum.txt containing info on the spectrum
        spectrum=[]
        for x in range(numpts): # Spectrum from 10000 (1000nm) to 50000 cm-1 (200nm)
            spectrum.append(0)

        width=end-start
        
        for x in range(len(energy_eV)):
            for y in range(numpts): # the index in the array
                realy=width*y/numpts+start # the wavelength
                realy=1.0e7/realy # the energy in wavenumbers
                z=2.174e8*osc[x]/FWHM
                z=z*math.exp(-2.772*((realy-energy_wavenum[x])/FWHM)**2)
                spectrum[y]=spectrum[y]+z

        screen.write("Writing the spectrum to UVSpectrum.txt\n")
        outputfile=open(os.path.join(gaussdir,"UVSpectrum.txt"),"w")
        outputfile.write("Wavelength (nm)\tEnergy (cm-1)\tAbs\t<--UV Spectrum\tUV-Vis transitions-->\tWavelength (nm)\tEnergy (cm-1)\tOsc. strength\n")

        width=end-start
        for x in range(numpts):
            realx=width*x/numpts+start
            realx=1.0e7/realx
            outputfile.write(str(1e7/realx)+"\t"+str(realx)+"\t"+str(spectrum[x]))
            if x<len(energy_wavenum): # Write the oscillator strengths out also
                outputfile.write("\t\t\t"+str(wave[x])+"\t"+str(energy_wavenum[x])+"\t"+str(osc[x]))
            outputfile.write("\n")
        outputfile.close()

        # Plot the UV Spectrum using Gnuplot

        screen.write("Plotting using Gnuplot\n")

        if max(spectrum)<1E-8: # Gnuplot won't draw it if the spectrum is flat
            screen.write("There are no peaks in this wavelength range!\n")
        else:
            line="set ytics nomirror\nset y2tics\nset y2label 'Oscillator strength'\n"
            line=line+"set xlabel 'Wavelength (nm)'\nset ylabel 'epsilon'\nset xrange ["+str(start)+":"+str(end)+"]\n"
            line=line+"plot '"+os.path.join(gaussdir,"UVSpectrum.txt")+"' using 1:3 notitle with lines, '"+os.path.join(gaussdir,"UVSpectrum.txt")+"' using 4:6 axes x1y2 notitle with impulses\n"

            Gnuplot(root,gnuplotexec,line,"UV-Vis Spectrum")

    else:
#######################################################
# Circular dichroism section from here to end of main #
#######################################################

        if not rotatory:
            screen.write("No rotatory lengths were found\n")
            return False
        elif len(rotatory)!=len(energy_eV): # Catch violation of an assertion
            screen.write("The number of R values doesn't agree with the number of electronic transitions!\n")
            return False
  
# Write CDSpectrum.txt containing info on the CD spectrum
        spectrum=[]
        for x in range(numpts): # Spectrum from 10000 (1000nm) to 50000 cm-1 (200nm)
            spectrum.append(0)
        
        width=end-start
        sigma=FWHM*8065.6 # Conversion from eV to 1/cm
        for x in range(len(rotatory)):
            for y in range(numpts): # the index in the array
                realy=width*y/numpts+start # the wavelength
                realy=1.0e7/realy # the energy in wavenumber
                prefactor = 1.0 / math.sqrt(2 * math.pi * sigma)
                exponent= math.exp(-((realy-energy_wavenum[x])/(2*sigma) )**2)
                # Equation taken (with slight amendment in exponent) from JPCA, 2003, 107, 2526.
                z=(1/2.297e-39) * prefactor * energy_wavenum[x] * rotatory[x] * 1e-40 * exponent
                spectrum[y]=spectrum[y]+z

        screen.write("Writing the spectrum to CDSpectrum.txt\n")
        outputfile=open(os.path.join(gaussdir,"CDSpectrum.txt"),"w")
        outputfile.write("Wavelength (nm)\tEnergy (cm-1)\tAbs\t<--CD Spectrum\tStates-->\tWavelength (nm)\tEnergy (cm-1)\tR(length)\n")

        width=end-start
        for x in range(numpts):
            realx=float(width)*x/numpts+start # Need to use float, otherwise it's an integer
            outputfile.write( "%f\t%f\t%f" % (realx,1.0e7/realx,spectrum[x]) )
            if x<len(energy_wavenum): # Write the R values out also
                outputfile.write( "\t\t\t%f\t%f\t%f" % (wave[x],energy_wavenum[x],rotatory[x]) )
            outputfile.write("\n")
        outputfile.close()

        # Plot the UV Spectrum using Gnuplot

        screen.write("Plotting using Gnuplot\n")

        if max(spectrum)<1E-8: # Gnuplot won't draw it if the spectrum is flat
            screen.write("There are no peaks in this wavelength range!\n")
        else:
            line="set ytics nomirror\nset y2tics\nset y2label 'R (length) / 1e-40'\n"
            line=line+"set xlabel 'Wavelength (nm)'\nset ylabel 'epsilon'\nset xrange ["+str(start)+":"+str(end)+"]\n"
            line=line+"plot '"+os.path.join(gaussdir,"CDSpectrum.txt")+"' using 1:3 notitle with lines, '"+os.path.join(gaussdir,"CDSpectrum.txt")+"' using 4:6 axes x1y2 notitle with impulses\n"

            Gnuplot(root,gnuplotexec,line,"Circular dichroism spectrum")

    screen.write("Finishing UVVis.py")

#######################################################
#                      End of main                    #
#######################################################    

    

def readorbital_data(inputfile):
    # Reads in all data from orbital_data.txt
    # This function is also used by MO.py

    # thisHOMO is numbered based on the 1st orbital being zero
    
    line=inputfile.readline(); NBasis=int(line.split()[1])
    line=inputfile.readline().split(); thisHOMO=int(line[1])-1
    unres=False
    if len(line)==3:
        unres=True # This is an unrestricted calculation
        thisHOMO_beta=int(line[2])-1
    line=inputfile.readline(); NGroups=int(line.split()[1])
    groupname=[]; groupatoms=[]
    for i in range(NGroups): # Read in group info
        line=inputfile.readline()
        temp=line.split('\t')
        groupname.append(temp[0])
        groupatoms.append(map(int,temp[1].split()))

    line=inputfile.readline(); line=inputfile.readline()
    contrib=[]; contrib_beta=[]
    for i in range(NBasis):
        contrib.append([])
        if unres:
            contrib_beta.append([])
    # Contribs for orbital#1 will be in contrib[0][0-->NGroups]

    evalue=[]; evalue_beta=[]
    for i in range(NBasis-1,-1,-1):
        line=inputfile.readline().split()
        evalue.append(float(line[2]))
        more=line[4+NGroups:4+NGroups*2] # Strip off the crud at the start
        contrib[i]=map(float,more)
        if unres:
            evalue_beta.append(float(line[6+NGroups*2]))
            more=line[8+NGroups*3:8+NGroups*4]
            contrib_beta[i]=map(float,more)

    evalue.reverse() # Because you're reading them in backwards
    optional=[]
    if unres:
        evalue_beta.reverse()
        optional=[thisHOMO_beta,contrib_beta,evalue_beta]

    return thisHOMO,NBasis,NGroups,groupname,groupatoms,contrib,evalue,optional


def percent(number):
    return str(int(round(number*100))) # round leaves .0 at the end of a number
    
def levelname(i,HOMO):
    if i<HOMO:
        level='H-'+str(HOMO-i)
    elif i>HOMO+1:
        level='L+'+str(i-HOMO-1)
    elif i==HOMO+1:
        level="LUMO"
    else:
        level="HOMO"
    return level
    

# The main start
if __name__=="__main__": # if it's being run (and not imported)
    root=Tk()
    UVVis(root,sys.stdout,"input/RUBPY3_TD.out")
    root.mainloop()
