#!/bin/sh

set -e

BASE_REL=$(dpkg-parsechangelog 2>/dev/null | sed -ne 's/Version: \([0-9]\)~.*/\1/p')
OLDDIR=${PWD}
GOS_DIR=${OLDDIR}/get-orig-source
SVN_COMMIT='svn log http://svn.drobilla.net/lad/trunk/ganv/ -l 1 | sed -ne "s/r\([0-9]\+\).*/\1/p"'
REPACK_SUFFIX=~dfsg0

if [ -z ${BASE_REL} ]; then
	echo 'Please run this script from the sources root directory.'
	exit 1
fi


rm -rf ${GOS_DIR}
mkdir ${GOS_DIR} && cd ${GOS_DIR}
GANV_SVN_COMMIT=$(eval "${SVN_COMMIT}")
svn export -r ${GANV_SVN_COMMIT} http://svn.drobilla.net/lad/trunk/ganv/ \
	ganv-${BASE_REL}~svn${GANV_SVN_COMMIT}${REPACK_SUFFIX}
cd ganv-${BASE_REL}~svn${GANV_SVN_COMMIT}${REPACK_SUFFIX}
# Unpack waf
./waf --help 2>&1 1>/dev/null
mv .waf-*/waflib waflib
sed -i '/^#==>$/,$d' waf
rmdir .waf-*
find waflib -name "*.pyc" -delete
# Repack tarball
cd .. && tar cjf \
	${OLDDIR}/ganv_${BASE_REL}~svn${GANV_SVN_COMMIT}${REPACK_SUFFIX}.orig.tar.bz2 \
	ganv-${BASE_REL}~svn${GANV_SVN_COMMIT}${REPACK_SUFFIX} --exclude-vcs
rm -rf ${GOS_DIR}
