/* Test for decoding SMS on Nokia 6510 driver */

#include <gammu.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include "common.h"

#include "../libgammu/protocol/protocol.h" /* Needed for GSM_Protocol_Message */
#include "../libgammu/gsmstate.h" /* Needed for state machine internals */

#include "../helper/message-display.h"

unsigned char data[] = {
	0x00, 0x02, 0x00, 0x01, 0x00, 0x00, 0x00, 0x9F, 0x00, 0x00, 0x02, 0x51, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2B,
	0x00, 0x33, 0x00, 0x39, 0x00, 0x33, 0x00, 0x33, 0x00, 0x33, 0x00, 0x33, 0x00, 0x33, 0x00, 0x33,
	0x00, 0x31, 0x00, 0x30, 0x00, 0x35, 0x00, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x44, 0x0C, 0x91, 0x93, 0x23, 0x68, 0x28, 0x01, 0x85, 0x00, 0x08, 0x80, 0x90, 0x03, 0x32, 0x21,
	0x10, 0x80, 0x8C, 0x05, 0x00, 0x03, 0xE3, 0x02, 0x01, 0x00, 0x50, 0x00, 0x65, 0x00, 0x7A, 0x00,
	0x7A, 0x00, 0x6F, 0x00, 0x20, 0x00, 0x64, 0x00, 0x69, 0x00, 0x20, 0x00, 0x7A, 0x00, 0x75, 0x00,
	0x6C, 0x00, 0xFA, 0x00, 0x20, 0x00, 0x6D, 0x00, 0x61, 0x00, 0x20, 0x00, 0x6B, 0x00, 0x65, 0x00,
	0x2E, 0x00, 0x2E, 0x00, 0x6E, 0x00, 0x6E, 0x00, 0x20, 0x00, 0x73, 0x00, 0x69, 0x00, 0x20, 0x00,
	0x72, 0x00, 0x69, 0x00, 0x73, 0x00, 0x70, 0x00, 0x6F, 0x00, 0x6E, 0x00, 0x64, 0x00, 0x65, 0x00,
	0x20, 0x00, 0x70, 0x00, 0x69, 0x00, 0xF9, 0x00, 0x20, 0x00, 0x61, 0x00, 0x69, 0x00, 0x20, 0x00,
	0x6D, 0x00, 0x65, 0x00, 0x73, 0x00, 0x73, 0x00, 0x61, 0x00, 0x67, 0x00, 0x69, 0x00, 0x3F, 0x00,
	0x21, 0x00, 0x20, 0x00, 0x43, 0x00, 0x61, 0x00, 0x67, 0x00, 0x61, 0x00, 0x74, 0x00, 0x69, 0x00,
	0x2E, 0x00, 0x20, 0x00, 0x42, 0x00, 0x75, 0x00, 0x6F, 0x00, 0x6E, 0x00, 0x61, 0x00, 0x20, 0x01,
	0x00, 0xFF, 0x01, 0x00, 0x01, 0x00, 0x02, 0x00, 0x0E, 0x2B, 0x33, 0x39, 0x33, 0x32, 0x30, 0x35,
	0x39, 0x35, 0x36, 0x31, 0x31, 0x31, 0x00, 0x03, 0x00, 0xA6, 0x00, 0x50, 0x00, 0x65, 0x00, 0x7A,
	0x00, 0x7A, 0x00, 0x6F, 0x00, 0x20, 0x00, 0x64, 0x00, 0x69, 0x00, 0x20, 0x00, 0x7A, 0x00, 0x75,
	0x00, 0x6C, 0x00, 0xFA, 0x00, 0x20, 0x00, 0x6D, 0x00, 0x61, 0x00, 0x20, 0x00, 0x6B, 0x00, 0x65,
	0x00, 0x2E, 0x00, 0x2E, 0x00, 0x6E, 0x00, 0x6E, 0x00, 0x20, 0x00, 0x73, 0x00, 0x69, 0x00, 0x20,
	0x00, 0x72, 0x00, 0x69, 0x00, 0x73, 0x00, 0x70, 0x00, 0x6F, 0x00, 0x6E, 0x00, 0x64, 0x00, 0x65,
	0x00, 0x20, 0x00, 0x70, 0x00, 0x69, 0x00, 0xF9, 0x00, 0x20, 0x00, 0x61, 0x00, 0x69, 0x00, 0x20,
	0x00, 0x6D, 0x00, 0x65, 0x00, 0x73, 0x00, 0x73, 0x00, 0x61, 0x00, 0x67, 0x00, 0x69, 0x00, 0x3F,
	0x00, 0x21, 0x00, 0x20, 0x00, 0x43, 0x00, 0x61, 0x00, 0x67, 0x00, 0x61, 0x00, 0x74, 0x00, 0x69,
	0x00, 0x2E, 0x00, 0x20, 0x00, 0x42, 0x00, 0x75, 0x00, 0x6F, 0x00, 0x6E, 0x00, 0x61, 0x00, 0x20,
	0x00, 0x6E, 0x00, 0x6F, 0x00, 0x74, 0x00, 0x74, 0x00, 0x65, 0x00, 0x21, 0x00, 0x3A, 0x00, 0x2D,
	0x00, 0x50, 0x00, 0x20, 0x00, 0x65, 0x00, 0x68, 0x00, 0x20, 0x00, 0x65, 0x00, 0x68, 0x00, 0x00,
	0x04, 0x00, 0x1C, 0x00, 0x2B, 0x00, 0x33, 0x00, 0x39, 0x00, 0x33, 0x00, 0x32, 0x00, 0x38, 0x00,
	0x36, 0x00, 0x38, 0x00, 0x32, 0x00, 0x31, 0x00, 0x30, 0x00, 0x35, 0x00, 0x38, 0x00, 0x00, 0x0C,
	0x00, 0x01, 0x00, 0x07, 0x00, 0x01, 0x00, 0x05, 0x00, 0x01, 0x00, 0x06, 0x00, 0x04, 0x00, 0x00,
	0x00, 0x00, 0x08, 0x00, 0x01, 0x00, 0x0B, 0x00, 0x01, 0x00, 0x09, 0x00, 0x04, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x0B, 0x00, 0x01, 0x00, 0x09, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00
	};

unsigned char message[] = {
	0x00, 0x50, 0x00, 0x65, 0x00, 0x7a, 0x00, 0x7a, 0x00, 0x6f, 0x00, 0x20, 0x00, 0x64, 0x00, 0x69,
	0x00, 0x20, 0x00, 0x7a, 0x00, 0x75, 0x00, 0x6c, 0x00, 0xfa, 0x00, 0x20, 0x00, 0x6d, 0x00, 0x61,
	0x00, 0x20, 0x00, 0x6b, 0x00, 0x65, 0x00, 0x2e, 0x00, 0x2e, 0x00, 0x6e, 0x00, 0x6e, 0x00, 0x20,
	0x00, 0x73, 0x00, 0x69, 0x00, 0x20, 0x00, 0x72, 0x00, 0x69, 0x00, 0x73, 0x00, 0x70, 0x00, 0x6f,
	0x00, 0x6e, 0x00, 0x64, 0x00, 0x65, 0x00, 0x20, 0x00, 0x70, 0x00, 0x69, 0x00, 0xf9, 0x00, 0x20,
	0x00, 0x61, 0x00, 0x69, 0x00, 0x20, 0x00, 0x6d, 0x00, 0x65, 0x00, 0x73, 0x00, 0x73, 0x00, 0x61,
	0x00, 0x67, 0x00, 0x69, 0x00, 0x3f, 0x00, 0x21, 0x00, 0x20, 0x00, 0x43, 0x00, 0x61, 0x00, 0x67,
	0x00, 0x61, 0x00, 0x74, 0x00, 0x69, 0x00, 0x2e, 0x00, 0x20, 0x00, 0x42, 0x00, 0x75, 0x00, 0x6f,
	0x00, 0x6e, 0x00, 0x61, 0x00, 0x20, 0x00, 0x00
	};

/* This is not part of API! */
extern GSM_Error N6510_DecodeFilesystemSMS(GSM_StateMachine *s, GSM_MultiSMSMessage *sms, GSM_File *FFF, int location);

int main(int argc UNUSED, char **argv UNUSED)
{
	GSM_Debug_Info *debug_info;
	GSM_StateMachine *s;
	GSM_File file;
	GSM_Error error;
	GSM_MultiSMSMessage sms;
	size_t len;

	debug_info = GSM_GetGlobalDebug();
	GSM_SetDebugFileDescriptor(stderr, FALSE, debug_info);
	GSM_SetDebugLevel("textall", debug_info);

	/* Allocates state machine */
	s = GSM_AllocStateMachine();
	test_result (s != NULL);

	debug_info = GSM_GetDebug(s);
	GSM_SetDebugGlobal(TRUE, debug_info);
	GSM_SetDebugFileDescriptor(stderr, FALSE, debug_info);
	GSM_SetDebugLevel("textall", debug_info);

	/* Init file */
	file.Buffer = malloc(sizeof(data));
	memcpy(file.Buffer, data, sizeof(data));
	file.Used = sizeof(data);
	file.ID_FullName[0] = 0;
	file.ID_FullName[1] = 0;
	GSM_GetCurrentDateTime(&(file.Modified));

	/* Parse it */
	error = N6510_DecodeFilesystemSMS(s, &sms, &file, 0);

	/* Check expected text */
	len = UnicodeLength(sms.SMS[0].Text);
	if (len > (sizeof(message) / 2) - 1) len = (sizeof(message) / 2) - 1;
	test_result(mywstrncmp(sms.SMS[0].Text, message, len) == TRUE);

	/* Display message */
	DisplayMultiSMSInfo(&sms, FALSE, TRUE, NULL, NULL);
	DisplayMultiSMSInfo(&sms, TRUE, TRUE, NULL, NULL);

	/* Free state machine */
	GSM_FreeStateMachine(s);

	gammu_test_result(error, "N6510_DecodeFilesystemSMS");

	return 0;
}

/* Editor configuration
 * vim: noexpandtab sw=8 ts=8 sts=8 tw=72:
 */
