/******************************************
 *
 * $GAMGI/src/chem/gamgi_chem_orbital.h
 *
 * Copyright (C) 2012 Carlos Pereira
 *
 * Distributed under the terms of the GNU
 * General Public License: $GAMGI/LICENSE
 *
 */

/**********************
 * internal functions *
 **********************

static double static_radial_1s (double r);

static double static_radial_2s (double r);
static double static_radial_2p (double r);

static double static_radial_3s (double r);
static double static_radial_3p (double r);
static double static_radial_3d (double r);

static double static_radial_4s (double r);
static double static_radial_4p (double r);
static double static_radial_4d (double r);
static double static_radial_4f (double r);

static double static_radial_5s (double r);
static double static_radial_5p (double r);
static double static_radial_5d (double r);
static double static_radial_5f (double r);
static double static_radial_5g (double r);

static double static_radial_6s (double r);
static double static_radial_6p (double r);
static double static_radial_6d (double r);
static double static_radial_6f (double r);
static double static_radial_6g (double r);
static double static_radial_6h (double r);

static void static_radial (int n, int l, double *c, gamgi_radial *f);

static double static_angular_s (double x, double y, double z, double r);

static double static_angular_pz (double x, double y, double z, double r);
static double static_angular_px (double x, double y, double z, double r);
static double static_angular_py (double x, double y, double z, double r);

static double static_angular_dz2 (double x, double y, double z, double r);
static double static_angular_dxz (double x, double y, double z, double r);
static double static_angular_dyz (double x, double y, double z, double r);
static double static_angular_dx2_y2 (double x, double y, double z, double r);
static double static_angular_dxy (double x, double y, double z, double r);

static double static_angular_fz3 (double x, double y, double z, double r);
static double static_angular_fxz2 (double x, double y, double z, double r);
static double static_angular_fyz2 (double x, double y, double z, double r);
static double static_angular_fz_x2_y2 (double x, double y, double z, double r);
static double static_angular_fxyz (double x, double y, double z, double r);
static double static_angular_fx_x2_3y2 (double x, double y, double z, double r);
static double static_angular_fy_3x2_y2 (double x, double y, double z, double r);

static double static_angular_gz4 (double x, double y, double z, double r);
static double static_angular_gz3x (double x, double y, double z, double r);
static double static_angular_gz3y (double x, double y, double z, double r);
static double static_angular_gz2_x2_y2 (double x, double y, double z, double r);
static double static_angular_gz2_xy (double x, double y, double z, double r);
static double static_angular_gzx3 (double x, double y, double z, double r);
static double static_angular_gzy3 (double x, double y, double z, double r);
static double static_angular_gx4_y4 (double x, double y, double z, double r);
static double static_angular_gxy_x2_y2 (double x, double y, double z, double r);

static double static_angular_hz5 (double x, double y, double z, double r);
static double static_angular_hz4x (double x, double y, double z, double r);
static double static_angular_hz4y (double x, double y, double z, double r);
static double static_angular_hz3_x2_y2 (double x, double y, double z, double r);
static double static_angular_hz3_xy (double x, double y, double z, double r);
static double static_angular_hz2x3 (double x, double y, double z, double r);
static double static_angular_hz2y3 (double x, double y, double z, double r);
static double static_angular_hz_x4_y4 (double x, double y, double z, double r);
static double static_angular_hxyz_x2_y2 (double x, double y, double z, double r);
static double static_angular_hx5 (double x, double y, double z, double r);
static double static_angular_hy5 (double x, double y, double z, double r);

static void static_angular (int l, int m, double *c, gamgi_angular *f);

 **********************
 * external functions *
 **********************/

void gamgi_chem_orbital_m (int l, gamgi_bool *sensitive);

void gamgi_chem_orbital_l (int n, gamgi_bool *sensitive);

int gamgi_chem_orbital_points (int n);

double gamgi_chem_orbital_radius (int n, int l, int m, double charge);

gamgi_bool gamgi_chem_orbital_create (gamgi_orbital *orbital,
int *octants, int seed);

/*************
 * Rationale *
 *************

Implemented with dotted model. Oct 2012.

 *************
 * Rationale *
 *************/
