/**********************************************
 *
 * $GAMGI/src/gtk/plane/gamgi_gtk_plane_list.c
 *
 * Copyright (C) 2006 Carlos Pereira
 *
 * Distributed under the terms of the GNU
 * General Public License: $GAMGI/LICENSE
 *
 */

#include "gamgi_engine.h"
#include "gamgi_gtk.h"
#include "gamgi_phys.h"
#include "gamgi_io.h"

#include "gamgi_gtk_dialog.h"
#include "gamgi_gtk_object.h"
#include "gamgi_gtk_cell_symmetry.h"
#include "gamgi_gtk_plane_create.h"
#include "gamgi_gtk_plane_list.h"
#include "gamgi_math_node.h"
#include "gamgi_phys_plane.h"
#include "gamgi_phys_direction.h"
#include "gamgi_io_token.h"

static struct {

/******************************
 * indicates if the structure *
 * is currently being used    *
 ******************************/

gamgi_bool active;
int n_list;
int *list; } node;

static void static_delete (GtkWidget *widget,
GdkEventButton *event, void *data)
{
gamgi_gtk_plane_list_cancel (widget, data);
}

static void static_ok (GtkWidget *widget, void *data)
{
}

static void static_init (gamgi_window *window)
{
}

static void static_create (gamgi_window *window)
{
GtkWidget *dialog;
GtkWidget *scrolled_window;
GtkWidget *frame;
GtkWidget *button;
GtkWidget *label;
GtkWidget *table;
GtkWidget *vbox_dialog, *vbox_frame, *vbox_center, *vbox_top, *vbox_top_top;
GtkWidget *hbox_center, *hbox_left;
GtkAdjustment *adjustment;
GtkWidget *treeview;
GtkCellRenderer *renderer;
GtkTreeViewColumn *column;

dialog = gamgi_gtk_dialog_task1_create ("Plane List", window);
gtk_container_set_border_width (GTK_CONTAINER (dialog), 5);
g_signal_connect (dialog, "delete_event",
G_CALLBACK (static_delete), window);

vbox_dialog = gtk_vbox_new (FALSE, 5);
gtk_container_add (GTK_CONTAINER (dialog), vbox_dialog);
gtk_widget_show (vbox_dialog);

/********
 * List *
 ********/

vbox_frame = gtk_vbox_new (FALSE, 5);
gtk_box_pack_start (GTK_BOX (vbox_dialog), vbox_frame, TRUE, TRUE, 0);
gtk_container_set_border_width (GTK_CONTAINER (vbox_frame), 5);
gtk_widget_show (vbox_frame);

frame = gtk_frame_new (NULL);
gtk_box_pack_start (GTK_BOX (vbox_frame), frame, TRUE, TRUE, 0);
gtk_frame_set_label (GTK_FRAME (frame), " List ");
gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_ETCHED_IN);
gtk_widget_show (frame);

hbox_center = gtk_hbox_new (TRUE, 5);
gtk_container_add (GTK_CONTAINER (frame), hbox_center);
gtk_container_set_border_width (GTK_CONTAINER (hbox_center), 5);
gtk_widget_show (hbox_center);

hbox_left = gtk_hbox_new (FALSE, 5);
gtk_box_pack_start (GTK_BOX (hbox_center), hbox_left, TRUE, TRUE, 0);
gtk_widget_show (hbox_left);

frame = gtk_frame_new (NULL);
gtk_box_pack_start (GTK_BOX (hbox_left), frame, TRUE, TRUE, 0);
gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_ETCHED_IN);
gtk_widget_show (frame);

scrolled_window = gtk_scrolled_window_new (NULL, NULL);
gtk_container_add (GTK_CONTAINER (frame), scrolled_window);
gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled_window),
GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
gtk_widget_show (scrolled_window);

treeview = gtk_tree_view_new ();
gtk_container_add (GTK_CONTAINER (scrolled_window), treeview);
gtk_widget_set_size_request (treeview, 100, 150);
g_object_set_data (G_OBJECT (dialog), "treeview", treeview);
gtk_widget_show (treeview);

renderer = gtk_cell_renderer_text_new ();
column = gtk_tree_view_column_new_with_attributes ("Subject", renderer, "text", 0, NULL);
gtk_tree_view_append_column (GTK_TREE_VIEW (treeview), column);

renderer = gtk_cell_renderer_text_new ();
column = gtk_tree_view_column_new_with_attributes ("List", renderer, "text", 0, NULL);
gtk_tree_view_append_column (GTK_TREE_VIEW (treeview), column);
gtk_tree_view_set_headers_visible (GTK_TREE_VIEW (treeview), TRUE);

/********************
 * Include, Exclude *
 ********************/

vbox_center = gtk_vbox_new (TRUE, 0);
gtk_box_pack_start (GTK_BOX (hbox_left), vbox_center, FALSE, FALSE, 20);
gtk_widget_show (vbox_center);

vbox_top = gtk_vbox_new (FALSE, 10);
gtk_box_pack_start (GTK_BOX (vbox_center), vbox_top, FALSE, FALSE, 0);
gtk_widget_show (vbox_top);

vbox_top_top = gtk_vbox_new (FALSE, 5);
gtk_box_pack_start (GTK_BOX (vbox_top), vbox_top_top, FALSE, FALSE, 0);
gtk_widget_show (vbox_top_top);

label = gtk_label_new ("Include");
gtk_box_pack_start (GTK_BOX (vbox_top_top), label, FALSE, FALSE, 0);
gtk_widget_show (label);

button = gtk_button_new_with_label ("<");
gtk_box_pack_start (GTK_BOX (vbox_top_top), button, FALSE, FALSE, 0);
gtk_widget_set_size_request (button, 20, 25);
gtk_widget_show (button);

vbox_top_top = gtk_vbox_new (FALSE, 5);
gtk_box_pack_start (GTK_BOX (vbox_top), vbox_top_top, FALSE, FALSE, 0);
gtk_widget_show (vbox_top_top);

label = gtk_label_new ("Exclude");
gtk_box_pack_start (GTK_BOX (vbox_top_top), label, FALSE, FALSE, 0);
gtk_widget_show (label);

button = gtk_button_new_with_label (">");
gtk_widget_set_size_request (button, 20, 25);
gtk_box_pack_end (GTK_BOX (vbox_top_top), button, FALSE, FALSE, 0);
gtk_widget_show (button);

/***************
 * plane range *
 ***************/

vbox_center = gtk_vbox_new (TRUE, 0);
gtk_box_pack_start (GTK_BOX (hbox_left), vbox_center, FALSE, FALSE, 0);
gtk_widget_show (vbox_center);

vbox_top = gtk_vbox_new (FALSE, 5);
gtk_box_pack_start (GTK_BOX (vbox_center), vbox_top, FALSE, FALSE, 0);
gtk_widget_show (vbox_top);

label = gtk_label_new ("Max");
gtk_box_pack_start (GTK_BOX (vbox_top), label, FALSE, FALSE, 0);
gtk_widget_show (label);

table = gtk_table_new (3, 6, FALSE);
gtk_box_pack_start (GTK_BOX (vbox_top), table, FALSE, FALSE, 0);
gtk_widget_show (table);

adjustment = (GtkAdjustment *) gtk_adjustment_new (1.0, -1000, 1000, 1.0, 0, 0);
button = gtk_spin_button_new (adjustment, 1.0, 0);
gtk_table_attach (GTK_TABLE (table), button, 0, 1, 0, 1, GTK_EXPAND, GTK_FILL, 0, 0);
gtk_spin_button_set_digits (GTK_SPIN_BUTTON (button), 0);
g_object_set_data (G_OBJECT (dialog), "button_max_h", button);
gtk_widget_show (button);

adjustment = (GtkAdjustment *) gtk_adjustment_new (1.0, -1000, 1000, 1.0, 0, 0);
button = gtk_spin_button_new (adjustment, 1.0, 0);
gtk_table_attach (GTK_TABLE (table), button, 2, 3, 0, 1, GTK_EXPAND, GTK_FILL, 5, 0);
gtk_spin_button_set_digits (GTK_SPIN_BUTTON (button), 0);
g_object_set_data (G_OBJECT (dialog), "button_max_k", button);
gtk_widget_show (button);

adjustment = (GtkAdjustment *) gtk_adjustment_new (1.0, -1000, 1000, 1.0, 0, 0);
button = gtk_spin_button_new (adjustment, 1.0, 0);
gtk_table_attach (GTK_TABLE (table), button, 4, 5, 0, 1, GTK_EXPAND, GTK_EXPAND, 0, 0);
gtk_spin_button_set_digits (GTK_SPIN_BUTTON (button), 0);
g_object_set_data (G_OBJECT (dialog), "button_max_l", button);
gtk_widget_show (button);

label = gtk_label_new ("H");
gtk_table_attach (GTK_TABLE (table), label, 0, 1, 1, 2, GTK_FILL, GTK_FILL, 0, 0);
gtk_widget_show (label);

label = gtk_label_new ("K");
gtk_table_attach (GTK_TABLE (table), label, 2, 3, 1, 2, GTK_FILL, GTK_FILL, 0, 5);
gtk_widget_show (label);

label = gtk_label_new ("L");
gtk_table_attach (GTK_TABLE (table), label, 4, 5, 1, 2, GTK_FILL, GTK_FILL, 0, 0);
gtk_widget_show (label);

adjustment = (GtkAdjustment *) gtk_adjustment_new (0.0, -1000, 1000, 1.0, 0, 0);
button = gtk_spin_button_new (adjustment, 1.0, 0);
gtk_table_attach (GTK_TABLE (table), button, 0, 1, 2, 3, GTK_EXPAND, GTK_FILL, 0, 0);
gtk_spin_button_set_digits (GTK_SPIN_BUTTON (button), 0);
g_object_set_data (G_OBJECT (dialog), "button_min_h", button);
gtk_widget_show (button);

adjustment = (GtkAdjustment *) gtk_adjustment_new (0.0, -1000, 1000, 1.0, 0, 0);
button = gtk_spin_button_new (adjustment, 1.0, 0);
gtk_table_attach (GTK_TABLE (table), button, 2, 3, 2, 3, GTK_EXPAND, GTK_FILL, 5, 0);
gtk_spin_button_set_digits (GTK_SPIN_BUTTON (button), 0);
g_object_set_data (G_OBJECT (dialog), "button_min_k", button);
gtk_widget_show (button);

adjustment = (GtkAdjustment *) gtk_adjustment_new (0.0, -1000, 1000, 1.0, 0, 0);
button = gtk_spin_button_new (adjustment, 1.0, 0);
gtk_table_attach (GTK_TABLE (table), button, 4, 5, 2, 3, GTK_EXPAND, GTK_EXPAND, 0, 0);
gtk_spin_button_set_digits (GTK_SPIN_BUTTON (button), 0);
g_object_set_data (G_OBJECT (dialog), "button_min_l", button);
gtk_widget_show (button);

label = gtk_label_new ("Min");
gtk_box_pack_start (GTK_BOX (vbox_top), label, FALSE, FALSE, 0);
gtk_widget_show (label);

/*********************
 * Ok/Cancel buttons *
 *********************/

hbox_center = gtk_hbox_new (TRUE, 0);
gtk_box_pack_start (GTK_BOX (vbox_dialog), hbox_center, FALSE, FALSE, 0);
gtk_widget_show (hbox_center);

button = gamgi_gtk_dialog_button_create ("Ok", NULL);
gtk_widget_set_size_request (button, GAMGI_GTK_BUTTON_WIDTH, -1);
gtk_box_pack_start (GTK_BOX (hbox_center), button, FALSE, FALSE, 0);
g_signal_connect (button, "clicked",
G_CALLBACK (static_ok), window);
gtk_widget_show (button);

button = gamgi_gtk_dialog_button_create ("Cancel", "red");
gtk_widget_set_size_request (button, GAMGI_GTK_BUTTON_WIDTH, -1);
gtk_box_pack_start (GTK_BOX (hbox_center), button, FALSE, FALSE, 0);
gtk_widget_grab_focus (button);
g_signal_connect (button, "clicked",
G_CALLBACK (gamgi_gtk_plane_list_cancel), window);
gtk_widget_show (button);

static_init (window);
gtk_widget_show (dialog);
}

void gamgi_gtk_plane_list_start (void *data)
{
node.active = FALSE;
}

void gamgi_gtk_plane_list_cancel (GtkWidget *widget, void *data)
{
gamgi_window *window = GAMGI_CAST_WINDOW data;
GtkWidget *dialog = window->dialog0;
GtkWidget *button;

gamgi_gtk_dialog_task1_remove (widget, window);

/***********************************
 * if no data has been submited,   *
 * the default is the range button *
 ***********************************/

if (node.active == FALSE)
  {
  button = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "button_set");
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (button), FALSE);
  }
}

gamgi_bool gamgi_gtk_plane_list_get (gamgi_cell *cell, 
int *o1, int *o2, int *o3, gamgi_window *window)
{
/**************************************************
 * return FALSE if node information is not active *
 **************************************************/

if (node.active == FALSE) return FALSE;

/********************
 * export node data *
 ********************/

return TRUE;
}

void gamgi_gtk_plane_list (GtkWidget *widget, void *data)
{
gamgi_window *window = GAMGI_CAST_WINDOW data;
GtkWidget *dialog = window->dialog0;
GtkWidget *button;

button = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "button_set");
if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (button)) == TRUE)
  {
  /******************************
   * create second level dialog *
   ******************************/

  static_create (window);
  }
else
  {
  /***********************************
   *   remove second level dialog    *
   *                                 *
   * restart Order data, if disabled *
   ***********************************/

  if (window->dialog1 != NULL)
    gamgi_gtk_dialog_task1_remove (widget, window);

  if (node.active == TRUE)
    { 
    node.active = FALSE;
    gamgi_gtk_plane_create_range (TRUE, window);
    }
  }
}
