/*************************************************
 *
 * $GAMGI/src/gtk/plane/gamgi_gtk_plane_select.c
 *
 * Copyright (C) Carlos Pereira
 *
 * Distributed under the terms of the GNU
 * General Public License: $GAMGI/LICENSE
 *
 */

#include "gamgi_engine.h"
#include "gamgi_gtk.h"

#include "gamgi_engine_list.h"
#include "gamgi_engine_dlist.h"
#include "gamgi_gtk_select.h"
#include "gamgi_gtk_dialog.h"
#include "gamgi_mesa_select.h"

static void static_ok (GtkWidget *widget, void *data)
{
gamgi_window *window = GAMGI_CAST_WINDOW data;

printf ("handle plane select ok\n");
gamgi_gtk_dialog_task0_remove (widget, window);
}

void gamgi_gtk_plane_select_press (gamgi_window *window_mouse,    
GdkEventButton *event, int x, int y, gamgi_window *window_dialog)
{
/******************************
 * local mouse selection only *
 ******************************/

if (window_dialog != window_mouse) return;
gamgi_mesa_select_object (window_mouse, x, y, GAMGI_ENGINE_PLANE, FALSE, NULL);
}

void gamgi_gtk_plane_select (GtkWidget *widget, void *data)
{
gamgi_window *window = GAMGI_CAST_WINDOW data;
GtkWidget *dialog;
GtkWidget *treeview;
GtkTreeStore *store;
gamgi_dlist *dlist;

dialog = gamgi_gtk_dialog_task0_create ("Plane Select", window);
window->action = GAMGI_GTK_PLANE_SELECT;

treeview = gamgi_gtk_select_dialog (window, static_ok); 
store = gtk_tree_store_new (2, G_TYPE_STRING, G_TYPE_POINTER);

dlist = gamgi_engine_dlist_plane_gamgi (NULL);
while (dlist != NULL)
  {
  gamgi_gtk_select_plane (store, NULL, GAMGI_CAST_PLANE dlist->data);
  dlist = gamgi_engine_dlist_remove_start (dlist);
  }

gtk_tree_view_set_model (GTK_TREE_VIEW (treeview), GTK_TREE_MODEL (store));
g_object_unref (store);

gtk_widget_show (dialog);
}
