/*************************************************
 *
 * $GAMGI/src/gtk/light/gamgi_gtk_light_modify.c
 *
 * Copyright (C) 2004 Carlos Pereira
 *
 * Distributed under the terms of the GNU
 * General Public License: $GAMGI/LICENSE
 *
 */

#include "gamgi_engine.h"
#include "gamgi_gtk.h"
#include "gamgi_mesa.h"
#include "gamgi_math.h"
#include "gamgi_global.h"

#include "gamgi_engine_find.h"
#include "gamgi_gtk_dialog.h"
#include "gamgi_gtk_history.h"
#include "gamgi_gtk_object.h"
#include "gamgi_gtk_statusbar.h"
#include "gamgi_mesa_select.h"
#include "gamgi_io_token.h"

static void static_light (gamgi_window *window)
{
GtkWidget *dialog = window->dialog0;
GtkWidget *label_position, *label_direction, *label_angle;
GtkWidget *entry_position_x, *entry_position_y, *entry_position_z;
GtkWidget *entry_direction_x, *entry_direction_y, *entry_direction_z;
GtkWidget *entry_angle;
GtkWidget *label_axial, *label_radial;
GtkWidget *label_constant, *label_linear, *label_quadratic;
GtkWidget *entry_constant, *entry_linear, *entry_quadratic;
GtkWidget *entry_radial;
GtkWidget *combo;
int row;

label_position = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "label_position");
entry_position_x = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "entry_position_x");
entry_position_y = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "entry_position_y");
entry_position_z = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "entry_position_z");

label_direction = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "label_direction");
entry_direction_x = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "entry_direction_x");
entry_direction_y = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "entry_direction_y");
entry_direction_z = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "entry_direction_z");

label_angle = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "label_angle");
entry_angle = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "entry_angle");

label_axial = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "label_axial");
label_constant = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "label_constant");
label_linear = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "label_linear");
label_quadratic = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "label_quadratic");
entry_constant = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "entry_constant");
entry_linear = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "entry_linear");
entry_quadratic = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "entry_quadratic");

label_radial = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "label_radial");
entry_radial = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "entry_radial");

combo = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "combo_light");
row = gtk_combo_box_get_active (GTK_COMBO_BOX (combo));

/*********************
 * directional light *
 *********************/

if (row == GAMGI_MESA_DIRECTIONAL - 1)
  {
  gtk_widget_set_sensitive (label_direction, TRUE);
  gtk_widget_set_sensitive (entry_direction_x, TRUE);
  gtk_widget_set_sensitive (entry_direction_y, TRUE);
  gtk_widget_set_sensitive (entry_direction_z, TRUE);

  gtk_widget_set_sensitive (label_position, FALSE);
  gtk_entry_set_text (GTK_ENTRY (entry_position_x), "");
  gtk_entry_set_text (GTK_ENTRY (entry_position_y), "");
  gtk_entry_set_text (GTK_ENTRY (entry_position_z), "");
  gtk_widget_set_sensitive (entry_position_x, FALSE);
  gtk_widget_set_sensitive (entry_position_y, FALSE);
  gtk_widget_set_sensitive (entry_position_z, FALSE);

  gtk_widget_set_sensitive (label_angle, FALSE);
  gtk_entry_set_text (GTK_ENTRY (entry_angle), "");
  gtk_widget_set_sensitive (entry_angle, FALSE);

  gtk_widget_set_sensitive (label_axial, FALSE);
  gtk_widget_set_sensitive (label_constant, FALSE);
  gtk_widget_set_sensitive (label_linear, FALSE);
  gtk_widget_set_sensitive (label_quadratic, FALSE);
  gtk_entry_set_text (GTK_ENTRY (entry_constant), "");
  gtk_entry_set_text (GTK_ENTRY (entry_linear), "");
  gtk_entry_set_text (GTK_ENTRY (entry_quadratic), "");
  gtk_widget_set_sensitive (entry_constant, FALSE);
  gtk_widget_set_sensitive (entry_linear, FALSE);
  gtk_widget_set_sensitive (entry_quadratic, FALSE);

  gtk_widget_set_sensitive (label_radial, FALSE);
  gtk_entry_set_text (GTK_ENTRY (entry_radial), "");
  gtk_widget_set_sensitive (entry_radial, FALSE);
  }

/********************
 * positional light *
 ********************/

else if (row == GAMGI_MESA_POSITIONAL - 1)
  {
  gtk_widget_set_sensitive (label_direction, FALSE);
  gtk_entry_set_text (GTK_ENTRY (entry_direction_x), "");
  gtk_entry_set_text (GTK_ENTRY (entry_direction_y), "");
  gtk_entry_set_text (GTK_ENTRY (entry_direction_z), "");
  gtk_widget_set_sensitive (entry_direction_x, FALSE);
  gtk_widget_set_sensitive (entry_direction_y, FALSE);
  gtk_widget_set_sensitive (entry_direction_z, FALSE);

  gtk_widget_set_sensitive (label_position, TRUE);
  gtk_widget_set_sensitive (entry_position_x, TRUE);
  gtk_widget_set_sensitive (entry_position_y, TRUE);
  gtk_widget_set_sensitive (entry_position_z, TRUE);

  gtk_widget_set_sensitive (label_angle, FALSE);
  gtk_entry_set_text (GTK_ENTRY (entry_angle), "");
  gtk_widget_set_sensitive (entry_angle, FALSE);

  gtk_widget_set_sensitive (label_axial, TRUE);
  gtk_widget_set_sensitive (label_constant, TRUE);
  gtk_widget_set_sensitive (label_linear, TRUE);
  gtk_widget_set_sensitive (label_quadratic, TRUE);
  gtk_widget_set_sensitive (entry_constant, TRUE);
  gtk_widget_set_sensitive (entry_linear, TRUE);
  gtk_widget_set_sensitive (entry_quadratic, TRUE);

  gtk_widget_set_sensitive (label_radial, FALSE);
  gtk_entry_set_text (GTK_ENTRY (entry_radial), "");
  gtk_widget_set_sensitive (entry_radial, FALSE);
  }

/**************
 * spot light *
 **************/

else if (row == GAMGI_MESA_SPOT - 1)
  {
  gtk_widget_set_sensitive (label_direction, TRUE);
  gtk_widget_set_sensitive (entry_direction_x, TRUE);
  gtk_widget_set_sensitive (entry_direction_y, TRUE);
  gtk_widget_set_sensitive (entry_direction_z, TRUE);

  gtk_widget_set_sensitive (label_position, TRUE);
  gtk_widget_set_sensitive (entry_position_x, TRUE);
  gtk_widget_set_sensitive (entry_position_y, TRUE);
  gtk_widget_set_sensitive (entry_position_z, TRUE);

  gtk_widget_set_sensitive (label_angle, TRUE);
  gtk_widget_set_sensitive (entry_angle, TRUE);

  gtk_widget_set_sensitive (label_axial, TRUE);
  gtk_widget_set_sensitive (label_constant, TRUE);
  gtk_widget_set_sensitive (label_linear, TRUE);
  gtk_widget_set_sensitive (label_quadratic, TRUE);
  gtk_widget_set_sensitive (entry_constant, TRUE);
  gtk_widget_set_sensitive (entry_linear, TRUE);
  gtk_widget_set_sensitive (entry_quadratic, TRUE);

  gtk_widget_set_sensitive (label_radial, TRUE);
  gtk_widget_set_sensitive (entry_radial, TRUE);
  }

/***************
 * local light *
 ***************/

else
  {
  gtk_widget_set_sensitive (label_direction, TRUE);
  gtk_widget_set_sensitive (entry_direction_x, TRUE);
  gtk_widget_set_sensitive (entry_direction_y, TRUE);
  gtk_widget_set_sensitive (entry_direction_z, TRUE);
  gtk_entry_set_text (GTK_ENTRY (entry_direction_x), "");
  gtk_entry_set_text (GTK_ENTRY (entry_direction_y), "");
  gtk_entry_set_text (GTK_ENTRY (entry_direction_z), "");

  gtk_widget_set_sensitive (label_position, TRUE);
  gtk_widget_set_sensitive (entry_position_x, TRUE);
  gtk_widget_set_sensitive (entry_position_y, TRUE);
  gtk_widget_set_sensitive (entry_position_z, TRUE);
  gtk_entry_set_text (GTK_ENTRY (entry_position_x), "");
  gtk_entry_set_text (GTK_ENTRY (entry_position_y), "");
  gtk_entry_set_text (GTK_ENTRY (entry_position_z), "");

  gtk_widget_set_sensitive (label_angle, TRUE);
  gtk_widget_set_sensitive (entry_angle, TRUE);
  gtk_entry_set_text (GTK_ENTRY (entry_angle), "");

  gtk_widget_set_sensitive (label_axial, TRUE);
  gtk_widget_set_sensitive (label_constant, TRUE);
  gtk_widget_set_sensitive (label_linear, TRUE);
  gtk_widget_set_sensitive (label_quadratic, TRUE);
  gtk_widget_set_sensitive (entry_constant, TRUE);
  gtk_widget_set_sensitive (entry_linear, TRUE);
  gtk_widget_set_sensitive (entry_quadratic, TRUE);
  gtk_entry_set_text (GTK_ENTRY (entry_constant), "");
  gtk_entry_set_text (GTK_ENTRY (entry_linear), "");
  gtk_entry_set_text (GTK_ENTRY (entry_quadratic), "");

  gtk_widget_set_sensitive (label_radial, TRUE);
  gtk_widget_set_sensitive (entry_radial, TRUE);
  gtk_entry_set_text (GTK_ENTRY (entry_radial), "");
  }
}

static void static_default (GtkWidget *widget, void *data)
{
gamgi_window *window = GAMGI_CAST_WINDOW data;
GtkWidget *dialog = window->dialog0;
GtkWidget *entry;
GtkWidget *combo;
char token[GAMGI_ENGINE_TOKEN];
int row;

/***********************
 * update light status *
 ***********************/

static_light (window);

/******************
 * get light menu *
 ******************/

combo = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "combo_light");
row = gtk_combo_box_get_active (GTK_COMBO_BOX (combo));

/***********************
 * set widget defaults *
 ***********************/

if (row == GAMGI_MESA_DIRECTIONAL - 1 || row == GAMGI_MESA_SPOT - 1)
  {
  entry = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "entry_direction_x");
  sprintf (token, "%.*f", gamgi->gamgi->length, GAMGI_MESA_LIGHT_DIRECTION_X);
  gtk_entry_set_text (GTK_ENTRY (entry), token);

  entry = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "entry_direction_y");
  sprintf (token, "%.*f", gamgi->gamgi->length, GAMGI_MESA_LIGHT_DIRECTION_Y);
  gtk_entry_set_text (GTK_ENTRY (entry), token);

  entry = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "entry_direction_z");
  sprintf (token, "%.*f", gamgi->gamgi->length, GAMGI_MESA_LIGHT_DIRECTION_Z);
  gtk_entry_set_text (GTK_ENTRY (entry), token);
  }

if (row == GAMGI_MESA_POSITIONAL - 1 || row == GAMGI_MESA_SPOT - 1)
  {
  entry = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "entry_position_x");
  sprintf (token, "%.*f", gamgi->gamgi->length, GAMGI_MESA_LIGHT_POSITION_X);
  gtk_entry_set_text (GTK_ENTRY (entry), token);

  entry = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "entry_position_y");
  sprintf (token, "%.*f", gamgi->gamgi->length, GAMGI_MESA_LIGHT_POSITION_Y);
  gtk_entry_set_text (GTK_ENTRY (entry), token);

  entry = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "entry_position_z");
  sprintf (token, "%.*f", gamgi->gamgi->length, GAMGI_MESA_LIGHT_POSITION_Z);
  gtk_entry_set_text (GTK_ENTRY (entry), token);

  entry = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "entry_constant");
  sprintf (token, "%.*f", GAMGI_MATH_DECIMAL_ATTENUATION,
  (float) GAMGI_MESA_LIGHT_CONSTANT);
  gtk_entry_set_text (GTK_ENTRY (entry), token);

  entry = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "entry_linear");
  sprintf (token, "%.*f", GAMGI_MATH_DECIMAL_ATTENUATION,
  (float) GAMGI_MESA_LIGHT_LINEAR);
  gtk_entry_set_text (GTK_ENTRY (entry), token);

  entry = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "entry_quadratic");
  sprintf (token, "%.*f", GAMGI_MATH_DECIMAL_ATTENUATION,
  (float) GAMGI_MESA_LIGHT_QUADRATIC);
  gtk_entry_set_text (GTK_ENTRY (entry), token);
  }

if (row == GAMGI_MESA_SPOT - 1)
  {
  entry = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "entry_angle");
  sprintf (token, "%.*f", gamgi->gamgi->angle, 
  (float) GAMGI_MESA_LIGHT_ANGLE);
  gtk_entry_set_text (GTK_ENTRY (entry), token);

  entry = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "entry_radial");
  sprintf (token, "%.*f", GAMGI_MATH_DECIMAL_ATTENUATION,
  (float) GAMGI_MESA_LIGHT_RADIAL);
  gtk_entry_set_text (GTK_ENTRY (entry), token);
  }

}

/********************* internal function ****************
 *                                                      *
 *                        STATIC_RESET                  *
 *                                                      *
 * Reset the light modify dialog, cleaning all entries. *
 *                                                      *
 ********************************************************/

static void static_reset (gamgi_window *window)
{
GtkWidget *dialog = window->dialog0;
GtkEntry *entry;
GtkWidget *combo;

/****************
 * reset colors *
 ****************/

entry = (GtkEntry *) g_object_get_data (G_OBJECT (dialog), "entry_ambient_r");
gtk_entry_set_text (entry, "");
entry = (GtkEntry *) g_object_get_data (G_OBJECT (dialog), "entry_ambient_g");
gtk_entry_set_text (entry, "");
entry = (GtkEntry *) g_object_get_data (G_OBJECT (dialog), "entry_ambient_b");
gtk_entry_set_text (entry, "");

entry = (GtkEntry *) g_object_get_data (G_OBJECT (dialog), "entry_diffuse_r");
gtk_entry_set_text (entry, ""); 
entry = (GtkEntry *) g_object_get_data (G_OBJECT (dialog), "entry_diffuse_g");
gtk_entry_set_text (entry, "");
entry = (GtkEntry *) g_object_get_data (G_OBJECT (dialog), "entry_diffuse_b");
gtk_entry_set_text (entry, "");

entry = (GtkEntry *) g_object_get_data (G_OBJECT (dialog), "entry_specular_r");
gtk_entry_set_text (entry, "");
entry = (GtkEntry *) g_object_get_data (G_OBJECT (dialog), "entry_specular_g");
gtk_entry_set_text (entry, "");
entry = (GtkEntry *) g_object_get_data (G_OBJECT (dialog), "entry_specular_b");
gtk_entry_set_text (entry, "");

/***************
 * reset light *
 ***************/

entry = (GtkEntry *) g_object_get_data (G_OBJECT (dialog), "entry_light");
gtk_entry_set_text (entry, "");

combo = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "combo_light");
gtk_combo_box_set_active (GTK_COMBO_BOX (combo), 3);

/*******************************
 * reset geometry, attenuation *
 *******************************/

static_default (NULL, window);
}

/************ internal function *************
 *                                          *
 *               STATIC_GLOBAL              *
 *                                          *
 * Makes the light entry sensitive when the *
 * local button is pressed and insensitive  *
 * when the global button is pressed.       *
 *                                          *
 ********************************************/

static void static_global (GtkWidget *widget, void *data)
{
gamgi_window *window = GAMGI_CAST_WINDOW data;
GtkWidget *dialog = window->dialog0;
GtkWidget *hbox, *button;

hbox = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "hbox_light");
button = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "button_global");

if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (button)) == FALSE)
  {
  /*****************************
   * Choose the Light directly *
   *****************************/

  gtk_widget_set_sensitive (hbox, TRUE);
  }
else
  {
  /*********************************************
   * Choose the Light List previously selected *
   *********************************************/

  static_reset (window);
  gtk_widget_set_sensitive (hbox, FALSE);
  }
}


static void static_ok (GtkWidget *widget, void *data)
{
gamgi_window *window = GAMGI_CAST_WINDOW data;
gamgi_light *light;
GtkWidget *dialog = window->dialog0;
GtkWidget *button;
GtkEntry *entry;
GtkWidget *combo;
char token[GAMGI_ENGINE_TOKEN];
const char *name;
const char *name_position_x, *name_position_y, *name_position_z;
const char *name_direction_x, *name_direction_y, *name_direction_z;
const char *name_constant, *name_linear, *name_quadratic;
const char *name_angle, *name_radial;
float ambient_r, ambient_g, ambient_b;
float diffuse_r, diffuse_g, diffuse_b;
float specular_r, specular_g, specular_b;
float position_x, position_y, position_z;
float direction_x, direction_y, direction_z;
float constant, linear, quadratic;
float angle, radial;
gamgi_bool direction, position;
int row;

/******************
 * get light menu *
 ******************/

combo = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "combo_light");
row = gtk_combo_box_get_active (GTK_COMBO_BOX (combo));

/**************************
 * get new light geometry *
 **************************/

entry = (GtkEntry *) g_object_get_data (G_OBJECT (dialog), "entry_position_x");
name_position_x = gtk_entry_get_text (GTK_ENTRY (entry));
entry = (GtkEntry *) g_object_get_data (G_OBJECT (dialog), "entry_position_y");
name_position_y = gtk_entry_get_text (GTK_ENTRY (entry));
entry = (GtkEntry *) g_object_get_data (G_OBJECT (dialog), "entry_position_z");
name_position_z = gtk_entry_get_text (GTK_ENTRY (entry));

entry = (GtkEntry *) g_object_get_data (G_OBJECT (dialog), "entry_direction_x");
name_direction_x = gtk_entry_get_text (GTK_ENTRY (entry));
entry = (GtkEntry *) g_object_get_data (G_OBJECT (dialog), "entry_direction_y");
name_direction_y = gtk_entry_get_text (GTK_ENTRY (entry));
entry = (GtkEntry *) g_object_get_data (G_OBJECT (dialog), "entry_direction_z");
name_direction_z = gtk_entry_get_text (GTK_ENTRY (entry));

entry = (GtkEntry *) g_object_get_data (G_OBJECT (dialog), "entry_angle");
name_angle = gtk_entry_get_text (GTK_ENTRY (entry));

/*****************************
 * get new light attenuation *
 *****************************/

entry = (GtkEntry *) g_object_get_data (G_OBJECT (dialog), "entry_constant");
name_constant = gtk_entry_get_text (GTK_ENTRY (entry));
entry = (GtkEntry *) g_object_get_data (G_OBJECT (dialog), "entry_linear");
name_linear = gtk_entry_get_text (GTK_ENTRY (entry));
entry = (GtkEntry *) g_object_get_data (G_OBJECT (dialog), "entry_quadratic");
name_quadratic = gtk_entry_get_text (GTK_ENTRY (entry));
entry = (GtkEntry *) g_object_get_data (G_OBJECT (dialog), "entry_radial");
name_radial = gtk_entry_get_text (GTK_ENTRY (entry));

button = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "button_global");
if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (button)) == FALSE)
  {
  /****************
   * Local method *
   ****************/

  /**************************************
   * Get name (possibly new) and number *
   **************************************/

  light = GAMGI_CAST_LIGHT gamgi_gtk_object_number (dialog,
  "entry_light", GAMGI_ENGINE_LIGHT, window, token);
  if (light == NULL)
    {
    gamgi_gtk_dialog_message_create ("Error", "Invalid Light Object", window);
    return;
    }

  /*********************************************************************
   * Choosing local mode means that the type of light remains the      *
   * same, so adding data specific for other types cannot be accepted. *
   *********************************************************************/

  if (row == 3)
    {
    /****************************************************************
     * a directional light must have no position,angle,axial,radial *
     ****************************************************************/

    if (light->position[3] == 0.0 &&
    (gamgi_io_token_check (name_position_x) == TRUE ||
    gamgi_io_token_check (name_position_y) == TRUE ||
    gamgi_io_token_check (name_position_z) == TRUE ||
    gamgi_io_token_check (name_angle) == TRUE ||
    gamgi_io_token_check (name_constant) == TRUE ||
    gamgi_io_token_check (name_linear) == TRUE ||
    gamgi_io_token_check (name_quadratic) == TRUE ||
    gamgi_io_token_check (name_radial) == TRUE))
      {
      gamgi_gtk_dialog_message_create ("Error", "Incompatible Light Data", window);
      return;
      }

    /**********************************************************
     * a positional light must have no direction,angle,radial *
     **********************************************************/

    if (light->position[3] == 1.0 && light->angle == 180.0 &&
    (gamgi_io_token_check (name_direction_x) == TRUE ||
    gamgi_io_token_check (name_direction_y) == TRUE ||
    gamgi_io_token_check (name_direction_z) == TRUE ||
    gamgi_io_token_check (name_angle) == TRUE ||
    gamgi_io_token_check (name_radial) == TRUE))
      {
      gamgi_gtk_dialog_message_create ("Error", "Incompatible Light Data", window);
      return;
      }

    }

  /*************************************************
   * get current light data: directional and       *
   * positional data are stored in the same light  *
   * array but come from different dialog entries. *
   *************************************************/
  
  direction_x = light->direction[0];
  direction_y = light->direction[1];
  direction_z = light->direction[2];

  if (light->position[3] == 0)
    {
    direction_x = -light->position[0];
    direction_y = -light->position[1];
    direction_z = -light->position[2];
    }
  else
    {
    position_x = light->position[0];
    position_y = light->position[1];
    position_z = light->position[2];
    }

  angle = light->angle;

  constant = light->constant;
  linear = light->linear;
  quadratic = light->quadratic;
  radial = light->radial;

  ambient_r = light->ambient[0];
  ambient_g = light->ambient[1];
  ambient_b = light->ambient[2];

  diffuse_r = light->diffuse[0];
  diffuse_g = light->diffuse[1];
  diffuse_b = light->diffuse[2];

  specular_r = light->specular[0];
  specular_g = light->specular[1];
  specular_b = light->specular[2];

  /******************************************************
   * changing from a type of light to another:          *
   * new direction and position data might be required. *
   ******************************************************/
 
  direction = FALSE;
  position = FALSE;

  /************************************************************************ 
   * changing from positional to directional light requires new direction *
   ************************************************************************/

  if (light->position[3] == 1.0 && light->angle == 180.0 && 
  row == GAMGI_MESA_DIRECTIONAL - 1) direction = TRUE;
  
  /*****************************************************************
   * changing from positional to spot light requires new direction *
   *****************************************************************/

  if (light->position[3] == 1.0 && light->angle == 180.0 &&
  row == GAMGI_MESA_SPOT - 1) direction = TRUE;

  /******************************************************************
   * changing from spot to directional light requires new direction *
   ******************************************************************/

  if (light->angle != 180.0 && row == GAMGI_MESA_DIRECTIONAL - 1) direction = TRUE;

  /************************************************************
   * changing from directional to spot requires new direction *
   ************************************************************/

  if (light->position[3] == 0.0 && row == GAMGI_MESA_SPOT - 1) direction = TRUE;

  /***********************************************************
   * changing from directional to spot requires new position *
   ***********************************************************/

  if (light->position[3] == 0.0 && row == GAMGI_MESA_SPOT - 1) position = TRUE;

  /*****************************************************************
   * changing from directional to positional requires new position *
   *****************************************************************/

  if (light->position[3] == 0.0 && row == GAMGI_MESA_POSITIONAL - 1) position = TRUE;

  /**************
   * x position *
   **************/

  if ((position == TRUE || gamgi_io_token_check (name_position_x) == TRUE) &&
  gamgi_io_token_float_scan (name_position_x, &position_x, -FLT_MAX, FLT_MAX) == FALSE)
    {
    gamgi_gtk_dialog_message_create ("Error", "Invalid Geometry Data", window);
    return;
    }

  /**************
   * y position *
   **************/

  if ((position == TRUE || gamgi_io_token_check (name_position_y) == TRUE) &&
  gamgi_io_token_float_scan (name_position_y, &position_y, -FLT_MAX, FLT_MAX) == FALSE)
    {
    gamgi_gtk_dialog_message_create ("Error", "Invalid Geometry Data", window);
    return;
    }

  /**************
   * z position *
   **************/

  if ((position == TRUE || gamgi_io_token_check (name_position_z) == TRUE) &&
  gamgi_io_token_float_scan (name_position_z, &position_z, -FLT_MAX, FLT_MAX) == FALSE)
    {
    gamgi_gtk_dialog_message_create ("Error", "Invalid Geometry Data", window);
    return;
    }

  /***************
   * x direction *
   ***************/

  if ((direction == TRUE || gamgi_io_token_check (name_direction_x) == TRUE) &&
  gamgi_io_token_float_scan (name_direction_x, &direction_x, -FLT_MAX, FLT_MAX) == FALSE)
    {
    gamgi_gtk_dialog_message_create ("Error", "Invalid Geometry Data", window);
    return;
    }

  /***************
   * y direction *
   ***************/

  if ((direction == TRUE || gamgi_io_token_check (name_direction_y) == TRUE) &&
  gamgi_io_token_float_scan (name_direction_y, &direction_y, -FLT_MAX, FLT_MAX) == FALSE)
    {
    gamgi_gtk_dialog_message_create ("Error", "Invalid Geometry Data", window);
    return;
    }

  /***************
   * z direction *
   ***************/

  if ((direction == TRUE || gamgi_io_token_check (name_direction_z) == TRUE) &&
  gamgi_io_token_float_scan (name_direction_z, &direction_z, -FLT_MAX, FLT_MAX) == FALSE)
    {
    gamgi_gtk_dialog_message_create ("Error", "Invalid Geometry Data", window);
    return;
    }
    
  /*******************************************************
   * (0,0,0) is valid for position but not for direction *
   *******************************************************/

  if (direction_x == 0.0 && direction_y == 0.0 && direction_z == 0.0)
    {
    gamgi_gtk_dialog_message_create ("Error", "Invalid Geometry Data", window);
    return;
    }

  /*********
   * angle *
   *********/

  if (gamgi_io_token_check (name_angle) == TRUE &&
  gamgi_io_token_float_scan (name_angle, &angle, 0.0, 90.0) == FALSE)
    {
    gamgi_gtk_dialog_message_create ("Error", "Invalid Light Attenuation", window);
    return;
    }

  /************************
   * constant attenuation *
   ************************/

  if (gamgi_io_token_check (name_constant) == TRUE &&
  gamgi_io_token_float_scan (name_constant, &constant, 0.0, FLT_MAX) == FALSE)
    {
    gamgi_gtk_dialog_message_create ("Error", "Invalid Light Attenuation", window);
    return;
    }

  /**********************
   * linear attenuation *
   **********************/

  if (gamgi_io_token_check (name_linear) == TRUE &&
  gamgi_io_token_float_scan (name_linear, &linear, 0.0, FLT_MAX) == FALSE)
    {
    gamgi_gtk_dialog_message_create ("Error", "Invalid Light Attenuation", window);
    return;
    }

  /*************************
   * quadratic attenuation *
   *************************/

  if (gamgi_io_token_check (name_quadratic) == TRUE &&
  gamgi_io_token_float_scan (name_quadratic, &quadratic, 0.0, FLT_MAX) == FALSE)
    {
    gamgi_gtk_dialog_message_create ("Error", "Invalid Light Attenuation", window);
    return;
    }

  /**********************
   * radial attenuation *
   **********************/

  if (gamgi_io_token_check (name_radial) == TRUE &&
  gamgi_io_token_float_scan (name_radial, &radial, 0.0, FLT_MAX) == FALSE)
    {
    gamgi_gtk_dialog_message_create ("Error", "Invalid Light Attenuation", window);
    return;
    }

  /*******************
   * ambient r color *
   *******************/

  entry = (GtkEntry *) g_object_get_data (G_OBJECT (dialog), "entry_ambient_r");
  name = gtk_entry_get_text (GTK_ENTRY (entry));
  if (gamgi_io_token_check (name) == TRUE && 
  gamgi_io_token_float_scan (name, &ambient_r, 0.0, 1.0) == FALSE)
    {
    gamgi_gtk_dialog_message_create ("Error", "Invalid Color Data", window);
    return;
    }

  /*******************
   * ambient g color *
   *******************/

  entry = (GtkEntry *) g_object_get_data (G_OBJECT (dialog), "entry_ambient_g");
  name = gtk_entry_get_text (GTK_ENTRY (entry));
  if (gamgi_io_token_check (name) == TRUE && 
  gamgi_io_token_float_scan (name, &ambient_g, 0.0, 1.0) == FALSE)
    {
    gamgi_gtk_dialog_message_create ("Error", "Invalid Color Data", window);
    return;
    }

  /*******************
   * ambient b color *
   *******************/

  entry = (GtkEntry *) g_object_get_data (G_OBJECT (dialog), "entry_ambient_b");
  name = gtk_entry_get_text (GTK_ENTRY (entry));
  if (gamgi_io_token_check (name) == TRUE && 
  gamgi_io_token_float_scan (name, &ambient_b, 0.0, 1.0) == FALSE)
    {
    gamgi_gtk_dialog_message_create ("Error", "Invalid Color Data", window);
    return;
    }

  /*******************
   * diffuse r color *
   *******************/

  entry = (GtkEntry *) g_object_get_data (G_OBJECT (dialog), "entry_diffuse_r");
  name = gtk_entry_get_text (GTK_ENTRY (entry));
  if (gamgi_io_token_check (name) == TRUE &&
  gamgi_io_token_float_scan (name, &diffuse_r, 0.0, 1.0) == FALSE)
    {
    gamgi_gtk_dialog_message_create ("Error", "Invalid Color Data", window);
    return;
    }

  /*******************
   * diffuse g color *
   *******************/

  entry = (GtkEntry *) g_object_get_data (G_OBJECT (dialog), "entry_diffuse_g");
  name = gtk_entry_get_text (GTK_ENTRY (entry));
  if (gamgi_io_token_check (name) == TRUE &&
  gamgi_io_token_float_scan (name, &diffuse_g, 0.0, 1.0) == FALSE)
    {
    gamgi_gtk_dialog_message_create ("Error", "Invalid Color Data", window);
    return;
    }

  /*******************
   * diffuse b color *
   *******************/

  entry = (GtkEntry *) g_object_get_data (G_OBJECT (dialog), "entry_diffuse_b");
  name = gtk_entry_get_text (GTK_ENTRY (entry));
  if (gamgi_io_token_check (name) == TRUE &&
  gamgi_io_token_float_scan (name, &diffuse_b, 0.0, 1.0) == FALSE)
    {
    gamgi_gtk_dialog_message_create ("Error", "Invalid Color Data", window);
    return;
    }

  /********************
   * specular r color *
   ********************/

  entry = (GtkEntry *) g_object_get_data (G_OBJECT (dialog), "entry_specular_r");
  name = gtk_entry_get_text (GTK_ENTRY (entry));
  if (gamgi_io_token_check (name) == TRUE &&
  gamgi_io_token_float_scan (name, &specular_r, 0.0, 1.0) == FALSE)
    {
    gamgi_gtk_dialog_message_create ("Error", "Invalid Color Data", window);
    return;
    }

  /********************
   * specular g color *
   ********************/

  entry = (GtkEntry *) g_object_get_data (G_OBJECT (dialog), "entry_specular_g");
  name = gtk_entry_get_text (GTK_ENTRY (entry));
  if (gamgi_io_token_check (name) == TRUE &&
  gamgi_io_token_float_scan (name, &specular_g, 0.0, 1.0) == FALSE)
    {
    gamgi_gtk_dialog_message_create ("Error", "Invalid Color Data", window);
    return;
    }

  /********************
   * specular b color *
   ********************/

  entry = (GtkEntry *) g_object_get_data (G_OBJECT (dialog), "entry_specular_b");
  name = gtk_entry_get_text (GTK_ENTRY (entry));
  if (gamgi_io_token_check (name) == TRUE &&
  gamgi_io_token_float_scan (name, &specular_b, 0.0, 1.0) == FALSE)
    {
    gamgi_gtk_dialog_message_create ("Error", "Invalid Color Data", window);
    return;
    }

  /*****************************************************************
   * error: light must have ambient, diffuse or specular comonents *
   *****************************************************************/

  if (ambient_r + ambient_g + ambient_b == 0
  && diffuse_r + diffuse_g + diffuse_b == 0
  && specular_r + specular_g + specular_b == 0)
  {
  gamgi_gtk_dialog_message_create ("Error", "Invalid Color Data", window);
  return;
  }

  /******************************************
   * input data is ok: no errors were found *
   ******************************************/

  /************************************
   * save current layer as undo layer *
   ************************************/

  gamgi_gtk_history_update (window->layer, window->layer->undo, GAMGI_ENGINE_UNDO);

  /**************************************
   * set light with modified parameters *
   **************************************/

  if (row == GAMGI_MESA_DIRECTIONAL - 1 || 
  (row == 3 && light->position[3] == 0))
    {
    /*********************
     * directional light *
     *********************/

    /************************************************************
     * invert the vector direction, so it has the same physical *
     * meaning in directional and positional lights, always     *
     * pointing from the light source to the light destination  *
     ************************************************************/

    light->position[0] = -direction_x;
    light->position[1] = -direction_y;
    light->position[2] = -direction_z;

    light->position[3] = 0.0;

    light->constant = GAMGI_MESA_LIGHT_CONSTANT;
    light->linear = GAMGI_MESA_LIGHT_LINEAR;
    light->quadratic = GAMGI_MESA_LIGHT_QUADRATIC;
    }
  else
    {
    /****************************
     * positional or spot light *
     ****************************/

    light->position[0] = position_x;
    light->position[1] = position_y;
    light->position[2] = position_z;
    light->position[3] = 1.0;

    light->constant = constant;
    light->linear = linear;
    light->quadratic = quadratic;
    }

  if (row == GAMGI_MESA_SPOT - 1 || (row == 3 && light->angle != 180))
    {
    /**************
     * spot light *
     **************/

    light->direction[0] = direction_x;
    light->direction[1] = direction_y;
    light->direction[2] = direction_z;

    /*******************************************************************
     * if the spot light was a directional or positional light before, *
     * then angle will be 180.0 initially. If the user did not supply  *
     * a new angle at all, then the default 90.0 is provided.          *
     *******************************************************************/

    light->angle = (angle == 180.0) ? 90.0 : angle;
    light->angle = angle;
    light->radial = radial;
    }
  else
    {
    /********************
     * positional light *
     ********************/

    light->direction[0] = GAMGI_MESA_LIGHT_DIRECTION_X;
    light->direction[1] = GAMGI_MESA_LIGHT_DIRECTION_Y;
    light->direction[2] = GAMGI_MESA_LIGHT_DIRECTION_Z;

    light->angle = 180.0;
    light->radial = GAMGI_MESA_LIGHT_RADIAL;
    }

  strcpy (light->object.name, token);

  light->ambient[0] = ambient_r;
  light->ambient[1] = ambient_g;
  light->ambient[2] = ambient_b;

  light->diffuse[0] = diffuse_r;
  light->diffuse[1] = diffuse_g;
  light->diffuse[2] = diffuse_b;

  light->specular[0] = specular_r;
  light->specular[1] = specular_g;
  light->specular[2] = specular_b;
  }

/***********************************************************
 * Update statusbar, redraw gl_area image and reset dialog *
 ***********************************************************/

gamgi_gtk_statusbar_focus_modify (window);
gtk_widget_queue_draw (window->area);
static_reset (window);
}

static void static_init (gamgi_window *window)
{
GtkWidget *dialog = window->dialog0;
GtkWidget *combo;

combo = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "combo_light");
gtk_combo_box_set_active (GTK_COMBO_BOX (combo), 3);
}

static void static_press (gamgi_object *object, void *data)
{
gamgi_window *window = GAMGI_CAST_WINDOW data;
gamgi_light *light;
GtkWidget *dialog = window->dialog0;
GtkWidget *entry;
GtkWidget *combo;
char string[2 * GAMGI_ENGINE_TOKEN];

light = GAMGI_CAST_LIGHT object;

static_reset (window);

entry = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "entry_light");
sprintf (string, "%s %d", light->object.name, light->object.number);
gtk_entry_set_text (GTK_ENTRY (entry), string);

/*********************
 * set type of light *
 *********************/

combo = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "combo_light");

if (light->position[3] == 0.0)
  gtk_combo_box_set_active (GTK_COMBO_BOX (combo), GAMGI_MESA_DIRECTIONAL - 1);
else if (light->angle == 180.0)
  gtk_combo_box_set_active (GTK_COMBO_BOX (combo), GAMGI_MESA_POSITIONAL - 1);
else
  gtk_combo_box_set_active (GTK_COMBO_BOX (combo), GAMGI_MESA_SPOT - 1);
   
/****************
 * get position *
 ****************/

if (light->position[3] == 1.0)
  {
  /***********************************
   * positional light: read position *
   ***********************************/

  entry = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "entry_position_x");
  sprintf (string, "%.*f", gamgi->gamgi->length, light->position[0]);
  gtk_entry_set_text (GTK_ENTRY (entry), string);

  entry = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "entry_position_y");
  sprintf (string, "%.*f", gamgi->gamgi->length, light->position[1]);
  gtk_entry_set_text (GTK_ENTRY (entry), string);

  entry = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "entry_position_z");
  sprintf (string, "%.*f", gamgi->gamgi->length, light->position[2]);
  gtk_entry_set_text (GTK_ENTRY (entry), string);

  /********************************************
   * positional light: read axial attenuation *
   ********************************************/

  entry = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "entry_constant");
  sprintf (string, "%.*f",  GAMGI_MATH_DECIMAL_ATTENUATION, light->constant);
  gtk_entry_set_text (GTK_ENTRY (entry), string);

  entry = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "entry_linear");
  sprintf (string, "%.*f",  GAMGI_MATH_DECIMAL_ATTENUATION, light->linear);
  gtk_entry_set_text (GTK_ENTRY (entry), string);

  entry = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "entry_quadratic");
  sprintf (string, "%.*f",  GAMGI_MATH_DECIMAL_ATTENUATION, light->quadratic);
  gtk_entry_set_text (GTK_ENTRY (entry), string);

  if (light->angle != 180.0)
    {
    /******************************
     * spot light: read direction *
     ******************************/

    entry = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "entry_direction_x");
    sprintf (string, "%.*f", gamgi->gamgi->length, light->direction[0]);
    gtk_entry_set_text (GTK_ENTRY (entry), string);

    entry = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "entry_direction_y");
    sprintf (string, "%.*f", gamgi->gamgi->length, light->direction[1]);
    gtk_entry_set_text (GTK_ENTRY (entry), string);

    entry = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "entry_direction_z");
    sprintf (string, "%.*f", gamgi->gamgi->length, light->direction[2]);
    gtk_entry_set_text (GTK_ENTRY (entry), string);

    entry = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "entry_angle");
    sprintf (string, "%.*f", gamgi->gamgi->angle, light->angle);
    gtk_entry_set_text (GTK_ENTRY (entry), string);

    entry = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "entry_radial");
    sprintf (string, "%.*f",  GAMGI_MATH_DECIMAL_ATTENUATION, light->radial);
    gtk_entry_set_text (GTK_ENTRY (entry), string);
    }
  }
else
  {
  /*************************************
   * directional light: read direction *
   *************************************/

  /************************************************************
   * invert the vector direction, so it has the same physical *
   * meaning in directional and positional lights, always     *
   * pointing from the light source to the light destination  *
   ************************************************************/

  entry = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "entry_direction_x");
  sprintf (string, "%.*f", gamgi->gamgi->length, -light->position[0]);
  gtk_entry_set_text (GTK_ENTRY (entry), string);

  entry = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "entry_direction_y");
  sprintf (string, "%.*f", gamgi->gamgi->length, -light->position[1]);
  gtk_entry_set_text (GTK_ENTRY (entry), string);

  entry = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "entry_direction_z");
  sprintf (string, "%.*f", gamgi->gamgi->length, -light->position[2]);
  gtk_entry_set_text (GTK_ENTRY (entry), string);
  }

/*********************
 * get ambient color *
 *********************/

entry = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "entry_ambient_r");
sprintf (string, "%.*f", GAMGI_MATH_DECIMAL_COLOR, light->ambient[0]);
gtk_entry_set_text (GTK_ENTRY (entry), string);

entry = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "entry_ambient_g");
sprintf (string, "%.*f", GAMGI_MATH_DECIMAL_COLOR, light->ambient[1]);
gtk_entry_set_text (GTK_ENTRY (entry), string);

entry = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "entry_ambient_b");
sprintf (string, "%.*f", GAMGI_MATH_DECIMAL_COLOR, light->ambient[2]);
gtk_entry_set_text (GTK_ENTRY (entry), string);

/*********************
 * get diffuse color *
 *********************/

entry = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "entry_diffuse_r");
sprintf (string, "%.*f", GAMGI_MATH_DECIMAL_COLOR, light->diffuse[0]);
gtk_entry_set_text (GTK_ENTRY (entry), string);

entry = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "entry_diffuse_g");
sprintf (string, "%.*f", GAMGI_MATH_DECIMAL_COLOR, light->diffuse[1]);
gtk_entry_set_text (GTK_ENTRY (entry), string);

entry = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "entry_diffuse_b");
sprintf (string, "%.*f", GAMGI_MATH_DECIMAL_COLOR, light->diffuse[2]);
gtk_entry_set_text (GTK_ENTRY (entry), string);

/**********************
 * get specular color *
 *********************/

entry = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "entry_specular_r");
sprintf (string, "%.*f", GAMGI_MATH_DECIMAL_COLOR, light->specular[0]);
gtk_entry_set_text (GTK_ENTRY (entry), string);

entry = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "entry_specular_g");
sprintf (string, "%.*f", GAMGI_MATH_DECIMAL_COLOR, light->specular[1]);
gtk_entry_set_text (GTK_ENTRY (entry), string);

entry = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "entry_specular_b");
sprintf (string, "%.*f", GAMGI_MATH_DECIMAL_COLOR, light->specular[2]);
gtk_entry_set_text (GTK_ENTRY (entry), string);

static_light (window);
}

/*************** external function *************
 *                                             *
 *          GAMGI_GTK_LIGHT_MODIFY_PRESS       *
 *                                             *
 *                                             *
 ***********************************************/
 
void gamgi_gtk_light_modify_press (gamgi_window *window_mouse,
int x, int y, gamgi_window *window_dialog)
{
GtkWidget *dialog = window_dialog->dialog0;
GtkWidget *button; 

/******************************
 * local mouse selection only *
 ******************************/

button = (GtkWidget *) g_object_get_data (G_OBJECT (dialog), "button_global");
if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (button)) == TRUE ||
window_mouse->layer->light_start == NULL ||
window_dialog != window_mouse) return;

gamgi_mesa_select_object (window_mouse, x, y, 
GAMGI_ENGINE_LIGHT, FALSE, static_press);
}

/**************** external function ******************
 *                                                   *
 *             GAMGI_GTK_LIGHT_MODIFY                *
 *                                                   *
 *  Creates the dialog window used to modify lights. *
 *                                                   *
 *****************************************************/

void gamgi_gtk_light_modify (GtkWidget *widget, void *data)
{
gamgi_window *window = GAMGI_CAST_WINDOW data;
GtkWidget *dialog;
GtkWidget *notebook;
GtkWidget *button;
GtkWidget *label;
GtkWidget *entry;
GtkWidget *frame;
GtkWidget *table;
GtkWidget *hbox_center, *hbox_left, *hbox_left_left;
GtkWidget *vbox_dialog, *vbox_page, *vbox_frame, *vbox_top;
GtkWidget *combo;
GtkListStore *store;
GtkCellRenderer *renderer;
GtkTreeIter iter;

/******************
 * dialog level 0 *
 ******************/

dialog = gamgi_gtk_dialog_task0_create ("Light Modify", window);
window->action = GAMGI_GTK_LIGHT_MODIFY;
gtk_container_set_border_width (GTK_CONTAINER (dialog), 5);

/********************
 * global container *
 ********************/

vbox_dialog = gtk_vbox_new (FALSE, 5);
gtk_container_add (GTK_CONTAINER (dialog), vbox_dialog);
gtk_widget_show (vbox_dialog);

/*****************
 * Light objects *
 *****************/

hbox_center = gtk_hbox_new (TRUE, 0);
gtk_box_pack_start (GTK_BOX (vbox_dialog), hbox_center, FALSE, FALSE, 0);
gtk_widget_show (hbox_center);

hbox_left = gtk_hbox_new (FALSE, 10);
gtk_box_pack_start (GTK_BOX (hbox_center), hbox_left, FALSE, FALSE, 0);
gtk_widget_show (hbox_left);

/*********
 * Local *
 *********/

hbox_left_left = gtk_hbox_new (FALSE, 5);
gtk_box_pack_start (GTK_BOX (hbox_left), hbox_left_left, FALSE, FALSE, 0);
g_object_set_data (G_OBJECT (dialog), "hbox_light", hbox_left_left);
gtk_widget_show (hbox_left_left);

label = gtk_label_new ("Light");
gtk_box_pack_start (GTK_BOX (hbox_left_left), label, FALSE, FALSE, 0);
gtk_widget_show (label);

entry = gtk_entry_new ();
gtk_box_pack_start (GTK_BOX (hbox_left_left), entry, FALSE, FALSE, 0);
gtk_entry_set_width_chars (GTK_ENTRY (entry), GAMGI_GTK_CHAR_20);
gtk_entry_set_max_length (GTK_ENTRY (entry), GAMGI_GTK_CHAR_20);
g_object_set_data (G_OBJECT (dialog), "entry_light", entry);
gtk_widget_show (entry);

/**********
 * Global *
 **********/

button = gtk_toggle_button_new_with_label ("Global");
gtk_box_pack_start (GTK_BOX (hbox_left), button, FALSE, FALSE, 0);
g_signal_connect (GTK_OBJECT (button), "toggled",
G_CALLBACK (static_global), window);
g_object_set_data (G_OBJECT (dialog), "button_global", button);
gtk_widget_show (button);

/************
 * notebook *
 ************/

notebook = gtk_notebook_new ();
gtk_box_pack_start (GTK_BOX (vbox_dialog), notebook, FALSE, FALSE, 0);
gtk_notebook_set_tab_pos (GTK_NOTEBOOK (notebook), GTK_POS_TOP);
g_object_set_data (G_OBJECT (dialog), "notebook", notebook);
gtk_widget_show (notebook);

/*************
 * Type page *
 *************/

vbox_page = gtk_vbox_new (FALSE, 5);
label = gtk_label_new (" Type ");
gtk_notebook_append_page (GTK_NOTEBOOK (notebook), vbox_page, label);
gtk_container_set_border_width (GTK_CONTAINER (vbox_page), 5);
gtk_widget_show (vbox_page);

frame = gtk_frame_new (NULL);
gtk_box_pack_start (GTK_BOX (vbox_page), frame, TRUE, TRUE, 0);
gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_ETCHED_IN);
gtk_widget_show (frame);

vbox_frame = gtk_vbox_new (TRUE, 0);
gtk_container_add (GTK_CONTAINER (frame), vbox_frame);
gtk_container_set_border_width (GTK_CONTAINER (vbox_frame), 5);
gtk_widget_show (vbox_frame);

vbox_top = gtk_vbox_new (FALSE, 5);
gtk_box_pack_start (GTK_BOX (vbox_frame), vbox_top, FALSE, FALSE, 0);
gtk_widget_show (vbox_top);

/****************
 * illumination *
 ****************/

hbox_center = gtk_hbox_new (TRUE, 0);
gtk_box_pack_start (GTK_BOX (vbox_top), hbox_center, FALSE, FALSE, 0);
gtk_widget_show (hbox_center);

hbox_left = gtk_hbox_new (FALSE, 5);
gtk_box_pack_start (GTK_BOX (hbox_center), hbox_left, FALSE, FALSE, 0);
gtk_widget_show (hbox_left);

combo = gtk_combo_box_new ();
gtk_box_pack_start (GTK_BOX (hbox_left), combo, FALSE, FALSE, 0);
g_signal_connect (GTK_OBJECT (combo), "changed",
G_CALLBACK (static_default), window);
g_object_set_data (G_OBJECT (dialog), "combo_light", combo);
gtk_widget_show (combo);

store = gtk_list_store_new (1, G_TYPE_STRING);
gtk_list_store_append (store, &iter);
gtk_list_store_set (store, &iter, 0, "Directional", -1);
gtk_list_store_append (store, &iter);
gtk_list_store_set (store, &iter, 0, "Positional", -1);
gtk_list_store_append (store, &iter);
gtk_list_store_set (store, &iter, 0, "Spot", -1);
gtk_list_store_append (store, &iter);
gtk_list_store_set (store, &iter, 0, "Local", -1);
gtk_combo_box_set_model (GTK_COMBO_BOX (combo), GTK_TREE_MODEL (store));
g_object_unref (store);

renderer = gtk_cell_renderer_text_new ();
gtk_cell_layout_pack_start (GTK_CELL_LAYOUT (combo), renderer, FALSE);
gtk_cell_layout_set_attributes (GTK_CELL_LAYOUT (combo), renderer, "text", 0, NULL);

/************
 * geometry *
 ************/

hbox_center = gtk_hbox_new (TRUE, 0);
gtk_box_pack_start (GTK_BOX (vbox_top), hbox_center, FALSE, FALSE, 0);
gtk_widget_show (hbox_center);

table = gtk_table_new (4, 4, FALSE);
gtk_box_pack_start (GTK_BOX (hbox_center), table, FALSE, FALSE, 0);
gtk_widget_show (table);

label = gtk_label_new ("Direction");
gtk_table_attach (GTK_TABLE (table), label, 1, 2, 0, 1, GTK_FILL, GTK_FILL, 0, 0);
g_object_set_data (G_OBJECT (dialog), "label_direction", label);
gtk_widget_show (label);

label = gtk_label_new ("Position");
gtk_table_attach (GTK_TABLE (table), label, 2, 3, 0, 1, GTK_FILL, GTK_FILL, 0, 0);
g_object_set_data (G_OBJECT (dialog), "label_position", label);
gtk_widget_show (label);

label = gtk_label_new ("Angle");
gtk_table_attach (GTK_TABLE (table), label, 3, 4, 1, 2, GTK_FILL, GTK_FILL, 0, 0);
g_object_set_data (G_OBJECT (dialog), "label_angle", label);
gtk_widget_show (label);

label = gtk_label_new ("X");
gtk_table_attach (GTK_TABLE (table), label, 0, 1, 1, 2, GTK_FILL, GTK_FILL, 5, 0);
gtk_widget_show (label);

label = gtk_label_new ("Y");
gtk_table_attach (GTK_TABLE (table), label, 0, 1, 2, 3, GTK_FILL, GTK_FILL, 5, 0);
gtk_widget_show (label);

label = gtk_label_new ("Z");
gtk_table_attach (GTK_TABLE (table), label, 0, 1, 3, 4, GTK_FILL, GTK_FILL, 5, 0);
gtk_widget_show (label);

entry = gtk_entry_new ();
gtk_table_attach (GTK_TABLE (table), entry, 1, 2, 1, 2, GTK_FILL, GTK_FILL, 5, 0);
gtk_entry_set_width_chars (GTK_ENTRY (entry), GAMGI_GTK_CHAR_7);
gtk_entry_set_max_length (GTK_ENTRY (entry), GAMGI_GTK_CHAR_7);
g_object_set_data (G_OBJECT (dialog), "entry_direction_x", entry);
gtk_widget_show (entry);

entry = gtk_entry_new ();
gtk_table_attach (GTK_TABLE (table), entry, 2, 3, 1, 2, GTK_FILL, GTK_FILL, 5, 0);
gtk_entry_set_width_chars (GTK_ENTRY (entry), GAMGI_GTK_CHAR_7);
gtk_entry_set_max_length (GTK_ENTRY (entry), GAMGI_GTK_CHAR_7);
g_object_set_data (G_OBJECT (dialog), "entry_position_x", entry);
gtk_widget_show (entry);

entry = gtk_entry_new ();
gtk_table_attach (GTK_TABLE (table), entry, 1, 2, 2, 3, GTK_FILL, GTK_FILL, 5, 0);
gtk_entry_set_width_chars (GTK_ENTRY (entry), GAMGI_GTK_CHAR_7);
gtk_entry_set_max_length (GTK_ENTRY (entry), GAMGI_GTK_CHAR_7);
g_object_set_data (G_OBJECT (dialog), "entry_direction_y", entry);
gtk_widget_show (entry);

entry = gtk_entry_new ();
gtk_table_attach (GTK_TABLE (table), entry, 2, 3, 2, 3, GTK_FILL, GTK_FILL, 5, 0);
gtk_entry_set_width_chars (GTK_ENTRY (entry), GAMGI_GTK_CHAR_7);
gtk_entry_set_max_length (GTK_ENTRY (entry), GAMGI_GTK_CHAR_7);
g_object_set_data (G_OBJECT (dialog), "entry_position_y", entry);
gtk_widget_show (entry);

entry = gtk_entry_new ();
gtk_table_attach (GTK_TABLE (table), entry, 3, 4, 2, 3, GTK_FILL, GTK_FILL, 5, 0);
gtk_entry_set_width_chars (GTK_ENTRY (entry), GAMGI_GTK_CHAR_7);
gtk_entry_set_max_length (GTK_ENTRY (entry), GAMGI_GTK_CHAR_7);
g_object_set_data (G_OBJECT (dialog), "entry_angle", entry);
gtk_widget_show (entry);

entry = gtk_entry_new ();
gtk_table_attach (GTK_TABLE (table), entry, 1, 2, 3, 4, GTK_FILL, GTK_FILL, 5, 0);
gtk_entry_set_width_chars (GTK_ENTRY (entry), GAMGI_GTK_CHAR_7);
gtk_entry_set_max_length (GTK_ENTRY (entry), GAMGI_GTK_CHAR_7);
g_object_set_data (G_OBJECT (dialog), "entry_direction_z", entry);
gtk_widget_show (entry);

entry = gtk_entry_new ();
gtk_table_attach (GTK_TABLE (table), entry, 2, 3, 3, 4, GTK_FILL, GTK_FILL, 5, 0);
gtk_entry_set_width_chars (GTK_ENTRY (entry), GAMGI_GTK_CHAR_7);
gtk_entry_set_max_length (GTK_ENTRY (entry), GAMGI_GTK_CHAR_7);
g_object_set_data (G_OBJECT (dialog), "entry_position_z", entry);
gtk_widget_show (entry);

/**************
 * Color page *
 **************/

vbox_page = gtk_vbox_new (FALSE, 5);
label = gtk_label_new (" Color ");
gtk_notebook_append_page (GTK_NOTEBOOK (notebook), vbox_page, label);
gtk_container_set_border_width (GTK_CONTAINER (vbox_page), 5);
gtk_widget_show (vbox_page);

frame = gtk_frame_new (NULL);
gtk_box_pack_start (GTK_BOX (vbox_page), frame, TRUE, TRUE, 0);
gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_ETCHED_IN);
gtk_widget_show (frame);

vbox_frame = gtk_vbox_new (TRUE, 0);
gtk_container_add (GTK_CONTAINER (frame), vbox_frame);
gtk_container_set_border_width (GTK_CONTAINER (vbox_frame), 5);
gtk_widget_show (vbox_frame);

hbox_center = gtk_hbox_new (TRUE, 0);
gtk_box_pack_start (GTK_BOX (vbox_frame), hbox_center, FALSE, FALSE, 0);
gtk_widget_show (hbox_center);

table = gtk_table_new (4, 4, FALSE);
gtk_box_pack_start (GTK_BOX (hbox_center), table, FALSE, FALSE, 0);
gtk_widget_show (table);

label = gtk_label_new ("Ambient");
gtk_table_attach (GTK_TABLE (table), label, 1, 2, 0, 1, GTK_FILL, GTK_FILL, 0, 0);
gtk_widget_show (label);

label = gtk_label_new ("Diffuse");
gtk_table_attach (GTK_TABLE (table), label, 2, 3, 0, 1, GTK_FILL, GTK_FILL, 0, 0);
gtk_widget_show (label);

label = gtk_label_new ("Specular");
gtk_table_attach (GTK_TABLE (table), label, 3, 4, 0, 1, GTK_FILL, GTK_FILL, 0, 0);
gtk_widget_show (label);

label = gtk_label_new ("R");
gtk_table_attach (GTK_TABLE (table), label, 0, 1, 1, 2, GTK_FILL, GTK_FILL, 5, 0);
gtk_widget_show (label);

label = gtk_label_new ("G");
gtk_table_attach (GTK_TABLE (table), label, 0, 1, 2, 3, GTK_FILL, GTK_FILL, 5, 0);
gtk_widget_show (label);

label = gtk_label_new ("B");
gtk_table_attach (GTK_TABLE (table), label, 0, 1, 3, 4, GTK_FILL, GTK_FILL, 5, 0);
gtk_widget_show (label);

/*******
 * red *
 *******/

entry = gtk_entry_new ();
gtk_table_attach (GTK_TABLE (table), entry, 1, 2, 1, 2, GTK_FILL, GTK_FILL, 10, 0);
gtk_entry_set_width_chars (GTK_ENTRY (entry), GAMGI_GTK_CHAR_5);
gtk_entry_set_max_length (GTK_ENTRY (entry), GAMGI_GTK_CHAR_5);
g_object_set_data (G_OBJECT (dialog), "entry_ambient_r", entry);
gtk_widget_show (entry);

entry = gtk_entry_new ();
gtk_table_attach (GTK_TABLE (table), entry, 2, 3, 1, 2, GTK_FILL, GTK_FILL, 10, 0);
gtk_entry_set_width_chars (GTK_ENTRY (entry), GAMGI_GTK_CHAR_5);
gtk_entry_set_max_length (GTK_ENTRY (entry), GAMGI_GTK_CHAR_5);
g_object_set_data (G_OBJECT (dialog), "entry_diffuse_r", entry);
gtk_widget_show (entry);

entry = gtk_entry_new ();
gtk_table_attach (GTK_TABLE (table), entry, 3, 4, 1, 2, GTK_FILL, GTK_FILL, 10, 0);
gtk_entry_set_width_chars (GTK_ENTRY (entry), GAMGI_GTK_CHAR_5);
gtk_entry_set_max_length (GTK_ENTRY (entry), GAMGI_GTK_CHAR_5);
g_object_set_data (G_OBJECT (dialog), "entry_specular_r", entry);
gtk_widget_show (entry);

/*********
 * green *
 *********/

entry = gtk_entry_new ();
gtk_table_attach (GTK_TABLE (table), entry, 1, 2, 2, 3, GTK_FILL, GTK_FILL, 10, 5);
gtk_entry_set_width_chars (GTK_ENTRY (entry), GAMGI_GTK_CHAR_5);
gtk_entry_set_max_length (GTK_ENTRY (entry), GAMGI_GTK_CHAR_5);
g_object_set_data (G_OBJECT (dialog), "entry_ambient_g", entry);
gtk_widget_show (entry);

entry = gtk_entry_new ();
gtk_table_attach (GTK_TABLE (table), entry, 2, 3, 2, 3, GTK_FILL, GTK_FILL, 10, 5);
gtk_entry_set_width_chars (GTK_ENTRY (entry), GAMGI_GTK_CHAR_5);
gtk_entry_set_max_length (GTK_ENTRY (entry), GAMGI_GTK_CHAR_5);
g_object_set_data (G_OBJECT (dialog), "entry_diffuse_g", entry);
gtk_widget_show (entry);

entry = gtk_entry_new ();
gtk_table_attach (GTK_TABLE (table), entry, 3, 4, 2, 3, GTK_FILL, GTK_FILL, 10, 5);
gtk_entry_set_width_chars (GTK_ENTRY (entry), GAMGI_GTK_CHAR_5);
gtk_entry_set_max_length (GTK_ENTRY (entry), GAMGI_GTK_CHAR_5);
g_object_set_data (G_OBJECT (dialog), "entry_specular_g", entry);
gtk_widget_show (entry);

/********
 * blue *
 ********/

entry = gtk_entry_new ();
gtk_table_attach (GTK_TABLE (table), entry, 1, 2, 3, 4, GTK_FILL, GTK_FILL, 10, 0);
gtk_entry_set_width_chars (GTK_ENTRY (entry), GAMGI_GTK_CHAR_5);
gtk_entry_set_max_length (GTK_ENTRY (entry), GAMGI_GTK_CHAR_5);
g_object_set_data (G_OBJECT (dialog), "entry_ambient_b", entry);
gtk_widget_show (entry);

entry = gtk_entry_new ();
gtk_table_attach (GTK_TABLE (table), entry, 2, 3, 3, 4, GTK_FILL, GTK_FILL, 10, 0);
gtk_entry_set_width_chars (GTK_ENTRY (entry), GAMGI_GTK_CHAR_5);
gtk_entry_set_max_length (GTK_ENTRY (entry), GAMGI_GTK_CHAR_5);
g_object_set_data (G_OBJECT (dialog), "entry_diffuse_b", entry);
gtk_widget_show (entry);

entry = gtk_entry_new ();
gtk_table_attach (GTK_TABLE (table), entry, 3, 4, 3, 4, GTK_FILL, GTK_FILL, 10, 0);
gtk_entry_set_width_chars (GTK_ENTRY (entry), GAMGI_GTK_CHAR_5);
gtk_entry_set_max_length (GTK_ENTRY (entry), GAMGI_GTK_CHAR_5);
g_object_set_data (G_OBJECT (dialog), "entry_specular_b", entry);
gtk_widget_show (entry);

/********************
 * Attenuation page *
 ********************/

vbox_page = gtk_vbox_new (FALSE, 5);
label = gtk_label_new ("Attenuation");
gtk_notebook_append_page (GTK_NOTEBOOK (notebook), vbox_page, label);
gtk_container_set_border_width (GTK_CONTAINER (vbox_page), 5);
gtk_widget_show (vbox_page);

frame = gtk_frame_new (NULL);
gtk_box_pack_start (GTK_BOX (vbox_page), frame, TRUE, TRUE, 0);
gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_ETCHED_IN);
gtk_widget_show (frame);

vbox_frame = gtk_vbox_new (TRUE, 0);
gtk_container_add (GTK_CONTAINER (frame), vbox_frame);
gtk_container_set_border_width (GTK_CONTAINER (vbox_frame), 5);
gtk_widget_show (vbox_frame);

vbox_top = gtk_vbox_new (FALSE, 5);
gtk_box_pack_start (GTK_BOX (vbox_frame), vbox_top, FALSE, FALSE, 0);
gtk_widget_show (vbox_top);

/*********
 * axial *
 *********/

hbox_center = gtk_hbox_new (TRUE, 0);
gtk_box_pack_start (GTK_BOX (vbox_top), hbox_center, FALSE, FALSE, 0);
gtk_widget_show (hbox_center);

table = gtk_table_new (3, 4, FALSE);
gtk_box_pack_start (GTK_BOX (hbox_center), table, FALSE, FALSE, 0);
gtk_widget_show (table);

label = gtk_label_new ("Axial");
gtk_table_attach (GTK_TABLE (table), label, 1, 2, 0, 1, GTK_FILL, GTK_FILL, 0, 5);
g_object_set_data (G_OBJECT (dialog), "label_axial", label);
gtk_widget_show (label);

label = gtk_label_new ("Constant");
gtk_table_attach (GTK_TABLE (table), label, 0, 1, 1, 2, GTK_FILL, GTK_FILL, 0, 0);
g_object_set_data (G_OBJECT (dialog), "label_constant", label);
gtk_widget_show (label);

label = gtk_label_new ("Linear");
gtk_table_attach (GTK_TABLE (table), label, 0, 1, 2, 3, GTK_FILL, GTK_FILL, 0, 0);
g_object_set_data (G_OBJECT (dialog), "label_linear", label);
gtk_widget_show (label);

label = gtk_label_new ("Quadratic");
gtk_table_attach (GTK_TABLE (table), label, 0, 1, 3, 4, GTK_FILL, GTK_FILL, 0, 0);
g_object_set_data (G_OBJECT (dialog), "label_quadratic", label);
gtk_widget_show (label);

entry = gtk_entry_new ();
gtk_table_attach (GTK_TABLE (table), entry, 1, 2, 1, 2, GTK_FILL, GTK_FILL, 5, 0);
gtk_entry_set_width_chars (GTK_ENTRY (entry), GAMGI_GTK_CHAR_5);
gtk_entry_set_max_length (GTK_ENTRY (entry), GAMGI_GTK_CHAR_5);
g_object_set_data (G_OBJECT (dialog), "entry_constant", entry);
gtk_widget_show (entry);

entry = gtk_entry_new ();
gtk_table_attach (GTK_TABLE (table), entry, 1, 2, 2, 3, GTK_FILL, GTK_FILL, 5, 0);
gtk_entry_set_width_chars (GTK_ENTRY (entry), GAMGI_GTK_CHAR_5);
gtk_entry_set_max_length (GTK_ENTRY (entry), GAMGI_GTK_CHAR_5);
g_object_set_data (G_OBJECT (dialog), "entry_linear", entry);
gtk_widget_show (entry);

entry = gtk_entry_new ();
gtk_table_attach (GTK_TABLE (table), entry, 1, 2, 3, 4, GTK_FILL, GTK_FILL, 5, 0);
gtk_entry_set_width_chars (GTK_ENTRY (entry), GAMGI_GTK_CHAR_5);
gtk_entry_set_max_length (GTK_ENTRY (entry), GAMGI_GTK_CHAR_5);
g_object_set_data (G_OBJECT (dialog), "entry_quadratic", entry);
gtk_widget_show (entry);

/**********
 * radial *
 **********/

label = gtk_label_new ("Radial");
gtk_table_attach (GTK_TABLE (table), label, 2, 3, 1, 2, GTK_FILL, GTK_FILL, 15, 0);
g_object_set_data (G_OBJECT (dialog), "label_radial", label);
gtk_widget_show (label);

entry = gtk_entry_new ();
gtk_table_attach (GTK_TABLE (table), entry, 2, 3, 2, 3, GTK_FILL, GTK_FILL, 15, 0);
gtk_entry_set_width_chars (GTK_ENTRY (entry), GAMGI_GTK_CHAR_5);
gtk_entry_set_max_length (GTK_ENTRY (entry), GAMGI_GTK_CHAR_5);
g_object_set_data (G_OBJECT (dialog), "entry_radial", entry);
gtk_widget_show (entry);

/*********************
 * Ok/Cancel buttons *
 *********************/

hbox_center = gtk_hbox_new (TRUE, 0);
gtk_box_pack_start (GTK_BOX (vbox_dialog), hbox_center, FALSE, FALSE, 0);
gtk_widget_show (hbox_center);

button = gamgi_gtk_dialog_button_create ("Ok", NULL);
gtk_widget_set_size_request (button, GAMGI_GTK_BUTTON_WIDTH, -1);
GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);
gtk_box_pack_start (GTK_BOX (hbox_center), button, FALSE, FALSE, 0);
g_signal_connect (GTK_OBJECT (button), "clicked",
G_CALLBACK (static_ok), window);
gtk_widget_show (button);

button = gamgi_gtk_dialog_button_create ("Cancel", "red");
gtk_widget_set_size_request (button, GAMGI_GTK_BUTTON_WIDTH, -1);
GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);
gtk_box_pack_start (GTK_BOX (hbox_center), button, FALSE, FALSE, 0);
gtk_widget_grab_focus (button);
g_signal_connect (GTK_OBJECT (button), "clicked",
G_CALLBACK (gamgi_gtk_dialog_task0_remove), window);
gtk_widget_show (button);

static_init (window);
gtk_widget_show (dialog);
}
