//
// $Source: /cvsroot/gambit/gambit/sources/gui/Attic/treedraw.cc,v $
// $Revision: 1.16.2.6 $
// $Date: 2004/08/17 17:53:51 $
//
// DESCRIPTION:
// Display configuration class for the extensive form
//
// This file is part of Gambit
// Copyright (c) 2002, The Gambit Project
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include "wx/wxprec.h"
#ifndef WX_PRECOMP
#include "wx/wx.h"
#endif  // WX_PRECOMP
#include "wx/notebook.h"
#include "wx/spinctrl.h"

#include "gambit.h"
#include "treedraw.h"

//===========================================================================
//                 class TreeDrawSettings: Implementation
//===========================================================================

TreeDrawSettings::TreeDrawSettings(void)
  : m_nodeAboveFont(*wxTheFontList->FindOrCreateFont(10, wxDEFAULT, wxNORMAL, wxNORMAL)),
    m_nodeBelowFont(*wxTheFontList->FindOrCreateFont(10, wxDEFAULT, wxNORMAL, wxNORMAL)),
    m_nodeRightFont(*wxTheFontList->FindOrCreateFont(10, wxDEFAULT, wxNORMAL, wxNORMAL)),
    m_branchAboveFont(*wxTheFontList->FindOrCreateFont(10, wxDEFAULT, wxNORMAL, wxNORMAL)),
    m_branchBelowFont(*wxTheFontList->FindOrCreateFont(10, wxDEFAULT, wxNORMAL, wxNORMAL)),
    m_chanceColor(*wxLIGHT_GREY), m_terminalColor(*wxBLACK)
{
  for (int pl = 0; pl < 8; pl++) {
    if (pl % 2 == 0) {
      m_playerColor[pl] = *wxRED;
    }
    else {
      m_playerColor[pl] = *wxBLUE;
    }
  }
  LoadOptions();
}

void TreeDrawSettings::SaveFont(const wxString &p_prefix, 
				wxConfig &p_config, const wxFont &p_font)
{
  p_config.Write(p_prefix + _T("Size"), (long) p_font.GetPointSize());
  p_config.Write(p_prefix + _T("Family"), (long) p_font.GetFamily());
  p_config.Write(p_prefix + _T("Face"), p_font.GetFaceName());
  p_config.Write(p_prefix + _T("Style"), (long) p_font.GetStyle());
  p_config.Write(p_prefix + _T("Weight"), (long) p_font.GetWeight());
}

void TreeDrawSettings::LoadFont(const wxString &p_prefix,
				const wxConfig &p_config, wxFont &p_font)
{
  long size, family, style, weight;
  wxString face;
  p_config.Read(p_prefix + _T("Size"), &size, 10);
  p_config.Read(p_prefix + _T("Family"), &family, wxMODERN);
  p_config.Read(p_prefix + _T("Face"), &face, _T(""));
  p_config.Read(p_prefix + _T("Style"), &style, wxNORMAL);
  p_config.Read(p_prefix + _T("Weight"), &weight, wxNORMAL);

  p_font = *wxTheFontList->FindOrCreateFont(size, family, style, weight,
					    false, face);
}

void TreeDrawSettings::SaveColor(const wxString &p_prefix,
				 wxConfig &p_config, const wxColour &p_color)
{
  p_config.Write(p_prefix + _T("Red"), (long) p_color.Red());
  p_config.Write(p_prefix + _T("Green"), (long) p_color.Green());
  p_config.Write(p_prefix + _T("Blue"), (long) p_color.Blue());
}

void TreeDrawSettings::LoadColor(const wxString &p_prefix,
				 const wxConfig &p_config, wxColour &p_color)
{
  long red, green, blue;
  p_config.Read(p_prefix + _T("Red"), &red, p_color.Red());
  p_config.Read(p_prefix + _T("Green"), &green, p_color.Green());
  p_config.Read(p_prefix + _T("Blue"), &blue, p_color.Blue());
  p_color = wxColour(red, green, blue);
}

void TreeDrawSettings::SaveOptions(void) const
{
  wxConfig config(_T("Gambit"));
  
  config.Write(_T("/TreeDisplay/NodeSize"), (long) m_nodeSize);
  config.Write(_T("/TreeDisplay/TerminalSpacing"), (long) m_terminalSpacing);
  config.Write(_T("/TreeDisplay/ChanceToken"), (long) m_chanceToken);
  config.Write(_T("/TreeDisplay/PlayerToken"), (long) m_playerToken);
  config.Write(_T("/TreeDisplay/TerminalToken"), (long) m_terminalToken);
  config.Write(_T("/TreeDisplay/RootReachable"), (long) m_rootReachable);

  config.Write(_T("/TreeDisplay/BranchLength"), (long) m_branchLength);
  config.Write(_T("/TreeDisplay/TineLength"), (long) m_tineLength);
  config.Write(_T("/TreeDisplay/BranchStyle"), (long) m_branchStyle);
  config.Write(_T("/TreeDisplay/BranchLabels"), (long) m_branchLabels);

  config.Write(_T("/TreeDisplay/InfosetConnect"), (long) m_infosetConnect);
  config.Write(_T("/TreeDisplay/InfosetJoin"), (long) m_infosetJoin);

  config.Write(_T("/TreeDisplay/SubgameStyle"), (long) m_subgameStyle);

  config.Write(_T("/TreeDisplay/NodeAboveLabel"), (long) m_nodeAboveLabel);
  config.Write(_T("/TreeDisplay/NodeBelowLabel"), (long) m_nodeBelowLabel);
  config.Write(_T("/TreeDisplay/NodeRightLabel"), (long) m_nodeRightLabel);
  config.Write(_T("/TreeDisplay/BranchAboveLabel"), (long) m_branchAboveLabel);
  config.Write(_T("/TreeDisplay/BranchBelowLabel"), (long) m_branchBelowLabel);

  SaveFont(_T("/TreeDisplay/NodeAboveFont"), config, m_nodeAboveFont);
  SaveFont(_T("/TreeDisplay/NodeBelowFont"), config, m_nodeBelowFont);
  SaveFont(_T("/TreeDisplay/NodeRightFont"), config, m_nodeRightFont);
  SaveFont(_T("/TreeDisplay/BranchAboveFont"), config, m_branchAboveFont);
  SaveFont(_T("/TreeDisplay/BranchBelowFont"), config, m_branchBelowFont);

  SaveColor(_T("/TreeDisplay/ChanceColor"), config, m_chanceColor);
  SaveColor(_T("/TreeDisplay/TerminalColor"), config, m_terminalColor);
  for (int pl = 0; pl < 8; pl++) {
    SaveColor(wxString::Format(_T("/TreeDisplay/Player%dColor"), pl + 1),
	      config, m_playerColor[pl]);
  }

  config.Write(_T("/TreeDisplay/NumDecimals"), (long) m_numDecimals);
}

void TreeDrawSettings::LoadOptions(void)
{
  wxConfig config(_T("Gambit"));
  config.Read(_T("/TreeDisplay/NodeSize"), &m_nodeSize, 20);
  config.Read(_T("/TreeDisplay/TerminalSpacing"), &m_terminalSpacing, 45);
  config.Read(_T("/TreeDisplay/ChanceToken"), &m_chanceToken, 2);
  config.Read(_T("/TreeDisplay/PlayerToken"), &m_playerToken, 2);
  config.Read(_T("/TreeDisplay/TerminalToken"), &m_terminalToken, 2);
  config.Read(_T("/TreeDisplay/RootReachable"), &m_rootReachable, 0);

  config.Read(_T("/TreeDisplay/BranchLength"), &m_branchLength, 60);
  config.Read(_T("/TreeDisplay/TineLength"), &m_tineLength, 20);
  config.Read(_T("/TreeDisplay/BranchStyle"), &m_branchStyle, 0);
  config.Read(_T("/TreeDisplay/BranchLabels"), &m_branchLabels, 0);

  config.Read(_T("/TreeDisplay/InfosetConnect"), &m_infosetConnect, 2);
  config.Read(_T("/TreeDisplay/InfosetJoin"), &m_infosetJoin, 1);

  config.Read(_T("/TreeDisplay/SubgameStyle"), &m_subgameStyle, 1);

  config.Read(_T("/TreeDisplay/NodeAboveLabel"), &m_nodeAboveLabel, 1);
  config.Read(_T("/TreeDisplay/NodeBelowLabel"), &m_nodeBelowLabel, 4);
  config.Read(_T("/TreeDisplay/NodeRightLabel"), &m_nodeRightLabel, 1);
  config.Read(_T("/TreeDisplay/BranchAboveLabel"), &m_branchAboveLabel, 1);
  config.Read(_T("/TreeDisplay/BranchBelowLabel"), &m_branchBelowLabel, 2);
  
  LoadFont(_T("/TreeDisplay/NodeAboveFont"), config, m_nodeAboveFont);
  LoadFont(_T("/TreeDisplay/NodeBelowFont"), config, m_nodeBelowFont);
  LoadFont(_T("/TreeDisplay/NodeRightFont"), config, m_nodeRightFont);
  LoadFont(_T("/TreeDisplay/BranchAboveFont"), config, m_branchAboveFont);
  LoadFont(_T("/TreeDisplay/BranchBelowFont"), config, m_branchBelowFont);

  LoadColor(_T("/TreeDisplay/ChanceColor"), config, m_chanceColor);
  LoadColor(_T("/TreeDisplay/TerminalColor"), config, m_terminalColor);
  for (int pl = 0; pl < 8; pl++) {
    LoadColor(wxString::Format(_T("/TreeDisplay/Player%dColor"), pl + 1),
	      config, m_playerColor[pl]);
  }

  config.Read(_T("/TreeDisplay/NumDecimals"), &m_numDecimals, 2);
}



