/***************************************************************************

  CWorkspace.cpp

  The Workspace class

  (c) 2000-2003 Benot Minisini <gambas@users.sourceforge.net>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 1, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************/

#define __CWORKSPACE_CPP

#include "main.h"

#include <qevent.h>
#include <qapplication.h>

#include "CWorkspace.h"


DECLARE_EVENT(EVENT_Activate);
DECLARE_EVENT(EVENT_Deactivate);


BEGIN_METHOD_VOID(CWORKSPACE_init)

  GB_CLASS CLASS_Window = GB.FindClass("Window");

  EVENT_Activate = GB.GetEvent(CLASS_Window, "Activate");
  EVENT_Deactivate = GB.GetEvent(CLASS_Window, "Deactivate");

END_METHOD


BEGIN_METHOD(CWORKSPACE_new, GB_OBJECT parent)

  QWorkspace *wid = new QWorkspace(QT.GetContainer(VARG(parent)));

  QT.InitWidget(wid, (void *)_object);

  THIS->widget.container = wid;
  THIS->active = 0;

  QObject::connect(wid, SIGNAL(windowActivated(QWidget *)), &CWorkspace::manager, SLOT(activated(QWidget *)));

  wid->setScrollBarsEnabled(true);
  wid->show();

END_METHOD


BEGIN_PROPERTY(CWORKSPACE_active_window)

  QWidget *wid = WIDGET->activeWindow();

  if (wid)
    GB.ReturnObject(QT.GetObject(wid));
  else
    GB.ReturnNull();

END_PROPERTY


BEGIN_METHOD(CWORKSPACE_arrange, GB_INTEGER mode)

  switch(VARG(mode))
  {
    case 0: WIDGET->cascade(); break;
    case 1: WIDGET->tile(); break;
    default: break;
  }

END_METHOD


BEGIN_METHOD_VOID(CWORKSPACE_next)

  QWidgetList list = WIDGET->windowList();
  uint *index;
  void *win;

  index = (uint *)GB.GetEnum();

  for(;;)
  {
    if (*index >= list.count())
    {
      GB.StopEnum();
      return;
    }

    win = QT.GetObject(list.at(*index));
    (*index)++;

    if (win)
    {
      GB.ReturnObject(win);
      return;
    }
  }

END_METHOD


BEGIN_PROPERTY(CWORKSPACE_count)

  QWidgetList list = WIDGET->windowList();

  GB.ReturnInteger(list.count());

END_PROPERTY



GB_DESC CWorkspaceChildrenDesc[] =
{
  GB_DECLARE(".WorkspaceChildren", 0), GB_VIRTUAL_CLASS(),

  GB_METHOD("_next", "Window", CWORKSPACE_next, NULL),
  GB_PROPERTY_READ("Count", "i", CWORKSPACE_count),

  GB_END_DECLARE
};


GB_DESC CWorkspaceDesc[] =
{
  GB_DECLARE("Workspace", sizeof(CWORKSPACE)), GB_INHERITS("Control"),

  GB_CONSTANT("Cascade", "i", 0),
  GB_CONSTANT("Tile", "i", 1),

  GB_STATIC_METHOD("_init", NULL, CWORKSPACE_init, NULL),
  GB_METHOD("_new", NULL, CWORKSPACE_new, "(Parent)Container;"),
  GB_METHOD("Arrange", NULL, CWORKSPACE_arrange, "(Arrangement)i<Workspace>"),

  GB_PROPERTY_READ("ActiveWindow", "Control", CWORKSPACE_active_window),

  GB_PROPERTY_SELF("Children", ".WorkspaceChildren"),

  GB_CONSTANT("_Properties", "s", CWORKSPACE_PROPERTIES),

  GB_END_DECLARE
};


/***************************************************************************

  CWorkspace

***************************************************************************/

CWorkspace CWorkspace::manager;

void CWorkspace::activated(QWidget *w)
{
  void *_object = QT.GetObject((QWidget *)sender());
  void *win;

  //qDebug("CWorkspace::activated(%p)", w);
  
  if (THIS->active)
  {
    //QWidget *focus = qApp->focusWidget();
    //qDebug("Deactivate: %p -> %p (%p)", THIS->active, focus, focus ? focus->topLevelWidget() : 0);
    //dict.replace((void *)THIS->active, focus);
    
    win = QT.GetObject(THIS->active);
    if (win)
      GB.Raise(win, EVENT_Deactivate, 0);

    QObject::disconnect(THIS->active, SIGNAL(destroyed()), &CWorkspace::manager, SLOT(destroyed()));
  }

  THIS->active = w;

  if (w)
  {
    //qDebug("Activate: %p -> %p", w, dict.find((void *)w));
    //if (dict.find((void *)w))
    //{
    //  dict[(void *)w]->setFocus();
    //  dict.remove((void *)w);
    //}
    
    //qDebug("Activate: %p -> %p", w, w->focusWidget());
    
    QObject::connect(w, SIGNAL(destroyed()), &CWorkspace::manager, SLOT(destroyed()));
    win = QT.GetObject(w);
    if (win)
      GB.Raise(win, EVENT_Activate, 0);
  }
}


void CWorkspace::destroyed()
{
  QWidget *widget = (QWidget *)sender();
  void *_object = QT.GetObject(widget->parentWidget());

  if (THIS && THIS->active == widget)
    THIS->active = 0;
}
