/***************************************************************************

  CWindow.h

  The Window and Form classes

  (c) 2000-2003 Benot Minisini <gambas@users.sourceforge.net>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 1, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************/

#ifndef __CWINDOW_H
#define __CWINDOW_H

#include <qmainwindow.h>
#include <qasciidict.h>
#include <qmenubar.h>
#include <qptrdict.h>
#include <qevent.h>
#include <qpushbutton.h>
#include <qsizegrip.h>
#include <qworkspace.h>

#include "gambas.h"
#include "CContainer.h"
#include "CMenu.h"
#include "CPicture.h"

//class MyCentral;

typedef
  struct {
    CWIDGET widget;
    QWidget *container;
    CARRANGEMENT arrangement;
    //QAsciiDict<void> *dict;
    CMenuList *menu;
    long ret;
    CPICTURE *icon;
    CPICTURE *mask;
    CWIDGET *focus;
    long x;
    long y;
    long w;
    long h;
    unsigned embedded : 1;
    unsigned window : 1;
    unsigned topOnly : 1;
    unsigned skipTaskbar : 1;
    }
  CWINDOW;

typedef
  struct {
    CWINDOW window;
    }
  CFORM;


#ifndef __CWINDOW_CPP

extern GB_DESC CWindowDesc[];
extern GB_DESC CWindowMenusDesc[];
//extern GB_DESC CWindowToolBarsDesc[];
extern GB_DESC CWindowsDesc[];
extern GB_DESC CFormDesc[];

extern CWINDOW *CWINDOW_Main;
extern CWINDOW *CWINDOW_Current;

#else

//#define WIDGET ((QWidget *)(((CWIDGET *)_object)->widget))
#define WINDOW ((MyMainWindow *)(((CWIDGET *)_object)->widget))
#define FRAME ((MyEmbeddedWindow *)(((CWIDGET *)_object)->widget))
#define THIS ((CWINDOW *)_object)

#define CWINDOW_PROPERTIES CWIDGET_PROPERTIES \
  ",Text,Icon,Mask,Persistent,Border,State,TopOnly,SkipTaskbar,Arrangement,Spacing,Padding"

#endif

class CWindow : public QObject
{
  Q_OBJECT

public:

  static QPtrDict<CWINDOW> dict;

  static CWindow manager;
  static int count;

protected:

  bool eventFilter(QObject *, QEvent *);
};


class CWorkspace : public QObject
{
  Q_OBJECT

public:

  static CWorkspace manager;
  
protected:

  bool eventFilter(QObject *, QEvent *);
};

class MyMainWindow : public QMainWindow
{
  Q_OBJECT
  
  friend class CWorkspace;

private:

  QPushButton *db;
  QPushButton *cb;
  QSizeGrip *sg;
  bool shown;
  bool mdichild;
  int border;
  int state;
  bool mustCenter;
  int loopLevel;
  bool _activate;

  void doReparent(QWidget *, WFlags, const QPoint & );
  
protected:

  void showEvent(QShowEvent *);
  //void hideEvent(QHideEvent *);
  void resizeEvent(QResizeEvent *);
  void moveEvent(QMoveEvent *);
  void keyPressEvent(QKeyEvent *);
  void closeEvent(QCloseEvent *);

public:

  enum { BorderNone = 0, BorderFixed = 1, BorderResizable = 2 };
  enum { StateNormal = 0, StateMinimized = 1, StateMaximized = 2, StateFullScreen = 3 };

  MyMainWindow(QWidget *);
  ~MyMainWindow();

  //void setFocus();
  void showActivate();
  void showModal();
  void showPopup();
  bool isModal() { return testWFlags(WShowModal); }
  int level() { return loopLevel; }
  //void hide(void);

  //bool isTopOnly() { return getWFlags() & WStyle_StaysOnTop; }
  void setTopOnly(bool);
  void setSkipTaskbar(bool);

  int getBorder(void) { return border; }
  void setBorder(int);
  void setSizeGrip(bool);
  void moveSizeGrip();

  int getState(void);
  void setState(int);

  void paintUnclip(bool);
  //QSize MyMainWindow::sizeHint() const;
  bool isPersistent(void);
  void setPersistent(bool);

  QPushButton *defaultButton(void) { return db; }
  QPushButton *cancelButton(void) { return cb; }
  void setDefaultButton(QPushButton *, bool);
  void setCancelButton(QPushButton *, bool);

  void defineMask();
  void center(bool);
};


class MyEmbeddedWindow : public MyContainer
{
  Q_OBJECT

private:

  bool shown;

protected:

  void showEvent(QShowEvent *);
  void resizeEvent(QResizeEvent *);
  void moveEvent(QMoveEvent *);

public:

  void show();
  
  MyEmbeddedWindow(QWidget *);
  ~MyEmbeddedWindow();
};


//void CWINDOW_set_top_only(QWidget *w, bool top);


#endif
