/***************************************************************************

  CScrollView.cpp

  (c) 2000-2003 Benot Minisini <gambas@users.sourceforge.net>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 1, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************/

#define __CSCROLLVIEW_CPP



#include <qframe.h>
#if QT_VERSION >= 0x030200
#include <qobjectlist.h>
#else
#include <qobjcoll.h>
#endif
#include <qscrollview.h>

#include "gambas.h"

#include "CConst.h"
#include "CScrollView.h"


/***************************************************************************

  class MyScrollView

***************************************************************************/

MyScrollView::MyScrollView(QWidget *parent)
: QScrollView(parent)
{
}


void MyScrollView::frameChanged(void)
{
  CSCROLLVIEW *ob = (CSCROLLVIEW *)CWidget::get(this);

  QScrollView::frameChanged();
  //CCONTAINER_arrange(ob->container);

  //if (ob->container)
    ob->container->autoResize();
}

void MyScrollView::resizeEvent(QResizeEvent *e)
{
  CSCROLLVIEW *ob = (CSCROLLVIEW *)CWidget::get(this);

  QScrollView::resizeEvent(e);
  //CCONTAINER_arrange(ob->container);

  //if (ob->container)
    ob->container->autoResize();
}

/***************************************************************************

  class MyContents

***************************************************************************/

MyContents::MyContents(QWidget *parent, MyScrollView *scrollview)
: QFrame(parent)
{
  right = 0;
  bottom = 0;
  sw = scrollview;
}

void MyContents::autoResize(void)
{
  int w = 0, h = 0;
  int ww, hh;

  if (right)
    w = right->x() + right->width();
  if (bottom)
    h = bottom->y() + bottom->height();

  ww = sw->contentsRect().width();
  hh = sw->contentsRect().height();

  if (w < ww)
    w = ww;
  if (h < hh)
    h = hh;

  resize(w, h);
}


void MyContents::findRightBottom(void)
{
  QObjectList *list = (QObjectList *)children();
  QWidget *wid;
  QObject *ob;
  int w = 0, h = 0;
  int ww, hh;

  if (!list)
  {
    right = 0;
    bottom = 0;
    return;
  }

  ob = list->first();
  while (ob)
  {
    if (ob->isWidgetType())
    {
      wid = (QWidget *)ob;

      ww = wid->x() + wid->width();
      hh = wid->y() + wid->height();

      if (ww > w)
      {
        w = ww;
        right = wid;
      }

      if (hh > h)
      {
        h = hh;
        bottom = wid;
      }

    }
    ob = list->next();
  }
}


void MyContents::checkWidget(QWidget *wid)
{
  bool doResize = false;

  if (wid == right || wid == bottom)
  {
    findRightBottom();
    doResize = true;
  }
  else
  {
    if (right == 0 || (wid->x() + wid->width()) > (right->x() + right->width()))
    {
      right = wid;
      doResize = true;
    }

    if (bottom == 0 || (wid->y() + wid->height()) > (bottom->y() + bottom->height()))
    {
      bottom = wid;
      doResize = true;
    }
  }

  if (doResize)
    autoResize();
}


void MyContents::childEvent(QChildEvent *e)
{
  if (!e->child()->isWidgetType())
    return;

  if (e->inserted())
  {
    e->child()->installEventFilter(this);
    checkWidget((QWidget *)e->child());
  }
  else if (e->removed())
  {
    e->child()->removeEventFilter(this);
    if (e->child() == right || e->child() == bottom)
    {
      findRightBottom();
      autoResize();
    }
  }
}

bool MyContents::eventFilter(QObject *o, QEvent *e)
{
  int type = e->type();
  QWidget *wid = (QWidget *)o;

  if (type == QEvent::Move || type == QEvent::Resize)
    checkWidget(wid);

  return QObject::eventFilter(o, e);
}




/***************************************************************************

  ScrollView

***************************************************************************/

BEGIN_METHOD(CSCROLLVIEW_new, GB_OBJECT parent)

  MyScrollView *wid = new MyScrollView(CONTAINER(VARG(parent)));
  MyContents *cont = new MyContents(wid->viewport(), wid);

  CWIDGET_new(wid, (void *)_object, "ScrollView");

  THIS->container = cont;
  wid->addChild(THIS->container);

  CWidget::installFilter(THIS->container);
  CWidget::removeFilter(wid->horizontalScrollBar());
  CWidget::removeFilter(wid->verticalScrollBar());

  // Border.Sunken by default
  wid->setLineWidth(2);
  wid->setFrameStyle(QFrame::StyledPanel + QFrame::Sunken);

  wid->show();

END_METHOD


BEGIN_PROPERTY(CSCROLLVIEW_client_x)

  GB.ReturnInteger(WIDGET->viewport()->x());

END_PROPERTY


BEGIN_PROPERTY(CSCROLLVIEW_client_y)

  GB.ReturnInteger(WIDGET->viewport()->y());

END_PROPERTY


BEGIN_PROPERTY(CSCROLLVIEW_client_width)

  GB.ReturnInteger(WIDGET->viewport()->width());

END_PROPERTY


BEGIN_PROPERTY(CSCROLLVIEW_client_height)

  GB.ReturnInteger(WIDGET->viewport()->height());

END_PROPERTY


BEGIN_PROPERTY(CSCROLLVIEW_scroll_x)

  if (READ_PROPERTY)
    GB.ReturnInteger(WIDGET->contentsX());
  else
    WIDGET->setContentsPos(VPROP(GB_INTEGER), WIDGET->contentsY());

END_PROPERTY


BEGIN_PROPERTY(CSCROLLVIEW_scroll_y)

  if (READ_PROPERTY)
    GB.ReturnInteger(WIDGET->contentsY());
  else
    WIDGET->setContentsPos(WIDGET->contentsX(), VPROP(GB_INTEGER));

END_PROPERTY


BEGIN_METHOD(CSCROLLVIEW_scroll, GB_INTEGER x; GB_INTEGER y)

  WIDGET->setContentsPos(VARG(x), VARG(y));

END_METHOD


BEGIN_PROPERTY(CSCROLLVIEW_scrollbar)

  long scroll;

  if (READ_PROPERTY)
  {
    scroll = 0;
    if (WIDGET->hScrollBarMode() == QScrollView::Auto)
      scroll += 1;
    if (WIDGET->vScrollBarMode() == QScrollView::Auto)
      scroll += 2;

    GB.ReturnInteger(scroll);
  }
  else
  {
    scroll = VPROP(GB_INTEGER) & 3;
    WIDGET->setHScrollBarMode( (scroll & 1) ? QScrollView::Auto : QScrollView::AlwaysOff);
    WIDGET->setVScrollBarMode( (scroll & 2) ? QScrollView::Auto : QScrollView::AlwaysOff);
  }

END_PROPERTY


BEGIN_PROPERTY(CSCROLLVIEW_background)

  if (READ_PROPERTY)
    GB.ReturnInteger(THIS->container->paletteBackgroundColor().rgb() & 0xFFFFFF);
  else
    THIS->container->setPaletteBackgroundColor(QColor((QRgb)VPROP(GB_INTEGER)));

END_PROPERTY



/***************************************************************************

  Descriptions

***************************************************************************/

DECLARE_METHOD(CWIDGET_border);

GB_DESC CScrollViewDesc[] =
{
  GB_DECLARE("ScrollView", sizeof(CSCROLLVIEW)), GB_INHERITS("Container"),

  GB_METHOD("_new", NULL, CSCROLLVIEW_new, "(Parent)Container;"),

  GB_PROPERTY("ScrollBar", "i<Scroll>", CSCROLLVIEW_scrollbar),

  GB_PROPERTY("Background", "i", CSCROLLVIEW_background),
  GB_PROPERTY("BackColor", "i", CSCROLLVIEW_background),

  GB_PROPERTY("Border", "i<Border>", CWIDGET_border_full),

  GB_PROPERTY("ScrollX", "i", CSCROLLVIEW_scroll_x),
  GB_PROPERTY("ScrollY", "i", CSCROLLVIEW_scroll_y),
  GB_PROPERTY_READ("ClientX", "i", CSCROLLVIEW_client_x),
  GB_PROPERTY_READ("ClientY", "i", CSCROLLVIEW_client_y),
  GB_PROPERTY_READ("ClientW", "i", CSCROLLVIEW_client_width),
  GB_PROPERTY_READ("ClientH", "i", CSCROLLVIEW_client_height),
  GB_PROPERTY_READ("ClientWidth", "i", CSCROLLVIEW_client_width),
  GB_PROPERTY_READ("ClientHeight", "i", CSCROLLVIEW_client_height),
  GB_METHOD("Scroll", NULL, CSCROLLVIEW_scroll, "(X)i(Y)i"),
  //GB_PROPERTY("Arrangement", "i<Arrange>", CCONTAINER_arrangement),

  GB_CONSTANT("_Properties", "s", CSCROLLVIEW_PROPERTIES),

  GB_END_DECLARE
};


/***************************************************************************

  class CScrollView

***************************************************************************/

CScrollView CScrollView::manager;


bool CScrollView::eventFilter(QObject *o, QEvent *e)
{
  if (e->type() == QEvent::LayoutHint)
    qDebug("Layout hint %p", sender());

  return QObject::eventFilter(o, e);
}



