/***************************************************************************

  dump.c

  Class dumping

  (c) 2000-2004 Benot Minisini <gambas@users.sourceforge.net>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 1, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************/

#define __GBC_DUMP_C

#include <stdlib.h>
#include <string.h>
#include <stdio.h>

#include "gb_common.h"
#include "gb_error.h"

#include "gb_table.h"
#include "gbc_compile.h"
#include "gb_code.h"


PRIVATE void dump_name(long index)
{
  printf("%s", TABLE_get_symbol_name(JOB->class->table, index));
}


PRIVATE void dump_type(TYPE type, boolean as)
{
  long value;
  TYPE_ID id;
  CLASS_ARRAY *array;
  int i;

  id = TYPE_get_id(type);
  value = TYPE_get_value(type);

  if (id == T_ARRAY)
  {
    array = &JOB->class->array[value];

    printf("[");
    for (i = 0; i < array->ndim; i++)
    {
      if (i > 0)
        printf(",");
      printf("%ld", array->dim[i]);
    }
    printf("] AS ");
    dump_type(array->type, FALSE);
  }
  else if (id == T_OBJECT && value >= 0)
  {
    if (as)
      printf(" AS ");
    dump_name(JOB->class->class[value]);
  }
  else
  {
    if (as)
      printf(" AS ");
    printf("%s", TYPE_get_desc(type));
  }
}


PRIVATE void dump_function(FUNCTION *func)
{
  int i;

  printf("(");

  for (i = 0; i < func->nparam; i++)
  {
    if (i > 0) printf(", ");

    if (i == func->npmin)
      printf("OPTIONAL ");

    dump_name(func->param[i].index);
    dump_type(func->param[i].type, TRUE);
  }

  printf(")");
}



PUBLIC void CLASS_dump(void)
{
  int i;
  TYPE type;
  CLASS_SYMBOL *sym;
  CLASS *class = JOB->class;

  printf("\n");

  if (JOB->is_module)
    printf("MODULE ");
  else if (JOB->is_form)
    printf("FORM ");
  else
    printf("CLASS ");

  printf("%s\n\n", class->name);

  printf("Static size : %ld octets\n", class->size_stat);
  printf("Dynamic size : %ld octets\n\n", class->size_dyn);

  for (i = 0; i < TABLE_count(class->table); i++)
  {
    sym = CLASS_get_symbol(class, i);
    type = sym->global.type;
    if (TYPE_is_null(type))
      continue;

    if (TYPE_is_static(type)) printf("STATIC ");
    if (TYPE_is_public(type)) printf("PUBLIC "); else printf("PRIVATE ");

    switch(TYPE_get_kind(type))
    {
      case TK_VARIABLE:

        dump_name(i);
        dump_type(type, TRUE);
        break;

      case TK_FUNCTION:

        if (TYPE_get_id(type) == T_VOID)
          printf("PROCEDURE ");
        else
          printf("FUNCTION ");

        dump_name(i);
        dump_function(&class->function[sym->global.value]);

        break;

      case TK_CONST:

        printf("CONST ");
        dump_name(i);
        dump_type(type, TRUE);
        printf(" = ");
        dump_name(class->constant[sym->global.value].index);

        break;

      case TK_PROPERTY:

        printf("PROPERTY ");
        dump_name(i);
        dump_type(type, TRUE);
        break;

      case TK_EVENT:

        printf("EVENT ");
        dump_name(i);
        break;

      case TK_UNKNOWN: printf("UNKNOWN "); break;
      case TK_EXTERN: printf("EXTERN "); break;
      case TK_LABEL: printf("LABEL "); break;
    }

    printf("\n");

    /*
    if (TYPE_get_kind(type) == TK_FUNCTION)
    {
      func = &class->function[value];
      printf(" L:%ld", func->line);
    }
    else if (TYPE_get_kind(type) == TK_EVENT)
      func = (FUNCTION *)&class->event[value];
    else if (TYPE_get_kind(type) == TK_EXTERN)
    {
      func = (FUNCTION *)&class->ext_func[value];
      printf(" in %s", TABLE_get_symbol_name(class->table, class->ext_func[value].library));
    }
    */
  }

  printf("\n");
}


