import gnome, os, gobject, gio, time
from gnome import ui
from threading import Thread
from itertools import count

class Browser(object):
    new_id = count().next
    def __init__(self):
        self.dialog_builder = build_builder('browser')
        self.dialog = self.dialog_builder.get_object('dialog')
        self.list = self.dialog_builder.get_object('list')
        self.icons = self.dialog_builder.get_object('icons')
        self.filechooser = self.dialog_builder.get_object('filechooser')
        self.icons.set_text_column(1)
        self.icons.set_pixbuf_column(2)
                
        self.current_folder = gio.File('.').get_path()
#        print "self.current_folder", self.current_folder
        self.thumbnailer = Thumbnailer()
        self.thumbnailer.start()
        self.populate()
        self.alive = True
        gobject.timeout_add(100, self.monitor)
    
    def run(self):
        resp = self.dialog.run()
        self.thumbnailer.go = False
        if resp:
            return self.get_filenames()
        else:
            return None

    def destroy(self):
        self.alive = False
        self.dialog.destroy()
    
    def get_filenames(self):
        retval = []

        def iterator(iconview, path, *args):
            retval.append(os.path.realpath(os.curdir) + '/' + self.list.get_value(self.list.get_iter(path), 1))

        self.icons.selected_foreach(iterator)
        return retval

    def populate(self):
        self.list.clear()
        dir_content = os.listdir(os.curdir)
        dir_content.sort()
        self.thumbnailer.reset(dir_content)
        
    def monitor(self):
        if self.alive == False:
            return False
    
        if not self.filechooser.get_filename():
            time.sleep(.2)
            return True

        if self.current_folder != self.filechooser.get_filename():
            self.current_folder = self.filechooser.get_filename()
            os.chdir(self.current_folder)
            self.populate()
            return True

        while self.thumbnailer.done:
            thing, uri, thumbnail = self.thumbnailer.done.pop(0)
            self.list.append([self.new_id(), thing, thumbnail])

        return True


class Thumbnailer(Thread):
    def __init__(self):
        Thread.__init__(self)
        self.daemon = True
        self.go = True
        self.todo = []
        self.done = []
        self.thumbFactory = ui.ThumbnailFactory(gnome.ui.THUMBNAIL_SIZE_NORMAL)
    
    def reset(self, todo):
        self.res = False
        self.done = []
        self.todo = todo

    def run(self):
        while self.go:
            self.res = False
            if self.todo:
                thing = self.todo.pop(0)
                handler = gio.File(thing)
                info = handler.query_info('*')
                mime = info.get_content_type()

                if mime.startswith('image') or mime.startswith('video'):
                    thumbnail = None
                    uri = handler.get_uri()
                    if self.thumbFactory.can_thumbnail(uri, mime, 0):
                        thumbnail = self.thumbFactory.generate_thumbnail(uri, mime)
                else:
                    continue

                if thumbnail != None:
                    self.thumbFactory.save_thumbnail(thumbnail, uri, 0)
                    if not self.res:
                        self.done.append((thing, uri, thumbnail))
            else:
                time.sleep(.2)
