/*
 * (C) 2008 Ben Motmans <ben.motmans@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __LIBGALAXIUM_H__
#define __LIBGALAXIUM_H__

#include <stdbool.h>
#include <gst/gst.h>

typedef struct playInfo playInfo;

typedef void (* ManagedEosCallback) (playInfo *engine);
typedef void (* ManagedErrorCallback) (playInfo *engine, GQuark domain, gint code, const gchar *error, const gchar *debug);

struct playInfo
{
	GstElement *playbin;

	ManagedEosCallback eosCallback;
	ManagedErrorCallback errorCallback;
};

extern bool libgalaxium_cab_init ();
extern void libgalaxium_cab_destroy ();

extern bool libgalaxium_cab_extract (char* filename, char* directory);

extern void libgalaxium_gstreamer_init ();
extern void libgalaxium_gstreamer_set_eos_callback (playInfo* info, ManagedEosCallback callback);
extern void libgalaxium_gstreamer_set_error_callback (playInfo* info, ManagedErrorCallback callback);
extern playInfo* libgalaxium_gstreamer_open (char* filename);
extern void libgalaxium_gstreamer_close (playInfo* i);
extern void libgalaxium_gstreamer_play (playInfo* i);

#endif
