/*
 * Galaxium Messenger
 * 
 * Copyright (C) 2008 Paul Burton <paulburton89@gmail.com>
 * 
 * License: GNU General Public License (GPL)
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

using System;
using System.Text;

using Anculus.Core;

namespace Galaxium.Protocol.Msn
{
	[MsnP2PApplication (8, "5E288469-7693-4B64-A8DC-C56648E4397D")]
	public class P2PObjectLookup : AbstractMsnP2PSessionApplication
	{
		public override bool AutoAccept
		{
			get { return true; }
		}
		
		//public P2PObjectLookup ()
		//{
		//}
		
		public P2PObjectLookup (MsnP2PSession p2pSession)
			: base (p2pSession)
		{
		}
		
		public override bool CheckInvite (SLPRequestMessage invite)
		{
			return base.CheckInvite (invite);
		}
		
		public override string CreateInviteContext ()
		{
			//What is this??? I think it's a SHA1 hash, but what of?
			byte[] data = new byte[] { 0x96, 0x6E, 0xD1, 0x6A, 0x60, 0xBC, 0x1B, 0x40, 0x89, 0xE2,
									   0x5B, 0xB5, 0x45, 0xDD, 0x2B, 0xF0, 0x00, 0x00, 0x00, 0x00 };
			
			return Convert.ToBase64String (data);
		}
		
		public override bool ProcessMessage (IMsnP2PBridge bridge, P2PMessage msg)
		{
			Log.Debug ("{0}", msg);
			
#if debug
			return false;
#else
			// If we're not debugging then we should try to continue even if we don't understand this message
			return true;
#endif
		}
	}
}
