/*
 * Galaxium Messenger
 * 
 * Copyright (C) 2008 Paul Burton <paulburton89@gmail.com>
 * 
 * License: GNU General Public License (GPL)
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

using System;

namespace Galaxium.Protocol.Msn
{
	public interface IMsnP2PApplication : IDisposable
	{
		event EventHandler Complete;
		event EventHandler Error;
		
		uint AppID { get; }
		
		IMsnP2PBridge Bridge { get; }
		MsnAccount Local { get; }
		MsnContact Remote { get; }
		MsnSession Session { get; }
		
		//.ctor (MsnAccount local, MsnContact remote);
		
		bool ProcessMessage (IMsnP2PBridge bridge, P2PMessage msg);
		void Send (P2PMessage msg);
	}

	public interface IMsnP2PSessionApplication : IMsnP2PApplication
	{
		event EventHandler Began;
		event EventHandler LocallyCancelled;
		event EventHandler RemotelyCancelled;
		
		bool AutoAccept { get; }
		MsnP2PSession P2PSession { get; set; }
		
		//.ctor (MsnP2PSession p2pSession);
		//.ctor (MsnAccount local, MsnContact remote);
		
		bool CheckInvite (SLPRequestMessage invite);
		string CreateInviteContext ();
		
		void Begin ();
		
		void Accept ();
		void Decline ();
		void Cancel ();
	}
}
