/*
 * Galaxium Messenger
 * 
 * Copyright (C) 2003 Philippe Durand <draekz@gmail.com>
 * 
 * License: GNU General Public License (GPL)
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

using System;
using System.Reflection;

using G=Gtk;
using Mono.Addins;
using Galaxium.Core;

namespace Galaxium.Gui.GtkGui
{
	public abstract class MenuExtension : ContextExtension
	{
		public abstract G.MenuItem GetMenuItem (G.MenuItem item);
		
		protected Gtk.Window Window
		{
			get
			{
				if (Context.Object is Gtk.Window)
					return Context.Object as Gtk.Window;
				
				PropertyInfo prop = Context.Object.GetType ().GetProperty ("NativeWidget");
				
				if (prop != null)
					return (prop.GetValue (Context.Object, null) as Gtk.Widget).Toplevel as Gtk.Window;
				
				return null;
			}
		}
	}
}