/*
 * Galaxium Messenger
 * Copyright (C) 2007 Ben Motmans <ben.motmans@gmail.com>
 * 
 * License: GNU General Public License (GPL)
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

using System;
using System.Collections.Generic;
using Mono.Addins;
using Galaxium.Protocol;

namespace Galaxium.Client
{
	public static class CommandInputHandlerUtility
	{
		private static Dictionary<string, Dictionary<string, ICommandInputHandler>> _handlers;

		static CommandInputHandlerUtility ()
		{
			_handlers = new Dictionary<string, Dictionary<string, ICommandInputHandler>> ();
			
			foreach (CommandInputHandlerExtension ext in AddinManager.GetExtensionNodes ("/Galaxium/CommandInputHandlers")) {
				ICommandInputHandler handler = ext.CommandInputHandler;
				if (handler != null) {
					foreach (IProtocol protocol in handler.SupportedProtocols) {
						Dictionary<string, ICommandInputHandler> handlers = null;
						if (!_handlers.TryGetValue (protocol.Name, out handlers)) {
							handlers = new Dictionary<string,ICommandInputHandler> ();
							_handlers.Add (protocol.Name, handlers);
						}
						
						foreach (string command in handler.SupportedCommands)
							handlers.Add (command.ToLower (), handler);
					}
				}
			}
		}
		
		public static ICommandInputHandler GetCommandInputHandler (IProtocol protocol, string command)
		{
			if (protocol == null)
				throw new ArgumentNullException ("protocol");
			if (command == null)
				throw new ArgumentNullException ("command");
			
			command = command.ToLower ();
			
			Dictionary<string, ICommandInputHandler> handlers = null;
			if (_handlers.TryGetValue (protocol.Name, out handlers)) {
				ICommandInputHandler handler = null;
				if (handlers.TryGetValue (command, out handler))
					return handler;
			}

			return null;
		}
	}
}