/*
 * Galaxium Messenger
 * Copyright (C) 2007 Ben Motmans <ben.motmans@gmail.com>
 * Copyright (C) 2007 Philippe Durand <draekz@gmail.com>
 * 
 * License: GNU General Public License (GPL)
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

using System;
using System.Text;
using System.Collections.Generic;

using Gtk;
using Gdk;
using GLib;

using Galaxium.Core;
using Galaxium.Gui;
using Galaxium.Gui.GtkGui;
using Galaxium.Client;

namespace Galaxium.Client.GtkGui
{
	public sealed class PluginTreeNodeBuilder : ITreeNodeBuilder<HintTreeNodeRenderer>
	{
		public string ContextMenuExtensionPoint
		{
			get { return "/Galaxium/Gui/PreferenceTree/ContextMenu/Plugin"; }
		}

		public bool HasDynamicChildNodes (TreeNodeContext context)
		{
			return false;
		}

		public Type NodeType
		{
			get { return typeof (PreferenceWidgetExtension); }
		}

		public void RenderIcon (TreeNodeContext context, HintTreeNodeRenderer renderer, ITreeNodeWidget widget)
		{
			DefaultTreeNodeWidget nodeWidget = widget as DefaultTreeNodeWidget;
			if (nodeWidget != null) {
				CellRendererPixbuf cell = nodeWidget.GetPixbufRenderer ();
				if (cell != null) {
					PreferenceWidgetExtension ext = context.NodeObject as PreferenceWidgetExtension;
					renderer.RenderIcon (cell, ext.Icon, false);
				}
			}
		}

		public void RenderText (TreeNodeContext context, HintTreeNodeRenderer renderer, ITreeNodeWidget widget)
		{
			DefaultTreeNodeWidget nodeWidget = widget as DefaultTreeNodeWidget;
			if (nodeWidget != null) {
				CellRendererText cell = nodeWidget.GetTextRenderer ();
				if (cell != null) {
					PreferenceWidgetExtension ext = context.NodeObject as PreferenceWidgetExtension;
					renderer.RenderText (cell, ext.Name, false);
				}
			}
		}

		public void BuildDynamicChildNodes (TreeNodeContext context)
		{
		}

		public void NodeActivated (TreeNodeContext context)
		{
		}

		public string GetComparableContent (TreeNodeContext context)
		{
			return (context.NodeObject as PreferenceWidgetExtension).Name;
		}
	}
}