namespace GalagoTests
{
	using System;
	using Galago;
	using Gtk;

	public class PresenceFeed
	{
		public static int Main(string[] args)
		{
			Application.Init();

			DBus.Connection conn = DBus.Bus.GetSessionBus();

			if (!Galago.Core.InitFeed("test-feed"))
			{
				Console.WriteLine("Unable to initialize Galago");

				return 1;
			}

			SetupInfo();

			Application.Run();

			Galago.Core.Uninit();

			return 0;
		}

		private static void SetupInfo()
		{
			Service aimService, jabberService;
			Status status;
			Account account;
			Account contact;
			Person person;
			Person me;
			Presence presence;

			/* Setup our services */
			aimService    = new Service("aim", "AOL Instant Messenger");
			jabberService = new Service("jabber", "Jabber");

			/* Create our local person */
			me = Person.GetMe(true);

			/* Setup our person's AIM account */
			account  = new Account(aimService, me, "GalagoAIMUser");
			presence = new Presence(account);

			presence.SetIdle(true, 60 * 5);

			status = new Status(StatusType.Away, "away", "Away");
			status.SetAttribute("message", "I'm eating dinner.");

			presence.AddStatus(status);

			/* Add contacts to our AIM account */
			person   = new Person("gonkulator-1");
			contact  = new Account(aimService, person, "lottabs2");
			presence = new Presence(contact);

			presence.SetIdle(true, 60 * 20);
			account.AddContact(contact);

			/* Setup our person's Jabber account */
			account = new Account(jabberService, me,
								  "jabberuser@galago.sf.net");
			presence = new Presence(account);

			status = new Status(StatusType.Available, "available", "Available");
			presence.AddStatus(status);

			/* Add contacts to our Jabber account */
			person   = new Person("cae-1", true);
			contact  = new Account(jabberService, person, "caedan@jabber.org");
			presence = new Presence(contact);

			status = new Status(StatusType.Available, "available", "Available");
			presence.AddStatus(status);

			account.AddContact(contact);

			contact = new Account(jabberService, person, "caelum@chipx86.com");
			presence = new Presence(contact);

			status = new Status(StatusType.Offline, "offline", "Offline");
			presence.AddStatus(status);

			account.AddContact(contact);
		}
	}
}
