namespace GalagoTests
{
	using System;
	using Galago;

	public class GetPresence
	{
		public static int Main(string[] args)
		{
			if (args.Length != 2)
			{
				Console.WriteLine("Usage: get-presence.exe service-id " +
								  "username");
				return 1;
			}

			if (!Galago.Core.Init("get-presence"))
			{
				Console.WriteLine("Unable to initialize Galago");

				return 1;
			}

			string service_id = args[0];
			string username   = args[1];

			Service service = Galago.Core.GetService(service_id, false, true);

			if (service == null)
			{
				Console.WriteLine("Unknown service: " + service_id);
				return 1;
			}

			Account account = service.GetAccount(username, true);

			if (account == null)
			{
				Console.WriteLine("Unknown account " + username +
								  "on service " + service_id);
				return 1;
			}

			Person person = account.Person;

			Console.WriteLine("Service:      " + service.Name);
			Console.WriteLine("Username:     " + account.UserName);
			Console.WriteLine("Display name: " + account.DisplayName);

			Presence presence = account.Presence;

			if (presence == null)
			{
				Console.WriteLine("No presence");
			}
			else
			{
				Console.WriteLine("Idle:         " + presence.Idle);
				Console.WriteLine("Idle Time:    " + presence.IdleTime);

				Console.WriteLine("Status(es):");

				List statuses = presence.Statuses;

				foreach (Status status in statuses)
				{
					Console.WriteLine("\tType:    " + status.Type);
					Console.WriteLine("\tID:      " + status.Id);
					Console.WriteLine("\tName:    " + status.Name);
				}
			}

			Galago.Core.Uninit();

			return 0;
		}
	}
}
