/* GAdmin-OpenVPN - An easy to use GTK+ frontend for the openvpn client.
 * Copyright (C) 2008 - 2009 Magnus Loef <magnus-swe@telia.com> 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
*/



#include "../config.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <dirent.h>
#include "gettext.h"
#include "widgets.h"
#include "show_info.h"
#include "allocate.h"
#include "chars_are_digits.h"
#include "populate_client_settings.h"
#include "populate_conf_tab.h"
#include "commented.h"
#include "functions.h"


extern gchar *selected_connection;



void connection_treeview_row_clicked(GtkTreeView *treeview, GdkEventButton *event,
								gpointer data)
{
    GtkTreeIter iter;
    GtkTreePath *path;
    GtkTreeModel *list_store;
    GtkTreeSelection *selection;

    /* The left button is pressed */
    if( ! event->type == GDK_BUTTON_PRESS || ! event->button == 1 )
      return;

    selection = gtk_tree_view_get_selection(GTK_TREE_VIEW(treeview));

    if( gtk_tree_selection_count_selected_rows(selection) <= 1 )
    {
			/* Get the treepath for the row that was clicked */
         if( gtk_tree_view_get_path_at_pos(GTK_TREE_VIEW(treeview), event->x, event->y,
				                                &path, NULL, NULL, NULL))
         {
	    gtk_tree_selection_unselect_all(selection);
	    gtk_tree_selection_select_path(selection, path);

	    if( selected_connection!=NULL )
	      g_free(selected_connection);

	    list_store = gtk_tree_view_get_model(GTK_TREE_VIEW(treeview));
	    gtk_tree_model_get_iter(list_store, &iter, path);
	    gtk_tree_model_get(list_store, &iter, 0, &selected_connection, -1);

            gtk_tree_path_free(path);

	    populate_client_settings(data);
	    populate_conf_tab(data);
	 }
    }
}


// Move to apply settings ?
void remove_all_selected_lines()
{
    FILE *fp;
    long file_size = 0;
    char *line, *tmp;
    long num = 0, x = 0;
    struct dirent **namelist;
    gchar *conf, *connections_path;

    connections_path = g_strdup_printf("%s/client/", OPENVPN_SYSCONF_DIR);

    num = scandir(connections_path, &namelist, 0, alphasort);
    if( num < 0 )
    {
	/* Dont notify */
        g_free(connections_path);
        return;
    }
    /* List all directories in locations_path */
    for(x=0; x<num; x++)
    {
	/* Append the location names in the treeview but not "." or ".." */
	if( x > 1 )
	{
	    /* Read the config file and if it contains a name line:
	       "# Connection_name: Name" then add it as the selected_connection. */
	    conf = g_strdup_printf("%s/client/%s/gadmin-openvpn-client.conf", OPENVPN_SYSCONF_DIR, namelist[x]->d_name);
	    if((fp=fopen(conf, "r"))==NULL)
	    {
		g_free(conf);
		free(namelist[x]);
		continue;
	    }
	    fseek(fp, 0, SEEK_END);
	    file_size = ftell(fp);
	    rewind(fp);

	    line = allocate(file_size+1);
	    tmp  = allocate(file_size+1);

	    if( file_size > 1 )
	    while(fgets(line, file_size, fp)!=NULL)
	    {
		/* Remove the commented "Connection_selected" line from the configuration file. */
		if( cmplowercase(line, "connection_selected") && commented(line) )
		{
		    continue;
		}
		strcat(tmp, line);
	    }
	    fclose(fp);
	    free(line);

	    /* Write the changed conf */
	    if((fp=fopen(conf, "w+"))==NULL)
	    {
		free(namelist[x]);
		free(line);
		free(tmp);
		g_free(conf);
		continue;
	    }
	    fputs(tmp, fp);
	    fclose(fp);
	    g_free(conf);
	    free(tmp);
	}
        free(namelist[x]);
    }
    g_free(connections_path);
    free(namelist);
}


void populate_connections(struct w *widgets)
{
    FILE *fp;
    int i = 0, have_name = 0;
    int have_selection = 0;
    long file_size = 0;
    char *line, *tmp;
    long num = 0, x = 0;
    struct dirent **namelist;
    GtkTreeIter iter;
    gchar *utf8, *conf, *connections_path;

    gtk_list_store_clear(widgets->connection_store);

    connections_path = g_strdup_printf("%s/client/", OPENVPN_SYSCONF_DIR);

    num = scandir(connections_path, &namelist, 0, alphasort);
    if( num < 0 )
    {
	/* Dont notify */
        g_free(connections_path);
        return;
    }
    /* List all directories in locations_path */
    for(x=0; x<num; x++)
    {
	/* Append the location names in the treeview but not "." or ".." */
	if( x > 1 )
	{
	    /* Read the config file and if it contains a name line:
	       "# Connection_name: Name" then add it as the selected_connection. */
	    conf = g_strdup_printf("%s/client/%s/gadmin-openvpn-client.conf", OPENVPN_SYSCONF_DIR, namelist[x]->d_name);
	    if((fp=fopen(conf, "r"))==NULL)
	    {
		g_free(conf);
		free(namelist[x]);
		continue;
	    }
	    fseek(fp, 0, SEEK_END);
	    file_size = ftell(fp);
	    rewind(fp);

	    line = allocate(file_size);
	    tmp  = allocate(file_size);

	    if( file_size > 1 )
	    while(fgets(line, file_size, fp)!=NULL)
	    {
		if( line==NULL || strlen(line) < 10 || strlen(line) > 70 )
		continue;

		/* Insert the commented connection name from the configuration file. */
		if( cmplowercase(line, "connection_name: ") && commented(line) )
		{
		    for(i=0; line[i]!='\0'; i++)
		      if( line[i]==':' )
		        break;
		    for(i=i+1; line[i]!='\0'; i++)
		      if( line[i]!=' ' )
		        break;
		    snprintf(tmp, 50, "%s", &line[i]);
		    if( tmp[strlen(tmp)-1]=='\r' || tmp[strlen(tmp)-1]=='\n' )
		        tmp[strlen(tmp)-1]='\0';
		    if( tmp[strlen(tmp)-1]=='\r' || tmp[strlen(tmp)-1]=='\n' )
		        tmp[strlen(tmp)-1]='\0';

		    gtk_list_store_append(GTK_LIST_STORE(widgets->connection_store), &iter);
		    utf8 = g_locale_to_utf8(tmp, strlen(tmp), NULL, NULL, NULL);
		    gtk_list_store_set(GTK_LIST_STORE(widgets->connection_store), &iter, 0, utf8, -1);
		    if(utf8!=NULL)
		      g_free(utf8);
		
		    have_name = 1;
		}
		if( cmplowercase(line, "connection_selected")
		&& ! have_selection && commented(line) )
		{
		    /* Set this as the selected connection */
		    if( selected_connection!=NULL )
		      g_free(selected_connection);
		    selected_connection = g_strdup_printf("%s", tmp);

		    /* We have a valid configuration selection. */
		    have_selection = 1;
		}
	    }
	    fclose(fp);
	    free(line);
	    free(tmp);
	    g_free(conf);

	    /* Use the directory name if theres no name for this connection. */
	    if( ! have_name )
	    {
		gtk_list_store_append(GTK_LIST_STORE(widgets->connection_store), &iter);
		utf8 = g_locale_to_utf8(namelist[x]->d_name, strlen(namelist[x]->d_name), NULL, NULL, NULL);
		gtk_list_store_set(GTK_LIST_STORE(widgets->connection_store), &iter, 0, utf8, -1);
		if(utf8!=NULL)
		  g_free(utf8);

		/* Set this as the selected connection if none are selected. */
		if( ! have_selection )
		{
		    if( selected_connection!=NULL )
		      g_free(selected_connection);
		    selected_connection = g_strdup_printf("%s", namelist[x]->d_name);
		}
	    }
	    have_name = 0;
	}
        free(namelist[x]);
    }
    g_free(connections_path);
    free(namelist);
}



void select_row_with_name(gchar *name, struct w *widgets)
{
    GtkTreeSelection *selection;
    gchar *temp_name, *saved_name = NULL;
    GtkTreeIter iter;
    gboolean edit = 0;
    GtkTreePath *path;
    int have_rows = 0, row_selected = 0;

    if( widgets->connection_store )
    {
	selection = gtk_tree_view_get_selection(GTK_TREE_VIEW(widgets->connection_treeview));
	if( ! selection )
	  return;

        if( gtk_tree_model_get_iter_first(GTK_TREE_MODEL(widgets->connection_store), &iter) )
        {
            do {
                    gtk_tree_model_get(GTK_TREE_MODEL(widgets->connection_store), &iter, 0, &temp_name, -1);

		    if( ! have_rows )
		    {
			have_rows = 1;
			saved_name = g_strdup_printf("%s", temp_name);
		    }

		    if( name!=NULL && temp_name!=NULL )
		    {
			if( ! strcmp(name, temp_name) )
			{
			    path = gtk_tree_model_get_path(GTK_TREE_MODEL(widgets->connection_store), &iter);
			    gtk_tree_selection_select_path(selection, path);
			    gtk_tree_view_set_cursor(GTK_TREE_VIEW(widgets->connection_treeview), path, NULL, edit);
			    gtk_tree_path_free(path);

			    row_selected = 1;
			    break;
			}
		    }
		    if( temp_name!=NULL )
		      g_free(temp_name);

                }  while(gtk_tree_model_iter_next(GTK_TREE_MODEL(widgets->connection_store), &iter));
         }
    }

    /* Select the first row and name if exists and if no row have been selected */
    if( ! row_selected && have_rows )
    {
	path = gtk_tree_path_new_first();

	selection = gtk_tree_view_get_selection(GTK_TREE_VIEW(widgets->connection_treeview));
	//if( ! selection )
	//  return;

	gtk_tree_selection_select_path(selection, path);
	gtk_tree_view_set_cursor(GTK_TREE_VIEW(widgets->connection_treeview), path, NULL, edit);
	gtk_tree_path_free(path);

	if( selected_connection!=NULL )
	  g_free(selected_connection);

	selected_connection = g_strdup_printf("%s", saved_name);
    }
    if( saved_name!=NULL )
      g_free(saved_name);
}


void populate_client_settings(struct w *widgets)
{
    /* Populates the values for the client in the client tab */
    FILE *fp, *fp1;
    int i = 0, have_name = 0, have_sysinit_script = 0;
    long file_size  = 0;
    long file_size1 = 0;
    char *line, *tmp, *line1, *tmp1;
    gchar *info, *utf8 = NULL;
    gchar *openvpn_client_conf;
    gchar *openvpn_sysinit_script;

    /* Select a row that matches the selected connection name */
    select_row_with_name(selected_connection, widgets);

    /* Clear all entries */
    for(i=0; i<4; i++)
      gtk_entry_set_text(GTK_ENTRY(widgets->client_set_entry[i]), "");

    /* Set combo defaults */
    gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->client_set_combo[0]), 0);
    gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->client_set_combo[1]), 0);
    gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->client_set_combo[2]), 0);
    gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->client_set_combo[3]), 0);

    /* These combos are set from the sysinit script. Fix: changing connections wont change these! */
    gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->client_set_combo[4]), 0);
    gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->client_set_combo[5]), 0);
    gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->client_set_combo[6]), 0);

    /* Set spin button values to 0 */
    for(i=0; i<3; i++)
      gtk_spin_button_set_value(GTK_SPIN_BUTTON(widgets->client_set_spinbutton[i]), 0);

    /* Set default openvpn port */
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(widgets->client_set_spinbutton[0]), 1194);

    if( selected_connection == NULL || strlen(selected_connection) < 3 )
    {
	/* Dont notify */
	return;
    }

    /* Set default passfile path in the entry */
    info = g_strdup_printf("%s/client/%s/passfile", OPENVPN_SYSCONF_DIR, selected_connection);
    utf8 = g_locale_to_utf8(info, strlen(info), NULL, NULL, NULL);
    gtk_entry_set_text(GTK_ENTRY(widgets->client_set_entry[4]), utf8);
    if( utf8!=NULL )
      g_free(utf8);
    g_free(info);

    /* Insert values from gadmin-openvpn-client.conf */
    openvpn_client_conf = g_strdup_printf("%s/client/%s/gadmin-openvpn-client.conf", OPENVPN_SYSCONF_DIR, selected_connection);

    if((fp=fopen(openvpn_client_conf, "r"))==NULL)
    {
	info = g_strdup_printf("%s %s", _("Error: Can not open file:\n"), openvpn_client_conf);
        show_info(info);
        g_free(info);
        g_free(openvpn_client_conf);
	return;
    }
    fseek(fp, 0, SEEK_END);
    file_size = ftell(fp);
    rewind(fp);

    line = allocate(file_size);
    tmp  = allocate(1024);

    if( file_size > 1 )
    while(fgets(line, file_size, fp)!=NULL)
    {
        if( line==NULL || strlen(line) > 1000 )
          continue;

	/* Insert connection name if there is one. */
	if( cmplowercase(line, "connection_name: ") && commented(line) )
	{
	    for(i=0; line[i]!='\0'; i++)
	      if( line[i]==':' )
	        break;
	    for(i=i+1; line[i]!='\0'; i++)
	      if( line[i]!=' ' )
	        break;
	    snprintf(tmp, 50, "%s", &line[i]);
	    if( tmp[strlen(tmp)-1]=='\r' || tmp[strlen(tmp)-1]=='\n' )
	        tmp[strlen(tmp)-1]='\0';
	    if( tmp[strlen(tmp)-1]=='\r' || tmp[strlen(tmp)-1]=='\n' )
	        tmp[strlen(tmp)-1]='\0';
	
	    utf8 = g_locale_to_utf8(tmp, strlen(tmp), NULL, NULL, NULL);
	    gtk_entry_set_text(GTK_ENTRY(widgets->client_set_entry[0]), utf8);
	    if( utf8!=NULL )
	      g_free(utf8);

	    have_name = 1;
	}

        if( line==NULL || strlen(line) < 4 || commented(line) )
          continue;

	/* Remote server address */
	if( cmplowercase(line, "remote ") )
	{
	    for(i=0; line[i]!='\0'; i++)
	      if( line[i]!=' ')
	        break;

	    for(i=i; line[i]!='\0'; i++)
	      if( line[i]==' ' && line[i+1]!=' ' )
	        break;
	
	    snprintf(tmp, 1000, "%s", &line[i+1]);

	    /* Cut away the last port bit */
	    for(i=strlen(tmp)-1; tmp[i]!='\0'; i--)
	      if( tmp[i-1]!=' ' && tmp[i]==' ' )
	        break;

	    tmp[i]='\0';

	    utf8 = g_locale_to_utf8(tmp, strlen(tmp), NULL, NULL, NULL);
	    gtk_entry_set_text(GTK_ENTRY(widgets->client_set_entry[1]), utf8);
	    if( utf8!=NULL )
	      g_free(utf8);

	    /* Remote server port */
	    for(i=strlen(line)-1; line[i]!='\0'; i--)
	      if( line[i-1]==' ' && line[i]!=' ' )
	        break;
	
	    snprintf(tmp, 1000, "%s", &line[i]);
	    if( tmp[strlen(tmp)-1]=='\n')
	      tmp[strlen(tmp)-1]='\0';

	    if( chars_are_digits(tmp) )
	    {
		i = atoi(tmp);
		gtk_spin_button_set_value(GTK_SPIN_BUTTON(widgets->client_set_spinbutton[0]), i);
	    }
	}

	/* Username: auth-user-pass: read the path/passfile */
	if( cmplowercase(line, "auth-user-pass ") )
	{
	    /* Get the path */
	    for(i=0; line[i]!='\0'; i++)
	      if( line[i]!=' ')
	        break;

	    for(i=i; line[i]!='\0'; i++)
	      if( line[i]==' ' && line[i+1]!=' ' )
	        break;
	
	    snprintf(tmp, 1000, "%s", &line[i+1]);
	    if( tmp[strlen(tmp)-1]=='\n')
	      tmp[strlen(tmp)-1]='\0';

	    /* Insert the path into the passfile entry */
	    utf8 = g_locale_to_utf8(tmp, strlen(tmp), NULL, NULL, NULL);
	    gtk_entry_set_text(GTK_ENTRY(widgets->client_set_entry[4]), utf8);
	    if( utf8!=NULL )
	      g_free(utf8);

	    /* Open this path and get the username from the first row in the file */
	    if((fp1=fopen(tmp, "r"))==NULL)
	    {
		/* Do nothing */
	    }
	    else
	    {
		fseek(fp1, 0, SEEK_END);
		file_size1 = ftell(fp1);
		rewind(fp1);

		line1 = allocate(file_size1);
		tmp1  = allocate(1024);

		if( file_size1 > 1 )
		while(fgets(line1, file_size1, fp1)!=NULL)
		{
		    if( line1==NULL || strlen(line1) < 3 || commented(line1) )
		      continue;

		    snprintf(tmp1, 1000, "%s", line1);
		    if( tmp1[strlen(tmp1)-1]=='\n')
		      tmp1[strlen(tmp1)-1]='\0';

		    /* Insert the username */
		    utf8 = g_locale_to_utf8(tmp1, strlen(tmp1), NULL, NULL, NULL);
		    gtk_entry_set_text(GTK_ENTRY(widgets->client_set_entry[2]), utf8);
		    if( utf8!=NULL )
		      g_free(utf8);

		    /* Break after the first line/username read and inserted if any */
		    break;
		}
		fclose(fp1);
		free(line1);
		free(tmp1);
	    }
	}

        /* Combo: Protocol */
	if( cmplowercase(line, "proto ") )
	{
	    if( cmplowercase(line, "tcp") )
	    {
		gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->client_set_combo[0]), 0);
	    }
	    else
	    if( cmplowercase(line, "udp") )
	    {
		gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->client_set_combo[0]), 1);
	    }
	    else
	    {
		printf("Populate_client_settings.c: I have no choise for this proto\n");
	    }
	}

	/* Combo: TAP device name */
	if( cmplowercase(line, "dev ") )
	{
	    if( cmplowercase(line, "tap0") )
	    {
		gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->client_set_combo[1]), 0);
	    }
	    else
	    if( cmplowercase(line, "tap1") )
	    {
		gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->client_set_combo[1]), 1);
	    }
	    else
	    if( cmplowercase(line, "tap2") )
	    {
		gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->client_set_combo[1]), 2);
	    }
	    else
	    if( cmplowercase(line, "tap3") )
	    {
		gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->client_set_combo[1]), 3);
	    }
	    else
	    {
		printf("Populate_client_settings.c: I have no choise for this dev\n");
	    }
	}

	/* Combo: Encryption type */
	if( cmplowercase(line, "cipher ") )
	{
	    if( cmplowercase(line, "bf-cbc") )
	    {
		gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->client_set_combo[2]), 0);
	    }
	    else
	    if( cmplowercase(line, "aes-128-cbc") )
	    {
		gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->client_set_combo[2]), 1);
	    }
	    else
	    if( cmplowercase(line, "aes-256-cbc") )
	    {
		gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->client_set_combo[2]), 2);
	    }
	    else
	    if( cmplowercase(line, "des-ede3-cbc") )
	    {
		gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->client_set_combo[2]), 3);
	    }
	    else
	    {
		printf("Populate_client_settings.c: I have no choise for this cipher\n");
	    }
	}

	/* Combo: Use compression */
	if( cmplowercase(line, "comp-lzo") )
	{
	    gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->client_set_combo[3]), 1);
	}

	/* Spin: Loglevel / verbosity */
	if( cmplowercase(line, "verb ") )
	{
	    for(i=0; line[i]!='\0'; i++)
	      if( line[i]!=' ' )
	        break;

	    for(i=i; line[i]!='\0'; i++)
	      if( line[i]==' ' && line[i+1]!=' ' )
	        break;
	
	    snprintf(tmp, 1000, "%s", &line[i+1]);
	    if( tmp[strlen(tmp)-1]=='\n')
	      tmp[strlen(tmp)-1]='\0';

	    if( chars_are_digits(tmp) )
	    {
		i = atoi(tmp);
		gtk_spin_button_set_value(GTK_SPIN_BUTTON(widgets->client_set_spinbutton[1]), i);
	    }
	}



	/* LAN specific options are collected from the sysinit start script */



	/* Proxy server: "http-proxy ProxyServer Port" and http-proxy-retry */
	if( cmplowercase(line, "http-proxy ") )
	{
	    for(i=0; line[i]!='\0'; i++)
	      if( line[i]!=' ')
	        break;

	    for(i=i; line[i]!='\0'; i++)
	      if( line[i]==' ' && line[i+1]!=' ' )
	        break;
	
	    snprintf(tmp, 1000, "%s", &line[i+1]);

	    /* Cut away the last port bit */
	    for(i=strlen(tmp)-1; tmp[i]!='\0'; i--)
	      if( tmp[i-1]!=' ' && tmp[i]==' ' )
	        break;

	    tmp[i]='\0';

	    utf8 = g_locale_to_utf8(tmp, strlen(tmp), NULL, NULL, NULL);
	    gtk_entry_set_text(GTK_ENTRY(widgets->client_set_entry[6]), utf8);
	    if( utf8!=NULL )
	      g_free(utf8);

	    /* Proxy server port: */
	    for(i=strlen(line)-1; line[i]!='\0'; i--)
	      if( line[i-1]==' ' && line[i]!=' ' )
	        break;
	
	    snprintf(tmp, 1000, "%s", &line[i]);
	    if( tmp[strlen(tmp)-1]=='\n')
	      tmp[strlen(tmp)-1]='\0';

	    if( chars_are_digits(tmp) )
	    {
		i = atoi(tmp);
		gtk_spin_button_set_value(GTK_SPIN_BUTTON(widgets->client_set_spinbutton[2]), i);
	    }
	}


	/* Ca cert */
	if( cmplowercase(line, "ca ") && cmplowercase(line, " certs/")
	&&  line[0]=='c' && line[1]=='a' && line[2]==' ' )
	{
	    for(i=0; line[i]!='\0'; i++)
	      if( line[i]=='/' )
	        break;

	    snprintf(tmp, 1000, "%s", &line[i+1]);
	    if( tmp[strlen(tmp)-1]=='\n' )
	      tmp[strlen(tmp)-1]='\0';

	    utf8 = g_locale_to_utf8(tmp, strlen(tmp), NULL, NULL, NULL);
	    gtk_entry_set_text(GTK_ENTRY(widgets->client_set_entry[7]), utf8);
	    if( utf8!=NULL )
	      g_free(utf8);
	}
	/* Cert */
	if( cmplowercase(line, "cert ") && cmplowercase(line, " certs/")
	&&  line[0]=='c' && line[1]=='e' && line[2]=='r' && line[3]=='t' && line[4]==' ' )
	{
	    for(i=0; line[i]!='\0'; i++)
	      if( line[i]=='/' )
	        break;

	    snprintf(tmp, 1000, "%s", &line[i+1]);
	    if( tmp[strlen(tmp)-1]=='\n' )
	      tmp[strlen(tmp)-1]='\0';

	    utf8 = g_locale_to_utf8(tmp, strlen(tmp), NULL, NULL, NULL);
	    gtk_entry_set_text(GTK_ENTRY(widgets->client_set_entry[8]), utf8);
	    if( utf8!=NULL )
	      g_free(utf8);
	}
	/* Key */
	if( cmplowercase(line, "key ") && cmplowercase(line, " certs/")
	&&  line[0]=='k' && line[1]=='e' && line[2]=='y' && line[3]==' ' )
	{
	    for(i=0; line[i]!='\0'; i++)
	      if( line[i]=='/' )
	        break;

	    snprintf(tmp, 1000, "%s", &line[i+1]);
	    if( tmp[strlen(tmp)-1]=='\n' )
	      tmp[strlen(tmp)-1]='\0';

	    utf8 = g_locale_to_utf8(tmp, strlen(tmp), NULL, NULL, NULL);
	    gtk_entry_set_text(GTK_ENTRY(widgets->client_set_entry[9]), utf8);
	    if( utf8!=NULL )
	      g_free(utf8);
	}
	/* DH */
	if( cmplowercase(line, "dh ") && cmplowercase(line, " certs/")
	&&  line[0]=='d' && line[1]=='h' && line[2]==' ' )
	{
	    for(i=0; line[i]!='\0'; i++)
	      if( line[i]=='/' )
	        break;

	    snprintf(tmp, 1000, "%s", &line[i+1]);
	    if( tmp[strlen(tmp)-1]=='\n' )
	      tmp[strlen(tmp)-1]='\0';

	    utf8 = g_locale_to_utf8(tmp, strlen(tmp), NULL, NULL, NULL);
	    gtk_entry_set_text(GTK_ENTRY(widgets->client_set_entry[10]), utf8);
	    if( utf8!=NULL )
	      g_free(utf8);
	}
	/* TLS-AUTH */
	if( cmplowercase(line, "tls-auth ") && cmplowercase(line, " certs/")
	&&  line[0]=='t' && line[1]=='l' && line[2]=='s' && line[3]=='-' && line[4]=='a' )
	{
	    for(i=0; line[i]!='\0'; i++)
	      if( line[i]=='/' )
	        break;

	    snprintf(tmp, 1000, "%s", &line[i+1]);
	    if( tmp[strlen(tmp)-1]=='\n' )
	      tmp[strlen(tmp)-1]='\0';

	    /* Snip the last space before "1" */
	    for(i=0; tmp[i]!='\0'; i++)
	      if( tmp[i]==' ' )
	        break;
	    tmp[i]='\0';

	    utf8 = g_locale_to_utf8(tmp, strlen(tmp), NULL, NULL, NULL);
	    gtk_entry_set_text(GTK_ENTRY(widgets->client_set_entry[11]), utf8);
	    if( utf8!=NULL )
	      g_free(utf8);
	}
    }
    fclose(fp);
    free(line);
    free(tmp);
    g_free(openvpn_client_conf);


    if( ! have_name )
    {
	tmp  = allocate(100);
	snprintf(tmp, 50, "%s", "Imported-Setup");
	
	utf8 = g_locale_to_utf8(tmp, strlen(tmp), NULL, NULL, NULL);
	gtk_entry_set_text(GTK_ENTRY(widgets->client_set_entry[0]), utf8);
	if( utf8!=NULL )
	  g_free(utf8);
	free(tmp);
    }



    /* Insert values from the sysinit script if it exists */
    openvpn_sysinit_script = g_strdup_printf("%s/gadmin-openvpn-client", SYSINIT_SCRIPTS_DIR);
    if((fp=fopen(openvpn_sysinit_script, "r"))==NULL)
    {
	/* Dont show a popup and dont return */
    }
    else
    {
	have_sysinit_script = 1;

	fseek(fp, 0, SEEK_END);
	file_size = ftell(fp);
	rewind(fp);

	line = allocate(file_size);
	tmp  = allocate(1024);

	if( file_size > 1 )
	while(fgets(line, file_size, fp)!=NULL)
	{
	    if( line==NULL || strlen(line) < 4 )
              continue;

	    /* Start at boot (This is just a comment in the start script) */
	    if( cmplowercase(line, "# client starts at boot") )
	    {
		gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->client_set_combo[6]), 1);
	    }


	    if( line==NULL || strlen(line) < 4 || commented(line) )
              continue;

	    /* Share internet */
	    if( cmplowercase(line, "iptables -t nat -a postrouting -s") )
	    {
		//	share_internet = 1;
		gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->client_set_combo[4]), 1);
	    }
	    /* Using Firestarter */
	    if( cmplowercase(line, "firestarter -s") )
	    {
		gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->client_set_combo[5]), 1);
	    }

	    /* Mount command */
	    if( cmplowercase(line, "mount ") )
	    {
		if( line[strlen(line)-1]=='\n')
	          line[strlen(line)-1]='\0';
		utf8 = g_locale_to_utf8(line, strlen(line), NULL, NULL, NULL);
		gtk_entry_set_text(GTK_ENTRY(widgets->client_set_entry[5]), utf8);
		if( utf8!=NULL )
	          g_free(utf8);
	    }

	    /* LAN interface name */
/*
	    if( cmplowercase(line, "eth=\"") )
	    {
		for(i=0; line[i]!='\0'; i++)
	          if( line[i]=='"')
	            break;

		snprintf(tmp, 1000, "%s", &line[i+1]);
		if( tmp[strlen(tmp)-1]=='\n')
	          tmp[strlen(tmp)-1]='\0';

		for(i=0; tmp[i]!='\0'; i++)
	          if( tmp[i]=='"' )
	    	    break;
		tmp[i]='\0';

		utf8 = g_locale_to_utf8(tmp, strlen(tmp), NULL, NULL, NULL);
		gtk_entry_set_text(GTK_ENTRY(widgets->client_set_entry[1]), utf8);
		if( utf8!=NULL )
	          g_free(utf8);
	    }
*/
	    /* LAN broadcast address */
/*
	    if( cmplowercase(line, "eth_broadcast=\"") )
	    {
		for(i=0; line[i]!='\0'; i++)
	          if( line[i]=='"')
	    	    break;

		snprintf(tmp, 1000, "%s", &line[i+1]);
		if( tmp[strlen(tmp)-1]=='\n')
	          tmp[strlen(tmp)-1]='\0';

		for(i=0; tmp[i]!='\0'; i++)
	          if( tmp[i]=='"' )
	    	    break;
		tmp[i]='\0';

		utf8 = g_locale_to_utf8(tmp, strlen(tmp), NULL, NULL, NULL);
		gtk_entry_set_text(GTK_ENTRY(widgets->client_set_entry[4]), utf8);
		if( utf8!=NULL )
	          g_free(utf8);
	    }
*/
	}
	fclose(fp);
	free(line);
	free(tmp);
    }

    /* Insert standard values if there is no init script */
/*
    if( ! have_sysinit_script )
    {
	tmp = allocate(1024);

	snprintf(tmp, 1000, "%s", "eth1");
	utf8 = g_locale_to_utf8(tmp, strlen(tmp), NULL, NULL, NULL);
	gtk_entry_set_text(GTK_ENTRY(widgets->client_set_entry[1]), utf8);
	if( utf8!=NULL )
          g_free(utf8);

	snprintf(tmp, 1000, "%s", "192.168.10.255");
	utf8 = g_locale_to_utf8(tmp, strlen(tmp), NULL, NULL, NULL);
	gtk_entry_set_text(GTK_ENTRY(widgets->client_set_entry[4]), utf8);
	if( utf8!=NULL )
          g_free(utf8);

	free(tmp);
    }
*/

    g_free(openvpn_sysinit_script);
}
