/* GAdmin-OpenVPN - An easy to use GTK+ frontend for the openvpn client.
 * Copyright (C) 2008 Magnus Loef <magnus-swe@telia.com> 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
*/


#include "../config.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include "gettext.h"
#include "widgets.h"
#include "make_settings_entries.h"
#include "make_settings_combos.h"
#include "make_settings_spinbuttons.h"
#include "make_settings_progressbars.h"
#include "make_settings_labels.h"
#include "make_settings_hseparators.h"
#include "create_client_settings.h"

extern int use_tls;



void create_client_settings(struct w *widgets)
{
    GtkTooltips *tooltips;
//    GtkWidget *gen_cert_button;
    gchar *utf8 = NULL;
//    gdouble progress_val = 1.0;
    gchar *combo_text;

    /* Counters for the widgets and positions in the table */
    int a = 0;
    int b = 1;
    int ent  = 0;
    int spin = 0;
    int comb = 0;

    /* Max lengths and input */
    int entry_size = 100;

    tooltips = gtk_tooltips_new();

    /* Connection name */
    widgets->client_set_entry[ent] = make_long_entry_with_label(GTK_TABLE(widgets->srv_set_table), _(" connection name: "), 0,1,a,b,entry_size);
    gtk_tooltips_set_tip(tooltips, widgets->client_set_entry[ent], 
    _("A name for this VPN connection"), NULL);
    a++; b++; ent++;

    /* Server address */
    widgets->client_set_entry[ent] = make_long_entry_with_label(GTK_TABLE(widgets->srv_set_table), _(" Server address: "), 0,1,a,b,entry_size);
    gtk_tooltips_set_tip(tooltips, widgets->client_set_entry[ent], 
    _("Remote VPN server address"), NULL);
    a++; b++; ent++;

    /* Server port */
    widgets->client_set_spinbutton[spin] = make_short_spinbutton_with_label(GTK_TABLE(widgets->srv_set_table), _(" Server port: "), 0,1,a,b,50);
    gtk_tooltips_set_tip(tooltips, widgets->client_set_spinbutton[spin], _("Remote VPN server port"), NULL);
    a++; b++; spin++;

    /* Server Protocol UDP/TCP */
    widgets->client_set_combo[comb] = make_short_combo_with_label(GTK_TABLE(widgets->srv_set_table), _(" Server Protocol: "), 0,1,a,b,50);
    combo_text = g_strdup_printf(_("TCP"));
    utf8 = g_locale_to_utf8(combo_text, strlen(combo_text), NULL, NULL, NULL);
    gtk_combo_box_append_text(GTK_COMBO_BOX(widgets->client_set_combo[comb]), utf8);
    g_free(combo_text); g_free(utf8);
    combo_text = g_strdup_printf(_("UDP"));
    utf8 = g_locale_to_utf8(combo_text, strlen(combo_text), NULL, NULL, NULL);
    gtk_combo_box_append_text(GTK_COMBO_BOX(widgets->client_set_combo[comb]), utf8);
    g_free(combo_text); g_free(utf8);
    a++; b++; comb++;

    /* The TAP interface to create and use */
    widgets->client_set_combo[comb] = make_short_combo_with_label(GTK_TABLE(widgets->srv_set_table), _(" TAP Device: "), 0,1,a,b,50);
    combo_text = g_strdup_printf("Tap0");
    utf8 = g_locale_to_utf8(combo_text, strlen(combo_text), NULL, NULL, NULL);
    gtk_combo_box_append_text(GTK_COMBO_BOX(widgets->client_set_combo[comb]), utf8);
    g_free(combo_text); g_free(utf8);
    combo_text = g_strdup_printf("Tap1");
    utf8 = g_locale_to_utf8(combo_text, strlen(combo_text), NULL, NULL, NULL);
    gtk_combo_box_append_text(GTK_COMBO_BOX(widgets->client_set_combo[comb]), utf8);
    g_free(combo_text); g_free(utf8);
    combo_text = g_strdup_printf("Tap2");
    utf8 = g_locale_to_utf8(combo_text, strlen(combo_text), NULL, NULL, NULL);
    gtk_combo_box_append_text(GTK_COMBO_BOX(widgets->client_set_combo[comb]), utf8);
    g_free(combo_text); g_free(utf8);
    combo_text = g_strdup_printf("Tap3");
    utf8 = g_locale_to_utf8(combo_text, strlen(combo_text), NULL, NULL, NULL);
    gtk_combo_box_append_text(GTK_COMBO_BOX(widgets->client_set_combo[comb]), utf8);
    g_free(combo_text); g_free(utf8);
    a++; b++; comb++;

    /* Username */
    widgets->client_set_entry[ent] = make_long_entry_with_label(GTK_TABLE(widgets->srv_set_table), _(" Username: "), 0,1,a,b,200);
    gtk_tooltips_set_tip(tooltips, widgets->client_set_entry[ent], _("A username for the server if required"), NULL);
    a++; b++; ent++;

    /* Password */
    widgets->client_set_entry[ent] = make_long_entry_with_label(GTK_TABLE(widgets->srv_set_table), _(" Password: "), 0,1,a,b,200);
    gtk_tooltips_set_tip(tooltips, widgets->client_set_entry[ent], _("A password for the server if required"), NULL);
    a++; b++; ent++;

    /* Encryption type: BlowFish, AES or Triple-DES */
    widgets->client_set_combo[comb] = make_short_combo_with_label(GTK_TABLE(widgets->srv_set_table), _(" Encryption type: "), 0,1,a,b,50);
    combo_text = g_strdup_printf(_("BlowFish"));
    utf8 = g_locale_to_utf8(combo_text, strlen(combo_text), NULL, NULL, NULL);
    gtk_combo_box_append_text(GTK_COMBO_BOX(widgets->client_set_combo[comb]), utf8);
    g_free(combo_text); g_free(utf8);
    combo_text = g_strdup_printf(_("AES-128"));
    utf8 = g_locale_to_utf8(combo_text, strlen(combo_text), NULL, NULL, NULL);
    gtk_combo_box_append_text(GTK_COMBO_BOX(widgets->client_set_combo[comb]), utf8);
    g_free(combo_text); g_free(utf8);
    combo_text = g_strdup_printf(_("AES-256"));
    utf8 = g_locale_to_utf8(combo_text, strlen(combo_text), NULL, NULL, NULL);
    gtk_combo_box_append_text(GTK_COMBO_BOX(widgets->client_set_combo[comb]), utf8);
    g_free(combo_text); g_free(utf8);
    combo_text = g_strdup_printf(_("Triple-DES"));
    utf8 = g_locale_to_utf8(combo_text, strlen(combo_text), NULL, NULL, NULL);
    gtk_combo_box_append_text(GTK_COMBO_BOX(widgets->client_set_combo[comb]), utf8);
    g_free(combo_text); g_free(utf8);
    a++; b++; comb++;

    /* Use compression */
    widgets->client_set_combo[comb] = make_short_combo_with_label(GTK_TABLE(widgets->srv_set_table), _(" Use compression: "), 0,1,a,b,50);
    combo_text = g_strdup_printf(_("No"));
    utf8 = g_locale_to_utf8(combo_text, strlen(combo_text), NULL, NULL, NULL);
    gtk_combo_box_append_text(GTK_COMBO_BOX(widgets->client_set_combo[comb]), utf8);
    g_free(combo_text); g_free(utf8);
    combo_text = g_strdup_printf(_("Yes"));
    utf8 = g_locale_to_utf8(combo_text, strlen(combo_text), NULL, NULL, NULL);
    gtk_combo_box_append_text(GTK_COMBO_BOX(widgets->client_set_combo[comb]), utf8);
    g_free(combo_text); g_free(utf8);
    a++; b++; comb++;

    /* Share connection */
    widgets->client_set_combo[comb] = make_short_combo_with_label(GTK_TABLE(widgets->srv_set_table), _(" Share connection: "), 0,1,a,b,50);
    combo_text = g_strdup_printf(_("No"));
    utf8 = g_locale_to_utf8(combo_text, strlen(combo_text), NULL, NULL, NULL);
    gtk_combo_box_append_text(GTK_COMBO_BOX(widgets->client_set_combo[comb]), utf8);
    g_free(combo_text); g_free(utf8);
    combo_text = g_strdup_printf(_("Yes"));
    utf8 = g_locale_to_utf8(combo_text, strlen(combo_text), NULL, NULL, NULL);
    gtk_combo_box_append_text(GTK_COMBO_BOX(widgets->client_set_combo[comb]), utf8);
    g_free(combo_text); g_free(utf8);
    a++; b++; comb++;

    /* Using Firestarter */
    widgets->client_set_combo[comb] = make_short_combo_with_label(GTK_TABLE(widgets->srv_set_table), _(" Using Firestarter: "), 0,1,a,b,50);
    combo_text = g_strdup_printf(_("No"));
    utf8 = g_locale_to_utf8(combo_text, strlen(combo_text), NULL, NULL, NULL);
    gtk_combo_box_append_text(GTK_COMBO_BOX(widgets->client_set_combo[comb]), utf8);
    g_free(combo_text); g_free(utf8);
    combo_text = g_strdup_printf(_("Yes"));
    utf8 = g_locale_to_utf8(combo_text, strlen(combo_text), NULL, NULL, NULL);
    gtk_combo_box_append_text(GTK_COMBO_BOX(widgets->client_set_combo[comb]), utf8);
    g_free(combo_text); g_free(utf8);
    a++; b++; comb++;

    /* Start at boot */
    widgets->client_set_combo[comb] = make_short_combo_with_label(GTK_TABLE(widgets->srv_set_table), _(" Start at boot: "), 0,1,a,b,50);
    combo_text = g_strdup_printf(_("No"));
    utf8 = g_locale_to_utf8(combo_text, strlen(combo_text), NULL, NULL, NULL);
    gtk_combo_box_append_text(GTK_COMBO_BOX(widgets->client_set_combo[comb]), utf8);
    g_free(combo_text); g_free(utf8);
    combo_text = g_strdup_printf(_("Yes"));
    utf8 = g_locale_to_utf8(combo_text, strlen(combo_text), NULL, NULL, NULL);
    gtk_combo_box_append_text(GTK_COMBO_BOX(widgets->client_set_combo[comb]), utf8);
    g_free(combo_text); g_free(utf8);
    a++; b++; comb++;


    /* LAN interface name */
/*
    widgets->server_set_entry[ent] = make_long_entry_with_label(GTK_TABLE(widgets->srv_set_table), _(" LAN interface name: "), 0,1,a,b,entry_size);
    gtk_tooltips_set_tip(tooltips, widgets->server_set_entry[ent], 
    _("The name of the LAN network interface, IE: eth1"), NULL);
    a++; b++; ent++;
*/
    /* LAN interface address */
/*
    widgets->server_set_entry[ent] = make_long_entry_with_label(GTK_TABLE(widgets->srv_set_table), _(" LAN interface address: "), 0,1,a,b,entry_size);
    gtk_tooltips_set_tip(tooltips, widgets->server_set_entry[ent], 
    _("IE: 192.168.10.100\nYour LAN should not have the same network address as connecting clients commonly have, IE: 192.168.0 or 10.0.0. Also change this setting in your DHCP server and firewall."), NULL);
    a++; b++; ent++;
*/
    /* LAN Subnet mask */
/*
    widgets->server_set_entry[ent] = make_long_entry_with_label(GTK_TABLE(widgets->srv_set_table), _(" LAN subnet mask: "), 0,1,a,b,entry_size);
    gtk_tooltips_set_tip(tooltips, widgets->server_set_entry[ent], 
    _("IE: 255.255.255.0"), NULL);
    a++; b++; ent++;
*/
    /* LAN Broadcast address */
/*
    widgets->server_set_entry[ent] = make_long_entry_with_label(GTK_TABLE(widgets->srv_set_table), _(" LAN broadcast address: "), 0,1,a,b,entry_size);
    gtk_tooltips_set_tip(tooltips, widgets->server_set_entry[ent], 
    _("IE: 192.168.10.255"), NULL);
    a++; b++; ent++;
*/



    /* Log level (verb 3) */
    widgets->client_set_spinbutton[spin] = make_short_spinbutton_with_label(GTK_TABLE(widgets->srv_set_table),_(" Log level: "), 0,1,a,b,50);
    gtk_tooltips_set_tip(tooltips, widgets->client_set_spinbutton[spin], _("Log verbosity level."), NULL);
    a++; b++; spin++;

    /* HTTP Proxy server address */
    widgets->client_set_entry[ent] = make_long_entry_with_label(GTK_TABLE(widgets->srv_set_table), _(" Proxy server: "), 0,1,a,b,entry_size);
    gtk_tooltips_set_tip(tooltips, widgets->client_set_entry[ent], 
    _("Local HTTP Proxy server address if any"), NULL);
    a++; b++; ent++;

    /* HTTP proxy server port */
    widgets->client_set_spinbutton[spin] = make_short_spinbutton_with_label(GTK_TABLE(widgets->srv_set_table),_(" Proxy port: "), 0,1,a,b,50);
    gtk_tooltips_set_tip(tooltips, widgets->client_set_spinbutton[spin], _("Local HTTP proxy server port if any"), NULL);
    a++; b++; spin++;

    gtk_widget_show_all(widgets->main_window);
}
