/* GADMIN-DHCPD - An easy to use GTK+ frontend for ISC DHCPD.
 * Copyright (C) 2004 - 2009 Magnus Loef <magnus-swe@telia.com> 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
*/



#include <gtk/gtk.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "widgets.h"
#include "gettext.h"
#include "allocate.h"
#include "set_num_ranges.h"

extern char global_netmask[1024];
extern char global_subnet[1024];
extern char global_nic[1024];

extern int num_ranges;
extern char DHCPD_CONF_BUF[1024];



void set_num_ranges(gchar *nic, gchar *subnet, gchar *netmask)
{
    FILE *fp;
    long conf_size=0;
    int found_scope=0;
    char *line;

    /* Set some global values */
    num_ranges = 0;

    // FIXME: source and destination overlap
    sprintf(global_subnet, "%s", subnet);
    sprintf(global_netmask, "%s", netmask);
    sprintf(global_nic, "%s", nic);
    
    gchar *scope_line1 = g_strdup_printf("subnet %s netmask %s\n", subnet, netmask);
    gchar *scope_line2 = g_strdup_printf("subnet %s netmask %s{\n", subnet, netmask);
    gchar *scope_line3 = g_strdup_printf("subnet %s netmask %s {\n", subnet, netmask);
    gchar *nic_line = g_strdup_printf("interface %s;\n", nic);

    if((fp=fopen(DHCPD_CONF_BUF, "r"))==NULL)
    {
	g_free(scope_line1);
	g_free(scope_line2);
	g_free(scope_line3);
	g_free(nic_line);
        return;
    }
    fseek(fp, 0, SEEK_END);
    conf_size = ftell(fp);
    rewind(fp);

    line = allocate(conf_size+1);

    if( conf_size > 1 )    
    while(fgets(line, conf_size, fp)!=NULL)
    {
	if( ( strstr(line, scope_line1) || strstr(line, scope_line2) 
	|| strstr(line, scope_line3)  ) && ! strstr(line, "#") )
	{
	    while(fgets(line, conf_size, fp)!=NULL)
	    {
		if( strstr(line, nic_line) && ! strstr(line, "#") )
		{
		    found_scope = 1;
		    break;
		}
	    }
	}
	if( found_scope )
	  break;
    }


    if( found_scope && conf_size > 1 )
    {
	while(fgets(line, conf_size, fp)!=NULL)
	{
	    /* Break at the next subnet declaration if any */
	    if( strstr(line, "subnet") && strstr(line, "}") )
	      break;

	    /* Scroll past any failover peers */
	    if( strstr(line, "failover peer") && strstr(line, "}") && ! strstr(line, "#") )
	    {
		while(fgets(line, conf_size, fp)!=NULL)
		  if( strstr(line, "}") && strlen(line)<3 )
	            break;
	    }
	
	    if( strstr(line, "range ") && ! strstr(line, "#") )
	      num_ranges++;
	}
    }
    fclose(fp);
    free(line);

    g_free(scope_line1);
    g_free(scope_line2);
    g_free(scope_line3);
    g_free(nic_line);
}
