/* GADMIN-DHCPD - An easy to use GTK+ frontend for ISC DHCPD.
 * Copyright (C) 2004 - 2009 Magnus Loef <magnus-swe@telia.com> 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
*/



#include <gtk/gtk.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "widgets.h"
#include "gettext.h"
#include "allocate.h"
#include "show_info.h"
#include "clear_ptr_array.h"
#include "add_range.h"
#include "delete_range.h"
#include "set_del_row_num.h"


extern int num_ranges;
extern int MAX_CONF_LINE;
extern char DHCPD_CONF_BUF[1024];


void populate_ranges(struct w *widgets, 
                                    	    gchar *nic, 
                                            gchar *subnet, 
					    gchar *netmask)
{
    FILE *fp;
    long conf_size = 0;
    int found_scope = 0;
    gint i = 0;
    char *line;
    char *range_from;
    char *range_to;
    gchar *utf8=NULL, *info;

    GtkWidget *hbox[num_ranges];
    GtkWidget *from_label[num_ranges];
    GtkWidget *to_label[num_ranges];
    GtkWidget *from_entry[num_ranges];
    GtkWidget *to_entry[num_ranges];
    GtkWidget *del_range_button[num_ranges];
    GtkWidget *spacer_label_del[num_ranges];

    GtkWidget *add_range_hbox;
    GtkWidget *from_label_add, *to_label_add;
    GtkWidget *spacer_label_add;

    GtkTooltips *tooltips;
    tooltips = gtk_tooltips_new();

    if( nic==NULL || subnet==NULL || netmask==NULL )
    {
       info = g_strdup_printf(_("Populate ranges recieved a NULL value, ranges not populated\n"));
       show_info(info);
       g_free(info);
       return;
    }

    gchar *scope_line1 = g_strdup_printf("subnet %s netmask %s\n", subnet, netmask);
    gchar *scope_line2 = g_strdup_printf("subnet %s netmask %s{\n", subnet, netmask);
    gchar *scope_line3 = g_strdup_printf("subnet %s netmask %s {\n", subnet, netmask);
    gchar *nic_line = g_strdup_printf("interface %s;\n", nic);

    /* Destroy all range widgets and clear range pointers */
    clear_ptr_array(widgets);

    gtk_widget_destroy(widgets->range_scrolled_vbox);
      
    widgets->range_scrolled_vbox = gtk_vbox_new(FALSE, 0);

    gtk_container_add (GTK_CONTAINER (widgets->range_viewport), widgets->range_scrolled_vbox);

    if((fp=fopen(DHCPD_CONF_BUF, "r"))==NULL)
    {
	g_free(scope_line1);
	g_free(scope_line2);
	g_free(scope_line3);
	g_free(nic_line);
        return;
    }
    fseek(fp, 0, SEEK_END);
    conf_size = ftell(fp);
    rewind(fp);

    line = allocate(conf_size+1);

    if( conf_size > 1 )
    while(fgets(line, conf_size, fp)!=NULL)
    {
	if( strlen(line) >= MAX_CONF_LINE-1 )
	  continue;
    
	if( ( strstr(line, scope_line1) || strstr(line, scope_line2) 
	|| strstr(line, scope_line3) ) && ! strstr(line, "#") )
	{
	    while(fgets(line, conf_size, fp)!=NULL)
	    {
		if( strstr(line, nic_line) && ! strstr(line, "#") )
		{
		    found_scope = 1;
		    break;
		}
	    }
	}
	if( found_scope )
	  break;
    }


    /* Add a header label above the ranges */
    GtkWidget *range_spacer_hbox = gtk_hbox_new(FALSE, 0);
    gtk_box_pack_start(GTK_BOX(widgets->range_scrolled_vbox), range_spacer_hbox, FALSE, FALSE, 0);
    GtkWidget *range_spacer_label = gtk_label_new(_("Shared IP-address ranges"));
    gtk_box_pack_start(GTK_BOX(range_spacer_hbox), range_spacer_label, TRUE, TRUE, 0);


    /* "Add range" hbox, label, entry and button */
    add_range_hbox = gtk_hbox_new(FALSE, 0);
    gtk_box_pack_start(GTK_BOX(widgets->range_scrolled_vbox), add_range_hbox, FALSE, FALSE, 0);

    from_label_add = gtk_label_new(_(" Range from: "));
    gtk_box_pack_start(GTK_BOX(add_range_hbox), from_label_add, FALSE, FALSE, 0);

    widgets->ranges_add_from_entry = gtk_entry_new();
    gtk_box_pack_start(GTK_BOX(add_range_hbox), widgets->ranges_add_from_entry, TRUE, TRUE, 0);
    gtk_tooltips_set_tip(tooltips, widgets->ranges_add_from_entry, "192.168.0.10", NULL);
    
    to_label_add = gtk_label_new(_(" to: "));
    gtk_box_pack_start(GTK_BOX(add_range_hbox), to_label_add, FALSE, FALSE, 0);

    widgets->ranges_add_to_entry = gtk_entry_new();
    gtk_box_pack_start(GTK_BOX(add_range_hbox), widgets->ranges_add_to_entry, TRUE, TRUE, 0);
    gtk_tooltips_set_tip(tooltips, widgets->ranges_add_to_entry, "192.168.0.20", NULL);

    widgets->ranges_add_button = gtk_button_new_from_stock(GTK_STOCK_ADD);
    gtk_box_pack_start(GTK_BOX(add_range_hbox), widgets->ranges_add_button, FALSE, TRUE, 0);
    g_signal_connect_swapped(G_OBJECT(widgets->ranges_add_button), "clicked", 
                             G_CALLBACK(add_range), widgets);


    /* Give some room between the scroller and the button */
    spacer_label_add = gtk_label_new("");
    gtk_box_pack_start(GTK_BOX(add_range_hbox), spacer_label_add, FALSE, FALSE, 5);


    /* Get the actual size of the add range button so we can compare it to the
       delete range buttons and use the same width for all */
    GtkRequisition add_button_req;
    gtk_widget_size_request(GTK_WIDGET(widgets->ranges_add_button), &add_button_req);


    if( found_scope && conf_size > 1 )
    {
	range_from = allocate(MAX_CONF_LINE+1);
	range_to = allocate(MAX_CONF_LINE+1);

	i = 0;	
	while(fgets(line, conf_size, fp)!=NULL)
	{
	    /* Break at the next scope */
	    if( strstr(line, "}") && strlen(line) < 3 )
	      break;
	
	    if( strstr(line, "range ") && ! strstr(line, "#") 
	    && strlen(line) < MAX_CONF_LINE-1 )
	    {
		/* Insert ranges */
		sscanf(line, "%*s %s %s", range_from, range_to);
				
		hbox[i] = gtk_hbox_new(FALSE, 0);
		gtk_box_pack_start(GTK_BOX(widgets->range_scrolled_vbox), hbox[i], FALSE, FALSE, 0);
		g_ptr_array_add(widgets->ranges_hbox_array, (gpointer) hbox[i]);

		from_label[i] = gtk_label_new(_(" Range from: "));
		gtk_box_pack_start(GTK_BOX(hbox[i]), from_label[i], FALSE, FALSE, 0);

		from_entry[i] = gtk_entry_new();
		gtk_box_pack_start(GTK_BOX(hbox[i]), from_entry[i], TRUE, TRUE, 0);
		g_ptr_array_add(widgets->ranges_from_entry_array, (gpointer) from_entry[i]);
		utf8 = g_locale_to_utf8(range_from, strlen(range_from), NULL, NULL, NULL);
		gtk_entry_set_text(GTK_ENTRY(from_entry[i]), utf8);

		to_label[i] = gtk_label_new(_(" to: "));
		gtk_box_pack_start(GTK_BOX(hbox[i]), to_label[i], FALSE, FALSE, 0);

		to_entry[i] = gtk_entry_new();
		gtk_box_pack_start(GTK_BOX(hbox[i]), to_entry[i], TRUE, TRUE, 0);
		g_ptr_array_add(widgets->ranges_to_entry_array, (gpointer) to_entry[i]);
		utf8 = g_locale_to_utf8(range_to, strlen(range_to)-1, NULL, NULL, NULL);
		gtk_entry_set_text(GTK_ENTRY(to_entry[i]), utf8);

		del_range_button[i] = gtk_button_new_from_stock(GTK_STOCK_DELETE);
		gtk_box_pack_start(GTK_BOX(hbox[i]), del_range_button[i], FALSE, TRUE, 0);
		g_ptr_array_add(widgets->ranges_del_button_array, (gpointer) del_range_button[i]);

		g_signal_connect_swapped(G_OBJECT(del_range_button[i]), "clicked", 
                                  G_CALLBACK(set_del_row_num), GINT_TO_POINTER(i));

		g_signal_connect_swapped(G_OBJECT(del_range_button[i]), "clicked", 
                                  G_CALLBACK(delete_range), widgets);

		/* Give some room between the scroller and the button */
		spacer_label_del[i] = gtk_label_new("");
		gtk_box_pack_start(GTK_BOX(hbox[i]), spacer_label_del[i], FALSE, FALSE, 5);

		/* Make the add and delete buttons the same width. */
		GtkRequisition del_button_req;
		gtk_widget_size_request(GTK_WIDGET(del_range_button[i]), &del_button_req);

		if( add_button_req.width > del_button_req.width )
	          gtk_widget_set_usize(GTK_WIDGET(del_range_button[i]), add_button_req.width, -1);

		if( del_button_req.width > add_button_req.width )
    	          gtk_widget_set_usize(GTK_WIDGET(widgets->ranges_add_button), del_button_req.width, -1);

		i++;	    
	    }
	}
	free(range_from);
	free(range_to);
    }
    fclose(fp);
    free(line);

    g_free(scope_line1);
    g_free(scope_line2);
    g_free(scope_line3);
    g_free(nic_line);

    if( utf8!=NULL )
      g_free(utf8);

    gtk_widget_show_all(widgets->main_window);
}
