/* UtilsInterface.c */
/**********************************************************************************************************
Copyright (c) 2002-2007 Abdul-Rahman Allouche. All rights reserved

Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated
documentation files (the Gabedit), to deal in the Software without restriction, including without limitation
the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software,
and to permit persons to whom the Software is furnished to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be included in all copies or substantial portions
  of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
DEALINGS IN THE SOFTWARE.
************************************************************************************************************/


#include "../../Config.h"
#include <stdlib.h>
#include <ctype.h>

#include "../Common/Global.h"
#include "../Utils/Constantes.h"
#include "../Gaussian/GaussGlobal.h"
#include "../Files/FileChooser.h"
#include "../Gamess/Gamess.h"
#include "../PCGamess/PCGamess.h"
#include "../Molcas/Molcas.h"
#include "../Molpro/Molpro.h"
#include "../MPQC/MPQC.h"
#include "../QChem/QChem.h"
#include "../Gaussian/Gaussian.h"
#include "../Geometry/GeomGlobal.h"
#include "../Utils/UtilsInterface.h"
#include "../Geometry/InterfaceGeom.h"
#include "../Utils/Utils.h"
#include "../Utils/GabeditTextEdit.h"
#include "../Geometry/ResultsAnalise.h"
#include "../Geometry/EnergiesCurves.h"
#include "../Common/Windows.h"
#include "../Files/ListeFiles.h"
#include "../Geometry/GeomXYZ.h"
#include "../Geometry/GeomZmatrix.h"
#include "../Common/SplashScreen.h"
#include "../OpenGL/ViewOrb.h"
#include "../Geometry/Fragments.h"
#include "../Geometry/DrawGeom.h"
#include "../Common/Exit.h"
#include "../Molcas/MolcasVariables.h"
#include "../Molcas/MolcasSeward.h"

#include "../../pixmaps/Ok.xpm"
#include "../../pixmaps/Cancel.xpm"
#include "../../pixmaps/Yes.xpm"
#include "../../pixmaps/No.xpm"
#include "../../pixmaps/SaveMini.xpm"
#include "../../pixmaps/Close.xpm"
#include "../../pixmaps/Apply.xpm"
#include "../../pixmaps/Question.xpm"
#include "../../pixmaps/Warning.xpm"
#include "../../pixmaps/Error.xpm"
#include "../../pixmaps/Info.xpm"
#include "../../pixmaps/A0p.xpm"
#include "../../pixmaps/A0d.xpm"
#include "../../pixmaps/Open.xpm"
#include "../../pixmaps/Gabedit.xpm"
#include "../../pixmaps/Print.xpm"
#include "../../pixmaps/Next.xpm"
#include "../../pixmaps/Stop.xpm"
#include "../../pixmaps/Play.xpm"
#include "../Common/StockIcons.h"

/********************************************************************************/
static gint destroy_popup(gpointer data)
{
        gtk_widget_hide(GTK_WIDGET(data));
        gtk_object_destroy(GTK_OBJECT(data));
        return FALSE;
}
/********************************************************************************/
void create_popup_win(gchar* label)
{
	GtkWidget *MainFrame;
	GtkWidget *Label;
	GtkWidget *hbox = gtk_hbox_new(0,FALSE);
	

	MainFrame = gtk_window_new (GTK_WINDOW_POPUP);

	/* center it on the screen*/
        gtk_window_set_position(GTK_WINDOW (MainFrame), GTK_WIN_POS_MOUSE);

	/* set up key and mound button press to hide splash screen*/

        gtk_widget_add_events(MainFrame,
                              GDK_BUTTON_PRESS_MASK|
                              GDK_BUTTON_RELEASE_MASK|
                              GDK_KEY_PRESS_MASK);

        g_signal_connect(G_OBJECT(MainFrame),"button_press_event",
                GTK_SIGNAL_FUNC(gtk_widget_destroy),NULL);
        g_signal_connect(G_OBJECT(MainFrame),"key_press_event",
                GTK_SIGNAL_FUNC(gtk_widget_destroy),NULL);
        gtk_widget_realize(MainFrame);

	Label = gtk_label_new(label);
   	gtk_label_set_justify(GTK_LABEL(Label),GTK_JUSTIFY_LEFT);
 	set_font (Label,"helvetica bold 24");  
	gtk_box_pack_start (GTK_BOX (hbox), Label, FALSE, FALSE, 0);
        gtk_widget_show(Label);
        gtk_widget_show(hbox);
        gtk_container_add (GTK_CONTAINER (MainFrame), hbox);
        gtk_widget_show(MainFrame);

	/* force it to draw now.*/
	gdk_flush();

	/* go into main loop, processing events.*/
        while(gtk_events_pending())
                gtk_main_iteration();

	/* after 3 seconds, destroy the splash screen.*/
        g_timeout_add( 1000, destroy_popup, MainFrame );
}
/********************************************************************************/
void init_child(GtkWidget *widget, GabeditSignalFunc func,gchar *buttonlabel)
{
  WidgetChilds  *childs = g_malloc(sizeof(WidgetChilds));
  g_object_set_data(G_OBJECT (widget), "Childs", childs);
  childs->nchilds = 1;
  childs->childs = g_malloc(sizeof(GtkWidget*));
  childs->destroychilds = g_malloc(sizeof(GtkSignalFunc));
  childs->childs[0] = widget;
  g_object_set_data(G_OBJECT(childs->childs[0]),"Parent",widget);
  childs->destroychilds[0] = func;
  if(buttonlabel)
	add_button_windows(buttonlabel,widget);
}
/********************************************************************************/
void add_child(GtkWidget *widget,GtkWidget *childwidget,GabeditSignalFunc func,gchar *buttonlabel)
{
  WidgetChilds  *childs = (WidgetChilds  *)g_object_get_data(G_OBJECT(widget),"Childs");
  childs->nchilds++;
  childs->childs = g_realloc(childs->childs,childs->nchilds*sizeof(GtkWidget*));
  childs->destroychilds = g_realloc(childs->destroychilds,childs->nchilds*sizeof(GtkSignalFunc));
  childs->childs[childs->nchilds-1] = childwidget;
  g_object_set_data(G_OBJECT(childs->childs[childs->nchilds-1]),"Parent",widget);
  childs->destroychilds[childs->nchilds-1] = func;
  if(buttonlabel)
	add_button_windows(buttonlabel,childwidget);
}
/********************************************************************************/
void delete_child(GtkWidget *childwidget)
{
  GtkWidget *widget = NULL;
  WidgetChilds  *childs;
  gint i;
  gint k;

  widget = GTK_WIDGET(g_object_get_data(G_OBJECT(childwidget),"Parent"));
  if(!widget)
	return;
  childs = (WidgetChilds  *)g_object_get_data(G_OBJECT(widget),"Childs");

  k = -1;
  for(i=0;i<childs->nchilds;i++)
  {
	if(childs->childs[i]==childwidget)
        {
		destroy_button_windows(childs->childs[i]);
		childs->destroychilds[i](childs->childs[i]);
		childs->childs[i] = NULL;
		k = i;
		break;
	}
  }
  if(k!=-1)
  {
  	for(i=k;i<childs->nchilds-1;i++)
  	{
		childs->childs[i] = childs->childs[i+1];
		childs->destroychilds[i] = childs->destroychilds[i+1];
  	}
  	childs->nchilds--;
  	childs->childs = g_realloc(childs->childs,childs->nchilds*sizeof(GtkWidget*));
  	childs->destroychilds = g_realloc(childs->destroychilds,childs->nchilds*sizeof(GtkSignalFunc));
  }
}
/********************************************************************************/
void delete_all_childs(GtkWidget *widget)
{
  WidgetChilds  *childs;
  gint i;

  if(!widget)
	return;
  childs = (WidgetChilds  *)g_object_get_data(G_OBJECT(widget),"Childs");
  for(i=1;i<childs->nchilds;i++)
  {
	if(childs->childs[i])
	{
		destroy_button_windows(childs->childs[i]);
		childs->destroychilds[i](childs->childs[i]);
		childs->childs[i] = NULL;
	}
  }
  childs->nchilds = 1;
  childs->childs = g_realloc(childs->childs,childs->nchilds*sizeof(GtkWidget*));
  childs->destroychilds = g_realloc(childs->destroychilds,childs->nchilds*sizeof(GtkSignalFunc));
   
}
/********************************************************************************/
void destroy_childs(GtkWidget *widget)
{
  WidgetChilds  *childs = (WidgetChilds  *)g_object_get_data(G_OBJECT(widget),"Childs");
  gint i;
  for(i=childs->nchilds-1;i>=0;i--)
  {
   if(childs->childs[i])
   {
	destroy_button_windows(childs->childs[i]);
	childs->destroychilds[i](childs->childs[i]);
   }
  }
  g_free(childs->childs);
  g_free(childs->destroychilds);
  g_free(childs);
}
/********************************************************************************/
/* create_pixmap, convenience function to create a pixmap widget, from data */
GtkWidget *create_pixmap(GtkWidget *widget, gchar **data)
{
  GtkStyle *style;
  GdkBitmap *mask;
  GdkPixmap *gdk_pixmap;
  GtkWidget *gtk_pixmap;

  style = gtk_widget_get_style(widget);
  g_assert(style != NULL);

  gdk_pixmap = gdk_pixmap_create_from_xpm_d(widget->window,&mask, &style->bg[GTK_STATE_NORMAL],data);
  g_assert(gdk_pixmap != NULL);
  gtk_pixmap = gtk_image_new_from_pixmap(gdk_pixmap, mask);

  g_assert(gtk_pixmap != NULL);
  gtk_widget_show(gtk_pixmap);

  return(gtk_pixmap);
}
/********************************************************************************/
 GdkPixmap *get_pixmap(GtkWidget  *widget,gushort red,gushort green,gushort blue)
{
  GdkPixmap *pixmap = NULL;
  GdkGC *gc = NULL;
  gint width = ScreenHeight/20;
  gint height = ScreenHeight/50;
  GdkColormap *colormap;
  GdkColor Color;

  gc = gdk_gc_new(widget->window);
  Color.red =  red;
  Color.green =  green;
  Color.blue =  blue;

  pixmap = gdk_pixmap_new(widget->window,width,height, -1);
  gdk_draw_rectangle (pixmap,
                      widget->style->black_gc,
                      TRUE,
                      0, 0, width, height);    
  colormap  = gdk_window_get_colormap(widget->window);
  gdk_colormap_alloc_color(colormap,&Color,FALSE,TRUE);
  gdk_gc_set_foreground(gc,&Color);
  gdk_draw_rectangle (pixmap,
                      gc,
                      TRUE,
                      1, 1, width-1, height-1);    

  gdk_gc_destroy(gc);
  return pixmap;
}   
/********************************************************************************/
GtkWidget *create_hbox_pixmap_color(GtkWidget *widget,gushort red,gushort green,gushort blue)
{
  GdkBitmap *mask = NULL;
  GdkPixmap *gdk_pixmap;
  GtkWidget *gtk_pixmap;
  GtkWidget *hbox;

  hbox = gtk_hbox_new (TRUE, 0);
 
  gdk_pixmap = get_pixmap(widget,red,green,blue);
  gtk_pixmap = gtk_image_new_from_pixmap(gdk_pixmap, mask);
 
  gdk_pixmap_unref(gdk_pixmap);
 
 
  gtk_box_pack_start (GTK_BOX (hbox), gtk_pixmap, TRUE, TRUE, 1);
 
  return hbox ;
}  
/********************************************************************************/
GtkWidget *create_button_pixmap_color(GtkWidget *widget,gushort red,gushort green,gushort blue)
{
  GtkWidget *hbox = create_hbox_pixmap_color(widget,red,green,blue);
  GtkWidget *Button = gtk_button_new();

  gtk_container_add(GTK_CONTAINER(Button),hbox);
  gtk_widget_show (hbox);
  g_object_set_data(G_OBJECT (Button), "Hbox", hbox);
 
  return Button ;
}  
/********************************************************************************/
GtkWidget *create_radio_button_pixmap(GtkWidget *widget, gchar **data,gchar *string,GtkWidget *oldbutton)
{
  GtkStyle *style;
  GdkBitmap *mask;
  GdkPixmap *gdk_pixmap;
  GtkWidget *gtk_pixmap;
  GtkWidget *Button;
  GtkWidget *hbox;
  GtkWidget *Label = NULL;

  hbox = gtk_hbox_new (TRUE, 0);
  gtk_widget_ref (hbox);
  gtk_widget_show (hbox);
 
 
  style = gtk_widget_get_style(widget);
  g_assert(style != NULL);
 
  gdk_pixmap = gdk_pixmap_create_from_xpm_d(widget->window,
                                            &mask, &style->bg[GTK_STATE_NORMAL],data);
  g_assert(gdk_pixmap != NULL);
  gtk_pixmap = gtk_image_new_from_pixmap(gdk_pixmap, mask);
 
  gdk_pixmap_unref(gdk_pixmap);
  gdk_pixmap_unref(mask);
 
  g_assert(gtk_pixmap != NULL);
/*  gtk_widget_show(gtk_pixmap);*/
 
  /*
  if(oldbutton)
  Button = gtk_radio_button_new(gtk_radio_button_group (GTK_RADIO_BUTTON (oldbutton)));
  else
  Button = gtk_radio_button_new(NULL);
  */
  Button = gtk_toggle_button_new(); 

  gtk_container_add(GTK_CONTAINER(Button),hbox);
  if(string)
  	Label = gtk_label_new(string);
  gtk_box_pack_start (GTK_BOX (hbox), gtk_pixmap, FALSE, FALSE, 1);
  if(string)
  	gtk_box_pack_start (GTK_BOX (hbox), Label, FALSE, FALSE, 1);
 
  return Button ;
} 
/********************************************************************************/
void set_icon_default()
{
  GdkPixbuf *pixbuf;
   
  pixbuf = gdk_pixbuf_new_from_xpm_data((const char**)gabedit_xpm);
  gtk_window_set_default_icon (pixbuf);
}     
/********************************************************************************/
void set_icone(GtkWidget *widget)
{
  GtkStyle *style;
  GdkBitmap *mask;
  GdkPixmap *gdk_pixmap;

   
  style = gtk_widget_get_style(widget);
  gdk_pixmap = gdk_pixmap_create_from_xpm_d (widget->window,&mask, &style->bg[GTK_STATE_NORMAL],gabedit_xpm);
  gdk_window_set_icon(widget->window,NULL,gdk_pixmap,mask); 
}     
/********************************************************************************/
void data_modify(gboolean mod)
{
        if(mod)
         imodif = DATA_MOD_YES;
        else
         imodif = DATA_MOD_NO;
 	change_all_labels();
}     
/********************************************************************************/
GtkWidget *create_label_pixmap(GtkWidget *widget, gchar **data,gchar *string)
{
  GtkStyle *style;
  GdkBitmap *mask;
  GdkPixmap *gdk_pixmap;
  GtkWidget *gtk_pixmap;
  GtkWidget *Label;
  GtkWidget *hbox;

  hbox = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (hbox);
  gtk_widget_show (hbox);
 
  style = gtk_widget_get_style(widget);
  g_assert(style != NULL);
 
  gdk_pixmap = gdk_pixmap_create_from_xpm_d(widget->window,
                                            &mask, &style->bg[GTK_STATE_NORMAL],data);
  g_assert(gdk_pixmap != NULL);
  gtk_pixmap = gtk_image_new_from_pixmap(gdk_pixmap, mask);
 
  gdk_pixmap_unref(gdk_pixmap);
  gdk_pixmap_unref(mask);
 
  g_assert(gtk_pixmap != NULL);
 
  Label = gtk_label_new(string);
  gtk_label_set_justify(GTK_LABEL(Label),GTK_JUSTIFY_LEFT);
  gtk_box_pack_end (GTK_BOX (hbox), gtk_pixmap, FALSE, FALSE, 2);
  gtk_box_pack_start (GTK_BOX (hbox), Label, FALSE, FALSE, 2);
 
  return hbox;
}  
/********************************************************************************/
GtkWidget *create_pixmap_label(GtkWidget *widget, gchar **data,gchar *string)
{
  GtkStyle *style;
  GdkBitmap *mask;
  GdkPixmap *gdk_pixmap;
  GtkWidget *gtk_pixmap;
  GtkWidget *Label;
  GtkWidget *hbox;

  hbox = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (hbox);
  gtk_widget_show (hbox);
 
  style = gtk_widget_get_style(widget);
  g_assert(style != NULL);
 
  gdk_pixmap = gdk_pixmap_create_from_xpm_d(widget->window,
                                            &mask, &style->bg[GTK_STATE_NORMAL],data);
  g_assert(gdk_pixmap != NULL);
  gtk_pixmap = gtk_image_new_from_pixmap(gdk_pixmap, mask);
 
  gdk_pixmap_unref(gdk_pixmap);
  gdk_pixmap_unref(mask);
 
  g_assert(gtk_pixmap != NULL);
 
  Label = gtk_label_new(string);
  gtk_label_set_justify(GTK_LABEL(Label),GTK_JUSTIFY_LEFT);
  gtk_box_pack_start (GTK_BOX (hbox), gtk_pixmap, FALSE, FALSE, 2);
  gtk_box_pack_start (GTK_BOX (hbox), Label, FALSE, FALSE, 2);
 
  return hbox;
}  
/********************************************************************************/
GtkWidget *create_label_with_pixmap(GtkWidget *Win,gchar *string,gchar *type)
{
    GtkWidget *hbox;
    GtkWidget *Label;
    if( strstr(type,"Question") )
    	hbox = create_pixmap_label(Win,question_xpm,string);
    else
    if( strstr(type,"Warning") )
    	hbox = create_pixmap_label(Win,warning_xpm,string);
    else
    if( strstr(type,"Error") )
    	hbox = create_pixmap_label(Win,error_xpm,string);
    else
    if( strstr(type,"Info") )
    	hbox = create_pixmap_label(Win,info_xpm,string);
    else
    {
  	hbox = gtk_hbox_new (TRUE, 0);
  	gtk_widget_show (hbox);
        Label = gtk_label_new(string);
        gtk_box_pack_start (GTK_BOX (hbox), Label, FALSE, FALSE, 1);
    }

    return hbox;
}
/********************************************************************************/
GtkWidget *create_button_pixmap(GtkWidget *widget, gchar **data,gchar *string)
{
  GtkStyle *style;
  GdkBitmap *mask;
  GdkPixmap *gdk_pixmap;
  GtkWidget *gtk_pixmap;
  GtkWidget *Button;
  GtkWidget *Label = NULL;
  GtkWidget *hbox;

  hbox = gtk_hbox_new (FALSE, 1);
  gtk_widget_ref (hbox);
  gtk_widget_show (hbox);
 
 
  style = gtk_widget_get_style(widget);
  g_assert(style != NULL);
 
  gdk_pixmap = gdk_pixmap_create_from_xpm_d (widget->window,&mask, &style->bg[GTK_STATE_NORMAL],data);
  g_assert(gdk_pixmap != NULL);
  gtk_pixmap = gtk_image_new_from_pixmap(gdk_pixmap, mask);
 
  gdk_pixmap_unref(gdk_pixmap);
  gdk_pixmap_unref(mask);
 
  g_assert(gtk_pixmap != NULL);
 
  Button = gtk_button_new();
  gtk_container_add(GTK_CONTAINER(Button),hbox);
  gtk_box_pack_start (GTK_BOX (hbox), gtk_pixmap, FALSE, FALSE, 2);

  if(string)
  {
  	Label = gtk_label_new(string);
  	gtk_box_pack_end (GTK_BOX (hbox), Label, FALSE, FALSE, 1);
  }
 
  return Button ;
}  

/********************************************************************************/
void exit_all(GtkWidget *widget, gchar *data)
{
 if(imodif == DATA_MOD_NO ) 
	ExitDlg(NULL, NULL);
 else
 	Save_YesNo();
}
/********************************************************************************/
GtkWidget *create_button(GtkWidget *Win,gchar *string)
{
    GtkWidget *button;
    if( strstr(string,"OK") )
    	button = create_button_pixmap(Win,ok_xpm,"  OK   ");
    else
    if(strstr(string,"Cancel") )
    	button = create_button_pixmap(Win,cancel_xpm," Cancel ");
    else
    if(strstr(string,"CANCEL") )
    	button = create_button_pixmap(Win,cancel_xpm," CANCEL ");
    else
    if(strstr(string,"Yes") )
    	button = create_button_pixmap(Win,yes_xpm,"Yes");
    else
    if(strstr(string,"No") )
    	button = create_button_pixmap(Win,no_xpm," No ");
    else
    if(strstr(string,"SAVE&CLOSE") )
    	button = create_button_pixmap(Win,savemini_xpm," SAVE & CLOSE ");
    else
    if(strstr(string,"Save&Apply&Close") )
    	button = create_button_pixmap(Win,savemini_xpm," Save&Apply&Close ");
    else
    if(strstr(string,"Save&Close") )
    	button = create_button_pixmap(Win,savemini_xpm," Save & Close ");
    else
    if(strstr(string,"Apply&Close") )
    	button = create_button_pixmap(Win,apply_xpm," Apply&Close ");
    else
    if(strstr(string,"Save") )
    	button = create_button_pixmap(Win,savemini_xpm," Save ");
    else
    if(strstr(string,"SAVE") )
    	button = create_button_pixmap(Win,savemini_xpm," SAVE ");
    else
    if(strstr(string,"CLOSE") )
    	button = create_button_pixmap(Win,close_xpm," CLOSE ");
    else
    if(strstr(string,"Close") )
    	button = create_button_pixmap(Win,close_xpm," Close ");
    else
    if(strstr(string,"Apply") )
    	button = create_button_pixmap(Win,apply_xpm," Apply ");
    else
    if(strstr(string," *a0 ") )
		button = create_button_pixmap(Win,a0p_xpm,NULL);
    else
    if(strstr(string," /a0 ") )
		button = create_button_pixmap(Win,a0d_xpm,NULL);
    else
    if(strstr(string,"Print") )
    	button = create_button_pixmap(Win,print_xpm," Print ");
    else
    if(strstr(string,"Stop") )
    	button = create_button_pixmap(Win,stop_xpm," Stop ");
    else
    if(strstr(string,"Play") )
    	button = create_button_pixmap(Win,play_xpm," Play ");
    else
    if(strstr(string,"Next")||strstr(string,"NEXT") )
    	button = create_button_pixmap(Win,next_xpm," NEXT ");
    else
    	button = gtk_button_new_with_label(string);

    return button;
}
/********************************************************************************/
GtkWidget* Message(char *message,char *titre,gboolean center)
{
    GtkWidget *DialogueMessage = NULL;
    GtkWidget *Label, *Bouton;
    GtkWidget *frame, *vboxframe;


    DialogueMessage = gtk_dialog_new();
    gtk_widget_realize(GTK_WIDGET(DialogueMessage));

    gtk_window_set_title(GTK_WINDOW(DialogueMessage),titre);
   gtk_window_set_transient_for(GTK_WINDOW(DialogueMessage),GTK_WINDOW(Fenetre));
    gtk_window_set_position(GTK_WINDOW(DialogueMessage),GTK_WIN_POS_CENTER);

   g_signal_connect(G_OBJECT(DialogueMessage), "delete_event", (GtkSignalFunc)destroy_button_windows, NULL);
    g_signal_connect(G_OBJECT(DialogueMessage), "delete_event", (GtkSignalFunc)gtk_widget_destroy, NULL);
  frame = gtk_frame_new (NULL);
  gtk_frame_set_shadow_type( GTK_FRAME(frame),GTK_SHADOW_ETCHED_OUT);

  gtk_container_set_border_width (GTK_CONTAINER (frame), 5);
   gtk_box_pack_start_defaults( GTK_BOX(GTK_DIALOG(DialogueMessage)->vbox), frame);

  gtk_widget_show (frame);

  vboxframe = create_vbox(frame);

    if(center)
    {
    	Label = create_label_with_pixmap(Fenetre,message,titre);
    	gtk_box_pack_start_defaults(GTK_BOX(vboxframe), Label);
    }
    else
    {
	GtkWidget* hbox;
    	Label = gtk_label_new(message);
  	gtk_widget_show (Label);
   	gtk_label_set_justify(GTK_LABEL(Label),GTK_JUSTIFY_LEFT);
  	hbox = gtk_hbox_new (FALSE, 5);
  	gtk_box_pack_start (GTK_BOX (vboxframe), hbox, FALSE, FALSE, 5);
  	gtk_box_pack_start (GTK_BOX(hbox), Label, FALSE, FALSE, 5);
  	gtk_widget_show (hbox);
    }
    
    gtk_box_set_homogeneous (GTK_BOX( GTK_DIALOG(DialogueMessage)->action_area), FALSE);
  
  Bouton = create_button(DialogueMessage,"OK");
  gtk_box_pack_end (GTK_BOX( GTK_DIALOG(DialogueMessage)->action_area), Bouton, FALSE, TRUE, 5);  
  GTK_WIDGET_SET_FLAGS(Bouton, GTK_CAN_DEFAULT);
  gtk_widget_grab_default(Bouton);
 g_signal_connect_swapped(G_OBJECT(Bouton), "clicked",
                          (GtkSignalFunc)destroy_button_windows,
                          GTK_OBJECT(DialogueMessage));
    g_signal_connect_swapped(G_OBJECT(Bouton), "clicked",
                          (GtkSignalFunc)gtk_widget_destroy,
                          GTK_OBJECT(DialogueMessage));

    add_button_windows(titre,DialogueMessage);
    gtk_widget_show_all(DialogueMessage);
    return DialogueMessage;
}
/********************************************************************************/
void select_all()
{
	
	if( gtk_notebook_get_current_page(GTK_NOTEBOOK(NoteBookText))==0)
		gabedit_text_select_all(text);
	else
		gabedit_text_select_all(textresult);
}
/********************************************************************************/
void goto_end(GtkWidget *current,gpointer data)
{
	gabedit_text_goto_end(current);
}      
/********************************************************************************/
void goto_end_result(GtkWidget *win,gpointer data)
{
 	goto_end(textresult,data);
}      
/********************************************************************************/
void ClearText(GtkWidget* text)
{
        gint nchar;
        nchar=gabedit_text_get_length(GABEDIT_TEXT(text));
        gabedit_text_set_point(GABEDIT_TEXT(text),0);
        gabedit_text_forward_delete(GABEDIT_TEXT(text),nchar);
        
        gabedit_text_set_point(GABEDIT_TEXT(text),0);

}
/********************************************************************************/
void destroy( GtkWidget *widget, gpointer   data )
{
  guint i;
           if(iframe==2)
 		geom_is_not_open();
           gtk_widget_destroy(widget);
           iedit=1;
           gabedit_text_set_editable(GABEDIT_TEXT(text), TRUE);
           if(iframe==2 && iprogram == PROG_IS_GAUSS)
       	     for(i=0;i<6;i++)
       		EntryCS[i]=NULL;
           iframe=1;
           widget = NULL;
}
/********************************************************************************/
void Cancel_YesNo(GtkWidget *widget, gpointer   data, GabeditSignalFunc func)
{
    GtkWidget *DialogueMessage = NULL;
    GtkWidget *Label, *Bouton;
	GtkWidget *frame, *vboxframe;
    DialogueMessage = gtk_dialog_new();
	gtk_window_set_position(GTK_WINDOW(DialogueMessage),GTK_WIN_POS_CENTER);
    gtk_window_set_title(GTK_WINDOW(DialogueMessage)," Warning ");
    gtk_window_set_modal (GTK_WINDOW (DialogueMessage), TRUE);

    g_signal_connect(G_OBJECT(DialogueMessage),
                       "delete_event",
                       (GtkSignalFunc)gtk_widget_destroy,
                       NULL);
    
	frame = gtk_frame_new (NULL);
    gtk_frame_set_shadow_type( GTK_FRAME(frame),GTK_SHADOW_ETCHED_OUT);
    gtk_widget_ref (frame);
    g_object_set_data_full (G_OBJECT (DialogueMessage), "frame",
	  frame,(GtkDestroyNotify) gtk_widget_unref);
    gtk_container_set_border_width (GTK_CONTAINER (frame), 10);
    gtk_box_pack_start_defaults(
         GTK_BOX(GTK_DIALOG(DialogueMessage)->vbox), frame);
    gtk_widget_show (frame);
    vboxframe = create_vbox(frame);

    Label = gtk_label_new("Are you sure to \ncancel this window ?");
    gtk_box_pack_start_defaults(GTK_BOX(vboxframe), Label);
    gtk_label_set_justify(GTK_LABEL(Label),
                          GTK_JUSTIFY_CENTER);
    gtk_misc_set_padding(GTK_MISC(Label), 10, 10);
    
    gtk_widget_realize(DialogueMessage);

    Bouton = create_button(DialogueMessage,"No");
    gtk_box_pack_start_defaults( GTK_BOX(GTK_DIALOG(DialogueMessage)->action_area), Bouton);
    g_signal_connect_swapped(G_OBJECT(Bouton), "clicked", (GtkSignalFunc)gtk_widget_destroy, GTK_OBJECT(DialogueMessage));
    GTK_WIDGET_SET_FLAGS(Bouton, GTK_CAN_DEFAULT);
    gtk_widget_grab_default(Bouton);

    Bouton = create_button(DialogueMessage,"Yes");
    gtk_box_pack_start_defaults( GTK_BOX(GTK_DIALOG(DialogueMessage)->action_area), Bouton);
    GTK_WIDGET_SET_FLAGS(Bouton, GTK_CAN_DEFAULT);
    g_signal_connect_swapped(G_OBJECT(Bouton),"clicked", (GtkSignalFunc)func, GTK_OBJECT(widget));
    g_signal_connect_swapped(G_OBJECT(Bouton), "clicked", (GtkSignalFunc)gtk_widget_destroy, GTK_OBJECT(DialogueMessage));


    gtk_widget_show_all(DialogueMessage);
}
/**********************************************************************************/
FilePosTypeGeom get_geometry_type_from_molpro_input_file(gchar *NomFichier)
{
 gchar *t;
 FILE *fd;
 guint taille=BSIZE;
 FilePosTypeGeom j;
 gint k;
 gchar *t1;
 gchar *t2;
 gchar *t3 = NULL;

 
 j.geomtyp=GEOM_IS_ZMAT;
 j.numline=0;
 j.units=0;
 t=g_malloc(taille);
 fd = FOpen(NomFichier, "r");
 if(fd!=NULL)
 {
 	k= 0;
 	while(!feof(fd) )    
 	{
 		if(!fgets(t, taille, fd))
			break;
 		k++; 
                t1 = g_strdup(t);
                t2= g_strdup("Geometry={");
                g_strup(t1);
                g_strup(t2);
                t3 = NULL;
                t3 = strstr(t1,t2);
                if(t3 != NULL)
 			j.numline=k;
                g_free(t2); 
                t3 = NULL;
                t2= g_strdup("ANGSTROM");
                t3 = strstr(t1,t2);
                if(t3 != NULL)
 			j.units=1;
                g_free(t2); 
                t2= g_strdup("geomtyp=xyz");
                g_strup(t2);
                t3 = NULL;
                t3 = strstr(t1,t2);
                if(t3 != NULL)
 			j.geomtyp=GEOM_IS_XYZ;
                g_free(t2); 
                g_free(t1);
  	}
  	fclose(fd);
  }
  if(j.numline==0)
	j.geomtyp=GEOM_IS_OTHER;
  g_free(t);
  return j;
}
/**********************************************************************************/
FilePosTypeGeom get_geometry_type_from_gauss_input_file(gchar *NomFichier)
{
 gchar *t;
 FILE *fd;
 guint taille=BSIZE;
 gboolean OK=TRUE;
 gint i;
 FilePosTypeGeom j;
 gint k;
 gchar *t1;
 gchar *t2;
 gchar *t3 = NULL;

 
 j.geomtyp=GEOM_IS_OTHER;
 j.numline=0;
 j.units=1;
 t=g_malloc(taille);
 fd = FOpen(NomFichier, "r");
 if(fd!=NULL)
 {
/* Commands lines */
 while(!feof(fd) )    
 {
 	if(!fgets(t, taille, fd))
		break;
 	j.numline++;
     	if((int)t[0]==(int)'#' || (int)t[0]==(int)'%' )
        {
                t1 = g_strdup(t);
                t2= g_strdup("Units(Au");
                g_strup(t1);
                g_strup(t2);
                t3 = strstr(t1,t2);
                if(t3 != NULL)
 			j.units=0;
                g_free(t1);
                g_free(t2); 
        	continue;
        }
     	else
		break;
  }
/* Title */
 while(!feof(fd) )    
 {
 	if(!fgets(t, taille, fd))
		break;
 	j.numline++;
      	OK=TRUE;
      	for(i=0;i<(gint)strlen(t);i++)
      	if(t[i]!=' ' && t[i] !='\n' )
      	{
		OK=FALSE;
        	break;
      	}
        if(OK)
        	break;
  }

/* Charge and Spin */
 if(!feof(fd) )    
 {
 if(fgets(t, taille, fd))
  	j.numline++;
 }
/* First line of geometry */
  if(!feof(fd) )    
  {
 	if(!fgets(t, taille, fd))
        {
  		j.geomtyp = GEOM_IS_OTHER;
        }
        else
        {
		gchar dump[5][BSIZE];
 		j.numline++;

		k = sscanf(t,"%s %s %s %s %s",dump[0],dump[1],dump[2],dump[3],dump[4]);
		if(k==5)
			j.geomtyp = GEOM_IS_XYZ;
		else
		if(k==4)
			j.geomtyp = GEOM_IS_XYZ;
		else
		if(k==1)
			j.geomtyp = GEOM_IS_ZMAT;
		else
			j.geomtyp = GEOM_IS_OTHER;
		/*
  		k=0;
  		for(i=strlen(t)-1;i>0;i--)
    		if(t[i]!=' ' || t[i] !='\n' )
    		{
			k=i;
       			break;
    		}
  		if(k>2)
   			j.geomtyp = GEOM_IS_XYZ;
  		else
  		if(k>0 && k<=2)
   			j.geomtyp = GEOM_IS_ZMAT;
  		else j.geomtyp = GEOM_IS_OTHER;
		*/
        }
   }
 }     
  fclose(fd);
  g_free(t);
  return j;
}
/**********************************************************************************/
FilePosTypeGeom get_geometry_type_from_qchem_input_file(gchar *NomFichier)
{
 gchar *t;
 FILE *fd;
 guint taille=BSIZE;
 FilePosTypeGeom j;
 gint k;

 
 j.geomtyp=GEOM_IS_OTHER;
 j.numline=0;
 j.units=1;
 t=g_malloc(taille);
 fd = FOpen(NomFichier, "r");
 if(fd!=NULL)
 {
 while(!feof(fd) )    
 {
 	if(!fgets(t, taille, fd)) break;
	if(strstr(t,"$molecule")) break;
  	j.numline++;
  }
/* Charge and Spin */
 if(!feof(fd) )    
 {
 if(fgets(t, taille, fd))
  	j.numline++;
 }
/* First line of geometry */
  if(!feof(fd) )    
  {
 	if(!fgets(t, taille, fd))
        {
  		j.geomtyp = GEOM_IS_OTHER;
        }
        else
        {
		gchar dump[5][BSIZE];
 		j.numline++;

		k = sscanf(t,"%s %s %s %s %s",dump[0],dump[1],dump[2],dump[3],dump[4]);
		if(k==5)
			j.geomtyp = GEOM_IS_XYZ;
		else
		if(k==4)
			j.geomtyp = GEOM_IS_XYZ;
		else
		if(k==1)
			j.geomtyp = GEOM_IS_ZMAT;
		else
			j.geomtyp = GEOM_IS_OTHER;
        }
   }
 }     
  fclose(fd);
  g_free(t);
  return j;
}
/**********************************************************************************/
void read_geom_in_gamess_input(gchar *fileName)
{
	gchar* logfile;
	gchar* t;
	FILE* file;
	t = get_suffix_name_file(fileName);
	logfile = g_strdup_printf("%s.log",t);
	file = FOpen(logfile, "r");
	if(!file)
	{
		if(logfile) g_free(logfile);
		logfile = g_strdup_printf("%s.out",t);
		file = FOpen(logfile, "r");
		if(!file) return;
	}
	fclose(file);
	read_geom_from_gamess_output_file(logfile,1);
}
/**********************************************************************************/
void read_geom_in_pcgamess_input(gchar *fileName)
{
	gchar* logfile;
	gchar* t;
	FILE* file;
	t = get_suffix_name_file(fileName);
	logfile = g_strdup_printf("%s.log",t);
	file = FOpen(logfile, "r");
	if(!file)
	{
		if(logfile) g_free(logfile);
		logfile = g_strdup_printf("%s.out",t);
		file = FOpen(logfile, "r");
		if(!file) return;
	}
	fclose(file);
	read_geom_from_gamess_output_file(logfile,1);
}
/**********************************************************************************/
void read_geom_in_mpqc_input(gchar *fileName)
{
	read_XYZ_from_mpqc_input_file(fileName);
}
/**********************************************************************************/
void read_geom_in_gauss_input(gchar *NameFile)
{
	FilePosTypeGeom j;
 	j=  get_geometry_type_from_gauss_input_file(NameFile);
 	if( j.geomtyp == GEOM_IS_XYZ)
		read_XYZ_from_gauss_input_file(NameFile,j);
      	else
 	if( j.geomtyp == GEOM_IS_ZMAT)
		read_Zmat_from_gauss_input_file(NameFile,j);
        else
    		Message("Sorry\nI can not read gemetry in gaussian input file\n"," Warning ",TRUE);
}
/**********************************************************************************/
void read_geom_in_molcas_input(gchar *NameFile)
{
	setMolcasGeometryFromInputFile(NameFile);
}
/**********************************************************************************/
void read_geom_in_molpro_input(gchar *NameFile)
{
	FilePosTypeGeom j;
 	j=  get_geometry_type_from_molpro_input_file(NameFile);

 	if( j.geomtyp == GEOM_IS_XYZ)
		read_XYZ_from_molpro_input_file(NameFile,j);
        else
 	if( j.geomtyp == GEOM_IS_ZMAT)
		read_Zmat_from_molpro_input_file(NameFile,j);
        else
    		Message("Sorry\nI can not read gemetry in molpro input file\n"," Warning ",TRUE);
}
/**********************************************************************************/
void read_geom_in_qchem_input(gchar *NameFile)
{
	FilePosTypeGeom j;
 	j=  get_geometry_type_from_qchem_input_file(NameFile);
 	if( j.geomtyp == GEOM_IS_XYZ)
		read_XYZ_from_qchem_input_file(NameFile);
      	else
 	if( j.geomtyp == GEOM_IS_ZMAT)
		read_Zmat_from_qchem_input_file(NameFile);
        else
    		Message("Sorry\nI can not read gemetry in Q-Chem input file\n"," Warning ",TRUE);
}
/**********************************************************************************/
void get_doc(gchar *NomFichier)
{
	gchar *t;
	FILE *fd;
	guint nchar;
	guint taille=BSIZE;

	if ((!NomFichier) || (strcmp(NomFichier,"") == 0)) return ;
 
	t=g_malloc(taille);
	fd = FOpen(NomFichier, "r");
	if(fd==NULL)
	{
		g_free(t);
		t = g_strdup_printf("Sorry, I can not open\n %s\n file",NomFichier);
		Message(t,"Error",TRUE);
		g_free(t);
		return;
	}

	iprogram = get_type_of_program(fd);

	nchar=gabedit_text_get_length(GABEDIT_TEXT(text));
	gabedit_text_set_point(GABEDIT_TEXT(text),0);
	gabedit_text_forward_delete(GABEDIT_TEXT(text),nchar);

	while(1)
	{
		nchar = fread(t, 1, taille, fd);
		gabedit_text_insert (GABEDIT_TEXT(text), NULL, NULL, NULL, t,nchar);
     		if(nchar<taille) break;
	}
	fclose(fd);

	g_free(t);
	gabedit_text_set_point(GABEDIT_TEXT(text),0);

	fileopen.remotehost = NULL;
	fileopen.remoteuser = NULL;
	fileopen.remotepass = NULL;
	fileopen.remotedir = NULL;
	fileopen.command = NULL;
	fileopen.netWorkProtocol = defaultNetWorkProtocol;

	if(iprogram == PROG_IS_MPQC) fileopen.command=g_strdup(NameCommandMPQC);
	else if(iprogram == PROG_IS_GAMESS) fileopen.command=g_strdup(NameCommandGamess);
	else if(iprogram == PROG_IS_PCGAMESS) fileopen.command=g_strdup(NameCommandPCGamess);
	else if(iprogram == PROG_IS_GAUSS) fileopen.command=g_strdup(NameCommandGaussian);
	else if(iprogram == PROG_IS_MOLCAS) fileopen.command=g_strdup(NameCommandMolcas);
	else if(iprogram == PROG_IS_MOLPRO) fileopen.command=g_strdup(NameCommandMolpro);
	else if(iprogram == PROG_IS_QCHEM) fileopen.command=g_strdup(NameCommandQChem);
     	else fileopen.command=NULL;

	if(iprogram> PROG_IS_OTHER )
	{
		fileopen.datafile = get_name_file(NomFichier); 
		t = get_suffix_name_file(NomFichier);
		fileopen.projectname = get_name_file(t);
		fileopen.localdir = get_name_dir(t);
		g_free(t);
		CreeFeuille(treeViewProjects, noeud[iprogram],fileopen.projectname,fileopen.datafile ,fileopen.localdir,
			fileopen.remotehost,fileopen.remoteuser,fileopen.remotepass,fileopen.remotedir,iprogram,  fileopen.command, fileopen.netWorkProtocol);
	}
	else
	{
  		fileopen.projectname = get_name_file(NomFichier);
  		fileopen.localdir = get_name_dir(NomFichier);
 		CreeFeuille(treeViewProjects, noeud[NBNOD-1],fileopen.projectname,fileopen.projectname,fileopen.localdir,
				fileopen.remotehost,fileopen.remoteuser,fileopen.remotepass,fileopen.remotedir,NBNOD-1,  fileopen.command, fileopen.netWorkProtocol);
	}

	if(iprogram == PROG_IS_GAMESS)
	{
 		fileopen.datafile = g_strdup_printf("%s.inp",fileopen.projectname);
 		fileopen.outputfile=g_strdup_printf("%s.log",fileopen.projectname);
 		fileopen.logfile=g_strdup_printf("%s.log",fileopen.projectname);
  		/* fileopen.moldenfile=g_strdup_printf("%s.molden",fileopen.projectname);*/
  		fileopen.moldenfile=g_strdup_printf("%s.log",fileopen.projectname);
	}
	else
	if(iprogram == PROG_IS_PCGAMESS)
	{
 		fileopen.datafile = g_strdup_printf("%s.inp",fileopen.projectname);
 		fileopen.outputfile=g_strdup_printf("%s.log",fileopen.projectname);
 		fileopen.logfile=g_strdup_printf("%s.log",fileopen.projectname);
  		/* fileopen.moldenfile=g_strdup_printf("%s.molden",fileopen.projectname);*/
  		fileopen.moldenfile=g_strdup_printf("%s.log",fileopen.projectname);
	}
	else
	if(iprogram == PROG_IS_MPQC)
	{
 		fileopen.datafile = g_strdup_printf("%s.com",fileopen.projectname);
 		fileopen.outputfile=g_strdup_printf("%s.out",fileopen.projectname);
 		fileopen.logfile=g_strdup_printf("%s.out",fileopen.projectname);
  		fileopen.moldenfile=g_strdup_printf("'%s.molden'", fileopen.projectname);
	}
	else
	if(iprogram == PROG_IS_MOLCAS)
	{
 		fileopen.datafile = g_strdup_printf("%s.com",fileopen.projectname);
 		fileopen.outputfile=g_strdup_printf("%s.out",fileopen.projectname);
 		fileopen.logfile=g_strdup_printf("%s.log",fileopen.projectname);
  		/* fileopen.moldenfile=g_strdup_printf("%s.molden",fileopen.projectname);*/
  		fileopen.moldenfile=g_strdup_printf("'%s.*.molden'", fileopen.projectname);
	}
	else
	if(iprogram == PROG_IS_MOLPRO)
	{
 		fileopen.datafile = g_strdup_printf("%s.com",fileopen.projectname);
 		fileopen.outputfile=g_strdup_printf("%s.out",fileopen.projectname);
 		fileopen.logfile=g_strdup_printf("%s.log",fileopen.projectname);
  		fileopen.moldenfile=g_strdup_printf("%s.molden",fileopen.projectname);
	}
	else if(iprogram == PROG_IS_GAUSS)
 	{
 		fileopen.datafile = g_strdup_printf("%s.com",fileopen.projectname);
 		fileopen.outputfile=g_strdup_printf("%s.log",fileopen.projectname);
 		fileopen.logfile=g_strdup_printf("%s.log",fileopen.projectname);
  		fileopen.moldenfile=g_strdup_printf("%s.log",fileopen.projectname);
 	}
	else if(iprogram == PROG_IS_QCHEM)
 	{
 		fileopen.datafile = g_strdup_printf("%s.inp",fileopen.projectname);
 		fileopen.outputfile=g_strdup_printf("%s.out",fileopen.projectname);
 		fileopen.logfile=g_strdup_printf("%s.out",fileopen.projectname);
  		fileopen.moldenfile=g_strdup_printf("%s.out",fileopen.projectname);
 	}
	else
	{
 		fileopen.datafile = g_strdup_printf("%s",fileopen.projectname);
 		fileopen.outputfile=g_strdup_printf("%s","Unknown");
 		fileopen.logfile = g_strdup_printf("%s","Unknown");
	}

	if( iprogram == PROG_IS_GAUSS) read_geom_in_gauss_input(NomFichier);
	else if( iprogram == PROG_IS_GAMESS) read_geom_in_gamess_input(NomFichier);
	else if( iprogram == PROG_IS_PCGAMESS) read_geom_in_pcgamess_input(NomFichier);
	else if( iprogram == PROG_IS_MOLPRO) read_geom_in_molpro_input(NomFichier);
	else if( iprogram == PROG_IS_MPQC) read_geom_in_mpqc_input(NomFichier);
	else if( iprogram == PROG_IS_QCHEM) read_geom_in_qchem_input(NomFichier);
	else if(iprogram == PROG_IS_MOLCAS)
	{
		setMolcasVariablesFromInputFile(NomFichier);
		read_geom_in_molcas_input(NomFichier);
	}

	data_modify(FALSE);

	if(GeomConvIsOpen) find_energy_gamess_gauss_molcas_molpro_mpqc_qchem(NULL,NULL);

}
/********************************************************************************/
 void show_doc(GabeditFileChooser *SelecteurFichier, gint response_id)
{
 
 char *NomFichier;
 if(response_id != GTK_RESPONSE_OK) return;
 NomFichier = gabedit_file_chooser_get_current_file(SelecteurFichier);
 get_doc(NomFichier);
 }
/********************************************************************************/
 void insert_doc(GabeditFileChooser *SelecteurFichier, gint response_id)
{
 char *t;
 char *NomFichier;
 guint nchar;
 FILE *fd;
 guint taille=BSIZE;
 if(response_id != GTK_RESPONSE_OK) return;
 NomFichier = gabedit_file_chooser_get_current_file(SelecteurFichier);
 if ((!NomFichier) || (strcmp(NomFichier,"") == 0))
		    return ;

 
 t=g_malloc(taille);
 fd = FOpen(NomFichier, "r");
 if(fd!=NULL)
 {
  while(1)
  {
     nchar = fread(t, 1, taille, fd);
     gabedit_text_insert (GABEDIT_TEXT(text), NULL, NULL, NULL, t,nchar);
     if(nchar<taille) break;
  }
  fclose(fd);
 }
 g_free(t);
 gabedit_text_set_point(GABEDIT_TEXT(text),0);
 set_last_directory(NomFichier);
}
/********************************************************************************/
 void charge_doc(GtkWidget* wid, gpointer data)
{
 gtk_notebook_set_current_page((GtkNotebook*)NoteBookText,0);
 choose_file_to_open();
}
/********************************************************************************/
 void inserrer_doc(void)
{
 gtk_notebook_set_current_page((GtkNotebook*)NoteBookText,0);
 choose_file_to_insert();
 /*data_modify(TRUE);*/
}
/********************************************************************************/
static gboolean enreg_doc(gchar *NomFichier)
{
	gchar *temp;
	FILE *fd;
	gint i;
 
	fd = FOpen(NomFichier, "wb");
	if(fd == NULL)
	{
		Message("Sorry, I can not save file","Error",TRUE);
		return FALSE;
	}
	temp=gabedit_text_get_chars(text,0,-1);
	for(i=0;i<strlen(temp);i++)
		if(temp[i]=='\r') temp[i] = ' ';
	fprintf(fd,"%s",temp);
	fclose(fd);
	g_free(temp);
	set_last_directory(NomFichier);
	return TRUE;
}
/********************************************************************************/
void enreg_selec_doc(GabeditFileChooser *SelecteurFichier , gint response_id)
{
 
	gchar *temp;
	gchar *NomFichier;
  
 	if(response_id != GTK_RESPONSE_OK) return;
 	NomFichier = gabedit_file_chooser_get_current_file(SelecteurFichier);

	if ((!NomFichier) || (strcmp(NomFichier,"") == 0)) return ;
  
	if(iprogram == PROG_IS_MPQC) fileopen.command=g_strdup(NameCommandMPQC);
	else if(iprogram == PROG_IS_GAMESS) fileopen.command=g_strdup(NameCommandGamess);
	else if(iprogram == PROG_IS_PCGAMESS) fileopen.command=g_strdup(NameCommandPCGamess);
	else if(iprogram == PROG_IS_GAUSS) fileopen.command=g_strdup(NameCommandGaussian);
	else if(iprogram == PROG_IS_MOLCAS) fileopen.command=g_strdup(NameCommandMolcas);
	else if(iprogram == PROG_IS_MOLPRO) fileopen.command=g_strdup(NameCommandMolpro);
     	else fileopen.command=NULL;

	if(iprogram>PROG_IS_OTHER)
	{
 		temp = get_suffix_name_file(NomFichier);
 		fileopen.projectname = get_name_file(temp);
 		fileopen.localdir = get_name_dir(temp);
 		g_free(temp);
		if(iprogram==PROG_IS_GAMESS)
		fileopen.datafile = g_strdup_printf("%s.inp",fileopen.projectname);
		else
		if(iprogram==PROG_IS_PCGAMESS)
		fileopen.datafile = g_strdup_printf("%s.inp",fileopen.projectname);
		else
		if(iprogram==PROG_IS_QCHEM)
		fileopen.datafile = g_strdup_printf("%s.inp",fileopen.projectname);
		else
		fileopen.datafile = g_strdup_printf("%s.com",fileopen.projectname);
		if(NomFichier) g_free(NomFichier);
		NomFichier = g_strdup_printf("%s%s%s",fileopen.localdir,G_DIR_SEPARATOR_S,fileopen.datafile);

 		fileopen.remotehost = NULL;
 		fileopen.remoteuser = NULL;
 		fileopen.remotepass = NULL;
 		fileopen.remotedir = NULL;
		fileopen.netWorkProtocol = defaultNetWorkProtocol;

 		CreeFeuille(treeViewProjects, noeud[iprogram],fileopen.projectname,fileopen.datafile,fileopen.localdir,
					fileopen.remotehost,fileopen.remoteuser,fileopen.remotepass,fileopen.remotedir,iprogram,  fileopen.command, fileopen.netWorkProtocol);
	}
	else
	{
		temp = NomFichier;
 		fileopen.projectname = get_name_file(temp);
 		fileopen.localdir = get_name_dir(temp);
 		fileopen.remotehost = NULL;
 		fileopen.remoteuser = NULL;
 		fileopen.remotepass = NULL;
		fileopen.netWorkProtocol = defaultNetWorkProtocol;
 		CreeFeuille(treeViewProjects, noeud[NBNOD-1],fileopen.projectname,fileopen.projectname,
			fileopen.localdir,fileopen.remotehost,fileopen.remoteuser,fileopen.remotepass,fileopen.remotedir,NBNOD-1,  fileopen.command, fileopen.netWorkProtocol);
	}

	if(iprogram == PROG_IS_MPQC)
	{
		fileopen.datafile = g_strdup_printf("%s.com",fileopen.projectname);
	 	fileopen.outputfile = g_strdup_printf("%s.out",fileopen.projectname);
 		fileopen.logfile = g_strdup_printf("%s.out",fileopen.projectname);
 		fileopen.moldenfile = g_strdup_printf("%s.molden",fileopen.projectname);
	}
	else
	if(iprogram == PROG_IS_GAMESS)
	{
		fileopen.datafile = g_strdup_printf("%s.inp",fileopen.projectname);
	 	fileopen.outputfile = g_strdup_printf("%s.log",fileopen.projectname);
 		fileopen.logfile = g_strdup_printf("%s.log",fileopen.projectname);
 		fileopen.moldenfile = g_strdup_printf("%s.log",fileopen.projectname);
	}
	else
	if(iprogram == PROG_IS_PCGAMESS)
	{
		fileopen.datafile = g_strdup_printf("%s.inp",fileopen.projectname);
	 	fileopen.outputfile = g_strdup_printf("%s.log",fileopen.projectname);
 		fileopen.logfile = g_strdup_printf("%s.log",fileopen.projectname);
 		fileopen.moldenfile = g_strdup_printf("%s.log",fileopen.projectname);
	}
	else
	if(iprogram == PROG_IS_GAUSS)
	{
		fileopen.datafile = g_strdup_printf("%s.com",fileopen.projectname);
	 	fileopen.outputfile = g_strdup_printf("%s.log",fileopen.projectname);
 		fileopen.logfile = g_strdup_printf("%s.log",fileopen.projectname);
 		fileopen.moldenfile = g_strdup_printf("%s.log",fileopen.projectname);
	}
	else if(iprogram == PROG_IS_MOLCAS)
	{
 		fileopen.datafile = g_strdup_printf("%s.com",fileopen.projectname);
 		fileopen.outputfile = g_strdup_printf("%s.out",fileopen.projectname);
		fileopen.logfile = g_strdup_printf("%s.log",fileopen.projectname);
		fileopen.moldenfile = g_strdup_printf("%s.molden",fileopen.projectname);
	}
	else if(iprogram == PROG_IS_MOLPRO)
	{
 		fileopen.datafile = g_strdup_printf("%s.com",fileopen.projectname);
 		fileopen.outputfile = g_strdup_printf("%s.out",fileopen.projectname);
		fileopen.logfile = g_strdup_printf("%s.log",fileopen.projectname);
		fileopen.moldenfile = g_strdup_printf("%s.molden",fileopen.projectname);
	}
     	else
	{
		fileopen.datafile = g_strdup(NomFichier);
		fileopen.outputfile = g_strdup("Unknown");
		fileopen.logfile = g_strdup("Unknown");
	}

	if(enreg_doc(NomFichier))
	{
 		change_label_onglet();
 		data_modify(FALSE);
	}
}
/********************************************************************************/
 void save_as_doc(void)
{
	choose_file_to_save();
}
/********************************************************************************/
void save_doc(void)
{
	 if ( strcmp(fileopen.datafile,"NoName") != 0)
	 {
		gchar* FileName =  g_strdup_printf("%s%s%s",fileopen.localdir,G_DIR_SEPARATOR_S,fileopen.datafile);
 		if(enreg_doc(FileName))
			data_modify(FALSE);

		g_free(FileName);
	 }
	else
		choose_file_to_save();
}
/********************************************************************************/
void new_doc_molcas(GtkWidget* wid, gpointer data)
{
 	newMolcas();
	iprogram = PROG_IS_MOLCAS;
}
/********************************************************************************/
 void new_doc_molpro(GtkWidget* wid, gpointer data)
{
 	molpro();
	iprogram = PROG_IS_MOLPRO;
}
/********************************************************************************/
 void new_doc_mpqc(GtkWidget* wid, gpointer data)
{
 	newMPQC();
	iprogram = PROG_IS_MPQC;
}
/********************************************************************************/
 void new_doc_gamess(GtkWidget* wid, gpointer data)
{
 	newGamess();
	iprogram = PROG_IS_GAMESS;
	fileopen.command=g_strdup(NameCommandGamess);
}
/********************************************************************************/
 void new_doc_pcgamess(GtkWidget* wid, gpointer data)
{
 	newPCGamess();
	iprogram = PROG_IS_PCGAMESS;
	fileopen.command=g_strdup(NameCommandPCGamess);
}
/********************************************************************************/
 void new_doc_gauss(GtkWidget* wid, gpointer data)
{
 gauss(1);
}
/********************************************************************************/
 void new_doc_qchem(GtkWidget* wid, gpointer data)
{
 	newQChem();
	iprogram = PROG_IS_QCHEM;
	fileopen.command=g_strdup(NameCommandQChem);
}
/********************************************************************************/
void new_doc_other(GtkWidget* wid, gpointer data)
{
	gint nchar;
 	reset_name_files();
	data_modify(TRUE);
    gabedit_text_set_point(GABEDIT_TEXT(text),0);
	nchar =  gabedit_text_get_length(GABEDIT_TEXT(text));
    gabedit_text_forward_delete(GABEDIT_TEXT(text),nchar);
	gtk_notebook_set_current_page((GtkNotebook*)NoteBookText,0);
}
/********************************************************************************/
 void insert_doc_gauss(void)
{
 gauss(0);
}
/********************************************************************************/
static void show_about_new()
 {
	static const gchar *authors[] = {
		"Abdul-Rahman Allouche <allouchear@users.sourceforge.net>",
		NULL
	};

	static const gchar *documenters[] = {
		"Abdul-Rahman Allouche <allouchear@users.sourceforge.net>",
		NULL
	};

	static const gchar *copyright =
		"Copyright \xc2\xa9 2002-2007 Abdul-Rahman Allouche.\n"
		"All rights reserved.\n";
	
	gchar *license =
		g_strdup_printf("%s%s",
			copyright,
			"\n"
			"Permission is hereby granted, free of charge, to any person obtaining a copy\n"
			"of this software(the Gabedit) and associated documentation files, to deal in\n"
			"the Software without restriction, including without limitation the rights to\n"
			"use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies\n"
			"of the Software, and to permit persons to whom the Software is furnished to \n"
			"do so, subject to the following conditions:\n"
			"\n"
			"The above copyright notice and this permission notice shall be included in all\n"
			"copies or substantial portions of the Software.\n"
			"\n"
			"THE SOFTWARE IS PROVIDED \"AS IS\", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR\n"
			"IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,\n"
			"FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL\n"
			"THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER\n"
			"LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,\n"
			"OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER\n"
			"DEALINGS IN THE SOFTWARE."
			);

	static const gchar *comments =
		"Graphical User Interface to GAMESS-US, Gaussian, Molcas, Molpro, "
		"MPQC, PCGamess and Q-Chem computational chemistry packages.";
	
	gchar *GABEDIT_VERSION =
		g_strdup_printf("%d.%d.%d",MAJOR_VERSION,MINOR_VERSION,MICRO_VERSION);
	
	gtk_about_dialog_set_url_hook(show_homepage, NULL, NULL);

	gtk_show_about_dialog (
		NULL,
		"name", "Gabedit",
		"version", GABEDIT_VERSION,
		"comments", comments,
		"copyright", copyright,
		"license", license,
		"website", "http://gabedit.sourceforge.net",
		"documenters", documenters,
		"authors", authors,
		"logo-icon-name", GTK_STOCK_ABOUT,
		NULL);
		
	g_free(GABEDIT_VERSION);
	g_free(license);
}
/********************************************************************************/
void show_about()
{
	if(GTK_MAJOR_VERSION>=2 && GTK_MINOR_VERSION>=6) show_about_new();
	else create_about_frame();
}
/********************************************************************************/
void show_version()
{
 gchar* Version_S = g_strdup_printf("%d.%d.%d",MAJOR_VERSION,MINOR_VERSION,MICRO_VERSION);
 gchar *temp=g_strdup_printf("\n Version %s \n\n Abdul-Rahman ALLOUCHE\n\n january 2007\n",Version_S);
 Message(temp," Version ",TRUE);
 g_free(Version_S);
 g_free(temp);
}
/********************************************************************************/
void show_homepage(GtkWidget *w,gpointer data)
{

#ifdef G_OS_WIN32
	gchar* Command = "Iexplore.exe http://gabedit.sourceforge.net/";
	system(Command);
#else
	gchar* Command = "mozilla  http://gabedit.sourceforge.net/ &";
	if (system(Command)<0)
	{
		gchar* Command = "galeon http://gabedit.sourceforge.net/ &";
		if (system(Command)<0)
		{
			gchar* Command = "konqueror http://gabedit.sourceforge.net/ &";
			system(Command);
		}
	}
#endif
}
/********************************************************************************/
void desole(void)
{
 char *temp="Sorry , this option is not active";
 Message(temp," Warning ",TRUE);
}
/********************************************************************************/
 void change_insert(void)
{
 if (iedit==0)
      {
      iedit=1;
      gabedit_text_set_editable(GABEDIT_TEXT(text), TRUE);
      }
  else
   {
      iedit=0;
      gabedit_text_set_editable(GABEDIT_TEXT(text), FALSE);
   }
}
/********************************************************************************/
void  create_label_hbox(GtkWidget *hbox,gchar *tlabel,gint llen)
{
    GtkWidget* label;
    label = gtk_label_new(tlabel); 
    gtk_widget_set_size_request(GTK_WIDGET(label),llen,-1);
    gtk_box_pack_start(GTK_BOX(hbox), label,FALSE,FALSE,2);
}
/********************************************************************************/
GtkWidget *create_text(GtkWidget *win,GtkWidget *frame,gboolean editable)
{
  GtkWidget *Text;
  GtkWidget *scrolledwindow;
  scrolledwindow = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_ref (scrolledwindow);
  g_object_set_data_full (G_OBJECT (win), "scrolledwindow", scrolledwindow,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (scrolledwindow);
  gtk_container_add (GTK_CONTAINER (frame), scrolledwindow);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow), GTK_POLICY_NEVER, GTK_POLICY_ALWAYS);

  Text = gabedit_text_new ();
  gtk_widget_ref (Text);
  g_object_set_data_full (G_OBJECT (win), "Text", Text,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (Text);
  gtk_container_add (GTK_CONTAINER (scrolledwindow), Text);
  gabedit_text_set_editable (GABEDIT_TEXT (Text), editable);
  return Text;
}
/********************************************************************************/
void  gtk_combo_box_entry_set_popdown_strings(GtkWidget* comboBoxEntry, GList *list)
{
	GList* l;
	GtkTreeModel * model = NULL;
	if(!list) return;
	model = gtk_combo_box_get_model(GTK_COMBO_BOX(comboBoxEntry));
	gtk_list_store_clear(GTK_LIST_STORE(model));
	l = list;
	while(l)
	{
		gtk_combo_box_append_text (GTK_COMBO_BOX (comboBoxEntry), (gchar*)(l->data));
		l = l->next;
	}
  	gtk_combo_box_set_active(GTK_COMBO_BOX (comboBoxEntry), 0);
}
/********************************************************************************/
GtkWidget*  create_combo_box_entry(gchar **tlist,gint nlist, gboolean edit,gint llen,gint elen)
{
	GtkWidget* combo;
	gint i;
	combo = gtk_combo_box_entry_new_text();
	for (i=0;i<nlist;i++) gtk_combo_box_append_text (GTK_COMBO_BOX (combo), tlist[i]);
	gtk_widget_set_size_request(GTK_WIDGET(combo),elen,-1);
 	gtk_editable_set_editable((GtkEditable*) (GTK_BIN (combo)->child),edit);
	if(nlist>0) gtk_combo_box_set_active(GTK_COMBO_BOX (combo), 0);
	return combo;
}
/********************************************************************************/
GtkWidget *create_combo_box_entry_liste(GtkWidget* Window,GtkWidget* hbox,gchar *lname,gchar **liste,int n)
{
  int i;
  GtkWidget *label;
  GtkWidget *combo;
  GtkWidget *combo_entry;

  if(lname)
  {
  	label = gtk_label_new (lname);
  	gtk_widget_show (label);
  	gtk_box_pack_start (GTK_BOX (hbox), label, TRUE, TRUE, 2);
  }

  combo = gtk_combo_box_entry_new_text ();
  gtk_widget_set_size_request(combo, (gint)(ScreenHeight*0.1), -1);
  gtk_widget_show (combo);
  gtk_box_pack_start (GTK_BOX (hbox), combo, TRUE, TRUE, 2);

  for (i=0;i<n;i++) gtk_combo_box_append_text (GTK_COMBO_BOX (combo), liste[i]);
  if(n>0) gtk_combo_box_set_active(GTK_COMBO_BOX (combo), 0);

  combo_entry = (GTK_BIN (combo)->child);
  gtk_widget_show (combo_entry);
  gtk_entry_set_text (GTK_ENTRY (combo_entry), liste[0]);
  return combo_entry;
 }
/********************************************************************************/
GtkWidget *create_frame(GtkWidget *win,GtkWidget *box,gchar *title)
{
  GtkWidget *frame;
  frame = gtk_frame_new (title);
  gtk_frame_set_shadow_type( GTK_FRAME(frame),GTK_SHADOW_ETCHED_OUT);
  gtk_box_pack_start (GTK_BOX (box), frame, TRUE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (frame), 5);
  gtk_widget_show (frame);
  return frame;
}
/********************************************************************************/
GtkWidget *create_hbox(GtkWidget *vbox)
{
  GtkWidget *hbox;
  hbox = gtk_hbox_new (TRUE, 0);
  gtk_widget_show (hbox);
  gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);
  return hbox;
}
/********************************************************************************/
GtkWidget *create_vbox(GtkWidget *win)
{
  GtkWidget *vbox;
  vbox = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (vbox);
  gtk_container_add (GTK_CONTAINER (win), vbox);
  return vbox;
}
/********************************************************************************/
GtkWidget *create_label_button(GtkWidget *win,GtkWidget *frame,GtkWidget* Vbox,
                         gchar *tlabel,gchar *tbutton)
{
  GtkWidget *label;
  GtkWidget *button;
  GtkWidget *hbox;
 
  hbox = gtk_hbox_new (FALSE, 2);
  gtk_widget_ref (hbox);
  gtk_widget_show (hbox);
  gtk_box_pack_start (GTK_BOX (Vbox), hbox, FALSE, FALSE, 0);

  label = gtk_label_new (tlabel);
  gtk_widget_ref (label);
  g_object_set_data_full (G_OBJECT (win), "label", label,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label);
  gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, TRUE, 2);

  button = gtk_button_new_with_label (tbutton);
  gtk_box_pack_start (GTK_BOX( hbox), button, TRUE, TRUE, 2);
  gtk_widget_show (button);
  return button;
}
/********************************************************************************/
void change_label_onglet()
{
	GtkWidget *LabelOnglet = GTK_WIDGET(g_object_get_data(G_OBJECT(text),"LabelOnglet"));
	gchar *temp;
	GtkStyle *style;

	temp=get_name_file(fileopen.datafile);
	gtk_label_set_text(GTK_LABEL(LabelOnglet),temp);

	if(imodif == DATA_MOD_YES)
	{
		/*
		PangoFontDescription *font_desc;

		font_desc = pango_font_description_from_string (FontsStyleLabel.fontname);
		*/
		style = (GtkStyle*)g_object_get_data(G_OBJECT(text),"StyleRed");
	

		/*
		if (style && font_desc)
		{
			style->font_desc = font_desc;
		}
		*/
		gtk_widget_set_style(LabelOnglet, style );
	}
	else
	{
		/*
  		PangoFontDescription *font_desc;

		font_desc = pango_font_description_from_string (FontsStyleLabel.fontname);
		*/
		style = (GtkStyle*)g_object_get_data(G_OBJECT(text),"StyleDef");

		/*
		if (style && font_desc)
		{
			style->font_desc = font_desc;
		}
		*/

		if(style) gtk_widget_set_style(LabelOnglet, style );
	}

	temp=get_name_file(fileopen.outputfile);
	LabelOnglet = GTK_WIDGET(g_object_get_data(G_OBJECT(textresult),"LabelOnglet"));
	gtk_label_set_text(GTK_LABEL(LabelOnglet),temp);

	g_free(temp);

}
/********************************************************************************/
void change_all_labels()
{
  change_label_onglet();
   set_label_infos_file();
}
/********************************************************************************/
void add_widget_table(GtkWidget *Table,GtkWidget *wid,gushort line,gushort colonne)
{

	gtk_table_attach(GTK_TABLE(Table),wid,colonne,colonne+1,line,line+1,
                  (GtkAttachOptions)(GTK_FILL | GTK_SHRINK),
                  (GtkAttachOptions)(GTK_FILL | GTK_SHRINK),
                  3,3);

}

/********************************************************************************/
GtkWidget *add_label_table(GtkWidget *Table, G_CONST_RETURN gchar *label,gushort line,gushort colonne)
{
	GtkWidget *Label;
	GtkWidget *hbox = gtk_hbox_new(0,FALSE);
	
	Label = gtk_label_new (label);
   	gtk_label_set_justify(GTK_LABEL(Label),GTK_JUSTIFY_LEFT);
	gtk_box_pack_start (GTK_BOX (hbox), Label, FALSE, FALSE, 0);
	add_widget_table(Table,hbox,line,colonne);

	return Label;
}
/********************************************************************************/
void get_result()
{
	char *t;
	FILE *fd;
	guint nchar;
	guint taille=BSIZE;
	nchar=gabedit_text_get_length(GABEDIT_TEXT(textresult));
	if ((!fileopen.outputfile) || (strcmp(fileopen.outputfile,"") == 0)) return ;
	if ((!fileopen.localdir) || (strcmp(fileopen.localdir,"") == 0)) return ;

	gabedit_text_set_point(GABEDIT_TEXT(textresult),0);
	gabedit_text_forward_delete(GABEDIT_TEXT(textresult),nchar);
 
	t = g_strdup_printf("%s%s%s",fileopen.localdir,G_DIR_SEPARATOR_S,fileopen.outputfile);
	fd = FOpen(t, "r");
	g_free(t);
	t=g_malloc(taille*sizeof(char));
	if(fd!=NULL)
	{
		gtk_widget_set_sensitive(ResultLocalFrame, FALSE);
		while(1)
		{
			nchar = fread(t, 1, taille, fd);
			gabedit_text_insert (GABEDIT_TEXT(textresult), NULL, NULL, NULL, t,nchar);
			if(nchar<taille) break;
		}
		fclose(fd);
		gtk_widget_set_sensitive(ResultLocalFrame, TRUE);
	}
	g_free(t);
	gabedit_text_set_point(GABEDIT_TEXT(textresult),0);
}
/********************************************************************************/
 void view_result_end()
{
	gtk_notebook_set_current_page((GtkNotebook*)NoteBookText,1);
	get_result();
	goto_end_result(NULL,NULL);
}
/********************************************************************************/
void view_result()
{
	gtk_notebook_set_current_page((GtkNotebook*)NoteBookText,1);
	get_result();
}
/********************************************************************************/
GtkWidget * create_hseparator(GtkWidget *vbox)
{
	GtkWidget *hseparator;
	hseparator = gtk_hseparator_new ();
	gtk_widget_ref (hseparator);
	g_object_set_data_full (G_OBJECT (vbox), "hseparator", hseparator, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (hseparator);
	gtk_box_pack_start (GTK_BOX (vbox), hseparator, FALSE, FALSE, 1);
	return hseparator;
}
/********************************************************************************/
GtkWidget * create_vseparator(GtkWidget *hbox)
{
	GtkWidget *vseparator;
	vseparator = gtk_vseparator_new ();
	gtk_widget_ref (vseparator);
	g_object_set_data_full (G_OBJECT (hbox), "vseparator", vseparator, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (vseparator);
	gtk_box_pack_start (GTK_BOX (hbox), vseparator, FALSE, FALSE, 1);
	return vseparator;
}
/********************************************************************************/
GtkWidget*  create_vbox_false(GtkWidget *win)
{
	GtkWidget *vbox;
	vbox = gtk_vbox_new (FALSE, 0);
	gtk_container_add (GTK_CONTAINER (win), vbox);
	gtk_widget_show (vbox);
	return vbox;
}
/********************************************************************************/
GtkWidget*  create_hbox_false(GtkWidget *vbox)
{
	GtkWidget *hbox;
	hbox = gtk_hbox_new (FALSE, 0);
	gtk_box_pack_start (GTK_BOX(vbox), hbox, FALSE, FALSE, 2);
	gtk_widget_show (hbox);
	return hbox;
}
/********************************************************************************/
GtkWidget*  create_hbox_true(GtkWidget *vbox)
{
	GtkWidget *hbox;
	hbox = gtk_hbox_new (FALSE, 0);
	gtk_box_pack_start (GTK_BOX(vbox), hbox, TRUE, TRUE, 2);
	gtk_widget_show (hbox);
	return hbox;
}
/********************************************************************************/
GtkWidget*  create_label_entry(GtkWidget *hbox,gchar *tlabel,gint llen,gint elen)
{
	 GtkWidget* entry;
	GtkWidget* label;
    
	label = gtk_label_new(tlabel); 
	gtk_widget_set_size_request(GTK_WIDGET(label),llen,-1);
	gtk_box_pack_start(GTK_BOX(hbox), label,FALSE,FALSE,2);
   
	entry = gtk_entry_new();
	gtk_widget_set_size_request(GTK_WIDGET(entry),elen,-1);
	gtk_box_pack_start(GTK_BOX(hbox), entry,FALSE,FALSE,2);
	return entry;
}
/********************************************************************************/
GtkWidget*  create_label_combo(GtkWidget *hbox,gchar *tlabel,gchar **tlist,gint nlist, gboolean edit,gint llen,gint elen)
{
	GtkWidget* combo;
	GtkWidget* label;
	gint i;

	label = gtk_label_new(tlabel); 
	gtk_widget_set_size_request(GTK_WIDGET(label),llen,-1);
	gtk_box_pack_start(GTK_BOX(hbox), label,FALSE,FALSE,2);

	combo = gtk_combo_box_entry_new_text();
	for (i=0;i<nlist;i++) gtk_combo_box_append_text (GTK_COMBO_BOX (combo), tlist[i]);
	if(nlist>0) gtk_combo_box_set_active(GTK_COMBO_BOX (combo), 0);
	gtk_widget_set_size_request(GTK_WIDGET(combo),elen,-1);
	gtk_box_pack_start(GTK_BOX(hbox), combo,FALSE,FALSE,2);
	gtk_widget_set_sensitive(GTK_BIN(combo)->child,edit);
	return GTK_BIN(combo)->child;
}
/********************************************************************************/
void show_forbidden_characters()
{
	gchar *temp;
	gchar Forbidden[]={
	'0','1','2','3','4','5','6','7','8','9',
    	'+','-','/','%','$','*','!','@','#','^',
    	'&','(',')','|','\\','<','>','?',',','~',
    	'`','\'','.','"',':',';'};
	guint All=36;
	guint i;
	temp = g_strdup("Sorry the name of varibale is not valid !\n\n");
	temp = g_strdup_printf("%s The first caractere can not be one of : \n",temp);
	for(i=0;i<10;i++)
		temp = g_strdup_printf("%s %c",temp,Forbidden[i]);
	temp = g_strdup_printf("%s \n\n",temp);
	temp = g_strdup_printf("%s Do not use the following characters :\n",temp);
	for(i=11;i<All;i++)
	{
		temp = g_strdup_printf("%s %c ",temp,Forbidden[i]);
		if(i%10 == 0) temp = g_strdup_printf("%s \n",temp);
	}
	Message(temp," Error ",TRUE);
	g_free(temp);
}
/********************************************************************************/
void  cree_p_vbox()
{
	vboxmain = gtk_vbox_new (FALSE, 0);
	gtk_container_add (GTK_CONTAINER (Fenetre), vboxmain);
	gtk_widget_show (vboxmain);
}
/********************************************************************************/
void  cree_vboxs_list_text()
{
	GtkWidget *hpaned;

	hpaned = gtk_hpaned_new();
	gtk_container_add (GTK_CONTAINER (vboxmain), hpaned);

	vboxlistfiles = gtk_vbox_new (FALSE, 0);
	gtk_paned_add1(GTK_PANED(hpaned), vboxlistfiles);
	gtk_widget_show (vboxlistfiles);

	vboxtexts = gtk_vbox_new (FALSE, 0);
	gtk_paned_add2(GTK_PANED(hpaned), vboxtexts);
	gtk_widget_realize (vboxtexts);
	gtk_widget_show (vboxtexts);
	Hpaned = hpaned;
}
/********************************************************************************/
GtkWidget *create_checkbutton(GtkWidget *win,GtkWidget *box,gchar *tlabel)
{
	GtkWidget* checkbutton;
	checkbutton = gtk_check_button_new_with_label (tlabel);
	gtk_widget_ref (checkbutton);
	g_object_set_data_full (G_OBJECT (win), "checkbutton", checkbutton, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (checkbutton);
	gtk_box_pack_start (GTK_BOX (box), checkbutton, FALSE, FALSE, 0);
	return checkbutton;
}
/********************************************************************************/
GtkWidget *Continue_YesNo(void (*func)(GtkWidget*,gpointer data),gpointer data,gchar *message)
{
	GtkWidget *DialogueMessage = NULL;
	GtkWidget *Label, *Bouton;
	GtkWidget *frame, *vboxframe;
	DialogueMessage = gtk_dialog_new();
	gtk_window_set_position(GTK_WINDOW(DialogueMessage),GTK_WIN_POS_CENTER);
	gtk_window_set_title(GTK_WINDOW(DialogueMessage)," Warning ");
	gtk_window_set_transient_for(GTK_WINDOW(DialogueMessage),GTK_WINDOW(Fenetre));
	gtk_window_set_modal (GTK_WINDOW (DialogueMessage), TRUE);


	g_signal_connect(G_OBJECT(DialogueMessage), "delete_event", (GtkSignalFunc)gtk_widget_destroy, NULL);
    
	frame = gtk_frame_new (NULL);
	gtk_frame_set_shadow_type( GTK_FRAME(frame),GTK_SHADOW_ETCHED_OUT);
	gtk_widget_ref (frame);
	g_object_set_data_full (G_OBJECT (DialogueMessage), "frame", frame,(GtkDestroyNotify) gtk_widget_unref);
	gtk_container_set_border_width (GTK_CONTAINER (frame), 10);
	gtk_box_pack_start_defaults( GTK_BOX(GTK_DIALOG(DialogueMessage)->vbox), frame);
	gtk_widget_show (frame);
	vboxframe = create_vbox(frame);
	gtk_widget_realize(DialogueMessage);
	Label = create_label_with_pixmap(DialogueMessage,message,"Question");  
	gtk_box_pack_start_defaults(GTK_BOX(vboxframe), Label);
    
	gtk_widget_realize(DialogueMessage);

	Bouton = create_button(DialogueMessage,"No");
	gtk_box_pack_start_defaults(GTK_BOX(GTK_DIALOG(DialogueMessage)->action_area),Bouton);
	g_signal_connect_swapped(G_OBJECT(Bouton), "clicked", (GtkSignalFunc)gtk_widget_destroy, GTK_OBJECT(DialogueMessage));
	GTK_WIDGET_SET_FLAGS(Bouton, GTK_CAN_DEFAULT);
	gtk_widget_grab_default(Bouton);

	Bouton = create_button(DialogueMessage,"Yes");
	gtk_box_pack_start_defaults( GTK_BOX(GTK_DIALOG(DialogueMessage)->action_area), Bouton);
	GTK_WIDGET_SET_FLAGS(Bouton, GTK_CAN_DEFAULT);
	g_signal_connect(G_OBJECT(Bouton), "clicked", (GtkSignalFunc)func,data);
	g_signal_connect_swapped(G_OBJECT(Bouton), "clicked", (GtkSignalFunc)gtk_widget_destroy, GTK_OBJECT(DialogueMessage));


	gtk_widget_show_all(DialogueMessage);
	return DialogueMessage;
}
/**********************************************************************************/
void open_file(GtkWidget *widget, gchar *data)
{
	gchar *t;
 	if(imodif == DATA_MOD_YES)
        {
		t = g_strdup_printf("\nThe \"%s\" file has been modified.\n\n",get_name_file(fileopen.datafile));
		t = g_strdup_printf(" %sIf you continue, you lose what you have changed.\n\n",t);
		t = g_strdup_printf(" %sYou want to continue?\n",t);
		Continue_YesNo(charge_doc, NULL,t);
		g_free(t);
        }
        else
        {
		charge_doc(NULL, NULL);
 		data_modify(FALSE);
 	}
}
/**********************************************************************************/
void new_molcas(GtkWidget *widget, gchar *data)
{
	gchar t[BSIZE];
	gchar t1[BSIZE];
 	if(imodif == DATA_MOD_YES)
        {
		sprintf(t,"\nThe \"%s\" file has been modified.\n\n",get_name_file(fileopen.datafile));
		sprintf(t1,"%s",t);
		sprintf(t," %sIf you continue, you lose what you have changed.\n\n",t1);
		sprintf(t1,"%s",t);
		sprintf(t," %sYou want to continue?\n",t1);
		Continue_YesNo(new_doc_molcas, NULL,t);
        }
        else
        {
		new_doc_molcas(NULL, NULL);
		iprogram = PROG_IS_MOLCAS;
		fileopen.command=g_strdup(NameCommandMolcas);
 	}
}
/**********************************************************************************/
void new_molpro(GtkWidget *widget, gchar *data)
{
	gchar *t;
 	if(imodif == DATA_MOD_YES)
        {
		t = g_strdup_printf("\nThe \"%s\" file has been modified.\n\n",get_name_file(fileopen.datafile));
		t = g_strdup_printf(" %sIf you continue, you lose what you have changed.\n\n",t);
		t = g_strdup_printf(" %sYou want to continue?\n",t);
		Continue_YesNo(new_doc_molpro, NULL,t);
		g_free(t);
        }
        else
        {
		new_doc_molpro(NULL, NULL);
		iprogram = PROG_IS_MOLPRO;
		fileopen.command=g_strdup(NameCommandMolpro);
 	}
}
/**********************************************************************************/
void new_mpqc(GtkWidget *widget, gchar *data)
{
	gchar *t;
 	if(imodif == DATA_MOD_YES)
        {
		t = g_strdup_printf("\nThe \"%s\" file has been modified.\n\n",get_name_file(fileopen.datafile));
		t = g_strdup_printf(" %sIf you continue, you lose what you have changed.\n\n",t);
		t = g_strdup_printf(" %sYou want to continue?\n",t);
		Continue_YesNo(new_doc_mpqc, NULL,t);
		g_free(t);
        }
        else
        {
		new_doc_mpqc(NULL, NULL);
		iprogram = PROG_IS_MPQC;
		fileopen.command=g_strdup(NameCommandMPQC);
 	}
}
/**********************************************************************************/
void new_pcgamess(GtkWidget *widget, gchar *data)
{
	gchar *t;
 	if(imodif == DATA_MOD_YES)
        {
		t = g_strdup_printf("\nThe \"%s\" file has been modified.\n\n",get_name_file(fileopen.datafile));
		t = g_strdup_printf(" %sIf you continue, you lose what you have changed.\n\n",t);
		t = g_strdup_printf(" %sYou want to continue?\n",t);
		Continue_YesNo(new_doc_pcgamess, NULL,t);
		g_free(t);
        }
        else
        {
		new_doc_pcgamess(NULL, NULL);
		iprogram = PROG_IS_PCGAMESS;
		fileopen.command=g_strdup(NameCommandPCGamess);
 	}
}
/**********************************************************************************/
void new_gamess(GtkWidget *widget, gchar *data)
{
	gchar *t;
 	if(imodif == DATA_MOD_YES)
        {
		t = g_strdup_printf("\nThe \"%s\" file has been modified.\n\n",get_name_file(fileopen.datafile));
		t = g_strdup_printf(" %sIf you continue, you lose what you have changed.\n\n",t);
		t = g_strdup_printf(" %sYou want to continue?\n",t);
		Continue_YesNo(new_doc_gamess, NULL,t);
		g_free(t);
        }
        else
        {
		new_doc_gamess(NULL, NULL);
		iprogram = PROG_IS_GAMESS;
		fileopen.command=g_strdup(NameCommandGamess);
 	}
}
/**********************************************************************************/
void new_gauss(GtkWidget *widget, gchar *data)
{
	gchar *t;
 	if(imodif == DATA_MOD_YES)
        {
		t = g_strdup_printf("\nThe \"%s\" file has been modified.\n\n",get_name_file(fileopen.datafile));
		t = g_strdup_printf(" %sIf you continue, you lose what you have changed.\n\n",t);
		t = g_strdup_printf(" %sYou want to continue?\n",t);
		Continue_YesNo(new_doc_gauss, NULL,t);
		g_free(t);
        }
        else
        {
		new_doc_gauss(NULL, NULL);
		iprogram = PROG_IS_GAUSS;
		fileopen.command=g_strdup(NameCommandGaussian);
 	}
}
/**********************************************************************************/
void new_qchem(GtkWidget *widget, gchar *data)
{
	gchar *t;
 	if(imodif == DATA_MOD_YES)
        {
		t = g_strdup_printf("\nThe \"%s\" file has been modified.\n\n",get_name_file(fileopen.datafile));
		t = g_strdup_printf(" %sIf you continue, you lose what you have changed.\n\n",t);
		t = g_strdup_printf(" %sYou want to continue?\n",t);
		Continue_YesNo(new_doc_qchem, NULL,t);
		g_free(t);
        }
        else
        {
		new_doc_qchem(NULL, NULL);
		iprogram = PROG_IS_QCHEM;
		fileopen.command=g_strdup(NameCommandGamess);
 	}
}
/**********************************************************************************/
 void new_other(GtkWidget *widget, gchar *data)
{
	gchar *t;
 	if(imodif == DATA_MOD_YES)
        {
		t = g_strdup_printf("\nThe \"%s\" file has been modified.\n\n",get_name_file(fileopen.datafile));
		t = g_strdup_printf(" %sIf you continue, you lose what you have changed.\n\n",t);
		t = g_strdup_printf(" %sYou want to continue?\n",t);
		Continue_YesNo(new_doc_other, NULL,t);
		g_free(t);
        }
        else
        {
		new_doc_other(NULL, NULL);
		iprogram = PROG_IS_OTHER;
 	}
}
/**********************************************************************************/
GtkWidget *create_hbox_browser(GtkWidget* Wins,GtkWidget* vbox,gchar *tlabel,gchar *deffile,gchar** patterns)
{
  GtkWidget *Entry = NULL;
  GtkWidget *hbox ;
  GtkWidget *button;
  GtkWidget* Label;

  hbox = create_hbox_false(vbox);
  /* The label */
  Label = gtk_label_new(tlabel); 
  gtk_widget_set_size_request(GTK_WIDGET(Label),(gint)(ScreenHeight*0.06),-1);
  gtk_box_pack_start(GTK_BOX(hbox), Label,FALSE,FALSE,2);

  /* The Entry */
  Entry = gtk_entry_new();
  gtk_box_pack_start(GTK_BOX(hbox), Entry,TRUE,TRUE,2);
  if(deffile)
  {
  	PangoFontDescription *font_desc = pango_font_description_from_string (FontsStyleOther.fontname);
	GdkFont* font = NULL;
  	gint len = strlen(deffile)*8;
	if(font_desc) font = gdk_font_from_description (font_desc);
	if(font)
	{
  	 	len = strlen(deffile)*(gint)(gdk_string_width (font,"D") );
		gdk_font_unref (font);
	}

  	gtk_widget_set_size_request(GTK_WIDGET(Entry),len,32);
	gtk_entry_set_text(GTK_ENTRY(Entry),deffile);
  }
  else
  	gtk_widget_set_size_request(GTK_WIDGET(Entry),350,32);

  /* The Button */
  button = create_button_pixmap(Wins,open_xpm,NULL);
  g_signal_connect_swapped(G_OBJECT (button), "clicked",GTK_SIGNAL_FUNC(set_entry_selected_file),GTK_OBJECT(hbox));
  gtk_box_pack_start (GTK_BOX (hbox), button, FALSE, FALSE, 1);
  g_object_set_data(G_OBJECT (hbox), "Entry", Entry);
  g_object_set_data(G_OBJECT (hbox), "Button", button);
  g_object_set_data(G_OBJECT (hbox), "Label", Label);
  g_object_set_data(G_OBJECT (hbox), "Window", Wins);
  g_object_set_data(G_OBJECT (hbox), "Patterns",patterns);
  gtk_widget_show_all(hbox);
  return hbox;
}
/********************************************************************************/
void set_default_styles()
{
	/*
	gchar *font = NULL;
	gchar *fontLabel = NULL;
	gchar *rc_string = NULL;

	if(FontsStyleOther.fontname) font = g_strdup_printf("font =\"%s\"",FontsStyleOther.fontname);
	else font = g_strdup(" ");

	if(FontsStyleLabel.fontname) fontLabel = g_strdup_printf("font =\"%s\"",FontsStyleLabel.fontname);
	else fontLabel = g_strdup(" ");
	
	rc_string=g_strdup_printf(
	 "style \"allwid\""
     "{"
		"%s"
     "}"
	 "style \"labels\""
     "{"
		"%s"
     "}"
	 "style \"frames\""
     "{"
		"fg[NORMAL] = { 1., 0., 0. }"
		"bg[NORMAL] = { 0.5, 0.5, 0.5 }"
		"%s"
     "}"
	 "style \"buttons\""
     "{"
       "fg[PRELIGHT] = { 0, 0.1, 1.0 }\n"
       "bg[PRELIGHT] = { 0.4, 0.4, 0.4 }\n"
       "bg[ACTIVE] = { 1.0, 0, 0 }\n"
       "fg[ACTIVE] = { 0, 1.0, 0 }\n"
       "bg[NORMAL] = { 0.65, 0.65, 0.65 }\n"
       "fg[NORMAL] = { 0.0, 0.0, 1.0 }\n"
       "bg[INSENSITIVE] = { 1.0, 1.0, 1.0 }\n"
       "fg[INSENSITIVE] = { 1.0, 0, 1.0 }\n"
	   "%s"
     "}\n"
	 "style \"toggle_button\" = \"button\"\n"
     "{\n"
       "fg[NORMAL] = { 0.0, 0.0, 0.0 }\n"
       "fg[ACTIVE] = { 0.0, 0.0, 1.0 }\n"
       "%s"
     "}\n"

       "widget_class \"*Gtk*\" style \"allwid\"\n"
     "widget_class \"*GtkButton*\" style \"buttons\"\n"
     "widget_class \"*GtkCheckButton*\" style \"toggle_button\"\n"
     "widget_class \"*GtkRadioButton*\" style \"toggle_button\"\n"
     "widget_class \"*GtkToggleButton*\" style \"toggle_button\"\n"
	 "widget_class \"*GtkFrame\" style \"frames\"\n"
	 "widget_class \"*GtkLabel\" style \"labels\"\n"
	 ,font,fontLabel,font,font,font);

	gtk_rc_parse_string(rc_string);

	g_free(rc_string);
	g_free(font);
	g_free(fontLabel);
	*/
	gtk_rc_parse_string("gtk-icon-sizes = \"gtk-menu=13,13:gtk-small-toolbar=16,16:gtk-large-toolbar=24,24\"gtk-toolbar-icon-size = small-toolbar");
}
/********************************************************************************/
GtkWidget* create_text_widget(GtkWidget* box,gchar *title,GtkWidget **frame)
{
  GtkWidget *scrolledwindow;
  GtkWidget *Frame;
  GtkWidget *Text;

  Frame = gtk_frame_new(title);
  gtk_container_set_border_width(GTK_CONTAINER(Frame), 2);
  gtk_container_add (GTK_CONTAINER (box), Frame);

  scrolledwindow = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_show (scrolledwindow);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow ),
                   GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC); 

  gtk_container_add (GTK_CONTAINER (Frame), scrolledwindow);
  Text = gabedit_text_new ();
  set_tab_size (Text, 8);
  /*
  gabedit_text_set_word_wrap(GABEDIT_TEXT(Text), TRUE);  
  gabedit_text_set_line_wrap(GABEDIT_TEXT(Text), TRUE);
  */
  
  gtk_widget_show (Text);
  gtk_container_add (GTK_CONTAINER (scrolledwindow), Text);
  gabedit_text_set_editable (GABEDIT_TEXT (Text), FALSE); 
  *frame = Frame;

  return Text;
}
/*********************************************************************/
void draw_density_orbitals_gamess_or_gauss_or_molcas_or_molpro(GtkWidget *wid,gpointer data)
{
  if( iprogram == PROG_IS_GAMESS)
  {
 	gchar** FileName = g_malloc(2*sizeof(gchar*));
 	FileName[0] = NULL;
	FileName[1] = g_strdup_printf("%s%s%s",fileopen.localdir,G_DIR_SEPARATOR_S,fileopen.logfile);
 	view_orb(Fenetre,2,FileName);
	g_free(FileName[1] );
	g_free(FileName);
  }
  else
  if( iprogram == PROG_IS_PCGAMESS)
  {
 	gchar** FileName = g_malloc(2*sizeof(gchar*));
 	FileName[0] = NULL;
	FileName[1] = g_strdup_printf("%s%s%s",fileopen.localdir,G_DIR_SEPARATOR_S,fileopen.logfile);
 	view_orb(Fenetre,2,FileName);
	g_free(FileName[1] );
	g_free(FileName);
  }
  else
  if( iprogram == PROG_IS_GAUSS)
  {
 	gchar** FileName = g_malloc(2*sizeof(gchar*));
 	FileName[0] = NULL;
	FileName[1] = g_strdup_printf("%s%s%s",fileopen.localdir,G_DIR_SEPARATOR_S,fileopen.logfile);
 	view_orb(Fenetre,2,FileName);
	g_free(FileName[1] );
	g_free(FileName);
  }
  else
  if( iprogram == PROG_IS_MOLCAS)
  {
 	gchar** FileName = g_malloc(2*sizeof(gchar*));
 	FileName[0] = NULL;
	FileName[1] = g_strdup_printf("%s%s%s.scf.molden",fileopen.localdir,G_DIR_SEPARATOR_S,fileopen.projectname);
 	view_orb(Fenetre,2,FileName);
	g_free(FileName[1] );
	g_free(FileName);
  }
  else
  if( iprogram == PROG_IS_MOLPRO)
  {
 	gchar** FileName = g_malloc(2*sizeof(gchar*));
 	FileName[0] = NULL;
	FileName[1] = g_strdup_printf("%s%s%s",fileopen.localdir,G_DIR_SEPARATOR_S,fileopen.outputfile);
 	view_orb(Fenetre,2,FileName);
	g_free(FileName[1] );
	g_free(FileName);
  }
  else
  if( iprogram == PROG_IS_QCHEM)
  {
 	gchar** FileName = g_malloc(2*sizeof(gchar*));
 	FileName[0] = NULL;
	FileName[1] = g_strdup_printf("%s%s%s",fileopen.localdir,G_DIR_SEPARATOR_S,fileopen.outputfile);
 	view_orb(Fenetre,2,FileName);
	g_free(FileName[1] );
	g_free(FileName);
  }
  else
 	view_orb(Fenetre,0,NULL);
}
/*********************************************************************/
void set_last_directory(G_CONST_RETURN gchar* FileName)
{
	gchar* temp = get_suffix_name_file(FileName);
	gchar* localdir = get_name_dir(temp);
	if(!localdir) return;
	if(lastdirectory) g_free(lastdirectory);
	lastdirectory = g_strdup(localdir);
	if(temp) g_free(temp);
	if(localdir) g_free(localdir);
}
/*********************************************************************/
gchar* get_last_directory()
{
	return lastdirectory;
}
/******************************************************************/
static void set_dipole_color(GtkColorSelection *Sel,gpointer *d)
{
	GdkColor* color;
	color = g_object_get_data(G_OBJECT (Sel), "Color");
	gtk_color_selection_get_current_color(Sel, color);
}
/******************************************************************/
static void set_dipole_button_color(GtkObject *button,gpointer *data)
{
	GtkStyle *style = g_object_get_data(G_OBJECT (button), "Style");
	GdkColor* color = g_object_get_data(G_OBJECT (button), "Color");
	GtkWidget *OldButton  = g_object_get_data(G_OBJECT (button), "Button");
  	style =  gtk_style_copy(style); 
  	style->bg[0].red=color->red;
  	style->bg[0].green=color->green;
  	style->bg[0].blue= color->blue;
	gtk_widget_set_style(OldButton, style);
}
/******************************************************************/
static void open_color_dlg_dipole(GtkWidget *button,gpointer data)
{

	GtkColorSelectionDialog *colorDlg;
  	GtkStyle* style = g_object_get_data(G_OBJECT (button), "Style");
  	GtkWidget *win = g_object_get_data(G_OBJECT (button), "Win");
	GdkColor* color = g_object_get_data(G_OBJECT (button), "Color");;

	colorDlg = (GtkColorSelectionDialog *)gtk_color_selection_dialog_new("Set Dipole Color");
	gtk_color_selection_set_current_color (GTK_COLOR_SELECTION (colorDlg->colorsel), color);
	gtk_color_selection_set_current_color (GTK_COLOR_SELECTION (colorDlg->colorsel), color);
	gtk_window_set_transient_for(GTK_WINDOW(colorDlg),GTK_WINDOW(win));
        gtk_window_set_position(GTK_WINDOW(colorDlg),GTK_WIN_POS_CENTER);
  	gtk_window_set_modal (GTK_WINDOW (colorDlg), TRUE);
 	g_signal_connect(G_OBJECT(colorDlg), "delete_event",(GtkSignalFunc)destroy_button_windows,NULL);
  	g_signal_connect(G_OBJECT(colorDlg), "delete_event",GTK_SIGNAL_FUNC(gtk_widget_destroy),NULL);

  	g_object_set_data(G_OBJECT (colorDlg->colorsel), "Color", color);
  	gtk_widget_hide(colorDlg->help_button);
	g_signal_connect_swapped(G_OBJECT(colorDlg->ok_button),"clicked", (GtkSignalFunc)set_dipole_color,GTK_OBJECT(colorDlg->colorsel));

  	g_object_set_data(G_OBJECT (colorDlg->ok_button), "Color", color);
  	g_object_set_data(G_OBJECT (colorDlg->ok_button), "Button", button);
  	g_object_set_data(G_OBJECT (colorDlg->ok_button), "Style", style);
	g_signal_connect(G_OBJECT(colorDlg->ok_button),"clicked", (GtkSignalFunc)set_dipole_button_color,NULL);

  	g_signal_connect_swapped(G_OBJECT(colorDlg->ok_button), "clicked", (GtkSignalFunc)destroy_button_windows,GTK_OBJECT(colorDlg));
	g_signal_connect_swapped(G_OBJECT(colorDlg->ok_button),"clicked", (GtkSignalFunc)gtk_widget_destroy,GTK_OBJECT(colorDlg));

  	g_signal_connect_swapped(G_OBJECT(colorDlg->cancel_button), "clicked", (GtkSignalFunc)destroy_button_windows,GTK_OBJECT(colorDlg));
	g_signal_connect_swapped(G_OBJECT(colorDlg->cancel_button),"clicked", (GtkSignalFunc)gtk_widget_destroy,GTK_OBJECT(colorDlg));

  	add_button_windows(" Set Color ",GTK_WIDGET(colorDlg));
	gtk_widget_show(GTK_WIDGET(colorDlg));

}
/*********************************************************************/
GtkWidget* set_dipole_dialog ()
{
  GtkWidget *fp;
  GtkWidget *frame;
  GtkWidget *vboxall;
  GtkWidget *vboxframe;
  GtkWidget *hbox;
  GtkWidget *button;
  GtkWidget *label;
  GtkStyle *style;
  static GtkWidget* entrys[5];
  static GdkColor color;
  gchar* tlabel[5]={"Factor : ","X : ","Y : ","Z : ","Radius : "};
  gint i;

  /* principal Window */
  fp = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  gtk_window_set_modal(GTK_WINDOW(fp),TRUE);
  gtk_window_set_title(GTK_WINDOW(fp),"Set Dipole");
  gtk_container_set_border_width (GTK_CONTAINER (fp), 5);

  gtk_window_set_position(GTK_WINDOW(fp),GTK_WIN_POS_CENTER);
  gtk_window_set_modal (GTK_WINDOW (fp), TRUE);

  g_signal_connect(G_OBJECT(fp),"delete_event",(GtkSignalFunc)gtk_widget_destroy,NULL);

  vboxall = create_vbox(fp);
  frame = gtk_frame_new ("Set Dipole(Debye)");
  gtk_container_set_border_width (GTK_CONTAINER (frame), 5);
  gtk_container_add (GTK_CONTAINER (vboxall), frame);
  gtk_widget_show (frame);

  vboxframe = create_vbox(frame);
  for(i=0;i<5;i++)
  {
	hbox = create_hbox(vboxframe);
	label = gtk_label_new (tlabel[i]);
	gtk_widget_show (label);
	gtk_box_pack_start (GTK_BOX (hbox), label, TRUE, FALSE, 0);

	entrys[i] = gtk_entry_new ();
	gtk_widget_show (entrys[i]);
	gtk_box_pack_start (GTK_BOX (hbox), entrys[i], FALSE, TRUE, 0);

	if(i!=0)
	{
		if(i==4)
		{
			gchar* t = g_strdup_printf("%f",Dipole.radius*AUTODEB);
			gtk_entry_set_text(GTK_ENTRY(entrys[i]),t);
			g_free(t);
		}
		else
		{
			gchar* t = g_strdup_printf("%f",Dipole.Value[i-1]*AUTODEB);
			gtk_entry_set_text(GTK_ENTRY(entrys[i]),t);
			g_free(t);
		}
	}
	else
	{
		if(i==0)
			gtk_entry_set_text(GTK_ENTRY(entrys[i]),"1.0");
		else
			gtk_entry_set_text(GTK_ENTRY(entrys[i]),"0.0");
	}
  }
  hbox = gtk_hbox_new (TRUE, 0);
  gtk_widget_show (hbox);
  gtk_box_pack_start (GTK_BOX (vboxframe), hbox, FALSE, FALSE, 1);

  label = gtk_label_new ("Color : ");
  gtk_widget_show (label);
  gtk_box_pack_start (GTK_BOX (hbox), label, TRUE, FALSE, 0);
  style = gtk_widget_get_style(fp);
  button = gtk_button_new_with_label(" ");
  style =  gtk_style_copy(style); 
  style->bg[0].red=Dipole.color[0];
  style->bg[0].green=Dipole.color[1];
  style->bg[0].blue=Dipole.color[2];

  color.red =style->bg[0].red;
  color.green =style->bg[0].green;
  color.blue =style->bg[0].blue;
  gtk_widget_set_style(button, style );
  gtk_box_pack_start (GTK_BOX (hbox), button, FALSE, TRUE, 1);
  gtk_widget_show (button);
  g_object_set_data(G_OBJECT (button), "Style", style);
  g_object_set_data(G_OBJECT (button), "Win", fp);
  g_object_set_data(G_OBJECT (button), "Color", &color);
  g_signal_connect(G_OBJECT(button), "clicked", (GtkSignalFunc)open_color_dlg_dipole, NULL);

  hbox = create_hbox(vboxall);

  button = create_button(Fenetre,"OK");
  gtk_box_pack_start (GTK_BOX( hbox), button, TRUE, TRUE, 3);
  g_object_set_data(G_OBJECT (button), "Color", &color);
  g_signal_connect(G_OBJECT(button), "clicked",GTK_SIGNAL_FUNC(set_dipole),(gpointer)entrys);
  g_signal_connect_swapped(G_OBJECT(button), "clicked",GTK_SIGNAL_FUNC(gtk_widget_destroy),GTK_OBJECT(fp));
  gtk_widget_show (button);

  button = create_button(Fenetre,"Apply");
  gtk_box_pack_start (GTK_BOX( hbox), button, TRUE, TRUE, 3);
  g_object_set_data(G_OBJECT (button), "Color", &color);
  g_signal_connect(G_OBJECT(button), "clicked",GTK_SIGNAL_FUNC(set_dipole),(gpointer)entrys);
  gtk_widget_show (button);

  button = create_button(Fenetre,"Close");
  gtk_box_pack_start (GTK_BOX( hbox), button, TRUE, TRUE, 3);
  g_signal_connect_swapped(G_OBJECT(button), "clicked",GTK_SIGNAL_FUNC(gtk_widget_destroy),GTK_OBJECT(fp));

  gtk_widget_show (button);
   
  gtk_widget_show_all(fp);
  return fp;
}
/*************************************************************************************/
void fit_windows_position(GtkWidget* parent, GtkWidget* child)
{
	gint wChild = 0, hChild = 0;
	gint wParent=0, hParent=0;
	gdk_window_get_size(parent->window,&wParent,&hParent);
	gtk_window_move(GTK_WINDOW(parent),0,0);
	gdk_window_get_size(child->window,&wChild,&hChild);
	if(wParent+wChild+10<ScreenWidth) gtk_window_move(GTK_WINDOW(child),wParent+10,0);
}
