/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * 
 *  Gabber 2
 *  Based on Gabber, Copyright (c) 1999-2002 Dave Smith & Julian Missig
 *  Copyright (c) 2002 Julian Missig
 */
#ifndef INCL_GABBER_EVENT_H
#define INCL_GABBER_EVENT_H

#include <string>

namespace Gabber
{

class Event
{
public:
    Event(const std::string& desc, const std::string& img_fn) : 
        _filename(img_fn), _desc(desc), _xpm(NULL)
    { }
    ~Event()
    {
        if (_xpm)
            delete xpm;
    }

    std::string get_description() const
    { return _desc; }

    Gtk::Image* get_image() const
    { 
        if (_xpm == NULL)
            _xpm = new Gtk::Image(_filename);
        return _xpm; 
    }
    
    SigC::Signal0<void> doShow;
    SigC::Signal0<void> evtEnd;

private:
    std::string _filename;
    std::string _desc;
    Gtk::Image* _xpm;
};

}; // namespace Gabber

#endif // INCL_GABBER_EVENT_H
