#!/usr/bin/env python
# -*- coding: utf-8 -*-
"""version.py """

# Copyright (C) 2009, 2010, 2011, 2012, 2013 Federico Brega, Pierluigi Villani

# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 3
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
from __future__ import print_function
import urllib2
import threading

# Version of this software
VERSION = '1.6.0'

# This url is used to fetch the latest version number directely from 
# the website
LAST_VERSION_URL = 'http://cyclograph.sourceforge.net/latestcg'

# This parameter enables or disables the check if the user is running
# the latest version.
# It is intended for environments where the installable software is controlled
# as are distribution.
VERSION_CHECK_ENABLED = True

class LastVersionQuery(threading.Thread):
    lastversion = ''
    def query(self):
        if not VERSION_CHECK_ENABLED:
            return
        try:
            page = urllib2.urlopen(LAST_VERSION_URL)
            self.lastversion = page.read().strip()
            page.close()
        except urllib2.URLError:
            self.lastversion = ''
    def islast(self):
        if not self.lastversion:
            return True
        return VERSION >= self.lastversion
    def run(self):
        self.query()


if __name__ == "__main__":
    print(VERSION)

