/*
	CVSNT Helper application API
    Copyright (C) 2004-5 Tony Hoyle and March-Hare Software Ltd

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License version 2.1 as published by the Free Software Foundation.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
/* Win32 specific */
#include <cvsapi.h>
#include "../GlobalSettings.h"

namespace
{
	static char cvs_config_dir[_MAX_PATH] = {0};
	static char cvs_library_dir[_MAX_PATH] = {0};
	static char cvs_command[_MAX_PATH] = {0};

	const char *GetCvsDir(char *dir, int size)
	{
		if(!*dir) /* Only do this once */
		{
			if(CGlobalSettings::GetGlobalValue("cvsnt","PServer","LibraryPath",dir,size) &&
			   CGlobalSettings::GetUserValue("cvsnt","PServer","LibraryPath",dir,size) &&
			   CGlobalSettings::GetGlobalValue("cvsnt","PServer","InstallPath",dir,size) &&
			   CGlobalSettings::GetUserValue("cvsnt","PServer","InstallPath",dir,size))
			{
				if (GetModuleFileNameA(NULL, dir, size))
				{
					char *p;

					p = strrchr(dir, '\\');
					if(p)
						*p = '\0';
					else
						dir[0] = '\0';
				}
			}
			GetShortPathNameA(dir,dir,size);
		}
		return dir;
	}

	int GetCachedPassword(const char *key, char *buffer, int buffer_len)
	{
		CSocketIO sock;

		/* No song and dance.. if there's no server listening, do nothing */
		if(!sock.create("127.0.0.1","32401",false))
			return -1;
		if(sock.bind()) // If we can bind, there's no server.  bind is quicker than connect...
		{
			sock.close();
			return -1; // Not listening
		}
		else
		{
			if(!sock.create("127.0.0.1","32401",false))
				return -1;
			if(!sock.connect())
				return -1;
			if(sock.send(key,(int)strlen(key))<=0)
			{
				CServerIo::trace(1,"Error sending to password agent");
				return -1;
			}
			if(sock.recv(buffer,buffer_len)<=0)
			{
				CServerIo::trace(1,"Error receiving from password agent");
				return -1;
			}
			if(buffer[0]==-1) /* No passwd */
			{
				CServerIo::trace(2,"No password stored in passwd agent");
				return -1;
			}
			sock.close();
		}
		return 0;
	}
	int SetCachedPassword(const char *key, const char *buffer)
	{
		CSocketIO sock;

		/* No song and dance.. if there's no server listening, do nothing */
		if(!sock.create("127.0.0.1","32401",false))
			return -1;
		if(sock.bind()) // If we can bind, there's no server.  bind is quicker than connect...
		{
			sock.close();
			return -1; // Not listening
		}
		else
		{
			if(!buffer)
			{
				if(!sock.create("127.0.0.1","32401",false))
					return -1;
				if(!sock.connect())
					return -1;
				cvs::string tmp;
				tmp="*";
				tmp+=key;
				if(sock.send(tmp.c_str(),(int)tmp.size())<=0)
				{
					CServerIo::trace(1,"Error sending to password agent");
					return -1;
				}
				sock.close();
			}
		}
		return 0;
	}
};

int CGlobalSettings::GetUserValue(const char *product, const char *key, const char *value, char *buffer, int buffer_len)
{
	/* Special case for the 'cvspass' key */
	if((!product || !strcmp(product,"cvsnt")) && key && !strcmp(key,"cvspass") && !GetCachedPassword(value,buffer,buffer_len))
		return 0;

	return _GetUserValue(product,key,value,buffer,buffer_len);
}

int CGlobalSettings::GetUserValue(const char *product, const char *key, const char *value, int& ival)
{
	char tmp[32];
	if(_GetUserValue(product,key,value,tmp,sizeof(tmp)))
		return -1;
	ival = atoi(tmp);
	return 0;
}

int CGlobalSettings::GetUserValue(const char *product, const char *key, const char *value, cvs::string& sval)
{
	char tmp[512];
	if(_GetUserValue(product,key,value,tmp,sizeof(tmp)))
		return -1;
	sval = tmp;
	return 0;
}

int CGlobalSettings::_GetUserValue(const char *product, const char *key, const char *value, char *buffer, int buffer_len)
{
	HKEY hKey,hSubKey;
	DWORD dwType,dwLen,dw;
	cvs::string regkey;

	if(!product || !strcmp(product,"cvsnt"))
		regkey="Software\\Cvsnt";
	else
		cvs::sprintf(regkey,64,"Software\\March Hare Software Ltd\\%s",product);

	if(RegOpenKeyExA(HKEY_CURRENT_USER,regkey.c_str(),0,KEY_READ,&hKey) &&
	   RegCreateKeyExA(HKEY_CURRENT_USER,regkey.c_str(),0,NULL,0,KEY_READ,NULL,&hKey,NULL))
	{
		return -1; // Couldn't open or create key
	}

	if(key)
	{
		if(RegOpenKeyExA(hKey,key,0,KEY_READ,&hSubKey) &&
		   RegCreateKeyExA(hKey,key,0,NULL,0,KEY_READ,NULL,&hSubKey,NULL))
		{
			RegCloseKey(hKey);
			return -1; // Couldn't open or create key
		}
		RegCloseKey(hKey);
		hKey=hSubKey;
	}

	dwType=REG_SZ;
	dwLen=buffer_len;
	if((dw=RegQueryValueExA(hKey,value,NULL,&dwType,(LPBYTE)buffer,&dwLen))!=0)
	{
		RegCloseKey(hKey);
		return -1;
	}
	RegCloseKey(hKey);
	if(dwType==REG_DWORD && buffer)
		sprintf(buffer,"%u",*(DWORD*)buffer);

	return 0;
}

int CGlobalSettings::SetUserValue(const char *product, const char *key, const char *value, const char *buffer)
{
	if((!product || !strcmp(product,"cvsnt")) && key && !strcmp(key,"cvspass") && !SetCachedPassword(value,buffer) && buffer)
		return 0;
	return _SetUserValue(product,key,value,buffer);
}

int CGlobalSettings::_SetUserValue(const char *product, const char *key, const char *value, const char *buffer)
{
	HKEY hKey,hSubKey;
	DWORD dwLen;
	cvs::string regkey;

	if(!product || !strcmp(product,"cvsnt"))
		regkey="Software\\Cvsnt";
	else
		cvs::sprintf(regkey,64,"Software\\March Hare Software Ltd\\%s",product);

	if(RegOpenKeyExA(HKEY_CURRENT_USER,regkey.c_str(),0,KEY_READ|KEY_WRITE,&hKey) &&
	   RegCreateKeyExA(HKEY_CURRENT_USER,regkey.c_str(),0,NULL,0,KEY_READ|KEY_WRITE,NULL,&hKey,NULL))
	{
		return -1; // Couldn't open or create key
	}

	if(key)
	{
		if(RegOpenKeyExA(hKey,key,0,KEY_WRITE,&hSubKey) &&
		   RegCreateKeyExA(hKey,key,0,NULL,0,KEY_WRITE,NULL,&hSubKey,NULL))
		{
			RegCloseKey(hKey);
			return -1; // Couldn't open or create key
		}
		RegCloseKey(hKey);
		hKey=hSubKey;
	}

	if(!buffer)
	{
		RegDeleteValueA(hKey,value);
	}
	else
	{
		dwLen=(DWORD)strlen(buffer);
		if(RegSetValueExA(hKey,value,0,REG_SZ,(LPBYTE)buffer,dwLen+1))
		{
			RegCloseKey(hKey);
			return -1;
		}
	}
	RegCloseKey(hKey);

	return 0;
}

int CGlobalSettings::SetUserValue(const char *product, const char *key, const char *value, int ival)
{
	HKEY hKey,hSubKey;
	DWORD dwLen;
	cvs::string regkey;

	if(!product || !strcmp(product,"cvsnt"))
		regkey="Software\\Cvsnt";
	else
		cvs::sprintf(regkey,64,"Software\\March Hare Software Ltd\\%s",product);

	if(RegOpenKeyExA(HKEY_CURRENT_USER,regkey.c_str(),0,KEY_READ|KEY_WRITE,&hKey) &&
	   RegCreateKeyExA(HKEY_CURRENT_USER,regkey.c_str(),0,NULL,0,KEY_READ|KEY_WRITE,NULL,&hKey,NULL))
	{
		return -1; // Couldn't open or create key
	}

	if(key)
	{
		if(RegOpenKeyExA(hKey,key,0,KEY_WRITE,&hSubKey) &&
		   RegCreateKeyExA(hKey,key,0,NULL,0,KEY_WRITE,NULL,&hSubKey,NULL))
		{
			RegCloseKey(hKey);
			return -1; // Couldn't open or create key
		}
		RegCloseKey(hKey);
		hKey=hSubKey;
	}

	DWORD dw = ival;
	dwLen=(DWORD)sizeof(DWORD);
	if(RegSetValueExA(hKey,value,0,REG_DWORD,(LPBYTE)&dw,dwLen))
	{
		RegCloseKey(hKey);
		return -1;
	}
	RegCloseKey(hKey);

	return 0;
}

int CGlobalSettings::EnumUserValues(const char *product, const char *key, int value_num, char *value, int value_len, char *buffer, int buffer_len)
{
	HKEY hKey,hSubKey;
	DWORD dwType,dwLen,dwValLen;
	DWORD dwRes;
	cvs::string regkey;

	if(!product || !strcmp(product,"cvsnt"))
		regkey="Software\\Cvsnt";
	else
		cvs::sprintf(regkey,64,"Software\\March Hare Software Ltd\\%s",product);

	if(RegOpenKeyExA(HKEY_CURRENT_USER,regkey.c_str(),0,KEY_READ,&hKey) &&
	   RegCreateKeyExA(HKEY_CURRENT_USER,regkey.c_str(),0,NULL,0,KEY_READ,NULL,&hKey,NULL))
	{
		return -1; // Couldn't open or create key
	}

	if(key)
	{
		if(RegOpenKeyExA(hKey,key,0,KEY_READ,&hSubKey) &&
		   RegCreateKeyExA(hKey,key,0,NULL,0,KEY_READ,NULL,&hSubKey,NULL))
		{
			RegCloseKey(hKey);
			return -1; // Couldn't open or create key
		}
		RegCloseKey(hKey);
		hKey=hSubKey;
	}

	dwLen=buffer_len;
	dwValLen=value_len;
	if((dwRes=RegEnumValueA(hKey,value_num,value,&dwValLen,NULL,&dwType,(LPBYTE)buffer,&dwLen))!=0 && dwRes!=234)
	{
		RegCloseKey(hKey);
		return -1;
	}
	RegCloseKey(hKey);
	if(dwType==REG_DWORD)
	    sprintf(buffer,"%u",*(DWORD*)buffer);

	return 0;
}

int CGlobalSettings::EnumUserKeys(const char *product, const char *key, int value_num, char *value, int value_len)
{
	HKEY hKey,hSubKey;
	DWORD dwValLen;
	DWORD dwRes;
	cvs::string regkey;

	if(!product || !strcmp(product,"cvsnt"))
		regkey="Software\\Cvsnt";
	else
		cvs::sprintf(regkey,64,"Software\\March Hare Software Ltd\\%s",product);

	if(RegOpenKeyExA(HKEY_CURRENT_USER,regkey.c_str(),0,KEY_READ,&hKey) &&
	   RegCreateKeyExA(HKEY_CURRENT_USER,regkey.c_str(),0,NULL,0,KEY_READ,NULL,&hKey,NULL))
	{
		return -1; // Couldn't open or create key
	}

	if(key)
	{
		if(RegOpenKeyExA(hKey,key,0,KEY_READ,&hSubKey) &&
		   RegCreateKeyExA(hKey,key,0,NULL,0,KEY_READ,NULL,&hSubKey,NULL))
		{
			RegCloseKey(hKey);
			return -1; // Couldn't open or create key
		}
		RegCloseKey(hKey);
		hKey=hSubKey;
	}

	dwValLen=value_len;
	if((dwRes=RegEnumKeyExA(hKey,value_num,value,&dwValLen,NULL,NULL,NULL,NULL))!=0)
	{
		RegCloseKey(hKey);
		return -1;
	}
	RegCloseKey(hKey);

	return 0;
}

int CGlobalSettings::DeleteUserKey(const char *product, const char *key)
{
	HKEY hKey;
	cvs::string regkey;

	if(!product || !strcmp(product,"cvsnt"))
		regkey="Software\\Cvsnt";
	else
		cvs::sprintf(regkey,64,"Software\\March Hare Software Ltd\\%s",product);

	if(RegOpenKeyExA(HKEY_CURRENT_USER,regkey.c_str(),0,KEY_READ|KEY_WRITE,&hKey) &&
	   RegCreateKeyExA(HKEY_CURRENT_USER,regkey.c_str(),0,NULL,0,KEY_READ|KEY_WRITE,NULL,&hKey,NULL))
	{
		return -1; // Couldn't open or create key
	}

	RegDeleteKeyA(hKey,key);

	RegCloseKey(hKey);

	return 0;
}


int CGlobalSettings::GetGlobalValue(const char *product, const char *key, const char *value, int& ival)
{
	char tmp[32];
	if(GetGlobalValue(product,key,value,tmp,sizeof(tmp)))
		return -1;
	ival = atoi(tmp);
	return 0;
}

int CGlobalSettings::GetGlobalValue(const char *product, const char *key, const char *value, cvs::string& sval)
{
	char tmp[512];
	if(GetGlobalValue(product,key,value,tmp,sizeof(tmp)))
		return -1;
	sval = tmp;
	return 0;
}

int CGlobalSettings::GetGlobalValue(const char *product, const char *key, const char *value, char *buffer, int buffer_len)
{
	HKEY hKey,hSubKey;
	DWORD dwType,dwLen;
	cvs::string regkey;

	if(!product || !strcmp(product,"cvsnt"))
		regkey="Software\\CVS";
	else
		cvs::sprintf(regkey,64,"Software\\March Hare Software Ltd\\%s",product);

	if(RegOpenKeyExA(HKEY_LOCAL_MACHINE,regkey.c_str(),0,KEY_READ,&hKey) &&
	   RegCreateKeyExA(HKEY_LOCAL_MACHINE,regkey.c_str(),0,NULL,0,KEY_READ,NULL,&hKey,NULL))
	{
		return -1; // Couldn't open or create key
	}

	if(key)
	{
		if(RegOpenKeyExA(hKey,key,0,KEY_READ,&hSubKey) &&
		   RegCreateKeyExA(hKey,key,0,NULL,0,KEY_READ,NULL,&hSubKey,NULL))
		{
			RegCloseKey(hKey);
			return -1; // Couldn't open or create key
		}
		RegCloseKey(hKey);
		hKey=hSubKey;
	}

	dwType=REG_SZ;
	dwLen=buffer_len;
	if(RegQueryValueExA(hKey,value,NULL,&dwType,(LPBYTE)buffer,&dwLen))
	{
		RegCloseKey(hKey);
		return -1;
	}
	RegCloseKey(hKey);
	if(dwType==REG_DWORD && buffer)
	    sprintf(buffer,"%u",*(DWORD*)buffer);

	return 0;
}

int CGlobalSettings::SetGlobalValue(const char *product, const char *key, const char *value, const char *buffer)
{
	HKEY hKey,hSubKey;
	DWORD dwLen;
	cvs::string regkey;

	if(!product || !strcmp(product,"cvsnt"))
		regkey="Software\\CVS";
	else
		cvs::sprintf(regkey,64,"Software\\March Hare Software Ltd\\%s",product);

	if(RegOpenKeyExA(HKEY_LOCAL_MACHINE,regkey.c_str(),0,KEY_READ|KEY_WRITE,&hKey) &&
	   RegCreateKeyExA(HKEY_LOCAL_MACHINE,regkey.c_str(),0,NULL,0,KEY_READ|KEY_WRITE,NULL,&hKey,NULL))
	{
		return -1; // Couldn't open or create key
	}

	if(key)
	{
		if(RegOpenKeyExA(hKey,key,0,KEY_WRITE,&hSubKey) &&
		   RegCreateKeyExA(hKey,key,0,NULL,0,KEY_WRITE,NULL,&hSubKey,NULL))
		{
			RegCloseKey(hKey);
			return -1; // Couldn't open or create key
		}
		RegCloseKey(hKey);
		hKey=hSubKey;
	}

	if(!buffer)
	{
		RegDeleteValueA(hKey,value);
	}
	else
	{
		dwLen=(DWORD)strlen(buffer);
		if(RegSetValueExA(hKey,value,0,REG_SZ,(LPBYTE)buffer,dwLen+1))
		{
			RegCloseKey(hKey);
			return -1;
		}
	}
	RegCloseKey(hKey);

	return 0;
}

int CGlobalSettings::SetGlobalValue(const char *product, const char *key, const char *value, int ival)
{
	HKEY hKey,hSubKey;
	DWORD dwLen;
	cvs::string regkey;

	if(!product || !strcmp(product,"cvsnt"))
		regkey="Software\\CVS";
	else
		cvs::sprintf(regkey,64,"Software\\March Hare Software Ltd\\%s",product);

	if(RegOpenKeyExA(HKEY_LOCAL_MACHINE,regkey.c_str(),0,KEY_READ|KEY_WRITE,&hKey) &&
	   RegCreateKeyExA(HKEY_LOCAL_MACHINE,regkey.c_str(),0,NULL,0,KEY_READ|KEY_WRITE,NULL,&hKey,NULL))
	{
		return -1; // Couldn't open or create key
	}

	if(key)
	{
		if(RegOpenKeyExA(hKey,key,0,KEY_WRITE,&hSubKey) &&
		   RegCreateKeyExA(hKey,key,0,NULL,0,KEY_WRITE,NULL,&hSubKey,NULL))
		{
			RegCloseKey(hKey);
			return -1; // Couldn't open or create key
		}
		RegCloseKey(hKey);
		hKey=hSubKey;
	}

	DWORD dw = (DWORD)ival,err;
	dwLen=(DWORD)sizeof(DWORD);
	err = RegSetValueExA(hKey,value,0,REG_DWORD,(LPBYTE)&dw,dwLen);
	if(err)
	{
		dw = GetLastError();
		RegCloseKey(hKey);
		return -1;
	}

	RegCloseKey(hKey);

	return 0;
}

int CGlobalSettings::EnumGlobalValues(const char *product, const char *key, int value_num, char *value, int value_len, char *buffer, int buffer_len)
{
	HKEY hKey,hSubKey;
	DWORD dwType,dwLen,dwValLen;
	DWORD dwRes;
	cvs::string regkey;

	if(!product || !strcmp(product,"cvsnt"))
		regkey="Software\\CVS";
	else
		cvs::sprintf(regkey,64,"Software\\March Hare Software Ltd\\%s",product);

	if(RegOpenKeyExA(HKEY_LOCAL_MACHINE,regkey.c_str(),0,KEY_READ,&hKey) &&
	   RegCreateKeyExA(HKEY_LOCAL_MACHINE,regkey.c_str(),0,NULL,0,KEY_READ,NULL,&hKey,NULL))
	{
		return -1; // Couldn't open or create key
	}

	if(key)
	{
		if(RegOpenKeyExA(hKey,key,0,KEY_READ,&hSubKey) &&
		   RegCreateKeyExA(hKey,key,0,NULL,0,KEY_READ,NULL,&hSubKey,NULL))
		{
			RegCloseKey(hKey);
			return -1; // Couldn't open or create key
		}
		RegCloseKey(hKey);
		hKey=hSubKey;
	}

	dwLen=buffer_len;
	dwValLen=value_len;
	if((dwRes=RegEnumValueA(hKey,value_num,value,&dwValLen,NULL,&dwType,(LPBYTE)buffer,&dwLen))!=0 && dwRes!=234)
	{
		RegCloseKey(hKey);
		return -1;
	}
	RegCloseKey(hKey);
	if(dwType==REG_DWORD && buffer)
	    sprintf(buffer,"%u",*(DWORD*)buffer);

	return 0;
}

int CGlobalSettings::EnumGlobalKeys(const char *product, const char *key, int value_num, char *value, int value_len)
{
	HKEY hKey,hSubKey;
	DWORD dwValLen;
	DWORD dwRes;
	cvs::string regkey;

	if(!product || !strcmp(product,"cvsnt"))
		regkey="Software\\CVS";
	else
		cvs::sprintf(regkey,64,"Software\\March Hare Software Ltd\\%s",product);

	if(RegOpenKeyExA(HKEY_LOCAL_MACHINE,regkey.c_str(),0,KEY_READ,&hKey) &&
	   RegCreateKeyExA(HKEY_LOCAL_MACHINE,regkey.c_str(),0,NULL,0,KEY_READ,NULL,&hKey,NULL))
	{
		return -1; // Couldn't open or create key
	}

	if(key)
	{
		if(RegOpenKeyExA(hKey,key,0,KEY_READ,&hSubKey) &&
		   RegCreateKeyExA(hKey,key,0,NULL,0,KEY_READ,NULL,&hSubKey,NULL))
		{
			RegCloseKey(hKey);
			return -1; // Couldn't open or create key
		}
		RegCloseKey(hKey);
		hKey=hSubKey;
	}

	dwValLen=value_len;
	if((dwRes=RegEnumKeyExA(hKey,value_num,value,&dwValLen,NULL,NULL,NULL,NULL))!=0)
	{
		RegCloseKey(hKey);
		return -1;
	}
	RegCloseKey(hKey);

	return 0;
}

int CGlobalSettings::DeleteGlobalKey(const char *product, const char *key)
{
	HKEY hKey;
	cvs::string regkey;

	if(!product || !strcmp(product,"cvsnt"))
		regkey="Software\\CVS";
	else
		cvs::sprintf(regkey,64,"Software\\March Hare Software Ltd\\%s",product);

	if(RegOpenKeyExA(HKEY_LOCAL_MACHINE,regkey.c_str(),0,KEY_READ|KEY_WRITE,&hKey) &&
	   RegCreateKeyExA(HKEY_LOCAL_MACHINE,regkey.c_str(),0,NULL,0,KEY_READ|KEY_WRITE,NULL,&hKey,NULL))
	{
		return -1; // Couldn't open or create key
	}

	RegDeleteKeyA(hKey,key);

	RegCloseKey(hKey);

	return 0;
}

const char *CGlobalSettings::GetConfigDirectory()
{
	return GetCvsDir(cvs_config_dir,sizeof(cvs_config_dir));
}

const char *CGlobalSettings::GetLibraryDirectory()
{
	return GetCvsDir(cvs_library_dir,sizeof(cvs_library_dir));
}

bool CGlobalSettings::SetConfigDirectory(const char *directory)
{
	if(CFileAccess::type(directory)!=CFileAccess::typeDirectory)
		return false;
	strcpy(cvs_config_dir,directory);
	return true;
}

bool CGlobalSettings::SetLibraryDirectory(const char *directory)
{
	if(CFileAccess::type(directory)!=CFileAccess::typeDirectory)
		return false;
	strcpy(cvs_library_dir,directory);
	return true;
}

const char *CGlobalSettings::GetCvsCommand()
{
	if(!*cvs_command) /* Only do this once */
	{
		if(CGlobalSettings::GetGlobalValue("cvsnt","PServer","InstallPath",cvs_command,sizeof(cvs_command)) &&
			CGlobalSettings::GetUserValue("cvsnt","PServer","InstallPath",cvs_command,sizeof(cvs_command)))
		{
			if (GetModuleFileNameA(NULL, cvs_command, sizeof(cvs_command)))
			{
				char *p;

				p = strrchr(cvs_command, '\\');
				if(p)
					*p = '\0';
				else
					cvs_command[0] = '\0';
			}
		}
		GetShortPathNameA(cvs_command,cvs_command,sizeof(cvs_command));
		strcat(cvs_command,"\\cvs.exe");
	}
	return cvs_command;
}

bool CGlobalSettings::SetCvsCommand(const char *command)
{
	return false; // Not on win32
}

