/*
  Copyright (C) 2002 by Marten Svanfeldt
                        Anders Stenberg

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free
  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef __GLSHADER_AFP_H__
#define __GLSHADER_AFP_H__

#include "csplugincommon/shader/shaderplugin.h"
#include "csplugincommon/shader/shaderprogram.h"
#include "csgfx/shadervarcontext.h"
#include "ivideo/shader/shader.h"
#include "csutil/strhash.h"
#include "csutil/leakguard.h"
#include "csutil/scf_implementation.h"

#include "glshader_arb.h"

class csShaderGLAFP :
  public scfImplementationExt0<csShaderGLAFP, csShaderProgram>
{
private:
  csGLShader_ARB* shaderPlug;

  GLuint program_num;

  bool validProgram;

  void Report (int severity, const char* msg, ...);
public:
  CS_LEAKGUARD_DECLARE (csShaderGLAFP);

  csShaderGLAFP (csGLShader_ARB* shaderPlug) : 
    scfImplementationType (this, shaderPlug->object_reg)
  {
    validProgram = true;
    this->shaderPlug = shaderPlug;
  }
  virtual ~csShaderGLAFP ()
  {
  }

  bool LoadProgramStringToGL ();

  void SetValid(bool val) { validProgram = val; }

  ////////////////////////////////////////////////////////////////////
  //                      iShaderProgram
  ////////////////////////////////////////////////////////////////////

  /// Sets this program to be the one used when rendering
  virtual void Activate();

  /// Deactivate program so that it's not used in next rendering
  virtual void Deactivate();

  /// Setup states needed for proper operation of the shader
  virtual void SetupState (const csRenderMesh* mesh,
    csRenderMeshModes& modes,
    const iShaderVarStack* stacks);

  /// Reset states to original
  virtual void ResetState ();

  /// Check if valid
  virtual bool IsValid() { return validProgram;} 

  /// Loads from a document-node
  virtual bool Load(iShaderDestinationResolver*, iDocumentNode* node);

  /// Loads from raw text
  virtual bool Load (iShaderDestinationResolver*, const char*, 
    csArray<csShaderVarMapping>&)
  { return false; }

  /// Compile a program
  virtual bool Compile();
};


#endif //__GLSHADER_AFP_H__

