/*
    Copyright (C) 2005 by Christopher Nelson

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "cssysdef.h"
#include "window.h"
#include "registrar.h"

namespace aws
{
  window::window()
  {
    csString oname("win.");

    oname+=template_name+".";
    oname+=name;

    SetupAutomation(oname);
  }

  void window::SetupAutomation(const csString &object_name)
  {  
    widget::SetupAutomation(object_name);
  
    prop_bag.CreateProperty("Title", property(true, true));
  }

}
