/*
 * The Cryptonit security software suite is developped by IDEALX
 * Cryptonit Team (http://IDEALX.org/ and http://cryptonit.org).
 *
 * Copyright 2003-2006 IDEALX
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License version
 * 2 as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301, USA. 
 *
 * In addition, as two special exceptions:
 *
 * 1) IDEALX S.A.S gives permission to:
 *  * link the code of portions of his program with the OpenSSL library under
 *    certain conditions described in each source file
 *  * distribute linked combinations including the two, with respect to the
 *    OpenSSL license and with the GPL
 *
 * You must obey the GNU General Public License in all respects for all of the
 * code used other than OpenSSL. If you modify file(s) with this exception,
 * you may extend this exception to your version of the file(s), but you are
 * not obligated to do so. If you do not wish to do so, delete this exception
 * statement from your version, in all files (this very one along with all
 * source files).

 * 2) IDEALX S.A.S acknowledges that portions of his sourcecode uses (by the
 * way of headers inclusion) some work published by 'RSA Security Inc.'. Those
 * portions are "derived from the RSA Security Inc. PKCS #11Cryptographic
 * Token Interface (Cryptoki)" as described in each individual source file.
 */

#include "VerifySettingsDlg.hh"

#include <wx/dir.h>

#ifndef __WXMSW__ // en attendant
#include "pics/folder_mini.xpm"
#endif


BEGIN_EVENT_TABLE (VerifySettingsDlg, CryptonitDlg)
    EVT_BUTTON (VSD_TARGETDIR_BTN_ID, VerifySettingsDlg::onTarget)
    EVT_CHECKBOX(VSD_DELETE_CB_ID, VerifySettingsDlg::onDelete)
    EVT_CHECKBOX(VSD_LEAVE_CB_ID, VerifySettingsDlg::onLeave)
    EVT_RADIOBUTTON(VSD_VERIFY_RADIO_ID, VerifySettingsDlg::onVerifyOnly)
    EVT_RADIOBUTTON(VSD_EXTRACT_RADIO_ID, VerifySettingsDlg::onExtract)

END_EVENT_TABLE()


VerifySettingsDlg::VerifySettingsDlg(wxWindow *parent, 
				 wxWindowID id, 
				 const wxString &title)
    : CryptonitDlg(parent, id, title)
{
  
  
  verifyRadio = new wxRadioButton(this, VSD_VERIFY_RADIO_ID,_("Verify signatures"),wxDefaultPosition,wxDefaultSize, wxRB_GROUP);  
  extractRadio = new wxRadioButton(this, VSD_EXTRACT_RADIO_ID ,_("Verify signatures and extact data from signed files"),wxDefaultPosition,wxDefaultSize);
  
  verifyRadio->SetValue(TRUE);
  extractRadio->SetValue(FALSE);

  wxBoxSizer *settingSizer = new wxBoxSizer(wxVERTICAL);
  
  wxStaticBox *extractBox = new wxStaticBox(this,-1, _("Verification type"));
  wxStaticBoxSizer *extractSizer = new wxStaticBoxSizer(extractBox, wxVERTICAL);

  extractSizer->Add(verifyRadio, 1,wxEXPAND |wxCENTER |wxALL,3);
  extractSizer->Add(extractRadio, 1,wxEXPAND |wxCENTER |wxALL,3);
  




  wxStaticBox *frame = new wxStaticBox(this,-1,_("Extraction settings"));
  wxStaticBoxSizer *ssSizer = new wxStaticBoxSizer(frame,wxVERTICAL);
  
  deleteCB = new wxCheckBox(this, VSD_DELETE_CB_ID, _("Delete verified files"));
  deleteCB->SetToolTip( _("If you check this option, signed files will be deleted after verification and data extraction.") );

  leaveCB = new wxCheckBox(this, VSD_LEAVE_CB_ID, _("Leave files at the same place"));
  leaveCB->SetToolTip( _("If you check this option, data will be extracted in the same directory than signed files.") );
  

  // target dir
  wxBoxSizer *targetSizer = new wxBoxSizer(wxHORIZONTAL);
  targetDir = new wxTextCtrl(this,-1,wxGetCwd(),wxDefaultPosition , wxSize(250,20));
  wxBitmap dirIcon = wxBITMAP(folder_mini);
#ifdef __WXMSW__
  dirIcon.SetMask( new wxMask(dirIcon, wxColour(0xC0,0xC0,0xC0)) );
#endif
  dirBtn = new wxBitmapButton(this,VSD_TARGETDIR_BTN_ID,dirIcon);

  
  targetSizer->Add(targetDir, 1, wxCENTER | wxBOTTOM | wxTOP | wxRIGHT | wxALIGN_LEFT, 5);
  targetSizer->Add(dirBtn,    0, wxCENTER | wxBOTTOM | wxTOP | wxLEFT, 5);
  
  ssSizer->Add(new wxStaticText( this, -1, _("Extract files in this directory")), 0, wxALIGN_LEFT | wxTOP | wxLEFT | wxRIGHT , 5); 
  ssSizer->Add(targetSizer, 0, wxALIGN_LEFT | wxLEFT | wxRIGHT | wxBOTTOM | wxEXPAND, 5 );
  ssSizer->Add(leaveCB,     0, wxALIGN_LEFT | wxLEFT | wxRIGHT, 5 );
  ssSizer->Add(deleteCB,    0, wxALIGN_LEFT | wxALL, 5);


  settingSizer->Add(extractSizer, 0, wxEXPAND | wxCENTER | wxALL , 3);
  //settingSizer->Add(encryptionSizer, 0, wxEXPAND | wxCENTER | wxALL , 3);
  settingSizer->Add(ssSizer, 0, wxEXPAND | wxCENTER | wxALL , 3);
  
  mainSizer->Add(settingSizer, 1 ,wxEXPAND |wxCENTER |wxALL,3);

  dirBtn->Enable(FALSE);
  targetDir->Enable(FALSE);
  leaveCB->SetValue(TRUE);
  leaveCB->Enable(FALSE);
  deleteCB->Enable(FALSE);
}




void VerifySettingsDlg::onTarget(wxCommandEvent &WXUNUSED(event)){

  wxDirDialog dirChooser(this, _("Choose a target directory for signed files"),wxGetCwd(), wxDD_NEW_DIR_BUTTON);

  if(dirChooser.ShowModal() == wxID_OK) {

    if( wxDir::Exists(dirChooser.GetPath()) )
      targetDir->SetValue(dirChooser.GetPath());
    else {
      wxMessageDialog errorMsg(this, _("The specified directory does not exist."), _("Error"), wxOK | wxICON_ERROR);
      errorMsg.ShowModal();
      return;
    }
  }
}

void VerifySettingsDlg::onLeave(wxCommandEvent &WXUNUSED(event)){
    dirBtn->Enable(!leaveCB->GetValue());
    targetDir->Enable(!leaveCB->GetValue());
}

void VerifySettingsDlg::onDelete(wxCommandEvent &WXUNUSED(event)){
    if(deleteCB->GetValue()){
	verifyRadio->SetValue(FALSE);
	extractRadio->SetValue(TRUE);
    }
  
}


bool VerifySettingsDlg::getDelete(){
    return deleteCB->GetValue();
}


wxString VerifySettingsDlg::getPath(){
    return targetDir->GetValue();
}

bool VerifySettingsDlg::getLeave(){
    return leaveCB->GetValue();
}


void VerifySettingsDlg::onVerifyOnly(wxCommandEvent &WXUNUSED(event)){
    leaveCB->Disable();
    deleteCB->Disable();
    dirBtn->Disable();
    targetDir->Disable();

}


void VerifySettingsDlg::onExtract(wxCommandEvent &WXUNUSED(event)){
    leaveCB->Enable();
    deleteCB->Enable();
    dirBtn->Enable(!leaveCB->GetValue());
    targetDir->Enable(!leaveCB->GetValue());
}


bool VerifySettingsDlg::getExtract(){

    return extractRadio->GetValue();
}
