/*
 * The Cryptonit security software suite is developped by IDEALX
 * Cryptonit Team (http://IDEALX.org/ and http://cryptonit.org).
 *
 * Copyright 2003-2006 IDEALX
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License version
 * 2 as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301, USA. 
 *
 * In addition, as two special exceptions:
 *
 * 1) IDEALX S.A.S gives permission to:
 *  * link the code of portions of his program with the OpenSSL library under
 *    certain conditions described in each source file
 *  * distribute linked combinations including the two, with respect to the
 *    OpenSSL license and with the GPL
 *
 * You must obey the GNU General Public License in all respects for all of the
 * code used other than OpenSSL. If you modify file(s) with this exception,
 * you may extend this exception to your version of the file(s), but you are
 * not obligated to do so. If you do not wish to do so, delete this exception
 * statement from your version, in all files (this very one along with all
 * source files).

 * 2) IDEALX S.A.S acknowledges that portions of his sourcecode uses (by the
 * way of headers inclusion) some work published by 'RSA Security Inc.'. Those
 * portions are "derived from the RSA Security Inc. PKCS #11Cryptographic
 * Token Interface (Cryptoki)" as described in each individual source file.
 */

#include <wx/wx.h>
#include <wx/dir.h>
#include <wx/filename.h>
#include <wx/imaglist.h>
#include <wx/datetime.h>
#include <wx/utils.h>
#include <wx/app.h>
#include <wx/colour.h>
#include <wx/cmndata.h>
#include <wx/gdicmn.h>



#ifndef __WXMSW__ // en attendant
#include "pics/verify_ok.xpm"
#include "pics/verify_notok.xpm"
#include "pics/verify_warning.xpm"
#include "pics/cert.xpm"
#include "pics/verify_ok_white.xpm"
#include "pics/verify_notok_white.xpm"
#include "pics/verify_warning_white.xpm"
#include "pics/cert_white.xpm"
#endif

#include "../Certificate.hh"
#include "../Crl.hh"
#include "Common.hh"
#include "VerifyCertDlg.hh"
#include "AddCrlDlg.hh"
#include "MainWindow.hh"


//DECLARE_APP(VerifyCertDlg)

#ifdef __WXMSW__
BEGIN_EVENT_TABLE(VerifyCertDlg, wxDialog)  
  EVT_BUTTON ( VCD_PRINT, VerifyCertDlg::OnPrint )
END_EVENT_TABLE();
#endif


VerifyCertDlg::VerifyCertDlg(wxWindow *parent,
			     wxWindowID id,
			     const wxString &title,
			     User *u)
    : CryptonitDlg(parent, id, title)
{
#ifdef __WXMSW__
  wxButton *printBtn;
#endif

    user = u;
    imageList= new wxImageList(16,16, TRUE, 4);
    imageList->Add(wxBITMAP(verify_notok));
    imageList->Add(wxBITMAP(verify_ok));
    imageList->Add(wxBITMAP(verify_warning));
    imageList->Add(wxBITMAP(cert));
    
    tree = new wxTreeCtrl(this, VCD_TREE_ID, wxDefaultPosition , wxDefaultSize, wxTR_HIDE_ROOT | wxTR_TWIST_BUTTONS );
    tree->AssignImageList( imageList );

    wxStaticBox *explainBox = new wxStaticBox(this , -1 ,title ) ;
    wxStaticBoxSizer *explainSizer = new wxStaticBoxSizer( explainBox , wxVERTICAL );

    wxStaticText *explainText = new wxStaticText( this , -1 , _("Cryptonit checked certificates validity"));

    wxFlexGridSizer *explainContent = new  wxFlexGridSizer( 2 ); 
    wxBitmap notOkIcon = wxBITMAP(verify_notok);
    wxBitmap okIcon = wxBITMAP(verify_ok);
    wxBitmap warningIcon = wxBITMAP(verify_warning);
    
#ifdef __WXMSW__
    notOkIcon.SetMask( new wxMask(notOkIcon, wxColour(0xC0,0xC0,0xC0)) );  
    okIcon.SetMask( new wxMask(okIcon, wxColour(0xC0,0xC0,0xC0)) );  
    warningIcon.SetMask( new wxMask(warningIcon, wxColour(0xC0,0xC0,0xC0)) );  
#endif
    explainContent->Add( new wxStaticBitmap(this, -1, notOkIcon ) , 0 ,  wxALL, 2);
    explainContent->Add( new wxStaticText(this , -1 , _("Failure: One or more certificates are invalid.") ) , 1 ,  wxALL, 2);
    explainContent->Add( new wxStaticBitmap(this, -1, okIcon ) , 0 ,  wxALL, 2);
    explainContent->Add( new wxStaticText(this , -1 , _("Success: Certificate is valid.") ) , 1 ,  wxALL, 2);
    explainContent->Add( new wxStaticBitmap(this, -1, warningIcon ) , 0 ,  wxALL, 2);
    explainContent->Add( new wxStaticText(this , -1 , _("Warning: Some non critic errors found.") ) , 1 ,  wxALL, 2);


    notValid = new wxStaticText(this, -1, _("At least one signature is not valid!\nPlease see details below"));
    wxFont my_font = notValid->GetFont();
    my_font.SetWeight(wxBOLD);
    wxColourDatabase();
    int my_size=my_font.GetPointSize()+7;
    my_font.SetPointSize(my_size);
    notValid->SetForegroundColour(_T("RED")); 
    notValid->SetFont( my_font );
    
    wxStaticText* warningText = new wxStaticText( this , -1 , _("Warning: Never use invalid certificates! ") );
    wxFont font = warningText->GetFont();
    font.SetWeight(wxBOLD);
    warningText->SetFont( font );

    
    explainSizer->Add( explainText , 0 , wxEXPAND | wxTOP | wxLEFT | wxRIGHT, 5);
    explainSizer->Add( explainContent , 0 , wxALL , 5);
    explainSizer->Add(notValid, 0, wxCENTER, 5);
    explainSizer->Add( warningText , 0 , wxCENTER | wxALL , 1);

    explainSizer->Add(tree, 3 ,wxEXPAND | wxALL, 5);

    mainSizer->Add( explainSizer , 1 , wxEXPAND | wxALL, 5);
    
    notValid->Hide();

    // Windows print button
#ifdef __WXMSW__
    printBtn = new wxButton(this, VCD_PRINT,_("Print"));
    btnSizer->Add( printBtn , 0 , wxALIGN_CENTER  , 6);
#endif
//    mainSizer->Add(tree, 3 ,wxEXPAND | wxALL, 5);

    
}

void VerifyCertDlg::expand( wxTreeItemId id ){
    tree->Expand( id );
}

wxTreeItemId VerifyCertDlg::addItem(wxTreeItemId parent , wxString value, int index){
    return  tree->AppendItem(parent, value,index);
}


wxTreeItemId VerifyCertDlg::getRootItem() const{
    return tree->GetRootItem();
}

wxTreeItemId VerifyCertDlg::addRootItem(wxString label) const{
    return tree->AddRoot(label);
}


void VerifyCertDlg::verify(std::vector<wxString> certificatesFiles){
	
    std::vector<wxString>::iterator certificatesFilesIt;
    std::vector<Certificate> *CAlist = new std::vector<Certificate>;
		
    //vector of CAs with out dated CRL;
    std::vector<Certificate> outdatedCRLCA;


    //loading CA
    wxDir dir(wxGetCwd());
    wxArrayString filename;
    wxFileName CADir( std2wx(user->getCACertificatesDir()) );
    dir.GetAllFiles(CADir.GetFullPath(), &filename, wxEmptyString, wxDIR_FILES);
	  
#ifdef DEBUG
    std::cerr << "Filename.getCount ... :" << filename.GetCount() << std::endl;
    for(int i=0;i < (int) filename.GetCount(); i++)
      {
	wxString strd = filename.Item(i);
	std::cerr<<wx2std(strd)<<std::endl;
      }
    std::cerr << "End of vector filename dumping" << std::endl;
    
#endif
    for(int j = 0 ; j < (unsigned) filename.GetCount() ; j++)
	{
	    Certificate cert;
#ifdef DEBUG
	    std::cerr << cert.getHash() << std::endl;
#endif
	
	    if(cert.load(wx2std(filename.Item((j))).c_str())==SUCCESS){
					CAlist->push_back(cert);
#ifdef DEBUG
					std::cerr << "Looking for filename " << filename.Item(j) << std::endl;

#endif
	    }
	}
		
    addRootItem(_T(""));
    
    // iterate through the reciptient's certificates ...
#ifdef DEBUG
    std::cerr << "Begin iteration...." << std::endl;
    int i= 0;
#endif 
  

    for (certificatesFilesIt = certificatesFiles.begin(); certificatesFilesIt != certificatesFiles.end(); certificatesFilesIt++)
      {
#ifdef DEBUG
	i++;
	std::cerr << "Iterration ...." << "step > " << i << std::endl;
#endif
	Certificate c;
	if(c.load(wx2std(*certificatesFilesIt).c_str())==SUCCESS){
#ifdef DEBUG
	  std::cerr << "Going to RootPath..  " << std::endl;
#endif
	    std::vector<Certificate> *CA= c.getPathToRoot(CAlist);
	    
	    //get a vector of crl
	    //std::vector<Certificate>::iterator CAiter;
	    std::vector<Crl> *CrlVector = new std::vector<Crl>;
		  
	    std::vector<Certificate>::reverse_iterator CArit = CA->rbegin();
	    std::vector<Certificate>::iterator CAit = CA->begin();
	    

	    //will contain path from a certificate to the root CA
	    std::vector<Certificate> *CaPath = new std::vector<Certificate>;
	    
	    std::vector<Crl>::iterator CrlIterator;
	    
	    // checking root CA 
	    Certificate cert( *CAit );
	    CaPath->push_back( cert );
	    
	    std::vector<int> errorVector;
	    int chainStatus = VERIF_CERTIFICATE_IS_VALID;
	    int error = VERIF_CERTIFICATE_IS_VALID;

#ifdef DEBUG
	    std::cerr << "Check if root CA is self signed" << std::endl;
#endif
	    //check if "root" CA is self signed 
	    if( CAit->isIssued(*CAit)!= X509_V_OK){
#ifdef DEBUG		    
	      std::cerr << "isIssued / X509_V_OK >" << CAit->isIssued(*CAit) << " / " << X509_V_OK<< std::endl;
#endif	      
		chainStatus = VERIF_ROOT_NOT_SELF_SIGNED ;
		errorVector.push_back( chainStatus );
		chainStatus = VERIF_CHAIN_NOT_VALID;
#ifdef DEBUG
		std::cerr << "CA not self SIGNED "<< "chainStatus: " << chainStatus << std::endl;
#endif
	    } else {
		errorVector.push_back( chainStatus );
	    }
       
	    
	    //checking other CAs (and user certificate) in the chain
	    for(CAit++ ; CAit != CA->end() ;CAit++){
#ifdef DEBUG

	      std::cerr << "Checking other CAs.." << std::endl;
#endif 
		Certificate cert( *CAit );
		//CaPath->push_back( cert );
		if( user->authorities->getAuthority(CAit->getIssuerName().getValues(DN_DISPLAY_LONG | DN_DISPLAY_VALUE, ',')) ){
		    std::string crlBase = user->authorities->getAuthority
						(CAit->getIssuerName().getValues(DN_DISPLAY_LONG | DN_DISPLAY_VALUE, ','))
						->getAttributeFirstValue("CRL");
		    Crl *c = new Crl();;
		    if( crlBase != "") {
						wxFileName crlFilename(std2wx(crlBase));
						//crlFilename.SetExt(_("der"));
						crlFilename=wxMyPrepend(crlFilename,std2wx(user->getCRLDir()));
						c->load(wx2std(crlFilename.GetFullPath()).c_str());
		    }
		    CrlVector->push_back(*c);
		}
		
		
		if( !(( error = CAit->isValid(CrlVector, CaPath)) & VERIF_CERTIFICATE_IS_VALID ) ){
		    if( error & VERIF_CRL_NOT_FOUND || error & VERIF_CRL_IS_OUT_DATED) {//CRL_NOT_FOUND and VERIF_CRL_IS_OUT_DATED are just warnings not errors
			chainStatus |= error ;
			if( error & VERIF_CRL_IS_OUT_DATED ){
			    outdatedCRLCA.push_back( cert );	
			}
		    } else {
			chainStatus |= VERIF_CHAIN_NOT_VALID | error ;
		    }
		    errorVector.push_back( chainStatus );
		} else{
		    if( error & VERIF_CRL_IS_OUT_DATED ){
			outdatedCRLCA.push_back( cert );
		    }
			if( chainStatus & VERIF_CHAIN_NOT_VALID )
			    error |= VERIF_CHAIN_NOT_VALID;

		    errorVector.push_back( error );
		}
		CaPath->push_back( cert );
	    }
	    
	   

#ifdef DEBUG

	    std::cerr<< "Checking user certificate " << std::endl;
#endif 	    
	    // checking user certificate
	    bool ok = true;
#ifdef DEBUG
	    std::cerr << "Checking if user certificate is revoked" << std::endl;
	    int i=0;
#endif
	    for(CrlIterator = CrlVector->begin() ; CrlIterator != CrlVector->end() ; CrlIterator++){
#ifdef DEBUG
	      i++;
	      std::cerr << "Iterration step: " << i << std::endl;
#endif
		Crl* tempCrl = new Crl( *CrlIterator );
		ok |= !CArit->isRevoked( tempCrl );
		delete tempCrl;
	    }
	


	    wxTreeItemId caId;
	    std::vector<wxTreeItemId> treeItems; // use for expanding tree's items (damn wxWindows ... )
			
	    //adding messages in the tree
	    wxString certificateName ;
	    certificateName = std2wx(user->addressBook->getContactInfo
															 (CArit->getSubjectName().getValues
																(DN_DISPLAY_SHORT | DN_DISPLAY_VALUE , ','), "cn"));
	    
	    
	    //trying ti get a human readable certificate's name.
	    if(certificateName == wxEmptyString) {
					certificateName = std2wx(CArit->getSubjectName().getValues
																	 (DN_DISPLAY_SHORT | DN_DISPLAY_VALUE , ','));
			}
	    certificateName = _("Certificate of ") + certificateName;


	    
	 /*   if(ok && !(chainStatus & VERIF_CHAIN_NOT_VALID)){
		caId = addItem(getRootItem(),certificateName ,3);
		treeItems.push_back( caId );
		
		if( chainStatus & VERIF_CRL_NOT_FOUND )
		    addItem(caId, _("This certificate seems to be valid but there were warnings"),2);
		
		else 
		    addItem(caId, _("This certificate is valid"),1);
		
	    } else if (!ok){
		caId = addItem(getRootItem(), CArit->getSubjectName().getValues(DN_DISPLAY_SHORT | DN_DISPLAY_VALUE , ',').c_str(),3);
		treeItems.push_back( caId );
		addItem(caId, _("This certificate has been revoked"),0);
			
	    } else if(chainStatus & VERIF_CHAIN_NOT_VALID){
		caId = addItem(getRootItem(), CArit->getSubjectName().getValues(DN_DISPLAY_SHORT | DN_DISPLAY_VALUE , ',').c_str(),3);
		treeItems.push_back( caId );
		addItem(caId, _("The certificate chain is not valid"),0);

	    }*/
	    
		
	    caId = getRootItem();//addItem(getRootItem(),certificateName ,3);
	    treeItems.push_back( caId );
	    
	    std::vector<int>::reverse_iterator errorIt = errorVector.rbegin();	



	    for( ; CArit != CA->rend() ;CArit++){

#ifdef DEBUG
	      std::cerr << "Checking user certificate" << std::endl;
#endif
			    // checking user certificate
		bool ok = true;
		for(CrlIterator = CrlVector->begin() ; CrlIterator != CrlVector->end() ; CrlIterator++){
		    Crl* tempCrl = new Crl( *CrlIterator );
		    ok |= !CArit->isRevoked( tempCrl );
		    delete tempCrl;
		}

		

		certificateName = std2wx(user->addressBook->getContactInfo
														 (CArit->getSubjectName().getValues
															(DN_DISPLAY_SHORT | DN_DISPLAY_VALUE , ','), "cn"));
		//trying to get a human readable certificate's name.
		if(certificateName == wxEmptyString)
		    certificateName = std2wx(CArit->getSubjectName().getValues
																 (DN_DISPLAY_SHORT | DN_DISPLAY_VALUE , ','));
		certificateName = _("Certificate of ") + certificateName;
		
		if (!ok){
		    caId = addItem(getRootItem(), certificateName,3);
		    treeItems.push_back( caId );
		    addItem(caId, _("This certificate has been revoked"),0);

		} else if(*errorIt & VERIF_CHAIN_NOT_VALID){
		    caId = addItem(caId, certificateName,3);
		    treeItems.push_back( caId );
		    
		    wxTreeItemId tmpId = addItem(caId, _("The certificate chain is not valid"),0);
		    treeItems.push_back( tmpId );
		    if(*errorIt & VERIF_CRL_NO_SIGNER_FOUND){
			addItem(tmpId, _("This certificate is not valid: No signer found for this CA's CRL"),0);
		    }
		    if(*errorIt & VERIF_CERTIFICATE_IS_REVOKED){
			addItem(tmpId, _("This certificate  is not valid: Certificate Revoked"),0);
		    } 
		    
		    
		} else if((*errorIt & VERIF_CERTIFICATE_IS_VALID) && !(*errorIt & VERIF_ROOT_NOT_SELF_SIGNED) ){
		    
		    caId = addItem(caId, certificateName, 3);
		    treeItems.push_back( caId );
		    addItem(caId, _("This certificate is valid"),1);
		} 
		
		
		else if(*errorIt & VERIF_ROOT_NOT_SELF_SIGNED){
#ifdef DEBUG
		    std::cerr << "ROOT NOT SELF SIGNED " << VERIF_ROOT_NOT_SELF_SIGNED << std::endl;
		    std::cerr << "errorIt value " << *errorIt << std::endl;
#endif

		    caId = addItem(caId, certificateName, 3);
		    treeItems.push_back( caId );
		    wxTreeItemId tmpId = addItem(caId, _("This certificate is not valid"),0);
		    treeItems.push_back( tmpId );
		    addItem(tmpId, _("This root certificate is not self signed"),0);
		}

		if (*errorIt & VERIF_CERTIFICATE_EXPIRED) {
#ifdef DEBUG
		  std::cerr << "VERIF_CERTIFICATE_EXPIRED " << VERIF_CERTIFICATE_EXPIRED << std::endl;
#endif 
		  addItem(caId, _("Certificate is EXPIRED,Do you think it is safe to use it? "),2);
		}


		if( *errorIt & VERIF_CRL_IS_OUT_DATED ){
#ifdef DEBUG
		  std::cerr << "VERIF_CRL out of date ? "  << VERIF_CRL_IS_OUT_DATED << std::endl;
		  
#endif
		  addItem(caId, _("CRL is outdated, what about update it? "),2);

		    
		} else if( *errorIt & VERIF_CRL_NOT_FOUND ){
#ifdef DEBUG
		  std::cerr << "VERIF CRL NOT FOUND? " << VERIF_CRL_NOT_FOUND << std::endl;
#endif

		  addItem(caId, _("CRL Not found"),2);
		}

		errorIt++; 		    		          
	    }
			    
	    std::vector<wxTreeItemId>::iterator it;
	    for( it = treeItems.begin() ; it != treeItems.end() ; it++ ){
		tree->Expand(*it);
	    }
	    
	    CA->clear();
	    delete CA;
	}
      }// end loop

    //CRL UPDATE
    if( outdatedCRLCA.size() ){
	wxMessageDialog outdatedMsg(this, _("Some CRL are outdated.\nDo you want to update them and restart verification process? "),
				    _("Question"), wxYES_NO | wxICON_QUESTION );
	
	if(outdatedMsg.ShowModal() == wxID_YES){
	    std::vector<Certificate>::iterator crlit;
	    for( crlit = outdatedCRLCA.begin() ; crlit != outdatedCRLCA.end() ; crlit++ ){
		std::string crlURI = user->authorities->getAuthority(crlit->getSubjectName().getValues(DN_DISPLAY_LONG | DN_DISPLAY_VALUE, ','))->getAttributeFirstValue( "URI" );
		AddCrlDlg::updateCrl( std2wx(crlURI) , *crlit , user );
	    }
	    tree->DeleteChildren( tree->GetRootItem() );
	    verify( certificatesFiles );
	}
    }
    outdatedCRLCA.clear();
    
}



void VerifyCertDlg::verifySignature(int validSignature , wxString filename , std::vector<Certificate> *CA){
    //get a vector of crl
    std::vector<Certificate>::iterator CAit;
    std::vector<Crl> *CrlVector = new std::vector<Crl>;
    
    //vector of CAs with out dated CRL;
    std::vector<Certificate> outdatedCRLCA;

    std::vector<Certificate>::reverse_iterator CArit = CA->rbegin();
    CAit = CA->begin();

    //will contain path from a certificate to the root CA
    std::vector<Certificate> *CaPath = new std::vector<Certificate>;

    std::vector<Crl>::iterator CrlIterator;

    // checking root CA 
    Certificate cert( *CAit );
    CaPath->push_back( cert );

    
    std::vector<int> errorVector;
    int chainStatus = VERIF_CERTIFICATE_IS_VALID;
    int error = VERIF_CERTIFICATE_IS_VALID;

#ifdef DEBUG
    std::cerr << "check if root CA is self signed" << std::endl;
#endif
    //check if "root" CA is self signed 
    if( cert.isIssued( cert )!= X509_V_OK){
	chainStatus= VERIF_ROOT_NOT_SELF_SIGNED ;
	errorVector.push_back( chainStatus );
	chainStatus = VERIF_CHAIN_NOT_VALID;
    } else {
	errorVector.push_back( chainStatus );
    }

#ifdef DEBUG
    std::cerr << "check other certificate in the chain" << std::endl;
#endif

  //checking other CAs (and user certificate) in the chain
	    for(CAit++ ; CAit != CA->end() ;CAit++){
		Certificate cert( *CAit );
		//CaPath->push_back( cert );
		if( user->authorities->getAuthority(CAit->getIssuerName().getValues(DN_DISPLAY_LONG | DN_DISPLAY_VALUE, ',')) ){
		    std::string crlBase = user->authorities->getAuthority(
									  CAit->getIssuerName().getValues(DN_DISPLAY_LONG | DN_DISPLAY_VALUE, ','))->getAttributeFirstValue( "CRL" );
		    Crl *c = new Crl();;
		    if( crlBase != "" ){
						wxFileName crlFilename(std2wx(crlBase));
						//crlFilename.SetExt("der");
						crlFilename=wxMyPrepend(crlFilename,std2wx(user->getCRLDir()));
						c->load(wx2std(crlFilename.GetFullPath()).c_str());
		    }
		    CrlVector->push_back(*c);
		}
		
		
		if( !(( error = CAit->isValid(CrlVector, CaPath)) & VERIF_CERTIFICATE_IS_VALID ) ){
		    if( error & VERIF_CRL_NOT_FOUND || error & VERIF_CRL_IS_OUT_DATED) {//CRL_NOT_FOUND and VERIF_CRL_IS_OUT_DATED are just warnings not errors
			chainStatus |= error ;
			if( error & VERIF_CRL_IS_OUT_DATED ){
			    outdatedCRLCA.push_back( cert );	
			}
		    } else {
			chainStatus |= VERIF_CHAIN_NOT_VALID | error ;
		    }
		    errorVector.push_back( chainStatus );
		} else{
		    if( error & VERIF_CRL_IS_OUT_DATED ){
			outdatedCRLCA.push_back( cert );
		    }
			if( chainStatus & VERIF_CHAIN_NOT_VALID )
			    error |= VERIF_CHAIN_NOT_VALID;

		    errorVector.push_back( error );
		}
		CaPath->push_back( cert );
	    }	

    
    
    bool signerCertOk = true;
    for(CrlIterator = CrlVector->begin() ; CrlIterator != CrlVector->end() ; CrlIterator++){
	Crl *tempCrl = new Crl( *CrlIterator );
	signerCertOk |= !CArit->isRevoked( tempCrl );
	delete tempCrl;
    }

    wxTreeItemId caId, rootId ;

    // store each wxTreeItemId in a vector in order to expand the tree at the end.
    std::vector<wxTreeItemId> treeItems; 

    bool badsigner = false;

    wxString certificateName ;
    certificateName = std2wx(user->addressBook->getContactInfo
														 (CArit->getSubjectName().getValues
															(DN_DISPLAY_SHORT | DN_DISPLAY_VALUE , ','), "cn"));
		if(certificateName == wxEmptyString) {
				certificateName = std2wx(CArit->getSubjectName().getValues
																 (DN_DISPLAY_SHORT | DN_DISPLAY_VALUE , ','));
		}

    if((validSignature == SUCCESS) && signerCertOk && !(chainStatus & VERIF_CHAIN_NOT_VALID)){
	caId = addItem(getRootItem(),_("Signature of ") + filename + _(" is valid") ,1);
	treeItems.push_back( caId );
	rootId = caId;

    } else {
	caId = addItem(getRootItem(), _("Signature of ") + filename + _(" is not valid") ,0);
	
	notValid->Show();
	rootId = caId;

	treeItems.push_back( caId );
	if(validSignature != SUCCESS){
	    if(validSignature == PKCS7_BAD_SIGNER){
		addItem(caId,_("This file seems to have been signed by ")+ certificateName ,0);
		badsigner = true;

	    }else if (validSignature == PKCS7_SIGNATURE_VERIF_FAILED){
		addItem(caId,_("Signature checking failed") ,0);
	    }
	
	}/*else if(!signerCertOk){
	    addItem(caId,_("The signer certificate is revoked ")+ certificateName ,0);
	    
	}else if(chainStatus & VERIF_CHAIN_NOT_VALID){
	    addItem(caId,_("The certificate chain is not valid") ,0);
	}else if(chainStatus & VERIF_CRL_NOT_FOUND ){
	    addItem(caId,_("The certificate chain is not valid") ,0);
	}*/
    }
	
    
    if(!badsigner){
	//adding messages in the tree
	if(signerCertOk && !(chainStatus & VERIF_CHAIN_NOT_VALID)){
	    caId = addItem(caId,_("Signed by ") + certificateName , 3);
	    if( chainStatus & VERIF_CRL_NOT_FOUND )
		addItem(caId, _("This signature seems to be valid but there were warnings"),2);
	  /*  else 
		addItem(caId, _("This certificate is valid"),1);*/
	    treeItems.push_back( caId );
	   
	} else {
	    caId = addItem(caId, _("Signed by ") + certificateName , 3);
	    treeItems.push_back( caId );
	}
	    
	/*} else if (!signerCertOk){
	    caId = addItem(caId, _("Signed by ") + certificateName , 3);
	    addItem(caId, _("Signer certificate has been revoked"),0);
	    treeItems.push_back( caId );
	    
	}else if(chainStatus & VERIF_CHAIN_NOT_VALID){
	    caId = addItem(caId, _("Signed by ") + certificateName , 3);
	    treeItems.push_back( caId );
	    addItem(caId, _("The certificates chain is not valid"),0);
	}*/
    


	std::vector<int>::reverse_iterator errorIt = errorVector.rbegin();	
	for( ; CArit != CA->rend() ;CArit++){
	    
	    
	    bool signerCertOk = true;
	    for(CrlIterator = CrlVector->begin() ; CrlIterator != CrlVector->end() ; CrlIterator++){
		Crl *tempCrl = new Crl( *CrlIterator );
		signerCertOk |= !CArit->isRevoked( tempCrl );
		delete tempCrl;
	    }
	    

	    wxString certificateName ;
	    certificateName = std2wx(user->addressBook->getContactInfo
															 (CArit->getSubjectName().getValues
																(DN_DISPLAY_SHORT | DN_DISPLAY_VALUE , ','), "cn"));
	    
	    if(certificateName == wxEmptyString) {
					certificateName = std2wx(CArit->getSubjectName().getValues
																	 (DN_DISPLAY_SHORT | DN_DISPLAY_VALUE , ','));
			}

	    certificateName = _("Certificate of ") + certificateName;
	    caId = addItem(caId, certificateName,3);
	    treeItems.push_back( caId );

	    if (!signerCertOk){
		caId = addItem(getRootItem(), certificateName,3);
		treeItems.push_back( caId );
		addItem(caId, _("This certificate has been revoked"),0);
		    
		
	    } else if(*errorIt & VERIF_CHAIN_NOT_VALID){
		addItem(caId, _("The certificate chain is not valid"),0);
		if(*errorIt & VERIF_CRL_NO_SIGNER_FOUND){
		    addItem(caId, _("This certificate is not valid: No signer found for this CA's CRL"),0);
		}
		
	    } else if(*errorIt & VERIF_CERTIFICATE_IS_VALID){
		addItem(caId, _("This certificate is valid"),1);
	    
	    } else if(*errorIt & VERIF_CRL_NO_SIGNER_FOUND){
		addItem(caId, _("This certificate is not valid: No signer found for this CA's CRL"),0);
	    
	    } else if(*errorIt & VERIF_CERTIFICATE_IS_REVOKED){
		addItem(caId, _("This certificate  is not valid: Certificate Revoked"),0);
	    }
	    if(*errorIt & VERIF_ROOT_NOT_SELF_SIGNED){
		addItem(caId, _("This root certificate is not self signed"),0);
	    }
	    
	    if( *errorIt & VERIF_CRL_IS_OUT_DATED ){
		addItem(caId, _("CRL is outdated, what about update it? "),2);
		
	    }else  if( *errorIt & VERIF_CRL_NOT_FOUND ){
		addItem(caId, _("CRL Not found"),2);
	    }
	    errorIt++; 
	}

	//expand all items in the tree (wx sux)
	std::vector<wxTreeItemId>::iterator it;
	for( it = treeItems.begin() ; it != treeItems.end() ; it++ ){
	    tree->Expand(*it);
	}
    }

    if( outdatedCRLCA.size() ){
	wxMessageDialog outdatedMsg(this, _("Some CRL are outdated.\nDo you want to update them and restart verification process? "),
				    _("Question"), wxYES_NO | wxICON_QUESTION );
	
	if(outdatedMsg.ShowModal() == wxID_YES){
	    std::vector<Certificate>::iterator crlit;
	    for( crlit = outdatedCRLCA.begin() ; crlit != outdatedCRLCA.end() ; crlit++ ){
		std::string crlURI = user->authorities->getAuthority(crlit->getSubjectName().getValues(DN_DISPLAY_LONG | DN_DISPLAY_VALUE, ','))->getAttributeFirstValue( "URI" );
		AddCrlDlg::updateCrl( std2wx(crlURI) , *crlit , user );
	    }
	    tree->DeleteChildren( rootId );
	    tree->Delete( rootId );
	    verifySignature(validSignature , filename , CA);
	}
    }
    outdatedCRLCA.clear();
}

#ifdef __WXMSW__

// Handlers for windows print functionnality

void VerifyCertDlg::OnPrint(wxCommandEvent& event)
{
  wxPrinter printer(& g_printDialogData);
  
  if (!printer.Print(this, this, true)) {
    if (wxPrinter::GetLastError() == wxPRINTER_ERROR)
      wxMessageBox(_("There was a problem printing."), _("Printing"), wxOK);
    else
      wxMessageBox(_("You cancelled printing"),
 		   _("Printing"), wxOK);
  }
  else {
    g_printDialogData = printer.GetPrintDialogData();
  }
}

bool VerifyCertDlg::OnPrintPage(int page)
{
  wxFont	font(wxSystemSettings::GetFont(wxSYS_DEFAULT_GUI_FONT));
  wxTreeItemId	rootItemId = tree->GetRootItem();
  wxDateTime	date(time(NULL));
  wxString	dateStr(_("Date: "));
  wxString	fileStr(_("File: "));
  wxString	pathStr(_("Path: "));
  wxString	fileName;
  size_t	childrenCount;
  void		*cookie = (void *)0xDEADBEEF;
  char		buf[1024];
  long		x = 50;
  long		y = 170;
  
  // return if not enough children
  childrenCount = tree->GetChildrenCount(rootItemId, false);  
  if (page <= 0 && page > childrenCount)
    return false;

  // Get context
  wxDC *dc = GetDC();
  
  if (dc) {
    // Get printer and sreen parameters
    int ppiScreenX, ppiScreenY;
    int ppiPrinterX, ppiPrinterY;

    GetPPIScreen(&ppiScreenX, &ppiScreenY);
    GetPPIPrinter(&ppiPrinterX, &ppiPrinterY);

    // This scales the DC so that the printout roughly represents the
    // the screen scaling.
    float scale = (float)((float)ppiPrinterX/(float)ppiScreenX);

    // Now we have to check in case our real page size is reduced
    // (e.g. because we?re drawing to a print preview memory DC)
    int pageWidth, pageHeight;
    int w, h;
    dc->GetSize(&w, &h);
    GetPageSizePixels(&pageWidth, &pageHeight);

    // If printer pageWidth == current DC width, then this doesn?t
    // change. But w might be the preview bitmap width,
    // so scale down.
    float overallScale = scale * (float)(w/(float)pageWidth);
    dc->SetUserScale(overallScale, overallScale);

    // Calculate conversion factor for converting millimetres into
    // logical units.
    float logUnitsFactor = (float)(ppiPrinterX/(scale*10));
    float logUnits = (float)(50*logUnitsFactor);
    
    // Set device context
    dc->SetPen(* wxBLACK_PEN);
    dc->SetDeviceOrigin(0, 0); 
    font.SetPointSize(6);
    font.SetWeight(wxBOLD);
    font.SetUnderlined(true);
    dc->SetFont(font);
    dc->SetBackground(* wxWHITE_BRUSH);
    dc->SetTextBackground(wxColour(* wxWHITE));

    // Get the child item corresponding to the page
    wxTreeItemId childItemId = tree->GetFirstChild(rootItemId, cookie);
    for (int i = 1; i < page; i++)
      childItemId = tree->GetNextChild(rootItemId, cookie);
    
    // Write report header
    fileName = tree->GetItemText(childItemId);
    fileName.Replace(_("Signature of "), _T(""), true);
    fileName.Replace(_(" is valid"), _T(""), true);
    fileName.Replace(_(" is not valid"), _T(""), true);
    wxFileName file(fileName);
    fileStr += file.GetFullName();
    pathStr += file.GetPath(wxPATH_GET_VOLUME, wxPATH_NATIVE);
    dateStr += date.Format((const wxChar*)("%c")).c_str();
    dc->DrawText(_("CRYPTONIT SIGNING VERIFICATION REPORT"), x, 50);
    font.SetUnderlined(false);
    dc->SetFont(font);
    dc->DrawText(fileStr.c_str(), x, 90);
    dc->DrawText(pathStr.c_str(), x, 110);
    dc->DrawText(dateStr.c_str(), x, 130);
    font.SetWeight(wxNORMAL);
    dc->SetFont(font);

    // Write signature verification tree
    DrawTree(dc, childItemId, cookie, 0, &y, 0);
    return true;
  }
  else { 
    return false; 
  }
}

void VerifyCertDlg::DrawTree(wxDC *dc, wxTreeItemId rootItemId, void *rootCookie, int level, long *y, int depth) 
{
  wxTreeItemId	childItemId;
  void		*childCookie = (void*)((int)rootCookie + 1);
  long		x = 50 + (level * 20);
  int		img;
  wxChar	buf[1024];
  wxBitmap	bitmap;

  // Get text and image index of the item
  wxString text = tree->GetItemText(rootItemId);
  img = tree->GetItemImage(rootItemId);
  
  // Draw lines, image and text
  if (level) {
    if (!depth)
      dc->DrawLine((x - 12), (*y - 8), (x - 12), *y + 4);
    else
      dc->DrawLine((x - 12), (*y - 16), (x - 12), *y + 4);
    dc->DrawLine((x - 12), *y + 4, x, *y + 4);
    }
  // Arrrgh... doesn't work with images 1, 2 and 3. Forced to put gruiiik inside
  //imageList->Draw(imageIndex, *dc, x, *y, wxIMAGELIST_DRAW_NORMAL, false);
  if (img == 0)
    bitmap = wxBITMAP(verify_notok_white);
  else if (img == 1)
    bitmap = wxBITMAP(verify_ok_white);
  else if (img == 2)
    bitmap = wxBITMAP(verify_warning_white);
  else
    bitmap = wxBITMAP(cert_white);
  
  bitmap.SetMask( new wxMask(bitmap, wxColour(0xC0,0xC0,0xC0)) );  
  dc->DrawBitmap(bitmap, x, *y - 4, true);
  dc->DrawText(text.c_str(), x + 22, *y);
  *y += 20;
  
  // Call recursivly the draw function for each item child
  childItemId = tree->GetFirstChild(rootItemId, childCookie); 
  for (int i = 0; childItemId.IsOk(); i++) 
    { 
      DrawTree(dc, childItemId, childCookie, level + 1, y, i);
      childItemId = tree->GetNextChild(rootItemId, childCookie); 
    }
}

bool VerifyCertDlg::OnBeginDocument(int startPage, int endPage) { 
  
  if (!wxPrintout::OnBeginDocument(startPage, endPage))
    return false; 
  return true; 
} 

void VerifyCertDlg::GetPageInfo(int *minPage, int *maxPage, int *selPageFrom, int *selPageTo) 
{ 
  *minPage = 1; 
  *maxPage = tree->GetChildrenCount(tree->GetRootItem(), false);
  *selPageFrom = *minPage; 
  *selPageTo = *maxPage; 
} 

bool VerifyCertDlg::HasPage (int pageNum) 
{ 
  size_t pageCount;
  
  pageCount = tree->GetChildrenCount(tree->GetRootItem(), false);
  if (pageNum <= 0 && pageNum > pageCount)
    return false;
  return true;
}

#endif
