/*
 * The Cryptonit security software suite is developped by IDEALX
 * Cryptonit Team (http://IDEALX.org/ and http://cryptonit.org).
 *
 * Copyright 2003-2006 IDEALX
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License version
 * 2 as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301, USA. 
 *
 * In addition, as two special exceptions:
 *
 * 1) IDEALX S.A.S gives permission to:
 *  * link the code of portions of his program with the OpenSSL library under
 *    certain conditions described in each source file
 *  * distribute linked combinations including the two, with respect to the
 *    OpenSSL license and with the GPL
 *
 * You must obey the GNU General Public License in all respects for all of the
 * code used other than OpenSSL. If you modify file(s) with this exception,
 * you may extend this exception to your version of the file(s), but you are
 * not obligated to do so. If you do not wish to do so, delete this exception
 * statement from your version, in all files (this very one along with all
 * source files).

 * 2) IDEALX S.A.S acknowledges that portions of his sourcecode uses (by the
 * way of headers inclusion) some work published by 'RSA Security Inc.'. Those
 * portions are "derived from the RSA Security Inc. PKCS #11Cryptographic
 * Token Interface (Cryptoki)" as described in each individual source file.
 */
#include <wx/wx.h>


#ifndef __WXMSW__ // en attendant
#include "pics/password.xpm"
#endif

#include "Common.hh"
#include "KeyChoiceDlg.hh"
#include "CertificateViewer.hh"

#include "../SoftKeyStore.hh"

using namespace Cryptonit;


BEGIN_EVENT_TABLE (KeyChoiceDlg, wxDialog)
  EVT_BUTTON (KCDLG_CV_BTN , KeyChoiceDlg::onCVBtn)
  EVT_BUTTON(wxID_PROPERTIES, KeyChoiceDlg::onADVBtn)
  EVT_CHECKBOX (KCDLG_CB1_BTN, KeyChoiceDlg::fillKeyCombo)
  EVT_CHECKBOX (KCDLG_CB2_BTN, KeyChoiceDlg::fillKeyCombo)
END_EVENT_TABLE()



KeyChoiceDlg::KeyChoiceDlg( wxWindow *parent,  std::vector<KeyStore *> s,  User *u, keyType type, const wxString& title): 
    wxDialog (parent, -1, title){

    stores = s;
    user = u;
    mainSizer = new wxBoxSizer(wxVERTICAL);
 
    
    wxBitmap bitmap = wxBITMAP(password);
#ifdef __WXMSW__
    bitmap.SetMask( new wxMask(bitmap, wxColour(0xC0,0xC0,0xC0)) );
#endif
    wxStaticBitmap *icon = new wxStaticBitmap(this, -1, bitmap);

    wxBoxSizer *keySizer = new wxBoxSizer( wxHORIZONTAL );
    keyCombo = new wxComboBox(this, -1 , _T(""), wxDefaultPosition, wxSize(350,20), 0 , NULL, wxCB_READONLY);
    keySizer->Add(icon, 0 ,wxEXPAND | wxALIGN_CENTER_VERTICAL  | wxALL , 10);    
    keySizer->Add( keyCombo, 0,wxEXPAND | wxALIGN_CENTER_VERTICAL | wxCENTER |wxALL,5 );
    mainSizer->Add(keySizer, 1 , wxEXPAND |wxCENTER |wxALL, 2);

    wxString my_tmpString = _T("Advanced usage: (Use it only if you know what you are doing)");
    advancebox = new wxStaticBox (this, -1,my_tmpString);
    chkboxSizer = new wxStaticBoxSizer(advancebox,wxVERTICAL);
    boxAttrib1 = new wxCheckBox(this, KCDLG_CB1_BTN, _("Use expired certificate or certificate not yet valid"));
    chkboxSizer->Add(boxAttrib1,wxALIGN_CENTER_VERTICAL | wxCENTER |wxALL);
    
    boxAttrib2 = new wxCheckBox(this, KCDLG_CB2_BTN, _("Use certificate evenif it is not designed for signing"));
    chkboxSizer->Add(boxAttrib2,wxALIGN_CENTER_VERTICAL | wxCENTER |wxALL);
    
    mainSizer->Add(chkboxSizer, 1,wxALIGN_TOP |wxLEFT |wxALL, 0);    
    advancebox->Layout();
   
    wxBoxSizer *btnSizer = new wxBoxSizer( wxHORIZONTAL );
    wxButton *cancelBtn = new wxButton(this,wxID_CANCEL,_("Cancel"));
    btnSizer->Add(cancelBtn, 0, wxALIGN_CENTER | wxALL,	 5);  
    advanceBtn = new wxButton(this,wxID_PROPERTIES, _("Show advanced mode"));
    btnSizer->Add(advanceBtn, 0,wxALIGN_CENTER | wxALL ,5);
    cvBtn = new wxButton(this,  KCDLG_CV_BTN, _("View certificate's details"));
    btnSizer->Add(cvBtn, 0,wxALIGN_CENTER | wxALL ,5);
    okBtn = new wxButton(this,wxID_OK,_("OK"));
    okBtn->SetDefault();
    btnSizer->Add(okBtn, 0,wxALIGN_CENTER | wxALL ,5);
    mainSizer->Add(btnSizer, 0, wxALIGN_BOTTOM | wxALIGN_RIGHT |wxALL, 2);

    keyCombo->SetSelection(0);  
    Center();
    SetSize(parent->GetSize());
    SetSizerAndFit(mainSizer);
    displayAdvance=true;
    
    boxAttrib1->Hide();
    boxAttrib2->Hide();
    advancebox->Hide();
    wxCommandEvent e;
    this->fillKeyCombo(e);
}

void KeyChoiceDlg::enableButtons(const bool enable){
  keyCombo->Enable(enable);
  cvBtn->Enable(enable);
  okBtn->Enable(enable);
}

void KeyChoiceDlg::fillKeyCombo(wxCommandEvent  &WXUNUSED(event))
{

  bool useExpired=boxAttrib1->IsChecked();
  bool useKeyNotSupposedToSign=boxAttrib2->IsChecked();
  
  //begin by cleaning the Combo
  keyCombo->Clear();

 int i=0;
    for( storeIt = stores.begin() ; storeIt != stores.end() ; storeIt++ ){
	if (*storeIt){
	    listCertif =(* storeIt)->listCertificates();
	    for( certIt = listCertif.begin() ; certIt != listCertif.end() ; certIt++ ){
	       if( certIt->isForSigningAndEncrypting() || certIt->isForSigning() || useKeyNotSupposedToSign){
		 if(certIt->timeValidity() || useExpired) {
			StoreAndKey *sak = (StoreAndKey *) malloc(sizeof( StoreAndKey ));
			sak->ks = *storeIt;
			Certificate *c = new Certificate( *certIt );
			sak->c = c;
			wxString cert = std2wx(certIt->getSubjectName().getValues(DN_DISPLAY_SHORT | DN_DISPLAY_VALUE , ','));
			keyCombo->Append( cert );
			keyCombo->SetClientData( i, (void*) sak );
			i++;
		 }
	       }
	    }
	}
   }
   if ( keyCombo->GetCount() == 0 ){
     keyCombo->Append( _("No key available") );    
     enableButtons(false);
   } else {
     if( keyCombo->GetCount() == 1 ) { // if only one key available select this one
       keyCombo->SetSelection(0);  
     }
     enableButtons(true);
    }  
}

KeyChoiceDlg::~KeyChoiceDlg()
{
    // no key so no data to free (to avoid wxWindows exception warning under win32)
    if( keyCombo->IsEnabled() == FALSE){
	return;
    }
    
    for(int i = 0 ; i < keyCombo->GetCount() ; i++){
	StoreAndKey *sak = (StoreAndKey *) keyCombo->GetClientData( i );
	if( sak ){
	    delete sak->c;
	    delete sak;
	}
    }

}


Key *KeyChoiceDlg::getKeyAndCert(Certificate &c, int *r){
    if( ShowModal() == wxID_OK ){

	int i = keyCombo->GetSelection();
	//if no entry selected, auto select the first one
	if( i == -1 ) {
	    i = 0;
	}
	StoreAndKey *sak =  (StoreAndKey *) keyCombo->GetClientData( i );
	Key *k = NULL;
	
	int ret = -1 ;
	if( sak != NULL ){
	    c = Certificate( *(sak->c) );
	    while( ret == GETKEY_BAD_PASSWD || ret == -1 ){
		ret = sak->ks->getKey( c , &k );
		if(ret == GETKEY_BAD_PASSWD){
		    wxMessageDialog errorMsg(this, _("Bad password! "), _("Error"), wxOK | wxICON_ERROR);
		    errorMsg.ShowModal();
		}
	    }
	    *r = ret;
	    return k;
	}
	*r = GETKEY_INVALID;
    }
    return NULL;
}

void KeyChoiceDlg::onADVBtn(wxCommandEvent  &WXUNUSED(event)){

  if(displayAdvance){
    advancebox->Show();
    boxAttrib1->Show();
    boxAttrib2->Show();
    advanceBtn->SetLabel(_("Hide advanced mode"));
    displayAdvance=false;
  } else {
    boxAttrib1->SetValue(false);
    boxAttrib2->SetValue(false);
    boxAttrib1->Hide();
    boxAttrib2->Hide();
    advancebox->Hide();
    advanceBtn->SetLabel(_("Show advanced mode"));
    displayAdvance=true;
  }
  boxAttrib1->Layout();
  boxAttrib2->Layout();
  advancebox->Layout();
  chkboxSizer->Layout();
  
  //Awfull tweak to fit with widget's style
  //advancebox->SetMinSize(wxSize((advancebox->GetSize()).GetWidth(),(int)wxDefaultCoord));
  advancebox->SetSize((mainSizer->GetSize()).GetWidth()+10,wxDefaultCoord);
  SetSizerAndFit(mainSizer);
  wxCommandEvent e;
  this->fillKeyCombo(e);
}


void KeyChoiceDlg::onCVBtn(wxCommandEvent  &WXUNUSED(event)){
    int i = keyCombo->GetSelection();
    if( i == -1 ) {
	i = 0;
    }
    StoreAndKey *sak =  (StoreAndKey *) keyCombo->GetClientData( i );
    if( sak != NULL ){
	Certificate c = Certificate( *(sak->c) );
	CertificateViewer cv(c, user, this, -1 , _("Certificate properties"));
	cv.showModal(wxSize(435,500) , _T("Close"), false); 
    }
    

}
