/* autogenerated file */
#ifndef OCI_IMAGE_SCHEMA_H
# define OCI_IMAGE_SCHEMA_H

# include <sys/types.h>
# include <stdint.h>
# include "json_common.h"

typedef string_cells oci_image_config_labels;

typedef struct {
    char *user;

    char **exposed_ports;
    size_t exposed_ports_len;

    char **env;
    size_t env_len;

    char **entrypoint;
    size_t entrypoint_len;

    char **cmd;
    size_t cmd_len;

    char **volumes;
    size_t volumes_len;

    char *working_dir;

    oci_image_config_labels *labels;

    char *stop_signal;

}
oci_image_config;

void free_oci_image_config (oci_image_config *ptr);

oci_image_config *make_oci_image_config (yajl_val tree, struct parser_context *ctx, parser_error *err);

bool gen_oci_image_config (yajl_gen g, oci_image_config *ptr, struct parser_context *ctx, parser_error *err);

typedef struct {
    char **diff_ids;
    size_t diff_ids_len;

    char *type;

}
oci_image_rootfs;

void free_oci_image_rootfs (oci_image_rootfs *ptr);

oci_image_rootfs *make_oci_image_rootfs (yajl_val tree, struct parser_context *ctx, parser_error *err);

bool gen_oci_image_rootfs (yajl_gen g, oci_image_rootfs *ptr, struct parser_context *ctx, parser_error *err);

typedef struct {
    char *created;
    char *author;
    char *created_by;
    char *comment;
    bool empty_layer;
    unsigned int empty_layer_present : 1;
}
oci_image_history_element;

void free_oci_image_history_element (oci_image_history_element *ptr);

oci_image_history_element *make_oci_image_history_element (yajl_val tree, struct parser_context *ctx, parser_error *err);

typedef struct {
    char *created;

    char *author;

    char *architecture;

    char *os;

    oci_image_config *config;

    oci_image_rootfs *rootfs;

    oci_image_history_element **history;
    size_t history_len;

}
oci_image;

void free_oci_image (oci_image *ptr);

oci_image *make_oci_image (yajl_val tree, struct parser_context *ctx, parser_error *err);

bool gen_oci_image (yajl_gen g, oci_image *ptr, struct parser_context *ctx, parser_error *err);

oci_image *oci_image_parse_file (const char *filename, struct parser_context *ctx, parser_error *err);

oci_image *oci_image_parse_file_stream (FILE *stream, struct parser_context *ctx, parser_error *err);

oci_image *oci_image_parse_data (const char *jsondata, struct parser_context *ctx, parser_error *err);

char *oci_image_generate_json (oci_image *ptr, struct parser_context *ctx, parser_error *err);

#endif
